/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.indexer.tocmaker;

import java.util.ArrayList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.docs.intent.core.document.IntentChapter;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.IntentSection;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.core.indexer.INDEX_ENTRY_TYPE;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndex;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexEntry;
import org.eclipse.mylyn.docs.intent.core.indexer.IntentIndexerFactory;
import org.eclipse.mylyn.docs.intent.core.query.StructuredElementHelper;

public class TocMaker {
    /*
     * WARNING - void declaration
     */
    public void computeIndex(IntentIndex index, IntentDocument document) {
        void var4_10;
        ArrayList<IntentIndexEntry> toRemove = new ArrayList<IntentIndexEntry>();
        TreeIterator treeIterator = index.eAllContents();
        while (treeIterator.hasNext()) {
            IntentIndexEntry iie;
            EObject eo = (EObject)treeIterator.next();
            if (!(eo instanceof IntentIndexEntry) || (iie = (IntentIndexEntry)eo).getReferencedElement() != null && iie.getReferencedElement().eResource() != null) continue;
            toRemove.add(iie);
        }
        for (EObject eObject : toRemove) {
            EcoreUtil.remove((EObject)eObject);
        }
        Object var4_7 = null;
        if (index.getEntries().isEmpty()) {
            IntentIndexEntry intentIndexEntry = IntentIndexerFactory.eINSTANCE.createIntentIndexEntry();
            index.getEntries().add((Object)intentIndexEntry);
        } else {
            IntentIndexEntry intentIndexEntry = (IntentIndexEntry)index.getEntries().get(0);
        }
        String title = StructuredElementHelper.getTitle((IntentStructuredElement)document);
        if (title == null || title.length() < 1) {
            title = "Document";
        }
        var4_10.setName(title);
        var4_10.setReferencedElement((IntentGenericElement)document);
        var4_10.setType(INDEX_ENTRY_TYPE.INTENT_DOCUMENT);
        for (IntentChapter chapter : document.getChapters()) {
            IntentIndexEntry candidateChapterEntry = null;
            for (IntentIndexEntry candidate : var4_10.getSubEntries()) {
                String completeLevel;
                if ((IntentStructuredElement)candidate.getReferencedElement() == null || (completeLevel = ((IntentStructuredElement)candidate.getReferencedElement()).getCompleteLevel()) == null || !completeLevel.equals(chapter.getCompleteLevel())) continue;
                candidateChapterEntry = candidate;
            }
            this.computeEntryForChapter((IntentIndexEntry)var4_10, candidateChapterEntry, chapter);
        }
    }

    private IntentIndexEntry computeEntryForChapter(IntentIndexEntry documentIndexEntry, IntentIndexEntry candidateChapterEntry, IntentChapter chapter) {
        String title;
        IntentIndexEntry chapterEntry = candidateChapterEntry;
        if (candidateChapterEntry == null) {
            chapterEntry = IntentIndexerFactory.eINSTANCE.createIntentIndexEntry();
            documentIndexEntry.getSubEntries().add((Object)chapterEntry);
        }
        if ((title = StructuredElementHelper.getTitle((IntentStructuredElement)chapter)) == null || title.length() < 1) {
            title = "Untitled Chapter";
        }
        chapterEntry.setName(String.valueOf(chapter.getCompleteLevel()) + " " + title);
        chapterEntry.setReferencedElement((IntentGenericElement)chapter);
        chapterEntry.setType(INDEX_ENTRY_TYPE.INTENT_CHAPTER);
        for (IntentSection section : chapter.getSubSections()) {
            IntentIndexEntry candidateSectionEntry = null;
            for (IntentIndexEntry candidate : chapterEntry.getSubEntries()) {
                String completeLevel;
                if ((IntentStructuredElement)candidate.getReferencedElement() == null || (completeLevel = ((IntentStructuredElement)candidate.getReferencedElement()).getCompleteLevel()) == null || !completeLevel.equals(section.getCompleteLevel())) continue;
                candidateSectionEntry = candidate;
            }
            this.computeEntryForSection(chapterEntry, candidateSectionEntry, section);
        }
        return chapterEntry;
    }

    private IntentIndexEntry computeEntryForSection(IntentIndexEntry containerIndexEntry, IntentIndexEntry candidateSectionEntry, IntentSection section) {
        String title;
        IntentIndexEntry sectionEntry = candidateSectionEntry;
        if (candidateSectionEntry == null) {
            sectionEntry = IntentIndexerFactory.eINSTANCE.createIntentIndexEntry();
            containerIndexEntry.getSubEntries().add((Object)sectionEntry);
        }
        if ((title = StructuredElementHelper.getTitle((IntentStructuredElement)section)) == null || title.length() < 1) {
            title = "Untitled Section";
        }
        sectionEntry.setName(String.valueOf(section.getCompleteLevel()) + " " + title);
        sectionEntry.setReferencedElement((IntentGenericElement)section);
        sectionEntry.setType(INDEX_ENTRY_TYPE.INTENT_SECTION);
        for (IntentSection subSection : section.getSubSections()) {
            IntentIndexEntry candidateSubSectionEntry = null;
            for (IntentIndexEntry candidate : sectionEntry.getSubEntries()) {
                IntentStructuredElement referencedElement = (IntentStructuredElement)candidate.getReferencedElement();
                if (referencedElement == null || !referencedElement.getCompleteLevel().equals(subSection.getCompleteLevel())) continue;
                candidateSubSectionEntry = candidate;
            }
            this.computeEntryForSection(sectionEntry, candidateSubSectionEntry, subSection);
        }
        return sectionEntry;
    }
}

