/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.exporter.ui;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditorInput;
import org.eclipse.mylyn.docs.intent.client.ui.preferences.IntentPreferenceService;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.core.document.IntentStructuredElement;
import org.eclipse.mylyn.docs.intent.serializer.IntentSerializer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class IntentPreviewView
extends ViewPart {
    public static final String ID = "org.eclipse.mylyn.docs.intent.exporter.ui.preview";
    private static final String PREF_NOT_ACTIVATED_MESSAGE = "<h3> Intent HTML Preview is not activated.</h3><p> You can activate it through Intent Preferences (Window > Preferences > Mylyn > Intent > Appearance > Show HTML Preview Page).</p>";
    private static IntentPreviewView INSTANCE;
    private Browser browser;
    private IntentSerializer intentSerializer;
    private IntentPreviewViewPartListener previewViewListener;
    private IEditorPart lastRefreshedEditor;

    public IntentPreviewView() {
        INSTANCE = this;
    }

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.intentSerializer = new IntentSerializer();
        this.previewViewListener = new IntentPreviewViewPartListener();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)this.previewViewListener);
        this.refreshPreviewView((IWorkbenchPart)this.getActiveEditorPart(), true);
    }

    public void setFocus() {
        IntentPreviewView.refreshPreviewView();
    }

    public static void refreshPreviewView() {
        if (INSTANCE != null) {
            if (Display.getCurrent() == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        INSTANCE.refreshPreviewView((IWorkbenchPart)INSTANCE.lastRefreshedEditor, true);
                    }
                });
            } else {
                INSTANCE.refreshPreviewView((IWorkbenchPart)IntentPreviewView.INSTANCE.lastRefreshedEditor, true);
            }
        }
    }

    private void refreshPreviewView(IWorkbenchPart activeEditor, boolean setURL) {
        if (!this.browser.isDisposed() && activeEditor instanceof IEditorPart && ((IEditorPart)activeEditor).getEditorInput() instanceof IntentEditorInput) {
            if (!IntentPreferenceService.getBoolean((String)"org.eclipse.mylyn.docs.intent.client.ui.preferences.show_preview_page").booleanValue()) {
                this.browser.setText(PREF_NOT_ACTIVATED_MESSAGE);
            } else if (setURL) {
                this.browser.setUrl(this.getHTMLPreviewURL((IntentEditorInput)((IEditorPart)activeEditor).getEditorInput()));
            } else {
                this.browser.refresh();
            }
            this.lastRefreshedEditor = (IEditorPart)activeEditor;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getHTMLPreviewURL(IntentEditorInput editorInput) {
        block2: {
            htmlPreviewLocation = "file:///" + editorInput.getRepository().getRepositoryLocation() + "generated/html/";
            container = editorInput.getIntentElement();
            if (!(container instanceof IntentDocument)) ** GOTO lbl7
            htmlPreviewLocation = String.valueOf(htmlPreviewLocation) + "IntentDocumentation.html";
            break block2;
lbl-1000:
            // 1 sources

            {
                container = container.eContainer();
lbl7:
                // 2 sources

                ** while (container != null && (!(container instanceof IntentStructuredElement) || ((IntentStructuredElement)container).getTitle() == null))
            }
lbl8:
            // 1 sources

            if (container instanceof IntentStructuredElement) {
                htmlPreviewLocation = String.valueOf(htmlPreviewLocation) + ((IntentStructuredElement)container).getCompleteLevel() + "_" + this.intentSerializer.serialize((EObject)((IntentStructuredElement)container).getTitle()).replace(" ", "") + ".html";
            }
        }
        return htmlPreviewLocation;
    }

    public void dispose() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener((IPartListener)this.previewViewListener);
        INSTANCE = null;
        super.dispose();
    }

    private IEditorPart getActiveEditorPart() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
            return activePage.getActiveEditor();
        }
        return null;
    }

    public class IntentPreviewViewPartListener
    implements IPartListener {
        public void partOpened(IWorkbenchPart part) {
            IntentPreviewView.this.refreshPreviewView(part, true);
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part.equals(IntentPreviewView.this.lastRefreshedEditor)) {
                IntentPreviewView.this.lastRefreshedEditor = null;
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (part.equals(IntentPreviewView.this.lastRefreshedEditor)) {
                IntentPreviewView.this.lastRefreshedEditor = null;
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            IntentPreviewView.this.refreshPreviewView(part, true);
        }

        public void partActivated(IWorkbenchPart part) {
            IntentPreviewView.this.refreshPreviewView(part, true);
        }
    }
}

