/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.chunktypes.ArrayIndexCheckpointData;
import com.ibm.jbatch.tck.artifacts.chunktypes.ReadRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyPersistentRestartUserData;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.api.chunk.AbstractItemWriter;
import jakarta.batch.runtime.context.StepContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;

@Named(value="doSomethingSimpleTimeArrayWriter")
public class DoSomethingSimpleTimeArrayWriter
extends AbstractItemWriter {
    private static final Logger logger = Logger.getLogger(DoSomethingSimpleTimeArrayWriter.class.getName());
    private int[] writerDataArray;
    private int idx = 0;
    private int chkArraySize;
    int chunkWriteIteration = 0;
    @Inject
    @BatchProperty(name="app.arraysize")
    String appArraySizeString;
    @Inject
    @BatchProperty(name="app.sleeptime")
    String sleeptimeString;
    @Inject
    @BatchProperty(name="app.timeinterval")
    String timeintervalString;
    @Inject
    private StepContext stepCtx = null;
    int arraysize;
    long currwritetime;

    public void open(Serializable cpd) throws Exception {
        logger.fine("openWriter");
        MyPersistentRestartUserData myData = null;
        myData = (MyPersistentRestartUserData)this.stepCtx.getPersistentUserData();
        if (myData != null) {
            this.stepCtx.setPersistentUserData((Serializable)new MyPersistentRestartUserData(myData.getExecutionNumber() + 1, null));
            logger.fine("AJM: iteration = " + ((MyPersistentRestartUserData)this.stepCtx.getPersistentUserData()).getExecutionNumber());
        } else {
            this.stepCtx.setPersistentUserData((Serializable)new MyPersistentRestartUserData(1, null));
        }
        ArrayIndexCheckpointData checkpointData = (ArrayIndexCheckpointData)cpd;
        this.arraysize = Integer.parseInt(this.appArraySizeString);
        this.writerDataArray = new int[this.arraysize];
        if (checkpointData == null) {
            this.idx = 0;
            logger.fine("WRITE: chkpt data = null, so idx = " + this.idx);
        } else {
            this.idx = checkpointData.getCurrentIndex();
            logger.fine("WRITE: chkpt data was valid, so idx = " + this.idx);
            logger.fine("WRITE: chunkWriteIteration = " + this.chunkWriteIteration);
        }
        for (int i = 0; i < this.arraysize; ++i) {
            this.writerDataArray[i] = 0;
        }
    }

    public void close() throws Exception {
        for (int i = 0; i < this.arraysize; ++i) {
            logger.fine("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
    }

    public void writeItems(List<Object> myData) throws Exception {
        int i;
        logger.fine("writeMyData receives chunk size=" + myData.size());
        logger.fine("WRITE: before writing, idx = " + this.idx);
        logger.fine("WRITE: before writing, chunkWriteIteration = " + this.chunkWriteIteration);
        ++this.chunkWriteIteration;
        for (i = 0; i < myData.size(); ++i) {
            this.writerDataArray[this.idx] = ((ReadRecord)myData.get(i)).getCount();
            ++this.idx;
        }
        for (i = 0; i < this.arraysize; ++i) {
            logger.fine("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
        logger.fine("WRITE: idx = " + this.idx + " and i = " + i);
        logger.fine("WRITE: chunkWriteIteration= " + this.chunkWriteIteration);
    }

    public ArrayIndexCheckpointData checkpointInfo() throws Exception {
        ArrayIndexCheckpointData _chkptData = new ArrayIndexCheckpointData();
        _chkptData.setCurrentIndex(this.idx);
        return _chkptData;
    }

    private class MyTransient {
        int data = 0;

        MyTransient(int x) {
            this.data = x;
        }
    }
}

