/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.override.nocallbacklistener;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.override.nocallbacklistener.NoCallBackListener;
import com.sun.ts.tests.jpa.core.override.util.CallBackCounts;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final Long ID = 1L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void testNoCallBackListener() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CallBackCounts.clearCountsMap();
        NoCallBackListener entity = new NoCallBackListener();
        entity.setId(ID);
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)entity);
        TestUtil.logTrace((String)("persisted entity" + entity));
        this.getEntityManager().flush();
        this.getEntityManager().refresh((Object)entity);
        NoCallBackListener newEntity = null;
        List result = this.getEntityManager().createQuery("SELECT n FROM NoCallBackListener n").getResultList();
        if (result != null && result.size() > 0) {
            newEntity = (NoCallBackListener)result.get(0);
            if (newEntity.getId() == 1L) {
                TestUtil.logTrace((String)"Retrieved persisted entity");
            }
            this.getEntityManager().remove((Object)entity);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            try {
                pass1 = this.checkPersistCallBacks();
                TestUtil.logTrace((String)("pass1 = " + pass1));
                pass2 = this.checkRemoveCallBacks();
                TestUtil.logTrace((String)("pass2 = " + pass2));
                pass3 = this.checkLoadCallBacks();
                TestUtil.logTrace((String)("pass3 = " + pass3));
                if (!(pass1 && pass2 && pass3)) {
                    throw new EETest.Fault("Test failed while testing prePersist, postPersist, preremove and postremove methods and also the post Load method");
                }
                TestUtil.logTrace((String)"testOverrideCallBackMethods Passed");
            }
            catch (Exception e) {
                throw new EETest.Fault("Exception thrown while testing testNoCallBackListener" + e);
            }
        } else {
            throw new EETest.Fault("getResultList returned a null list");
        }
    }

    private boolean checkPersistCallBacks() throws EETest.Fault {
        boolean result = false;
        if (this.test("prePersistFromXML", 1) && this.test("postPersist", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkRemoveCallBacks() throws EETest.Fault {
        boolean result = false;
        if (this.test("preRemoveFromXML", 1) && this.test("postRemoveFromXML", 1)) {
            result = true;
        }
        return result;
    }

    private boolean checkLoadCallBacks() throws EETest.Fault {
        boolean result = false;
        if (this.test("postLoadFromXML", 1)) {
            return true;
        }
        return result;
    }

    private boolean test(String callBackName, int expectedCount) throws EETest.Fault {
        boolean pass = false;
        int count = CallBackCounts.getCount((String)callBackName);
        if (count == expectedCount) {
            TestUtil.logTrace((String)("test passed in test method" + callBackName));
            pass = true;
        } else {
            TestUtil.logTrace((String)("test not passed as the count and the expected count are not same" + callBackName));
        }
        return pass;
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM NOENTITYLISTENER_TABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

