/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.samples.jdbc.ee.testConn;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;

public class testConnClient
extends ServiceEETest
implements Serializable {
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private DataSource ds1 = null;
    private Properties props = null;
    private String pTableName = null;
    private String fTableName = null;

    public static void main(String[] args) {
        testConnClient theTests = new testConnClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.props = new Properties(p);
                this.pTableName = p.getProperty("ptable");
                this.fTableName = p.getProperty("ftable");
                TestUtil.logTrace((String)"Getting the initial context...");
                this.jc = new TSNamingContext();
                TestUtil.logTrace((String)("Initial context: " + this.jc.toString()));
                TestUtil.logTrace((String)"Looking up the JNDI DataSource names");
                this.ds1 = (DataSource)this.jc.lookup("java:comp/env/jdbc/DB1");
                TestUtil.logTrace((String)("ds1: " + this.ds1.toString()));
                this.getConnection();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testCreateTable() throws EETest.Fault {
        try {
            this.createTable(this.props, this.conn);
        }
        catch (RemoteException re) {
            TestUtil.logMsg((String)("Remote exception on createTable: " + re.getMessage()));
            throw new EETest.Fault("Call to testCreateTable Failed.", re);
        }
    }

    private void createTable(Properties testProps, Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"createTable");
        try {
            this.dropTables(conn);
            TestUtil.logTrace((String)("Deleted all rows from Tables " + this.pTableName + " and " + this.fTableName));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logTrace((String)("SQLException while deleting rows from Tables " + this.pTableName + " and " + this.fTableName + ":" + e.getMessage()));
        }
        String strTabSize = testProps.getProperty("cofSize");
        TestUtil.logTrace((String)("strTabSize: " + strTabSize));
        Integer intTabSize = new Integer(strTabSize);
        TestUtil.logTrace((String)("intTabSize: " + intTabSize.toString()));
        this.logMsg("intTabSize: " + intTabSize.toString());
        int tSize = intTabSize;
        TestUtil.logTrace((String)("tSize: " + tSize));
        String strTabTypeSize = testProps.getProperty("cofTypeSize");
        TestUtil.logTrace((String)("strTabTypeSize: " + strTabTypeSize));
        Integer intTabTypeSize = new Integer(strTabTypeSize);
        TestUtil.logTrace((String)("intTabTypeSize: " + intTabTypeSize.toString()));
        this.logMsg("intTabTypeSize: " + intTabTypeSize.toString());
        int tTypeSize = intTabTypeSize;
        TestUtil.logTrace((String)("tTypeSize: " + tTypeSize));
        try {
            TestUtil.logTrace((String)("Adding the " + this.pTableName + " table rows"));
            String updateString1 = testProps.getProperty("Dbschema_Tab2_Insert", "");
            PreparedStatement pStmt1 = conn.prepareStatement(updateString1);
            int j = 1;
            while (j <= tTypeSize) {
                String sTypeDesc = "Type-" + j;
                int newType = j++;
                pStmt1.setInt(1, newType);
                pStmt1.setString(2, sTypeDesc);
                pStmt1.executeUpdate();
            }
            TestUtil.logTrace((String)("Adding the " + this.fTableName + " table rows"));
            String updateString = testProps.getProperty("Dbschema_Tab1_Insert", "");
            PreparedStatement pStmt = conn.prepareStatement(updateString);
            for (int i = 1; i <= tSize; ++i) {
                int newKey = i;
                String newName = this.fTableName + "-" + i;
                float newPrice = (float)i + 0.0f;
                int newType = i % 5;
                if (newType == 0) {
                    newType = 5;
                }
                pStmt.setInt(1, newKey);
                pStmt.setString(2, newName);
                pStmt.setFloat(3, newPrice);
                pStmt.setInt(4, newType);
                pStmt.executeUpdate();
            }
            pStmt.close();
            pStmt1.close();
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException inserting " + this.fTableName + " or " + this.pTableName + " table"), (Throwable)e);
            TestUtil.logErr((String)e.getMessage());
            this.dropTables(conn);
            throw new RemoteException(e.getMessage());
        }
    }

    private void dropTables(Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"dropTables");
        String removeString = this.props.getProperty("Dbschema_Tab1_Delete", "");
        String removeString1 = this.props.getProperty("Dbschema_Tab2_Delete", "");
        try {
            Statement stmt = conn.createStatement();
            stmt.executeUpdate(removeString);
            stmt.close();
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoteException(e.getMessage());
        }
        finally {
            try {
                Statement stmt = conn.createStatement();
                stmt.executeUpdate(removeString1);
                stmt.close();
            }
            catch (SQLException e) {
                TestUtil.printStackTrace((Throwable)e);
                throw new RemoteException(e.getMessage());
            }
        }
    }

    private void getConnection() throws ClassNotFoundException, SQLException, Exception {
        TestUtil.logTrace((String)"Attempting to make the connection");
        this.conn = this.ds1.getConnection();
        TestUtil.logMsg((String)("Made the connection to: " + this.ds1.toString() + " via DataSource"));
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.dropTables(this.conn);
            this.logMsg("Dropped tables OK");
            this.conn.close();
            this.logMsg("Closed connection OK");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
            this.logErr(e.getMessage());
        }
    }
}

