/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.xa;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import com.sun.ts.tests.jms.commonee.Client;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSession;
import jakarta.jms.Topic;
import java.util.Properties;

public class MDBClient
extends Client {
    private Queue cmtQ;
    private Queue bmtQ;
    private Topic bmtT;
    private Topic cmtT;

    public static void main(String[] args) {
        MDBClient theTests = new MDBClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        super.setup(args, p);
        try {
            this.cmtQ = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_CMT");
            this.bmtQ = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_BMT");
            this.rcvrQueue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.bmtT = (Topic)this.context.lookup("java:comp/env/jms/MDB_DURABLE_BMT");
            this.cmtT = (Topic)this.context.lookup("java:comp/env/jms/MDB_DURABLE_CMT");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup Failed!", e);
        }
    }

    public void Test1() throws EETest.Fault {
        String TestCase = "xaTest1";
        int TestNum = 1;
        try {
            this.qSender = this.session.createSender(this.cmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, this.props);
            System.out.println("Client: sending test message");
            this.qSender.send((Message)this.msg);
            System.out.println("Client:  response  message");
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("oops! error!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void Test2() throws EETest.Fault {
        String TestCase = "xaTest2";
        int TestNum = 2;
        try {
            this.tPub = this.tSession.createPublisher(this.cmtT);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, this.props);
            this.tPub.publish((Message)this.msg);
            System.out.println("Client:  response  message");
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("oops! error!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void Test3() throws EETest.Fault {
        String TestCase = "xaTest3";
        int TestNum = 3;
        try {
            this.qSender = this.session.createSender(this.cmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, this.props);
            this.qSender.send((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test3 - getRollbackOnly returned wrong value");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void Test4() throws EETest.Fault {
        String TestCase = "xaTest4";
        int TestNum = 4;
        try {
            this.qSender = this.session.createSender(this.bmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, this.props);
            this.qSender.send((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test4 - ");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void Test5() throws EETest.Fault {
        String TestCase = "xaTest5";
        int TestNum = 5;
        try {
            this.qSender = this.session.createSender(this.bmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, this.props);
            this.qSender.send((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test5 - ");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void Test6() throws EETest.Fault {
        String TestCase = "xaTest6";
        int TestNum = 6;
        try {
            this.tPub = this.tSession.createPublisher(this.bmtT);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, this.props);
            this.tPub.publish((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test6 - ");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void Test7() throws EETest.Fault {
        String TestCase = "xaTest7";
        int TestNum = 7;
        try {
            this.tPub = this.tSession.createPublisher(this.cmtT);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, this.props);
            this.msg.setStringProperty("TestCase", TestCase);
            this.tPub.publish((Message)this.msg);
            System.out.println("Client:  response  message");
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("oops! error!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void Test8() throws EETest.Fault {
        String TestCase = "xaTest8";
        int TestNum = 8;
        try {
            this.qSender = this.session.createSender(this.bmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, this.props);
            this.qSender.send((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test8 - ");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void Test9() throws EETest.Fault {
        String TestCase = "xaTest9";
        int TestNum = 9;
        try {
            this.tPub = this.tSession.createPublisher(this.bmtT);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, this.props);
            this.tPub.publish((Message)this.msg);
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("Test9 - ");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    public void Test10() throws EETest.Fault {
        String TestCase = "xaTest10";
        int TestNum = 10;
        try {
            this.qSender = this.session.createSender(this.cmtQ);
            this.createTestMessage(TestCase, TestNum);
            JmsUtil.addPropsToMessage((Message)this.msg, this.props);
            this.qSender.send((Message)this.msg);
            System.out.println("Client:  response  message");
            if (!this.checkOnResponse(TestCase)) {
                throw new Exception("oops! error!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Test Failed!", e);
        }
    }

    @Override
    public void createTestMessage(String TestCase, int num) {
        String myMessage = "Transaction tests";
        try {
            this.msg = this.session.createTextMessage();
            this.msg.setStringProperty("user", this.jmsUser);
            this.msg.setStringProperty("password", this.jmsPassword);
            this.msg.setText(myMessage);
            this.msg.setIntProperty("TestCaseNum", num);
            this.msg.setStringProperty("COM_SUN_JMS_TESTNAME", TestCase);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"Error setting user and password in jms msg");
        }
    }

    @Override
    public boolean checkOnResponse(String prop) {
        boolean status = false;
        try {
            TestUtil.logTrace((String)"@checkOnResponse");
            status = this.recvMessageInternal(this.session, prop);
            TestUtil.logTrace((String)"Close the session");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return status;
    }

    @Override
    public boolean recvMessageInternal(QueueSession session, String prop) throws JMSException {
        boolean retcode = false;
        TestUtil.logTrace((String)"@recvMessageInternal");
        QueueReceiver rcvr = session.createReceiver(this.rcvrQueue);
        Message msgRec = null;
        for (int i = 0; i < 10; ++i) {
            TestUtil.logTrace((String)("@recvMessageInternal trying to receive the message: " + i));
            msgRec = rcvr.receive(this.timeout);
            if (msgRec != null) break;
        }
        if (msgRec != null) {
            if (msgRec.getStringProperty("TestCase").equals(prop) && msgRec.getStringProperty("Status").equals("Pass")) {
                TestUtil.logTrace((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                TestUtil.logTrace((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                TestUtil.logTrace((String)"Pass: we got the expected msg back! ");
                retcode = true;
            } else if (msgRec.getStringProperty("Status").equals("Fail")) {
                TestUtil.logTrace((String)("TestCase: " + msgRec.getStringProperty("TestCase")));
                TestUtil.logTrace((String)("Status from msg: " + msgRec.getStringProperty("Status")));
                TestUtil.logTrace((String)"Fail: Error(s) occurred! ");
            } else {
                TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
                TestUtil.logTrace((String)("TestCase:  " + msgRec.getStringProperty("TestCase")));
            }
        } else if (msgRec == null) {
            TestUtil.logTrace((String)"Fail: we didnt get the expected msg back! ");
        }
        return retcode;
    }

    private void cleanTheQueue() {
    }
}

