/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.relationship.bidirmanyxmany;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.relationship.bidirmanyxmany.BiDirMXMPerson;
import com.sun.ts.tests.jpa.core.relationship.bidirmanyxmany.BiDirMXMProject;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void biDirMXMTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin biDirMXMTest1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            BiDirMXMProject project1 = new BiDirMXMProject(1L, "JavaEE", Float.valueOf(500.0f));
            BiDirMXMProject project2 = new BiDirMXMProject(2L, "Identity", Float.valueOf(300.0f));
            BiDirMXMPerson person1 = new BiDirMXMPerson(Long.valueOf(1L), "Duke");
            BiDirMXMPerson person2 = new BiDirMXMPerson(Long.valueOf(2L), "Foo");
            this.getEntityManager().persist((Object)project1);
            this.getEntityManager().persist((Object)project2);
            this.getEntityManager().persist((Object)person1);
            this.getEntityManager().persist((Object)person2);
            Vector<BiDirMXMProject> projects = new Vector<BiDirMXMProject>();
            projects.add(project1);
            projects.add(project2);
            person1.setProjects(projects);
            Vector<BiDirMXMProject> projects2 = new Vector<BiDirMXMProject>();
            projects2.add(project2);
            person2.setProjects(projects2);
            this.getEntityManager().merge((Object)person1);
            this.getEntityManager().merge((Object)person2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            TestUtil.logTrace((String)"persisted Persons and Project");
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"persisted Persons and Project");
            boolean pass1 = false;
            boolean pass2 = false;
            BiDirMXMPerson newPerson = (BiDirMXMPerson)this.getEntityManager().find(BiDirMXMPerson.class, (Object)1L);
            if (newPerson != null) {
                Collection newProjects = newPerson.getProjects();
                for (BiDirMXMProject prj : newProjects) {
                    if (prj.getName().equals("Identity")) {
                        TestUtil.logTrace((String)"Found Searched Project Identity");
                        pass1 = true;
                        continue;
                    }
                    if (!prj.getName().equals("JavaEE")) continue;
                    TestUtil.logTrace((String)"Found Searched Project JavaEE");
                    pass2 = true;
                }
            }
            boolean pass3 = false;
            BiDirMXMPerson newPerson2 = (BiDirMXMPerson)this.getEntityManager().find(BiDirMXMPerson.class, (Object)2L);
            if (newPerson2 != null) {
                Collection newProjects2 = newPerson2.getProjects();
                for (BiDirMXMProject prj : newProjects2) {
                    if (!prj.getName().equals("Identity")) continue;
                    TestUtil.logTrace((String)"Found Searched Project for Person id=2");
                    pass3 = true;
                }
            }
            if (pass1 && pass2 && pass3) {
                TestUtil.logTrace((String)"biDirMXMTest1: Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)"Unexpected results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("biDirMXMTest1 failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPERSON_BIDIRMXMPROJECT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPERSON").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BIDIRMXMPROJECT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

