/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.criteriaapi.Root;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.schema30.Customer;
import com.sun.ts.tests.jpa.common.schema30.Customer_;
import com.sun.ts.tests.jpa.common.schema30.Department;
import com.sun.ts.tests.jpa.common.schema30.Department_;
import com.sun.ts.tests.jpa.common.schema30.Util;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CollectionJoin;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import java.util.List;
import java.util.Properties;

public class Client
extends Util {
    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"Entering Setup");
        try {
            super.setup(args, p);
            this.getEntityManager();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void joinStringTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join("work");
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void joinStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join("work", JoinType.INNER);
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinStringJoinTypeTest failed");
        }
    }

    public void joinStringIllegalArgumentExceptionTest() throws EETest.Fault {
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.join("doesnotexist");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        TestUtil.logMsg((String)"String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.join("doesnotexist", JoinType.INNER);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinStringIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void joinSingularAttributeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join(Customer_.work);
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSingularAttributeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void joinSingularAttributeJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join address = customer.join(Customer_.work, JoinType.INNER);
            Expression e = cbuilder.literal((Object)"4");
            cquery.where((Expression)address.get("id").in(e)).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSingularAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionAttributeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinCollectionAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionAttributeJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.join(Customer_.orders, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinCollectionAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionStringTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.joinCollection("orders");
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinCollectionStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinCollectionStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            CollectionJoin order = customer.joinCollection("orders", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinCollectionStringJoinTypeTest failed");
        }
    }

    public void joinCollectionIllegalArgumentExceptionTest() throws EETest.Fault {
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinCollection("doesnotexist");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        TestUtil.logMsg((String)"String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinCollection("doesnotexist", JoinType.INNER);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinCollectionIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetAttributeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSetAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetAttributeJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.join(Customer_.orders2, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSetAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetStringTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.joinSet("orders2");
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSetStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinSetStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            SetJoin order = customer.joinSet("orders2", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinSetStringJoinTypeTest failed");
        }
    }

    public void joinSetIllegalArgumentExceptionTest() throws EETest.Fault {
        Root customer;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"String Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinSet("doesnotexist");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        TestUtil.logMsg((String)"String, JoinType Test");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            customer = cquery.from(Customer.class);
            try {
                customer.joinSet("doesnotexist", JoinType.INNER);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected exception");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinSetIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListAttributeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            ListJoin order = customer.join(Customer_.orders3);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinListAttributeTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListAttributeJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            ListJoin order = customer.join(Customer_.orders3, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinListAttributeJoinTypeTest failed");
        }
    }

    public void joinListIllegalArgumentExceptionTest() throws EETest.Fault {
        Root root;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing String");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinList("doesnotexist");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing String, JoinType");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinList("doesnotexist", JoinType.INNER);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinListIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListStringTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            ListJoin order = customer.joinList("orders3");
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinListStringTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    public void joinListStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            ListJoin order = customer.joinList("orders3", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)order.get("id"), (Object)"1")).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinListStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapAttributeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.join(Department_.lastNameEmployees);
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinMapAttributeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapAttributeJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.join(Department_.lastNameEmployees, JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinMapAttributeJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapStringTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.joinMap("lastNameEmployees");
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinMapStringTest failed");
        }
    }

    @SetupMethod(name="setupDepartmentEmployeeData")
    public void joinMapStringJoinTypeTest() throws EETest.Fault {
        boolean pass = false;
        try {
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Department.class);
            Root department = cquery.from(Department.class);
            MapJoin employee = department.joinMap("lastNameEmployees", JoinType.INNER);
            cquery.where((Expression)cbuilder.equal((Expression)employee.get("id"), (Object)"1")).select((Selection)department);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 1 reference, got: " + clist.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("joinMapStringJoinTypeTest failed");
        }
    }

    public void joinMapIllegalArgumentExceptionTest() throws EETest.Fault {
        Root root;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing String");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinMap("doesnotexist");
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing String, JoinType");
        try {
            cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            cquery = cbuilder.createQuery(Customer.class);
            root = cquery.from(Customer.class);
            try {
                root.joinMap("doesnotexist", JoinType.INNER);
                TestUtil.logErr((String)"Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("joinMapIllegalArgumentExceptionTest failed");
        }
    }

    public void rootGetCorrelationParentIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            boolean isCorr = customer.isCorrelated();
            if (!isCorr) {
                TestUtil.logTrace((String)"isCorrelated() return false");
                pass1 = true;
            } else {
                TestUtil.logErr((String)("Expected isCorrelated() to return false, actual:" + isCorr));
            }
            try {
                customer.getCorrelationParent();
                TestUtil.logErr((String)"Did not throw IllegalStateException");
            }
            catch (IllegalStateException ise) {
                TestUtil.logTrace((String)"Received expected IllegalStateException");
                pass2 = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exception", (Throwable)e);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught unexpected exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("rootGetCorrelationParentIllegalStateExceptionTest failed");
        }
    }
}

