/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.ejbql.select_clause;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AddressDVC;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AliasHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Customer;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.LineItemDVC;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.ProductHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Schema;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class Client
extends EETest {
    private CustomerHome customerHome = null;
    private OrderHome orderHome = null;
    private AliasHome aliasHome = null;
    private ProductHome productHome = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            Schema.setup(p);
            this.customerHome = Schema.customerHome;
            this.orderHome = Schema.orderHome;
            this.aliasHome = Schema.aliasHome;
            this.productHome = Schema.productHome;
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void selectTest1() throws EETest.Fault {
        boolean pass = true;
        Customer c = null;
        try {
            TestUtil.logMsg((String)"Find Customer By Home Phone Number");
            c = this.customerHome.getCustomerByHomePhoneNumber("223-8888");
            if (!Util.checkEJB(c, "3")) {
                TestUtil.logErr((String)"UnSuccessfully found customer Shelly D. Mcgowan");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customer Shelly D. Mcgowan");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest1 failed");
        }
    }

    public void selectTest2() throws EETest.Fault {
        boolean pass = true;
        AddressDVC expAddressDVC = null;
        AddressDVC a = null;
        try {
            TestUtil.logMsg((String)"Find the home address for Alan E. Frechette via ejbSelect");
            expAddressDVC = Schema.addressDVC[0];
            a = this.customerHome.selectHomeAddress();
            if (!Util.checkAddressDVC(a, expAddressDVC)) {
                TestUtil.logErr((String)"UnSuccessfully found the home address for Alan E. Frechette");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found the home address for Alan E. Frechette");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest2: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest2 failed");
        }
    }

    public void selectTest3() throws EETest.Fault {
        boolean pass = true;
        Set s = null;
        try {
            TestUtil.logMsg((String)"Find home zip codes via ejbSelectHomeZipCodesByCity");
            s = this.customerHome.selectHomeZipCodesByCity("Peabody");
            String expectedZip = "88444";
            if (s.size() != 1) {
                TestUtil.logErr((String)("selectHomeZipCodesByCity returned " + s.size() + " references, expected 1 reference"));
                pass = false;
            } else if (!s.contains(expectedZip)) {
                TestUtil.logErr((String)("selectHomeZipCodesByCity returned " + s + " expected: 88444"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully removed duplicate zip codes ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest3 failed");
        }
    }

    public void selectTest4() throws EETest.Fault {
        boolean pass = true;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all home zip codes via ejbSelectAllHomeZipCodesByCity");
            c = this.customerHome.selectAllHomeZipCodesByCity("Peabody");
            String expectedZip1 = "88444";
            String expectedZip2 = "88444";
            if (c.size() != 2) {
                TestUtil.logErr((String)("selectHomeZipCodesByCity returned " + c.size() + " references, expected 2 references"));
                pass = false;
            } else {
                Iterator i = c.iterator();
                String s1 = (String)i.next();
                String s2 = (String)i.next();
                if (!expectedZip1.equals(s1) && !expectedZip2.equals(s2)) {
                    TestUtil.logErr((String)("selectAllHomeZipCodesByCity returned " + expectedZip1 + "," + expectedZip2 + "expected: 88444, 88444"));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)"Successfully returned duplicate zip codes as expected");
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest4 failed");
        }
    }

    public void selectTest5() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all orders in OrderEJB");
            o = this.orderHome.findAllOrdersWithGreaterPrice();
            expectedPKs = new String[]{"2", "5", "11", "16"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all orders with a greater total price");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all orders with a greater total price");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest5: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest5 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest5 failed");
        }
    }

    public void selectTest6() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all customers with alias: fish");
            c = this.customerHome.selectCustomersByAlias("fish");
            expectedPKs = new String[]{"1", "2"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers with alias: fish");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customers with alias: fish");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest6: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest6 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest6 failed");
        }
    }

    public void selectTest7() throws EETest.Fault {
        boolean pass = true;
        LineItemDVC[] expectedDVCs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find all line items related to the orders");
            o = this.orderHome.selectAllLineItems();
            expectedDVCs = new LineItemDVC[44];
            for (int i = 0; i < 44; ++i) {
                expectedDVCs[i] = Schema.lineItemDVC[i];
            }
            if (!Util.checkLineItemDVCs(o, expectedDVCs)) {
                TestUtil.logErr((String)"UnSuccessfully found all line items");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all line items");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest7: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest7 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest7 failed");
        }
    }

    public void selectTest8() throws EETest.Fault {
        boolean pass = true;
        AddressDVC[] expAddressDVCs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all work addresses via ejbSelect");
            expAddressDVCs = this.setExpectedWorkAddresses();
            c = this.customerHome.selectAllWorkAddresses();
            if (!Util.checkAddressDVCs(c, expAddressDVCs)) {
                TestUtil.logErr((String)"UnSuccessfully found all work addresses");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all work addresses");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest8: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest8 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest8 failed");
        }
    }

    public void selectTest9() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find customers by home phone area code: 603");
            c = this.customerHome.selectPhonesByArea("603");
            expectedPKs = new String[]{"5", "6"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers with the 603 area code");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers with the 603 area code");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest9: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest9 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest9 failed");
        }
    }

    public void selectTest10() throws EETest.Fault {
        boolean pass = true;
        Set s = null;
        try {
            TestUtil.logMsg((String)"Find Customer Addresses by Set");
            s = this.customerHome.selectCustomerAddressBySet("MA");
            String expectedAddr = "1 Network Drive";
            if (s.size() != 1) {
                TestUtil.logErr((String)("selectCustomerAddressBySet returned " + s.size() + " references, expected 1 reference"));
                pass = false;
            } else if (!s.contains(expectedAddr)) {
                TestUtil.logErr((String)("selectCustomerAddressBySet returned " + s + " expected: 1 Network Drive"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned addresses without duplicates");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest10: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest10 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest10 failed");
        }
    }

    public void selectTest11() throws EETest.Fault {
        boolean pass = true;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find addresses via ejbSelectCustomerAddressByCollection");
            c = this.customerHome.selectCustomerAddressByCollection("MA");
            String expectedAddr = "1 Network Drive";
            if (c.size() != 1) {
                TestUtil.logErr((String)("selectCustomerAddressByCollection returned " + c.size() + " references, expected 1 reference"));
                pass = false;
            } else if (!c.contains(expectedAddr)) {
                TestUtil.logErr((String)("selectCustomerAddressByCollection returned " + c + " expected: 1 Network Drive"));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned addresses without duplicates as expected");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest11: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest11 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest11 failed");
        }
    }

    public void selectTest12() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find All Customers By Work City");
            c = this.customerHome.getCustomersByWorkCity("Burlington");
            expectedPKs = new String[14];
            for (int i = 0; i < 14; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found all customers working in City: Burlington");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found all customers working in City: Burlington");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest12: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest12 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest12 failed");
        }
    }

    public void selectTest13() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find DISTINCT customers whose orders are less than $1250");
            c = this.customerHome.findCustomersByQuery30();
            expectedPKs = new String[]{"1", "3", "4", "6", "7", "8", "9", "11", "12", "13", "14"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found DISTINCT customers whose orders are less than $1250");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found DISTINCT customers with orders less than $1250");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest13: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest13 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest13 failed");
        }
    }

    public void selectTest15() throws EETest.Fault {
        boolean pass = true;
        String s1 = new String("4");
        String s2 = null;
        try {
            TestUtil.logMsg((String)"Find MINIMUM order id for Robert E. Bissett");
            s2 = this.orderHome.selectMinSingle();
            if (s2.equals(s1)) {
                TestUtil.logMsg((String)"Successfully returned expected results");
            } else {
                TestUtil.logErr((String)("selectMinSingle returned " + s2 + "expected: " + s1));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest15: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest15 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest15 failed");
        }
    }

    public void selectTest17() throws EETest.Fault {
        boolean pass = true;
        int i1 = 8;
        int i2 = 0;
        try {
            TestUtil.logMsg((String)"Find MAXIMUM number of lineItem quantities available an order may have");
            i2 = this.orderHome.selectMaxSingle();
            if (i2 != i1) {
                TestUtil.logErr((String)("selectMaxSingle returned:" + i2 + "expected: " + i1));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest17: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest17 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest17 failed");
        }
    }

    public void selectTest19() throws EETest.Fault {
        boolean pass = true;
        double d1 = 1538.49;
        double d2 = 1538.5;
        try {
            TestUtil.logMsg((String)"Find AVERAGE price of all orders");
            double d3 = this.orderHome.selectAvgSingle();
            if (d3 >= d1 && d3 < d2) {
                TestUtil.logMsg((String)("selectAvgSingle returned expected results: " + d1));
            } else {
                TestUtil.logErr((String)("selectAvgSingle returned " + d3 + "expected: " + d1));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest19: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest19 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest19 failed");
        }
    }

    public void selectTest21() throws EETest.Fault {
        boolean pass = true;
        double d1 = 9907.14;
        double d2 = 9907.15;
        try {
            TestUtil.logMsg((String)"Find SUM of all product prices");
            double d3 = this.productHome.selectSumSingle();
            if (d3 >= d1 && d3 < d2) {
                TestUtil.logMsg((String)("selectSumSingle returned expected results: " + d1));
            } else {
                TestUtil.logErr((String)("selectSumSingle returned " + d3 + "expected: " + d1));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest21: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest21 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest21 failed");
        }
    }

    public void selectTest23() throws EETest.Fault {
        boolean pass = true;
        Object expectedPKs = null;
        long l1 = 18L;
        long l2 = 0L;
        try {
            TestUtil.logMsg((String)"Find the total number of products available");
            l2 = this.productHome.selectCountSingle();
            if (l1 != l2) {
                TestUtil.logErr((String)("selectCountSingle returned " + l2 + "expected: " + l1));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest23: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest23 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest23 failed");
        }
    }

    public void selectTest25() throws EETest.Fault {
        boolean pass = true;
        Collection c1 = null;
        Collection c2 = null;
        try {
            TestUtil.logMsg((String)"Execute two queries composed differently and verify results");
            c1 = this.customerHome.selectCustomersByNotNullWorkZipCode();
            c2 = this.customerHome.findCustomersByQuery26();
            if (c2.size() != c1.size()) {
                TestUtil.logErr((String)("ERROR: Incorrect results received, Collection 1: " + c1.size() + "Collection 2: " + c2.size()));
                pass = false;
            } else {
                TestUtil.logMsg((String)"Both queries returned same cardinality");
                TestUtil.logTrace((String)("Correct results received, Collection 1: " + c1.size() + "Collection 2: " + c2.size()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest25: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest25 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest25 failed");
        }
    }

    public void selectTest26() throws EETest.Fault {
        boolean pass = true;
        AddressDVC[] expAddressDVCs = new AddressDVC[]{Schema.addressDVC[0], Schema.addressDVC[2]};
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all home addresses for customers like ette");
            c = this.customerHome.selectCustomersByQuery42();
            if (!Util.checkAddressDVCs(c, expAddressDVCs)) {
                TestUtil.logErr((String)"UnSuccessfully found expected home addresses");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found expected home addresses");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest26: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest26 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest26 failed");
        }
    }

    public void selectTest28() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Find all customers with alias: kellieann and id: 7");
            c = this.customerHome.selectCustomersByAlias("kellieann", "7");
            expectedPKs = new String[]{"3", "14"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found expected customers");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customers");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception selectTest28: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selectTest28 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selectTest28 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }

    private AddressDVC[] setExpectedHomeAddresses() {
        AddressDVC[] addressDVC = new AddressDVC[]{Schema.addressDVC[0], Schema.addressDVC[2], Schema.addressDVC[4], Schema.addressDVC[6], Schema.addressDVC[8], Schema.addressDVC[10], Schema.addressDVC[12], Schema.addressDVC[14], Schema.addressDVC[16], Schema.addressDVC[18], Schema.addressDVC[20], Schema.addressDVC[22], Schema.addressDVC[24], Schema.addressDVC[26]};
        return addressDVC;
    }

    private AddressDVC[] setExpectedWorkAddresses() {
        AddressDVC[] addressDVC = new AddressDVC[]{Schema.addressDVC[1], Schema.addressDVC[3], Schema.addressDVC[5], Schema.addressDVC[7], Schema.addressDVC[9], Schema.addressDVC[11], Schema.addressDVC[13], Schema.addressDVC[15], Schema.addressDVC[17], Schema.addressDVC[19], Schema.addressDVC[21], Schema.addressDVC[23], Schema.addressDVC[25], Schema.addressDVC[27]};
        return addressDVC;
    }
}

