/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.jpa22.query.stream;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.jpa22.query.stream.Department;
import com.sun.ts.tests.jpa.jpa22.query.stream.Employee;
import com.sun.ts.tests.jpa.jpa22.query.stream.Insurance;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.sql.Date;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;
    private final Employee[] empRef = new Employee[21];
    private final Date d1 = this.getSQLDate("2000-02-14");
    final Department[] deptRef = new Department[5];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught in Setup: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getResultStreamTest() throws EETest.Fault {
        LinkedList<Integer> expected = new LinkedList<Integer>();
        for (int i = 1; i != 22; ++i) {
            expected.add(i);
        }
        Query query = this.getEntityManager().createQuery("select e.id from Employee e");
        List ids = query.getResultList();
        this.assertTrue(ids.size() == 21, "Unexpected result count:" + ids.size());
        this.assertTrue(this.checkEntityPK(ids, expected, false), "Unexpected PKs received");
        Stream s1 = query.getResultStream();
        try {
            s1.forEach(this::checkPK);
        }
        catch (RuntimeException e) {
            throw new EETest.Fault(e.getMessage());
        }
        ObjectCounter oc = new ObjectCounter();
        s1 = query.getResultStream();
        s1.forEach(oc::increment);
        this.assertTrue(oc.getCounter() == 21, "Unexpected streamed objects found:" + oc.getCounter());
        TestUtil.logTrace((String)"Query.getResultStream() returned expected ids");
    }

    public void getTypedResultStreamTest() throws EETest.Fault {
        List<Employee> expected = Arrays.asList(this.empRef);
        TypedQuery query = this.getEntityManager().createQuery("select e from Employee e", Employee.class);
        List received = query.getResultList();
        this.assertTrue(received.size() == 21, "Unexpected result count:" + received.size());
        this.assertTrue(this.checkEntityPK(received, expected, false), "Unexpected PKs received");
        Stream s1 = query.getResultStream();
        try {
            s1.forEach(this::checkPK);
        }
        catch (RuntimeException e) {
            throw new EETest.Fault(e.getMessage());
        }
        ObjectCounter oc = new ObjectCounter();
        s1 = query.getResultStream();
        s1.forEach(oc::increment);
        this.assertTrue(oc.getCounter() == 21, "Unexpected streamed objects found:" + oc.getCounter());
        TestUtil.logTrace((String)"TypedQuery.getResultStream() returned expected ids");
    }

    private <T> void checkPK(T t) {
        if (Integer.class.isInstance(t)) {
            this.checkPK((Integer)t);
        } else if (Employee.class.isInstance(t)) {
            this.checkPK(((Employee)t).getId());
        }
    }

    private void checkPK(int pk) {
        if (pk < 1 || pk > 21) {
            throw new RuntimeException("Unexepcted pk: " + pk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        TestUtil.logTrace((String)"createTestData");
        Insurance[] insRef = new Insurance[5];
        Date d2 = this.getSQLDate("2001-06-27");
        Date d3 = this.getSQLDate("2002-07-07");
        Date d4 = this.getSQLDate("2003-03-03");
        Date d5 = this.getSQLDate("2004-04-10");
        Date d6 = this.getSQLDate("2005-02-18");
        Date d7 = this.getSQLDate("2000-09-17");
        Date d8 = this.getSQLDate("2001-11-14");
        Date d9 = this.getSQLDate("2002-10-04");
        Date d10 = this.getSQLDate("2003-01-25");
        Date d11 = this.getSQLDate();
        try {
            this.getEntityTransaction().begin();
            this.deptRef[0] = new Department(1, "Engineering");
            this.deptRef[1] = new Department(2, "Marketing");
            this.deptRef[2] = new Department(3, "Sales");
            this.deptRef[3] = new Department(4, "Accounting");
            this.deptRef[4] = new Department(5, "Training");
            TestUtil.logTrace((String)"Start to persist departments ");
            for (Department department : this.deptRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted department " + department));
            }
            insRef[0] = new Insurance(1, "Prudential");
            insRef[1] = new Insurance(2, "Cigna");
            insRef[2] = new Insurance(3, "Sentry");
            TestUtil.logTrace((String)"Start to persist insurance ");
            for (Department department : insRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted insurance " + (Insurance)department));
            }
            this.empRef[0] = new Employee(1, "Alan", "Frechette", this.d1, 35000.0f);
            this.empRef[0].setDepartment(this.deptRef[0]);
            this.empRef[0].setInsurance(insRef[0]);
            this.empRef[1] = new Employee(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[1].setDepartment(this.deptRef[1]);
            this.empRef[1].setInsurance(insRef[1]);
            this.empRef[2] = new Employee(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[2].setDepartment(this.deptRef[2]);
            this.empRef[2].setInsurance(insRef[2]);
            this.empRef[3] = new Employee(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[3].setDepartment(this.deptRef[3]);
            this.empRef[3].setInsurance(insRef[0]);
            this.empRef[4] = new Employee(5, "Stephen", "DMilla", d5, 25000.0f);
            this.empRef[4].setDepartment(this.deptRef[4]);
            this.empRef[4].setInsurance(insRef[1]);
            this.empRef[5] = new Employee(6, "Karen", "Tegan", d6, 80000.0f);
            this.empRef[5].setDepartment(this.deptRef[0]);
            this.empRef[5].setInsurance(insRef[2]);
            this.empRef[6] = new Employee(7, "Stephen", "Cruise", d7, 90000.0f);
            this.empRef[6].setDepartment(this.deptRef[1]);
            this.empRef[6].setInsurance(insRef[0]);
            this.empRef[7] = new Employee(8, "Irene", "Caruso", d8, 20000.0f);
            this.empRef[7].setDepartment(this.deptRef[2]);
            this.empRef[7].setInsurance(insRef[1]);
            this.empRef[8] = new Employee(9, "William", "Keaton", d9, 35000.0f);
            this.empRef[8].setDepartment(this.deptRef[3]);
            this.empRef[8].setInsurance(insRef[2]);
            this.empRef[9] = new Employee(10, "Kate", "Hudson", d10, 20000.0f);
            this.empRef[9].setDepartment(this.deptRef[4]);
            this.empRef[9].setInsurance(insRef[0]);
            this.empRef[10] = new Employee(11, "Jonathan", "Smith", d10, 40000.0f);
            this.empRef[10].setDepartment(this.deptRef[0]);
            this.empRef[10].setInsurance(insRef[1]);
            this.empRef[11] = new Employee(12, "Mary", "Macy", d9, 40000.0f);
            this.empRef[11].setDepartment(this.deptRef[1]);
            this.empRef[11].setInsurance(insRef[2]);
            this.empRef[12] = new Employee(13, "Cheng", "Fang", d8, 40000.0f);
            this.empRef[12].setDepartment(this.deptRef[2]);
            this.empRef[12].setInsurance(insRef[0]);
            this.empRef[13] = new Employee(14, "Julie", "OClaire", d7, 60000.0f);
            this.empRef[13].setDepartment(this.deptRef[3]);
            this.empRef[13].setInsurance(insRef[1]);
            this.empRef[14] = new Employee(15, "Steven", "Rich", d6, 60000.0f);
            this.empRef[14].setDepartment(this.deptRef[4]);
            this.empRef[14].setInsurance(insRef[2]);
            this.empRef[15] = new Employee(16, "Kellie", "Lee", d5, 60000.0f);
            this.empRef[15].setDepartment(this.deptRef[0]);
            this.empRef[15].setInsurance(insRef[0]);
            this.empRef[16] = new Employee(17, "Nicole", "Martin", d4, 60000.0f);
            this.empRef[16].setDepartment(this.deptRef[1]);
            this.empRef[16].setInsurance(insRef[1]);
            this.empRef[17] = new Employee(18, "Mark", "Francis", d3, 60000.0f);
            this.empRef[17].setDepartment(this.deptRef[2]);
            this.empRef[17].setInsurance(insRef[2]);
            this.empRef[18] = new Employee(19, "Will", "Forrest", d2, 60000.0f);
            this.empRef[18].setDepartment(this.deptRef[3]);
            this.empRef[18].setInsurance(insRef[0]);
            this.empRef[19] = new Employee(20, "Katy", "Hughes", this.d1, 60000.0f);
            this.empRef[19].setDepartment(this.deptRef[4]);
            this.empRef[19].setInsurance(insRef[1]);
            this.empRef[20] = new Employee(21, "Jane", "Smmith", d11, 60000.0f);
            this.empRef[20].setDepartment(this.deptRef[0]);
            this.empRef[20].setInsurance(insRef[2]);
            for (Department department : this.empRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted employee " + (Employee)department));
            }
            this.getEntityTransaction().commit();
            TestUtil.logTrace((String)"Created TestData");
        }
        catch (Exception re) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in createTestData while rolling back TX:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    private void assertTrue(boolean condition, String message) throws EETest.Fault {
        if (!condition) {
            throw new EETest.Fault(message);
        }
    }

    static class ObjectCounter {
        int counter = 0;

        ObjectCounter() {
        }

        void increment(Object o) {
            ++this.counter;
        }

        int getCounter() {
            return this.counter;
        }
    }
}

