/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entityManager2;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entityManager2.DoesNotExist;
import com.sun.ts.tests.jpa.core.entityManager2.Employee;
import com.sun.ts.tests.jpa.core.entityManager2.Order;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Client
extends PMClientBase {
    Employee[] empRef = new Employee[5];
    Order[] orders = new Order[5];
    Properties props = null;
    Map map = new HashMap();
    Employee emp = new Employee(1, "foo", "bar", this.getUtilDate("2000-02-14"), 35000.0f);
    String dataBaseName = null;
    static final String ORACLE = "oracle";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        this.props = p;
        try {
            super.setup(args, p);
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupOrderData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setupOrderData");
        this.props = p;
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createOrderData();
            this.map.putAll(this.getEntityManager().getProperties());
            this.map.put("foo", "bar");
            this.displayMap(this.map);
            this.dataBaseName = p.getProperty("jdbc.db");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void cleanupData() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findExceptionsTest() throws EETest.Fault {
        int pass = 0;
        TestUtil.logMsg((String)"Testing findClassObjectIllegalArgumentException");
        TestUtil.logMsg((String)"Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client.class, (Object)1);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK");
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Testing findClassObjectMapIllegalArgumentException");
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        TestUtil.logTrace((String)"Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client.class, (Object)1, myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK", myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null, myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Testing findClassObjectLockModeTypeIllegalArgumentException");
        TestUtil.logMsg((String)"Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client.class, (Object)1, LockModeType.NONE);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK", LockModeType.NONE);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null, LockModeType.NONE);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Testing findClassObjectLockModeTypeTransactionRequiredException");
        try {
            if (this.getEntityTransaction().isActive()) {
                TestUtil.logTrace((String)"A transaction is active, execute rollback");
                this.getEntityTransaction().rollback();
            } else {
                TestUtil.logTrace((String)"No transaction is active");
            }
        }
        catch (Exception fe) {
            TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
        }
        try {
            this.getEntityManager().find(Order.class, (Object)1, LockModeType.PESSIMISTIC_READ);
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing findClassObjectLockModeTypeMapIllegalArgumentException");
        TestUtil.logMsg((String)"Invalid Object test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Client.class, (Object)1, LockModeType.NONE, myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Invalid PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, (Object)"PK", LockModeType.NONE, myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Null PK test");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(Order.class, null, LockModeType.NONE, myMap);
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Testing findClassObjectLockModeTypeMapTransactionRequiredException");
        try {
            if (this.getEntityTransaction().isActive()) {
                TestUtil.logTrace((String)"A transaction is active, execute rollback");
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception fe) {
            TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
        }
        try {
            this.getEntityManager().find(Order.class, (Object)0, LockModeType.PESSIMISTIC_READ, myMap);
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected.");
            ++pass;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (pass != 14) {
            throw new EETest.Fault("findExceptionsTest failed");
        }
    }

    public void flushExceptionsTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityManager().flush();
            TestUtil.logErr((String)"TransactionRequiredException was not thrown");
        }
        catch (TransactionRequiredException e) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected.");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("flushExceptionsTest failed");
        }
    }

    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void lockTransactionRequiredExceptionTest() throws EETest.Fault {
        Order o;
        boolean pass1 = false;
        boolean pass2 = false;
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        TestUtil.logMsg((String)"Testing TransactionRequiredException for lock(Object, LockModeType)");
        try {
            o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            this.getEntityManager().lock((Object)o, LockModeType.WRITE);
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException e) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TransactionRequiredException for lock(Object, LockModeType, Map)");
        try {
            o = (Order)this.getEntityManager().find(Order.class, (Object)1);
            this.getEntityManager().lock((Object)o, LockModeType.WRITE, myMap);
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException e) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("lockTransactionRequiredExceptionTest failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback1Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().contains(PMClientBase.class);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback1Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback2Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNamedQuery("doesnotexist");
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback2Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback3Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNamedQuery("doesnotexist", PMClientBase.class);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback3Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback4Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNamedStoredProcedureQuery("doesnotexist");
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback4Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityManagerMethodsRuntimeExceptionsCauseRollback5Test() throws EETest.Fault {
        boolean pass;
        block17: {
            pass = false;
            try {
                this.getEntityTransaction().begin();
                CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
                CriteriaDelete cd = cbuilder.createCriteriaDelete(DoesNotExist.class);
                cd.from(DoesNotExist.class);
                try {
                    Query q = this.getEntityManager().createQuery(cd);
                    TestUtil.logMsg((String)"RuntimeException wasn't thrown, try executing it");
                    q.executeUpdate();
                    TestUtil.logErr((String)"RuntimeException not thrown");
                }
                catch (RuntimeException e) {
                    TestUtil.logTrace((String)"RuntimeException Caught as Expected.", (Throwable)e);
                    if (!this.getEntityTransaction().getRollbackOnly()) {
                        TestUtil.logErr((String)"Transaction was not marked for rollback");
                        break block17;
                    }
                    TestUtil.logTrace((String)"Transaction was marked for rollback");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred while creating CriteriaDelete", (Throwable)e);
            }
            finally {
                try {
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                }
                catch (Exception fe) {
                    TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback5Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityManagerMethodsRuntimeExceptionsCauseRollback6Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            CriteriaQuery cquery = cbuilder.createQuery(PMClientBase.class);
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            TestUtil.logMsg((String)"RuntimeException wasn't thrown, try executing it");
            q.executeUpdate();
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback6Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void entityManagerMethodsRuntimeExceptionsCauseRollback7Test() throws EETest.Fault {
        boolean pass;
        block17: {
            pass = false;
            try {
                this.getEntityTransaction().begin();
                CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
                CriteriaUpdate cu = cbuilder.createCriteriaUpdate(DoesNotExist.class);
                Root root = cu.from(DoesNotExist.class);
                cu.where((Expression)cbuilder.equal((Expression)root.get("id"), (Object)1));
                cu.set(root.get("firstName"), (Object)"foobar");
                try {
                    Query q = this.getEntityManager().createQuery(cu);
                    TestUtil.logMsg((String)"RuntimeException wasn't thrown, try executing it");
                    q.executeUpdate();
                    TestUtil.logErr((String)"RuntimeException not thrown");
                }
                catch (RuntimeException e) {
                    TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
                    if (!this.getEntityTransaction().getRollbackOnly()) {
                        TestUtil.logErr((String)"Transaction was not marked for rollback");
                        break block17;
                    }
                    TestUtil.logTrace((String)"Transaction was marked for rollback");
                    pass = true;
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected exception occurred while creating CriteriaUpdate", (Throwable)e);
            }
            finally {
                try {
                    if (this.getEntityTransaction().isActive()) {
                        this.getEntityTransaction().rollback();
                    }
                }
                catch (Exception fe) {
                    TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
                }
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback7Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback8Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("invalid");
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback8Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback9Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("invalid", PMClientBase.class);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback9Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback10Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("doesnotexist");
            TestUtil.logMsg((String)"RuntimeException not thrown, try executing it");
            spq.execute();
            TestUtil.logErr((String)"RuntimeException was not thrown, after trying to executing it");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback10Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback11Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("doesnotexist", new Class[]{PMClientBase.class});
            TestUtil.logMsg((String)"RuntimeException not thrown, try executing it");
            spq.execute();
            TestUtil.logErr((String)"RuntimeException was not thrown, after trying to executing it");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback11Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback12Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("doesnotexist", new String[]{"doesnotexist"});
            TestUtil.logMsg((String)"RuntimeException not thrown, try executing it");
            spq.execute();
            TestUtil.logErr((String)"RuntimeException was not thrown, after trying to executing it");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback12Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback13Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().detach(PMClientBase.class);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback13Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback14Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist");
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback14Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback15Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist", LockModeType.NONE);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback15Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback16Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist", LockModeType.NONE, this.map);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback16Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback17Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().find(PMClientBase.class, (Object)"doesnotexist", this.map);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback17Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback21Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().getLockMode(PMClientBase.class);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback21Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback23Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().getReference(PMClientBase.class, (Object)"doesnotexist");
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback23Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback24Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock(PMClientBase.class, LockModeType.NONE);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback24Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback25Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().lock(PMClientBase.class, LockModeType.NONE, this.map);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback25Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback26Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().merge(PMClientBase.class);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback26Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback27Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist(PMClientBase.class);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback27Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback28Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback28Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback29Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class, LockModeType.NONE);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback29Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback30Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class, LockModeType.NONE, this.map);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback30Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback31Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().refresh(PMClientBase.class, this.map);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback31Test failed");
        }
    }

    public void entityManagerMethodsRuntimeExceptionsCauseRollback32Test() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().remove(PMClientBase.class);
            TestUtil.logErr((String)"RuntimeException not thrown");
        }
        catch (RuntimeException e) {
            TestUtil.logTrace((String)"RuntimeException Caught as Expected.");
            if (!this.getEntityTransaction().getRollbackOnly()) {
                TestUtil.logErr((String)"Transaction was not marked for rollback");
            } else {
                TestUtil.logTrace((String)"Transaction was marked for rollback");
                pass = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("entityManagerMethodsRuntimeExceptionsCauseRollback32Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void refreshTransactionRequiredExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing refresh(Object, LockModeType)");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            o.setdescription("FOOBAR");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ);
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Testing refresh(Object, LockModeType, Map)");
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            o.setdescription("FOOBAR");
            this.getEntityManager().refresh((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("refreshTransactionRequiredExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupOrderData")
    @CleanupMethod(name="cleanupData")
    public void lockTransactionRequiredException2Test() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing lock(Object, LockModeType)");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            this.removeTestData();
            this.getEntityManager().lock((Object)o, LockModeType.PESSIMISTIC_READ);
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected.");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        TestUtil.logMsg((String)"Testing lock(Object, LockModeType, Map)");
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("some.cts.specific.property", "nothing.in.particular");
        try {
            this.getEntityTransaction().begin();
            Order o = (Order)this.getEntityManager().find(Order.class, (Object)4);
            this.getEntityTransaction().commit();
            this.removeTestData();
            this.getEntityManager().lock((Object)o, LockModeType.PESSIMISTIC_READ, myMap);
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected.");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("lockTransactionRequiredException2Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderData() {
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Creating Orders");
            this.orders[0] = new Order(1, 111, "desc1");
            this.orders[1] = new Order(2, 222, "desc2");
            this.orders[2] = new Order(3, 333, "desc3");
            this.orders[3] = new Order(4, 444, "desc4");
            this.orders[4] = new Order(5, 555, "desc5");
            for (Order o : this.orders) {
                TestUtil.logTrace((String)("Persisting order:" + o.toString()));
                this.getEntityManager().persist((Object)o);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

