/*
 * Copyright (c) 2007, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

/*
 * @(#)Client.java	1.19 03/05/16
 */

package com.sun.ts.tests.ejb.ee.deploy.entity.bmp.enventry.casesens;

import java.util.Properties;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.common.dao.DAOFactory;

public class Client extends EETest {

  private static final String beanName = "java:comp/env/ejb/CaseBean";

  private TSNamingContext ctx = null;

  private Properties props = null;

  private CaseBeanHome home = null;

  public static void main(String[] args) {
    Client theTests = new Client();
    Status s = theTests.run(args, System.out, System.err);
    s.exit();
  }

  /**
   * @class.setup_props: org.omg.CORBA.ORBClass; java.naming.factory.initial;
   *
   * @class.testArgs: -ap tssql.stmt
   *
   */
  public void setup(String[] args, Properties props) throws Fault {

    try {
      this.props = props;

      logTrace("Getting naming context...");
      ctx = new TSNamingContext();

      logMsg("[Client] Initializing DB table...");
      DAOFactory.getInstance().getCoffeeDAO().cleanup();

      logTrace("Looking up home...");
      home = (CaseBeanHome) ctx.lookup(beanName, CaseBeanHome.class);
      logMsg("[Client] Setup OK!");
    } catch (Exception e) {
      throw new Fault("Setup failed:", e);
    }
  }

  /**
   * @testName: testCaseSensitivity
   *
   * @assertion_ids: EJB:SPEC:872
   *
   * @test_Strategy: Deploy a BMP Entity bean with two String environment
   *                 entries whose name differ only by case and are assigned to
   *                 two distinct values. Check that we can lookup the two
   *                 environment entries. Check that their runtime values are
   *                 distinct and match the the ones specified in the DD.
   */
  public void testCaseSensitivity() throws Fault {
    boolean pass = true;
    CaseBean bean;

    try {
      logTrace("[Client] creating bean instance...");
      bean = home.create(props, 1, "coffee-1", 1);
      logTrace("[Client] Calling bean...");
      pass = bean.testCaseSensitivity();
      logTrace("[Client] Removing bean...");
      bean.remove();

      if (!pass) {
        throw new Fault("Env entry casesens test failed");
      }
    } catch (Exception e) {
      throw new Fault("Env entry casesens test failed: " + e, e);
    }
  }

  public void cleanup() throws Fault {
    logMsg("[Client] cleanup()");
  }
}
