/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation;

import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.ClassTransformerImpl;
import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.EntityManagerFactoryImpl;
import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.PersistenceUnitInfoImpl;
import ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.TSLogger;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.spi.ClassTransformer;
import jakarta.persistence.spi.LoadState;
import jakarta.persistence.spi.PersistenceProviderResolver;
import jakarta.persistence.spi.PersistenceProviderResolverHolder;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import jakarta.persistence.spi.ProviderUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PersistenceProvider
implements jakarta.persistence.spi.PersistenceProvider,
ProviderUtil {
    static Map<String, PersistenceUnitInfoImpl> puInfoMap;
    private static final PersistenceProvider provider;
    protected TSLogger logger;

    public PersistenceProvider() {
        this.callLogger("PersistenceProvider.ctor");
    }

    private void callLogger(String s) {
        if (this.logger == null) {
            this.logger = TSLogger.getInstance();
        }
        this.logger.log(s);
    }

    public void generateSchema(PersistenceUnitInfo info, Map map) {
        System.out.println("Called ALTERNATE_PROVIDER: PersistenceProvider.generateSchema(PersistenceUnitInfo, Map)");
        this.callLogger("Called generateSchema(PersistenceUnitInfo, Map)");
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo puInfo, Map properties) {
        ClassTransformerImpl transformer;
        System.out.println("Called ALTERNATE_PROVIDER: PersistenceProvider.createContainerEntityManagerFactory(PersistenceUnitInfo, Map)");
        PersistenceProviderResolver pr = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        List list = pr.getPersistenceProviders();
        System.out.println("LIST OF PROVIDERS:");
        System.out.println("------------------");
        for (Object o : list) {
            System.out.println("PROVIDER:" + o.getClass().getName());
        }
        System.out.println("------------------");
        String unitName = puInfo.getPersistenceUnitName();
        System.out.println("ALTERNATE_PROVIDER: createContainerEntityManagerFactory - unitName:" + unitName);
        if (unitName != null && !unitName.contains("CTS")) {
            return null;
        }
        this.displayMap(properties);
        this.callLogger("Called createContainerEntityManagerFactory(PersistenceUnitInfo, Map)");
        EntityManagerFactoryImpl emf = new EntityManagerFactoryImpl(true);
        emf.properties = properties;
        emf.transformer = transformer = new ClassTransformerImpl();
        puInfo.addTransformer((ClassTransformer)transformer);
        emf.puInfo = puInfo;
        emf.newTempClassloader = puInfo.getNewTempClassLoader();
        System.out.println("returning ALTERNATE_PROVIDER factory:" + emf.toString());
        return emf;
    }

    public EntityManagerFactory createEntityManagerFactory(String puName, Map properties) {
        System.out.println("Called ALTERNATE_PROVIDER: PersistenceProvider.createEntityManagerFactory(String, Map)");
        if (!puName.equals("ALTPROVIDERPU")) {
            System.out.println("returning null from ALTERNATE_PROVIDER: PersistenceProvider.createEntityManagerFactory(String, Map) PU Names don't match");
            return null;
        }
        if (properties != null && properties.size() > 0) {
            String pp = (String)properties.get("jakarta.persistence.provider");
            if (pp == null) {
                System.out.println("returning null from ALTERNATE_PROVIDER: PersistenceProvider.createEntityManagerFactory(String, Map) no provider specified");
                return null;
            }
            if (!pp.equals("ee.jakarta.tck.persistence.common.pluggability.altprovider.implementation.PersistenceProvider")) {
                System.out.println("returning null from ALTERNATE_PROVIDER: PersistenceProvider.createEntityManagerFactory(String, Map) different provider specified");
                return null;
            }
        }
        PersistenceProviderResolver pr = PersistenceProviderResolverHolder.getPersistenceProviderResolver();
        List list = pr.getPersistenceProviders();
        System.out.println("LIST OF PROVIDERS:");
        System.out.println("------------------");
        for (Object o : list) {
            System.out.println("PROVIDER:" + o.getClass().getName());
        }
        System.out.println("------------------");
        this.callLogger("Called createEntityManagerFactory(String, Map");
        PersistenceUnitInfoImpl puInfo = PersistenceProvider.getPersistenceUnitInfoMap().get(puName);
        Object emf = null;
        if (puInfo != null) {
            puInfo = puInfo.clone();
            puInfo.classLoader = Thread.currentThread().getContextClassLoader();
            emf = new EntityManagerFactoryImpl();
            ((EntityManagerFactoryImpl)emf).properties = properties;
            ((EntityManagerFactoryImpl)emf).puInfo = puInfo;
        }
        System.out.println("returning ALTERNATE_PROVIDER factory:" + emf.toString());
        return emf;
    }

    public EntityManagerFactory createEntityManagerFactory(PersistenceConfiguration configuration) {
        return null;
    }

    public ProviderUtil getProviderUtil() {
        this.callLogger("Called getProviderUtil()");
        return provider;
    }

    public LoadState isLoaded(Object entity) {
        this.callLogger("Called isLoaded()");
        return LoadState.UNKNOWN;
    }

    public LoadState isLoadedWithReference(Object entity, String attributeName) {
        this.callLogger("Called isLoadedWithReference()");
        return LoadState.UNKNOWN;
    }

    public LoadState isLoadedWithoutReference(Object entity, String attributeName) {
        this.callLogger("Called isLoadedWithoutReference()");
        return LoadState.UNKNOWN;
    }

    private static Map<String, PersistenceUnitInfoImpl> getPersistenceUnitInfoMap() {
        if (puInfoMap == null) {
            Hashtable<String, PersistenceUnitInfoImpl> m = new Hashtable<String, PersistenceUnitInfoImpl>();
            PersistenceUnitInfoImpl puinfo = new PersistenceUnitInfoImpl();
            puinfo.puName = "ALTPROVIDERPU";
            puinfo.persistenceProviderClassName = PersistenceProvider.class.getName();
            puinfo.managedClassNames = new ArrayList<String>();
            puinfo.managedClassNames.add("com.foo");
            puinfo.transactionType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
            puinfo.excludeUnlistedClasses = false;
            URL url = null;
            try {
                url = new URL("file:///pluggability_contracts_resource_local.jar");
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<URL> lURL = new ArrayList<URL>();
            lURL.add(url);
            puinfo.jarFileUrls = lURL;
            ArrayList<String> lMappingFileNames = new ArrayList<String>();
            lMappingFileNames.add("META-INF/myMappingFile1.xml");
            lMappingFileNames.add("META-INF/myMappingFile2.xml");
            puinfo.mappingFileNames = lMappingFileNames;
            try {
                url = new URL("pluggability_contracts_resource_local.jar");
            }
            catch (Exception exception) {
                // empty catch block
            }
            puinfo.persistenceUnitRootUrl = url;
            puinfo.persistenceXMLSchemaVersion = "3.2";
            Properties properties = new Properties();
            properties.setProperty("jakarta.persistence.provider", "foobar");
            puinfo.properties = properties;
            m.put(puinfo.puName, puinfo);
            puInfoMap = m;
        }
        return puInfoMap;
    }

    public boolean generateSchema(String persistenceUnitName, Map map) {
        return false;
    }

    private void displayMap(Map map) {
        if (map != null) {
            Set set = map.entrySet();
            for (Map.Entry me : set) {
                if (me.getValue() instanceof String) {
                    System.out.println("PersistenceProvider.displayMap() - name:" + (String)me.getKey() + ", value:" + me.getValue());
                    continue;
                }
                System.out.println("PersistenceProvider.displayMap() - name:" + (String)me.getKey() + ", value:" + me.getValue().getClass().getName());
            }
        } else {
            System.out.println("PersistenceProvider.displayMap() - Map passed in to displayMap was null");
        }
    }

    static {
        provider = new PersistenceProvider();
    }
}

