/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.Random;
import org.junit.Assert;
import org.junit.Test;

public class RandomTest {
    private static final String msg = "This test is statistical in nature and can fail. Try re-running.";

    @Test
    public void TestRand() {
        DoubleDataset ta = Random.rand((int[])new int[]{10000});
        Assert.assertEquals((String)msg, (double)0.5, (double)((Number)ta.mean(new boolean[0])).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)(0.5 / Math.sqrt(3.0)), (double)ta.stdDeviation(), (double)0.04);
    }

    @Test
    public void TestSeed() {
        Random.seed((int)103);
        DoubleDataset ta = Random.rand((int[])new int[]{100});
        Random.seed((int)103);
        DoubleDataset tb = Random.rand((int[])new int[]{100});
        int i = 0;
        while (i < 100) {
            Assert.assertEquals((double)ta.get(i), (double)tb.get(i), (double)1.0E-6);
            ++i;
        }
    }

    @Test
    public void TestRandn() {
        Random.seed((int)103);
        DoubleDataset ta = Random.randn((int[])new int[]{10000});
        Assert.assertEquals((String)msg, (double)0.0, (double)((Number)ta.mean(new boolean[0])).doubleValue(), (double)0.04);
        Assert.assertEquals((String)msg, (double)1.0, (double)ta.stdDeviation(), (double)0.04);
    }

    @Test
    public void TestRandInt() {
        Random.seed((int)107);
        IntegerDataset ta = Random.random_integers((int)13, (int)27, (int[])new int[]{10000});
        Assert.assertEquals((String)msg, (double)20.0, (double)((Number)ta.mean(new boolean[0])).doubleValue(), (double)0.07);
        Assert.assertEquals((String)msg, (double)Math.sqrt(18.666666666666668), (double)ta.stdDeviation(), (double)0.07);
        Assert.assertEquals((String)msg, (double)13.0, (double)ta.min(new boolean[0]).doubleValue(), (double)0.0);
        Assert.assertEquals((String)msg, (double)27.0, (double)ta.max(new boolean[0]).doubleValue(), (double)0.0);
        ta = Random.randint((int)2, (int)8, (int[])new int[]{10000});
        Assert.assertEquals((String)msg, (double)2.0, (double)ta.min(new boolean[0]).doubleValue(), (double)0.0);
        Assert.assertEquals((String)msg, (double)7.0, (double)ta.max(new boolean[0]).doubleValue(), (double)0.0);
    }

    @Test
    public void TestExp() {
        Random.seed((int)103);
        DoubleDataset ta = Random.exponential((double)2.3, (int[])new int[]{10000});
        Assert.assertEquals((String)msg, (double)2.3, (double)((Number)ta.mean(new boolean[0])).doubleValue(), (double)0.11499999999999999);
        Assert.assertEquals((String)msg, (double)2.3, (double)ta.stdDeviation(), (double)0.11499999999999999);
    }

    @Test
    public void TestPoi() {
        Random.seed((int)103);
        IntegerDataset ta = Random.poisson((double)2.3, (int[])new int[]{10000});
        Assert.assertEquals((String)msg, (double)2.3, (double)((Number)ta.mean(new boolean[0])).doubleValue(), (double)0.11499999999999999);
        Assert.assertEquals((String)msg, (double)Math.sqrt(2.3), (double)ta.stdDeviation(), (double)0.11499999999999999);
    }
}

