/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.ReplaceRewrite;
import org.eclipse.jdt.internal.corext.dom.StatementRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.RenameUnusedVariableFixCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.fix.UnusedCodeCleanUpCore;
import org.eclipse.jdt.internal.ui.text.correction.JavadocTagsSubProcessorCore;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class UnusedCodeFixCore
extends CompilationUnitRewriteOperationsFixCore {
    private final Map<String, String> fCleanUpOptions;

    private static void removeParamTag(ASTRewrite rewrite, SingleVariableDeclaration varDecl, TextEditGroup group) {
        TagElement tagElement;
        Javadoc javadoc;
        if (varDecl.getParent() instanceof MethodDeclaration && (javadoc = ((MethodDeclaration)varDecl.getParent()).getJavadoc()) != null && (tagElement = JavadocTagsSubProcessorCore.findParamTag(javadoc, varDecl.getName().getIdentifier())) != null) {
            rewrite.remove((ASTNode)tagElement, group);
        }
    }

    public static UnusedCodeFixCore createRemoveUnusedImportFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        ImportDeclaration node;
        if (UnusedCodeFixCore.isUnusedImport(problem) && (node = UnusedCodeFixCore.getImportDeclaration(problem, compilationUnit)) != null) {
            String label = FixMessages.UnusedCodeFix_RemoveImport_description;
            RemoveImportOperation operation = new RemoveImportOperation(node);
            Hashtable<String, String> options = new Hashtable<String, String>();
            options.put("cleanup.remove_unused_imports", "true");
            return new UnusedCodeFixCore(label, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{operation}, options);
        }
        return null;
    }

    public static boolean isUnusedImport(IProblemLocation problem) {
        int id = problem.getProblemId();
        return id == 268435844 || id == 268435842 || id == 0x10000181 || id == 268435843 || id == 268435846;
    }

    public static UnusedCodeFixCore createUnusedMemberFix(CompilationUnit compilationUnit, IProblemLocation problem, boolean removeAllAssignements) {
        IBinding binding;
        SimpleName name;
        if (UnusedCodeFixCore.isUnusedMember(problem) && (name = UnusedCodeFixCore.getUnusedName(compilationUnit, problem)) != null && (binding = name.resolveBinding()) != null) {
            if (UnusedCodeFixCore.isFormalParameterInEnhancedForStatement(name)) {
                return null;
            }
            String label = UnusedCodeFixCore.getDisplayString(name, binding, removeAllAssignements);
            RemoveUnusedMemberOperation operation = new RemoveUnusedMemberOperation(new SimpleName[]{name}, removeAllAssignements);
            return new UnusedCodeFixCore(label, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{operation}, UnusedCodeFixCore.getCleanUpOptions(binding, removeAllAssignements));
        }
        return null;
    }

    public static UnusedCodeFixCore createUnusedParameterFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        SimpleName name;
        if (UnusedCodeFixCore.isUnusedParameter(problem) && (name = UnusedCodeFixCore.getUnusedName(compilationUnit, problem)) != null) {
            IMethodBinding methodBinding;
            SingleVariableDeclaration parameter = ASTNodes.getTypedAncestor((ASTNode)name, SingleVariableDeclaration.class);
            IBinding binding = name.resolveBinding();
            MethodDeclaration method = ASTNodes.getTypedAncestor((ASTNode)parameter, MethodDeclaration.class);
            if (method != null && (methodBinding = method.resolveBinding()) != null && Modifier.isPrivate((int)methodBinding.getModifiers())) {
                MethodReferenceFinder refFinder = new MethodReferenceFinder(methodBinding);
                method.getRoot().accept((ASTVisitor)refFinder);
                if (!refFinder.hasReference()) {
                    String newName = UnusedCodeFixCore.findSafeRename(method, methodBinding, Arrays.asList(name));
                    String label = Messages.format(FixMessages.UnusedCodeFix_RemoveParameter_description, name);
                    RemoveUnusedMemberOperation removeUsagesOperation = new RemoveUnusedMemberOperation(new SimpleName[]{name}, false);
                    RemoveUnusedParameterOperation removeInvocationsOperation = new RemoveUnusedParameterOperation(parameter, newName);
                    return new UnusedCodeFixCore(label, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{removeInvocationsOperation, removeUsagesOperation}, UnusedCodeFixCore.getCleanUpOptions(binding, false));
                }
            }
        }
        return null;
    }

    public static UnusedCodeFixCore createUnusedTypeParameterFix(CompilationUnit compilationUnit, IProblemLocation problemLoc) {
        IBinding binding;
        SimpleName name;
        if (problemLoc.getProblemId() == 16777877 && (name = UnusedCodeFixCore.getUnusedName(compilationUnit, problemLoc)) != null && (binding = name.resolveBinding()) != null) {
            String label = FixMessages.UnusedCodeFix_RemoveUnusedTypeParameter_description;
            RemoveUnusedTypeParameterOperation operation = new RemoveUnusedTypeParameterOperation(name);
            return new UnusedCodeFixCore(label, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{operation}, UnusedCodeFixCore.getCleanUpOptions(binding, false));
        }
        return null;
    }

    public static boolean isUnusedMember(IProblemLocation problem) {
        int id = problem.getProblemId();
        return id == 603979894 || id == 603979910 || id == 570425421 || id == 553648135 || id == 536870973;
    }

    public static boolean isUnusedLambdaParameter(IProblemLocation problem) {
        return problem.getProblemId() == 536871193;
    }

    public static boolean isUnusedParameter(IProblemLocation problem) {
        return problem.getProblemId() == 536870974;
    }

    public static UnusedCodeFixCore createRemoveUnusedCastFix(CompilationUnit compilationUnit, IProblemLocation problem) {
        if (problem.getProblemId() != 553648309) {
            return null;
        }
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        ASTNode curr = ASTNodes.getUnparenthesedExpression(selectedNode);
        if (!(curr instanceof CastExpression)) {
            return null;
        }
        return new UnusedCodeFixCore(FixMessages.UnusedCodeFix_RemoveCast_description, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{new RemoveCastOperation((CastExpression)curr)});
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, boolean removeUnusedPrivateMethods, boolean removeUnusedPrivateConstructors, boolean removeUnusedPrivateFields, boolean removeUnusedPrivateTypes, boolean removeUnusedLocalVariables, boolean removeUnusedImports, boolean removeUnusedCast, boolean removeUnusedParameter) {
        IProblem[] problems = compilationUnit.getProblems();
        IProblemLocation[] locations = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            locations[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return UnusedCodeFixCore.createCleanUp(compilationUnit, locations, removeUnusedPrivateMethods, removeUnusedPrivateConstructors, removeUnusedPrivateFields, removeUnusedPrivateTypes, removeUnusedLocalVariables, removeUnusedImports, removeUnusedCast, removeUnusedParameter);
    }

    public static ICleanUpFix createCleanUp(CompilationUnit compilationUnit, IProblemLocation[] problems, boolean removeUnusedPrivateMethods, boolean removeUnusedPrivateConstructors, boolean removeUnusedPrivateFields, boolean removeUnusedPrivateTypes, boolean removeUnusedLocalVariables, boolean removeUnusedImports, boolean removeUnusedCast, boolean removeUnusedParameter) {
        ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation> result = new ArrayList<CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation>();
        Hashtable variableDeclarations = new Hashtable();
        LinkedHashSet<CastExpression> unnecessaryCasts = new LinkedHashSet<CastExpression>();
        HashSet<SimpleName> removedMembers = new HashSet<SimpleName>();
        HashMap<MethodDeclaration, Set> parametersToRemove = new HashMap<MethodDeclaration, Set>();
        IProblemLocation[] iProblemLocationArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode selectedNode;
            ASTNode curr;
            IBinding binding;
            SimpleName name;
            ImportDeclaration node;
            IProblemLocation iProblemLocation = iProblemLocationArray[n2];
            int id = iProblemLocation.getProblemId();
            if (removeUnusedImports && (id == 268435844 || id == 268435842 || id == 0x10000181 || id == 268435843 || id == 268435846) && (node = UnusedCodeFixCore.getImportDeclaration(iProblemLocation, compilationUnit)) != null) {
                result.add(new RemoveImportOperation(node));
            }
            if ((removeUnusedPrivateMethods && id == 603979894 || removeUnusedPrivateConstructors && id == 603979910 || removeUnusedPrivateTypes && id == 553648135) && (name = UnusedCodeFixCore.getUnusedName(compilationUnit, iProblemLocation)) != null && (binding = name.resolveBinding()) != null) {
                removedMembers.add(name);
                result.add(new RemoveUnusedMemberOperation(new SimpleName[]{name}, false));
            }
            if ((removeUnusedLocalVariables && id == 536870973 || removeUnusedPrivateFields && id == 570425421) && (name = UnusedCodeFixCore.getUnusedName(compilationUnit, iProblemLocation)) != null && !RenameUnusedVariableFixCore.canRenameToUnnamedVariable(compilationUnit, name) && (binding = name.resolveBinding()) instanceof IVariableBinding && !UnusedCodeFixCore.isFormalParameterInEnhancedForStatement(name) && (!((IVariableBinding)binding).isField() || UnusedCodeFixCore.isSideEffectFree(name, compilationUnit))) {
                VariableDeclarationFragment parent = ASTNodes.getParent((ASTNode)name, VariableDeclarationFragment.class);
                if (parent != null) {
                    ASTNode varDecl = parent.getParent();
                    if (!variableDeclarations.containsKey(varDecl)) {
                        variableDeclarations.put(varDecl, new ArrayList());
                    }
                    ((List)variableDeclarations.get(varDecl)).add(name);
                } else {
                    result.add(new RemoveUnusedMemberOperation(new SimpleName[]{name}, false));
                }
            }
            if (removeUnusedCast && id == 553648309 && (curr = ASTNodes.getUnparenthesedExpression(selectedNode = iProblemLocation.getCoveringNode(compilationUnit))) instanceof CastExpression) {
                unnecessaryCasts.add((CastExpression)curr);
            }
            if (removeUnusedParameter && id == 536870974) {
                SimpleName parameter = UnusedCodeFixCore.getUnusedName(compilationUnit, iProblemLocation);
                MethodDeclaration method = ASTNodes.getTypedAncestor((ASTNode)parameter, MethodDeclaration.class);
                parametersToRemove.computeIfAbsent(method, key -> new LinkedHashSet()).add(parameter);
            }
            ++n2;
        }
        for (List list : variableDeclarations.values()) {
            result.add(new RemoveUnusedMemberOperation(list.toArray(new SimpleName[0]), false));
        }
        if (unnecessaryCasts.size() > 0) {
            result.add(new RemoveAllCastOperation(unnecessaryCasts));
        }
        for (Map.Entry entry : parametersToRemove.entrySet()) {
            MethodDeclaration method = (MethodDeclaration)entry.getKey();
            IMethodBinding methodBinding = method.resolveBinding();
            if (methodBinding == null) continue;
            Set namesToRemove = (Set)entry.getValue();
            MethodReferenceFinder refFinder = new MethodReferenceFinder(methodBinding);
            method.getRoot().accept((ASTVisitor)refFinder);
            if (refFinder.hasReference()) continue;
            String newName = UnusedCodeFixCore.findSafeRename(method, methodBinding, namesToRemove);
            for (SimpleName parameterName : (Set)entry.getValue()) {
                SingleVariableDeclaration parameter = ASTNodes.getTypedAncestor((ASTNode)parameterName, SingleVariableDeclaration.class);
                if (!Modifier.isPrivate((int)methodBinding.getModifiers()) || removedMembers.contains(method.getName())) continue;
                result.add(new RemoveUnusedMemberOperation(new SimpleName[]{parameterName}, false));
                result.add(new RemoveUnusedParameterOperation(parameter, newName));
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return new UnusedCodeFixCore(FixMessages.UnusedCodeFix_change_name, compilationUnit, result.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[result.size()]));
    }

    private static String findSafeRename(MethodDeclaration method, IMethodBinding methodBinding, Collection<SimpleName> namesToRemove) {
        int newParameterCount = method.parameters().size() - namesToRemove.size();
        HashSet potentialConflicts = new HashSet();
        UnusedCodeFixCore.walkVisibleMethods(methodBinding.getDeclaringClass(), m -> {
            if (Modifier.isPrivate((int)m.getModifiers()) && m.getDeclaringClass() != methodBinding.getDeclaringClass()) {
                return true;
            }
            if (m.getName().startsWith(methodBinding.getName()) && m.getParameterTypes().length == newParameterCount) {
                potentialConflicts.add(m.getName());
            }
            return true;
        });
        int i = 1;
        Object newMethodName = methodBinding.getName();
        while (potentialConflicts.contains(newMethodName)) {
            newMethodName = methodBinding.getName() + i++;
        }
        return newMethodName;
    }

    private static boolean walkVisibleMethods(ITypeBinding clazz, Predicate<IMethodBinding> handler) {
        if (clazz == null) {
            return true;
        }
        if (!UnusedCodeFixCore.walkMethodsInType(clazz, handler)) {
            return false;
        }
        if (!UnusedCodeFixCore.walkVisibleMethods(clazz.getSuperclass(), handler)) {
            return false;
        }
        ITypeBinding[] iTypeBindingArray = clazz.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding itfc = iTypeBindingArray[n2];
            if (!UnusedCodeFixCore.walkVisibleMethods(itfc, handler)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean walkMethodsInType(ITypeBinding clazz, Predicate<IMethodBinding> handler) {
        IMethodBinding[] iMethodBindingArray = clazz.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (!handler.test(method)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isFormalParameterInEnhancedForStatement(SimpleName name) {
        return name.getParent() instanceof SingleVariableDeclaration && name.getParent().getLocationInParent() == EnhancedForStatement.PARAMETER_PROPERTY;
    }

    public static boolean isSideEffectFree(SimpleName simpleName, CompilationUnit completeRoot) {
        SimpleName[] references;
        SimpleName nameNode = (SimpleName)NodeFinder.perform((ASTNode)completeRoot, (int)simpleName.getStartPosition(), (int)simpleName.getLength());
        SimpleName[] simpleNameArray = references = LinkedNodeFinder.findByBinding((ASTNode)completeRoot, nameNode.resolveBinding());
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleName reference = simpleNameArray[n2];
            if (UnusedCodeFixCore.hasSideEffect(reference)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean hasSideEffect(SimpleName reference) {
        ASTNode parent = reference.getParent();
        while (parent instanceof QualifiedName) {
            parent = parent.getParent();
        }
        if (parent instanceof FieldAccess) {
            parent = parent.getParent();
        }
        ASTNode node = null;
        int nameParentType = parent.getNodeType();
        switch (nameParentType) {
            case 7: {
                Assignment assignment = (Assignment)parent;
                node = assignment.getRightHandSide();
                break;
            }
            case 44: {
                SingleVariableDeclaration decl = (SingleVariableDeclaration)parent;
                node = decl.getInitializer();
                if (node != null) break;
                return false;
            }
            case 59: {
                node = parent;
                break;
            }
            default: {
                return false;
            }
        }
        ArrayList<Expression> sideEffects = new ArrayList<Expression>();
        node.accept((ASTVisitor)new SideEffectFinder(sideEffects));
        return sideEffects.size() > 0;
    }

    public static SimpleName getUnusedName(CompilationUnit compilationUnit, IProblemLocation problem) {
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode instanceof MethodDeclaration) {
            return ((MethodDeclaration)selectedNode).getName();
        }
        if (selectedNode instanceof SimpleName) {
            return (SimpleName)selectedNode;
        }
        return null;
    }

    public static String getDisplayString(SimpleName simpleName, IBinding binding, boolean removeAllAssignements) {
        String name = BasicElementLabels.getJavaElementName(simpleName.getIdentifier());
        switch (binding.getKind()) {
            case 2: {
                return Messages.format(FixMessages.UnusedCodeFix_RemoveType_description, name);
            }
            case 4: {
                if (((IMethodBinding)binding).isConstructor()) {
                    return Messages.format(FixMessages.UnusedCodeFix_RemoveConstructor_description, name);
                }
                return Messages.format(FixMessages.UnusedCodeFix_RemoveMethod_description, name);
            }
            case 3: {
                if (removeAllAssignements) {
                    return Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocalWithInitializer_description, name);
                }
                return Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_description, name);
            }
        }
        return "";
    }

    public static Map<String, String> getCleanUpOptions(IBinding binding, boolean removeAll) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put("cleanup.remove_unused_private_members", "true");
        switch (binding.getKind()) {
            case 2: {
                result.put("cleanup.remove_unused_private_types", "true");
                break;
            }
            case 4: {
                if (((IMethodBinding)binding).isConstructor()) {
                    result.put("cleanup.remove_private_constructors", "true");
                    break;
                }
                result.put("cleanup.remove_unused_private_methods", "true");
                break;
            }
            case 3: {
                if (removeAll) {
                    return null;
                }
                result.put("cleanup.remove_unused_private_fields", "true");
                result.put("cleanup.remove_unused_local_variables", "true");
                result.put("cleanup.remove_unused_method_parameters", "true");
                break;
            }
        }
        return result;
    }

    public static ImportDeclaration getImportDeclaration(IProblemLocation problem, CompilationUnit compilationUnit) {
        ASTNode node;
        ASTNode selectedNode = problem.getCoveringNode(compilationUnit);
        if (selectedNode != null && (node = ASTNodes.getParent(selectedNode, 26)) instanceof ImportDeclaration) {
            return (ImportDeclaration)node;
        }
        return null;
    }

    private static void replaceCast(CastExpression castExpression, Expression replacement, ASTRewrite rewrite, TextEditGroup group) {
        ASTNode move;
        CastExpression toReplace;
        boolean castEnclosedInNecessaryParentheses = castExpression.getParent() instanceof ParenthesizedExpression && NecessaryParenthesesChecker.needsParentheses((Expression)castExpression, castExpression.getParent().getParent(), castExpression.getParent().getLocationInParent());
        Object object = toReplace = castEnclosedInNecessaryParentheses ? castExpression.getParent() : castExpression;
        if (NecessaryParenthesesChecker.needsParentheses(replacement, toReplace.getParent(), toReplace.getLocationInParent())) {
            if (replacement.getParent() instanceof ParenthesizedExpression) {
                move = rewrite.createMoveTarget(replacement.getParent());
            } else if (castEnclosedInNecessaryParentheses) {
                toReplace = castExpression;
                move = rewrite.createMoveTarget((ASTNode)replacement);
            } else {
                ParenthesizedExpression parentheses = replacement.getAST().newParenthesizedExpression();
                parentheses.setExpression((Expression)rewrite.createMoveTarget((ASTNode)replacement));
                move = parentheses;
            }
        } else {
            move = rewrite.createMoveTarget((ASTNode)replacement);
        }
        rewrite.replace((ASTNode)toReplace, move, group);
    }

    private UnusedCodeFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations) {
        this(name, compilationUnit, fixRewriteOperations, (Map<String, String>)null);
    }

    private UnusedCodeFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] fixRewriteOperations, Map<String, String> options) {
        super(name, compilationUnit, fixRewriteOperations);
        this.fCleanUpOptions = options;
    }

    public UnusedCodeCleanUpCore getCleanUp() {
        if (this.fCleanUpOptions == null) {
            return null;
        }
        return new UnusedCodeCleanUpCore(this.fCleanUpOptions);
    }

    private static class MethodReferenceFinder
    extends ASTVisitor {
        private IMethodBinding binding;
        private boolean hasReference = false;

        public MethodReferenceFinder(IMethodBinding binding) {
            this.binding = binding;
        }

        private boolean markMethodReference(MethodReference ref) {
            if (ref.resolveMethodBinding() == this.binding) {
                this.hasReference = true;
                return false;
            }
            return true;
        }

        public boolean hasReference() {
            return this.hasReference;
        }

        public boolean visit(CreationReference node) {
            return this.markMethodReference((MethodReference)node);
        }

        public boolean visit(ExpressionMethodReference node) {
            return this.markMethodReference((MethodReference)node);
        }

        public boolean visit(TypeMethodReference node) {
            return this.markMethodReference((MethodReference)node);
        }
    }

    public static class RemoveAllCastOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final LinkedHashSet<CastExpression> fUnnecessaryCasts;

        public RemoveAllCastOperation(LinkedHashSet<CastExpression> unnecessaryCasts) {
            this.fUnnecessaryCasts = unnecessaryCasts;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveCast_description, cuRewrite);
            while (this.fUnnecessaryCasts.size() > 0) {
                Assignment assignment;
                CastExpression castExpression = (CastExpression)this.fUnnecessaryCasts.iterator().next();
                this.fUnnecessaryCasts.remove(castExpression);
                CastExpression down = castExpression;
                Expression downChild = down.getExpression();
                while (true) {
                    Expression downChildExpression;
                    if (this.fUnnecessaryCasts.contains(downChild)) {
                        down = (CastExpression)downChild;
                        this.fUnnecessaryCasts.remove(down);
                        downChild = down.getExpression();
                        continue;
                    }
                    if (!(downChild instanceof ParenthesizedExpression) || !NecessaryParenthesesChecker.needsParentheses(downChildExpression = ((ParenthesizedExpression)downChild).getExpression(), (ASTNode)down, (StructuralPropertyDescriptor)CastExpression.EXPRESSION_PROPERTY)) break;
                    downChild = downChildExpression;
                }
                CastExpression exp = castExpression;
                while (exp.getParent() instanceof ParenthesizedExpression) {
                    exp = (Expression)exp.getParent();
                }
                if (exp.getLocationInParent() == Assignment.RIGHT_HAND_SIDE_PROPERTY && (assignment = (Assignment)exp.getParent()).getLocationInParent() == ExpressionStatement.EXPRESSION_PROPERTY) {
                    ExpressionStatement stmt = (ExpressionStatement)assignment.getParent();
                    Expression lexp = assignment.getLeftHandSide();
                    if (lexp.subtreeMatch(new ASTMatcher(), (Object)downChild)) {
                        rewrite.remove((ASTNode)stmt, group);
                        continue;
                    }
                }
                UnusedCodeFixCore.replaceCast(castExpression, downChild, rewrite, group);
            }
        }
    }

    public static class RemoveCastOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final CastExpression fCast;

        public RemoveCastOperation(CastExpression cast) {
            this.fCast = cast;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            Assignment assignment;
            Expression childExpression;
            TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveCast_description, cuRewrite);
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            CastExpression cast = this.fCast;
            Expression expression = cast.getExpression();
            if (expression instanceof ParenthesizedExpression && NecessaryParenthesesChecker.needsParentheses(childExpression = ((ParenthesizedExpression)expression).getExpression(), (ASTNode)cast, (StructuralPropertyDescriptor)CastExpression.EXPRESSION_PROPERTY)) {
                expression = childExpression;
            }
            CastExpression exp = cast;
            while (exp.getParent() instanceof ParenthesizedExpression) {
                exp = (Expression)exp.getParent();
            }
            if (exp.getLocationInParent() == Assignment.RIGHT_HAND_SIDE_PROPERTY && (assignment = (Assignment)exp.getParent()).getLocationInParent() == ExpressionStatement.EXPRESSION_PROPERTY) {
                ExpressionStatement stmt = (ExpressionStatement)assignment.getParent();
                Expression lexp = assignment.getLeftHandSide();
                if (lexp.subtreeMatch(new ASTMatcher(), (Object)expression)) {
                    rewrite.remove((ASTNode)stmt, group);
                    return;
                }
            }
            UnusedCodeFixCore.replaceCast(cast, expression, rewrite, group);
        }
    }

    public static class RemoveImportOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ImportDeclaration fImportDeclaration;

        public RemoveImportOperation(ImportDeclaration importDeclaration) {
            this.fImportDeclaration = importDeclaration;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            ImportDeclaration node = this.fImportDeclaration;
            TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveImport_description, cuRewrite);
            cuRewrite.getASTRewrite().remove((ASTNode)node, group);
        }
    }

    public static class RemoveUnusedMemberOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final SimpleName[] fUnusedNames;
        private boolean fForceRemove;
        private int fRemovedAssignmentsCount;
        private int fAlteredAssignmentsCount;

        public RemoveUnusedMemberOperation(SimpleName[] unusedNames, boolean removeAllAssignements) {
            this.fUnusedNames = unusedNames;
            this.fForceRemove = removeAllAssignements;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore model) throws CoreException {
            SimpleName[] simpleNameArray = this.fUnusedNames;
            int n = this.fUnusedNames.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleName unusedName = simpleNameArray[n2];
                this.removeUnusedName(cuRewrite, unusedName);
                ++n2;
            }
        }

        private void removeUnusedName(CompilationUnitRewrite cuRewrite, SimpleName simpleName) {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            CompilationUnit completeRoot = cuRewrite.getRoot();
            IBinding binding = simpleName.resolveBinding();
            CompilationUnit root = (CompilationUnit)simpleName.getRoot();
            String displayString = this.getDisplayString(binding);
            TextEditGroup group = this.createTextEditGroup(displayString, cuRewrite);
            if (binding.getKind() == 4) {
                IMethodBinding decl = ((IMethodBinding)binding).getMethodDeclaration();
                ASTNode declaration = root.findDeclaringNode((IBinding)decl);
                rewrite.remove(declaration, group);
            } else if (binding.getKind() == 2) {
                ITypeBinding decl = ((ITypeBinding)binding).getTypeDeclaration();
                ASTNode declaration = root.findDeclaringNode((IBinding)decl);
                if (declaration.getParent() instanceof TypeDeclarationStatement) {
                    declaration = declaration.getParent();
                }
                rewrite.remove(declaration, group);
            } else if (binding.getKind() == 3) {
                SimpleName nameNode = (SimpleName)NodeFinder.perform((ASTNode)completeRoot, (int)simpleName.getStartPosition(), (int)simpleName.getLength());
                SimpleName[] simpleNameArray = LinkedNodeFinder.findByBinding((ASTNode)completeRoot, nameNode.resolveBinding());
                int n = simpleNameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SimpleName reference = simpleNameArray[n2];
                    this.removeVariableReferences(rewrite, reference, group);
                    ++n2;
                }
                IVariableBinding bindingDecl = ((IVariableBinding)nameNode.resolveBinding()).getVariableDeclaration();
                ASTNode declaringNode = completeRoot.findDeclaringNode((IBinding)bindingDecl);
                if (declaringNode instanceof SingleVariableDeclaration) {
                    UnusedCodeFixCore.removeParamTag(rewrite, (SingleVariableDeclaration)declaringNode, group);
                }
            }
        }

        private String getDisplayString(IBinding binding) {
            switch (binding.getKind()) {
                case 2: {
                    return FixMessages.UnusedCodeFix_RemoveUnusedType_description;
                }
                case 4: {
                    if (((IMethodBinding)binding).isConstructor()) {
                        return FixMessages.UnusedCodeFix_RemoveUnusedConstructor_description;
                    }
                    return FixMessages.UnusedCodeFix_RemoveUnusedPrivateMethod_description;
                }
                case 3: {
                    if (((IVariableBinding)binding).isField()) {
                        return FixMessages.UnusedCodeFix_RemoveUnusedField_description;
                    }
                    return FixMessages.UnusedCodeFix_RemoveUnusedVariabl_description;
                }
            }
            return "";
        }

        private void removeVariableReferences(ASTRewrite rewrite, SimpleName reference, TextEditGroup group) {
            ASTNode parent = reference.getParent();
            while (parent instanceof QualifiedName) {
                parent = parent.getParent();
            }
            if (parent instanceof FieldAccess) {
                parent = parent.getParent();
            }
            int nameParentType = parent.getNodeType();
            switch (nameParentType) {
                case 7: {
                    Assignment assignment = (Assignment)parent;
                    Expression rightHand = assignment.getRightHandSide();
                    ASTNode assignParent = assignment.getParent();
                    if (assignParent.getNodeType() == 21 && rightHand.getNodeType() != 7) {
                        this.removeVariableWithInitializer(rewrite, (ASTNode)rightHand, assignParent, group);
                        break;
                    }
                    rewrite.replace((ASTNode)assignment, rewrite.createCopyTarget((ASTNode)rightHand), group);
                    break;
                }
                case 44: {
                    rewrite.remove(parent, group);
                    break;
                }
                case 59: {
                    boolean sideEffectInitializer;
                    VariableDeclarationFragment frag = (VariableDeclarationFragment)parent;
                    ASTNode varDecl = frag.getParent();
                    List fragments = varDecl instanceof VariableDeclarationExpression ? ((VariableDeclarationExpression)varDecl).fragments() : (varDecl instanceof FieldDeclaration ? ((FieldDeclaration)varDecl).fragments() : ((VariableDeclarationStatement)varDecl).fragments());
                    Expression initializer = frag.getInitializer();
                    ArrayList<Expression> sideEffects = new ArrayList<Expression>();
                    if (initializer != null) {
                        initializer.accept((ASTVisitor)new SideEffectFinder(sideEffects));
                    }
                    if (initializer instanceof ConditionalExpression && varDecl instanceof VariableDeclarationStatement) {
                        AST ast = rewrite.getAST();
                        ConditionalExpression ce = (ConditionalExpression)initializer;
                        if (this.fForceRemove || !RemoveUnusedMemberOperation.checkSideEffects(sideEffects) && !RemoveUnusedMemberOperation.checkCondtionalExpression(ce.getThenExpression()) && !RemoveUnusedMemberOperation.checkCondtionalExpression(ce.getElseExpression())) {
                            rewrite.remove(varDecl, group);
                            return;
                        }
                        IfStatement ifStatement = ast.newIfStatement();
                        ifStatement.setExpression((Expression)rewrite.createCopyTarget((ASTNode)ASTNodes.getUnparenthesedExpression(ce.getExpression())));
                        Block thenBlock = ast.newBlock();
                        if (RemoveUnusedMemberOperation.checkCondtionalExpression(ce.getThenExpression())) {
                            ASTNode thenExpression = rewrite.createCopyTarget((ASTNode)ASTNodes.getUnparenthesedExpression(ce.getThenExpression()));
                            thenBlock.statements().add(ast.newExpressionStatement((Expression)thenExpression));
                        }
                        ifStatement.setThenStatement((Statement)thenBlock);
                        if (RemoveUnusedMemberOperation.checkCondtionalExpression(ce.getElseExpression())) {
                            Block elseBlock = ast.newBlock();
                            ASTNode elseExpression = rewrite.createCopyTarget((ASTNode)ASTNodes.getUnparenthesedExpression(ce.getElseExpression()));
                            elseBlock.statements().add(ast.newExpressionStatement((Expression)elseExpression));
                            ifStatement.setElseStatement((Statement)elseBlock);
                        }
                        rewrite.replace(varDecl, (ASTNode)ifStatement, group);
                        return;
                    }
                    boolean bl = sideEffectInitializer = sideEffects.size() > 0;
                    if (fragments.size() == this.fUnusedNames.length) {
                        if (this.fForceRemove) {
                            rewrite.remove(varDecl, group);
                            return;
                        }
                        if (parent.getParent() instanceof FieldDeclaration) {
                            rewrite.remove(varDecl, group);
                            return;
                        }
                        if (sideEffectInitializer) {
                            if (varDecl.getLocationInParent() == ForStatement.INITIALIZERS_PROPERTY) {
                                Expression[] exps = new Expression[sideEffects.size()];
                                int i = 0;
                                while (i < exps.length) {
                                    Expression movedInit;
                                    Expression sideEffect = sideEffects.get(i);
                                    exps[i] = movedInit = (Expression)rewrite.createMoveTarget((ASTNode)sideEffect);
                                    ++i;
                                }
                                ReplaceRewrite replaceRewrite = ReplaceRewrite.create(rewrite, new ASTNode[]{varDecl});
                                replaceRewrite.replace((ASTNode[])exps, group);
                                break;
                            }
                            Statement[] wrapped = new Statement[sideEffects.size()];
                            int i = 0;
                            while (i < wrapped.length) {
                                Expression sideEffect = sideEffects.get(i);
                                Expression movedInit = (Expression)rewrite.createMoveTarget((ASTNode)sideEffect);
                                wrapped[i] = rewrite.getAST().newExpressionStatement(movedInit);
                                ++i;
                            }
                            StatementRewrite statementRewrite = new StatementRewrite(rewrite, new ASTNode[]{varDecl});
                            statementRewrite.replace((ASTNode[])wrapped, group);
                            break;
                        }
                        rewrite.remove(varDecl, group);
                        break;
                    }
                    if (this.fForceRemove) {
                        rewrite.remove((ASTNode)frag, group);
                        return;
                    }
                    ASTNode declaration = parent.getParent();
                    if (declaration instanceof FieldDeclaration) {
                        rewrite.remove((ASTNode)frag, group);
                        return;
                    }
                    if (declaration instanceof VariableDeclarationStatement) {
                        this.splitUpDeclarations(rewrite, group, frag, (VariableDeclarationStatement)declaration, sideEffects);
                        rewrite.remove((ASTNode)frag, group);
                        return;
                    }
                    if (!(declaration instanceof VariableDeclarationExpression) || sideEffectInitializer) break;
                    rewrite.remove((ASTNode)frag, group);
                    break;
                }
                case 37: 
                case 38: {
                    Expression expression = (Expression)parent;
                    ASTNode expressionParent = expression.getParent();
                    if (expressionParent.getNodeType() == 21) {
                        this.removeStatement(rewrite, expressionParent, group);
                        break;
                    }
                    rewrite.remove((ASTNode)expression, group);
                    break;
                }
            }
        }

        private static boolean checkCondtionalExpression(Expression expression) {
            int nodeType = ASTNodes.getUnparenthesedExpression(expression).getNodeType();
            return nodeType == 32 || nodeType == 37 || nodeType == 38 || nodeType == 7;
        }

        private static boolean checkSideEffects(List<Expression> sideEffects) {
            if (sideEffects.isEmpty()) {
                return false;
            }
            for (Expression expression : sideEffects) {
                if (!RemoveUnusedMemberOperation.checkCondtionalExpression(expression)) continue;
                return true;
            }
            return false;
        }

        private void splitUpDeclarations(ASTRewrite rewrite, TextEditGroup group, VariableDeclarationFragment frag, VariableDeclarationStatement originalStatement, List<Expression> sideEffects) {
            if (sideEffects.size() > 0) {
                ListRewrite statementRewrite = rewrite.getListRewrite(originalStatement.getParent(), (ChildListPropertyDescriptor)originalStatement.getLocationInParent());
                VariableDeclarationStatement previousStatement = originalStatement;
                for (Expression sideEffect : sideEffects) {
                    Expression movedInit = (Expression)rewrite.createMoveTarget((ASTNode)sideEffect);
                    ExpressionStatement wrapped = rewrite.getAST().newExpressionStatement(movedInit);
                    statementRewrite.insertAfter((ASTNode)wrapped, (ASTNode)previousStatement, group);
                    previousStatement = wrapped;
                }
                VariableDeclarationStatement newDeclaration = null;
                List fragments = originalStatement.fragments();
                int fragIndex = fragments.indexOf(frag);
                ListIterator fragmentIterator = fragments.listIterator(fragIndex + 1);
                while (fragmentIterator.hasNext()) {
                    VariableDeclarationFragment currentFragment = (VariableDeclarationFragment)fragmentIterator.next();
                    VariableDeclarationFragment movedFragment = (VariableDeclarationFragment)rewrite.createMoveTarget((ASTNode)currentFragment);
                    if (newDeclaration == null) {
                        newDeclaration = rewrite.getAST().newVariableDeclarationStatement(movedFragment);
                        Type copiedType = (Type)rewrite.createCopyTarget((ASTNode)originalStatement.getType());
                        newDeclaration.setType(copiedType);
                        continue;
                    }
                    newDeclaration.fragments().add(movedFragment);
                }
                if (newDeclaration != null) {
                    statementRewrite.insertAfter(newDeclaration, (ASTNode)previousStatement, group);
                    if (originalStatement.fragments().size() == newDeclaration.fragments().size() + 1) {
                        rewrite.remove((ASTNode)originalStatement, group);
                    }
                }
            }
        }

        private void removeVariableWithInitializer(ASTRewrite rewrite, ASTNode initializerNode, ASTNode statementNode, TextEditGroup group) {
            boolean performRemove = this.fForceRemove;
            if (!performRemove) {
                ArrayList<Expression> sideEffectNodes = new ArrayList<Expression>();
                initializerNode.accept((ASTVisitor)new SideEffectFinder(sideEffectNodes));
                performRemove = sideEffectNodes.isEmpty();
            }
            if (performRemove) {
                this.removeStatement(rewrite, statementNode, group);
                ++this.fRemovedAssignmentsCount;
            } else {
                ASTNode nodeToMove = initializerNode;
                while (nodeToMove instanceof FieldAccess) {
                    nodeToMove = ((FieldAccess)nodeToMove).getExpression();
                }
                ASTNode initNode = rewrite.createMoveTarget(nodeToMove);
                ExpressionStatement statement = rewrite.getAST().newExpressionStatement((Expression)initNode);
                rewrite.replace(statementNode, (ASTNode)statement, null);
                ++this.fAlteredAssignmentsCount;
            }
        }

        private void removeStatement(ASTRewrite rewrite, ASTNode statementNode, TextEditGroup group) {
            if (ASTNodes.isControlStatementBody(statementNode.getLocationInParent())) {
                rewrite.replace(statementNode, (ASTNode)rewrite.getAST().newBlock(), group);
            } else {
                rewrite.remove(statementNode, group);
            }
        }

        @Override
        public String getAdditionalInfo() {
            StringBuilder sb = new StringBuilder();
            if (this.fRemovedAssignmentsCount == 1) {
                sb.append(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_RemovedAssignments_preview_singular);
            } else if (this.fRemovedAssignmentsCount > 1) {
                sb.append(Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_RemovedAssignments_preview_plural, String.valueOf(this.fRemovedAssignmentsCount)));
            }
            if (this.fAlteredAssignmentsCount == 1) {
                sb.append(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_AlteredAssignments_preview_singular);
            } else if (this.fAlteredAssignmentsCount > 1) {
                sb.append(Messages.format(FixMessages.UnusedCodeFix_RemoveFieldOrLocal_AlteredAssignments_preview_plural, String.valueOf(this.fAlteredAssignmentsCount)));
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
            return null;
        }
    }

    public static class RemoveUnusedParameterOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private SingleVariableDeclaration parameter;
        private String newName;

        public RemoveUnusedParameterOperation(SingleVariableDeclaration parameter, String newName) {
            this.parameter = parameter;
            this.newName = newName;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            SimpleName[] linkedNodes;
            SingleVariableDeclaration declaration = (SingleVariableDeclaration)NodeFinder.perform((ASTNode)cuRewrite.getRoot(), (int)this.parameter.getStartPosition(), (int)this.parameter.getLength());
            TextEditGroup group = this.createTextEditGroup(FixMessages.UnusedCodeFix_RemoveUnusedMethodParameter_description, cuRewrite);
            MethodDeclaration method = ASTNodes.getTypedAncestor((ASTNode)this.parameter, MethodDeclaration.class);
            int argumentIndex = method.parameters().indexOf(declaration);
            SimpleName[] simpleNameArray = linkedNodes = LinkedNodeFinder.findByBinding((ASTNode)cuRewrite.getRoot(), (IBinding)method.resolveBinding());
            int n = linkedNodes.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleName linkedName = simpleNameArray[n2];
                ASTNode parent = linkedName.getParent();
                if (parent.getNodeType() == 32) {
                    MethodInvocation invocation = (MethodInvocation)parent;
                    ASTNode argument = (ASTNode)invocation.arguments().get(argumentIndex);
                    cuRewrite.getASTRewrite().remove(argument, group);
                }
                if (!linkedName.getFullyQualifiedName().equals(this.newName)) {
                    SimpleName newNameNode = linkedName.getAST().newSimpleName(this.newName);
                    cuRewrite.getASTRewrite().replace((ASTNode)linkedName, (ASTNode)newNameNode, group);
                }
                ++n2;
            }
        }
    }

    public static class RemoveUnusedTypeParameterOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final SimpleName fUnusedName;

        public RemoveUnusedTypeParameterOperation(SimpleName unusedName) {
            this.fUnusedName = unusedName;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            IBinding binding = this.fUnusedName.resolveBinding();
            CompilationUnit root = (CompilationUnit)this.fUnusedName.getRoot();
            String displayString = FixMessages.UnusedCodeFix_RemoveUnusedTypeParameter_description;
            TextEditGroup group = this.createTextEditGroup(displayString, cuRewrite);
            if (binding.getKind() == 2) {
                ITypeBinding decl = ((ITypeBinding)binding).getTypeDeclaration();
                ASTNode declaration = root.findDeclaringNode((IBinding)decl);
                if (declaration.getParent() instanceof TypeDeclarationStatement) {
                    declaration = declaration.getParent();
                }
                rewrite.remove(declaration, group);
            }
        }
    }

    public static class SideEffectFinder
    extends ASTVisitor {
        private final ArrayList<Expression> fSideEffectNodes;

        public SideEffectFinder(ArrayList<Expression> res) {
            this.fSideEffectNodes = res;
        }

        public boolean visit(Assignment node) {
            this.fSideEffectNodes.add((Expression)node);
            return false;
        }

        public boolean visit(PostfixExpression node) {
            this.fSideEffectNodes.add((Expression)node);
            return false;
        }

        public boolean visit(PrefixExpression node) {
            PrefixExpression.Operator operator = node.getOperator();
            if (operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
                this.fSideEffectNodes.add((Expression)node);
                return false;
            }
            return true;
        }

        public boolean visit(MethodInvocation node) {
            this.fSideEffectNodes.add((Expression)node);
            return false;
        }

        public boolean visit(ClassInstanceCreation node) {
            this.fSideEffectNodes.add((Expression)node);
            return false;
        }

        public boolean visit(SuperMethodInvocation node) {
            this.fSideEffectNodes.add((Expression)node);
            return false;
        }
    }
}

