/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.util.CtSym;
import org.eclipse.jdt.internal.compiler.util.Jdk;
import org.eclipse.jdt.internal.compiler.util.JrtFileSystem;
import org.eclipse.jdt.internal.compiler.util.SoftClassCache;

public class JRTUtil {
    public static final boolean DISABLE_CACHE = Boolean.getBoolean("org.eclipse.jdt.disable_JRT_cache");
    public static final boolean PROPAGATE_IO_ERRORS = Boolean.getBoolean("org.eclipse.jdt.propagate_io_errors");
    public static final String JAVA_BASE = "java.base";
    public static final char[] JAVA_BASE_CHAR = "java.base".toCharArray();
    public static final String MODULES_SUBDIR = "/modules";
    static final String[] DEFAULT_MODULE = new String[]{"java.base"};
    static final String[] NO_MODULE = new String[0];
    static final String MULTIPLE = "MU";
    static final String DEFAULT_PACKAGE = "";
    static String MODULE_TO_LOAD;
    public static final String JRT_FS_JAR = "jrt-fs.jar";
    static URI JRT_URI;
    public static final int NOTIFY_FILES = 1;
    public static final int NOTIFY_PACKAGES = 2;
    public static final int NOTIFY_MODULES = 4;
    public static final int NOTIFY_ALL = 7;
    private static Map<String, JrtFileSystem> images;
    private static final Map<Path, CtSym> ctSymFiles;
    private static final Map<Path, FileSystem> JRT_FILE_SYSTEMS;
    static final SoftClassCache classCache;

    static {
        JRT_URI = URI.create("jrt:/");
        images = new ConcurrentHashMap<String, JrtFileSystem>();
        ctSymFiles = new ConcurrentHashMap<Path, CtSym>();
        JRT_FILE_SYSTEMS = new ConcurrentHashMap<Path, FileSystem>();
        classCache = new SoftClassCache();
    }

    public static JrtFileSystem getJrtSystem(File image) {
        try {
            return JRTUtil.getJrtSystem(image, null);
        }
        catch (IOException e) {
            if (PROPAGATE_IO_ERRORS) {
                throw new IllegalStateException(e);
            }
            return null;
        }
    }

    public static JrtFileSystem getJrtSystem(File image, String release) throws IOException {
        Jdk jdk = new Jdk(image);
        Object key = jdk.path.toString();
        if (release != null && !jdk.sameRelease(release)) {
            key = (String)key + "|" + release;
        }
        try {
            JrtFileSystem system = images.computeIfAbsent((String)key, x -> {
                try {
                    return JrtFileSystem.getNewJrtFileSystem(jdk, release);
                }
                catch (IOException e) {
                    String errorMessage = "Error: failed to create JrtFileSystem from " + String.valueOf(image);
                    throw new UncheckedIOException(errorMessage, e);
                }
            });
            return system;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static FileSystem getJrtFileSystem(Path path) throws IOException {
        try {
            FileSystem fs = JRT_FILE_SYSTEMS.computeIfAbsent(path.toAbsolutePath().normalize(), p -> {
                try {
                    return FileSystems.newFileSystem(JRT_URI, Map.of("java.home", p.toString()));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            return fs;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public static FileSystem getJarFileSystem(Path path) throws IOException {
        URI uri = URI.create("jar:file:" + path.toUri().getRawPath());
        try {
            try {
                return FileSystems.getFileSystem(uri);
            }
            catch (FileSystemNotFoundException fne) {
                try {
                    return FileSystems.newFileSystem(uri, Map.of(), ClassLoader.getSystemClassLoader());
                }
                catch (FileSystemAlreadyExistsException e) {
                    return FileSystems.getFileSystem(uri);
                }
            }
        }
        catch (ProviderNotFoundException e) {
            throw new IOException("No provider for uri " + String.valueOf(uri), e);
        }
    }

    public static CtSym getCtSym(Path jdkHome) throws IOException {
        CtSym ctSym;
        try {
            ctSym = ctSymFiles.compute(jdkHome.toAbsolutePath().normalize(), (x, current) -> {
                if (current == null || !current.getFs().isOpen()) {
                    try {
                        return new CtSym((Path)x);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return current;
            });
        }
        catch (UncheckedIOException rio) {
            throw rio.getCause();
        }
        return ctSym;
    }

    public static void reset() {
        images.clear();
        classCache.clear();
        MODULE_TO_LOAD = System.getProperty("modules.to.load");
    }

    public static void walkModuleImage(File image, JrtFileVisitor<Path> visitor, int notify) throws IOException {
        JRTUtil.walkModuleImage(JRTUtil.getJrtSystem(image, null), visitor, notify);
    }

    public static void walkModuleImage(JrtFileSystem system, JrtFileVisitor<Path> visitor, int notify) throws IOException {
        if (system == null) {
            return;
        }
        system.walkModuleImage(visitor, notify);
    }

    public static InputStream getContentFromJrt(File jrt, String fileName, String module) throws IOException {
        JrtFileSystem system = JRTUtil.getJrtSystem(jrt, null);
        if (system == null) {
            throw new FileNotFoundException(String.valueOf(jrt));
        }
        return system.getContentFromJrt(fileName, module);
    }

    public static byte[] getClassfileContent(File jrt, String fileName, String module) throws IOException {
        JrtFileSystem system = JRTUtil.getJrtSystem(jrt, null);
        if (system == null) {
            throw new FileNotFoundException(String.valueOf(system));
        }
        return JRTUtil.getClassfileContent(system, fileName, module);
    }

    public static byte[] getClassfileContent(JrtFileSystem system, String fileName, String module) throws FileNotFoundException, IOException {
        return system.getClassfileContent(fileName, module);
    }

    public static ClassFileReader getClassfile(File jrt, String fileName, String module) throws IOException, ClassFormatException {
        JrtFileSystem system = JRTUtil.getJrtSystem(jrt, null);
        if (system == null) {
            throw new FileNotFoundException(String.valueOf(jrt));
        }
        return system.getClassfile(fileName, module);
    }

    public static ClassFileReader getClassfile(File jrt, String fileName, String module, Predicate<String> moduleNameFilter) throws IOException, ClassFormatException {
        JrtFileSystem jrtSystem = JRTUtil.getJrtSystem(jrt, null);
        if (jrtSystem == null) {
            throw new FileNotFoundException(String.valueOf(jrt));
        }
        return JRTUtil.getClassfile(jrtSystem, fileName, module, moduleNameFilter);
    }

    public static ClassFileReader getClassfile(JrtFileSystem system, String fileName, String module, Predicate<String> moduleNameFilter) throws FileNotFoundException, IOException, ClassFormatException {
        return system.getClassfile(fileName, module, moduleNameFilter);
    }

    public static List<String> getModulesDeclaringPackage(File jrt, String qName, String moduleName) {
        return JRTUtil.getModulesDeclaringPackage(JRTUtil.getJrtSystem(jrt), qName, moduleName);
    }

    public static List<String> getModulesDeclaringPackage(JrtFileSystem system, String qName, String moduleName) {
        if (system == null) {
            return List.of();
        }
        return system.getModulesDeclaringPackage(qName, moduleName);
    }

    public static boolean hasCompilationUnit(File jrt, String qualifiedPackageName, String moduleName) {
        JrtFileSystem system = JRTUtil.getJrtSystem(jrt);
        return JRTUtil.hasCompilationUnit(system, qualifiedPackageName, moduleName);
    }

    public static boolean hasCompilationUnit(JrtFileSystem system, String qualifiedPackageName, String moduleName) {
        if (system == null) {
            return false;
        }
        return system.hasClassFile(qualifiedPackageName, moduleName);
    }

    public static String sanitizedFileName(Path path) {
        String p = path.getFileName().toString();
        if (p.length() > 1 && p.charAt(p.length() - 1) == '/') {
            return p.substring(0, p.length() - 1);
        }
        return p;
    }

    public static byte[] safeReadBytes(Path path) throws IOException {
        try {
            return Files.readAllBytes(path);
        }
        catch (ClosedByInterruptException e) {
            Thread.interrupted();
            try {
                byte[] byArray = Files.readAllBytes(path);
                return byArray;
            }
            catch (NoSuchFileException e2) {
                return null;
            }
            finally {
                Thread.currentThread().interrupt();
            }
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    public static String getJdkRelease(File image) throws IOException {
        JrtFileSystem jrt = JRTUtil.getJrtSystem(image, null);
        return jrt == null ? null : jrt.getJdkRelease();
    }

    public static interface JrtFileVisitor<T> {
        default public FileVisitResult visitPackage(T dir, T mod, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        default public FileVisitResult visitFile(T file, T mod, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        default public FileVisitResult visitModule(T path, String name) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

