/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public class HttpTransportOverHTTP2
implements HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpTransportOverHTTP2.class);
    private final AtomicBoolean commit = new AtomicBoolean();
    private final TransportCallback transportCallback = new TransportCallback();
    private final Connector connector;
    private final HTTP2ServerConnection connection;
    private IStream stream;
    private MetaData metaData;

    public HttpTransportOverHTTP2(Connector connector, HTTP2ServerConnection connection) {
        this.connector = connector;
        this.connection = connection;
    }

    public boolean isOptimizedForDirectBuffers() {
        return this.connection.getEndPoint().isOptimizedForDirectBuffers();
    }

    public IStream getStream() {
        return this.stream;
    }

    public void setStream(IStream stream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} setStream {}", new Object[]{this, stream.getId()});
        }
        this.stream = stream;
    }

    public void recycle() {
        this.stream = null;
        this.commit.set(false);
    }

    public void send(MetaData.Response info, boolean isHeadRequest, ByteBuffer content, boolean lastContent, Callback callback) {
        if (info != null) {
            this.sendHeaders(info, content, lastContent, isHeadRequest, callback);
        } else {
            this.sendContent(content, lastContent, isHeadRequest, callback);
        }
    }

    private void sendHeaders(MetaData.Response info, ByteBuffer content, boolean lastContent, boolean isHeadRequest, Callback callback) {
        HeadersFrame headersFrame;
        boolean interimResponse;
        this.metaData = info;
        DataFrame dataFrame = null;
        HeadersFrame trailersFrame = null;
        boolean hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        int status = info.getStatus();
        boolean bl = interimResponse = status == 100 || status == 102;
        if (interimResponse) {
            if (hasContent) {
                callback.failed((Throwable)new IllegalStateException("Interim response cannot have content"));
                return;
            }
            headersFrame = new HeadersFrame(this.stream.getId(), (MetaData)info, null, false);
        } else if (this.commit.compareAndSet(false, true)) {
            if (lastContent) {
                long realContentLength = BufferUtil.length((ByteBuffer)content);
                long contentLength = info.getContentLength();
                if (contentLength < 0L) {
                    info.setContentLength(realContentLength);
                } else if (hasContent && contentLength != realContentLength) {
                    callback.failed((Throwable)new BadMessageException(500, String.format("Incorrect Content-Length %d!=%d", contentLength, realContentLength)));
                    return;
                }
            }
            if (hasContent) {
                headersFrame = new HeadersFrame(this.stream.getId(), (MetaData)info, null, false);
                if (lastContent) {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        dataFrame = new DataFrame(this.stream.getId(), content, true);
                    } else {
                        dataFrame = new DataFrame(this.stream.getId(), content, false);
                        trailersFrame = new HeadersFrame(this.stream.getId(), new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                    }
                } else {
                    dataFrame = new DataFrame(this.stream.getId(), content, false);
                }
            } else if (lastContent) {
                HttpFields trailers = this.retrieveTrailers();
                if (trailers == null) {
                    headersFrame = new HeadersFrame(this.stream.getId(), (MetaData)info, null, true);
                } else {
                    headersFrame = new HeadersFrame(this.stream.getId(), (MetaData)info, null, false);
                    trailersFrame = new HeadersFrame(this.stream.getId(), new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                }
            } else {
                headersFrame = new HeadersFrame(this.stream.getId(), (MetaData)info, null, false);
            }
        } else {
            callback.failed((Throwable)new IllegalStateException("Response already committed"));
            return;
        }
        HeadersFrame hf = headersFrame;
        DataFrame df = dataFrame;
        HeadersFrame tf = trailersFrame;
        this.transportCallback.send(callback, true, c -> {
            if (HttpTransportOverHTTP2.LOG.isDebugEnabled()) {
                HttpTransportOverHTTP2.LOG.debug("HTTP2 Response #{}/{}:{}{} {}{}{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), System.lineSeparator(), HttpVersion.HTTP_2, info.getStatus(), System.lineSeparator(), info.getFields()});
            }
            this.stream.send(new IStream.FrameList(hf, df, tf), c);
        });
    }

    private void sendContent(ByteBuffer content, boolean lastContent, boolean isHeadRequest, Callback callback) {
        boolean hasContent;
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (hasContent || lastContent) {
            if (lastContent) {
                HttpFields trailers = this.retrieveTrailers();
                if (trailers == null) {
                    this.transportCallback.send(callback, false, c -> this.sendDataFrame(content, true, true, (Callback)c));
                } else {
                    SendTrailers sendTrailers = new SendTrailers(callback, trailers);
                    if (hasContent) {
                        this.transportCallback.send((Callback)sendTrailers, false, c -> this.sendDataFrame(content, true, false, (Callback)c));
                    } else {
                        sendTrailers.succeeded();
                    }
                }
            } else {
                this.transportCallback.send(callback, false, c -> this.sendDataFrame(content, false, false, (Callback)c));
            }
        } else {
            callback.succeeded();
        }
    }

    private HttpFields retrieveTrailers() {
        Supplier supplier = this.metaData.getTrailerSupplier();
        if (supplier == null) {
            return null;
        }
        HttpFields trailers = (HttpFields)supplier.get();
        if (trailers == null) {
            return null;
        }
        return trailers.size() == 0 ? null : trailers;
    }

    public boolean isPushSupported() {
        return this.stream.getSession().isPushEnabled();
    }

    public void push(final MetaData.Request request) {
        if (!this.stream.getSession().isPushEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 Push disabled for {}", new Object[]{request});
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP/2 Push {}", new Object[]{request});
        }
        this.stream.push(new PushPromiseFrame(this.stream.getId(), (MetaData)request), (Promise)new Promise<Stream>(){

            public void succeeded(Stream pushStream) {
                HttpTransportOverHTTP2.this.connection.push(HttpTransportOverHTTP2.this.connector, (IStream)pushStream, request);
            }

            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not push " + request, x);
                }
            }
        }, (Stream.Listener)new Stream.Listener.Adapter());
    }

    private void sendDataFrame(ByteBuffer content, boolean lastContent, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: {} content bytes{}", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode()), content.remaining(), lastContent ? " (last chunk)" : ""});
        }
        DataFrame frame = new DataFrame(this.stream.getId(), content, endStream);
        this.stream.data(frame, callback);
    }

    private void sendTrailersFrame(MetaData metaData, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: trailers", new Object[]{this.stream.getId(), Integer.toHexString(this.stream.getSession().hashCode())});
        }
        HeadersFrame frame = new HeadersFrame(this.stream.getId(), metaData, null, true);
        this.stream.headers(frame, callback);
    }

    public void onStreamFailure(Throwable failure) {
        this.transportCallback.abort(failure);
    }

    public boolean onStreamTimeout(Throwable failure) {
        return this.transportCallback.idleTimeout(failure);
    }

    public void onCompleted() {
        HttpChannelOverHTTP2 channel;
        if (!this.stream.isClosed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{}: unconsumed request content, resetting stream", (long)this.stream.getId());
            }
            this.stream.reset(new ResetFrame(this.stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
        if ((channel = (HttpChannelOverHTTP2)this.stream.getAttachment()) != null) {
            channel.consumeInput();
        }
    }

    public void abort(Throwable failure) {
        IStream stream = this.stream;
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{} aborted", new Object[]{stream == null ? -1 : stream.getId(), stream == null ? Integer.valueOf(-1) : Integer.toHexString(stream.getSession().hashCode())});
        }
        if (stream != null) {
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
    }

    private class TransportCallback
    implements Callback {
        private State _state = State.IDLE;
        private Callback _callback;
        private boolean _commit;
        private Throwable _failure;

        private TransportCallback() {
        }

        private void reset(Throwable failure) {
            assert (Thread.holdsLock(this));
            this._state = failure != null ? State.FAILED : State.IDLE;
            this._callback = null;
            this._commit = false;
            this._failure = failure;
        }

        private void send(Callback callback, boolean commit, Consumer<Callback> sendFrame) {
            Throwable failure = this.sending(callback, commit);
            if (failure == null) {
                sendFrame.accept(this);
            } else {
                callback.failed(failure);
            }
        }

        private void abort(Throwable failure) {
            this.failed(failure);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Throwable sending(Callback callback, boolean commit) {
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                switch (this._state) {
                    case IDLE: {
                        this._state = State.SENDING;
                        this._callback = callback;
                        this._commit = commit;
                        return null;
                    }
                    case FAILED: {
                        return this._failure;
                    }
                }
                return new IllegalStateException("Invalid transport state: " + (Object)((Object)this._state));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void succeeded() {
            boolean commit;
            Callback callback;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                if (this._state != State.SENDING) {
                    return;
                }
                callback = this._callback;
                commit = this._commit;
                this.reset(null);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{}/{} {} success", new Object[]{HttpTransportOverHTTP2.this.stream.getId(), Integer.toHexString(HttpTransportOverHTTP2.this.stream.getSession().hashCode()), commit ? "commit" : "flush"});
            }
            callback.succeeded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable failure) {
            boolean commit;
            Callback callback;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                if (this._state != State.SENDING) {
                    this.reset(failure);
                    return;
                }
                callback = this._callback;
                commit = this._commit;
                this.reset(failure);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{}/{} {} failure", new Object[]{HttpTransportOverHTTP2.this.stream.getId(), Integer.toHexString(HttpTransportOverHTTP2.this.stream.getSession().hashCode()), commit ? "commit" : "flush", failure});
            }
            callback.failed(failure);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean idleTimeout(Throwable failure) {
            boolean timeout;
            Callback callback = null;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                if (this._state == State.SENDING) {
                    callback = this._callback;
                    this.reset(failure);
                }
            }
            boolean bl = timeout = callback != null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Response #{}/{} idle timeout {}", new Object[]{HttpTransportOverHTTP2.this.stream.getId(), Integer.toHexString(HttpTransportOverHTTP2.this.stream.getSession().hashCode()), timeout ? "expired" : "ignored", failure});
            }
            if (timeout) {
                callback.failed(failure);
            }
            return timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Invocable.InvocationType getInvocationType() {
            Callback callback;
            TransportCallback transportCallback = this;
            synchronized (transportCallback) {
                callback = this._callback;
            }
            return callback != null ? callback.getInvocationType() : super.getInvocationType();
        }
    }

    private class SendTrailers
    extends Callback.Nested {
        private final HttpFields trailers;

        private SendTrailers(Callback callback, HttpFields trailers) {
            super(callback);
            this.trailers = trailers;
        }

        public void succeeded() {
            HttpTransportOverHTTP2.this.transportCallback.send(this.getCallback(), false, c -> HttpTransportOverHTTP2.this.sendTrailersFrame(new MetaData(HttpVersion.HTTP_2, this.trailers), c));
        }
    }

    private static enum State {
        IDLE,
        SENDING,
        FAILED;

    }
}

