/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.config.handler.property;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jkube.kit.build.service.docker.config.handler.ExternalConfigHandler;
import org.eclipse.jkube.kit.build.service.docker.config.handler.property.ConfigKey;
import org.eclipse.jkube.kit.build.service.docker.config.handler.property.PropertyMode;
import org.eclipse.jkube.kit.build.service.docker.config.handler.property.ValueProvider;
import org.eclipse.jkube.kit.common.AssemblyConfiguration;
import org.eclipse.jkube.kit.common.JavaProject;
import org.eclipse.jkube.kit.common.util.EnvUtil;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.common.util.MapUtil;
import org.eclipse.jkube.kit.config.image.ImageConfiguration;
import org.eclipse.jkube.kit.config.image.LogConfiguration;
import org.eclipse.jkube.kit.config.image.NetworkConfig;
import org.eclipse.jkube.kit.config.image.RestartPolicy;
import org.eclipse.jkube.kit.config.image.RunImageConfiguration;
import org.eclipse.jkube.kit.config.image.RunVolumeConfiguration;
import org.eclipse.jkube.kit.config.image.UlimitConfig;
import org.eclipse.jkube.kit.config.image.WaitConfiguration;
import org.eclipse.jkube.kit.config.image.WatchImageConfiguration;
import org.eclipse.jkube.kit.config.image.build.Arguments;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.HealthCheckConfiguration;

public class PropertyConfigHandler
implements ExternalConfigHandler {
    public static final String TYPE_NAME = "properties";
    public static final String DEFAULT_PREFIX = "docker";

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    @Override
    public List<ImageConfiguration> resolve(ImageConfiguration fromConfig, JavaProject project) {
        Map externalConfig = fromConfig.getExternalConfig();
        String prefix = PropertyConfigHandler.getPrefix(externalConfig);
        Properties properties = JKubeProjectUtil.getPropertiesWithSystemOverrides((JavaProject)project);
        PropertyMode propertyMode = PropertyConfigHandler.getMode(externalConfig);
        ValueProvider valueProvider = new ValueProvider(prefix, properties, propertyMode);
        RunImageConfiguration run = this.extractRunConfiguration(fromConfig, valueProvider);
        BuildConfiguration build = this.extractBuildConfiguration(fromConfig, valueProvider, project);
        WatchImageConfiguration watch = this.extractWatchConfig(fromConfig, valueProvider);
        String name = valueProvider.getString(ConfigKey.NAME, fromConfig.getName());
        String alias = valueProvider.getString(ConfigKey.ALIAS, fromConfig.getAlias());
        if (name == null) {
            throw new IllegalArgumentException(String.format("Mandatory property [%s] is not defined", new Object[]{ConfigKey.NAME}));
        }
        return Collections.singletonList(ImageConfiguration.builder().name(name).alias(alias).run(run).build(build).watch(watch).build());
    }

    private static boolean isStringValueNull(ValueProvider valueProvider, BuildConfiguration config, ConfigKey key, Supplier<String> supplier) {
        return valueProvider.getString(key, config == null ? null : supplier.get()) != null;
    }

    private boolean buildConfigured(BuildConfiguration config, ValueProvider valueProvider, JavaProject project) {
        if (PropertyConfigHandler.isStringValueNull(valueProvider, config, ConfigKey.FROM, () -> ((BuildConfiguration)config).getFrom())) {
            return true;
        }
        if (valueProvider.getMap(ConfigKey.FROM_EXT, config == null ? null : config.getFromExt()) != null) {
            return true;
        }
        if (PropertyConfigHandler.isStringValueNull(valueProvider, config, ConfigKey.DOCKER_FILE, () -> ((BuildConfiguration)config).getDockerFileRaw())) {
            return true;
        }
        if (PropertyConfigHandler.isStringValueNull(valueProvider, config, ConfigKey.DOCKER_ARCHIVE, () -> ((BuildConfiguration)config).getDockerArchiveRaw())) {
            return true;
        }
        if (PropertyConfigHandler.isStringValueNull(valueProvider, config, ConfigKey.CONTEXT_DIR, () -> ((BuildConfiguration)config).getContextDirRaw())) {
            return true;
        }
        return new File(project.getBaseDirectory(), "Dockerfile").exists();
    }

    private static <T, R> R valueOrNull(T input, Function<T, R> function) {
        return Optional.ofNullable(input).map(function).orElse(null);
    }

    private BuildConfiguration extractBuildConfiguration(ImageConfiguration fromConfig, ValueProvider valueProvider, JavaProject project) {
        BuildConfiguration config = fromConfig.getBuildConfiguration();
        if (!this.buildConfigured(config, valueProvider, project)) {
            return null;
        }
        return BuildConfiguration.builder().cmd(this.extractArguments(valueProvider, ConfigKey.CMD, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getCmd))).cleanup(valueProvider.getString(ConfigKey.CLEANUP, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getCleanup))).nocache(valueProvider.getBoolean(ConfigKey.NOCACHE, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getNocache))).cacheFrom(this.extractCacheFrom(valueProvider.getString(ConfigKey.CACHEFROM, config == null ? null : (config.getCacheFrom() == null ? null : config.getCacheFrom().toString())), new String[0])).optimise(valueProvider.getBoolean(ConfigKey.OPTIMISE, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getOptimise))).entryPoint(this.extractArguments(valueProvider, ConfigKey.ENTRYPOINT, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getEntryPoint))).assembly(this.extractAssembly(PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getAssembly), valueProvider)).env(MapUtil.mergeMaps(valueProvider.getMap(ConfigKey.ENV_BUILD, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getEnv)), valueProvider.getMap(ConfigKey.ENV, Collections.emptyMap()))).args(valueProvider.getMap(ConfigKey.ARGS, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getArgs))).labels(valueProvider.getMap(ConfigKey.LABELS, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getLabels))).ports(this.extractPortValues(PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getPorts), valueProvider)).shell(this.extractArguments(valueProvider, ConfigKey.SHELL, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getShell))).runCmds(valueProvider.getList(ConfigKey.RUN, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getRunCmds))).from(valueProvider.getString(ConfigKey.FROM, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getFrom))).fromExt(valueProvider.getMap(ConfigKey.FROM_EXT, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getFromExt))).volumes(valueProvider.getList(ConfigKey.VOLUMES, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getVolumes))).tags(valueProvider.getList(ConfigKey.TAGS, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getTags))).maintainer(valueProvider.getString(ConfigKey.MAINTAINER, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getMaintainer))).workdir(valueProvider.getString(ConfigKey.WORKDIR, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getWorkdir))).skip(valueProvider.getBoolean(ConfigKey.SKIP_BUILD, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getSkip))).imagePullPolicy(valueProvider.getString(ConfigKey.IMAGE_PULL_POLICY_BUILD, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getImagePullPolicy))).contextDir(valueProvider.getString(ConfigKey.CONTEXT_DIR, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getContextDirRaw))).dockerArchive(valueProvider.getString(ConfigKey.DOCKER_ARCHIVE, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getDockerArchiveRaw))).dockerFile(valueProvider.getString(ConfigKey.DOCKER_FILE, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getDockerFileRaw))).buildOptions(valueProvider.getMap(ConfigKey.BUILD_OPTIONS, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getBuildOptions))).filter(valueProvider.getString(ConfigKey.FILTER, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getFilter))).user(valueProvider.getString(ConfigKey.USER, PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getUser))).healthCheck(this.extractHealthCheck(PropertyConfigHandler.valueOrNull(config, BuildConfiguration::getHealthCheck), valueProvider)).build();
    }

    private RunImageConfiguration extractRunConfiguration(ImageConfiguration fromConfig, ValueProvider valueProvider) {
        RunImageConfiguration config = fromConfig.getRunConfiguration();
        if (config.isDefault()) {
            config = null;
        }
        return RunImageConfiguration.builder().capAdd(valueProvider.getList(ConfigKey.CAP_ADD, config == null ? null : config.getCapAdd())).capDrop(valueProvider.getList(ConfigKey.CAP_DROP, config == null ? null : config.getCapDrop())).securityOpts(valueProvider.getList(ConfigKey.SECURITY_OPTS, config == null ? null : config.getSecurityOpts())).cmd(this.extractArguments(valueProvider, ConfigKey.CMD, config == null ? null : config.getCmd())).dns(valueProvider.getList(ConfigKey.DNS, config == null ? null : config.getDns())).dependsOn(valueProvider.getList(ConfigKey.DEPENDS_ON, config == null ? null : config.getDependsOn())).net(valueProvider.getString(ConfigKey.NET, config == null ? null : config.getNet())).network(this.extractNetworkConfig(config == null ? null : config.getNetworkingConfig(), valueProvider)).dnsSearch(valueProvider.getList(ConfigKey.DNS_SEARCH, config == null ? null : config.getDnsSearch())).domainname(valueProvider.getString(ConfigKey.DOMAINNAME, config == null ? null : config.getDomainname())).entrypoint(this.extractArguments(valueProvider, ConfigKey.ENTRYPOINT, config == null ? null : config.getEntrypoint())).env(MapUtil.mergeMaps(valueProvider.getMap(ConfigKey.ENV_RUN, config == null ? null : config.getEnv()), valueProvider.getMap(ConfigKey.ENV, Collections.emptyMap()))).labels(valueProvider.getMap(ConfigKey.LABELS, config == null ? null : config.getLabels())).envPropertyFile(valueProvider.getString(ConfigKey.ENV_PROPERTY_FILE, config == null ? null : config.getEnvPropertyFile())).extraHosts(valueProvider.getList(ConfigKey.EXTRA_HOSTS, config == null ? null : config.getExtraHosts())).hostname(valueProvider.getString(ConfigKey.HOSTNAME, config == null ? null : config.getHostname())).links(valueProvider.getList(ConfigKey.LINKS, config == null ? null : config.getLinks())).memory(valueProvider.getLong(ConfigKey.MEMORY, config == null ? null : config.getMemory())).memorySwap(valueProvider.getLong(ConfigKey.MEMORY_SWAP, config == null ? null : config.getMemorySwap())).containerNamePattern(valueProvider.getString(ConfigKey.CONTAINER_NAME_PATTERN, config == null ? null : config.getContainerNamePattern())).exposedPropertyKey(valueProvider.getString(ConfigKey.EXPOSED_PROPERTY_KEY, config == null ? null : config.getExposedPropertyKey())).portPropertyFile(valueProvider.getString(ConfigKey.PORT_PROPERTY_FILE, config == null ? null : config.getPortPropertyFile())).ports(valueProvider.getList(ConfigKey.PORTS, config == null ? null : config.getPorts())).shmSize(valueProvider.getLong(ConfigKey.SHMSIZE, config == null ? null : config.getShmSize())).privileged(valueProvider.getBoolean(ConfigKey.PRIVILEGED, config == null ? null : config.getPrivileged())).restartPolicy(this.extractRestartPolicy(config == null ? null : config.getRestartPolicy(), valueProvider)).user(valueProvider.getString(ConfigKey.USER, config == null ? null : config.getUser())).workingDir(valueProvider.getString(ConfigKey.WORKING_DIR, config == null ? null : config.getWorkingDir())).log(this.extractLogConfig(config == null ? null : config.getLog(), valueProvider)).wait(this.extractWaitConfig(config == null ? null : config.getWait(), valueProvider)).volumes(this.extractVolumeConfig(config == null ? null : config.getVolumeConfiguration(), valueProvider)).skip(valueProvider.getBoolean(ConfigKey.SKIP_RUN, config == null ? null : config.getSkip())).imagePullPolicy(valueProvider.getString(ConfigKey.IMAGE_PULL_POLICY_RUN, config == null ? null : config.getImagePullPolicy())).ulimits(this.extractUlimits(config == null ? null : config.getUlimits(), valueProvider)).tmpfs(valueProvider.getList(ConfigKey.TMPFS, config == null ? null : config.getTmpfs())).cpuShares(valueProvider.getLong(ConfigKey.CPUSHARES, config == null ? null : config.getCpuShares())).cpus(valueProvider.getLong(ConfigKey.CPUS, config == null ? null : config.getCpus())).cpuSet(valueProvider.getString(ConfigKey.CPUSET, config == null ? null : config.getCpuSet())).readOnly(valueProvider.getBoolean(ConfigKey.READ_ONLY, config == null ? null : config.getReadOnly())).autoRemove(valueProvider.getBoolean(ConfigKey.AUTO_REMOVE, config == null ? null : config.getAutoRemove())).build();
    }

    List<String> extractCacheFrom(String cacheFrom, String ... more) {
        if (more == null || more.length == 0) {
            return Collections.singletonList(cacheFrom);
        }
        return Stream.concat(Stream.of(cacheFrom), Arrays.stream(more)).collect(Collectors.toList());
    }

    private NetworkConfig extractNetworkConfig(NetworkConfig config, ValueProvider valueProvider) {
        return NetworkConfig.builder().modeString(valueProvider.getString(ConfigKey.NETWORK_MODE, config == null || config.getMode() == null ? null : config.getMode().name())).name(valueProvider.getString(ConfigKey.NETWORK_NAME, config == null ? null : config.getName())).aliases(valueProvider.getList(ConfigKey.NETWORK_ALIAS, config == null ? null : config.getAliases())).build();
    }

    private AssemblyConfiguration extractAssembly(AssemblyConfiguration config, ValueProvider valueProvider) {
        return AssemblyConfiguration.builder().targetDir(valueProvider.getString(ConfigKey.ASSEMBLY_BASEDIR, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getTargetDir))).exportTargetDir(valueProvider.getBoolean(ConfigKey.ASSEMBLY_EXPORT_TARGET_DIR, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getExportTargetDir))).permissionsString(valueProvider.getString(ConfigKey.ASSEMBLY_PERMISSIONS, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getPermissionsRaw))).user(valueProvider.getString(ConfigKey.ASSEMBLY_USER, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getUser))).modeString(valueProvider.getString(ConfigKey.ASSEMBLY_MODE, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getModeRaw))).tarLongFileMode(valueProvider.getString(ConfigKey.ASSEMBLY_TARLONGFILEMODE, PropertyConfigHandler.valueOrNull(config, AssemblyConfiguration::getTarLongFileMode))).build();
    }

    private HealthCheckConfiguration extractHealthCheck(HealthCheckConfiguration config, ValueProvider valueProvider) {
        Map<String, String> healthCheckProperties = valueProvider.getMap(ConfigKey.HEALTHCHECK, Collections.emptyMap());
        if (healthCheckProperties != null && healthCheckProperties.size() > 0) {
            return HealthCheckConfiguration.builder().interval(valueProvider.getString(ConfigKey.HEALTHCHECK_INTERVAL, PropertyConfigHandler.valueOrNull(config, HealthCheckConfiguration::getInterval))).timeout(valueProvider.getString(ConfigKey.HEALTHCHECK_TIMEOUT, PropertyConfigHandler.valueOrNull(config, HealthCheckConfiguration::getTimeout))).startPeriod(valueProvider.getString(ConfigKey.HEALTHCHECK_START_PERIOD, PropertyConfigHandler.valueOrNull(config, HealthCheckConfiguration::getStartPeriod))).retries(valueProvider.getInteger(ConfigKey.HEALTHCHECK_RETRIES, PropertyConfigHandler.valueOrNull(config, HealthCheckConfiguration::getRetries))).modeString(valueProvider.getString(ConfigKey.HEALTHCHECK_MODE, config == null || config.getMode() == null ? null : config.getMode().name())).cmd(this.extractArguments(valueProvider, ConfigKey.HEALTHCHECK_CMD, PropertyConfigHandler.valueOrNull(config, HealthCheckConfiguration::getCmd))).build();
        }
        return config;
    }

    private List<String> extractPortValues(List<String> config, ValueProvider valueProvider) {
        ArrayList<String> ret = new ArrayList<String>();
        List<String> ports = valueProvider.getList(ConfigKey.PORTS, config);
        if (ports == null) {
            return null;
        }
        List parsedPorts = EnvUtil.splitOnLastColon(ports);
        for (String[] port : parsedPorts) {
            ret.add(port[1]);
        }
        return ret;
    }

    private Arguments extractArguments(ValueProvider valueProvider, ConfigKey configKey, Arguments alternative) {
        return valueProvider.getObject(configKey, alternative, raw -> raw != null ? Arguments.builder().shell(raw).build() : null);
    }

    private RestartPolicy extractRestartPolicy(RestartPolicy config, ValueProvider valueProvider) {
        return RestartPolicy.builder().name(valueProvider.getString(ConfigKey.RESTART_POLICY_NAME, config == null ? null : config.getName())).retry(valueProvider.getInt(ConfigKey.RESTART_POLICY_RETRY, config == null || config.getRetry() == 0 ? null : Integer.valueOf(config.getRetry()))).build();
    }

    private LogConfiguration extractLogConfig(LogConfiguration config, ValueProvider valueProvider) {
        return LogConfiguration.builder().color(valueProvider.getString(ConfigKey.LOG_COLOR, config == null ? null : config.getColor())).date(valueProvider.getString(ConfigKey.LOG_DATE, config == null ? null : config.getDate())).file(valueProvider.getString(ConfigKey.LOG_FILE, config == null ? null : config.getFileLocation())).prefix(valueProvider.getString(ConfigKey.LOG_PREFIX, config == null ? null : config.getPrefix())).driverName(valueProvider.getString(ConfigKey.LOG_DRIVER_NAME, config == null || config.getDriver() == null ? null : config.getDriver().getName())).logDriverOpts(valueProvider.getMap(ConfigKey.LOG_DRIVER_OPTS, config == null || config.getDriver() == null ? null : config.getDriver().getOpts())).enabled(valueProvider.getBoolean(ConfigKey.LOG_ENABLED, Optional.ofNullable(config).map(LogConfiguration::isEnabled).orElse(false))).build();
    }

    private WaitConfiguration extractWaitConfig(WaitConfiguration config, ValueProvider valueProvider) {
        String url = valueProvider.getString(ConfigKey.WAIT_HTTP_URL, config == null ? null : config.getUrl());
        if (url == null) {
            url = valueProvider.getString(ConfigKey.WAIT_URL, config == null ? null : config.getUrl());
        }
        WaitConfiguration.ExecConfiguration exec = config == null ? null : config.getExec();
        WaitConfiguration.TcpConfiguration tcp = config == null ? null : config.getTcp();
        WaitConfiguration.HttpConfiguration http = config == null ? null : config.getHttp();
        return WaitConfiguration.builder().time(Integer.valueOf(valueProvider.getInt(ConfigKey.WAIT_TIME, config == null ? null : config.getTime()))).healthy(valueProvider.getBoolean(ConfigKey.WAIT_HEALTHY, config == null ? null : config.getHealthy())).url(url).preStop(valueProvider.getString(ConfigKey.WAIT_EXEC_PRE_STOP, exec == null ? null : exec.getPreStop())).postStart(valueProvider.getString(ConfigKey.WAIT_EXEC_POST_START, exec == null ? null : exec.getPostStart())).breakOnError(valueProvider.getBoolean(ConfigKey.WAIT_EXEC_BREAK_ON_ERROR, exec == null ? null : Boolean.valueOf(exec.isBreakOnError()))).method(valueProvider.getString(ConfigKey.WAIT_HTTP_METHOD, http == null ? null : http.getMethod())).status(valueProvider.getString(ConfigKey.WAIT_HTTP_STATUS, http == null ? null : http.getStatus())).log(valueProvider.getString(ConfigKey.WAIT_LOG, config == null ? null : config.getLog())).kill(valueProvider.getInteger(ConfigKey.WAIT_KILL, config == null ? null : config.getKill())).exit(valueProvider.getInteger(ConfigKey.WAIT_EXIT, config == null ? null : config.getExit())).shutdown(valueProvider.getInteger(ConfigKey.WAIT_SHUTDOWN, config == null ? null : config.getShutdown())).tcpHost(valueProvider.getString(ConfigKey.WAIT_TCP_HOST, tcp == null ? null : tcp.getHost())).tcpPorts(valueProvider.getIntList(ConfigKey.WAIT_TCP_PORT, tcp == null ? null : tcp.getPorts())).tcpModeString(valueProvider.getString(ConfigKey.WAIT_TCP_MODE, tcp == null || tcp.getMode() == null ? null : tcp.getMode().name())).build();
    }

    private WatchImageConfiguration extractWatchConfig(ImageConfiguration fromConfig, ValueProvider valueProvider) {
        WatchImageConfiguration config = fromConfig.getWatchConfiguration();
        return WatchImageConfiguration.builder().interval(valueProvider.getInteger(ConfigKey.WATCH_INTERVAL, config == null ? null : config.getIntervalRaw())).postGoal(valueProvider.getString(ConfigKey.WATCH_POSTGOAL, config == null ? null : config.getPostGoal())).postExec(valueProvider.getString(ConfigKey.WATCH_POSTEXEC, config == null ? null : config.getPostExec())).modeString(valueProvider.getString(ConfigKey.WATCH_POSTGOAL, config == null || config.getMode() == null ? null : config.getMode().name())).build();
    }

    private List<UlimitConfig> extractUlimits(List<UlimitConfig> config, ValueProvider valueProvider) {
        List<String> ulimits;
        ArrayList<String> other = null;
        if (config != null) {
            other = new ArrayList<String>();
            for (UlimitConfig ulimitConfig : config) {
                other.add(ulimitConfig.serialize());
            }
        }
        if ((ulimits = valueProvider.getList(ConfigKey.ULIMITS, other)) == null) {
            return null;
        }
        ArrayList<UlimitConfig> ret = new ArrayList<UlimitConfig>();
        for (String ulimit : ulimits) {
            ret.add(new UlimitConfig(ulimit));
        }
        return ret;
    }

    private RunVolumeConfiguration extractVolumeConfig(RunVolumeConfiguration config, ValueProvider valueProvider) {
        return RunVolumeConfiguration.builder().bind(valueProvider.getList(ConfigKey.BIND, config == null ? null : config.getBind())).from(valueProvider.getList(ConfigKey.VOLUMES_FROM, config == null ? null : config.getFrom())).build();
    }

    private static String getPrefix(Map<String, String> externalConfig) {
        String prefix = externalConfig.get("prefix");
        if (prefix == null) {
            prefix = DEFAULT_PREFIX;
        }
        return prefix;
    }

    private static PropertyMode getMode(Map<String, String> externalConfig) {
        return PropertyMode.parse(externalConfig.get("mode"));
    }

    public static boolean canCoexistWithOtherPropertyConfiguredImages(Map<String, String> externalConfig) {
        if (externalConfig == null || externalConfig.isEmpty()) {
            return false;
        }
        if (!TYPE_NAME.equals(externalConfig.get("type"))) {
            return true;
        }
        return externalConfig.get("prefix") != null;
    }
}

