/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.helper;

import com.google.common.base.Strings;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jkube.kit.build.service.docker.helper.ConfigHelper;
import org.eclipse.jkube.kit.build.service.docker.helper.FormatParameterReplacer;
import org.eclipse.jkube.kit.common.JavaProject;

public class ImageNameFormatter
implements ConfigHelper.NameFormatter {
    public static final String DOCKER_IMAGE_USER = "jkube.image.user";
    private final FormatParameterReplacer formatParamReplacer;
    private final Date now;

    public ImageNameFormatter(JavaProject project, Date now) {
        this.now = now;
        this.formatParamReplacer = new FormatParameterReplacer(this.initLookups(project));
    }

    @Override
    public String format(String name) {
        if (name == null) {
            return null;
        }
        return this.formatParamReplacer.replace(name);
    }

    private Map<String, FormatParameterReplacer.Lookup> initLookups(JavaProject project) {
        HashMap<String, FormatParameterReplacer.Lookup> lookups = new HashMap<String, FormatParameterReplacer.Lookup>();
        lookups.put("g", new DefaultUserLookup(project));
        lookups.put("a", new DefaultNameLookup(project));
        lookups.put("v", new DefaultTagLookup(project, DefaultTagLookup.Mode.PLAIN, this.now));
        lookups.put("t", new DefaultTagLookup(project, DefaultTagLookup.Mode.SNAPSHOT_WITH_TIMESTAMP, this.now));
        lookups.put("l", new DefaultTagLookup(project, DefaultTagLookup.Mode.SNAPSHOT_LATEST, this.now));
        return lookups;
    }

    private static String sanitizeName(String name) {
        StringBuilder ret = new StringBuilder();
        int underscores = 0;
        boolean lastWasADot = false;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                if (++underscores > 2) continue;
                ret.append(c);
                continue;
            }
            if (c == '.') {
                if (!lastWasADot) {
                    ret.append(c);
                }
                lastWasADot = true;
                continue;
            }
            underscores = 0;
            lastWasADot = false;
            if (!Character.isLetter(c) && !Character.isDigit(c) && c != '-') continue;
            ret.append(c);
        }
        return ret.toString().toLowerCase();
    }

    private static class DefaultTagLookup
    extends AbstractLookup {
        private static final String DOCKER_IMAGE_TAG = "jkube.image.tag";
        private final Mode mode;
        private final Date now;

        private DefaultTagLookup(JavaProject project, Mode mode, Date now) {
            super(project);
            this.mode = mode;
            this.now = now;
        }

        @Override
        public String lookup() {
            String tag = this.getProperty(DOCKER_IMAGE_TAG);
            if (!Strings.isNullOrEmpty((String)tag)) {
                return tag;
            }
            tag = this.project.getVersion();
            if (this.mode != Mode.PLAIN && tag.endsWith("-SNAPSHOT")) {
                if (this.mode == Mode.SNAPSHOT_WITH_TIMESTAMP) {
                    tag = "snapshot-" + new SimpleDateFormat("yyMMdd-HHmmss-SSSS").format(this.now);
                } else if (this.mode == Mode.SNAPSHOT_LATEST) {
                    tag = "latest";
                }
            }
            return tag;
        }

        private static enum Mode {
            PLAIN,
            SNAPSHOT_WITH_TIMESTAMP,
            SNAPSHOT_LATEST;

        }
    }

    private static class DefaultNameLookup
    extends AbstractLookup {
        private DefaultNameLookup(JavaProject project) {
            super(project);
        }

        @Override
        public String lookup() {
            return ImageNameFormatter.sanitizeName(this.project.getArtifactId());
        }
    }

    private static class DefaultUserLookup
    extends AbstractLookup {
        private DefaultUserLookup(JavaProject project) {
            super(project);
        }

        @Override
        public String lookup() {
            String user = this.getProperty(ImageNameFormatter.DOCKER_IMAGE_USER);
            if (user != null) {
                return user;
            }
            String groupId = this.project.getGroupId();
            while (groupId.endsWith(".")) {
                groupId = groupId.substring(0, groupId.length() - 1);
            }
            int idx = groupId.lastIndexOf(".");
            return ImageNameFormatter.sanitizeName(groupId.substring(idx != -1 ? idx + 1 : 0));
        }
    }

    public static abstract class AbstractLookup
    implements FormatParameterReplacer.Lookup {
        protected final JavaProject project;

        private AbstractLookup(JavaProject project) {
            this.project = project;
        }

        protected String getProperty(String key) {
            return this.project.getProperties().getProperty(key);
        }
    }
}

