/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.build.service.docker.helper;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Timestamp
implements Comparable<Timestamp> {
    private LocalDateTime date;
    private int rest;
    private static final Pattern TS_PATTERN = Pattern.compile("^(.*?)(?:\\.(\\d{3})(\\d*))?(Z|[+\\-][\\d:]+)?$", 2);

    public Timestamp() {
        this.date = LocalDateTime.now();
    }

    public Timestamp(String spec) {
        Matcher matcher = TS_PATTERN.matcher(spec);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid timestamp '" + spec + "' given.");
        }
        String millis = matcher.group(2);
        String rest = matcher.group(3);
        this.rest = rest != null ? Integer.parseInt(rest) : 0;
        this.date = LocalDateTime.parse(matcher.group(1) + (millis != null ? "." + millis : ".000") + matcher.group(4), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public LocalDateTime getDate() {
        return this.date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timestamp timestamp = (Timestamp)o;
        if (this.rest != timestamp.rest) {
            return false;
        }
        return this.date.equals(timestamp.date);
    }

    public int hashCode() {
        int result = this.date.hashCode();
        result = 31 * result + (this.rest ^ this.rest >>> 32);
        return result;
    }

    @Override
    public int compareTo(Timestamp ts) {
        int fc = this.date.compareTo(ts.date);
        if (fc != 0) {
            return fc;
        }
        return this.rest - ts.rest;
    }

    public String toString() {
        return this.date.toString();
    }
}

