/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ccp extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "\u09f3" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMM", "TMM" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "adp", "\ud804\udd03\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd2e\ud804\udd22\ud804\udd1a\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2c\ud804\udd16" },
            { "aed", "\ud804\udd0e\ud804\udd27\ud804\udd19 \ud804\udd03\ud804\udd22\ud804\udd27\ud804\udd1d\ud804\udd34 \ud804\udd03\ud804\udd1f\ud804\udd28\ud804\udd22\ud804\udd16\ud804\udd34 \ud804\udd18\ud804\udd28\ud804\udd22\ud804\udd34\ud804\udd26\ud804\udd1f\ud804\udd34" },
            { "afa", "\ud804\udd03\ud804\udd1b\ud804\udd34\ud804\udd09\ud804\udd1a\ud804\udd28 (\ud804\udd37\ud804\udd3f\ud804\udd38\ud804\udd3d-\ud804\udd38\ud804\udd36\ud804\udd36\ud804\udd38)" },
            { "afn", "\ud804\udd03\ud804\udd1c\ud804\udd34\ud804\udd09\ud804\udd1a\ud804\udd34 \ud804\udd03\ud804\udd1c\ud804\udd34\ud804\udd09\ud804\udd1a\ud804\udd28" },
            { "all", "\ud804\udd03\ud804\udd23\ud804\udd34\ud804\udd1d\ud804\udd2c\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd23\ud804\udd2c\ud804\udd07\ud804\udd34" },
            { "amd", "\ud804\udd03\ud804\udd22\ud804\udd34\ud804\udd1f\ud804\udd2c\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd18\ud804\udd33\ud804\udd22\ud804\udd1f\ud804\udd34" },
            { "ang", "\ud804\udd1a\ud804\udd2c\ud804\udd18\ud804\udd22\ud804\udd34\ud804\udd23\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd34 \ud804\udd03\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd34\ud804\udd11\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd09\ud804\udd2a\ud804\udd23\ud804\udd34\ud804\udd13\ud804\udd2c\ud804\udd22\ud804\udd34" },
            { "aoa", "\ud804\udd03\ud804\udd33\ud804\udd20\ud804\udd0b\ud804\udd34\ud804\udd09\ud804\udd2e\ud804\udd23\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd27\ud804\udd24\ud804\udd2e\ud804\udd1a\ud804\udd34\ud804\udd0e" },
            { "aok", "\ud804\udd03\ud804\udd33\ud804\udd20\ud804\udd0b\ud804\udd34\ud804\udd09\ud804\udd2e\ud804\udd23\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd27\ud804\udd24\ud804\udd2e\ud804\udd1a\ud804\udd34\ud804\udd0e(\ud804\udd37\ud804\udd3f\ud804\udd3d\ud804\udd3d-\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd36)" },
            { "aon", "\ud804\udd03\ud804\udd33\ud804\udd20\ud804\udd0b\ud804\udd34\ud804\udd09\ud804\udd2e\ud804\udd23\ud804\udd1a\ud804\udd34 \ud804\udd1a\ud804\udd31 \ud804\udd07\ud804\udd27\ud804\udd24\ud804\udd2e\ud804\udd1a\ud804\udd34\ud804\udd0e(\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd3b-\ud804\udd38\ud804\udd36\ud804\udd36\ud804\udd36)" },
            { "aor", "\ud804\udd03\ud804\udd33\ud804\udd20\ud804\udd0b\ud804\udd34\ud804\udd09\ud804\udd2e\ud804\udd23\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd27\ud804\udd24\ud804\udd2e\ud804\udd1a\ud804\udd34\ud804\udd0e(\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd3b-\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd3f)" },
            { "ara", "\ud804\udd03\ud804\udd22\ud804\udd34\ud804\udd0e\ud804\udd2c\ud804\udd1a\ud804\udd34\ud804\udd11\ud804\udd28\ud804\udd1a \ud804\udd03\ud804\udd27\ud804\udd0c\ud804\udd34\ud804\udd11\ud804\udd33\ud804\udd22\ud804\udd23\ud804\udd34" },
            { "arp", "\ud804\udd03\ud804\udd22\ud804\udd34\ud804\udd0e\ud804\udd2c\ud804\udd1a\ud804\udd34\ud804\udd11\ud804\udd28\ud804\udd1a \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e (\ud804\udd37\ud804\udd3f\ud804\udd3e\ud804\udd39-\ud804\udd37\ud804\udd3f\ud804\udd3e\ud804\udd3b)" },
            { "ars", "\ud804\udd03\ud804\udd22\ud804\udd34\ud804\udd0e\ud804\udd2c\ud804\udd1a\ud804\udd34\ud804\udd11\ud804\udd28\ud804\udd1a \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e" },
            { "ats", "\ud804\udd03\ud804\udd27\ud804\udd0c\ud804\udd34\ud804\udd11\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd25\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd01" },
            { "aud", "\ud804\udd03\ud804\udd27\ud804\udd0c\ud804\udd34\ud804\udd11\ud804\udd33\ud804\udd22\ud804\udd2c\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "awg", "\ud804\udd03\ud804\udd22\ud804\udd2a\ud804\udd1d \ud804\udd09\ud804\udd28\ud804\udd23\ud804\udd34\ud804\udd13\ud804\udd22\ud804\udd34" },
            { "azm", "\ud804\udd03\ud804\udd0e\ud804\udd22\ud804\udd34\ud804\udd1d\ud804\udd2d\ud804\udd0e\ud804\udd1a\ud804\udd34 \ud804\udd1f\ud804\udd1a\ud804\udd16\ud804\udd34 (\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd39-\ud804\udd38\ud804\udd36\ud804\udd36\ud804\udd3c)" },
            { "azn", "\ud804\udd03\ud804\udd0e\ud804\udd22\ud804\udd34\ud804\udd1d\ud804\udd2d\ud804\udd0e\ud804\udd1a\ud804\udd34 \ud804\udd1f\ud804\udd1a\ud804\udd16\ud804\udd34" },
            { "bad", "\ud804\udd1d\ud804\udd27\ud804\udd25\ud804\udd34\ud804\udd1a\ud804\udd28\ud804\udd20 \ud804\udd03\ud804\udd33\ud804\udd03 \ud804\udd26\ud804\udd22\ud804\udd34\ud804\udd0e\ud804\udd2c\ud804\udd09\ud804\udd2e\ud804\udd1e\ud804\udd28\ud804\udd1a \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "bam", "\ud804\udd1d\ud804\udd27\ud804\udd25\ud804\udd34\ud804\udd1a\ud804\udd28\ud804\udd20 \ud804\udd03\ud804\udd33\ud804\udd03 \ud804\udd26\ud804\udd22\ud804\udd34\ud804\udd0e\ud804\udd2c\ud804\udd09\ud804\udd2e\ud804\udd1e\ud804\udd28\ud804\udd1a \ud804\udd1f\ud804\udd22\ud804\udd34\ud804\udd07\ud804\udd34" },
            { "bbd", "\ud804\udd1d\ud804\udd22\ud804\udd34\ud804\udd1d\ud804\udd2c\ud804\udd13\ud804\udd2e\ud804\udd0e\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "bdt", "\ud804\udd1d\ud804\udd01\ud804\udd23\ud804\udd18\ud804\udd2c\ud804\udd25\ud804\udd28 \ud804\udd11\ud804\udd2c\ud804\udd0b" },
            { "bec", "\ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd34\ud804\udd18\ud804\udd0e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd34\ud804\udd07\ud804\udd34 (\ud804\udd1d\ud804\udd2e\ud804\udd18\ud804\udd2e\ud804\udd23\ud804\udd2c\ud804\udd2d\ud804\udd1b\ud804\udd22\ud804\udd2c)" },
            { "bef", "\ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd34\ud804\udd18\ud804\udd0e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd34\ud804\udd07\ud804\udd34" },
            { "bel", "\ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd34\ud804\udd18\ud804\udd0e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd34\ud804\udd07\ud804\udd34 (\ud804\udd03\ud804\udd22\ud804\udd34\ud804\udd17\ud804\udd28\ud804\udd07\ud804\udd34)" },
            { "bgl", "\ud804\udd1d\ud804\udd2a\ud804\udd23\ud804\udd34\ud804\udd09\ud804\udd2c\ud804\udd22\ud804\udd29\ud804\udd20\ud804\udd27 \ud804\udd26\ud804\udd22\ud804\udd34\ud804\udd13\ud804\udd34 \ud804\udd23\ud804\udd2c\ud804\udd1e\ud804\udd34" },
            { "bgn", "\ud804\udd1d\ud804\udd2a\ud804\udd23\ud804\udd34\ud804\udd09\ud804\udd2c\ud804\udd22\ud804\udd29\ud804\udd20\ud804\udd27 \ud804\udd1a\ud804\udd31 \ud804\udd23\ud804\udd2c\ud804\udd1e\ud804\udd34" },
            { "bhd", "\ud804\udd1d\ud804\udd26\ud804\udd27\ud804\udd22\ud804\udd2d\ud804\udd1a\ud804\udd28 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "bif", "\ud804\udd1d\ud804\udd2a\ud804\udd22\ud804\udd2a\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd28 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd34\ud804\udd07\ud804\udd34" },
            { "bmd", "\ud804\udd1d\ud804\udd22\ud804\udd34\ud804\udd1f\ud804\udd28\ud804\udd05\ud804\udd2a\ud804\udd13\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "bnd", "\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd2a\ud804\udd1a\ud804\udd2c\ud804\udd2d \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "bob", "\ud804\udd1d\ud804\udd27\ud804\udd23\ud804\udd28\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd2e" },
            { "bop", "\ud804\udd1d\ud804\udd27\ud804\udd23\ud804\udd28\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e" },
            { "bov", "\ud804\udd1d\ud804\udd27\ud804\udd23\ud804\udd28\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1f\ud804\udd27\ud804\udd1e\ud804\udd34\ud804\udd13\ud804\udd2e\ud804\udd23\ud804\udd34" },
            { "brb", "\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd0e\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2a\ud804\udd0e\ud804\udd2c\ud804\udd20\ud804\udd27\ud804\udd22\ud804\udd2e\ud804\udd1a\ud804\udd2e\ud804\udd1e\ud804\udd2e (\ud804\udd37\ud804\udd3f\ud804\udd3c\ud804\udd3d-\ud804\udd37\ud804\udd3f\ud804\udd3e\ud804\udd3c)" },
            { "brc", "\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd0e\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2a\ud804\udd0e\ud804\udd2c\ud804\udd2d\ud804\udd13\ud804\udd05\ud804\udd2a" },
            { "bre", "\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd0e\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2a\ud804\udd0e\ud804\udd2c\ud804\udd20\ud804\udd27\ud804\udd22\ud804\udd2e (\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd36-\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd39)" },
            { "brl", "\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd0e\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd2c\ud804\udd23\ud804\udd34" },
            { "brn", "\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd0e\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd2a\ud804\udd0e\ud804\udd2c\ud804\udd2d\ud804\udd13\ud804\udd2e \ud804\udd1a\ud804\udd2e\ud804\udd1e\ud804\udd2e" },
            { "brr", "\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd0e\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd2a\ud804\udd0e\ud804\udd2c\ud804\udd20\ud804\udd27\ud804\udd22\ud804\udd2e" },
            { "bsd", "\ud804\udd1d\ud804\udd26\ud804\udd1f\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "btn", "\ud804\udd1e\ud804\udd2a\ud804\udd11\ud804\udd1a\ud804\udd28 \ud804\udd03\ud804\udd2c\ud804\udd1a\ud804\udd34\ud804\udd09\ud804\udd2a\ud804\udd23\ud804\udd34\ud804\udd11\ud804\udd33\ud804\udd22\ud804\udd1f\ud804\udd34\ud804\udd1b\ud804\udd34" },
            { "buk", "\ud804\udd1d\ud804\udd27\ud804\udd22\ud804\udd34\ud804\udd1f\ud804\udd28 \ud804\udd07\ud804\udd28\ud804\udd20\ud804\udd16\ud804\udd34" },
            { "bwp", "\ud804\udd1d\ud804\udd27\ud804\udd16\ud804\udd34\ud804\udd25\ud804\udd2e\ud804\udd20\ud804\udd1a \ud804\udd1b\ud804\udd2a\ud804\udd23" },
            { "byb", "\ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd22\ud804\udd2a\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1a\ud804\udd28\ud804\udd05\ud804\udd2a \ud804\udd22\ud804\udd2a\ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd34 (\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd3a-\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd3f)" },
            { "byn", "\ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd22\ud804\udd2a\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd34" },
            { "byr", "\ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd22\ud804\udd2a\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd34(\ud804\udd38\ud804\udd36\ud804\udd36\ud804\udd36-\ud804\udd38\ud804\udd36\ud804\udd37\ud804\udd3c)" },
            { "bzd", "\ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd28\ud804\udd0e\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "cad", "\ud804\udd07\ud804\udd1a\ud804\udd13\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "cdf", "\ud804\udd07\ud804\udd27\ud804\udd0b\ud804\udd34\ud804\udd09\ud804\udd2e\ud804\udd23\ud804\udd28\ud804\udd0c\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd01\ud804\udd07\ud804\udd34" },
            { "chf", "\ud804\udd25\ud804\udd2d\ud804\udd2a\ud804\udd25\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd00" },
            { "clf", "\ud804\udd0c\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd28\ud804\udd18\ud804\udd18\ud804\udd2c\ud804\udd25\ud804\udd34 \ud804\udd18\ud804\udd28 \ud804\udd1c\ud804\udd2e\ud804\udd1f\ud804\udd2c\ud804\udd1a\ud804\udd34\ud804\udd16\ud804\udd2e" },
            { "clp", "\ud804\udd0c\ud804\udd28\ud804\udd23\ud804\udd28 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e" },
            { "cny", "\ud804\udd0c\ud804\udd29\ud804\udd1a \ud804\udd20\ud804\udd2a\ud804\udd20\ud804\udd1a\ud804\udd34" },
            { "cop", "\ud804\udd07\ud804\udd27\ud804\udd23\ud804\udd2e\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e" },
            { "cou", "\ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd28\ud804\udd18\ud804\udd16\ud804\udd34 \ud804\udd18\ud804\udd28 \ud804\udd1e\ud804\udd33\ud804\udd20\ud804\udd23\ud804\udd2e\ud804\udd22\ud804\udd34 \ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd2c\ud804\udd23\ud804\udd34" },
            { "crc", "\ud804\udd07\ud804\udd2e\ud804\udd25\ud804\udd34\ud804\udd11\ud804\udd22\ud804\udd28\ud804\udd07 \ud804\udd07\ud804\udd2e\ud804\udd23\ud804\udd2e\ud804\udd1a\ud804\udd34" },
            { "csd", "\ud804\udd1b\ud804\udd2a\ud804\udd22\ud804\udd2e\ud804\udd1a\ud804\udd28 \ud804\udd25\ud804\udd22\ud804\udd34\ud804\udd1d\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "csk", "\ud804\udd0c\ud804\udd2c\ud804\udd07\ud804\udd2e\ud804\udd25\ud804\udd33\ud804\udd23\ud804\udd2e\ud804\udd1e\ud804\udd07\ud804\udd34 \ud804\udd26\ud804\udd22\ud804\udd34\ud804\udd13\ud804\udd34 \ud804\udd07\ud804\udd2e\ud804\udd22\ud804\udd2a\ud804\udd1a" },
            { "cuc", "\ud804\udd07\ud804\udd28\ud804\udd05\ud804\udd2a\ud804\udd1d\ud804\udd1a\ud804\udd34 \ud804\udd1d\ud804\udd2e\ud804\udd18\ud804\udd2e\ud804\udd23\ud804\udd28\ud804\udd1b\ud804\udd22\ud804\udd2c \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e" },
            { "cup", "\ud804\udd07\ud804\udd28\ud804\udd05\ud804\udd2a\ud804\udd1d\ud804\udd1a\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e" },
            { "cve", "\ud804\udd07\ud804\udd2c\ud804\udd1b\ud804\udd34 \ud804\udd1e\ud804\udd22\ud804\udd34\ud804\udd18\ud804\udd2c \ud804\udd03\ud804\udd2c\ud804\udd25\ud804\udd34\ud804\udd07\ud804\udd2a\ud804\udd13\ud804\udd2e" },
            { "cyp", "\ud804\udd25\ud804\udd2d\ud804\udd1b\ud804\udd33\ud804\udd22\ud804\udd25\ud804\udd34 \ud804\udd1b\ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd34" },
            { "czk", "\ud804\udd0c\ud804\udd2c\ud804\udd07\ud804\udd34 \ud804\udd1b\ud804\udd33\ud804\udd22\ud804\udd27\ud804\udd0e\ud804\udd16\ud804\udd27\ud804\udd1a\ud804\udd34\ud804\udd16\ud804\udd33\ud804\udd22\ud804\udd27 \ud804\udd07\ud804\udd2e\ud804\udd22\ud804\udd2a\ud804\udd1a" },
            { "ddm", "\ud804\udd1b\ud804\udd2a\ud804\udd09\ud804\udd2c\ud804\udd18\ud804\udd28 \ud804\udd0e\ud804\udd22\ud804\udd34\ud804\udd1f\ud804\udd1a\ud804\udd34 \ud804\udd1f\ud804\udd22\ud804\udd34\ud804\udd07\ud804\udd34" },
            { "dem", "\ud804\udd13\ud804\udd27\ud804\udd20\ud804\udd27\ud804\udd0c\ud804\udd34 \ud804\udd1f\ud804\udd22\ud804\udd34\ud804\udd07\ud804\udd34" },
            { "djf", "\ud804\udd0e\ud804\udd28\ud804\udd1d\ud804\udd2a\ud804\udd16\ud804\udd28 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd01\ud804\udd07\ud804\udd34" },
            { "dkk", "\ud804\udd13\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd28\ud804\udd0c\ud804\udd34 \ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2f\ud804\udd1a\ud804\udd34" },
            { "dop", "\ud804\udd13\ud804\udd2e\ud804\udd1f\ud804\udd28\ud804\udd1a\ud804\udd28\ud804\udd07\ud804\udd1a\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e" },
            { "dzd", "\ud804\udd03\ud804\udd22\ud804\udd34\ud804\udd0e\ud804\udd2c\ud804\udd22\ud804\udd29\ud804\udd20\ud804\udd27 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "ecs", "\ud804\udd03\ud804\udd28\ud804\udd07\ud804\udd2a\ud804\udd20\ud804\udd13\ud804\udd2e\ud804\udd22\ud804\udd34 \ud804\udd25\ud804\udd2a\ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2c" },
            { "ecv", "\ud804\udd03\ud804\udd28\ud804\udd07\ud804\udd2a\ud804\udd20\ud804\udd13\ud804\udd2e\ud804\udd22\ud804\udd34 \ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd28\ud804\udd18\ud804\udd18\ud804\udd2c\ud804\udd0c\ud804\udd34 \ud804\udd18\ud804\udd28 \ud804\udd1e\ud804\udd2c\ud804\udd23\ud804\udd27\ud804\udd22\ud804\udd34 \ud804\udd07\ud804\udd27\ud804\udd1a\ud804\udd34\ud804\udd25\ud804\udd34\ud804\udd16\ud804\udd1a\ud804\udd34\ud804\udd16\ud804\udd2c (\ud804\udd03\ud804\udd28\ud804\udd05\ud804\udd2a\ud804\udd1e\ud804\udd28\ud804\udd25\ud804\udd28)" },
            { "eek", "\ud804\udd03\ud804\udd2c\ud804\udd0c\ud804\udd34\ud804\udd16\ud804\udd2e\ud804\udd1a\ud804\udd28\ud804\udd20 \ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2a\ud804\udd1a\ud804\udd28" },
            { "egp", "\ud804\udd1f\ud804\udd28\ud804\udd25\ud804\udd27\ud804\udd22\ud804\udd29\ud804\udd20\ud804\udd34 \ud804\udd1b\ud804\udd05\ud804\udd2a\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd34" },
            { "ern", "\ud804\udd03\ud804\udd2c\ud804\udd22\ud804\udd28\ud804\udd11\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd2c\ud804\udd1a\ud804\udd34 \ud804\udd1a\ud804\udd07\ud804\udd34\ud804\udd1c" },
            { "esa", "\ud804\udd25\ud804\udd33\ud804\udd1b\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd28\ud804\udd25\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2c\ud804\udd16 (\ud804\udd03\ud804\udd2c\ud804\udd07\ud804\udd34\ud804\udd07\ud804\udd2d\ud804\udd2a \ud804\udd26\ud804\udd28\ud804\udd0e\ud804\udd2c\ud804\udd1b\ud804\udd34)" },
            { "esb", "\ud804\udd25\ud804\udd33\ud804\udd1b\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd28\ud804\udd25\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2c\ud804\udd16 (\ud804\udd1d\ud804\udd2e\ud804\udd18\ud804\udd2e\ud804\udd23\ud804\udd2c\ud804\udd2d \ud804\udd1b\ud804\udd22\ud804\udd2c \ud804\udd26\ud804\udd28\ud804\udd0e\ud804\udd2c\ud804\udd1b\ud804\udd34)" },
            { "esp", "\ud804\udd25\ud804\udd33\ud804\udd1b\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd28\ud804\udd25\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2c\ud804\udd16" },
            { "etb", "\ud804\udd03\ud804\udd28\ud804\udd17\ud804\udd28\ud804\udd03\ud804\udd2e\ud804\udd1b\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1d\ud804\udd28\ud804\udd22\ud804\udd34" },
            { "eur", "\ud804\udd03\ud804\udd28\ud804\udd05\ud804\udd2a\ud804\udd22\ud804\udd2e" },
            { "fim", "\ud804\udd1c\ud804\udd28\ud804\udd1a\ud804\udd28\ud804\udd25\ud804\udd34 \ud804\udd1f\ud804\udd22\ud804\udd34\ud804\udd07" },
            { "fjd", "\ud804\udd1c\ud804\udd28\ud804\udd0e\ud804\udd28 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "fkp", "\ud804\udd1c\ud804\udd27\ud804\udd07\ud804\udd34\ud804\udd23\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd34 \ud804\udd09\ud804\udd2d \ud804\udd09\ud804\udd2d \ud804\udd1e\ud804\udd28\ud804\udd18\ud804\udd2c \ud804\udd1b\ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd34" },
            { "frf", "\ud804\udd1c\ud804\udd27\ud804\udd22\ud804\udd25\ud804\udd28 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd01\ud804\udd07\ud804\udd34" },
            { "gbp", "\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd11\ud804\udd28\ud804\udd0c\ud804\udd34 \ud804\udd1b\ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd34" },
            { "gek", "\ud804\udd0e\ud804\udd27\ud804\udd22\ud804\udd34\ud804\udd0e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd2a\ud804\udd1b\ud804\udd27\ud804\udd1a\ud804\udd34 \ud804\udd23\ud804\udd22\ud804\udd28\ud804\udd16\ud804\udd34" },
            { "gel", "\ud804\udd0e\ud804\udd27\ud804\udd22\ud804\udd34\ud804\udd0e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd23\ud804\udd22\ud804\udd28" },
            { "ghc", "\ud804\udd0a\ud804\udd1a \ud804\udd25\ud804\udd2c\ud804\udd13\ud804\udd28 (\ud804\udd37\ud804\udd3f\ud804\udd3d\ud804\udd3f-\ud804\udd38\ud804\udd36\ud804\udd36\ud804\udd3d)" },
            { "ghs", "\ud804\udd0a\ud804\udd1a \ud804\udd25\ud804\udd2c\ud804\udd13\ud804\udd28" },
            { "gip", "\ud804\udd0e\ud804\udd28\ud804\udd1d\ud804\udd33\ud804\udd22\ud804\udd23\ud804\udd34\ud804\udd11\ud804\udd22\ud804\udd34 \ud804\udd1b\ud804\udd05\ud804\udd2a\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "gmd", "\ud804\udd09\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd28\ud804\udd20 \ud804\udd13\ud804\udd23\ud804\udd25\ud804\udd28" },
            { "gnf", "\ud804\udd09\ud804\udd28\ud804\udd1a\ud804\udd28 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd33\ud804\udd07\ud804\udd34" },
            { "gns", "\ud804\udd09\ud804\udd28\ud804\udd1a\ud804\udd28 \ud804\udd25\ud804\udd2d\ud804\udd23\ud804\udd28" },
            { "gqe", "\ud804\udd03\ud804\udd28\ud804\udd07\ud804\udd2a\ud804\udd20\ud804\udd2c\ud804\udd11\ud804\udd2e\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd23\ud804\udd34 \ud804\udd09\ud804\udd28\ud804\udd1a\ud804\udd28 \ud804\udd03\ud804\udd28\ud804\udd07\ud804\udd2a\ud804\udd20\ud804\udd28\ud804\udd23\ud804\udd28" },
            { "grd", "\ud804\udd09\ud804\udd33\ud804\udd22\ud804\udd29\ud804\udd07\ud804\udd34 \ud804\udd18\ud804\udd33\ud804\udd22\ud804\udd0c\ud804\udd34\ud804\udd1f" },
            { "gtq", "\ud804\udd09\ud804\udd2a\ud804\udd20\ud804\udd16\ud804\udd2c\ud804\udd1f\ud804\udd23\ud804\udd27 \ud804\udd07\ud804\udd2a\ud804\udd20\ud804\udd2c\ud804\udd16\ud804\udd34\ud804\udd0e\ud804\udd23\ud804\udd34" },
            { "gwe", "\ud804\udd1b\ud804\udd27\ud804\udd22\ud804\udd34\ud804\udd16\ud804\udd2a\ud804\udd09\ud804\udd28\ud804\udd0e\ud804\udd34 \ud804\udd09\ud804\udd28\ud804\udd1a\ud804\udd28 \ud804\udd03\ud804\udd2c\ud804\udd25\ud804\udd34\ud804\udd07\ud804\udd2a\ud804\udd13\ud804\udd2e" },
            { "gwp", "\ud804\udd09\ud804\udd28\ud804\udd1a\ud804\udd28 \ud804\udd25\ud804\udd28\ud804\udd25\ud804\udd05\ud804\udd2a \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e" },
            { "gyd", "\ud804\udd09\ud804\udd2d\ud804\udd20\ud804\udd2c\ud804\udd1a \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "hkd", "\ud804\udd26\ud804\udd27\ud804\udd01\ud804\udd07\ud804\udd27\ud804\udd01 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "hnl", "\ud804\udd26\ud804\udd2a\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd2a\ud804\udd22\ud804\udd25\ud804\udd34 \ud804\udd23\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1b\ud804\udd28\ud804\udd22" },
            { "hrd", "\ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2e\ud804\udd20\ud804\udd2c\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "hrk", "\ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2e\ud804\udd20\ud804\udd2c\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd2a\ud804\udd1a" },
            { "htg", "\ud804\udd26\ud804\udd2d\ud804\udd16\ud804\udd28 \ud804\udd09\ud804\udd2f\ud804\udd22\ud804\udd34\ud804\udd18\ud804\udd2c" },
            { "huf", "\ud804\udd26\ud804\udd0b\ud804\udd34\ud804\udd09\ud804\udd2c\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1c\ud804\udd2e\ud804\udd22\ud804\udd28\ud804\udd1a\ud804\udd33\ud804\udd11\ud804\udd34" },
            { "idr", "\ud804\udd03\ud804\udd28\ud804\udd1a\ud804\udd34\ud804\udd18\ud804\udd2e\ud804\udd1a\ud804\udd2c\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1b\ud804\udd28\ud804\udd20\ud804\udd33\ud804\udd26\ud804\udd34" },
            { "iep", "\ud804\udd03\ud804\udd28\ud804\udd22\ud804\udd28\ud804\udd0c\ud804\udd34 \ud804\udd1b\ud804\udd05\ud804\udd2a\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "ilp", "\ud804\udd03\ud804\udd28\ud804\udd25\ud804\udd33\ud804\udd22\ud804\udd2d\ud804\udd23\ud804\udd28 \ud804\udd1b\ud804\udd05\ud804\udd2a\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "ils", "\ud804\udd03\ud804\udd28\ud804\udd25\ud804\udd33\ud804\udd22\ud804\udd2d\ud804\udd23\ud804\udd28 \ud804\udd1a\ud804\udd31 \ud804\udd25\ud804\udd2c\ud804\udd07\ud804\udd2c\ud804\udd23\ud804\udd34" },
            { "inr", "\ud804\udd03\ud804\udd28\ud804\udd1a\ud804\udd34\ud804\udd18\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1b\ud804\udd28" },
            { "iqd", "\ud804\udd03\ud804\udd28\ud804\udd22\ud804\udd07\ud804\udd28 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "irr", "\ud804\udd03\ud804\udd28\ud804\udd22\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd23\ud804\udd34" },
            { "isk", "\ud804\udd03\ud804\udd2d\ud804\udd25\ud804\udd34\ud804\udd23\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34 \ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2f\ud804\udd1a\ud804\udd34" },
            { "itl", "\ud804\udd03\ud804\udd28\ud804\udd16\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd27 \ud804\udd23\ud804\udd28\ud804\udd22" },
            { "jmd", "\ud804\udd0e\ud804\udd1f\ud804\udd2d\ud804\udd07\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "jod", "\ud804\udd0e\ud804\udd27\ud804\udd22\ud804\udd34\ud804\udd13\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "jpy", "\ud804\udd0e\ud804\udd1b\ud804\udd1a\ud804\udd28 \ud804\udd03\ud804\udd28\ud804\udd20\ud804\udd2c\ud804\udd1a\ud804\udd34" },
            { "kes", "\ud804\udd07\ud804\udd2c\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd25\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd01" },
            { "kgs", "\ud804\udd07\ud804\udd28\ud804\udd22\ud804\udd34\ud804\udd09\ud804\udd28\ud804\udd0e\ud804\udd34\ud804\udd03\ud804\udd28\ud804\udd25\ud804\udd34\ud804\udd16\ud804\udd1a\ud804\udd34 \ud804\udd25\ud804\udd2e\ud804\udd1f\ud804\udd34" },
            { "khr", "\ud804\udd07\ud804\udd27\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd2e\ud804\udd13\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd2c\ud804\udd23\ud804\udd34" },
            { "kmf", "\ud804\udd07\ud804\udd27\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd2e\ud804\udd22\ud804\udd2e \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd33\ud804\udd07\ud804\udd34" },
            { "kpw", "\ud804\udd03\ud804\udd2a\ud804\udd16\ud804\udd34\ud804\udd16\ud804\udd2e\ud804\udd22\ud804\udd34 \ud804\udd07\ud804\udd2e\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd22\ud804\udd34 \ud804\udd03\ud804\udd2e\ud804\udd1a\ud804\udd34" },
            { "krw", "\ud804\udd18\ud804\udd27\ud804\udd09\ud804\udd28\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd2e\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd22\ud804\udd34 \ud804\udd03\ud804\udd2e\ud804\udd1a\ud804\udd34" },
            { "kwd", "\ud804\udd07\ud804\udd2a\ud804\udd20\ud804\udd2c\ud804\udd16\ud804\udd28 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "kyd", "\ud804\udd07\ud804\udd2c\ud804\udd1f\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd09\ud804\udd2d \ud804\udd09\ud804\udd2d \ud804\udd1e\ud804\udd28\ud804\udd18\ud804\udd2c\ud804\udd22\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "kzt", "\ud804\udd07\ud804\udd0e\ud804\udd08\ud804\udd25\ud804\udd34\ud804\udd16\ud804\udd1a\ud804\udd28 \ud804\udd11\ud804\udd2c\ud804\udd0b\ud804\udd34\ud804\udd09\ud804\udd2c" },
            { "lak", "\ud804\udd23\ud804\udd2c\ud804\udd05\ud804\udd2a\ud804\udd25\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd28\ud804\udd1b\ud804\udd34" },
            { "lbp", "\ud804\udd23\ud804\udd2c\ud804\udd1d\ud804\udd1a\ud804\udd28\ud804\udd0e\ud804\udd34 \ud804\udd1b\ud804\udd05\ud804\udd2a\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "lkr", "\ud804\udd25\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd23\ud804\udd27\ud804\udd01\ud804\udd07\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1b\ud804\udd28" },
            { "lrd", "\ud804\udd23\ud804\udd28\ud804\udd1d\ud804\udd2c\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "lsl", "\ud804\udd23\ud804\udd2c\ud804\udd25\ud804\udd2a\ud804\udd11\ud804\udd2a \ud804\udd23\ud804\udd2e\ud804\udd11\ud804\udd28" },
            { "ltl", "\ud804\udd23\ud804\udd28\ud804\udd17\ud804\udd2d\ud804\udd2a\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd23\ud804\udd28\ud804\udd11" },
            { "ltt", "\ud804\udd23\ud804\udd28\ud804\udd17\ud804\udd2d\ud804\udd2a\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd11\ud804\udd23\ud804\udd2e\ud804\udd1a\ud804\udd33\ud804\udd20\ud804\udd25\ud804\udd34" },
            { "luc", "\ud804\udd23\ud804\udd2a\ud804\udd07\ud804\udd34\ud804\udd25\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd22\ud804\udd34\ud804\udd09\ud804\udd34 \ud804\udd1d\ud804\udd2e\ud804\udd18\ud804\udd2e\ud804\udd23\ud804\udd2c\ud804\udd1d\ud804\udd22\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd07\ud804\udd33\ud804\udd0b\ud804\udd34" },
            { "luf", "\ud804\udd23\ud804\udd2a\ud804\udd07\ud804\udd34\ud804\udd25\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd22\ud804\udd34\ud804\udd09\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd07\ud804\udd33\ud804\udd0b\ud804\udd34" },
            { "lul", "\ud804\udd23\ud804\udd2a\ud804\udd07\ud804\udd34\ud804\udd25\ud804\udd2c\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd22\ud804\udd34\ud804\udd09\ud804\udd34 \ud804\udd1c\ud804\udd2d\ud804\udd1a\ud804\udd2c\ud804\udd1a\ud804\udd34\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd23\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd07\ud804\udd33\ud804\udd0b\ud804\udd34" },
            { "lvl", "\ud804\udd23\ud804\udd33\ud804\udd20\ud804\udd11\ud804\udd34\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd23\ud804\udd33\ud804\udd20\ud804\udd11\ud804\udd34\ud804\udd25\ud804\udd34" },
            { "lvr", "\ud804\udd23\ud804\udd33\ud804\udd20\ud804\udd11\ud804\udd34\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1d\ud804\udd27\ud804\udd23\ud804\udd34" },
            { "lyd", "\ud804\udd23\ud804\udd28\ud804\udd1d\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "mad", "\ud804\udd1f\ud804\udd2e\ud804\udd22\ud804\udd2e\ud804\udd07\ud804\udd33\ud804\udd26\ud804\udd1a\ud804\udd34 \ud804\udd18\ud804\udd28\ud804\udd22\ud804\udd34\ud804\udd26\ud804\udd1f\ud804\udd34" },
            { "maf", "\ud804\udd1f\ud804\udd2e\ud804\udd22\ud804\udd2e\ud804\udd07\ud804\udd33\ud804\udd26\ud804\udd1a\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd33\ud804\udd07\ud804\udd34" },
            { "mdl", "\ud804\udd1f\ud804\udd2e\ud804\udd23\ud804\udd34\ud804\udd13\ud804\udd2e\ud804\udd1e\ud804\udd1a\ud804\udd34 \ud804\udd23\ud804\udd2c\ud804\udd20\ud804\udd2a" },
            { "mga", "\ud804\udd1f\ud804\udd18\ud804\udd09\ud804\udd0c\ud804\udd34\ud804\udd07\ud804\udd22\ud804\udd34 \ud804\udd03\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd22\ud804\udd28" },
            { "mgf", "\ud804\udd1f\ud804\udd18\ud804\udd09\ud804\udd0c\ud804\udd34\ud804\udd07\ud804\udd22\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd33\ud804\udd07\ud804\udd34" },
            { "mkd", "\ud804\udd1f\ud804\udd33\ud804\udd20\ud804\udd25\ud804\udd2c\ud804\udd13\ud804\udd2e\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "mlf", "\ud804\udd1f\ud804\udd23\ud804\udd28 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd33\ud804\udd07\ud804\udd34" },
            { "mmk", "\ud804\udd1f\ud804\udd20\ud804\udd1a\ud804\udd34\ud804\udd1f\ud804\udd22\ud804\udd34 \ud804\udd07\ud804\udd28\ud804\udd20\ud804\udd16\ud804\udd34" },
            { "mnt", "\ud804\udd1f\ud804\udd27\ud804\udd0b\ud804\udd34\ud804\udd09\ud804\udd2e\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd16\ud804\udd2a\ud804\udd07\ud804\udd34\ud804\udd22\ud804\udd28\ud804\udd07\ud804\udd34" },
            { "mop", "\ud804\udd1f\ud804\udd33\ud804\udd20\ud804\udd07\ud804\udd33\ud804\udd20\ud804\udd03\ud804\udd2e \ud804\udd1b\ud804\udd11\ud804\udd07" },
            { "mro", "\ud804\udd1f\ud804\udd2f\ud804\udd22\ud804\udd28\ud804\udd16\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd03\ud804\udd2e\ud804\udd03\ud804\udd2a\ud804\udd09\ud804\udd2d\ud804\udd2a\ud804\udd20 (1973\u20132017)" },
            { "mru", "\ud804\udd1f\ud804\udd2f\ud804\udd22\ud804\udd28\ud804\udd16\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd03\ud804\udd2e\ud804\udd03\ud804\udd2a\ud804\udd09\ud804\udd2d\ud804\udd2a\ud804\udd20" },
            { "mtl", "\ud804\udd1f\ud804\udd23\ud804\udd34\ud804\udd11 \ud804\udd23\ud804\udd28\ud804\udd22" },
            { "mtp", "\ud804\udd1f\ud804\udd23\ud804\udd34\ud804\udd11 \ud804\udd1b\ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "mur", "\ud804\udd1f\ud804\udd2f\ud804\udd22\ud804\udd28\ud804\udd16\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1b\ud804\udd28" },
            { "mvr", "\ud804\udd1f\ud804\udd23\ud804\udd34\ud804\udd18\ud804\udd28\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1c\ud804\udd28\ud804\udd20" },
            { "mwk", "\ud804\udd1f\ud804\udd23\ud804\udd03\ud804\udd2a\ud804\udd03\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd27\ud804\udd24\ud804\udd0c\ud804\udd34" },
            { "mxn", "\ud804\udd1f\ud804\udd33\ud804\udd20\ud804\udd07\ud804\udd34\ud804\udd25\ud804\udd28\ud804\udd07\ud804\udd1a\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e" },
            { "mxp", "\ud804\udd1f\ud804\udd33\ud804\udd20\ud804\udd07\ud804\udd34\ud804\udd25\ud804\udd28\ud804\udd07\ud804\udd1a\ud804\udd34 \ud804\udd25\ud804\udd28\ud804\udd23\ud804\udd34\ud804\udd1e\ud804\udd22\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e (\ud804\udd37\ud804\udd3e\ud804\udd3c\ud804\udd37-\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd38)" },
            { "mxv", "\ud804\udd1f\ud804\udd2c\ud804\udd07\ud804\udd34\ud804\udd25\ud804\udd28\ud804\udd07\ud804\udd1a\ud804\udd34 \ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd28\ud804\udd18\ud804\udd16\ud804\udd34 \ud804\udd18\ud804\udd28 \ud804\udd03\ud804\udd28\ud804\udd1a\ud804\udd34\ud804\udd1e\ud804\udd22\ud804\udd34\ud804\udd25\ud804\udd27\ud804\udd1a\ud804\udd34(UDI)" },
            { "myr", "\ud804\udd1f\ud804\udd23\ud804\udd34\ud804\udd20\ud804\udd2c\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd28\ud804\udd01\ud804\udd09\ud804\udd28\ud804\udd16\ud804\udd34" },
            { "mze", "\ud804\udd1f\ud804\udd2e\ud804\udd0e\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd28\ud804\udd07\ud804\udd34 \ud804\udd03\ud804\udd2c\ud804\udd25\ud804\udd34\ud804\udd07\ud804\udd2a\ud804\udd13\ud804\udd2e" },
            { "mzm", "\ud804\udd1b\ud804\udd2a\ud804\udd22\ud804\udd2e\ud804\udd1a\ud804\udd28 \ud804\udd1f\ud804\udd2e\ud804\udd0e\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd28\ud804\udd07\ud804\udd34 \ud804\udd1f\ud804\udd2c\ud804\udd11\ud804\udd28\ud804\udd07\ud804\udd2c\ud804\udd23\ud804\udd34" },
            { "mzn", "\ud804\udd1f\ud804\udd2e\ud804\udd0e\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd28\ud804\udd07\ud804\udd34 \ud804\udd1f\ud804\udd2c\ud804\udd11\ud804\udd28\ud804\udd07\ud804\udd2c\ud804\udd23\ud804\udd34" },
            { "nad", "\ud804\udd1a\ud804\udd1f\ud804\udd28\ud804\udd1d\ud804\udd28\ud804\udd20 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "ngn", "\ud804\udd1a\ud804\udd2d\ud804\udd0e\ud804\udd2c\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1a\ud804\udd20\ud804\udd34\ud804\udd22" },
            { "nic", "\ud804\udd1a\ud804\udd28\ud804\udd07\ud804\udd22\ud804\udd09\ud804\udd2a\ud804\udd20\ud804\udd1a \ud804\udd07\ud804\udd27\ud804\udd22\ud804\udd34\ud804\udd13\ud804\udd2e\ud804\udd1d(\ud804\udd37\ud804\udd3f\ud804\udd3e\ud804\udd3e-\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd37)" },
            { "nio", "\ud804\udd1a\ud804\udd28\ud804\udd07\ud804\udd22\ud804\udd09\ud804\udd2a\ud804\udd20\ud804\udd1a \ud804\udd07\ud804\udd27\ud804\udd22\ud804\udd34\ud804\udd13\ud804\udd2e\ud804\udd1d" },
            { "nlg", "\ud804\udd1a\ud804\udd2c\ud804\udd18\ud804\udd22\ud804\udd34\ud804\udd23\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34 \ud804\udd09\ud804\udd2a\ud804\udd23\ud804\udd34\ud804\udd13\ud804\udd2c\ud804\udd22\ud804\udd34" },
            { "nok", "\ud804\udd1a\ud804\udd27\ud804\udd22\ud804\udd34\ud804\udd03\ud804\udd2e\ud804\udd20\ud804\udd2c \ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2f\ud804\udd1a\ud804\udd34" },
            { "npr", "\ud804\udd1a\ud804\udd2c\ud804\udd1b\ud804\udd23\ud804\udd28 \ud804\udd22\ud804\udd2a\ud804\udd1b\ud804\udd28" },
            { "nzd", "\ud804\udd1a\ud804\udd28\ud804\udd03\ud804\udd2a\ud804\udd0e\ud804\udd28\ud804\udd23\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "omr", "\ud804\udd03\ud804\udd2e\ud804\udd1f\ud804\udd1a\ud804\udd28 \ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd23\ud804\udd34" },
            { "pab", "\ud804\udd1b\ud804\udd1a\ud804\udd1f \ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd34\ud804\udd1d\ud804\udd2e\ud804\udd20" },
            { "pei", "\ud804\udd1b\ud804\udd2c\ud804\udd22\ud804\udd2a\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd03\ud804\udd28\ud804\udd1a\ud804\udd34\ud804\udd16\ud804\udd28" },
            { "pen", "\ud804\udd1b\ud804\udd2c\ud804\udd22\ud804\udd2a\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd25\ud804\udd2e\ud804\udd23\ud804\udd34" },
            { "pes", "\ud804\udd1b\ud804\udd2c\ud804\udd22\ud804\udd2a\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd25\ud804\udd2e\ud804\udd23\ud804\udd34(\ud804\udd37\ud804\udd3e\ud804\udd3c\ud804\udd39-\ud804\udd37\ud804\udd3f\ud804\udd3c\ud804\udd3b)" },
            { "pgk", "\ud804\udd1b\ud804\udd1b\ud804\udd31 \ud804\udd1a\ud804\udd28\ud804\udd03\ud804\udd2a \ud804\udd09\ud804\udd28\ud804\udd1a\ud804\udd28 \ud804\udd09\ud804\udd28\ud804\udd1a\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd28\ud804\udd1a" },
            { "php", "\ud804\udd1c\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd1b\ud804\udd2d\ud804\udd1a\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e" },
            { "pkr", "\ud804\udd1b\ud804\udd07\ud804\udd28\ud804\udd25\ud804\udd34\ud804\udd16\ud804\udd1a\ud804\udd28 \ud804\udd22\ud804\udd2a\ud804\udd1b\ud804\udd28" },
            { "pln", "\ud804\udd1b\ud804\udd2e\ud804\udd23\ud804\udd28\ud804\udd0c\ud804\udd34 \ud804\udd0e\ud804\udd27\ud804\udd23\ud804\udd2e\ud804\udd11\ud804\udd28" },
            { "plz", "\ud804\udd1b\ud804\udd2e\ud804\udd23\ud804\udd28\ud804\udd0c\ud804\udd34 \ud804\udd0e\ud804\udd27\ud804\udd23\ud804\udd2e\ud804\udd11\ud804\udd28(\ud804\udd37\ud804\udd3f\ud804\udd3b\ud804\udd36-\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd3b)" },
            { "pte", "\ud804\udd1b\ud804\udd27\ud804\udd22\ud804\udd34\ud804\udd16\ud804\udd2a\ud804\udd09\ud804\udd28\ud804\udd0c\ud804\udd34 \ud804\udd03\ud804\udd2c\ud804\udd25\ud804\udd34\ud804\udd07\ud804\udd2a\ud804\udd13\ud804\udd2e" },
            { "pyg", "\ud804\udd1b\ud804\udd33\ud804\udd20\ud804\udd22\ud804\udd09\ud804\udd2a\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd09\ud804\udd2a\ud804\udd20\ud804\udd22\ud804\udd1a\ud804\udd28" },
            { "qar", "\ud804\udd07\ud804\udd16\ud804\udd22\ud804\udd34 \ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd33\ud804\udd20\ud804\udd23\ud804\udd34" },
            { "rhd", "\ud804\udd22\ud804\udd2e\ud804\udd13\ud804\udd2c\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "rol", "\ud804\udd1b\ud804\udd2a\ud804\udd22\ud804\udd2e\ud804\udd1a\ud804\udd28 \ud804\udd22\ud804\udd2a\ud804\udd1f\ud804\udd1a\ud804\udd28\ud804\udd20 \ud804\udd23\ud804\udd2c\ud804\udd20\ud804\udd2a" },
            { "ron", "\ud804\udd22\ud804\udd2a\ud804\udd1f\ud804\udd1a\ud804\udd28\ud804\udd20 \ud804\udd23\ud804\udd2c\ud804\udd20\ud804\udd2a" },
            { "rsd", "\ud804\udd25\ud804\udd22\ud804\udd34\ud804\udd1d\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "rub", "\ud804\udd22\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1d\ud804\udd2c\ud804\udd23\ud804\udd34" },
            { "rur", "\ud804\udd22\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1d\ud804\udd27\ud804\udd23\ud804\udd34(\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd37-\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd3e)" },
            { "rwf", "\ud804\udd22\ud804\udd2a\ud804\udd20\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd1a\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd33\ud804\udd07\ud804\udd34" },
            { "sar", "\ud804\udd25\ud804\udd2f\ud804\udd18\ud804\udd28 \ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd23\ud804\udd34" },
            { "sbd", "\ud804\udd25\ud804\udd27\ud804\udd23\ud804\udd2e\ud804\udd1f\ud804\udd27\ud804\udd1a\ud804\udd34 \ud804\udd09\ud804\udd2d \ud804\udd09\ud804\udd2d \ud804\udd1e\ud804\udd28\ud804\udd18\ud804\udd2c\ud804\udd22\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "scr", "\ud804\udd25\ud804\udd2c\ud804\udd20\ud804\udd27\ud804\udd25\ud804\udd2c\ud804\udd23\ud804\udd34\ud804\udd23\ud804\udd2e\ud804\udd03\ud804\udd28\ud804\udd0c\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1b\ud804\udd28" },
            { "sdd", "\ud804\udd1b\ud804\udd2a\ud804\udd22\ud804\udd2e\ud804\udd1a\ud804\udd28 \ud804\udd25\ud804\udd2a\ud804\udd18\ud804\udd1a\ud804\udd28 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "sdg", "\ud804\udd25\ud804\udd2a\ud804\udd18\ud804\udd1a\ud804\udd28 \ud804\udd1b\ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "sdp", "\ud804\udd1b\ud804\udd2a\ud804\udd22\ud804\udd2e\ud804\udd1a\ud804\udd28 \ud804\udd25\ud804\udd2a\ud804\udd18\ud804\udd1a\ud804\udd28 \ud804\udd1b\ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "sek", "\ud804\udd25\ud804\udd2d\ud804\udd2a\ud804\udd13\ud804\udd28\ud804\udd25\ud804\udd34 \ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2e\ud804\udd1a" },
            { "sgd", "\ud804\udd25\ud804\udd28\ud804\udd01\ud804\udd09\ud804\udd1b\ud804\udd2a\ud804\udd22\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "shp", "\ud804\udd25\ud804\udd2c\ud804\udd1a\ud804\udd33\ud804\udd11\ud804\udd34 \ud804\udd26\ud804\udd2c\ud804\udd23\ud804\udd2c\ud804\udd1a \ud804\udd1b\ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "sit", "\ud804\udd25\ud804\udd33\ud804\udd23\ud804\udd2e\ud804\udd1e\ud804\udd1a\ud804\udd28\ud804\udd20 \ud804\udd11\ud804\udd2e\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "skk", "\ud804\udd25\ud804\udd33\ud804\udd23\ud804\udd2e\ud804\udd1e\ud804\udd07\ud804\udd34 \ud804\udd07\ud804\udd2e\ud804\udd22\ud804\udd2a\ud804\udd1a" },
            { "sll", "\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd2c\ud804\udd22\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd27\ud804\udd1a\ud804\udd34 \ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd27\ud804\udd1a\ud804\udd34" },
            { "sos", "\ud804\udd25\ud804\udd2e\ud804\udd1f\ud804\udd23\ud804\udd28 \ud804\udd25\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd01" },
            { "srd", "\ud804\udd25\ud804\udd2a\ud804\udd22\ud804\udd28\ud804\udd1a\ud804\udd1f\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "srg", "\ud804\udd25\ud804\udd2a\ud804\udd22\ud804\udd28\ud804\udd1a\ud804\udd1f\ud804\udd34 \ud804\udd09\ud804\udd28\ud804\udd23\ud804\udd34\ud804\udd13\ud804\udd22\ud804\udd34" },
            { "ssp", "\ud804\udd18\ud804\udd27\ud804\udd09\ud804\udd28\ud804\udd1a\ud804\udd34 \ud804\udd25\ud804\udd2a\ud804\udd18\ud804\udd1a\ud804\udd28 \ud804\udd1b\ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "std", "\ud804\udd25\ud804\udd03\ud804\udd2e \ud804\udd11\ud804\udd2e\ud804\udd1f\ud804\udd2c \ud804\udd03\ud804\udd33\ud804\udd03 \ud804\udd1b\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd1a\ud804\udd34\ud804\udd25\ud804\udd28\ud804\udd1b\ud804\udd2c \ud804\udd13\ud804\udd2e\ud804\udd1b\ud804\udd34\ud804\udd22 (1977\u20132017)" },
            { "stn", "\ud804\udd25\ud804\udd03\ud804\udd2e \ud804\udd11\ud804\udd2e\ud804\udd1f\ud804\udd2c \ud804\udd03\ud804\udd33\ud804\udd03 \ud804\udd1b\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd1a\ud804\udd34\ud804\udd25\ud804\udd28\ud804\udd1b\ud804\udd2c \ud804\udd13\ud804\udd2e\ud804\udd1b\ud804\udd34\ud804\udd22" },
            { "sur", "\ud804\udd25\ud804\udd2e\ud804\udd23\ud804\udd28\ud804\udd20\ud804\udd2c\ud804\udd16\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1d\ud804\udd27\ud804\udd23\ud804\udd34" },
            { "svc", "\ud804\udd03\ud804\udd2c\ud804\udd23\ud804\udd34 \ud804\udd25\ud804\udd33\ud804\udd20\ud804\udd23\ud804\udd34\ud804\udd1e\ud804\udd2e\ud804\udd13\ud804\udd2e\ud804\udd22\ud804\udd34 \ud804\udd07\ud804\udd2e\ud804\udd23\ud804\udd2e\ud804\udd1a\ud804\udd34" },
            { "syp", "\ud804\udd25\ud804\udd28\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1b\ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "szl", "\ud804\udd25\ud804\udd2e\ud804\udd20\ud804\udd0e\ud804\udd28\ud804\udd23\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34 \ud804\udd23\ud804\udd28\ud804\udd23\ud804\udd0b\ud804\udd34\ud804\udd09\ud804\udd2c\ud804\udd1a\ud804\udd28" },
            { "thb", "\ud804\udd17\ud804\udd2d \ud804\udd1d\ud804\udd16\ud804\udd34" },
            { "tjr", "\ud804\udd16\ud804\udd0e\ud804\udd28\ud804\udd07\ud804\udd28\ud804\udd0c\ud804\udd34\ud804\udd16\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd2a\ud804\udd1d\ud804\udd27\ud804\udd23\ud804\udd34" },
            { "tjs", "\ud804\udd16\ud804\udd0e\ud804\udd28\ud804\udd07\ud804\udd28\ud804\udd0c\ud804\udd34\ud804\udd16\ud804\udd1a\ud804\udd34 \ud804\udd25\ud804\udd2e\ud804\udd1f\ud804\udd2e\ud804\udd1a\ud804\udd28" },
            { "tmm", "\ud804\udd16\ud804\udd2a\ud804\udd22\ud804\udd34\ud804\udd07\ud804\udd27\ud804\udd1f\ud804\udd2c\ud804\udd1a\ud804\udd28\ud804\udd0c\ud804\udd34\ud804\udd16\ud804\udd1a\ud804\udd28 \ud804\udd1f\ud804\udd1a\ud804\udd16\ud804\udd34(\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd39-\ud804\udd38\ud804\udd36\ud804\udd36\ud804\udd3f)" },
            { "tmt", "\ud804\udd16\ud804\udd2a\ud804\udd22\ud804\udd34\ud804\udd07\ud804\udd27\ud804\udd1f\ud804\udd2c\ud804\udd1a\ud804\udd28\ud804\udd0c\ud804\udd34\ud804\udd16\ud804\udd1a\ud804\udd28 \ud804\udd1f\ud804\udd1a\ud804\udd16\ud804\udd34" },
            { "tnd", "\ud804\udd16\ud804\udd28\ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd2c\ud804\udd25\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "top", "\ud804\udd11\ud804\udd2e\ud804\udd0b\ud804\udd34\ud804\udd09 \ud804\udd1b\ud804\udd33\ud804\udd03 \ud804\udd03\ud804\udd0b\ud804\udd34\ud804\udd09" },
            { "tpe", "\ud804\udd16\ud804\udd28\ud804\udd1f\ud804\udd2a\ud804\udd22\ud804\udd34 \ud804\udd03\ud804\udd2c\ud804\udd0c\ud804\udd34\ud804\udd07\ud804\udd2a\ud804\udd13\ud804\udd2e" },
            { "trl", "\ud804\udd1b\ud804\udd2a\ud804\udd22\ud804\udd2e\ud804\udd1a\ud804\udd34 \ud804\udd16\ud804\udd2a\ud804\udd22\ud804\udd34\ud804\udd07\ud804\udd28 \ud804\udd23\ud804\udd28\ud804\udd22" },
            { "try", "\ud804\udd16\ud804\udd2a\ud804\udd22\ud804\udd34\ud804\udd07\ud804\udd28 \ud804\udd23\ud804\udd28\ud804\udd22" },
            { "ttd", "\ud804\udd16\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd1a\ud804\udd28\ud804\udd18\ud804\udd16\ud804\udd34 \ud804\udd03\ud804\udd33\ud804\udd03 \ud804\udd11\ud804\udd2e\ud804\udd1d\ud804\udd09\ud804\udd2e \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "twd", "\ud804\udd1a\ud804\udd31 \ud804\udd26\ud804\udd2d\ud804\udd24\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "tzs", "\ud804\udd16\ud804\udd1a\ud804\udd34\ud804\udd0e\ud804\udd1a\ud804\udd28\ud804\udd20 \ud804\udd25\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd01" },
            { "uah", "\u0987\ud804\udd03\ud804\udd28\ud804\udd03\ud804\udd2a\ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2d\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd28\ud804\udd1b\ud804\udd34\ud804\udd1a\ud804\udd28\ud804\udd20" },
            { "uak", "\ud804\udd03\ud804\udd28\ud804\udd03\ud804\udd2a\ud804\udd07\ud804\udd33\ud804\udd22\ud804\udd2d\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd22\ud804\udd34\ud804\udd1d\ud804\udd2e\ud804\udd1e\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd34\ud804\udd11\ud804\udd27\ud804\udd0c\ud804\udd34" },
            { "ugs", "\ud804\udd03\ud804\udd2a\ud804\udd09\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd1a\ud804\udd34 \ud804\udd25\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd01 (\ud804\udd37\ud804\udd3f\ud804\udd3c\ud804\udd3c-\ud804\udd37\ud804\udd3f\ud804\udd3e\ud804\udd3d)" },
            { "ugx", "\ud804\udd03\ud804\udd2a\ud804\udd09\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd1a\ud804\udd34 \ud804\udd25\ud804\udd28\ud804\udd23\ud804\udd28\ud804\udd01" },
            { "usd", "\ud804\udd1f\ud804\udd22\ud804\udd34\ud804\udd07\ud804\udd28\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "usn", "\ud804\udd1f\ud804\udd22\ud804\udd34\ud804\udd07\ud804\udd28\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34 (\ud804\udd1b\ud804\udd27\ud804\udd22\ud804\udd2c \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd34)" },
            { "uss", "\ud804\udd1f\ud804\udd22\ud804\udd34\ud804\udd07\ud804\udd28\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34 (\ud804\udd03\ud804\udd2c\ud804\udd07\ud804\udd34\ud804\udd07\ud804\udd30\ud804\udd2a \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd34)" },
            { "uyi", "\ud804\udd03\ud804\udd2a\ud804\udd22\ud804\udd2a\ud804\udd09\ud804\udd2a\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e \ud804\udd03\ud804\udd2c\ud804\udd1a\ud804\udd34 \ud804\udd03\ud804\udd2a\ud804\udd1a\ud804\udd28\ud804\udd18\ud804\udd18\ud804\udd2c\ud804\udd0c\ud804\udd34 \ud804\udd03\ud804\udd28\ud804\udd1a\ud804\udd34\ud804\udd13\ud804\udd2c\ud804\udd07\ud804\udd34\ud804\udd25\ud804\udd2c\ud804\udd13\ud804\udd25\ud804\udd34" },
            { "uyp", "\ud804\udd03\ud804\udd2a\ud804\udd22\ud804\udd2a\ud804\udd09\ud804\udd2a\ud804\udd20\ud804\udd2c \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e (\ud804\udd37\ud804\udd3f\ud804\udd3d\ud804\udd3b-\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd39)" },
            { "uyu", "\ud804\udd03\ud804\udd2a\ud804\udd22\ud804\udd2a\ud804\udd09\ud804\udd2a\ud804\udd20\ud804\udd2c \ud804\udd1b\ud804\udd2c\ud804\udd25\ud804\udd2e" },
            { "uzs", "\ud804\udd03\ud804\udd2a\ud804\udd0c\ud804\udd34\ud804\udd1d\ud804\udd2c\ud804\udd07\ud804\udd28\ud804\udd0c\ud804\udd34\ud804\udd16\ud804\udd1a\ud804\udd28 \ud804\udd25\ud804\udd2e\ud804\udd1f\ud804\udd34" },
            { "veb", "\ud804\udd1e\ud804\udd2c\ud804\udd1a\ud804\udd28\ud804\udd0e\ud804\udd2a\ud804\udd14\ud804\udd2e\ud804\udd23\ud804\udd1a\ud804\udd34 \ud804\udd1d\ud804\udd27\ud804\udd23\ud804\udd28\ud804\udd1e\ud804\udd22\ud804\udd34(\ud804\udd37\ud804\udd3e\ud804\udd3d\ud804\udd37-\ud804\udd38\ud804\udd36\ud804\udd36\ud804\udd3e)" },
            { "vef", "\ud804\udd1e\ud804\udd2c\ud804\udd1a\ud804\udd28\ud804\udd0e\ud804\udd2a\ud804\udd14\ud804\udd2e\ud804\udd23\ud804\udd1a\ud804\udd34 \ud804\udd1d\ud804\udd27\ud804\udd23\ud804\udd28\ud804\udd1e\ud804\udd22\ud804\udd34" },
            { "vnd", "\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd2c\ud804\udd16\ud804\udd34\ud804\udd1a\ud804\udd1f\ud804\udd28 \ud804\udd13\ud804\udd27\ud804\udd0b\ud804\udd34\ud804\udd09\ud804\udd27" },
            { "vuv", "\ud804\udd1e\ud804\udd1a\ud804\udd2a\ud804\udd20\ud804\udd16\ud804\udd2a \ud804\udd1e\ud804\udd16\ud804\udd2a" },
            { "wst", "\ud804\udd25\ud804\udd1f\ud804\udd2e\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd11\ud804\udd23" },
            { "xaf", "\ud804\udd1f\ud804\udd27\ud804\udd16\ud804\udd34\ud804\udd19\ud804\udd33\ud804\udd20 \ud804\udd03\ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd07\ud804\udd1a\ud804\udd34[CFA] \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd33\ud804\udd20\ud804\udd0b\ud804\udd33\ud804\udd07\ud804\udd34" },
            { "xag", "\ud804\udd25\ud804\udd28\ud804\udd23\ud804\udd34\ud804\udd1e\ud804\udd22\ud804\udd34" },
            { "xau", "\ud804\udd09\ud804\udd2e\ud804\udd23\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "xcd", "\ud804\udd1b\ud804\udd2a\ud804\udd09\ud804\udd2c\ud804\udd18\ud804\udd28 \ud804\udd07\ud804\udd33\ud804\udd20\ud804\udd22\ud804\udd1d\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34" },
            { "xeu", "\ud804\udd03\ud804\udd28\ud804\udd03\ud804\udd2a\ud804\udd22\ud804\udd2e\ud804\udd1b\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd11\ud804\udd2c\ud804\udd0b\ud804\udd22\ud804\udd34 \ud804\udd03\ud804\udd2c\ud804\udd07\ud804\udd27\ud804\udd07\ud804\udd34" },
            { "xfo", "\ud804\udd1c\ud804\udd27\ud804\udd22\ud804\udd25\ud804\udd28 \ud804\udd09\ud804\udd2e\ud804\udd23\ud804\udd33\ud804\udd13\ud804\udd34 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd33\ud804\udd07\ud804\udd34" },
            { "xfu", "\ud804\udd1c\ud804\udd27\ud804\udd22\ud804\udd25\ud804\udd28 \ud804\udd03\ud804\udd28\ud804\udd03\ud804\udd2a\ud804\udd03\ud804\udd2d\ud804\udd25\ud804\udd28 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd0b\ud804\udd33\ud804\udd07\ud804\udd34" },
            { "xof", "\ud804\udd1b\ud804\udd27\ud804\udd0e\ud804\udd28\ud804\udd1f\ud804\udd34 \ud804\udd03\ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd07\ud804\udd1a\ud804\udd34 [CFA] \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd33\ud804\udd20\ud804\udd0b\ud804\udd33\ud804\udd07\ud804\udd34" },
            { "xpd", "\ud804\udd1b\ud804\udd33\ud804\udd20\ud804\udd23\ud804\udd2c\ud804\udd13\ud804\udd28\ud804\udd20\ud804\udd1f\ud804\udd34" },
            { "xpf", "\ud804\udd25\ud804\udd28\ud804\udd03\ud804\udd2c\ud804\udd1b\ud804\udd34\ud804\udd1b\ud804\udd28 \ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd33\ud804\udd20\ud804\udd0b\ud804\udd33\ud804\udd07\ud804\udd34" },
            { "xpt", "\ud804\udd1b\ud804\udd33\ud804\udd23\ud804\udd11\ud804\udd28\ud804\udd1a\ud804\udd1f\ud804\udd34" },
            { "xxx", "\ud804\udd26\ud804\udd27\ud804\udd1d\ud804\udd22\ud804\udd34 \ud804\udd1a\ud804\udd27\ud804\udd1b\ud804\udd2c\ud804\udd20\ud804\udd2c \ud804\udd11\ud804\udd2c\ud804\udd0b" },
            { "ydd", "\ud804\udd03\ud804\udd28\ud804\udd20\ud804\udd2c\ud804\udd1f\ud804\udd2c\ud804\udd1a\ud804\udd28 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "yer", "\ud804\udd03\ud804\udd28\ud804\udd20\ud804\udd2c\ud804\udd1f\ud804\udd2c\ud804\udd1a\ud804\udd28 \ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd23\ud804\udd34" },
            { "yud", "\ud804\udd21\ud804\udd2a\ud804\udd09\ud804\udd2e\ud804\udd25\ud804\udd33\ud804\udd23\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd27 \ud804\udd26\ud804\udd22\ud804\udd34\ud804\udd13\ud804\udd34 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "yum", "\ud804\udd21\ud804\udd2a\ud804\udd09\ud804\udd2e\ud804\udd25\ud804\udd33\ud804\udd23\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd27 \ud804\udd1a\ud804\udd2e\ud804\udd1e\ud804\udd28 \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "yun", "\ud804\udd21\ud804\udd2a\ud804\udd09\ud804\udd2e\ud804\udd25\ud804\udd33\ud804\udd23\ud804\udd1e\ud804\udd28\ud804\udd20\ud804\udd27 \ud804\udd1d\ud804\udd2e\ud804\udd18\ud804\udd2e\ud804\udd23\ud804\udd2c\ud804\udd2d\ud804\udd1b\ud804\udd22\ud804\udd2c \ud804\udd18\ud804\udd28\ud804\udd1a\ud804\udd22\ud804\udd34" },
            { "zar", "\ud804\udd18\ud804\udd27\ud804\udd09\ud804\udd28\ud804\udd1a\ud804\udd34 \ud804\udd03\ud804\udd1c\ud804\udd33\ud804\udd22\ud804\udd28\ud804\udd07\ud804\udd1a\ud804\udd34 \ud804\udd22\ud804\udd33\ud804\udd20\ud804\udd1a\ud804\udd33\ud804\udd13\ud804\udd34" },
            { "zmk", "\ud804\udd0e\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd27\ud804\udd24\ud804\udd0c (\ud804\udd37\ud804\udd3f\ud804\udd3c\ud804\udd3e-\ud804\udd38\ud804\udd36\ud804\udd37\ud804\udd38)" },
            { "zmw", "\ud804\udd0e\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd07\ud804\udd27\ud804\udd24\ud804\udd0c" },
            { "zrn", "\ud804\udd0e\ud804\udd2d\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1a\ud804\udd28\ud804\udd05\ud804\udd2a \ud804\udd0e\ud804\udd2d\ud804\udd22\ud804\udd2c (\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd39-\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd3e)" },
            { "zrz", "\ud804\udd0e\ud804\udd2d\ud804\udd22\ud804\udd28\ud804\udd20\ud804\udd1a\ud804\udd34 \ud804\udd1a\ud804\udd28\ud804\udd05\ud804\udd2a \ud804\udd0e\ud804\udd2d\ud804\udd22\ud804\udd2c (\ud804\udd37\ud804\udd3f\ud804\udd3d\ud804\udd37-\ud804\udd37\ud804\udd3f\ud804\udd3f\ud804\udd39)" },
            { "zwd", "\ud804\udd0e\ud804\udd28\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd1d\ud804\udd2a\ud804\udd20\ud804\udd2c \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34 (\ud804\udd37\ud804\udd3f\ud804\udd3e\ud804\udd36-\ud804\udd38\ud804\udd36\ud804\udd36\ud804\udd3e)" },
            { "zwl", "\ud804\udd0e\ud804\udd28\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd1d\ud804\udd2a\ud804\udd20\ud804\udd2c \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34 (\ud804\udd38\ud804\udd36\ud804\udd36\ud804\udd3f)" },
            { "zwr", "\ud804\udd0e\ud804\udd28\ud804\udd1f\ud804\udd34\ud804\udd1d\ud804\udd1d\ud804\udd2a\ud804\udd20\ud804\udd2c \ud804\udd13\ud804\udd27\ud804\udd23\ud804\udd22\ud804\udd34 (\ud804\udd38\ud804\udd36\ud804\udd36\ud804\udd3e)" },
        };
        return data;
    }
}
