/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ca extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Hora est\u00e0ndard de Moscou",
               "",
               "Hora d\u2019estiu de Moscou",
               "",
               "Hora de Moscou",
               "",
            };
        final String[] Pakistan = new String[] {
               "Hora est\u00e0ndard del Pakistan",
               "",
               "Hora d\u2019estiu del Pakistan",
               "",
               "Hora del Pakistan",
               "",
            };
        final String[] Magadan = new String[] {
               "Hora est\u00e0ndard de Magadan",
               "",
               "Hora d\u2019estiu de Magadan",
               "",
               "Hora de Magadan",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Hora est\u00e0ndard del Centre d\u2019Europa",
               "CET",
               "Hora d\u2019estiu del Centre d\u2019Europa",
               "CEST",
               "Hora del Centre d\u2019Europa",
               "CET",
            };
        final String[] America_Eastern = new String[] {
               "Hora est\u00e0ndard oriental d\u2019Am\u00e8rica del Nord",
               "",
               "Hora d\u2019estiu oriental d\u2019Am\u00e8rica del Nord",
               "",
               "Hora oriental d\u2019Am\u00e8rica del Nord",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Hora est\u00e0ndard de Lord Howe",
               "",
               "Horari d\u2019estiu de Lord Howe",
               "",
               "Hora de Lord Howe",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Hora est\u00e0ndard de Nova Zelanda",
               "",
               "Hora d\u2019estiu de Nova Zelanda",
               "",
               "Hora de Nova Zelanda",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hora de l\u2019oce\u00e0 \u00cdndic",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Hora est\u00e0ndard de Iakutsk",
               "",
               "Hora d\u2019estiu de Iakutsk",
               "",
               "Hora de Iakutsk",
               "",
            };
        final String[] East_Timor = new String[] {
               "Hora de Timor Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Hora de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Hora est\u00e0ndard de l\u2019Est d\u2019Europa",
               "EET",
               "Hora d\u2019estiu de l\u2019Est d\u2019Europa",
               "EEST",
               "Hora de l\u2019Est d\u2019Europa",
               "EET",
            };
        final String[] Argentina_Western = new String[] {
               "Hora est\u00e0ndard de l\u2019oest de l\u2019Argentina",
               "",
               "Hora d\u2019estiu de l\u2019oest de l\u2019Argentina",
               "",
               "Hora de l\u2019oest de l\u2019Argentina",
               "",
            };
        final String[] Ponape = new String[] {
               "Hora de Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Hora de Bol\u00edvia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hora est\u00e0ndard de Saint-Pierre i Miquelon",
               "",
               "Hora d\u2019estiu de Saint-Pierre i Miquelon",
               "",
               "Hora de Saint-Pierre i Miquelon",
               "",
            };
        final String[] Indochina = new String[] {
               "Hora d\u2019Indoxina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Hora est\u00e0ndard d\u2019Ekaterinburg",
               "",
               "Hora d\u2019estiu d\u2019Ekaterinburg",
               "",
               "Hora d\u2019Ekaterinburg",
               "",
            };
        final String[] Maldives = new String[] {
               "Hora de les Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Hora de Tahit\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Hora de Wallis i Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Hora est\u00e0ndard del sud de l\u2019\u00c0frica",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Hora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Hora de Line Islands",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Hora est\u00e0ndard de l\u2019Uzbekistan",
               "",
               "Hora d\u2019estiu de l\u2019Uzbekistan",
               "",
               "Hora de l\u2019Uzbekistan",
               "",
            };
        final String[] Mongolia = new String[] {
               "Hora est\u00e0ndard d\u2019Ulan Bator",
               "",
               "Hora d\u2019estiu d\u2019Ulan Bator",
               "",
               "Hora d\u2019Ulan Bator",
               "",
            };
        final String[] America_Central = new String[] {
               "Hora est\u00e0ndard central d\u2019Am\u00e8rica del Nord",
               "",
               "Hora d\u2019estiu central d\u2019Am\u00e8rica del Nord",
               "",
               "Hora central d\u2019Am\u00e8rica del Nord",
               "",
            };
        final String[] Niue = new String[] {
               "Hora de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Hora de Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Hora est\u00e0ndard de les illes Malvines",
               "",
               "Hora d\u2019estiu de les illes Malvines",
               "",
               "Hora de les illes Malvines",
               "",
            };
        final String[] Apia = new String[] {
               "Hora est\u00e0ndard d\u2019Apia",
               "",
               "Hora d\u2019estiu d\u2019Apia",
               "",
               "Hora d\u2019Apia",
               "",
            };
        final String[] Bhutan = new String[] {
               "Hora de Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Hora de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Hora de l\u2019oest del Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Hora de Kiritimati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "Hora de Reuni\u00f3",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Hora de les illes Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Hora est\u00e0ndard de Chatham",
               "",
               "Hora d\u2019estiu de Chatham",
               "",
               "Hora de Chatham",
               "",
            };
        final String[] Vostok = new String[] {
               "Hora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Hora est\u00e0ndard de l\u2019Argentina",
               "",
               "Hora d\u2019estiu de l\u2019Argentina",
               "",
               "Hora de l\u2019Argentina",
               "",
            };
        final String[] Gambier = new String[] {
               "Hora de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Hora de Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Hora de Vene\u00e7uela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hora de les illes Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Hora est\u00e0ndard de Cap Verd",
               "",
               "Hora d\u2019estiu de Cap Verd",
               "",
               "Hora de Cap Verd",
               "",
            };
        final String[] Norfolk = new String[] {
               "Hora de les illes Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Hora est\u00e0ndard de Samoa",
               "",
               "Hora d\u2019estiu de Samoa",
               "",
               "Hora de Samoa",
               "",
            };
        final String[] Davis = new String[] {
               "Hora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Hora est\u00e0ndard de Cuba",
               "",
               "Hora d\u2019estiu de Cuba",
               "",
               "Hora de Cuba",
               "",
            };
        final String[] GMT = new String[] {
               "Hora del Meridi\u00e0 de Greenwich",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Hora est\u00e0ndard de Filipines",
               "",
               "Hora d\u2019estiu de Filipines",
               "",
               "Hora de Filipines",
               "",
            };
        final String[] French_Southern = new String[] {
               "Hora d\u2019Ant\u00e0rtida i Fran\u00e7a del Sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Hora est\u00e0ndard de Nova Caled\u00f2nia",
               "",
               "Hora d\u2019estiu de Nova Caled\u00f2nia",
               "",
               "Hora de Nova Caled\u00f2nia",
               "",
            };
        final String[] Brunei = new String[] {
               "Hora de Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Hora est\u00e0ndard d\u2019Iran",
               "",
               "Hora d\u2019estiu d\u2019Iran",
               "",
               "Hora d\u2019Iran",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Hora del Tadjikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Hora est\u00e0ndard de Tonga",
               "",
               "Hora d\u2019estiu de Tonga",
               "",
               "Hora de Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Hora est\u00e0ndard de Bangla Desh",
               "",
               "Hora d\u2019estiu de Bangla Desh",
               "",
               "Hora de Bangla Desh",
               "",
            };
        final String[] Peru = new String[] {
               "Hora est\u00e0ndard del Per\u00fa",
               "",
               "Hora d\u2019estiu del Per\u00fa",
               "",
               "Hora del Per\u00fa",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Hora est\u00e0ndard de l\u2019Est de Grenl\u00e0ndia",
               "",
               "Hora d\u2019estiu de l\u2019Est de Grenl\u00e0ndia",
               "",
               "Hora de l\u2019Est de Grenl\u00e0ndia",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hora de l\u2019est d\u2019Indon\u00e8sia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Hora del Kirguizistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Hora est\u00e0ndard d\u2019Austr\u00e0lia Oriental",
               "",
               "Hora d\u2019estiu d\u2019Austr\u00e0lia Oriental",
               "",
               "Hora d\u2019Austr\u00e0lia Oriental",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Hora de la Guaiana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Hora est\u00e0ndard de Col\u00f2mbia",
               "",
               "Hora d\u2019estiu de Col\u00f2mbia",
               "",
               "Hora de Col\u00f2mbia",
               "",
            };
        final String[] Chile = new String[] {
               "Hora est\u00e0ndard de Xile",
               "",
               "Hora d\u2019estiu de Xile",
               "",
               "Hora de Xile",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hora de les illes Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Hora est\u00e0ndard d\u2019Irkutsk",
               "",
               "Hora d\u2019estiu d\u2019Irkutsk",
               "",
               "Hora d\u2019Irkutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "Hora est\u00e0ndard de Ge\u00f2rgia",
               "",
               "Hora d\u2019estiu de Ge\u00f2rgia",
               "",
               "Hora de Ge\u00f2rgia",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Hora est\u00e0ndard de Choibalsan",
               "",
               "Hora d\u2019estiu de Choibalsan",
               "",
               "Hora de Choibalsan",
               "",
            };
        final String[] China = new String[] {
               "Hora est\u00e0ndard de la Xina",
               "",
               "Hora d\u2019estiu de la Xina",
               "",
               "Hora de la Xina",
               "",
            };
        final String[] Armenia = new String[] {
               "Hora est\u00e0ndard d\u2019Arm\u00e8nia",
               "",
               "Hora d\u2019estiu d\u2019Arm\u00e8nia",
               "",
               "Hora d\u2019Arm\u00e8nia",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Hora de l\u2019\u00c0frica Central",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Hora est\u00e0ndard del Jap\u00f3",
               "",
               "Hora d\u2019estiu del Jap\u00f3",
               "",
               "Hora del Jap\u00f3",
               "",
            };
        final String[] Taipei = new String[] {
               "Hora est\u00e0ndard de Taipei",
               "",
               "Hora d\u2019estiu de Taipei",
               "",
               "Hora de Taipei",
               "",
            };
        final String[] Hovd = new String[] {
               "Hora est\u00e0ndard de Hovd",
               "",
               "Hora d\u2019estiu de Hovd",
               "",
               "Hora de Hovd",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hora est\u00e0ndard d\u2019Austr\u00e0lia centre-occidental",
               "",
               "Hora d\u2019estiu d\u2019Austr\u00e0lia centre-occidental",
               "",
               "Hora d\u2019Austr\u00e0lia centre-occidental",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Hora est\u00e0ndard de Sakhalin",
               "",
               "Hora d\u2019estiu de Sakhalin",
               "",
               "Hora de Sakhalin",
               "",
            };
        final String[] Paraguay = new String[] {
               "Hora est\u00e0ndard del Paraguai",
               "",
               "Hora d\u2019estiu del Paraguai",
               "",
               "Hora del Paraguai",
               "",
            };
        final String[] Malaysia = new String[] {
               "Hora de Mal\u00e0isia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Temps universal coordinat",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Hora est\u00e0ndard de Maurici",
               "",
               "Hora d\u2019estiu de Maurici",
               "",
               "Hora de Maurici",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Hora de l\u2019\u00c0frica Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Hora de Salom\u00f3",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Hora de les illes Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Hora est\u00e0ndard de Terranova",
               "",
               "Hora d\u2019estiu de Terranova",
               "",
               "Hora de Terranova",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Hora de l\u2019Afganistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hora est\u00e0ndard de Hong Kong",
               "",
               "Hora d\u2019estiu de Hong Kong",
               "",
               "Hora de Hong Kong",
               "",
            };
        final String[] Atlantic = new String[] {
               "Hora est\u00e0ndard de l\u2019Atl\u00e0ntic",
               "",
               "Hora d\u2019estiu de l\u2019Atl\u00e0ntic",
               "",
               "Hora de l\u2019Atl\u00e0ntic",
               "",
            };
        final String[] Israel = new String[] {
               "Hora est\u00e0ndard d\u2019Israel",
               "",
               "Hora d\u2019estiu d\u2019Israel",
               "",
               "Hora d\u2019Israel",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Hora central d\u2019Indon\u00e8sia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Hora est\u00e0ndard d\u2019Omsk",
               "",
               "Hora d\u2019estiu d\u2019Omsk",
               "",
               "Hora d\u2019Omsk",
               "",
            };
        final String[] Seychelles = new String[] {
               "Hora de les Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Hora est\u00e0ndard de l\u2019Uruguai",
               "",
               "Hora d\u2019estiu de l\u2019Uruguai",
               "",
               "Hora de l\u2019Uruguai",
               "",
            };
        final String[] Nepal = new String[] {
               "Hora del Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "Hora de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Hora est\u00e0ndard de Vanatu",
               "",
               "Hora d\u2019estiu de Vanatu",
               "",
               "Hora de Vanatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Hora est\u00e0ndard de Novosibirsk",
               "",
               "Hora d\u2019estiu de Novosibirsk",
               "",
               "Hora de Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "Hora de Singapur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Hora est\u00e0ndard de les A\u00e7ores",
               "",
               "Hora d\u2019estiu de les A\u00e7ores",
               "",
               "Hora de les A\u00e7ores",
               "",
            };
        final String[] Suriname = new String[] {
               "Hora de Surinam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hora est\u00e0ndard de Krasnoiarsk",
               "",
               "Hora d\u2019estiu de Krasnoiarsk",
               "",
               "Hora de Krasnoiarsk",
               "",
            };
        final String[] Myanmar = new String[] {
               "Hora de Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Hora est\u00e0ndard de l\u2019Amazones",
               "",
               "Hora d\u2019estiu de l\u2019Amazones",
               "",
               "Hora de l\u2019Amazones",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Hora de l\u2019est del Kazakhstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Hora est\u00e0ndard de Fiji",
               "",
               "Hora d\u2019estiu de Fiji",
               "",
               "Hora de Fiji",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Hora est\u00e0ndard de Petropavlovsk de Kamtxatka",
               "",
               "Horari d\u2019estiu de Petropavlovsk de Kamtxatka",
               "",
               "Hora de Kamtxatka",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Hora de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Hora de Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hora est\u00e0ndard de Hawaii-Aleutianes",
               "",
               "Hora d\u2019estiu de Hawaii-Aleutianes",
               "",
               "Hora de Hawaii-Aleutianes",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Hora est\u00e0ndard d\u2019Austr\u00e0lia Central",
               "",
               "Hora d\u2019estiu d\u2019Austr\u00e0lia Central",
               "",
               "Hora d\u2019Austr\u00e0lia Central",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Hora est\u00e0ndard del Pac\u00edfic",
               "",
               "Hora d\u2019estiu del Pac\u00edfic",
               "",
               "Hora del Pac\u00edfic",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Hora est\u00e0ndard del Turkmenistan",
               "",
               "Hora d\u2019estiu del Turkmenistan",
               "",
               "Hora del Turkmenistan",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Hora est\u00e0ndard de l\u2019Oest d\u2019Europa",
               "WET",
               "Hora d\u2019estiu de l\u2019Oest d\u2019Europa",
               "WEST",
               "Hora de l\u2019Oest d\u2019Europa",
               "WET",
            };
        final String[] Guyana = new String[] {
               "Hora de Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Hora de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Hora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Hora de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Hora est\u00e0ndard d\u2019Azerbaidjan",
               "",
               "Hora d\u2019estiu d\u2019Azerbaidjan",
               "",
               "Hora d\u2019Azerbaidjan",
               "",
            };
        final String[] Mawson = new String[] {
               "Hora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hora est\u00e0ndard del Pac\u00edfic de M\u00e8xic",
               "",
               "Hora d\u2019estiu del Pac\u00edfic de M\u00e8xic",
               "",
               "Hora del Pac\u00edfic de M\u00e8xic",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Hora est\u00e0ndard de l\u2019\u00c0frica Occidental",
               "",
               "Hora d\u2019estiu de l\u2019\u00c0frica Occidental",
               "",
               "Hora de l\u2019\u00c0frica Occidental",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Hora de Ge\u00f2rgia del Sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Hora est\u00e0ndard de l\u2019illa de Pasqua",
               "",
               "Hora d\u2019estiu de l\u2019illa de Pasqua",
               "",
               "Hora de l\u2019illa de Pasqua",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Hora est\u00e0ndard del nord-oest de M\u00e8xic",
               "",
               "Hora d\u2019estiu del nord-oest de M\u00e8xic",
               "",
               "Hora del nord-oest de M\u00e8xic",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Hora de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Hora est\u00e0ndard de l\u2019Oest de Grenl\u00e0ndia",
               "",
               "Hora d\u2019estiu de l\u2019Oest de Grenl\u00e0ndia",
               "",
               "Hora de l\u2019Oest de Grenl\u00e0ndia",
               "",
            };
        final String[] Ecuador = new String[] {
               "Hora de l\u2019Equador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Hora del Golf",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Hora est\u00e0ndard de Corea",
               "",
               "Hora d\u2019estiu de Corea",
               "",
               "Hora de Corea",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Hora est\u00e0ndard d\u2019Austr\u00e0lia Occidental",
               "",
               "Hora d\u2019estiu d\u2019Austr\u00e0lia Occidental",
               "",
               "Hora d\u2019Austr\u00e0lia Occidental",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Hora de l\u2019oest d\u2019Indon\u00e8sia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Hora est\u00e0ndard de muntanya d\u2019Am\u00e8rica del Nord",
               "",
               "Hora d\u2019estiu de muntanya d\u2019Am\u00e8rica del Nord",
               "",
               "Hora de muntanya d\u2019Am\u00e8rica del Nord",
               "",
            };
        final String[] Marquesas = new String[] {
               "Hora de les Marqueses",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Hora est\u00e0ndard \u00e0rab",
               "",
               "Hora d\u2019estiu \u00e0rab",
               "",
               "Hora \u00e0rab",
               "",
            };
        final String[] Alaska = new String[] {
               "Hora est\u00e0ndard d\u2019Alaska",
               "",
               "Hora d\u2019estiu d\u2019Alaska",
               "",
               "Hora d\u2019Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Hora est\u00e0ndard de Vladivostok",
               "",
               "Hora d\u2019estiu de Vladivostok",
               "",
               "Hora de Vladivostok",
               "",
            };
        final String[] Chamorro = new String[] {
               "Hora de Chamorro",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Hora de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hora de Papua Nova Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Hora est\u00e0ndard de Fernando de Noronha",
               "",
               "Hora d\u2019estiu de Fernando de Noronha",
               "",
               "Hora de Fernando de Noronha",
               "",
            };
        final String[] Brasilia = new String[] {
               "Hora est\u00e0ndard de Bras\u00edlia",
               "",
               "Hora d\u2019estiu de Bras\u00edlia",
               "",
               "Hora de Bras\u00edlia",
               "",
            };
        final String[] Anadyr = new String[] {
               "Hora est\u00e0ndard d\u2019Anadyr",
               "",
               "Horari d\u2019estiu d\u2019Anadyr",
               "",
               "Hora d\u2019Anadyr",
               "",
            };
        final String[] Samara = new String[] {
               "Hora est\u00e0ndard de Samara",
               "",
               "Hora d\u2019estiu de Samara",
               "",
               "Hora de Samara",
               "",
            };
        final String[] Pyongyang = new String[] {
               "Hora de Pyongyang",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hora est\u00e0ndard de l\u2019\u00cdndia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Hora est\u00e0ndard de les illes Cook",
               "",
               "Hora de mig estiu de les illes Cook",
               "",
               "Hora de les illes Cook",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Phoenix" },
            { "timezone.excity.Asia/Katmandu", "Katmand\u00fa" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Marqueses" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Danmarkshavn" },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Hora del Meridi\u00e0 de Greenwich",
                    "GMT",
                    "Hora d\u2019estiu brit\u00e0nica",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota del Nord" },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fiji" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "BET", Brasilia },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "Londres" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoiarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nome" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Choibalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Miquelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaia" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota del Nord" },
            { "timezone.excity.America/Cayenne", "Caiena" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Johnston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersey" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtung" },
            { "timezone.excity.Atlantic/South_Georgia", "Ge\u00f2rgia del Sud" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Havana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroit" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnom Penh" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Asia/Hebron", "Hebron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mawson" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.America/Resolute", "Resolute" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Masqat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "Al-aaiun" },
            { "timezone.excity.Australia/Hobart", "Hobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota del Nord" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bixkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Ojinaga" },
            { "timezone.excity.Europe/Zurich", "Zuric" },
            { "Europe/Samara", Samara },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "Nova York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "Ciutat desconeguda" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Thule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Europe/Uzhgorod", "Uzhgorod" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Dawson_Creek", "Dawson Creek" },
            { "timezone.excity.America/Bogota", "Bogot\u00e0" },
            { "timezone.excity.Asia/Baku", "Bak\u00fa" },
            { "timezone.excity.Asia/Hovd", "Hovd" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blanc Sablon" },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Khandyga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/Rio_Branco", "R\u00edo Branco" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Uli\u00e0novsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Hora del Meridi\u00e0 de Greenwich",
                    "GMT",
                    "Hora est\u00e0ndard d\u2019Irlanda",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Sar\u00e0tov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Aqtobe" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Saint Helena" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrain" },
            { "timezone.excity.Indian/Mahe", "Mahe" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "timezone.excity.Europe/Isle_of_Man", "Man" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Cura\u00e7ao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Par\u00eds" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "timezone.excity.America/Scoresbysund", "Scoresbysund" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Swift Current" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.America/Catamarca", "Catamarca" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "timezone.excity.Asia/Chita", "Txit\u00e0" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin Inlet" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "H\u00e8lsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr\u2019" },
            { "timezone.excity.Asia/Urumqi", "Urumchi" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Douala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Muqdiisho" },
            { "timezone.excity.Asia/Jayapura", "Jaipur" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalcanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Kuwait" },
            { "timezone.excity.America/Santo_Domingo", "Santo Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moscou" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Hora del Meridi\u00e0 de Greenwich",
                    "GMT",
                    "Hora d\u2019estiu brit\u00e0nica",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dacca" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigot" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulaanbaatar" },
            { "timezone.excity.Antarctica/McMurdo", "McMurdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "T\u00f2quio" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dubl\u00edn" },
            { "timezone.excity.Antarctica/Casey", "Casey" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cap Verd" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Goose Bay" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "Pacific/Noumea", New_Caledonia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "A\u00e7ores" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vientiane" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Christmas" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Aqta\u016b" },
            { "timezone.excity.America/Regina", "Regina" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Thunder Bay" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Louisville" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.Australia/Broken_Hill", "Broken Hill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Pacific/Tarawa", "Tarawa" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.America/Moncton", "Moncton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "V\u00edlnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjavik" },
            { "timezone.excity.Asia/Kamchatka", "Kamtxatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Taixkent" },
            { "timezone.excity.America/Argentina/San_Juan", "San Juan" },
            { "timezone.excity.Antarctica/Rothera", "Rothera" },
            { "timezone.excity.Asia/Shanghai", "Xangai" },
            { "timezone.excity.America/Juneau", "Juneau" },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "El Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Illa de Pasqua" },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menominee" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord Howe" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Wake" },
            { "timezone.excity.Atlantic/Canary", "Illes Can\u00e0ries" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Glace Bay" },
            { "timezone.excity.Africa/Casablanca", "Casablanca" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendijk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Erevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Creston" },
            { "timezone.excity.Africa/Cairo", "Caire, el" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Vars\u00f2via" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.America/Dawson", "Dawson" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Guadeloupe" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vatic\u00e0" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Rainy River" },
            { "timezone.excity.Asia/Beirut", "Beirut" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Guayaquil", "Guayaquil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.America/Panama", "Panam\u00e0" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kerguelen" },
            { "CNT", Newfoundland },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "M\u00f2naco" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edpoli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Asia/Pyongyang", "Pyongyang" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Atenes" },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Porto Velho" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Copenhagen" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Jerusalem" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Al-Riy\u0101d" },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust\u2019-Nera" },
            { "timezone.excity.Asia/Damascus", "Damasc" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Bahia" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Pacific/Tahiti", "Tahit\u00ed" },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "CST", America_Central },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astrakhan" },
            { "timezone.excity.America/Yellowknife", "Yellowknife" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "timezone.excity.Africa/Ceuta", "Ceuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Eucla" },
            { "timezone.excity.America/Mexico_City", "Ciutat de M\u00e8xic" },
            { "timezone.excity.Pacific/Kwajalein", "Kwajalein" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.America/Boise", "Boise" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zapor\u00edjia" },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Colombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronha" },
            { "timezone.excity.Asia/Sakhalin", "Sakhalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Guernsey" },
            { "timezone.excity.America/Argentina/San_Luis", "San Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Cambridge_Bay", "Cambridge Bay" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Campo Grande" },
            { "timezone.excity.Africa/Blantyre", "Blantyre" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Davis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Kizil-Orda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Maurici" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La Rioja" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Maarianhamina" },
            { "timezone.excity.America/St_Johns", "Saint John\u2019s" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barth\u00e9lemy" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Oral" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Se\u00fcl" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Busingen", "Busingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "NST", New_Zealand },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Caiman" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nic\u00f2sia" },
            { "timezone.excity.Europe/Kiev", "K\u00edev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Atlantic/Faeroe", "Illes F\u00e8roe" },
            { "timezone.excity.America/Whitehorse", "Whitehorse" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Halifax" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Ashgabat" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Syowa" },
            { "timezone.excity.America/Jamaica", "Jamaica" },
            { "timezone.excity.America/Hermosillo", "Hermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "Reuni\u00f3" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stanley" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Thimphu", "Thimbu" },
            { "timezone.excity.Asia/Dubai", "Dubai" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Anadyr", Anadyr },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "K\u0101bul" },
            { "timezone.excity.America/Iqaluit", "Iqaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudes" },
            { "timezone.excity.Pacific/Saipan", "Saipan" },
            { "timezone.excity.Indian/Cocos", "Cocos" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Brussel\u00b7les" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Comoro" },
            { "timezone.excity.America/Boa_Vista", "Boa Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Estocolm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tijuana" },
            { "timezone.excity.Indian/Maldives", "Maldives" },
        };
        return data;
    }
}
