/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_yo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_lo = "L\u00e1\u00f2";
        final String metaValue_ml = "M\u00e1l\u00e0y\u00e1l\u00e1m\u00f9";
        final String metaValue_mn = "M\u00f2ng\u00f3l\u00ed\u00e0";
        final String metaValue_or = "\u00d2d\u00ed\u00e0";
        final Object[][] data = new Object[][] {
            { "sbp", "Sangu" },
            { "ksh", "Colognian" },
            { "nyn", "\u0143y\u00e1k\u1ecd\u0301l\u00e8" },
            { "Zsym", "\u00c0w\u1ecdn \u00e0m\u00ec" },
            { "fil", "\u00c8d\u00e8 Filipino" },
            { "hmn", "Hmong" },
            { "Zsye", "\u00c9m\u00f3j\u00ec" },
            { "ccp", "Chakma" },
            { "luy", "Luy\u00ed\u00e0" },
            { "bas", "Basaa" },
            { "es_ES", "\u00c8d\u00e8 S\u00edp\u00e1n\u00ed\u00ec\u1e63\u00ec (or\u00edl\u1eb9\u0300-\u00e8d\u00e8 Y\u00far\u00f3\u00f2p\u00f9)" },
            { "teo", "T\u1eb9\u0301s\u00f2" },
            { "AC", "Er\u00e9k\u00f9s\u00f9 Ascension" },
            { "AD", "Or\u00edl\u1eb9\u0301\u00e8de \u00c0\u00e0nd\u00f3r\u00e0" },
            { "AE", "Or\u00edl\u1eb9\u0301\u00e8de \u1eb8mirate ti Aw\u1ecdn Arabu" },
            { "AF", "Or\u00edl\u1eb9\u0301\u00e8de \u00c0f\u00f9g\u00e0n\u00edst\u00e1n\u00ec" },
            { "af", "\u00c8d\u00e8 Afrikani" },
            { "AG", "Or\u00edl\u1eb9\u0301\u00e8de \u00c0\u00e0nt\u00edg\u00fa\u00e0 \u00e0ti B\u00e1r\u00edb\u00fad\u00e0" },
            { "type.ca.ethiopic", "K\u00e0l\u1eb9\u0300\u0144d\u00e0 \u1eb8t\u00ed\u00f3p\u00ed\u00eck\u00ec" },
            { "AI", "Or\u00edl\u1eb9\u0301\u00e8de \u00c0\u00e0ng\u00fal\u00edl\u00e0" },
            { "ak", "\u00c8d\u00e8 Akani" },
            { "AL", "Or\u00edl\u1eb9\u0301\u00e8de \u00c0l\u00f9b\u00e0n\u00ed\u00e1n\u00ec" },
            { "AM", "Or\u00edl\u1eb9\u0301\u00e8de Am\u00e9n\u00ed\u00e0" },
            { "am", "\u00c8d\u00e8 Amariki" },
            { "Arab", "\u00e8d\u00e8 L\u00e1r\u00fab\u00e1w\u00e1" },
            { "AO", "Or\u00edl\u1eb9\u0301\u00e8de \u00c0\u00e0ng\u00f3l\u00e0" },
            { "AQ", "Antak\u00edt\u00edk\u00e0" },
            { "Jpan", "\u00e8d\u00e8 j\u00e0p\u00e1\u00e0n\u00f9" },
            { "AR", "Or\u00edl\u1eb9\u0301\u00e8de Agent\u00edn\u00e0" },
            { "ar", "\u00c8d\u00e8 \u00c1r\u00e1b\u00eck\u00ec" },
            { "Hrkt", "\u00ecl\u00e0n\u00e0 \u00e0f\u1ecdw\u1ecd\u0301k\u1ecd ar\u00e1 J\u00e0p\u00e1n\u00f9" },
            { "AS", "S\u00e1m\u00f3\u00e1n\u00ec ti Or\u00edl\u1eb9\u0301\u00e8de \u00c0m\u00e9r\u00edk\u00e0" },
            { "as", "Ti Assam" },
            { "AT", "Or\u00edl\u1eb9\u0301\u00e8de As\u00edt\u00edr\u00ed\u00e0" },
            { "AU", "Or\u00edl\u1eb9\u0301\u00e8de \u00c1str\u00e0l\u00ec\u00e1" },
            { "AW", "Or\u00edl\u1eb9\u0301\u00e8de \u00c1r\u00fab\u00e0" },
            { "AX", "\u00c0w\u1ecdn Er\u00e9k\u00f9s\u00f9 ti \u00c5land" },
            { "AZ", "Or\u00edl\u1eb9\u0301\u00e8de As\u1eb9\u0301b\u00e1j\u00e1n\u00ec" },
            { "az", "\u00c8d\u00e8 Azerbaijani" },
            { "BA", "Or\u00edl\u1eb9\u0301\u00e8de B\u1ecd\u0300s\u00edn\u00ed\u00e0 \u00e0ti \u1eb8tis\u1eb9g\u00f3f\u00edn\u00e0" },
            { "BB", "Or\u00edl\u1eb9\u0301\u00e8de B\u00e1b\u00e1d\u00f3s\u00ec" },
            { "ceb", "Cebuano" },
            { "BD", "Or\u00edl\u1eb9\u0301\u00e8de B\u00e1ng\u00e1l\u00e1d\u00e9s\u00ec" },
            { "BE", "Or\u00edl\u1eb9\u0301\u00e8de B\u00e9g\u00ed\u1ecd\u0301m\u00f9" },
            { "be", "\u00c8d\u00e8 Belarusi" },
            { "BF", "Or\u00edl\u1eb9\u0301\u00e8de B\u00f9\u00f9k\u00edn\u00e1 Fas\u00f2" },
            { "BG", "Or\u00edl\u1eb9\u0301\u00e8de B\u00f9\u00f9g\u00e1r\u00ed\u00e0" },
            { "bg", "\u00c8d\u00e8 Bugaria" },
            { "BH", "Or\u00edl\u1eb9\u0301\u00e8de B\u00e1r\u00e1n\u00ec" },
            { "BI", "Or\u00edl\u1eb9\u0301\u00e8de B\u00f9\u00f9r\u00fand\u00ec" },
            { "BJ", "Or\u00edl\u1eb9\u0301\u00e8de B\u1eb9\u0300n\u1eb9\u0300" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Or\u00edl\u1eb9\u0301\u00e8de B\u00e9m\u00fad\u00e0" },
            { "bm", "B\u00e1\u1e3fb\u00e0r\u00e0" },
            { "BN", "Or\u00edl\u1eb9\u0301\u00e8de B\u00far\u00fan\u1eb9\u0301l\u00ec" },
            { "bn", "\u00c8d\u00e8 Bengali" },
            { "BO", "Or\u00edl\u1eb9\u0301\u00e8de B\u1ecd\u0300l\u00edf\u00edy\u00e0" },
            { "bo", "Tibet\u00e1n" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Oril\u1eb9\u0300-\u00e8d\u00e8 B\u00e0r\u00e0s\u00edl\u00ec" },
            { "br", "\u00c8d\u00e8 Bretoni" },
            { "BS", "Or\u00edl\u1eb9\u0301\u00e8de B\u00e0h\u00e1m\u00e1s\u00ec" },
            { "bs", "\u00c8d\u00e8 Bosnia" },
            { "xog", "\u1e62\u00f3g\u00e0" },
            { "BT", "Or\u00edl\u1eb9\u0301\u00e8de B\u00fat\u00e1n\u00ec" },
            { "BV", "Er\u00e9k\u00f9s\u00f9 Bouvet" },
            { "BW", "Or\u00edl\u1eb9\u0301\u00e8de B\u1ecd\u0300t\u00ecs\u00faw\u00e1n\u00e0" },
            { "Mymr", "My\u00e1nmar\u00e0" },
            { "type.nu.laoo", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec L\u00e1\u00f3" },
            { "BY", "Or\u00edl\u1eb9\u0301\u00e8de B\u00e9l\u00e1r\u00fas\u00ec" },
            { "seh", "\u1e62\u1eb9n\u00e0" },
            { "BZ", "Or\u00edl\u1eb9\u0301\u00e8de B\u00e8l\u00eds\u1eb9\u0300" },
            { "type.ca.persian", "K\u00e0l\u1eb9\u0300\u0144d\u00e0 P\u00e1s\u00ed\u00e0n\u00f9" },
            { "type.nu.hebr", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 H\u00e9b\u00e9r\u00f9" },
            { "CA", "Or\u00edl\u1eb9\u0301\u00e8de K\u00e1n\u00e1d\u00e0" },
            { "ca", "\u00c8d\u00e8 Catala" },
            { "CC", "Er\u00e9k\u00f9s\u00f9 Cocos (Keeling)" },
            { "mzn", "Masanderani" },
            { "ses", "Koiraboro Seni" },
            { "CD", "Oril\u1eb9\u0301\u00e8de K\u00f3ng\u00f2" },
            { "ce", "Chechen" },
            { "CF", "Or\u00edl\u1eb9\u0301\u00e8de \u00c0rin g\u00f9ngun \u00c1f\u00edr\u00edk\u00e0" },
            { "CG", "Or\u00edl\u1eb9\u0301\u00e8de K\u00f3ng\u00f2" },
            { "CH", "Or\u00edl\u1eb9\u0301\u00e8de switi\u1e63ilandi" },
            { "CI", "Or\u00edl\u1eb9\u0301\u00e8de K\u00f3\u00fat\u00e8 for\u00e0" },
            { "CK", "Or\u00edl\u1eb9\u0301\u00e8de Et\u00edokun K\u00f9\u00fak\u00f9" },
            { "CL", "Or\u00edl\u1eb9\u0301\u00e8de \u1e63\u00edl\u00e8" },
            { "CM", "Or\u00edl\u1eb9\u0301\u00e8de Kamer\u00fa\u00fan\u00ec" },
            { "CN", "Oril\u1eb9\u0300-\u00e8d\u00e8 \u1e62\u00e1\u00edn\u00e0" },
            { "CO", "Or\u00edl\u1eb9\u0301\u00e8de K\u00f2l\u00f3m\u00edb\u00eca" },
            { "co", "Corsican" },
            { "CP", "Er\u00e9k\u00f9s\u00f9 Clipperston" },
            { "Orya", metaValue_or },
            { "CR", "Or\u00edl\u1eb9\u0301\u00e8de Kuusita R\u00edk\u00e0" },
            { "cs", "\u00c8d\u00e8 seeki" },
            { "CU", "Or\u00edl\u1eb9\u0301\u00e8de K\u00fab\u00e0" },
            { "cu", "S\u00edl\u00e1f\u00ed\u00edk\u00ec Il\u00e9 \u00ccj\u1ecd\u0301s\u00ecn" },
            { "CV", "Or\u00edl\u1eb9\u0301\u00e8de Et\u00edokun K\u00e1p\u00e9 f\u00e9nd\u00e8" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Er\u00e9k\u00f9s\u00f9 Christmas" },
            { "CY", "Or\u00edl\u1eb9\u0301\u00e8de K\u00far\u00fas\u00ec" },
            { "cy", "\u00c8d\u00e8 Welshi" },
            { "CZ", "Or\u00edl\u1eb9\u0301\u00e8de \u1e63\u1eb9\u0301\u1eb9\u0301k\u00ec" },
            { "type.nu.ethi", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u1eb8ti\u00f3p\u00ed\u00eck\u00ec" },
            { "da", "\u00c8d\u00e8 Il\u1eb9\u0300 Denmark" },
            { "pt_PT", "\u00c8d\u00e8 P\u1ecdtog\u00ed (or\u00edl\u1eb9\u0300-\u00e8d\u00e8 Y\u00far\u00f3\u00f2p\u00f9)" },
            { "DE", "Or\u00edl\u1eb9\u00e8d\u00e8 J\u00e1m\u00e1n\u00ec" },
            { "de", "\u00c8d\u00e8 J\u00e1m\u00e1n\u00ec" },
            { "cgg", "Chiga" },
            { "DG", "Diego Ga\u1e63ia" },
            { "type.cf.standard", "\u00ccg\u00fanr\u00e9g\u00e9 Gb\u00e8d\u00e9ke K\u1ecd\u0301r\u1eb9\u0301\u0144s\u00ec" },
            { "type.nu.deva", "\u00c0w\u1ecdn d\u00edj\u00ec\u00ect\u00ec Defanag\u00e1r\u00ec" },
            { "DJ", "Or\u00edl\u1eb9\u0301\u00e8de D\u00edb\u1ecd\u0301\u00f3t\u00ec" },
            { "DK", "Or\u00edl\u1eb9\u0301\u00e8de D\u1eb9\u0301m\u00e1k\u00ec" },
            { "Brai", "B\u00edr\u00e1\u00ecl\u00e8" },
            { "DM", "Or\u00edl\u1eb9\u0301\u00e8de D\u00f2m\u00edn\u00edk\u00e0" },
            { "type.nu.armnlow", "\u00c0w\u1ecdn N\u1ecd\u0301\u0144b\u00e0 K\u00e9k\u00e8k\u00e9 ti Am\u1eb9\u0301r\u00edk\u00e0" },
            { "DO", "Oril\u1eb9\u0301\u00e8de D\u00f2m\u00edn\u00edk\u00e1n\u00ec" },
            { "bem", "B\u00e9\u1e3fb\u00e0" },
            { "es_419", "\u00c8d\u00e8 S\u00edp\u00e1n\u00ed\u00ec\u1e63\u00ec (or\u00edl\u1eb9\u0300-\u00e8d\u00e8 L\u00e1t\u00ecn-Am\u1eb9\u0301r\u00edk\u00e0) ( \u00c8d\u00e8 S\u00edp\u00e1n\u00ed\u00ecsh\u00ec (L\u00e1t\u00ecn-Am\u1eb9\u0301r\u00edk\u00e0)" },
            { "DZ", "Or\u00edl\u1eb9\u0301\u00e8de \u00c0l\u00f9g\u00e8r\u00ed\u00e1n\u00ec" },
            { "dz", "Dzongkha" },
            { "bez", "B\u1eb9\u0301n\u00e0" },
            { "type.ca.chinese", "K\u00e0l\u1eb9\u0300\u0144d\u00e0 ti \u1e62\u00e1\u00ecn\u00e0" },
            { "EA", "Seuta \u00e0ti Melilla" },
            { "EC", "Or\u00edl\u1eb9\u0301\u00e8de Eku\u00e1d\u00f2" },
            { "dje", "\u1e62\u00e1r\u00fam\u00e0" },
            { "type.nu.grek", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 G\u00edr\u00ed\u00eck\u00ec" },
            { "EE", "Or\u00edl\u1eb9\u0301\u00e8de Esitonia" },
            { "ee", "Ew\u00e8" },
            { "type.lb.normal", "\u00c0ra \u00ccda \u00ccl\u00e0 D\u00e9\u00e9d\u00e9\u00e9" },
            { "EG", "Or\u00edl\u1eb9\u0301\u00e8de \u00c9g\u00edp\u00edt\u00ec" },
            { "EH", "\u00ccw\u1ecd\u0300\u00f2\u00f2r\u00f9n S\u00e0h\u00e1r\u00e0" },
            { "el", "\u00c8d\u00e8 Giriki" },
            { "en", "\u00c8d\u00e8 G\u1eb9\u0300\u1eb9\u0301s\u00ec" },
            { "eo", "\u00c8d\u00e8 Esperanto" },
            { "chr", "Sh\u1eb9\u0301r\u00f3ki\u00ec" },
            { "ER", "Or\u00edl\u1eb9\u0301\u00e8de Eritira" },
            { "ES", "Or\u00edl\u1eb9\u0301\u00e8de Sipani" },
            { "es", "\u00c8d\u00e8 S\u00edp\u00e1n\u00ed\u00ec\u1e63\u00ec" },
            { "ET", "Or\u00edl\u1eb9\u0301\u00e8de Etopia" },
            { "et", "\u00c8d\u00e8 Estonia" },
            { "Hanb", "Han p\u1eb9\u0300l\u00fa Bopom\u00f3f\u00f2" },
            { "EU", "\u00cc\u1e63\u1ecd\u0300kan Y\u00far\u00f2p\u00f9" },
            { "eu", "\u00c8d\u00e8 Baski" },
            { "Hang", "H\u00e1\u0144g\u00f9l\u00f9" },
            { "type.ca.gregorian", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 Gregory" },
            { "EZ", "Agb\u00e8gb\u00e8 Euro" },
            { "shi", "Ta\u1e63el\u00ed\u00ect\u00ec" },
            { "type.nu.gujr", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec G\u00f9j\u00e1r\u00e1t\u00ec" },
            { "hsb", "Sorbian Ap\u00e1 \u00d2k\u00e8" },
            { "Hani", "H\u00e1\u00e0n\u00f9" },
            { "fa", "\u00c8d\u00e8 Pasia" },
            { "Hans", "t\u00ed w\u1ecd\u0301n m\u00fa r\u1ecdr\u00f9n." },
            { "type.nu.latn", "D\u00edj\u00ed\u00edt\u00ec \u00ccw\u1ecd\u0300 O\u00f2r\u00f9n" },
            { "Hant", "Hans \u00e0t\u1ecdw\u1ecd\u0301d\u1ecd\u0301w\u1ecd\u0301" },
            { "ff", "\u00c8d\u00e8 F\u00fal\u00e0n\u00ed" },
            { "FI", "Or\u00edl\u1eb9\u0301\u00e8de Filandi" },
            { "fi", "\u00c8d\u00e8 Finisi" },
            { "FJ", "Or\u00edl\u1eb9\u0301\u00e8de Fiji" },
            { "FK", "Or\u00edl\u1eb9\u0301\u00e8de Etikun Fakalandi" },
            { "FM", "Or\u00edl\u1eb9\u0301\u00e8de Makoronesia" },
            { "yue", "Cantonese" },
            { "FO", "\u00c0w\u1ecdn Er\u00e9k\u00f9s\u00f9 ti Faroe" },
            { "fo", "\u00c8d\u00e8 Faroesi" },
            { "Taml", "T\u00e1m\u00edl\u00ec" },
            { "FR", "Or\u00edl\u1eb9\u0301\u00e8de Faranse" },
            { "fr", "\u00c8d\u00e8 Farans\u00e9" },
            { "fy", "\u00c8d\u00e8 Frisia" },
            { "GA", "Or\u00edl\u1eb9\u0301\u00e8de Gabon" },
            { "ga", "\u00c8d\u00e8 Ireland" },
            { "GB", "Or\u00edl\u1eb9\u0301\u00e8d\u00e8 G\u1eb9\u0300\u1eb9\u0301s\u00ec" },
            { "GD", "Or\u00edl\u1eb9\u0301\u00e8de Genada" },
            { "gd", "\u00c8d\u00e8 Gaelik ti Ilu Scotland" },
            { "GE", "Or\u00edl\u1eb9\u0301\u00e8de G\u1ecdgia" },
            { "GF", "Or\u00edl\u1eb9\u0301\u00e8de Firen\u1e63i Guana" },
            { "GG", "Guernsey" },
            { "GH", "Or\u00edl\u1eb9\u0301\u00e8de Gana" },
            { "GI", "Or\u00edl\u1eb9\u0301\u00e8de Gibaratara" },
            { "GL", "Or\u00edl\u1eb9\u0301\u00e8de Gerelandi" },
            { "gl", "\u00c8d\u00e8 Galicia" },
            { "GM", "Or\u00edl\u1eb9\u0301\u00e8de Gambia" },
            { "GN", "Or\u00edl\u1eb9\u0301\u00e8de Gene" },
            { "gn", "\u00c8d\u00e8 Guarani" },
            { "GP", "Or\u00edl\u1eb9\u0301\u00e8de Gadelope" },
            { "GQ", "Or\u00edl\u1eb9\u0301\u00e8de Ekutoria Gini" },
            { "und", "\u00c8d\u00e8 \u00e0\u00ecm\u1ecd\u0300" },
            { "GR", "Or\u00edl\u1eb9\u0301\u00e8de Geriisi" },
            { "GS", "G\u00fa\u00fas\u00f9 Georgia \u00e0ti G\u00fa\u00fas\u00f9 \u00c0w\u1ecdn Er\u00e9k\u00f9s\u00f9 Sandwich" },
            { "GT", "Or\u00edl\u1eb9\u0301\u00e8de Guatemala" },
            { "GU", "Or\u00edl\u1eb9\u0301\u00e8de Guamu" },
            { "gu", "\u00c8d\u00e8 Gujarati" },
            { "gv", "M\u00e1\u01f9k\u00ec" },
            { "GW", "Or\u00edl\u1eb9\u0301\u00e8de Gene-Busau" },
            { "tlh", "\u00c8d\u00e8 Klingoni" },
            { "GY", "Or\u00edl\u1eb9\u0301\u00e8de Guyana" },
            { "ha", "\u00c8d\u00e8 Hausa" },
            { "ckb", "\u00c0\u00e0rin Gb\u00f9ngb\u00f9n Kurdish" },
            { "zxx", "K\u00f2 s\u00ed \u00e0k\u00f3\u00f2n\u00fa el\u00e9d\u00e8" },
            { "he", "\u00c8d\u00e8 Heberu" },
            { "hi", "\u00c8d\u00e8 H\u00ed\u0144d\u00ec" },
            { "de_AT", "\u00c8d\u00e8 J\u00e1m\u00e1n\u00ec (\u1ecc\u0301s\u00edr\u00ed\u00e0 )" },
            { "HK", "Hong Kong SAR ti \u1e62\u00e1\u00ecn\u00e0" },
            { "HM", "Er\u00e9k\u00f9s\u00f9 Heard \u00e0ti Er\u00e9k\u00f9s\u00f9 McDonald" },
            { "HN", "Or\u00edl\u1eb9\u0301\u00e8de Hondurasi" },
            { "HR", "Or\u00edl\u1eb9\u0301\u00e8de K\u00f2r\u00f3\u00e1t\u00ed\u00e0" },
            { "hr", "\u00c8d\u00e8 Kroatia" },
            { "agq", "\u00c1g\u1eb9\u0300\u1eb9\u0300m\u00f9" },
            { "gsw", "S\u00faw\u00eds\u00ec ti J\u00e1m\u00e1n\u00ec" },
            { "HT", "Or\u00edl\u1eb9\u0301\u00e8de Haati" },
            { "ht", "Haitian Creole" },
            { "HU", "Or\u00edl\u1eb9\u0301\u00e8de Hungari" },
            { "hu", "\u00c8d\u00e8 Hungaria" },
            { "hy", "\u00c8d\u00e8 Ile Armenia" },
            { "ia", "\u00c8d\u00e8 pipo" },
            { "IC", "\u1eb8r\u00e9k\u00f9s\u00f9 K\u00e1n\u00e1r\u00ec" },
            { "ID", "Or\u00edl\u1eb9\u0301\u00e8de Indonesia" },
            { "id", "\u00c8d\u00e8 Indon\u00e9\u1e63\u00ed\u00e0" },
            { "type.nu.tibt", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec Tibet\u00e1n" },
            { "IE", "Or\u00edl\u1eb9\u0301\u00e8de Ailandi" },
            { "ie", "Iru \u00c8d\u00e8" },
            { "ig", "\u00c8d\u00e8 Y\u00edb\u00f2" },
            { "naq", "N\u00e1m\u00e0" },
            { "ii", "\u1e62\u00edku\u00e1n Y\u00ec" },
            { "IL", "Or\u00edl\u1eb9\u0301\u00e8de Iser\u1eb9li" },
            { "IM", "Isle of Man" },
            { "IN", "Or\u00edl\u1eb9\u0301\u00e8de India" },
            { "IO", "Or\u00edl\u1eb9\u0301\u00e8de Et\u00edkun \u00cdnd\u00ed\u00e1n\u00ec ti \u00ccl\u00fa B\u00edr\u00edt\u00eds\u00ec" },
            { "IQ", "Or\u00edl\u1eb9\u0301\u00e8de Iraki" },
            { "IR", "Or\u00edl\u1eb9\u0301\u00e8de Irani" },
            { "IS", "Or\u00edl\u1eb9\u0301\u00e8de A\u1e63ilandi" },
            { "is", "\u00c8d\u00e8 Icelandic" },
            { "IT", "Or\u00edl\u1eb9\u0301\u00e8de It\u00e1li" },
            { "it", "\u00c8d\u00e8 \u00cdt\u00e1l\u00ec" },
            { "Zmth", "\u00c0m\u00ec \u00cc\u1e63\u00e8s\u00ecr\u00f2" },
            { "type.nu.thai", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec Thai" },
            { "type.nu.beng", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec B\u00e1\u0144g\u00edl\u00e0" },
            { "Mlym", metaValue_ml },
            { "ja", "\u00c8d\u00e8 J\u00e0p\u00e1\u00e0n\u00f9" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "K\u00e0l\u1eb9\u0300\u0144d\u00e0 L\u00e1r\u00fab\u00e1w\u00e1" },
            { "JM", "Or\u00edl\u1eb9\u0301\u00e8de Jamaika" },
            { "Beng", "B\u00e1\u0144g\u00edl\u00e0" },
            { "JO", "Or\u00edl\u1eb9\u0301\u00e8de J\u1ecddani" },
            { "JP", "Or\u00edl\u1eb9\u0301\u00e8de Japani" },
            { "jv", "\u00c8d\u00e8 Javanasi" },
            { "guz", "Gusii" },
            { "type.nu.knda", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec kanada" },
            { "de_CH", "\u00c8d\u00e8 Il\u1eb9\u0300 J\u00e1m\u00e1n\u00ec (Or\u00edl\u1eb9\u0301\u00e8de sw\u00edts\u00e0land\u00ec)" },
            { "smn", "Inari Sami" },
            { "ka", "\u00c8d\u00e8 Georgia" },
            { "type.ca.buddhist", "K\u00e0l\u1eb9\u0300\u0144d\u00e0 Buddhist" },
            { "KE", "Or\u00edl\u1eb9\u0301\u00e8de Kenya" },
            { "419", "L\u00e1t\u00edn Am\u1eb9\u0301r\u00edk\u00e0" },
            { "KG", "Or\u00edl\u1eb9\u0301\u00e8de Kuri\u1e63isitani" },
            { "KH", "Or\u00edl\u1eb9\u0301\u00e8de K\u00e0m\u00f9b\u00f3d\u00ed\u00e0" },
            { "KI", "Or\u00edl\u1eb9\u0301\u00e8de Kiribati" },
            { "ki", "K\u00edk\u00fay\u00f9" },
            { "mas", "M\u00e1s\u00e1\u00ec" },
            { "kk", "Ka\u1e63ak\u00ec" },
            { "kl", "Kalaal\u00eds\u00f9t\u00ec" },
            { "KM", "Or\u00edl\u1eb9\u0301\u00e8de K\u00f2m\u00f2r\u00f3s\u00ec" },
            { "km", "\u00c8d\u00e8 kameri" },
            { "KN", "Or\u00edl\u1eb9\u0301\u00e8de Kiiti ati Neefi" },
            { "kn", "\u00c8d\u00e8 Kannada" },
            { "Knda", "Kanada" },
            { "fr_CA", "\u00c8d\u00e8 Farans\u00e9 (or\u00edl\u1eb9\u0300-\u00e8d\u00e8 K\u00e1n\u00e1d\u00e0)" },
            { "ko", "\u00c8d\u00e8 K\u00f2r\u00ed\u00e0" },
            { "KP", "Or\u00edl\u1eb9\u0301\u00e8de Guusu K\u1ecdria" },
            { "KR", "Or\u00edl\u1eb9\u0301\u00e8de Ariwa K\u1ecdria" },
            { "ks", "Ka\u1e63\u00edmir\u00ec" },
            { "ku", "K\u1ecddi\u1e63\u00ec" },
            { "fr_CH", "\u00c8d\u00e8 Faran\u1e63\u00e9 (S\u00faw\u00eds\u00e0la\u01f9d\u00ec)" },
            { "KW", "Or\u00edl\u1eb9\u0301\u00e8de Kuweti" },
            { "kw", "K\u1ecd\u0301n\u00ec\u00ec\u1e63\u00ec" },
            { "KY", "Or\u00edl\u1eb9\u0301\u00e8de Et\u00edokun K\u00e1m\u00e1n\u00ec" },
            { "ky", "K\u00edr\u00edg\u00ed\u00ecs\u00ec" },
            { "KZ", "Or\u00edl\u1eb9\u0301\u00e8de Ka\u1e63a\u1e63atani" },
            { "Cyrl", "\u00e8d\u00e8 il\u1eb9\u0300 R\u1ecd\u0301\u1e63\u00ed\u00e0" },
            { "LA", "Or\u00edl\u1eb9\u0301\u00e8de Laosi" },
            { "la", "\u00c8d\u00e8 Latini" },
            { "LB", "Or\u00edl\u1eb9\u0301\u00e8de Lebanoni" },
            { "lb", "L\u00f9\u1e63\u1eb9\u0301mb\u1ecd\u0301\u1ecd\u0300g\u00ec" },
            { "LC", "Or\u00edl\u1eb9\u0301\u00e8de Lu\u1e63ia" },
            { "type.nu.mlym", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec M\u00e1l\u00e0y\u00e1l\u00e1m\u00f9" },
            { "lg", "Ganda" },
            { "nds", "J\u00e1m\u00e1n\u00ec \u00ecp\u00ecl\u1eb9\u0300" },
            { "LI", "Or\u00edl\u1eb9\u0301\u00e8de L\u1eb9\u1e63it\u1eb9nisiteni" },
            { "LK", "Or\u00edl\u1eb9\u0301\u00e8de Siri Lanka" },
            { "Tibt", "T\u00edb\u00e9t\u00e1n" },
            { "ln", "L\u00ec\u01f9g\u00e1l\u00e0" },
            { "fur", "Firi\u00fal\u00ed\u00e0n\u00ec" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u00c8to \u00ccdiw\u1ecd\u0300n \u1eccba" },
            { "LR", "Or\u00edl\u1eb9\u0301\u00e8de Laberia" },
            { "LS", "Or\u00edl\u1eb9\u0301\u00e8de Lesoto" },
            { "LT", "Or\u00edl\u1eb9\u0301\u00e8de Lituania" },
            { "lt", "\u00c8d\u00e8 Lithuania" },
            { "LU", "Or\u00edl\u1eb9\u0301\u00e8de Lusemogi" },
            { "lu", "L\u00fab\u00e0-Katanga" },
            { "LV", "Or\u00edl\u1eb9\u0301\u00e8de Latifia" },
            { "lv", "\u00c8d\u00e8 Latvianu" },
            { "Kana", "Katak\u00e1n\u00e0" },
            { "LY", "Or\u00edl\u1eb9\u0301\u00e8de Libiya" },
            { "vun", "Funjo" },
            { "lag", "L\u00e1\u0144g\u00ec" },
            { "Thaa", "Taana" },
            { "MA", "Or\u00edl\u1eb9\u0301\u00e8de Moroko" },
            { "MC", "Or\u00edl\u1eb9\u0301\u00e8de Monako" },
            { "MD", "Or\u00edl\u1eb9\u0301\u00e8de Modofia" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Or\u00edl\u1eb9\u0301\u00e8de Madasika" },
            { "mg", "Malagas\u00ec" },
            { "MH", "Or\u00edl\u1eb9\u0301\u00e8de Etikun M\u00e1\u1e63ali" },
            { "type.co.ducet", "\u00c8t\u00f2 \u1eb8l\u1eb9\u0301s\u1eb9\u1eb9s\u1eb9 \u00c0k\u00f9\u00e0y\u00e0n Unicode" },
            { "mi", "M\u00e0\u00f3r\u00ec" },
            { "MK", "\u00c0r\u00edw\u00e1 Macedonia" },
            { "mk", "\u00c8d\u00e8 Macedonia" },
            { "ml", metaValue_ml },
            { "ML", "Or\u00edl\u1eb9\u0301\u00e8de Mali" },
            { "MM", "Or\u00edl\u1eb9\u0301\u00e8de Manamari" },
            { "mn", metaValue_mn },
            { "MN", "Or\u00edl\u1eb9\u0301\u00e8de Mogolia" },
            { "MO", "Macao SAR ti \u1e62\u00e1\u00ecn\u00e0" },
            { "MP", "Or\u00edl\u1eb9\u0301\u00e8de Etikun Guusu Mariana" },
            { "MQ", "Or\u00edl\u1eb9\u0301\u00e8de Matinikuwi" },
            { "MR", "Or\u00edl\u1eb9\u0301\u00e8de Maritania" },
            { "mr", "\u00c8d\u00e8 marathi" },
            { "MS", "Or\u00edl\u1eb9\u0301\u00e8de Motserati" },
            { "ms", "\u00c8d\u00e8 Malaya" },
            { "MT", "Or\u00edl\u1eb9\u0301\u00e8de Malata" },
            { "mt", "\u00c8d\u00e8 Malta" },
            { "MU", "Or\u00edl\u1eb9\u0301\u00e8de Maritiusi" },
            { "MV", "Or\u00edl\u1eb9\u0301\u00e8de Maladifi" },
            { "MW", "Or\u00edl\u1eb9\u0301\u00e8de Malawi" },
            { "MX", "Or\u00edl\u1eb9\u0301\u00e8de Mesiko" },
            { "type.ca.japanese", "K\u00e0l\u1eb9\u0300\u0144d\u00e0 ti J\u00e0p\u00e1n\u00f9" },
            { "MY", "Or\u00edl\u1eb9\u0301\u00e8de Malasia" },
            { "my", "\u00c8d\u00e8 Bumiisi" },
            { "MZ", "Or\u00edl\u1eb9\u0301\u00e8de Mo\u1e63amibiku" },
            { "Armn", "\u00c0m\u1eb9\u0301n\u00ed\u00e0" },
            { "dsb", "\u1e62ob\u00ed\u00e0n\u00f9 \u00ccp\u00ecl\u1eb9\u0300" },
            { "NA", "Or\u00edl\u1eb9\u0301\u00e8de Namibia" },
            { "type.co.search", "\u00cc\u1e63\u00e0w\u00e1r\u00ed \u00c8te-Gbogbogb\u00f2" },
            { "202", "S\u00e0h\u00e1r\u00e0 \u00c1f\u00edr\u00edk\u00e0" },
            { "nb", "N\u1ecd\u0301\u1ecd\u0301w\u00e8 Bok\u00edm\u00e0l" },
            { "type.ca.hebrew", "K\u00e0l\u1eb9\u0300\u0144d\u00e0 H\u00e9b\u00e9r\u00f9" },
            { "NC", "Or\u00edl\u1eb9\u0301\u00e8de Kaledonia Titun" },
            { "nd", "\u00c0r\u00edw\u00e1 Ndebele" },
            { "NE", "Or\u00edl\u1eb9\u0301\u00e8de N\u00e0\u00ecj\u00e1" },
            { "ne", "\u00c8d\u00e8 Nepali" },
            { "NF", "Or\u00edl\u1eb9\u0301\u00e8de Etikun N\u1ecd\u0301\u00faf\u00f3k\u00ec" },
            { "NG", "Oril\u1eb9\u0300-\u00e8d\u00e8 N\u00e0\u00ecj\u00edr\u00ed\u00e0" },
            { "NI", "Or\u00edl\u1eb9\u0301\u00e8de NIkaragua" },
            { "NL", "Or\u00edl\u1eb9\u0301\u00e8de Nedalandi" },
            { "nl", "\u00c8d\u00e8 D\u1ecd\u0301\u1ecd\u0300\u1e63\u00ec" },
            { "nn", "N\u1ecd\u0301\u1ecd\u0301w\u00e8 N\u00edn\u1ecd\u0300s\u00eck\u00ec" },
            { "NO", "Or\u00edl\u1eb9\u0301\u00e8de N\u1ecd\u1ecdwii" },
            { "no", "\u00c8d\u00e8 Norway" },
            { "NP", "Or\u00edl\u1eb9\u0301\u00e8de Nepa" },
            { "NR", "Or\u00edl\u1eb9\u0301\u00e8de Nauru" },
            { "NU", "Or\u00edl\u1eb9\u0301\u00e8de Niue" },
            { "rof", "R\u00f3\u0144b\u00f2" },
            { "ny", "\u0143y\u00e1j\u00e0" },
            { "NZ", "Or\u00edl\u1eb9\u0301\u00e8de \u1e63ilandi Titun" },
            { "kab", "Kabil\u00e8" },
            { "oc", "\u00c8d\u00e8 Occitani" },
            { "kam", "K\u00e1\u0144b\u00e0" },
            { "mer", "M\u00e9r\u00f9" },
            { "type.nu.armn", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00c0m\u1eb9\u0301n\u00ed\u00e0" },
            { "OM", "Or\u00edl\u1eb9\u0301\u00e8de \u1ecc\u1ecdma" },
            { "om", "\u00d2r\u00f2m\u1ecd\u0301" },
            { "or", metaValue_or },
            { "os", "\u1ecc\u1e63\u1eb9\u0301t\u00ed\u00eck\u00ec" },
            { "mfe", "Morisiyen" },
            { "PA", "Or\u00edl\u1eb9\u0301\u00e8de Panama" },
            { "pa", "\u00c8d\u00e8 Punjabi" },
            { "dua", "Duala" },
            { "en_GB", "\u00c8d\u00e8 \u00f2y\u00ecnb\u00f3 G\u1eb9\u0300\u1eb9\u0301s\u00ec" },
            { "PE", "Or\u00edl\u1eb9\u0301\u00e8de Peru" },
            { "PF", "Or\u00edl\u1eb9\u0301\u00e8de Firen\u1e63i Polinesia" },
            { "PG", "Or\u00edl\u1eb9\u0301\u00e8de Paapu ti Giini" },
            { "PH", "Or\u00edl\u1eb9\u0301\u00e8de filipini" },
            { "PK", "Or\u00edl\u1eb9\u0301\u00e8de Pakisitan" },
            { "PL", "Or\u00edl\u1eb9\u0301\u00e8de Polandi" },
            { "pl", "\u00c8d\u00e8 P\u00f3l\u00e1\u01f9d\u00ec" },
            { "ewo", "\u00c8w\u00f3\u01f9d\u00f2" },
            { "PM", "Or\u00edl\u1eb9\u0301\u00e8de P\u1eb9\u1eb9ri ati mikuloni" },
            { "PN", "Or\u00edl\u1eb9\u0301\u00e8de Pikarini" },
            { "type.ca.dangi", "K\u00e0l\u1eb9\u0300\u0144d\u00e0 dangi" },
            { "PR", "Or\u00edl\u1eb9\u0301\u00e8de P\u1ecdto Riko" },
            { "PS", "Agb\u00e8gb\u00e8 Pal\u1eb9s\u00edt\u00ed\u00e0n\u00f9" },
            { "ps", "P\u00e1sh\u00edt\u00f2" },
            { "PT", "Or\u00edl\u1eb9\u0301\u00e8de P\u1ecd\u0301t\u00fag\u00e0" },
            { "pt", "\u00c8d\u00e8 P\u1ecdtog\u00ed" },
            { "key.co", "\u00c8t\u00f2 \u1eb8l\u1eb9\u0301s\u1eb9\u1eb9s\u1eb9" },
            { "PW", "Or\u00edl\u1eb9\u0301\u00e8de Paalu" },
            { "type.nu.greklow", "\u00c0w\u1ecdn N\u1ecd\u0301\u0144b\u00e0 G\u00edr\u00ed\u00eck\u00ec K\u00e9k\u00e8k\u00e9" },
            { "PY", "Or\u00edl\u1eb9\u0301\u00e8de Paraguye" },
            { "pt_BR", "\u00c8d\u00e8 P\u1ecdtog\u00ed (Oril\u1eb9\u0300-\u00e8d\u00e8 Br\u00e0s\u00edl)" },
            { "mgh", "Makhuwa-Meeto" },
            { "Hebr", "H\u00e9b\u00e9r\u00f9" },
            { "key.cf", "\u00ccg\u00fanr\u00e9g\u00e9 K\u1ecd\u0301r\u1eb9\u0301\u0144s\u00ec" },
            { "QA", "Or\u00edl\u1eb9\u0301\u00e8de Kota" },
            { "key.ca", "K\u00e0l\u1eb9\u0301\u0144d\u00e0" },
            { "Laoo", metaValue_lo },
            { "mgo", "M\u00e9t\u00e0" },
            { "type.hc.h23", "\u00c8to W\u00e1k\u00e0t\u00ed 24 (0\u201323)" },
            { "type.hc.h24", "\u00c8to W\u00e1k\u00e0t\u00ed 24 (1\u201324)" },
            { "type.nu.mymr", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec My\u00e1nmar\u00ed" },
            { "QO", "Agb\u00e8gb\u00e8 Oceania" },
            { "qu", "K\u00fa\u1eb9\u0301\u0144j\u00f9\u00e0" },
            { "brx", "B\u00f3d\u00f2" },
            { "kde", "M\u00e1kond\u00e9" },
            { "001", "Agb\u00e1y\u00e9" },
            { "Ethi", "\u1eb8ti\u00f3p\u00ed\u00eck\u00ec" },
            { "002", "\u00c1f\u00edr\u00edk\u00e0" },
            { "003", "\u00c0r\u00edw\u00e1 Am\u1eb9\u0301r\u00edk\u00e0" },
            { "RE", "Or\u00edl\u1eb9\u0301\u00e8de Riuniyan" },
            { "type.hc.h12", "\u00c8to W\u00e1k\u00e0t\u00ed 12 (1\u201312)" },
            { "005", "G\u00fa\u00fa\u1e63\u00f9 Am\u1eb9\u0301r\u00edk\u00e0" },
            { "type.hc.h11", "\u00c8to W\u00e1k\u00e0t\u00ed 12 (0\u201311)" },
            { "009", "Oceania" },
            { "rm", "R\u00f3m\u00e1\u01f9\u1e63\u00ec" },
            { "rn", "R\u00fa\u0144d\u00ec" },
            { "key.cu", "K\u1ecd\u0301r\u1eb9\u0301\u0144s\u00ec" },
            { "RO", "Or\u00edl\u1eb9\u0301\u00e8de Romaniya" },
            { "ro", "\u00c8d\u00e8 Romania" },
            { "RS", "Serbia" },
            { "type.nu.orya", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec \u00d2d\u00ed\u00e0" },
            { "type.nu.hanidec", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 D\u1eb9\u0301s\u00edm\u00e0 \u1e62\u00e1\u00ecn\u00e0" },
            { "RU", "Or\u00edl\u1eb9\u0301\u00e8de R\u1ecd\u1e63ia" },
            { "ru", "\u00c8d\u00e8 R\u1ecd\u0301\u1e63\u00ed\u00e0" },
            { "RW", "Or\u00edl\u1eb9\u0301\u00e8de Ruwanda" },
            { "rw", "\u00c8d\u00e8 Ruwanda" },
            { "kea", "Kabufad\u00ed\u00e1n\u00f9" },
            { "en_AU", "\u00c8d\u00e8 G\u1eb9\u0300\u1eb9\u0301s\u00ec (\u00f3r\u00edl\u1eb9\u0300-\u00e8d\u00e8 \u1eccsir\u00e9l\u00ed\u00e0)" },
            { "SA", "Or\u00edl\u1eb9\u0301\u00e8de Saudi Arabia" },
            { "sa", "\u00c8d\u00e8 awon ara Indo" },
            { "SB", "Or\u00edl\u1eb9\u0301\u00e8de Etikun Solomoni" },
            { "twq", "Tasawak" },
            { "011", "\u00ccw\u1ecd\u0300 oor\u00f9n Af\u00edr\u00edk\u00e0" },
            { "SC", "Or\u00edl\u1eb9\u0301\u00e8de se\u1e63\u1eb9l\u1eb9si" },
            { "SD", "Or\u00edl\u1eb9\u0301\u00e8de Sudani" },
            { "sd", "\u00c8d\u00e8 Sindhi" },
            { "013", "\u00c0\u00e0rin Gb\u00f9gb\u00f9n \u00c0m\u1eb9\u0301r\u00edk\u00e0" },
            { "SE", "Or\u00edl\u1eb9\u0301\u00e8de Swidini" },
            { "se", "Ap\u00e1\u00e0r\u00edw\u00e1 Sami" },
            { "014", "\u00ccl\u00e0 Oor\u00f9n \u00c1f\u00edr\u00edk\u00e0" },
            { "015", "Northern Africa" },
            { "SG", "Or\u00edl\u1eb9\u0301\u00e8de Singapo" },
            { "sg", "Sango" },
            { "SH", "Or\u00edl\u1eb9\u0301\u00e8de H\u1eb9lena" },
            { "sh", "\u00c8d\u00e8 Serbo-Croatiani" },
            { "type.lb.strict", "\u00c0ra \u00ccda \u00ccl\u00e0 M\u00edm\u00fan\u00e1" },
            { "017", "\u00c0\u00e0r\u00edn gb\u00f9ngb\u00f9n Af\u00edr\u00edk\u00e0" },
            { "SI", "Or\u00edl\u1eb9\u0301\u00e8de Silofania" },
            { "si", "\u00c8d\u00e8 Sinhalese" },
            { "018", "Ap\u00e1g\u00fa\u00fas\u00f9 \u00c1f\u00edr\u00edk\u00e0" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "019", "Am\u1eb9\u0301r\u00edk\u00e0" },
            { "SK", "Or\u00edl\u1eb9\u0301\u00e8de Silofakia" },
            { "sk", "\u00c8d\u00e8 Slovaki" },
            { "SL", "Or\u00edl\u1eb9\u0301\u00e8de Siria looni" },
            { "sl", "\u00c8d\u00e8 Slovenia" },
            { "SM", "Or\u00edl\u1eb9\u0301\u00e8de Sani Marino" },
            { "sm", "S\u00e1m\u00f3\u00e1n\u00f9" },
            { "SN", "Or\u00edl\u1eb9\u0301\u00e8de S\u1eb9n\u1eb9ga" },
            { "sn", "\u1e62\u1ecdn\u00e0" },
            { "SO", "Or\u00edl\u1eb9\u0301\u00e8de Somalia" },
            { "so", "\u00c8d\u00e8 ara Somalia" },
            { "type.nu.arab", "\u00e0w\u1ecdn d\u00edj\u00edt\u00ec L\u00e0rub\u00e1w\u00e1-\u00cdnd\u00ed\u00e0" },
            { "sq", "\u00c8d\u00e8 Albania" },
            { "type.nu.taml", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec \u00ccb\u00edl\u1eb9\u0300 T\u00e1m\u00edl\u00f9" },
            { "SR", "Or\u00edl\u1eb9\u0301\u00e8de Surinami" },
            { "sr", "\u00c8d\u00e8 Serbia" },
            { "SS", "G\u00fa\u00fas\u00f9 Sudan" },
            { "type.cf.account", "\u00ccg\u00fanr\u00e9g\u00e9 \u00cc\u1e63ir\u00f2 Ow\u00f3 K\u1ecd\u0301r\u1eb9\u0301\u0144s\u00ec" },
            { "ST", "Or\u00edl\u1eb9\u0301\u00e8de Sao tomi ati pirii\u1e63ipi" },
            { "st", "\u00c8d\u00e8 Sesoto" },
            { "su", "\u00c8d\u00e8 Sudani" },
            { "SV", "Or\u00edl\u1eb9\u0301\u00e8de \u1eb8\u1eb9s\u00e1f\u00e1d\u00f2" },
            { "sv", "\u00c8d\u00e8 Suwidiisi" },
            { "sw", "\u00c8d\u00e8 Swahili" },
            { "SX", "Sint Maarten" },
            { "SY", "Or\u00edl\u1eb9\u0301\u00e8de Siria" },
            { "type.nu.hantfin", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00cc\u1e63\u00fan\u00e1 \u00ccb\u00edl\u1eb9\u0300 \u1e62\u00e1\u00ecn\u00e0" },
            { "SZ", "Or\u00edl\u1eb9\u0301\u00e8de Sa\u1e63iland" },
            { "TA", "Tristan da Kunha" },
            { "ta", "\u00c8d\u00e8 Tamili" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "\u00c8to \u00ccdiw\u1ecd\u0300n US" },
            { "021", "Ap\u00e1\u00e0r\u00edw\u00e1 Am\u1eb9\u0301r\u00edk\u00e0" },
            { "142", "Asia" },
            { "TC", "Or\u00edl\u1eb9\u0301\u00e8de T\u1ecd\u1ecdki ati Etikun Kak\u1ecdsi" },
            { "yav", "Yangb\u1eb9n" },
            { "143", "\u00c0\u00e0rin Gb\u00f9ngb\u00f9n \u00c9\u1e63\u00ed\u00e0" },
            { "TD", "Or\u00edl\u1eb9\u0301\u00e8de \u1e63\u00e0\u00e0d\u00ec" },
            { "te", "\u00c8d\u00e8 Telugu" },
            { "145", "\u00ccw\u1ecd\u0300 \u00d2\u00f2r\u00f9n E\u1e63\u00ed\u00e0" },
            { "TF", "Agb\u00e8gb\u00e8 G\u00fa\u00fas\u00f9 Faran\u1e63\u00e9" },
            { "TG", "Or\u00edl\u1eb9\u0301\u00e8de Togo" },
            { "tg", "T\u00e0j\u00ed\u00eck\u00ec" },
            { "TH", "Or\u00edl\u1eb9\u0301\u00e8de Tailandi" },
            { "th", "\u00c8d\u00e8 Tai" },
            { "ti", "\u00c8d\u00e8 Tigrinya" },
            { "TJ", "Or\u00edl\u1eb9\u0301\u00e8de Takisitani" },
            { "en_CA", "\u00c8d\u00e8 G\u1eb9\u0300\u1eb9\u0301s\u00ec (Or\u00edl\u1eb9\u0300-\u00e8d\u00e8 K\u00e1n\u00e1d\u00e0)" },
            { "029", "K\u00e1r\u00edb\u00ed\u00e0n\u00f9" },
            { "TK", "Or\u00edl\u1eb9\u0301\u00e8de Tokelau" },
            { "tk", "\u00c8d\u00e8 Turkmen" },
            { "TL", "Or\u00edl\u1eb9\u0301\u00e8de \u00ccl\u00e0O\u00f2r\u00f9n T\u00edm\u1ecd\u0300" },
            { "TM", "Or\u00edl\u1eb9\u0301\u00e8de T\u1ecd\u1ecdkimenisita" },
            { "TN", "Or\u00edl\u1eb9\u0301\u00e8de Tuni\u1e63ia" },
            { "TO", "Or\u00edl\u1eb9\u0301\u00e8de Tonga" },
            { "to", "T\u00f3\u0144g\u00e0n" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 J\u00e1p\u00e0n\u00f9" },
            { "TR", "Or\u00edl\u1eb9\u0301\u00e8de T\u1ecd\u1ecdki" },
            { "tr", "\u00c8d\u00e8 T\u1ecd\u1ecdkisi" },
            { "TT", "Or\u00edl\u1eb9\u0301\u00e8de Tirinida ati Tobaga" },
            { "tt", "Tatar\u00ed" },
            { "TV", "Or\u00edl\u1eb9\u0301\u00e8de Tufalu" },
            { "TW", "Or\u00edl\u1eb9\u0301\u00e8de Taiwani" },
            { "ast", "Asturian" },
            { "TZ", "Or\u00edl\u1eb9\u0301\u00e8de T\u00e0\u01f9s\u00e1n\u00ed\u00e0" },
            { "nmg", "K\u00edw\u00e1\u1e63\u00ed\u00f2" },
            { "Zzzz", "\u00cc\u1e63\u1ecdw\u1ecd\u0301k\u1ecd\u0300w\u00e9 \u00e0\u00ecm\u1ecd\u0300" },
            { "150", "Europe" },
            { "UA", "Or\u00edl\u1eb9\u0301\u00e8de Ukarini" },
            { "030", "\u00ccl\u00e0 \u00d2\u00f2r\u00f9n E\u1e63\u00ed\u00e0" },
            { "151", "\u00ccl\u00e0 \u00d2r\u00f9n Y\u00far\u00f3p\u00f9" },
            { "154", "Northern Europe" },
            { "034", "G\u00fa\u00fa\u1e63\u00f9 E\u1e63\u00ed\u00e0" },
            { "155", "\u00ccw\u1ecd\u0300 \u00d2\u00f2r\u00f9n Y\u00far\u00f3p\u00f9" },
            { "035", "G\u00fa\u00fa\u1e63\u00f9 \u00ecl\u00e0 \u00f2\u00f2r\u00f9n \u00c9\u1e63\u00ed\u00e0" },
            { "UG", "Or\u00edl\u1eb9\u0301\u00e8de Uganda" },
            { "ug", "Y\u00fag\u1ecd\u0300" },
            { "Kore", "K\u00f3r\u00ed\u00e0" },
            { "Zyyy", "W\u1ecd\u0301p\u1ecd\u0300" },
            { "039", "G\u00fa\u00fa\u1e63\u00f9 Y\u00far\u00f3\u00f2p\u00f9" },
            { "uk", "\u00c8d\u00e8 Ukania" },
            { "Sinh", "S\u00ecnh\u00e1l\u00e0" },
            { "UM", "\u00c0w\u1ecdn Er\u00e9k\u00f9s\u00f9 K\u00e9k\u00e8k\u00e9 Agb\u00e8gb\u00e8 US" },
            { "UN", "\u00cc\u1e63\u1ecd\u0300kan \u00e0gb\u00e1y\u00e9" },
            { "ur", "\u00c8d\u00e8 Udu" },
            { "US", "Or\u00edl\u1eb9\u0300-\u00e8d\u00e8 Am\u1eb9rik\u00e0" },
            { "haw", "Hawaiian" },
            { "UY", "Or\u00edl\u1eb9\u0301\u00e8de Nruguayi" },
            { "prg", "P\u00far\u00fa\u1e63\u00ed\u00e0n\u00f9" },
            { "UZ", "Or\u00edl\u1eb9\u0301\u00e8de N\u1e63ib\u1eb9kisitani" },
            { "uz", "\u00c8d\u00e8 Uzbek" },
            { "tzm", "\u00c0\u00e0rin Gb\u00f9ngb\u00f9n Atlas Tamazight" },
            { "nnh", "Ngiemb\u00f9n\u00f9" },
            { "VA", "\u00ccl\u00fa Vatican" },
            { "VC", "Or\u00edl\u1eb9\u0301\u00e8de Fis\u1eb9nnti ati Genadina" },
            { "VE", "Or\u00edl\u1eb9\u0301\u00e8de F\u1eb9n\u1eb9\u1e63u\u1eb9la" },
            { "type.ca.roc", "K\u00e0l\u1eb9\u0300\u0144d\u00e0 Minguo" },
            { "VG", "Or\u00edl\u1eb9\u0301\u00e8de Et\u00edkun F\u00e1g\u00edn\u00ec ti \u00ecl\u00fa B\u00edr\u00edt\u00eds\u00ec" },
            { "VI", "Or\u00edl\u1eb9\u0301\u00e8de Etikun Fagini ti Am\u1eb9rika" },
            { "vi", "\u00c8d\u00e8 Jetinamu" },
            { "khq", "Koira \u1e62\u00ed\u00edn\u00ec" },
            { "key.hc", "\u00d2b\u00edr\u00edkiti W\u00e1k\u00e0t\u00ed (12 vs 24)" },
            { "VN", "Or\u00edl\u1eb9\u0301\u00e8de F\u1eb9tinami" },
            { "vo", "F\u1ecd\u0301l\u00e1p\u00f9\u00f9k\u00f9" },
            { "VU", "Or\u00edl\u1eb9\u0301\u00e8de Faniatu" },
            { "rwk", "Riwa" },
            { "053", "\u1ecc\u1e63ir\u00e9la\u1e63\u00ed\u00e0" },
            { "054", "M\u1eb9lan\u00e9\u1e63\u00ed\u00e0" },
            { "WF", "Or\u00edl\u1eb9\u0301\u00e8de Wali ati futuna" },
            { "Grek", "J\u1ecd\u0301j\u00ed\u00e0" },
            { "057", "Agb\u00e8gb\u00e8 Maikiron\u00e9\u1e63\u00ed\u00e0" },
            { "jgo", "\u0143g\u00f2mb\u00e0" },
            { "lkt", "L\u00e1kota" },
            { "wo", "W\u1ecd\u0301l\u1ecd\u0301\u1ecd\u0300f\u00f9" },
            { "wae", "W\u1ecds\u00e0" },
            { "zgh", "\u00c0f\u1eb9n\u00f9k\u00f2 T\u00e1m\u00e1s\u00e1\u00ect\u00ec ti M\u00f2r\u00f3k\u00f2" },
            { "WS", "Or\u00edl\u1eb9\u0301\u00e8de Sam\u1ecd" },
            { "Mong", metaValue_mn },
            { "XA", "Pseudo-Accents" },
            { "XB", "Pseudo-Bidi" },
            { "061", "Poline\u1e63\u00ed\u00e0" },
            { "Latn", "\u00c8d\u00e8 L\u00e1t\u00ecn" },
            { "type.nu.hans", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00ccr\u1ecd\u0300r\u00f9n ti \u1e62\u00e1\u00ecn\u00e0" },
            { "type.nu.hant", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00ccb\u00edl\u1eb9\u0300 \u1e62\u00e1\u00ecn\u00e0" },
            { "xh", "\u00c8d\u00e8 Xhosa" },
            { "XK", "K\u00f2s\u00f3f\u00f2" },
            { "type.nu.romanlow", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec R\u00f3m\u00e1n\u00f9 K\u00e9ker\u00e9" },
            { "Gujr", "Gujar\u00e1ti" },
            { "Zxxx", "Aik\u1ecdsil\u1eb9" },
            { "kkj", "K\u00e0k\u00f3" },
            { "YE", "Or\u00edl\u1eb9\u0301\u00e8de yemeni" },
            { "type.co.standard", "\u00ccl\u00e0n\u00e0 On\u00edr\u00faur\u00fa \u00c8t\u00f2" },
            { "yi", "\u00c8d\u00e8 Yiddishi" },
            { "yo", "\u00c8d\u00e8 Yor\u00f9b\u00e1" },
            { "es_MX", "\u00c8d\u00e8 S\u00edp\u00e1n\u00ed\u00ec\u1e63\u00ec (or\u00edl\u1eb9\u0300-\u00e8d\u00e8 M\u1eb9\u0301s\u00edk\u00f2)" },
            { "YT", "Or\u00edl\u1eb9\u0301\u00e8de Mayote" },
            { "ZA", "G\u00fa\u00fa\u1e63\u00f9 \u00c1f\u00edr\u00edk\u00e0" },
            { "type.lb.loose", "\u00c0ra \u00ccda \u00ccl\u00e0 T\u00edt\u00fa" },
            { "kln", "K\u00e1l\u1eb9nj\u00edn" },
            { "Deva", "D\u1eb9fanag\u00e1r\u00ec" },
            { "zh", "\u00c8d\u00e8 Mandarin t\u00ed w\u1ecd\u0301n \u0144 s\u1ecd l\u00f3r\u00edl\u1eb9\u0300-\u00e8d\u00e8 \u1e62\u00e1\u00edn\u00e0" },
            { "type.nu.geor", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 J\u1ecd\u0301j\u00ed\u00e0" },
            { "Hira", "Hirag\u00e1n\u00e0" },
            { "ZM", "Or\u00edl\u1eb9\u0301\u00e8de \u1e63amibia" },
            { "Bopo", "Bopom\u00f3f\u00f2" },
            { "key.lb", "\u00c0ra \u00ccda \u00ccl\u00e0" },
            { "zu", "\u00c8d\u00e8 \u1e62ulu" },
            { "ZW", "Or\u00edl\u1eb9\u0301\u00e8de \u1e63imibabe" },
            { "ZZ", "\u00c0gb\u00e8gb\u00e8 \u00e0\u00ecm\u1ecd\u0300" },
            { "Geor", "J\u1ecd\u0301j\u00ed\u00e0n\u00f9" },
            { "type.ms.metric", "\u00c8to M\u1eb9\u0301t\u00edr\u00ed\u00eck\u00ec" },
            { "type.ca.iso8601", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 ISO-8601" },
            { "type.nu.telu", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec T\u00e9l\u00fag\u00f9" },
            { "type.nu.jpanfin", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00cc\u1e63\u00fan\u00e1 J\u00e0p\u00e1\u00e0n\u00f9" },
            { "ebu", "\u1eb8mb\u00f9" },
            { "jmc", "M\u00e1\u1e63\u00e1m\u00e8" },
            { "type.nu.hansfin", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00cc\u1e63\u00fan\u00e1 \u00ccr\u1ecd\u0300r\u00f9n \u1e62\u00e1\u00ecn\u00e0" },
            { "kok", "K\u00f3nk\u00e1n\u00ec" },
            { "type.nu.arabext", "\u00c0w\u1ecdn D\u00edj\u00ed\u00ect\u00ec L\u00e1r\u00fab\u00e1w\u00e1-\u00cdnd\u00ed\u00e0 f\u00edf\u1eb9\u0300" },
            { "nus", "N\u00fa\u1eb9\u0300" },
            { "type.nu.fullwide", "\u00c0w\u1ecdn D\u00edj\u00ed\u00ect\u00ec F\u00edf\u1eb9\u0300-\u1eb8\u0300k\u00fan" },
            { "dav", "T\u00e1\u00edt\u00e0" },
            { "lrc", "Ap\u00e1\u00e0r\u00edw\u00e1 L\u00far\u00ec" },
            { "zh_Hant", "\u00c8d\u00e8 \u00ccb\u00edl\u1eb9\u0300 \u1e62\u00e1\u00edn\u00e0" },
            { "type.nu.khmr", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec K\u1eb9\u0301m\u1eb9\u0300" },
            { "mua", "M\u00fand\u00e0ng\u00ec" },
            { "type.nu.guru", "\u00c0w\u1ecdn D\u00edj\u00ed\u00ect\u00ec Gurumuk\u00ec" },
            { "Khmr", "K\u1eb9m\u1eb9\u0300" },
            { "mul", "\u1eccl\u1ecd\u0301p\u1ecd\u0300 \u00e8d\u00e8" },
            { "key.ms", "\u00c8to \u00ccdiw\u1ecd\u0300n" },
            { "type.nu.roman", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec R\u00f3m\u00e1n\u00f9" },
            { "sah", "S\u00e0k\u00edh\u00e0" },
            { "type.nu.tamldec", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec T\u00e0m\u00edl\u00f9" },
            { "saq", "Samburu" },
            { "key.nu", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0" },
            { "Guru", "Gurum\u00fakh\u00ec" },
            { "ksb", "\u1e62\u00e1\u0144b\u00e1l\u00e0" },
            { "Telu", "T\u00e9l\u00fag\u00f9" },
            { "ksf", "B\u00e1f\u00ed\u00e0" },
        };
        return data;
    }
}
