/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_yo extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "O\u1e63\u00f9 \u1e62\u1eb9\u0301r\u1eb9\u0301",
               "O\u1e63\u00f9 \u00c8r\u00e8l\u00e8",
               "O\u1e63\u00f9 \u1eb8r\u1eb9\u0300n\u00e0",
               "O\u1e63\u00f9 \u00ccgb\u00e9",
               "O\u1e63\u00f9 \u1eb8\u0300bibi",
               "O\u1e63\u00f9 \u00d2k\u00fadu",
               "O\u1e63\u00f9 Ag\u1eb9m\u1ecd",
               "O\u1e63\u00f9 \u00d2g\u00fan",
               "O\u1e63\u00f9 Owewe",
               "O\u1e63\u00f9 \u1ecc\u0300w\u00e0r\u00e0",
               "O\u1e63\u00f9 B\u00e9l\u00fa",
               "O\u1e63\u00f9 \u1ecc\u0300p\u1eb9\u0300",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "\u1e62\u1eb9\u0301r",
               "\u00c8r\u00e8l",
               "\u1eb8r\u1eb9\u0300n",
               "\u00ccgb",
               "\u1eb8\u0300bi",
               "\u00d2k\u00fa",
               "Ag\u1eb9",
               "\u00d2g\u00fa",
               "Owe",
               "\u1ecc\u0300w\u00e0",
               "B\u00e9l",
               "\u1ecc\u0300p\u1eb9",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "S",
               "\u00c8",
               "\u1eb8",
               "\u00cc",
               "\u1eb8\u0300",
               "\u00d2",
               "A",
               "\u00d2",
               "O",
               "\u1ecc\u0300",
               "B",
               "\u1ecc\u0300",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u1eccj\u1ecd\u0301 \u00c0\u00eck\u00fa",
               "\u1eccj\u1ecd\u0301 Aj\u00e9",
               "\u1eccj\u1ecd\u0301 \u00ccs\u1eb9\u0301gun",
               "\u1eccj\u1ecd\u0301r\u00fa",
               "\u1eccj\u1ecd\u0301b\u1ecd",
               "\u1eccj\u1ecd\u0301 \u1eb8t\u00ec",
               "\u1eccj\u1ecd\u0301 \u00c0b\u00e1m\u1eb9\u0301ta",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u00c0\u00eck",
               "Aj",
               "\u00ccs\u1eb9\u0301g",
               "\u1eccj\u1ecd\u0301r",
               "\u1eccj\u1ecd\u0301b",
               "\u1eb8t",
               "\u00c0b\u00e1m",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\u00c0",
               "A",
               "\u00cc",
               "\u1ecc",
               "\u1ecc",
               "\u1eb8",
               "\u00c0",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "\u00ccd\u00e1m\u1eb9\u0301rin k\u00edn\u00ed",
               "\u00ccd\u00e1m\u1eb9\u0301rin Kej\u00ec",
               "\u00ccd\u00e1m\u1eb9\u0301rin K\u1eb9ta",
               "\u00ccd\u00e1m\u1eb9\u0301rin K\u1eb9rin",
            };
        final String[] metaValue_QuarterNarrows = new String[] {
               "k\u00edn\u00ed",
               "Kej\u00ec",
               "K\u1eb9ta",
               "K\u1eb9in",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "\u00c0\u00e1r\u1ecd\u0300",
               "\u1ecc\u0300s\u00e1n",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] metaValue_Eras = new String[] {
               "BCE",
               "AD",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "HH:mm:ss zzzz",
               "H:mm:ss z",
               "H:m:s",
               "H:m",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE, d MM y G",
               "d MM y G",
               "d MM y G",
               "dd/MM/y G",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE, d MM y GGGG",
               "d MM y GGGG",
               "d MM y GGGG",
               "dd/MM/y GGGG",
            };
        final String metaValue_calendarname_gregorian = "K\u00e0l\u1eb9\u0301\u0144d\u00e0 Gregory";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u1eccd\u00fan" },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "timezone.gmtFormat", "WAT{0}" },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "narrow.Eras", metaValue_Eras },
            { "abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "timezone.regionFormat.standard", "{0} \u00ccl\u00e0n\u00e0 \u00c0k\u00f3k\u00f2" },
            { "japanese.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.japanese", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 ti J\u00e0p\u00e1n\u00f9" },
            { "timezone.gmtZeroFormat", "WAT" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "long.Eras",
                new String[] {
                    "Saju Kristi",
                    "Lehin Kristi",
                }
            },
            { "roc.QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u00ccs\u1eb9\u0301j\u00fa" },
            { "field.era", "s\u00e1\u00e0" },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "\u00c0\u00e1r\u1ecd\u0300/\u1ecd\u0300s\u00e1n" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "japanese.QuarterNarrows", metaValue_QuarterNarrows },
            { "calendarname.roc", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 Minguo" },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "field.month", "Os\u00f9" },
            { "field.second", "\u00ccs\u1eb9\u0301j\u00fa \u00c0\u00e0y\u00e1" },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 L\u00e1r\u00fab\u00e1w\u00e1" },
            { "japanese.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations",
                new String[] {
                    "\u1e62\u1eb9\u0301",
                    "\u00c8r",
                    "\u1eb8r",
                    "\u00ccg",
                    "\u1eb8\u0300b",
                    "\u00d2k",
                    "Ag",
                    "\u00d2g",
                    "Ow",
                    "\u1ecc\u0300w",
                    "B\u00e9",
                    "\u1ecc\u0300p",
                    "",
                }
            },
            { "timezone.regionFormat", "\u00ccgb\u00e0 {0}" },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{other:0' '\u1eb9gb\u1eb9\u0300r\u00fan}",
                    "{other:00' '\u1eb9gb\u1eb9\u0300r\u00fan}",
                    "{other:000' '\u1eb9gb\u1eb9\u0300r\u00fan}",
                    "{other:0' 'm\u00edl\u00ed\u1ecd\u0300n\u00f9}",
                    "{other:00' 'm\u00edl\u00ed\u1ecd\u0300n\u00f9}",
                    "{other:000' 'm\u00edl\u00ed\u1ecd\u0300n\u00f9}",
                    "{other:0' 'bil\u00ed\u1ecd\u0300n\u00f9}",
                    "{other:00' 'bil\u00ed\u1ecd\u0300n\u00f9}",
                    "{other:000' 'bil\u00ed\u1ecd\u0300n\u00f9}",
                    "{other:0' 'tirili\u1ecd\u0300n\u00f9}",
                    "{other:00' 'tirili\u1ecd\u0300n\u00f9}",
                    "{other:000' 'tirili\u1ecd\u0300n\u00f9}",
                }
            },
            { "buddhist.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "field.zone", "Agb\u00e8gb\u00e8 \u00e0k\u00f3k\u00f2" },
            { "buddhist.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "Eras", metaValue_Eras },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "QuarterNarrows", metaValue_QuarterNarrows },
            { "islamic.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "standalone.QuarterNarrows",
                new String[] {
                    "k\u00ed",
                    "Ke",
                    "K\u1eb9t",
                    "K\u1eb9r",
                }
            },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "field.weekday", "\u1eccj\u1ecd\u0301 t\u00f3 w\u00e0 l\u00e1\u00e0\u00e1r\u00edn \u1ecd\u0300s\u1eb9\u0300" },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "field.week", "\u1ecc\u0300s\u1eb9\u0300" },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "timezone.regionFormat.daylight", "{0} \u00c0k\u00f3k\u00f2 oj\u00fam\u1ecdm\u1ecd" },
            { "DatePatterns",
                new String[] {
                    "EEEE, d MMM y",
                    "d MMM y",
                    "d MM y",
                    "d/M/y",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames",
                new String[] {
                    "\u00c0\u00eck\u00fa",
                    "Aj\u00e9",
                    "\u00ccs\u1eb9\u0301gun",
                    "\u1eccj\u1ecd\u0301r\u00fa",
                    "\u1eccj\u1ecd\u0301b\u1ecd",
                    "\u1eb8t\u00ec",
                    "\u00c0b\u00e1m\u1eb9\u0301ta",
                }
            },
            { "field.hour", "W\u00e1k\u00e0t\u00ed" },
            { "calendarname.buddhist", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 Buddhist" },
            { "standalone.MonthNames",
                new String[] {
                    "\u1e62\u1eb9\u0301r\u1eb9\u0301",
                    "\u00c8r\u00e8l\u00e8",
                    "\u1eb8r\u1eb9\u0300n\u00e0",
                    "\u00ccgb\u00e9",
                    "\u1eb8\u0300bibi",
                    "\u00d2k\u00fadu",
                    "Ag\u1eb9m\u1ecd",
                    "\u00d2g\u00fan",
                    "Owewe",
                    "\u1ecc\u0300w\u00e0r\u00e0",
                    "B\u00e9l\u00fa",
                    "\u1ecc\u0300p\u1eb9\u0300",
                    "",
                }
            },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "\u00a4#,##0.00",
                    "#,##0%",
                    "\u00a4#,##0.00;(\u00a4#,##0.00)",
                }
            },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterNames },
            { "roc.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
