/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_kn extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\u0c9c\u0ca8\u0cb5\u0cb0\u0cbf",
               "\u0cab\u0cc6\u0cac\u0ccd\u0cb0\u0cb5\u0cb0\u0cbf",
               "\u0cae\u0cbe\u0cb0\u0ccd\u0c9a\u0ccd",
               "\u0c8f\u0caa\u0ccd\u0cb0\u0cbf\u0cb2\u0ccd",
               "\u0cae\u0cc7",
               "\u0c9c\u0cc2\u0ca8\u0ccd",
               "\u0c9c\u0cc1\u0cb2\u0cc8",
               "\u0c86\u0c97\u0cb8\u0ccd\u0c9f\u0ccd",
               "\u0cb8\u0cc6\u0caa\u0ccd\u0c9f\u0cc6\u0c82\u0cac\u0cb0\u0ccd",
               "\u0c85\u0c95\u0ccd\u0c9f\u0ccb\u0cac\u0cb0\u0ccd",
               "\u0ca8\u0cb5\u0cc6\u0c82\u0cac\u0cb0\u0ccd",
               "\u0ca1\u0cbf\u0cb8\u0cc6\u0c82\u0cac\u0cb0\u0ccd",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "\u0c9c\u0ca8\u0cb5\u0cb0\u0cbf",
               "\u0cab\u0cc6\u0cac\u0ccd\u0cb0\u0cb5\u0cb0\u0cbf",
               "\u0cae\u0cbe\u0cb0\u0ccd\u0c9a\u0ccd",
               "\u0c8f\u0caa\u0ccd\u0cb0\u0cbf",
               "\u0cae\u0cc7",
               "\u0c9c\u0cc2\u0ca8\u0ccd",
               "\u0c9c\u0cc1\u0cb2\u0cc8",
               "\u0c86\u0c97",
               "\u0cb8\u0cc6\u0caa\u0ccd\u0c9f\u0cc6\u0c82",
               "\u0c85\u0c95\u0ccd\u0c9f\u0ccb",
               "\u0ca8\u0cb5\u0cc6\u0c82",
               "\u0ca1\u0cbf\u0cb8\u0cc6\u0c82",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\u0c9c",
               "\u0cab\u0cc6",
               "\u0cae\u0cbe",
               "\u0c8f",
               "\u0cae\u0cc7",
               "\u0c9c\u0cc2",
               "\u0c9c\u0cc1",
               "\u0c86",
               "\u0cb8\u0cc6",
               "\u0c85",
               "\u0ca8",
               "\u0ca1\u0cbf",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u0cad\u0cbe\u0ca8\u0cc1\u0cb5\u0cbe\u0cb0",
               "\u0cb8\u0ccb\u0cae\u0cb5\u0cbe\u0cb0",
               "\u0cae\u0c82\u0c97\u0cb3\u0cb5\u0cbe\u0cb0",
               "\u0cac\u0cc1\u0ca7\u0cb5\u0cbe\u0cb0",
               "\u0c97\u0cc1\u0cb0\u0cc1\u0cb5\u0cbe\u0cb0",
               "\u0cb6\u0cc1\u0c95\u0ccd\u0cb0\u0cb5\u0cbe\u0cb0",
               "\u0cb6\u0ca8\u0cbf\u0cb5\u0cbe\u0cb0",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u0cad\u0cbe\u0ca8\u0cc1",
               "\u0cb8\u0ccb\u0cae",
               "\u0cae\u0c82\u0c97\u0cb3",
               "\u0cac\u0cc1\u0ca7",
               "\u0c97\u0cc1\u0cb0\u0cc1",
               "\u0cb6\u0cc1\u0c95\u0ccd\u0cb0",
               "\u0cb6\u0ca8\u0cbf",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\u0cad\u0cbe",
               "\u0cb8\u0ccb",
               "\u0cae\u0c82",
               "\u0cac\u0cc1",
               "\u0c97\u0cc1",
               "\u0cb6\u0cc1",
               "\u0cb6",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "1\u0ca8\u0cc7 \u0ca4\u0ccd\u0cb0\u0cc8\u0cae\u0cbe\u0cb8\u0cbf\u0c95",
               "2\u0ca8\u0cc7 \u0ca4\u0ccd\u0cb0\u0cc8\u0cae\u0cbe\u0cb8\u0cbf\u0c95",
               "3\u0ca8\u0cc7 \u0ca4\u0ccd\u0cb0\u0cc8\u0cae\u0cbe\u0cb8\u0cbf\u0c95",
               "4\u0ca8\u0cc7 \u0ca4\u0ccd\u0cb0\u0cc8\u0cae\u0cbe\u0cb8\u0cbf\u0c95",
            };
        final String[] metaValue_QuarterAbbreviations = new String[] {
               "\u0ca4\u0ccd\u0cb0\u0cc8 1",
               "\u0ca4\u0ccd\u0cb0\u0cc8 2",
               "\u0ca4\u0ccd\u0cb0\u0cc8 3",
               "\u0ca4\u0ccd\u0cb0\u0cc8 4",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "\u0caa\u0cc2\u0cb0\u0ccd\u0cb5\u0cbe\u0cb9\u0ccd\u0ca8",
               "\u0c85\u0caa\u0cb0\u0cbe\u0cb9\u0ccd\u0ca8",
               "\u0cae\u0ca7\u0ccd\u0caf \u0cb0\u0cbe\u0ca4\u0ccd\u0cb0\u0cbf",
               "",
               "\u0cac\u0cc6\u0cb3\u0c97\u0ccd\u0c97\u0cc6",
               "",
               "\u0cae\u0ca7\u0ccd\u0caf\u0cbe\u0cb9\u0ccd\u0ca8",
               "",
               "\u0cb8\u0c82\u0c9c\u0cc6",
               "",
               "\u0cb0\u0cbe\u0ca4\u0ccd\u0cb0\u0cbf",
               "",
            };
        final String[] metaValue_narrow_AmPmMarkers = new String[] {
               "\u0caa\u0cc2",
               "\u0c85",
               "\u0cae\u0ca7\u0ccd\u0caf\u0cb0\u0cbe\u0ca4\u0ccd\u0cb0\u0cbf",
               "",
               "\u0cac\u0cc6\u0cb3\u0c97\u0ccd\u0c97\u0cc6",
               "",
               "\u0cae\u0ca7\u0ccd\u0caf\u0cbe\u0cb9\u0ccd\u0ca8",
               "",
               "\u0cb8\u0c82\u0c9c\u0cc6",
               "",
               "\u0cb0\u0cbe\u0ca4\u0ccd\u0cb0\u0cbf",
               "",
            };
        final String[] metaValue_Eras = new String[] {
               "\u0c95\u0ccd\u0cb0\u0cbf.\u0caa\u0cc2",
               "\u0c95\u0ccd\u0cb0\u0cbf.\u0cb6",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "hh:mm:ss a zzzz",
               "hh:mm:ss a z",
               "hh:mm:ss a",
               "hh:mm a",
            };
        final String[] metaValue_buddhist_QuarterNarrows = new String[] {
               "1",
               "2",
               "3",
               "4",
            };
        final String[] metaValue_java_time_buddhist_long_Eras = new String[] {
               "BC",
               "BE",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "G y MMMM d, EEEE",
               "G y MMMM d",
               "G y MMM d",
               "GGGGG y-MM-dd",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "GGGG y MMMM d, EEEE",
               "GGGG y MMMM d",
               "GGGG y MMM d",
               "G y-MM-dd",
            };
        final String[] metaValue_java_time_roc_long_Eras = new String[] {
               "\u0c86\u0cb0\u0ccd.\u0c93.\u0cb8\u0cbf.\u0c97\u0cc6 \u0cae\u0cc1\u0c82\u0c9a\u0cc6",
               "\u0cae\u0cbf\u0c82\u0c97\u0ccb",
            };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
               "",
               "AH",
            };
        final String metaValue_calendarname_gregorian = "\u0c97\u0ccd\u0cb0\u0cc6\u0c97\u0ccb\u0cb0\u0cbf\u0caf\u0ca8\u0ccd \u0c95\u0ccd\u0caf\u0cbe\u0cb2\u0cc6\u0c82\u0ca1\u0cb0\u0ccd";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u0cb5\u0cb0\u0ccd\u0cb7" },
            { "calendarname.islamic-umalqura", "\u0c87\u0cb8\u0ccd\u0cb2\u0cbe\u0cae\u0cbf\u0c95\u0ccd \u0c95\u0ccd\u0caf\u0cbe\u0cb2\u0cc6\u0c82\u0ca1\u0cb0\u0ccd (\u0c89\u0cae\u0ccd \u0c85\u0cb2\u0ccd-\u0c96\u0cc1\u0cb0\u0cbe)" },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "calendarname.islamic-civil", "\u0c87\u0cb8\u0ccd\u0cb2\u0cbe\u0cae\u0cbf\u0c95\u0ccd-\u0cb8\u0cbf\u0cb5\u0cbf\u0cb2\u0ccd \u0c95\u0ccd\u0caf\u0cbe\u0cb2\u0cc6\u0c82\u0ca1\u0cb0\u0ccd" },
            { "islamic.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "narrow.Eras", metaValue_Eras },
            { "roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "timezone.regionFormat.standard", "{0} \u0caa\u0ccd\u0cb0\u0cae\u0cbe\u0ca3\u0cbf\u0ca4 \u0cb8\u0cae\u0caf" },
            { "japanese.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.japanese", "\u0c9c\u0caa\u0cbe\u0ca8\u0cc0\u0cb8\u0ccd \u0c95\u0ccd\u0caf\u0cbe\u0cb2\u0cc6\u0c82\u0ca1\u0cb0\u0ccd" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "long.Eras",
                new String[] {
                    "\u0c95\u0ccd\u0cb0\u0cbf\u0cb8\u0ccd\u0ca4 \u0caa\u0cc2\u0cb0\u0ccd\u0cb5",
                    "\u0c95\u0ccd\u0cb0\u0cbf\u0cb8\u0ccd\u0ca4 \u0cb6\u0c95",
                }
            },
            { "roc.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u0ca8\u0cbf\u0cae\u0cbf\u0cb7" },
            { "field.era", "\u0caf\u0cc1\u0c97" },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "AM/PM" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.MonthNames",
                new String[] {
                    "\u0cae\u0cc1\u0cb9\u0cb0\u0cae\u0ccd",
                    "\u0cb8\u0cab\u0cbe\u0cb0\u0ccd",
                    "\u0cb0\u0cac\u0cbf\u2018 I",
                    "\u0cb0\u0cac\u0cbf\u2018 II",
                    "\u0c9c\u0cc1\u0cae\u0cbe\u0ca6\u0cbe I",
                    "\u0c9c\u0cc1\u0cae\u0cbe\u0ca6\u0cbe II",
                    "\u0cb0\u0c9c\u0cac\u0ccd",
                    "\u0cb6\u2019\u0cac\u0cbe\u0ca8\u0ccd",
                    "\u0cb0\u0cae\u0ca6\u0cbe\u0ca8\u0ccd",
                    "\u0cb6\u0cb5\u0ccd\u0cb5\u0cbe\u0cb2\u0ccd",
                    "\u0ca7\u0cc1\u2018\u0cb2\u0ccd-\u0c95\u0cbf\u2018\u0ca1\u0cbe\u0cb9\u0ccd",
                    "\u0ca7\u0cc1\u2018\u0cb2\u0ccd-\u0cb9\u0cbf\u0c9c\u0cbe\u0cb9\u0ccd",
                    "",
                }
            },
            { "japanese.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "calendarname.roc", "\u0cae\u0cbf\u0c82\u0c97\u0ccb \u0c95\u0ccd\u0caf\u0cbe\u0cb2\u0cc6\u0c82\u0ca1\u0cb0\u0ccd" },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "field.month", "\u0ca4\u0cbf\u0c82\u0c97\u0cb3\u0cc1" },
            { "roc.Eras", metaValue_java_time_roc_long_Eras },
            { "field.second", "\u0cb8\u0cc6\u0c95\u0cc6\u0c82\u0ca1\u0ccd" },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "\u0c87\u0cb8\u0ccd\u0cb2\u0cbe\u0cae\u0cbf\u0c95\u0ccd \u0c95\u0ccd\u0caf\u0cbe\u0cb2\u0cc6\u0c82\u0ca1\u0cb0\u0ccd" },
            { "java.time.roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "DayPeriodRules", "midnight:00:00;night1:21:00-06:00;afternoon1:12:00-18:00;morning1:06:00-12:00;evening1:18:00-21:00" },
            { "knda.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0ce6",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "java.time.roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "japanese.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations",
                new String[] {
                    "\u0c9c\u0ca8",
                    "\u0cab\u0cc6\u0cac\u0ccd\u0cb0",
                    "\u0cae\u0cbe\u0cb0\u0ccd\u0c9a\u0ccd",
                    "\u0c8f\u0caa\u0ccd\u0cb0\u0cbf",
                    "\u0cae\u0cc7",
                    "\u0c9c\u0cc2\u0ca8\u0ccd",
                    "\u0c9c\u0cc1\u0cb2\u0cc8",
                    "\u0c86\u0c97",
                    "\u0cb8\u0cc6\u0caa\u0ccd\u0c9f\u0cc6\u0c82",
                    "\u0c85\u0c95\u0ccd\u0c9f\u0ccb",
                    "\u0ca8\u0cb5\u0cc6\u0c82",
                    "\u0ca1\u0cbf\u0cb8\u0cc6\u0c82",
                    "",
                }
            },
            { "timezone.regionFormat", "{0} \u0cb8\u0cae\u0caf" },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0' '\u0cb8\u0cbe\u0cb5\u0cbf\u0cb0 other:0' '\u0cb8\u0cbe\u0cb5\u0cbf\u0cb0}",
                    "{one:00' '\u0cb8\u0cbe\u0cb5\u0cbf\u0cb0 other:00' '\u0cb8\u0cbe\u0cb5\u0cbf\u0cb0}",
                    "{one:000' '\u0cb8\u0cbe\u0cb5\u0cbf\u0cb0 other:000' '\u0cb8\u0cbe\u0cb5\u0cbf\u0cb0}",
                    "{one:0' '\u0cae\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd other:0' '\u0cae\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd}",
                    "{one:00' '\u0cae\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd other:00' '\u0cae\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd}",
                    "{one:000' '\u0cae\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd other:000' '\u0cae\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd}",
                    "{one:0' '\u0cac\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd other:0' '\u0cac\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd}",
                    "{one:00' '\u0cac\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd other:00' '\u0cac\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd}",
                    "{one:000' '\u0cac\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd other:000' '\u0cac\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd}",
                    "{one:0' '\u0c9f\u0ccd\u0cb0\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd\u200c other:0' '\u0c9f\u0ccd\u0cb0\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd\u200c}",
                    "{one:00' '\u0c9f\u0ccd\u0cb0\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd\u200c other:00' '\u0c9f\u0ccd\u0cb0\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd\u200c}",
                    "{one:000' '\u0c9f\u0ccd\u0cb0\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd\u200c other:000' '\u0c9f\u0ccd\u0cb0\u0cbf\u0cb2\u0cbf\u0caf\u0ca8\u0ccd\u200c}",
                }
            },
            { "roc.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "java.time.buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "java.time.roc.Eras", metaValue_java_time_roc_long_Eras },
            { "field.zone", "\u0cb8\u0cae\u0caf \u0cb5\u0cb2\u0caf" },
            { "japanese.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.narrow.Eras", metaValue_java_time_roc_long_Eras },
            { "buddhist.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "Eras", metaValue_Eras },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "islamic.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "field.weekday", "\u0cb5\u0cbe\u0cb0\u0ca6 \u0ca6\u0cbf\u0ca8" },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "java.time.buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "japanese.DayNames", metaValue_DayNames },
            { "knda.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "\u00a4#,##0.00",
                    "#,##0%",
                    "",
                }
            },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "field.week", "\u0cb5\u0cbe\u0cb0" },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0\u0cb8\u0cbe other:0\u0cb8\u0cbe}",
                    "{one:00\u0cb8\u0cbe other:00\u0cb8\u0cbe}",
                    "{one:000\u0cb8\u0cbe other:000\u0cb8\u0cbe}",
                    "{one:0\u0cae\u0cbf other:0\u0cae\u0cbf}",
                    "{one:00\u0cae\u0cbf other:00\u0cae\u0cbf}",
                    "{one:000\u0cae\u0cbf other:000\u0cae\u0cbf}",
                    "{one:0\u0cac\u0cbf other:0\u0cac\u0cbf}",
                    "{one:00\u0cac\u0cbf other:00\u0cac\u0cbf}",
                    "{one:000\u0cac\u0cbf other:000\u0cac\u0cbf}",
                    "{one:0\u0c9f\u0ccd\u0cb0\u0cbf other:0\u0c9f\u0ccd\u0cb0\u0cbf}",
                    "{one:00\u0c9f\u0ccd\u0cb0\u0cbf other:00\u0c9f\u0ccd\u0cb0\u0cbf}",
                    "{one:000\u0c9f\u0ccd\u0cb0\u0cbf other:000\u0c9f\u0ccd\u0cb0\u0cbf}",
                }
            },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "java.time.buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "timezone.regionFormat.daylight", "{0} \u0ca6\u0cbf\u0ca8\u0ca6 \u0cb8\u0cae\u0caf" },
            { "DatePatterns",
                new String[] {
                    "EEEE, MMMM d, y",
                    "MMMM d, y",
                    "MMM d, y",
                    "d/M/yy",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames", metaValue_DayNames },
            { "PluralRules", "one:i = 0 or n = 1" },
            { "field.hour", "\u0c97\u0c82\u0c9f\u0cc6" },
            { "islamic.MonthAbbreviations",
                new String[] {
                    "\u0cae\u0cc1\u0cb9\u0ccd.",
                    "\u0cb8\u0cab\u0cbe.",
                    "\u0cb0\u0cac\u0cbf\u2018 I",
                    "\u0cb0\u0cac\u0cbf\u2018 II",
                    "\u0c9c\u0cc1\u0cae\u0ccd. I",
                    "\u0c9c\u0cc1\u0cae\u0ccd. II",
                    "\u0cb0\u0c9c\u0ccd.",
                    "\u0cb6.",
                    "\u0cb0\u0cae\u0ccd.",
                    "\u0cb6\u0cb5\u0ccd.",
                    "\u0ca7\u0cc1\u2018\u0cb2\u0ccd-\u0c95\u0cbf.",
                    "\u0ca7\u0cc1\u2018\u0cb2\u0ccd-\u0cb9.",
                    "",
                }
            },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "calendarname.buddhist", "\u0cac\u0ccc\u0ca6\u0ccd\u0ca7\u0cb0 \u0c95\u0ccd\u0caf\u0cbe\u0cb2\u0cc6\u0c82\u0ca1\u0cb0\u0ccd" },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "\u00a4#,##0.00",
                    "#,##0%",
                    "\u00a4#,##0.00;(\u00a4#,##0.00)",
                }
            },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
