/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mk extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bas = "\u0431\u0430\u0441\u0430";
        final String metaValue_zbl = "\u0431\u043b\u0438\u0441\u0441\u0438\u043c\u0431\u043e\u043b\u0438";
        final String metaValue_gu = "\u0433\u0443\u045f\u0430\u0440\u0430\u0442\u0438";
        final String metaValue_kn = "\u043a\u0430\u043d\u043d\u0430\u0434\u0430";
        final String metaValue_nqo = "\u043d\u043a\u043e";
        final String metaValue_te = "\u0442\u0435\u043b\u0443\u0433\u0443";
        final String metaValue_vai = "\u0432\u0430\u0458";
        final Object[][] data = new Object[][] {
            { "001", "\u0421\u0432\u0435\u0442" },
            { "002", "\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "003", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "005", "\u0408\u0443\u0436\u043d\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "009", "\u041e\u043a\u0435\u0430\u043d\u0438\u0458\u0430" },
            { "011", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "013", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "014", "\u0418\u0441\u0442\u043e\u0447\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "015", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "017", "\u0421\u0440\u0435\u0434\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "018", "\u0408\u0443\u0436\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "019", "\u0410\u043c\u0435\u0440\u0438\u043a\u0438" },
            { "021", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u043a\u043e\u043d\u0442\u0438\u043d\u0435\u043d\u0442\u0430\u043b\u043d\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "029", "\u041a\u0430\u0440\u0438\u0431\u0438" },
            { "030", "\u0418\u0441\u0442\u043e\u0447\u043d\u0430 \u0410\u0437\u0438\u0458\u0430" },
            { "034", "\u0408\u0443\u0436\u043d\u0430 \u0410\u0437\u0438\u0458\u0430" },
            { "035", "\u0408\u0443\u0433\u043e\u0438\u0441\u0442\u043e\u0447\u043d\u0430 \u0410\u0437\u0438\u0458\u0430" },
            { "039", "\u0408\u0443\u0436\u043d\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0438\u0458\u0430" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0441\u043a\u0438 \u0440\u0435\u0433\u0438\u043e\u043d" },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "142", "\u0410\u0437\u0438\u0458\u0430" },
            { "143", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u0430 \u0410\u0437\u0438\u0458\u0430" },
            { "145", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0410\u0437\u0438\u0458\u0430" },
            { "150", "\u0415\u0432\u0440\u043e\u043f\u0430" },
            { "151", "\u0418\u0441\u0442\u043e\u0447\u043d\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "154", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "155", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "202", "\u0421\u0443\u043f\u0441\u0430\u0445\u0430\u0440\u0441\u043a\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "419", "\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "AC", "\u041e\u0441\u0442\u0440\u043e\u0432 \u0410\u0441\u0435\u043d\u0441\u0438\u043e\u043d" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0430" },
            { "AE", "\u041e\u0431\u0435\u0434\u0438\u043d\u0435\u0442\u0438 \u0410\u0440\u0430\u043f\u0441\u043a\u0438 \u0415\u043c\u0438\u0440\u0430\u0442\u0438" },
            { "AF", "\u0410\u0432\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0430 \u0438 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "AI", "\u0410\u043d\u0433\u0432\u0438\u043b\u0430" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438\u0458\u0430" },
            { "AM", "\u0415\u0440\u043c\u0435\u043d\u0438\u0458\u0430" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u043a" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0421\u0430\u043c\u043e\u0430" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438\u0458\u0430" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0430" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "AX", "\u041e\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0435\u0458\u045f\u0430\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0430 \u0438 \u0425\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "BE", "\u0411\u0435\u043b\u0433\u0438\u0458\u0430" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u0443\u0433\u0430\u0440\u0438\u0458\u0430" },
            { "BH", "\u0411\u0430\u0445\u0440\u0435\u0438\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0432\u0435\u0442\u0438 \u0412\u0430\u0440\u0442\u043e\u043b\u043e\u043c\u0435\u0458" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0438" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0458" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438\u0458\u0430" },
            { "BQ", "\u041a\u0430\u0440\u0438\u043f\u0441\u043a\u0430 \u0425\u043e\u043b\u0430\u043d\u0434\u0438\u0458\u0430" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b" },
            { "BS", "\u0411\u0430\u0445\u0430\u043c\u0438" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u041e\u0441\u0442\u0440\u043e\u0432 \u0411\u0443\u0432\u0435" },
            { "BW", "\u0411\u043e\u0446\u0432\u0430\u043d\u0430" },
            { "BY", "\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0438\u0458\u0430" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437\u0435" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u0438 (\u041a\u0438\u043b\u0438\u043d\u0448\u043a\u0438) \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e - \u041a\u0438\u043d\u0448\u0430\u0441\u0430" },
            { "CF", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e - \u0411\u0440\u0430\u0437\u0430\u0432\u0438\u043b" },
            { "CH", "\u0428\u0432\u0430\u0458\u0446\u0430\u0440\u0438\u0458\u0430" },
            { "CI", "\u0411\u0440\u0435\u0433\u043e\u0442 \u043d\u0430 \u0421\u043b\u043e\u043d\u043e\u0432\u0430\u0442\u0430 \u041a\u043e\u0441\u043a\u0430" },
            { "CK", "\u041a\u0443\u043a\u043e\u0432\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "CL", "\u0427\u0438\u043b\u0435" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u041a\u0438\u043d\u0430" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430" },
            { "CP", "\u041e\u0441\u0442\u0440\u043e\u0432 \u041a\u043b\u0438\u043f\u0435\u0440\u0442\u043e\u043d" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430\u0440\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e \u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u0443\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u0411\u043e\u0436\u0438\u045c\u0435\u043d \u041e\u0441\u0442\u0440\u043e\u0432" },
            { "CY", "\u041a\u0438\u043f\u0430\u0440" },
            { "CZ", "\u0427\u0435\u0448\u043a\u0430" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u0458\u0430" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e \u0413\u0430\u0440\u0441\u0438\u0458\u0430" },
            { "DJ", "\u040f\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0441\u043a\u0430" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "DO", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0438 \u041c\u0435\u043b\u0438\u0459\u0430" },
            { "EC", "\u0415\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "EE", "\u0415\u0441\u0442\u043e\u043d\u0438\u0458\u0430" },
            { "EG", "\u0415\u0433\u0438\u043f\u0435\u0442" },
            { "EH", "\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0421\u0430\u0445\u0430\u0440\u0430" },
            { "ER", "\u0415\u0440\u0438\u0442\u0440\u0435\u0458\u0430" },
            { "ES", "\u0428\u043f\u0430\u043d\u0438\u0458\u0430" },
            { "ET", "\u0415\u0442\u0438\u043e\u043f\u0438\u0458\u0430" },
            { "EU", "\u0415\u0432\u0440\u043e\u043f\u0441\u043a\u0430 \u0443\u043d\u0438\u0458\u0430" },
            { "EZ", "\u0415\u0432\u0440\u043e\u0437\u043e\u043d\u0430" },
            { "FI", "\u0424\u0438\u043d\u0441\u043a\u0430" },
            { "FJ", "\u0424\u0438\u045f\u0438" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "FO", "\u0424\u0430\u0440\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u0438\u0458\u0430" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "GB", "\u041e\u0431\u0435\u0434\u0438\u043d\u0435\u0442\u043e \u041a\u0440\u0430\u043b\u0441\u0442\u0432\u043e" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u0440\u0443\u0437\u0438\u0458\u0430" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u0413\u0432\u0430\u0458\u0430\u043d\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0437\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438\u0458\u0430" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u0458\u0430" },
            { "GP", "\u0413\u0432\u0430\u0434\u0430\u043b\u0443\u043f\u0435" },
            { "GQ", "\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0441\u043a\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430" },
            { "GR", "\u0413\u0440\u0446\u0438\u0458\u0430" },
            { "GS", "\u0408\u0443\u0436\u043d\u0430 \u040f\u043e\u0440\u045f\u0438\u0458\u0430 \u0438 \u0408\u0443\u0436\u043d\u0438 \u0421\u0435\u043d\u0434\u0432\u0438\u0447\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u0458\u0430 \u0411\u0438\u0441\u0430\u043e" },
            { "GY", "\u0413\u0432\u0430\u0458\u0430\u043d\u0430" },
            { "HK", "\u0425\u043e\u043d\u0433\u043a\u043e\u043d\u0433 \u0421\u0410\u0420 \u041a\u0438\u043d\u0430" },
            { "HM", "\u041e\u0441\u0442\u0440\u043e\u0432 \u0425\u0435\u0440\u0434 \u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u041c\u0435\u043a\u0434\u043e\u043d\u0430\u043b\u0434" },
            { "HN", "\u0425\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u0440\u0432\u0430\u0442\u0441\u043a\u0430" },
            { "HT", "\u0425\u0430\u0438\u0442\u0438" },
            { "HU", "\u0423\u043d\u0433\u0430\u0440\u0438\u0458\u0430" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "IE", "\u0418\u0440\u0441\u043a\u0430" },
            { "IL", "\u0418\u0437\u0440\u0430\u0435\u043b" },
            { "IM", "\u041e\u0441\u0442\u0440\u043e\u0432 \u041c\u0430\u043d" },
            { "IN", "\u0418\u043d\u0434\u0438\u0458\u0430" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430 \u0418\u043d\u0434\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u043a\u0430 \u0422\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0458\u0430" },
            { "IQ", "\u0418\u0440\u0430\u043a" },
            { "IR", "\u0418\u0440\u0430\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438\u0458\u0430" },
            { "JE", "\u040f\u0435\u0440\u0441\u0438" },
            { "JM", "\u0408\u0430\u043c\u0430\u0458\u043a\u0430" },
            { "JO", "\u0408\u043e\u0440\u0434\u0430\u043d" },
            { "JP", "\u0408\u0430\u043f\u043e\u043d\u0438\u0458\u0430" },
            { "KE", "\u041a\u0435\u043d\u0438\u0458\u0430" },
            { "KG", "\u041a\u0438\u0440\u0433\u0438\u0441\u0442\u0430\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u045f\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "KN", "\u0421\u0432\u0435\u0442\u0438 \u041a\u0438\u0442\u0441 \u0438 \u041d\u0435\u0432\u0438\u0441" },
            { "KP", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u041a\u043e\u0440\u0435\u0458\u0430" },
            { "KR", "\u0408\u0443\u0436\u043d\u0430 \u041a\u043e\u0440\u0435\u0458\u0430" },
            { "KW", "\u041a\u0443\u0432\u0430\u0458\u0442" },
            { "KY", "\u041a\u0430\u0458\u043c\u0430\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0431\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442 \u041b\u0443\u0441\u0438\u0458\u0430" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0430\u0458\u043d" },
            { "LK", "\u0428\u0440\u0438 \u041b\u0430\u043d\u043a\u0430" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438\u0458\u0430" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430\u043d\u0438\u0458\u0430" },
            { "LU", "\u041b\u0443\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438\u0458\u0430" },
            { "LY", "\u041b\u0438\u0431\u0438\u0458\u0430" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u0430\u0432\u0438\u0458\u0430" },
            { "ME", "\u0426\u0440\u043d\u0430 \u0413\u043e\u0440\u0430" },
            { "MF", "\u0421\u0435\u043d\u0442 \u041c\u0430\u0440\u0442\u0438\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "MK", "\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u0458\u0430" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MM", "\u041c\u0458\u0430\u043d\u043c\u0430\u0440 (\u0411\u0443\u0440\u043c\u0430)" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u0458\u0430" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e \u0421\u0410\u0420" },
            { "MP", "\u0421\u0435\u0432\u0435\u0440\u043d\u0438 \u041c\u0430\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u0458\u0430" },
            { "MS", "\u041c\u043e\u043d\u0441\u0435\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u0442\u0430" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u0446\u0438\u0443\u0441" },
            { "MV", "\u041c\u0430\u043b\u0434\u0438\u0432\u0438" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u043e" },
            { "MY", "\u041c\u0430\u043b\u0435\u0437\u0438\u0458\u0430" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438\u0458\u0430" },
            { "NC", "\u041d\u043e\u0432\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u0458\u0430" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u0448\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438\u0458\u0430" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0432\u0430" },
            { "NL", "\u0425\u043e\u043b\u0430\u043d\u0434\u0438\u0458\u0430" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0448\u043a\u0430" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u0458\u0435" },
            { "NZ", "\u041d\u043e\u0432 \u0417\u0435\u043b\u0430\u043d\u0434" },
            { "OM", "\u041e\u043c\u0430\u043d" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u0458\u0430" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u041d\u043e\u0432\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u0438\u043d\u0438" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u0441\u043a\u0430" },
            { "PM", "\u0421\u0435\u043d\u0442 \u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u0430\u043d" },
            { "PN", "\u041f\u0438\u0442\u043a\u0435\u0440\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "PR", "\u041f\u043e\u0440\u0442\u043e\u0440\u0438\u043a\u043e" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0441\u043a\u0438 \u0422\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0438" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0458\u0430" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "QO", "\u0417\u0430\u0432\u0438\u0441\u043d\u0438 \u0437\u0435\u043c\u0458\u0438 \u0432\u043e \u041e\u043a\u0435\u0430\u043d\u0438\u0458\u0430" },
            { "RE", "\u0420\u0435\u0458\u0443\u043d\u0438\u043e\u043d" },
            { "RO", "\u0420\u043e\u043c\u0430\u043d\u0438\u0458\u0430" },
            { "RS", "\u0421\u0440\u0431\u0438\u0458\u0430" },
            { "RU", "\u0420\u0443\u0441\u0438\u0458\u0430" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0421\u0430\u0443\u0434\u0438\u0441\u043a\u0430 \u0410\u0440\u0430\u0431\u0438\u0458\u0430" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u0441\u043a\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "SC", "\u0421\u0435\u0458\u0448\u0435\u043b\u0438" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "SE", "\u0428\u0432\u0435\u0434\u0441\u043a\u0430" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u0421\u0432\u0435\u0442\u0430 \u0415\u043b\u0435\u043d\u0430" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u0458\u0430" },
            { "SJ", "\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0438 \u0408\u0430\u043d \u041c\u0430\u0458\u0435\u043d" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u0447\u043a\u0430" },
            { "SL", "\u0421\u0438\u0435\u0440\u0430 \u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d \u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438\u0458\u0430" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "SS", "\u0408\u0443\u0436\u0435\u043d \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u0443\u043d \u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0441\u0438\u043f" },
            { "SV", "\u0415\u043b \u0421\u0430\u043b\u0432\u0430\u0434\u043e\u0440" },
            { "SX", "\u0421\u0432\u0435\u0442\u0438 \u041c\u0430\u0440\u0442\u0438\u043d" },
            { "SY", "\u0421\u0438\u0440\u0438\u0458\u0430" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434" },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d \u0434\u0430 \u041a\u0443\u045a\u0430" },
            { "TC", "\u041e\u0441\u0442\u0440\u043e\u0432\u0438 \u0422\u0443\u0440\u043a\u0441 \u0438 \u041a\u0430\u0438\u043a\u043e\u0441" },
            { "TD", "\u0427\u0430\u0434" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438 \u0408\u0443\u0436\u043d\u0438 \u0422\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0438" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0458\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u0430\u045f\u0438\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0422\u0438\u043c\u043e\u0440 \u041b\u0435\u0441\u0442\u0435" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u0443\u0440\u0446\u0438\u0458\u0430" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0438 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0458\u0432\u0430\u043d" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u0458\u0430" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d\u0430" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "UM", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0438 \u0432\u043e \u041f\u0430\u0446\u0438\u0444\u0438\u043a\u043e\u0442" },
            { "UN", "\u041e\u0431\u0435\u0434\u0438\u043d\u0435\u0442\u0438 \u043d\u0430\u0446\u0438\u0438" },
            { "US", "\u0421\u043e\u0435\u0434\u0438\u043d\u0435\u0442\u0438 \u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0414\u0440\u0436\u0430\u0432\u0438" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0458" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d" },
            { "VC", "\u0421\u0435\u043d\u0442 \u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0438 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u0438" },
            { "VE", "\u0412\u0435\u043d\u0435\u0446\u0443\u0435\u043b\u0430" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0438 \u0414\u0435\u0432\u0441\u0442\u0432\u0435\u043d\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "VI", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0414\u0435\u0432\u0441\u0442\u0432\u0435\u043d\u0438 \u041e\u0441\u0442\u0440\u043e\u0432\u0438" },
            { "VN", "\u0412\u0438\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "WF", "\u0412\u0430\u043b\u0438\u0441 \u0438 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "XA", "\u043f\u0441\u0435\u0432\u0434\u043e-\u0430\u043a\u0446\u0435\u043d\u0442\u0438" },
            { "XB", "\u043f\u0441\u0435\u0432\u0434\u043e-\u0431\u0438\u0434\u0438" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "YE", "\u0408\u0435\u043c\u0435\u043d" },
            { "YT", "\u041c\u0430\u0458\u043e\u0442" },
            { "ZA", "\u0408\u0443\u0436\u043d\u043e\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438\u0458\u0430" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u041d\u0435\u043f\u043e\u0437\u043d\u0430\u0442 \u0440\u0435\u0433\u0438\u043e\u043d" },
            { "aa", "\u0430\u0444\u0430\u0440\u0441\u043a\u0438" },
            { "ab", "\u0430\u043f\u0445\u0430\u0441\u043a\u0438" },
            { "ae", "\u0430\u0432\u0435\u0441\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u043d\u0441" },
            { "ak", "\u0430\u043a\u0430\u043d\u0441\u043a\u0438" },
            { "am", "\u0430\u043c\u0445\u0430\u0440\u0441\u043a\u0438" },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d\u0441\u043a\u0438" },
            { "ar", "\u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "as", "\u0430\u0441\u0430\u043c\u0441\u043a\u0438" },
            { "av", "\u0430\u0432\u0430\u0440\u0441\u043a\u0438" },
            { "ay", "\u0430\u0458\u043c\u0430\u0440\u0441\u043a\u0438" },
            { "az", "\u0430\u0437\u0435\u0440\u0431\u0435\u0458\u045f\u0430\u043d\u0441\u043a\u0438" },
            { "ba", "\u0431\u0430\u0448\u043a\u0438\u0440\u0441\u043a\u0438" },
            { "be", "\u0431\u0435\u043b\u043e\u0440\u0443\u0441\u043a\u0438" },
            { "bg", "\u0431\u0443\u0433\u0430\u0440\u0441\u043a\u0438" },
            { "bi", "\u0431\u0438\u0441\u043b\u0430\u043c\u0430" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b\u0441\u043a\u0438" },
            { "bo", "\u0442\u0438\u0431\u0435\u0442\u0441\u043a\u0438" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d\u0441\u043a\u0438" },
            { "bs", "\u0431\u043e\u0441\u0430\u043d\u0441\u043a\u0438" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u043e\u043d\u0441\u043a\u0438" },
            { "ce", "\u0447\u0435\u0447\u0435\u043d\u0441\u043a\u0438" },
            { "ch", "\u0447\u0430\u043c\u043e\u0440\u0441\u043a\u0438" },
            { "co", "\u043a\u043e\u0440\u0437\u0438\u043a\u0430\u043d\u0441\u043a\u0438" },
            { "cr", "\u043a\u0440\u0438" },
            { "cs", "\u0447\u0435\u0448\u043a\u0438" },
            { "cu", "\u0446\u0440\u043a\u043e\u0432\u043d\u043e\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u0438" },
            { "cv", "\u0447\u0443\u0432\u0430\u0448\u043a\u0438" },
            { "cy", "\u0432\u0435\u043b\u0448\u043a\u0438" },
            { "da", "\u0434\u0430\u043d\u0441\u043a\u0438" },
            { "de", "\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "dv", "\u0434\u0438\u0432\u0435\u0445\u0438" },
            { "dz", "\u0455\u043e\u043d\u0433\u043a\u0430" },
            { "ee", "\u0435\u0432\u0435" },
            { "el", "\u0433\u0440\u0447\u043a\u0438" },
            { "en", "\u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "eo", "\u0435\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "es", "\u0448\u043f\u0430\u043d\u0441\u043a\u0438" },
            { "et", "\u0435\u0441\u0442\u043e\u043d\u0441\u043a\u0438" },
            { "eu", "\u0431\u0430\u0441\u043a\u0438\u0441\u043a\u0438" },
            { "fa", "\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u0438" },
            { "ff", "\u0444\u0443\u043b\u0430" },
            { "fi", "\u0444\u0438\u043d\u0441\u043a\u0438" },
            { "fj", "\u0444\u0438\u045f\u0438\u0441\u043a\u0438" },
            { "fo", "\u0444\u0430\u0440\u0441\u043a\u0438" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "fy", "\u0437\u0430\u043f\u0430\u0434\u043d\u043e\u0444\u0440\u0438\u0437\u0438\u0441\u043a\u0438" },
            { "ga", "\u0438\u0440\u0441\u043a\u0438" },
            { "gd", "\u0448\u043a\u043e\u0442\u0441\u043a\u0438 \u0433\u0435\u043b\u0441\u043a\u0438" },
            { "gl", "\u0433\u0430\u043b\u0438\u0446\u0438\u0441\u043a\u0438" },
            { "gn", "\u0433\u0432\u0430\u0440\u0430\u043d\u0441\u043a\u0438" },
            { "gu", metaValue_gu },
            { "gv", "\u043c\u0430\u043d\u043a\u0441" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "he", "\u0445\u0435\u0431\u0440\u0435\u0458\u0441\u043a\u0438" },
            { "hi", "\u0445\u0438\u043d\u0434\u0438" },
            { "ho", "\u0445\u0438\u0440\u0438 \u043c\u043e\u0442\u0443" },
            { "hr", "\u0445\u0440\u0432\u0430\u0442\u0441\u043a\u0438" },
            { "ht", "\u0445\u0430\u0438\u0442\u0441\u043a\u0438" },
            { "hu", "\u0443\u043d\u0433\u0430\u0440\u0441\u043a\u0438" },
            { "hy", "\u0435\u0440\u043c\u0435\u043d\u0441\u043a\u0438" },
            { "hz", "\u0445\u0435\u0440\u0435\u0440\u043e" },
            { "ia", "\u0438\u043d\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0432\u0430" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0441\u043a\u0438" },
            { "ie", "\u043e\u043a\u0446\u0438\u0434\u0435\u043d\u0442\u0430\u043b" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "ii", "\u0441\u0438\u0447\u0443\u0430\u043d \u0458\u0438" },
            { "ik", "\u0438\u043d\u0443\u043f\u0438\u0458\u0430\u0447\u043a\u0438" },
            { "io", "\u0438\u0434\u043e" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "it", "\u0438\u0442\u0430\u043b\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "ja", "\u0458\u0430\u043f\u043e\u043d\u0441\u043a\u0438" },
            { "jv", "\u0458\u0430\u0432\u0430\u043d\u0441\u043a\u0438" },
            { "ka", "\u0433\u0440\u0443\u0437\u0438\u0441\u043a\u0438" },
            { "kg", "\u043a\u043e\u043d\u0433\u043e" },
            { "ki", "\u043a\u0438\u043a\u0443\u0458\u0443" },
            { "kj", "\u043a\u0432\u0430\u045a\u0430\u043c\u0430" },
            { "kk", "\u043a\u0430\u0437\u0430\u0448\u043a\u0438" },
            { "kl", "\u043a\u0430\u043b\u0430\u043b\u0438\u0441\u0443\u0442" },
            { "km", "\u043a\u043c\u0435\u0440\u0441\u043a\u0438" },
            { "kn", metaValue_kn },
            { "ko", "\u043a\u043e\u0440\u0435\u0458\u0441\u043a\u0438" },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0438" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440\u0441\u043a\u0438" },
            { "ku", "\u043a\u0443\u0440\u0434\u0441\u043a\u0438" },
            { "kv", "\u043a\u043e\u043c\u0438" },
            { "kw", "\u043a\u043e\u0440\u043d\u0441\u043a\u0438" },
            { "ky", "\u043a\u0438\u0440\u0433\u0438\u0441\u043a\u0438" },
            { "la", "\u043b\u0430\u0442\u0438\u043d\u0441\u043a\u0438" },
            { "lb", "\u043b\u0443\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0448\u043a\u0438" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "li", "\u043b\u0438\u043c\u0431\u0443\u0440\u0448\u043a\u0438" },
            { "ln", "\u043b\u0438\u043d\u0433\u0430\u043b\u0430" },
            { "lo", "\u043b\u0430\u043e\u0448\u043a\u0438" },
            { "lt", "\u043b\u0438\u0442\u0432\u0430\u043d\u0441\u043a\u0438" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "lv", "\u043b\u0430\u0442\u0432\u0438\u0441\u043a\u0438" },
            { "mg", "\u043c\u0430\u043b\u0433\u0430\u0448\u043a\u0438" },
            { "mh", "\u043c\u0430\u0440\u0448\u0430\u043b\u0441\u043a\u0438" },
            { "mi", "\u043c\u0430\u043e\u0440\u0441\u043a\u0438" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438" },
            { "ml", "\u043c\u0430\u043b\u0430\u0458\u0430\u043b\u0441\u043a\u0438" },
            { "mn", "\u043c\u043e\u043d\u0433\u043e\u043b\u0441\u043a\u0438" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0438" },
            { "ms", "\u043c\u0430\u043b\u0430\u0458\u0441\u043a\u0438" },
            { "mt", "\u043c\u0430\u043b\u0442\u0435\u0448\u043a\u0438" },
            { "my", "\u0431\u0443\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "na", "\u043d\u0430\u0443\u0440\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "nb", "\u043d\u043e\u0440\u0432\u0435\u0448\u043a\u0438 \u0431\u0443\u043a\u043c\u043e\u043b" },
            { "nd", "\u0441\u0435\u0432\u0435\u0440\u0435\u043d \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u0441\u043a\u0438" },
            { "ng", "\u043d\u0434\u043e\u043d\u0433\u0430" },
            { "nl", "\u0445\u043e\u043b\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "nn", "\u043d\u043e\u0440\u0432\u0435\u0448\u043a\u0438 \u043d\u0438\u043d\u043e\u0440\u0441\u043a" },
            { "no", "\u043d\u043e\u0440\u0432\u0435\u0448\u043a\u0438" },
            { "nr", "\u0458\u0443\u0436\u0435\u043d \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "nv", "\u043d\u0430\u0432\u0430\u0445\u043e" },
            { "ny", "\u045a\u0430\u043d\u045f\u0430" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "oj", "\u043e\u045f\u0438\u0431\u0432\u0430" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "or", "\u043e\u0434\u0438\u0458\u0430" },
            { "os", "\u043e\u0441\u0435\u0442\u0441\u043a\u0438" },
            { "pa", "\u043f\u0435\u043d\u045f\u0430\u043f\u0441\u043a\u0438" },
            { "pi", "\u043f\u0430\u043b\u0438" },
            { "pl", "\u043f\u043e\u043b\u0441\u043a\u0438" },
            { "ps", "\u043f\u0430\u0448\u0442\u0443\u043d\u0441\u043a\u0438" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0441\u043a\u0438" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "rm", "\u0440\u0435\u0442\u043e\u0440\u043e\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "rn", "\u0440\u0443\u043d\u0434\u0438" },
            { "ro", "\u0440\u043e\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "ru", "\u0440\u0443\u0441\u043a\u0438" },
            { "rw", "\u0440\u0443\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "sc", "\u0441\u0430\u0440\u0434\u0438\u043d\u0441\u043a\u0438" },
            { "sd", "\u0441\u0438\u043d\u0434\u0438" },
            { "se", "\u0441\u0435\u0432\u0435\u0440\u0435\u043d \u0441\u0430\u043c\u0438" },
            { "sg", "\u0441\u0430\u043d\u0433\u043e" },
            { "sh", "\u0441\u0440\u043f\u0441\u043a\u043e\u0445\u0440\u0432\u0430\u0442\u0441\u043a\u0438" },
            { "si", "\u0441\u0438\u043d\u0445\u0430\u043b\u0441\u043a\u0438" },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u0447\u043a\u0438" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d\u0435\u0447\u043a\u0438" },
            { "sm", "\u0441\u0430\u043c\u043e\u0430\u043d\u0441\u043a\u0438" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438\u0441\u043a\u0438" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u0441\u043a\u0438" },
            { "sr", "\u0441\u0440\u043f\u0441\u043a\u0438" },
            { "ss", "\u0441\u0432\u0430\u0442\u0438" },
            { "st", "\u0441\u0435\u0441\u043e\u0442\u043e" },
            { "su", "\u0441\u0443\u043d\u0434\u0441\u043a\u0438" },
            { "sv", "\u0448\u0432\u0435\u0434\u0441\u043a\u0438" },
            { "sw", "\u0441\u0432\u0430\u0445\u0438\u043b\u0438" },
            { "ta", "\u0442\u0430\u043c\u0438\u043b\u0441\u043a\u0438" },
            { "te", metaValue_te },
            { "tg", "\u0442\u0430\u045f\u0438\u043a\u0438\u0441\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "th", "\u0442\u0430\u0458\u043b\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u045a\u0430" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u043a\u0438" },
            { "tl", "\u0442\u0430\u0433\u0430\u043b\u043e\u0433" },
            { "tn", "\u0446\u0432\u0430\u043d\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430\u0458\u0441\u043a\u0438" },
            { "tr", "\u0442\u0443\u0440\u0441\u043a\u0438" },
            { "ts", "\u0446\u043e\u043d\u0433\u0430" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440\u0441\u043a\u0438" },
            { "tw", "\u0442\u0432\u0438" },
            { "ty", "\u0442\u0430\u0445\u0438\u0442\u0441\u043a\u0438" },
            { "ug", "\u0443\u0458\u0433\u0443\u0440\u0441\u043a\u0438" },
            { "uk", "\u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "uz", "\u0443\u0437\u0431\u0435\u0447\u043a\u0438" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "vi", "\u0432\u0438\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0438" },
            { "vo", "\u0432\u043e\u043b\u0430\u043f\u0438\u043a" },
            { "wa", "\u0432\u0430\u043b\u043e\u043d\u0441\u043a\u0438" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444\u0441\u043a\u0438" },
            { "xh", "\u043a\u043e\u0441\u0430" },
            { "yi", "\u0458\u0438\u0434\u0438\u0448" },
            { "yo", "\u0458\u043e\u0440\u0443\u043f\u0441\u043a\u0438" },
            { "za", "\u045f\u0443\u0430\u043d\u0448\u043a\u0438" },
            { "zh", "\u043a\u0438\u043d\u0435\u0441\u043a\u0438" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "ace", "\u0430\u0447\u0435\u0448\u043a\u0438" },
            { "ach", "\u0430\u043a\u043e\u043b\u0438" },
            { "ada", "\u0430\u0434\u0430\u043d\u0433\u043c\u0435" },
            { "ady", "\u0430\u0434\u0438\u0433\u0435\u0458\u0441\u043a\u0438" },
            { "aeb", "\u0442\u0443\u043d\u0438\u0441\u043a\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "afh", "\u0430\u0444\u0440\u0438\u0445\u0438\u043b\u0438" },
            { "agq", "\u0430\u0433\u0435\u043c\u0441\u043a\u0438" },
            { "ain", "\u0430\u0458\u043d\u0443" },
            { "akk", "\u0430\u043a\u0430\u0434\u0441\u043a\u0438" },
            { "akz", "\u0430\u043b\u0430\u0431\u0430\u043c\u0441\u043a\u0438" },
            { "ale", "\u0430\u043b\u0435\u0443\u0442\u0441\u043a\u0438" },
            { "aln", "\u0433\u0435\u0448\u043a\u0438 \u0430\u043b\u0431\u0430\u043d\u0441\u043a\u0438" },
            { "alt", "\u0458\u0443\u0436\u043d\u043e\u0430\u043b\u0442\u0430\u0458\u0441\u043a\u0438" },
            { "ang", "\u0441\u0442\u0430\u0440\u043e\u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "ann", "\u043e\u0431\u043e\u043b\u043e" },
            { "anp", "\u0430\u043d\u0433\u0438\u043a\u0430" },
            { "arc", "\u0430\u0440\u0430\u043c\u0435\u0458\u0441\u043a\u0438" },
            { "arn", "\u043c\u0430\u043f\u0443\u0447\u043a\u0438" },
            { "aro", "\u0430\u0440\u0430\u043e\u043d\u0430" },
            { "arp", "\u0430\u0440\u0430\u043f\u0430\u0445\u043e" },
            { "arq", "\u0430\u043b\u0436\u0438\u0440\u0441\u043a\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "ars", "\u043d\u0435\u045f\u0434\u0438\u0441\u043a\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "arw", "\u0430\u0440\u0430\u0432\u0430\u0447\u043a\u0438" },
            { "ary", "\u043c\u0430\u0440\u043e\u043a\u0430\u043d\u0441\u043a\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "arz", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "asa", "\u0430\u0441\u0443" },
            { "ase", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0437\u043d\u0430\u043a\u043e\u0432\u0435\u043d \u0458\u0430\u0437\u0438\u043a" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u0441\u043a\u0438" },
            { "atj", "\u0430\u0442\u0438\u043a\u0430\u043c\u0435\u043a" },
            { "avk", "\u043a\u043e\u0442\u0430\u0432\u0430" },
            { "awa", "\u0430\u0432\u0430\u0434\u0438" },
            { "bal", "\u0431\u0435\u043b\u0443\u045f\u0438\u0441\u043a\u0438" },
            { "ban", "\u0431\u0430\u043b\u0438\u0441\u043a\u0438" },
            { "bar", "\u0431\u0430\u0432\u0430\u0440\u0441\u043a\u0438" },
            { "bas", metaValue_bas },
            { "bax", "\u0431\u0430\u043c\u0443\u043d\u0441\u043a\u0438" },
            { "bbc", "\u0442\u043e\u0431\u0430" },
            { "bbj", "\u0433\u043e\u043c\u0430\u043b\u0430" },
            { "bej", "\u0431\u0435\u045f\u0430" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "bew", "\u0431\u0435\u0442\u0430\u0432\u0441\u043a\u0438" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "bfd", "\u0431\u0430\u0444\u0443\u0442" },
            { "bfq", "\u0431\u0430\u0434\u0430\u0433\u0430" },
            { "bgn", "\u0437\u0430\u043f\u0430\u0434\u0435\u043d \u0431\u0430\u043b\u043e\u0447\u0438" },
            { "bho", "\u0431\u043e\u045f\u043f\u0443\u0440\u0438" },
            { "bik", "\u0431\u0438\u043a\u043e\u043b\u0441\u043a\u0438" },
            { "bin", "\u0431\u0438\u043d\u0438" },
            { "bjn", "\u0431\u0430\u043d\u045f\u0430\u0440\u0441\u043a\u0438" },
            { "bkm", "\u043a\u043e\u043c" },
            { "bla", "\u0441\u0438\u043a\u0441\u0438\u043a\u0430" },
            { "bpy", "\u0431\u0438\u0448\u043d\u0443\u043f\u0440\u0438\u0458\u0430" },
            { "bqi", "\u0431\u0430\u0445\u0442\u0438\u0458\u0430\u0440\u0441\u043a\u0438" },
            { "bra", "\u0431\u0440\u0430\u0458" },
            { "brh", "\u0431\u0440\u0430\u0445\u0443\u0458\u0441\u043a\u0438" },
            { "brx", "\u0431\u043e\u0434\u043e" },
            { "bss", "\u0430\u043a\u043e\u0441\u0435" },
            { "bua", "\u0431\u0443\u0440\u0458\u0430\u0442\u0441\u043a\u0438" },
            { "bug", "\u0431\u0443\u0433\u0438\u0441\u043a\u0438" },
            { "bum", "\u0431\u0443\u043b\u0443" },
            { "byn", "\u0431\u0438\u043b\u0435\u043d\u0441\u043a\u0438" },
            { "byv", "\u043c\u0435\u0434\u0443\u043c\u0431\u0430" },
            { "cad", "\u043a\u0430\u0434\u043e" },
            { "car", "\u043a\u0430\u0440\u0438\u043f\u0441\u043a\u0438" },
            { "cay", "\u043a\u0430\u0458\u0443\u0433\u0430" },
            { "cch", "\u0430\u0446\u0430\u043c" },
            { "ccp", "\u0447\u0430\u043a\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "cgg", "\u0447\u0438\u0433\u0430" },
            { "chb", "\u0447\u0438\u0431\u0447\u0430" },
            { "chg", "\u0447\u0430\u0433\u0430\u0442\u0430\u0458\u0441\u043a\u0438" },
            { "chk", "\u0447\u0443\u0447\u043a\u0438" },
            { "chm", "\u043c\u0430\u0440\u0438\u0441\u043a\u0438" },
            { "chn", "\u0447\u0438\u043d\u0443\u0447\u043a\u0438 \u0436\u0430\u0440\u0433\u043e\u043d" },
            { "cho", "\u0447\u043e\u043a\u0442\u0430\u0432\u0441\u043a\u0438" },
            { "chp", "\u0447\u0438\u043f\u0435\u0432\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "chr", "\u0447\u0435\u0440\u043e\u043a\u0438" },
            { "chy", "\u0447\u0435\u0458\u0435\u043d\u0441\u043a\u0438" },
            { "ckb", "\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u043a\u0443\u0440\u0434\u0441\u043a\u0438" },
            { "clc", "\u0447\u0438\u043b\u043a\u043e\u0442\u0438\u043d\u0441\u043a\u0438" },
            { "cop", "\u043a\u043e\u043f\u0442\u0441\u043a\u0438" },
            { "cps", "\u043a\u0430\u043f\u0438\u0437\u043d\u043e\u043d" },
            { "crg", "\u043c\u0438\u0447\u0438\u0444" },
            { "crh", "\u043a\u0440\u0438\u043c\u0441\u043a\u043e\u0442\u0443\u0440\u0441\u043a\u0438" },
            { "crj", "\u0458\u0443\u0433\u043e\u0438\u0441\u0442\u043e\u0447\u0435\u043d \u043a\u0440\u0438\u0458\u0441\u043a\u0438" },
            { "crk", "\u043f\u0440\u0435\u0440\u0438\u0441\u043a\u0438 \u043a\u0440\u0438\u0458\u0441\u043a\u0438" },
            { "crl", "\u0441\u0435\u0432\u0435\u0440\u043e\u0438\u0441\u0442\u043e\u0447\u0435\u043d \u043a\u0440\u0438\u0458\u0441\u043a\u0438" },
            { "crm", "\u043b\u043e\u0441\u043e\u0432\u0441\u043a\u0438 \u043a\u0440\u0438\u0458\u0441\u043a\u0438" },
            { "crr", "\u043a\u0430\u0440\u043e\u043b\u0438\u043d\u0441\u043a\u0438 \u0430\u043b\u0433\u043e\u043d\u043a\u0438\u043d\u0441\u043a\u0438" },
            { "crs", "\u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438 (\u0421\u0435\u0441\u0435\u043b\u0432\u0430 \u043a\u0440\u0435\u043e\u043b\u0438)" },
            { "csb", "\u043a\u0430\u0448\u0443\u043f\u0441\u043a\u0438" },
            { "csw", "\u043c\u043e\u0447\u0443\u0440\u0438\u0448\u0435\u043d \u043a\u0440\u0438\u0458\u0441\u043a\u0438" },
            { "dak", "\u0434\u0430\u043a\u043e\u0442\u0430" },
            { "dar", "\u0434\u0430\u0440\u0433\u0432\u0430" },
            { "dav", "\u0442\u0430\u0438\u0442\u0430" },
            { "del", "\u0434\u0435\u043b\u0430\u0432\u0435\u0440" },
            { "den", "\u0441\u043b\u0435\u0458\u0432\u0438" },
            { "dgr", "\u0434\u043e\u0433\u0440\u0438\u043f\u0441\u043a\u0438" },
            { "din", "\u0434\u0438\u043d\u043a\u0430" },
            { "dje", "\u0437\u0430\u0440\u043c\u0430" },
            { "doi", "\u0434\u043e\u0433\u0440\u0438" },
            { "dsb", "\u0434\u043e\u043b\u043d\u043e\u043b\u0443\u0436\u0438\u0447\u043a\u0438" },
            { "dtp", "\u0434\u0443\u0441\u0443\u043d\u0441\u043a\u0438" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "dum", "\u0441\u0440\u0435\u0434\u043d\u043e\u0445\u043e\u043b\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "dyo", "\u0458\u043e\u043b\u0430-\u0444\u043e\u045a\u0438" },
            { "dyu", "\u045f\u0443\u043b\u0430" },
            { "dzg", "\u0434\u0430\u0437\u0430\u0433\u0430" },
            { "ebu", "\u0435\u043c\u0431\u0443" },
            { "efi", "\u0435\u0444\u0438\u043a" },
            { "egl", "\u0435\u043c\u0438\u043b\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "egy", "\u0441\u0442\u0430\u0440\u043e\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0438" },
            { "eka", "\u0435\u043a\u0430\u045f\u0443\u043a" },
            { "elx", "\u0435\u043b\u0430\u043c\u0441\u043a\u0438" },
            { "enm", "\u0441\u0440\u0435\u0434\u043d\u043e\u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "esu", "\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0458\u0443\u043f\u0438\u0447\u043a\u0438" },
            { "ewo", "\u0435\u0432\u043e\u043d\u0434\u043e" },
            { "ext", "\u0435\u043a\u0441\u0442\u0440\u0435\u043c\u0430\u0434\u0443\u0440\u0441\u043a\u0438" },
            { "fan", "\u0444\u0430\u043d\u0433" },
            { "fat", "\u0444\u0430\u043d\u0442\u0438" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u0438\u043d\u0441\u043a\u0438" },
            { "fit", "\u0442\u0443\u0440\u043d\u0435\u0434\u0430\u043b\u0435\u043d\u0441\u043a\u0438 \u0444\u0438\u043d\u0441\u043a\u0438" },
            { "fon", "\u0444\u043e\u043d" },
            { "frc", "\u043a\u0430\u045f\u0443\u043d\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "frm", "\u0441\u0440\u0435\u0434\u043d\u043e\u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "fro", "\u0441\u0442\u0430\u0440\u043e\u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "frp", "\u0444\u0440\u0430\u043d\u043a\u043e\u043f\u0440\u043e\u0432\u0430\u043d\u0441\u0430\u043b\u0441\u043a\u0438" },
            { "frr", "\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u0444\u0440\u0438\u0437\u0438\u0441\u043a\u0438" },
            { "frs", "\u0438\u0441\u0442\u043e\u0447\u043d\u043e\u0444\u0440\u0438\u0437\u0438\u0441\u043a\u0438" },
            { "fur", "\u0444\u0443\u0440\u043b\u0430\u043d\u0441\u043a\u0438" },
            { "gaa", "\u0433\u0430" },
            { "gag", "\u0433\u0430\u0433\u0430\u0443\u0441\u043a\u0438" },
            { "gan", "\u0433\u0430\u043d" },
            { "gay", "\u0433\u0430\u0458\u043e" },
            { "gba", "\u0433\u0431\u0430\u0458\u0430" },
            { "gbz", "\u0437\u043e\u0440\u043e\u0430\u0441\u0442\u0440\u0438\u0441\u043a\u0438 \u0434\u0430\u0440\u0438" },
            { "gez", "\u0433\u0438\u0437" },
            { "gil", "\u0433\u0438\u043b\u0431\u0435\u0440\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "glk", "\u0433\u0438\u043b\u0430\u043d\u0441\u043a\u0438" },
            { "gmh", "\u0441\u0440\u0435\u0434\u043d\u043e\u0433\u043e\u0440\u043d\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "goh", "\u0441\u0442\u0430\u0440\u043e\u0433\u043e\u0440\u043d\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "gom", "\u0433\u043e\u0430\u043d\u0441\u043a\u0438 \u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "gon", "\u0433\u043e\u043d\u0434\u0438" },
            { "gor", "\u0433\u043e\u0440\u043e\u043d\u0442\u0430\u043b\u043e" },
            { "got", "\u0433\u043e\u0442\u0441\u043a\u0438" },
            { "grb", "\u0433\u0440\u0435\u0431\u043e" },
            { "grc", "\u0441\u0442\u0430\u0440\u043e\u0433\u0440\u0447\u043a\u0438" },
            { "gsw", "\u0448\u0432\u0430\u0458\u0446\u0430\u0440\u0441\u043a\u0438 \u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "guc", "\u0433\u0432\u0430\u0445\u0438\u0440\u043e" },
            { "gur", "\u0444\u0430\u0440\u0435\u0444\u0430\u0440\u0435" },
            { "guz", "\u0433\u0443\u0441\u0438" },
            { "gwi", "\u0433\u0432\u0438\u0447\u0438\u043d\u0441\u043a\u0438" },
            { "hai", "\u0445\u0430\u0458\u0434\u0430" },
            { "hak", "\u0445\u0430\u043a\u0430" },
            { "haw", "\u0445\u0430\u0432\u0430\u0458\u0441\u043a\u0438" },
            { "hax", "\u0458\u0443\u0436\u0435\u043d \u0445\u0430\u0458\u0434\u0430" },
            { "hif", "\u0444\u0438\u045f\u0438\u0441\u043a\u0438 \u0445\u0438\u043d\u0434\u0438" },
            { "hil", "\u0445\u0438\u043b\u0438\u0433\u0430\u0458\u043d\u043e\u043d\u0441\u043a\u0438" },
            { "hit", "\u0445\u0435\u0442\u0438\u0442\u0441\u043a\u0438" },
            { "hmn", "\u0445\u043c\u043e\u043d\u0433" },
            { "hsb", "\u0433\u043e\u0440\u043d\u043e\u043b\u0443\u0436\u0438\u0447\u043a\u0438" },
            { "hsn", "\u0441\u0458\u0430\u043d\u0433" },
            { "hup", "\u0445\u0443\u043f\u0430" },
            { "hur", "\u0445\u0430\u043b\u043a\u043e\u043c\u0435\u043b\u0435\u043c" },
            { "iba", "\u0438\u0431\u0430\u043d" },
            { "ibb", "\u0438\u0431\u0438\u0431\u0438\u043e" },
            { "ikt", "\u0437\u0430\u043f\u0430\u0434\u043d\u043e\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0438 \u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "ilo", "\u0438\u043b\u043e\u043a\u0430\u043d\u0441\u043a\u0438" },
            { "inh", "\u0438\u043d\u0433\u0443\u0448\u043a\u0438" },
            { "izh", "\u0438\u0436\u043e\u0440\u0441\u043a\u0438" },
            { "jam", "\u0458\u0430\u043c\u0430\u0458\u0441\u043a\u0438 \u043a\u0440\u0435\u043e\u043b\u0441\u043a\u0438" },
            { "jbo", "\u043b\u043e\u0436\u0431\u0430\u043d" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u0435" },
            { "jpr", "\u0435\u0432\u0440\u0435\u0458\u0441\u043a\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u0438" },
            { "jrb", "\u0435\u0432\u0440\u0435\u0458\u0441\u043a\u043e\u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "jut", "\u0458\u0438\u0442\u0441\u043a\u0438" },
            { "kaa", "\u043a\u0430\u0440\u0430\u043a\u0430\u043b\u043f\u0430\u0447\u043a\u0438" },
            { "kab", "\u043a\u0430\u0431\u0438\u043b\u0441\u043a\u0438" },
            { "kac", "\u043a\u0430\u0447\u0438\u043d\u0441\u043a\u0438" },
            { "kaj", "\u043a\u0430\u045f\u0435" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "kaw", "\u043a\u0430\u0432\u0438" },
            { "kbd", "\u043a\u0430\u0431\u0430\u0440\u0434\u0438\u043d\u0441\u043a\u0438" },
            { "kbl", "\u043a\u0430\u043d\u0435\u043c\u0431\u0443" },
            { "kcg", "\u0442\u0458\u0430\u043f" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u0435" },
            { "kea", "\u043a\u0430\u0431\u0443\u0432\u0435\u0440\u0434\u0438\u0430\u043d\u0443" },
            { "ken", "\u043a\u0435\u045a\u0430\u043d\u0433" },
            { "kfo", "\u043a\u043e\u0440\u043e" },
            { "kgp", "\u043a\u0430\u0438\u043d\u0433\u0430\u043d\u0448\u043a\u0438" },
            { "kha", "\u043a\u0430\u0441\u0438" },
            { "kho", "\u0445\u043e\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "khq", "\u043a\u043e\u0458\u0440\u0430 \u0447\u0438\u0438\u043d\u0438" },
            { "khw", "\u043a\u043e\u0432\u0430\u0440\u0441\u043a\u0438" },
            { "kiu", "\u0437\u0430\u0437\u0430\u043a\u0438" },
            { "kkj", "\u043a\u0430\u043a\u043e" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u045f\u0438\u043d" },
            { "kmb", "\u043a\u0438\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "koi", "\u043a\u043e\u043c\u0438-\u043f\u0435\u0440\u043c\u0458\u0430\u0447\u043a\u0438" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "kos", "\u043a\u043e\u0437\u0440\u0435\u0458\u0441\u043a\u0438" },
            { "kpe", "\u043a\u043f\u0435\u043b\u0435" },
            { "krc", "\u043a\u0430\u0440\u0430\u0447\u0430\u0435\u0432\u0441\u043a\u043e-\u0431\u0430\u043b\u043a\u0430\u0440\u0441\u043a\u0438" },
            { "kri", "\u043a\u0440\u0438\u043e" },
            { "krj", "\u043a\u0438\u043d\u0430\u0440\u0430\u0458\u0441\u043a\u0438" },
            { "krl", "\u043a\u0430\u0440\u0435\u043b\u0441\u043a\u0438" },
            { "kru", "\u043a\u0443\u0440\u0443\u0445" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b\u0430" },
            { "ksf", "\u0431\u0430\u0444\u0438\u0458\u0430" },
            { "ksh", "\u043a\u043e\u043b\u043e\u045a\u0441\u043a\u0438" },
            { "kum", "\u043a\u0443\u043c\u0438\u0447\u043a\u0438" },
            { "kut", "\u043a\u0443\u0442\u0435\u043d\u0430\u0458\u0441\u043a\u0438" },
            { "kwk", "\u043a\u0432\u0430\u043a\u0432\u0430\u043b\u0430" },
            { "lad", "\u043b\u0430\u0434\u0438\u043d\u043e" },
            { "lag", "\u043b\u0430\u043d\u0433\u0438" },
            { "lah", "\u043b\u0430\u043d\u0434\u0430" },
            { "lam", "\u043b\u0430\u043c\u0431\u0430" },
            { "lez", "\u043b\u0435\u0437\u0433\u0438\u043d\u0441\u043a\u0438" },
            { "lfn", "\u043b\u0438\u043d\u0433\u0432\u0430 \u0444\u0440\u0430\u043d\u043a\u0430 \u043d\u043e\u0432\u0430" },
            { "lij", "\u043b\u0438\u0433\u0443\u0440\u0441\u043a\u0438" },
            { "lil", "\u043b\u0438\u043b\u0443\u0435\u0442\u0441\u043a\u0438" },
            { "liv", "\u043b\u0438\u0432\u043e\u043d\u0441\u043a\u0438" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0441\u043a\u0438" },
            { "lmo", "\u043b\u043e\u043c\u0431\u0430\u0440\u0434\u0438\u0441\u043a\u0438" },
            { "lol", "\u043c\u043e\u043d\u0433\u043e" },
            { "lou", "\u043b\u0443\u0438\u0437\u0438\u0458\u0430\u043d\u0441\u043a\u0438 \u043a\u0440\u0435\u043e\u043b\u0441\u043a\u0438" },
            { "loz", "\u043b\u043e\u0437\u0438" },
            { "lrc", "\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u043b\u0443\u0440\u0438\u0441\u043a\u0438" },
            { "lsm", "\u0441\u0430\u043c\u0438\u0441\u043a\u0438" },
            { "ltg", "\u043b\u0430\u0442\u0433\u0430\u043b\u0441\u043a\u0438" },
            { "lua", "\u043b\u0443\u0431\u0430-\u043b\u0443\u043b\u0443\u0430" },
            { "lui", "\u043b\u0443\u0458\u0441\u0435\u045a\u0441\u043a\u0438" },
            { "lun", "\u043b\u0443\u043d\u0434\u0430" },
            { "luo", "\u043b\u0443\u043e" },
            { "lus", "\u043c\u0438\u0437\u043e" },
            { "luy", "\u043b\u0443\u0458\u0430" },
            { "lzh", "\u043a\u043d\u0438\u0436\u0435\u0432\u0435\u043d \u043a\u0438\u043d\u0435\u0441\u043a\u0438" },
            { "lzz", "\u043b\u0430\u0441\u043a\u0438" },
            { "mad", "\u043c\u0430\u0434\u0443\u0440\u0441\u043a\u0438" },
            { "maf", "\u043c\u0430\u0444\u0430" },
            { "mag", "\u043c\u0430\u0433\u0430\u0445\u0438" },
            { "mai", "\u043c\u0430\u0438\u0442\u0438\u043b\u0438" },
            { "mak", "\u043c\u0430\u043a\u0430\u0441\u0430\u0440\u0441\u043a\u0438" },
            { "man", "\u043c\u0430\u043d\u0434\u0438\u043d\u0433\u043e" },
            { "mas", "\u043c\u0430\u0441\u0430\u0458\u0441\u043a\u0438" },
            { "mde", "\u043c\u0430\u0431\u0430" },
            { "mdf", "\u043c\u043e\u043a\u0448\u0430\u043d\u0441\u043a\u0438" },
            { "mdr", "\u043c\u0430\u043d\u0434\u0430\u0440\u0441\u043a\u0438" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "mfe", "\u043c\u043e\u0440\u0438\u0441\u0458\u0435\u043d" },
            { "mga", "\u0441\u0440\u0435\u0434\u043d\u043e\u0438\u0440\u0441\u043a\u0438" },
            { "mgh", "\u043c\u0430\u043a\u0443\u0432\u0430-\u043c\u0438\u0442\u043e" },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "mic", "\u043c\u0438\u043a\u043c\u0430\u043a" },
            { "min", "\u043c\u0438\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u0443" },
            { "mnc", "\u043c\u0430\u043d\u045f\u0443\u0440\u0441\u043a\u0438" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0441\u043a\u0438" },
            { "moe", "\u0438\u043d\u0443-\u0430\u0438\u043c\u0443\u043d\u0441\u043a\u0438" },
            { "moh", "\u043c\u043e\u0445\u0430\u0432\u0441\u043a\u0438" },
            { "mos", "\u043c\u043e\u0441\u0438" },
            { "mrj", "\u0437\u0430\u043f\u0430\u0434\u043d\u043e\u043c\u0430\u0440\u0438\u0441\u043a\u0438" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "mul", "\u043f\u043e\u0432\u0435\u045c\u0435 \u0458\u0430\u0437\u0438\u0446\u0438" },
            { "mus", "\u043a\u0440\u0438\u043a" },
            { "mwl", "\u043c\u0438\u0440\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "mwr", "\u043c\u0430\u0440\u0432\u0430\u0440\u0438" },
            { "mye", "\u043c\u0458\u0435\u043d\u0435" },
            { "myv", "\u0435\u0440\u0437\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "mzn", "\u043c\u0430\u0437\u0435\u043d\u0434\u0435\u0440\u0430\u043d\u0441\u043a\u0438" },
            { "nan", "\u0458\u0443\u0436\u043d\u043e\u043c\u0438\u043d\u0441\u043a\u0438" },
            { "nap", "\u043d\u0435\u0430\u043f\u043e\u043b\u0441\u043a\u0438" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "nds", "\u0434\u043e\u043b\u043d\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "new", "\u043d\u0435\u0432\u0430\u0440\u0441\u043a\u0438" },
            { "nia", "\u043d\u0438\u0458\u0430\u0441" },
            { "niu", "\u043d\u0438\u0443\u0458\u0435\u0441\u043a\u0438" },
            { "njo", "\u0430\u043e \u043d\u0430\u0433\u0430" },
            { "nmg", "\u043a\u0432\u0430\u0437\u0438\u043e" },
            { "nnh", "\u043d\u0433\u0438\u0435\u043c\u0431\u0443\u043d" },
            { "nog", "\u043d\u043e\u0433\u0430\u0458\u0441\u043a\u0438" },
            { "non", "\u0441\u0442\u0430\u0440\u043e\u043d\u043e\u0440\u0434\u0438\u0441\u043a\u0438" },
            { "nov", "\u043d\u043e\u0432\u0438\u0458\u0430\u043b" },
            { "nqo", metaValue_nqo },
            { "nso", "\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u0441\u043e\u0442\u0441\u043a\u0438" },
            { "nus", "\u043d\u0443\u0435\u0440" },
            { "nwc", "\u043a\u043b\u0430\u0441\u0438\u0447\u0435\u043d \u043d\u0435\u0432\u0430\u0440\u0441\u043a\u0438" },
            { "nym", "\u045a\u0430\u043c\u0432\u0435\u0437\u0438" },
            { "nyn", "\u045a\u0430\u043d\u043a\u043e\u043b\u0435" },
            { "nyo", "\u045a\u043e\u0440\u043e" },
            { "nzi", "\u043d\u0437\u0438\u043c\u0430" },
            { "ojb", "\u0441\u0435\u0432\u0435\u0440\u043e\u0437\u0430\u043f\u0430\u0434\u0435\u043d \u043e\u045f\u0438\u0431\u0432\u0430" },
            { "ojc", "\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u0435\u043d \u043e\u045f\u0438\u0431\u0432\u0430" },
            { "ojs", "\u043e\u0447\u0438\u0441\u043a\u0438 \u043a\u0440\u0438\u0458\u0441\u043a\u0438" },
            { "ojw", "\u0437\u0430\u043f\u0430\u0434\u0435\u043d \u043e\u045f\u0438\u0431\u0432\u0430" },
            { "oka", "\u043e\u043a\u0430\u043d\u0430\u0433\u0430\u043d\u0441\u043a\u0438" },
            { "osa", "\u043e\u0441\u0430\u0448\u043a\u0438" },
            { "ota", "\u043e\u0442\u043e\u043c\u0430\u043d\u0441\u043a\u0438 \u0442\u0443\u0440\u0441\u043a\u0438" },
            { "pag", "\u043f\u0430\u043d\u0433\u0430\u0441\u0438\u043d\u0430\u043d\u0441\u043a\u0438" },
            { "pal", "\u0441\u0440\u0435\u0434\u043d\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u0438" },
            { "pam", "\u043f\u0430\u043c\u043f\u0430\u043d\u0433\u0430" },
            { "pap", "\u043f\u0430\u043f\u0438\u0458\u0430\u043c\u0435\u043d\u0442\u043e" },
            { "pau", "\u043f\u0430\u043b\u0430\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "pcd", "\u043f\u0438\u043a\u0430\u0440\u0434\u0441\u043a\u0438" },
            { "pcm", "\u043d\u0438\u0433\u0435\u0440\u0438\u0441\u043a\u0438 \u043f\u0438\u045f\u0438\u043d" },
            { "pdc", "\u043f\u0435\u043d\u0441\u0438\u043b\u0432\u0430\u043d\u0438\u0441\u043a\u0438 \u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "pdt", "\u043c\u0435\u043d\u043e\u043d\u0438\u0442\u0441\u043a\u0438 \u0434\u043e\u043b\u043d\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "peo", "\u0441\u0442\u0430\u0440\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u0438" },
            { "pfl", "\u0444\u0430\u043b\u0435\u0447\u043a\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "phn", "\u0444\u0435\u043d\u0438\u043a\u0438\u0441\u043a\u0438" },
            { "pis", "\u043f\u0438\u045f\u0438\u043d" },
            { "pms", "\u043f\u0438\u0435\u043c\u043e\u043d\u0442\u0441\u043a\u0438" },
            { "pnt", "\u043f\u043e\u043d\u0442\u0441\u043a\u0438" },
            { "pon", "\u043f\u043e\u043d\u043f\u0435\u0458\u0441\u043a\u0438" },
            { "pqm", "\u043c\u0430\u043b\u0438\u0441\u0438\u0442\u0441\u043a\u0438 \u043f\u0430\u0441\u0430\u043c\u0430\u043a\u0432\u043e\u0434\u0441\u043a\u0438" },
            { "prg", "\u043f\u0440\u0443\u0441\u043a\u0438" },
            { "pro", "\u0441\u0442\u0430\u0440\u043e\u043f\u0440\u043e\u0432\u0430\u043d\u0441\u0430\u043b\u0441\u043a\u0438" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "qug", "\u043a\u0438\u0447\u0432\u0430\u043d\u0441\u043a\u0438" },
            { "raj", "\u0440\u0430\u045f\u0430\u0441\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "rap", "\u0440\u0430\u043f\u0430\u043d\u0443\u0458\u0441\u043a\u0438" },
            { "rar", "\u0440\u0430\u0440\u043e\u0442\u043e\u043d\u0433\u0430\u043d\u0441\u043a\u0438" },
            { "rgn", "\u0440\u043e\u043c\u0430\u045a\u043e\u043b\u0441\u043a\u0438" },
            { "rhg", "\u0440\u043e\u0445\u0438\u043d\u0448\u043a\u0438" },
            { "rif", "\u0440\u0438\u0444\u0441\u043a\u0438" },
            { "rof", "\u0440\u043e\u043c\u0431\u043e" },
            { "rom", "\u0440\u043e\u043c\u0441\u043a\u0438" },
            { "rtm", "\u0440\u043e\u0442\u0443\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "rue", "\u0440\u0443\u0441\u0438\u043d\u0441\u043a\u0438" },
            { "rug", "\u0440\u043e\u0432\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "rup", "\u0432\u043b\u0430\u0448\u043a\u0438" },
            { "rwk", "\u0440\u0443\u0430" },
            { "sad", "\u0441\u0430\u043d\u0434\u0430\u0432\u0435" },
            { "sah", "\u0458\u0430\u043a\u0443\u0442\u0441\u043a\u0438" },
            { "sam", "\u0441\u0430\u043c\u0430\u0440\u0458\u0430\u043d\u0441\u043a\u0438 \u0430\u0440\u0430\u043c\u0435\u0458\u0441\u043a\u0438" },
            { "saq", "\u0441\u0430\u043c\u0431\u0443\u0440\u0443" },
            { "sas", "\u0441\u0430\u0441\u0430\u0447\u043a\u0438" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u0438" },
            { "saz", "\u0441\u0430\u0443\u0440\u0430\u0448\u0442\u0440\u0430" },
            { "sba", "\u043d\u0433\u0435\u043c\u0431\u0435\u0458" },
            { "sbp", "\u0441\u0430\u043d\u0433\u0443" },
            { "scn", "\u0441\u0438\u0446\u0438\u043b\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "sco", "\u0448\u043a\u043e\u0442\u0441\u043a\u0438 \u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "sdc", "\u0441\u0430\u0441\u0430\u0440\u0441\u043a\u0438 \u0441\u0430\u0440\u0434\u0438\u043d\u0441\u043a\u0438" },
            { "sdh", "\u0458\u0443\u0436\u043d\u043e\u043a\u0443\u0440\u0434\u0441\u043a\u0438" },
            { "see", "\u0441\u0435\u043d\u0435\u043a\u0430" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "sei", "\u0441\u0435\u0440\u0438" },
            { "sel", "\u0441\u0435\u043b\u043a\u0443\u043f\u0441\u043a\u0438" },
            { "ses", "\u043a\u043e\u0458\u0440\u0430\u0431\u043e\u0440\u043e \u0441\u0435\u043d\u0438" },
            { "sga", "\u0441\u0442\u0430\u0440\u043e\u0438\u0440\u0441\u043a\u0438" },
            { "sgs", "\u0441\u0430\u043c\u043e\u0433\u0438\u0442\u0441\u043a\u0438" },
            { "shi", "\u0442\u0430\u0447\u0435\u043b\u0445\u0438\u0442" },
            { "shn", "\u0448\u0430\u043d" },
            { "shu", "\u0447\u0430\u0434\u0441\u043a\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "sid", "\u0441\u0438\u0434\u0430\u043c\u043e" },
            { "slh", "\u0458\u0443\u0436\u0435\u043d \u043b\u0443\u0448\u0443\u0446\u0438\u0434" },
            { "sli", "\u0434\u043e\u043b\u043d\u043e\u0448\u043b\u0435\u0437\u0438\u0441\u043a\u0438" },
            { "sly", "\u0441\u0435\u043b\u0430\u0458\u0430\u0440\u0441\u043a\u0438" },
            { "sma", "\u0458\u0443\u0436\u0435\u043d \u0441\u0430\u043c\u0438" },
            { "smj", "\u043b\u0443\u043b\u0435 \u0441\u0430\u043c\u0438" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438\u0441\u043a\u0438 \u0441\u0430\u043c\u0438" },
            { "sms", "\u0441\u043a\u043e\u043b\u0442 \u0441\u0430\u043c\u0438" },
            { "snk", "\u0441\u043e\u043d\u0438\u043d\u043a\u0435" },
            { "sog", "\u0437\u043e\u0433\u0434\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "srn", "\u0441\u0440\u0430\u043d\u0441\u043a\u0438 \u0442\u043e\u043d\u0433\u043e" },
            { "srr", "\u0441\u0435\u0440\u0435\u0440" },
            { "ssy", "\u0441\u0430\u0445\u043e" },
            { "stq", "\u0437\u0430\u0442\u0435\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u0444\u0440\u0438\u0437\u0438\u0441\u043a\u0438" },
            { "str", "\u0441\u0430\u043b\u0438\u0448\u043a\u0438 (\u0421\u0435\u0432\u0435\u0440\u0435\u043d \u0422\u0435\u0441\u043d\u0435\u0446)" },
            { "suk", "\u0441\u0443\u043a\u0443\u043c\u0430" },
            { "sus", "\u0441\u0443\u0441\u0443" },
            { "sux", "\u0441\u0443\u043c\u0435\u0440\u0441\u043a\u0438" },
            { "swb", "\u043a\u043e\u043c\u043e\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "syc", "\u043a\u043b\u0430\u0441\u0438\u0447\u0435\u043d \u0441\u0438\u0440\u0438\u0441\u043a\u0438" },
            { "syr", "\u0441\u0438\u0440\u0438\u0441\u043a\u0438" },
            { "szl", "\u0448\u043b\u0435\u0437\u0438\u0441\u043a\u0438" },
            { "tce", "\u0458\u0443\u0436\u043d\u043e\u0442\u0443\u0447\u043e\u043d\u0441\u043a\u0438" },
            { "tcy", "\u0442\u0443\u043b\u0443" },
            { "tem", "\u0442\u0438\u043c\u043d\u0435" },
            { "teo", "\u0442\u0435\u0441\u043e" },
            { "ter", "\u0442\u0435\u0440\u0435\u043d\u043e" },
            { "tet", "\u0442\u0435\u0442\u0443\u043c" },
            { "tgx", "\u0442\u0430\u0433\u0438\u0448\u043a\u0438" },
            { "tht", "\u0442\u0430\u043b\u0442\u0430\u043d\u0441\u043a\u0438" },
            { "tig", "\u0442\u0438\u0433\u0440\u0435" },
            { "tiv", "\u0442\u0438\u0432" },
            { "tkl", "\u0442\u043e\u043a\u0435\u043b\u0430\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "tkr", "\u0446\u0430\u0445\u0443\u0440\u0441\u043a\u0438" },
            { "tlh", "\u043a\u043b\u0438\u043d\u0433\u043e\u043d\u0441\u043a\u0438" },
            { "tli", "\u0442\u043b\u0438\u043d\u0433\u0438\u0442" },
            { "tly", "\u0442\u0430\u043b\u0438\u0448\u043a\u0438" },
            { "tmh", "\u0442\u0430\u043c\u0430\u0448\u0435\u043a" },
            { "tog", "\u045a\u0430\u0441\u0430 \u0442\u043e\u043d\u0433\u0430" },
            { "tok", "\u0442\u043e\u043a\u0438 \u043f\u043e\u043d\u0430" },
            { "tpi", "\u0442\u043e\u043a \u043f\u0438\u0441\u0438\u043d" },
            { "tru", "\u0442\u0443\u0440\u043e\u0458\u043e" },
            { "trv", "\u0442\u0430\u0440\u043e\u043a\u043e" },
            { "tsd", "\u0446\u0430\u043a\u043e\u043d\u0441\u043a\u0438" },
            { "tsi", "\u0446\u0438\u043c\u0448\u0438\u0458\u0430\u043d\u0441\u043a\u0438" },
            { "ttm", "\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u0442\u0443\u0447\u043e\u043d\u0441\u043a\u0438" },
            { "ttt", "\u0442\u0430\u0442\u0441\u043a\u0438" },
            { "tum", "\u0442\u0443\u043c\u0431\u0443\u043a\u0430" },
            { "tvl", "\u0442\u0443\u0432\u0430\u043b\u0443\u0430\u043d\u0441\u043a\u0438" },
            { "twq", "\u0442\u0430\u0437\u0430\u0432\u0430\u043a" },
            { "tyv", "\u0442\u0443\u0432\u0430\u043d\u0441\u043a\u0438" },
            { "tzm", "\u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0430\u0442\u043b\u0430\u043d\u0441\u043a\u0438 \u0442\u0430\u043c\u0430\u0437\u0438\u0442\u0441\u043a\u0438" },
            { "udm", "\u0443\u0434\u043c\u0443\u0440\u0442\u0441\u043a\u0438" },
            { "uga", "\u0443\u0433\u0430\u0440\u0438\u0442\u0441\u043a\u0438" },
            { "umb", "\u0443\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "und", "\u043d\u0435\u043f\u043e\u0437\u043d\u0430\u0442 \u0458\u0430\u0437\u0438\u043a" },
            { "vai", metaValue_vai },
            { "vec", "\u0432\u0435\u043d\u0435\u0442\u0441\u043a\u0438" },
            { "vep", "\u0432\u0435\u043f\u0448\u043a\u0438" },
            { "vls", "\u0437\u0430\u043f\u0430\u0434\u043d\u043e\u0444\u043b\u0430\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "vmf", "\u043c\u0430\u0458\u043d\u0441\u043a\u043e\u0444\u0440\u0430\u043d\u043a\u043e\u043d\u0441\u043a\u0438" },
            { "vot", "\u0432\u043e\u0442\u0441\u043a\u0438" },
            { "vro", "\u0432\u0438\u0440\u0443" },
            { "vun", "\u0432\u0443\u043d\u045f\u043e" },
            { "wae", "\u0432\u0430\u043b\u0441\u0435\u0440" },
            { "wal", "\u0432\u043e\u043b\u0430\u043c\u043e" },
            { "war", "\u0432\u0430\u0440\u0430\u0458\u0441\u043a\u0438" },
            { "was", "\u0432\u0430\u0448\u043e" },
            { "wbp", "\u0432\u0430\u0440\u043b\u043f\u0438\u0440\u0438" },
            { "wuu", "\u0432\u0443" },
            { "xal", "\u043a\u0430\u043b\u043c\u0438\u0447\u043a\u0438" },
            { "xmf", "\u043c\u0435\u0433\u0440\u0435\u043b\u0441\u043a\u0438" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "yao", "\u0458\u0430\u043e" },
            { "yap", "\u0458\u0430\u043f\u0441\u043a\u0438" },
            { "yav", "\u0458\u0435\u043d\u0433\u0431\u0435\u043d" },
            { "ybb", "\u0458\u0435\u043c\u0431\u0430" },
            { "yrl", "\u045a\u0435\u043d\u0433\u0430\u0442\u0443" },
            { "yue", "\u043a\u0430\u043d\u0442\u043e\u043d\u0441\u043a\u0438" },
            { "zap", "\u0437\u0430\u043f\u043e\u0442\u0435\u0447\u043a\u0438" },
            { "zbl", metaValue_zbl },
            { "zea", "\u0437\u0435\u043b\u0430\u043d\u0434\u0441\u043a\u0438" },
            { "zen", "\u0437\u0435\u043d\u0430\u0433\u0430" },
            { "zgh", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u0435\u043d \u043c\u0430\u0440\u043e\u043a\u0430\u043d\u0441\u043a\u0438 \u0442\u0430\u043c\u0430\u0437\u0438\u0442\u0441\u043a\u0438" },
            { "zun", "\u0437\u0443\u043d\u0438" },
            { "zxx", "\u0431\u0435\u0437 \u043b\u0438\u043d\u0433\u0432\u0438\u0441\u0442\u0438\u0447\u043a\u0430 \u0441\u043e\u0434\u0440\u0436\u0438\u043d\u0430" },
            { "zza", "\u0437\u0430\u0437\u0430" },
            { "Adlm", "\u0430\u0434\u043b\u0430\u043c\u0441\u043a\u043e" },
            { "Afak", "\u0430\u0444\u0430\u043a\u0430" },
            { "Aghb", "\u043a\u0430\u0432\u043a\u0430\u0441\u043a\u043e\u0430\u043b\u0431\u0430\u043d\u0441\u043a\u0438" },
            { "Arab", "\u0430\u0440\u0430\u043f\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Aran", "\u043d\u0430\u0441\u0442\u0430\u043b\u0438\u043a" },
            { "Armi", "\u0446\u0430\u0440\u0441\u043a\u043e\u0430\u0440\u0430\u043c\u0435\u0458\u0441\u043a\u0438" },
            { "Armn", "\u0435\u0440\u043c\u0435\u043d\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Avst", "\u0430\u0432\u0435\u0441\u0442\u0430\u043d\u0441\u043a\u043e" },
            { "Bali", "\u0431\u0430\u043b\u0438\u0441\u043a\u043e" },
            { "Bamu", "\u0431\u0430\u043c\u0443\u043c\u0441\u043a\u043e" },
            { "Bass", metaValue_bas },
            { "Batk", "\u0431\u0430\u0442\u0430\u0447\u043a\u043e" },
            { "Beng", "\u0431\u0435\u043d\u0433\u0430\u043b\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Blis", metaValue_zbl },
            { "Bopo", "\u0431\u043e\u043f\u043e\u043c\u043e\u0444\u043e" },
            { "Brah", "\u0431\u0440\u0430\u043c\u0438" },
            { "Brai", "\u0431\u0440\u0430\u0458\u043e\u0432\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Bugi", "\u0431\u0443\u0433\u0438\u0441\u043a\u043e" },
            { "Buhd", "\u0431\u0443\u0445\u0438\u0434\u0441\u043a\u043e" },
            { "Cakm", "\u0447\u0430\u043a\u043c\u0430\u043d\u0441\u043a\u043e" },
            { "Cans", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u043e \u0441\u043b\u043e\u0433\u043e\u0432\u043d\u043e" },
            { "Cari", "\u043a\u0430\u0440\u0438\u0441\u043a\u043e" },
            { "Cham", "\u0447\u0430\u043c\u0441\u043a\u043e" },
            { "Cher", "\u0447\u0435\u0440\u043e\u043a\u0438\u0441\u043a\u043e" },
            { "Cirt", "\u043a\u0438\u0440\u0442" },
            { "Copt", "\u043a\u043e\u043f\u0442\u0441\u043a\u043e" },
            { "Cprt", "\u043a\u0438\u043f\u0430\u0440\u0441\u043a\u043e" },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Cyrs", "\u0441\u0442\u0430\u0440\u043e\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u0430 \u043a\u0438\u0440\u0438\u043b\u0438\u0446\u0430" },
            { "Deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438" },
            { "Dsrt", "\u0434\u0435\u0437\u0435\u0440\u0435\u0442\u0441\u043a\u043e" },
            { "Dupl", "\u0414\u0438\u043f\u043b\u043e\u0458\u0435\u0435\u0432\u043e \u0441\u0442\u0435\u043d\u043e\u0433\u0440\u0430\u0444\u0441\u043a\u043e" },
            { "Egyd", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u043e \u0434\u0435\u043c\u043e\u0442\u0441\u043a\u043e" },
            { "Egyh", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u043e \u0445\u0438\u0435\u0440\u0430\u0442\u0441\u043a\u043e" },
            { "Egyp", "\u0435\u0433\u0438\u043f\u0435\u0442\u0441\u043a\u0438 \u0445\u0438\u0435\u0440\u043e\u0433\u043b\u0438\u0444\u0438" },
            { "Elba", "\u0435\u043b\u0431\u0430\u0441\u0430\u043d\u0441\u043a\u043e" },
            { "Ethi", "\u0435\u0442\u0438\u043e\u043f\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Geok", "\u0433\u0440\u0443\u0437\u0438\u0441\u043a\u0438 \u0445\u0443\u0446\u0443\u0440\u0438" },
            { "Geor", "\u0433\u0440\u0443\u0437\u0438\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Glag", "\u0433\u043b\u0430\u0433\u043e\u043b\u0438\u0446\u0430" },
            { "Goth", "\u0433\u043e\u0442\u0441\u043a\u043e" },
            { "Gran", "\u0433\u0440\u0430\u043d\u0442\u0430" },
            { "Grek", "\u0433\u0440\u0447\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0433\u0443\u0440\u043c\u0443\u043a\u0438" },
            { "Hanb", "\u0445\u0430\u043d\u0431" },
            { "Hang", "\u0445\u0430\u043d\u0433\u0443\u043b" },
            { "Hani", "\u0445\u0430\u043d\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Hano", "\u0445\u0430\u043d\u0443\u043d\u043e\u043e\u0432\u0441\u043a\u043e" },
            { "Hans", "\u043f\u043e\u0435\u0434\u043d\u043e\u0441\u0442\u0430\u0432\u0435\u043d\u043e" },
            { "Hant", "\u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e" },
            { "Hebr", "\u0445\u0435\u0431\u0440\u0435\u0458\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Hira", "\u0445\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "Hluw", "\u0430\u043d\u0430\u0434\u043e\u043b\u0441\u043a\u0438 \u0445\u0438\u0435\u0440\u043e\u0433\u043b\u0438\u0444\u0438" },
            { "Hmng", "\u043f\u0430\u0445\u0430\u0443\u0430\u043d\u0441\u043a\u043e \u0445\u043c\u043e\u043d\u0448\u043a\u043e" },
            { "Hrkt", "\u0458\u0430\u043f\u043e\u043d\u0441\u043a\u043e \u0441\u043b\u043e\u0433\u043e\u0432\u043d\u043e" },
            { "Hung", "\u0441\u0442\u0430\u0440\u043e\u0443\u043d\u0433\u0430\u0440\u0441\u043a\u043e" },
            { "Inds", "\u0445\u0430\u0440\u0430\u043f\u0441\u043a\u043e" },
            { "Ital", "\u0441\u0442\u0430\u0440\u043e\u0438\u0442\u0430\u043b\u0441\u043a\u043e" },
            { "Jamo", "\u045f\u0430\u043c\u043e" },
            { "Java", "\u0458\u0430\u0432\u0430\u043d\u0441\u043a\u043e" },
            { "Jpan", "\u0458\u0430\u043f\u043e\u043d\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Jurc", "\u045f\u0443\u0440\u0447\u0435\u043d\u0441\u043a\u043e" },
            { "Kali", "\u043a\u0430\u0458\u0430 \u043b\u0438" },
            { "Kana", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "Khar", "\u043a\u0430\u0440\u043e\u0448\u0442\u0438" },
            { "Khmr", "\u043a\u043c\u0435\u0440\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Khoj", "\u0445\u043e\u045f\u043a\u0438" },
            { "Knda", metaValue_kn },
            { "Kore", "\u043a\u043e\u0440\u0435\u0458\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Kpel", "\u043a\u043f\u0435\u043b\u0441\u043a\u043e" },
            { "Kthi", "\u043a\u0430\u0458\u0442\u0438" },
            { "Lana", "\u043b\u0430\u043d\u0441\u043a\u043e" },
            { "Laoo", "\u043b\u0430\u043e\u0448\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Latf", "\u0444\u0440\u0430\u043a\u0442\u0443\u0440\u043d\u0430 \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0430" },
            { "Latg", "\u0433\u0435\u043b\u0441\u043a\u0430 \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0430" },
            { "Latn", "\u043b\u0430\u0442\u0438\u043d\u0438\u0447\u043d\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Lepc", "\u043b\u0435\u043f\u0447\u0430\u043d\u0441\u043a\u043e" },
            { "Limb", "\u043b\u0438\u043c\u0431\u0443" },
            { "Lina", "\u043b\u0438\u043d\u0435\u0430\u0440\u043d\u043e \u0410" },
            { "Linb", "\u043b\u0438\u043d\u0435\u0430\u0440\u043d\u043e \u0411" },
            { "Lisu", "\u0424\u0440\u0435\u0458\u0437\u0435\u0440\u043e\u0432\u043e" },
            { "Loma", "\u043b\u043e\u043c\u0441\u043a\u043e" },
            { "Lyci", "\u043b\u0438\u043a\u0438\u0441\u043a\u043e" },
            { "Lydi", "\u043b\u0438\u0434\u0438\u0441\u043a\u043e" },
            { "Mahj", "\u043c\u0430\u0445\u0430\u045f\u0430\u043d\u0438" },
            { "Mand", "\u043c\u0430\u043d\u0434\u0435\u0458\u0441\u043a\u043e" },
            { "Mani", "\u043c\u0430\u043d\u0438\u0445\u0435\u0458\u0441\u043a\u043e" },
            { "Maya", "\u043c\u0430\u0458\u0430\u043d\u0441\u043a\u0438 \u0445\u0438\u0435\u0440\u043e\u0433\u043b\u0438\u0444\u0438" },
            { "Mend", "\u043c\u0435\u043d\u0434\u0441\u043a\u043e" },
            { "Merc", "\u043c\u0435\u0440\u043e\u0438\u0442\u0441\u043a\u043e \u0440\u0430\u043a\u043e\u043f\u0438\u0441\u043d\u043e" },
            { "Mero", "\u043c\u0435\u0440\u043e\u0438\u0442\u0441\u043a\u043e" },
            { "Mlym", "\u043c\u0430\u043b\u0430\u0458\u0430\u043b\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Modi", "\u043c\u043e\u0434\u0438" },
            { "Mong", "\u043c\u043e\u043d\u0433\u043e\u043b\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Moon", "\u041c\u0443\u043d\u043e\u0432\u043e" },
            { "Mroo", "\u043c\u0440\u043e" },
            { "Mtei", "\u043c\u0435\u0458\u0442\u0435\u0458\u0441\u043a\u043e" },
            { "Mymr", "\u043c\u0458\u0430\u043d\u043c\u0430\u0440\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Narb", "\u0441\u0442\u0430\u0440\u043e\u0441\u0435\u0432\u0435\u0440\u043d\u043e\u0430\u0440\u0430\u043f\u0441\u043a\u043e" },
            { "Nbat", "\u043d\u0430\u0431\u0430\u0442\u0435\u0458\u0441\u043a\u043e" },
            { "Nkgb", "\u043d\u0430\u0441\u0438\u0441\u043a\u0430 \u0433\u0435\u0431\u0430" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "\u043d\u0438\u0448\u0443" },
            { "Ogam", "\u043e\u0433\u0430\u043c" },
            { "Olck", "\u043e\u043b \u0447\u0438\u043a\u0438" },
            { "Orkh", "\u0441\u0442\u0430\u0440\u043e\u0442\u0443\u0440\u0441\u043a\u043e" },
            { "Orya", "\u043e\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Osma", "\u0441\u043e\u043c\u0430\u043b\u0438\u0441\u043a\u043e" },
            { "Palm", "\u043f\u0430\u043b\u043c\u0438\u0440\u0441\u043a\u043e" },
            { "Pauc", "\u041f\u0430\u0443\u0447\u0438\u043d\u0445\u0430\u0443\u043e\u0432\u043e" },
            { "Perm", "\u0441\u0442\u0430\u0440\u043e\u043f\u0435\u0440\u043c\u0441\u043a\u043e" },
            { "Phag", "\u043f\u0430\u0433\u0441\u043f\u0430" },
            { "Phli", "\u043d\u0430\u0442\u043f\u0438\u0441\u043d\u043e \u0441\u0440\u0435\u0434\u043d\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u043e" },
            { "Phlp", "\u043f\u0441\u0430\u043b\u0442\u0438\u0440\u0441\u043a\u043e \u0441\u0440\u0435\u0434\u043d\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u043e" },
            { "Phlv", "\u043a\u043d\u0438\u0436\u0435\u0432\u043d\u043e \u0441\u0442\u0430\u0440\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u043e" },
            { "Phnx", "\u0444\u0435\u043d\u0438\u043a\u0438\u0441\u043a\u043e" },
            { "Plrd", "\u041f\u043e\u043b\u0430\u0440\u0434\u043e\u0432\u043e" },
            { "Prti", "\u043d\u0430\u0442\u043f\u0438\u0441\u043d\u043e \u043f\u0430\u0440\u0442\u0438\u0441\u043a\u043e" },
            { "Rjng", "\u0440\u0435\u045f\u0430\u043d\u0448\u043a\u043e" },
            { "Rohg", "\u0445\u0430\u043d\u0438\u0444\u0438" },
            { "Roro", "\u0440\u043e\u043d\u0433\u043e\u0440\u043e\u043d\u0433\u043e" },
            { "Runr", "\u0440\u0443\u043d\u0441\u043a\u043e" },
            { "Samr", "\u0441\u0430\u043c\u0430\u0440\u0458\u0430\u043d\u0441\u043a\u043e" },
            { "Sara", "\u0441\u0430\u0440\u0430\u0442\u0438" },
            { "Sarb", "\u0441\u0442\u0430\u0440\u043e\u0458\u0443\u0436\u043d\u043e\u0430\u0440\u0430\u043f\u0441\u043a\u043e" },
            { "Saur", "\u0441\u0430\u0443\u0440\u0430\u0448\u0442\u0440\u0430\u043d\u0441\u043a\u043e" },
            { "Sgnw", "\u0437\u043d\u0430\u043a\u043e\u0432\u043d\u043e \u043f\u0438\u0448\u0443\u0432\u0430\u045a\u0435" },
            { "Shaw", "\u0428\u043e\u043e\u0432\u043e" },
            { "Shrd", "\u0448\u0430\u0440\u0430\u0434\u0430" },
            { "Sidd", "\u0441\u0438\u0434\u0430\u043c" },
            { "Sind", "\u043a\u0443\u0434\u0430\u0431\u0430\u0434\u0438" },
            { "Sinh", "\u0441\u0438\u043d\u0445\u0430\u043b\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Sora", "\u0441\u043e\u0440\u0430\u043d\u0433 \u0441\u043e\u043c\u043f\u0435\u043d\u0433" },
            { "Sund", "\u0441\u0443\u043d\u0434\u0430\u043d\u0441\u043a\u043e" },
            { "Sylo", "\u0441\u0438\u043b\u0445\u0435\u0442\u0441\u043a\u043e \u043d\u0430\u0433\u0430\u0440\u0438" },
            { "Syrc", "\u0441\u0438\u0440\u0438\u0441\u043a\u043e" },
            { "Syre", "\u0435\u0441\u0442\u0440\u0430\u043d\u0433\u0435\u043b\u0441\u043a\u043e \u0441\u0438\u0440\u0438\u0441\u043a\u043e" },
            { "Syrj", "\u0437\u0430\u043f\u0430\u0434\u043d\u043e\u0441\u0438\u0440\u0438\u0441\u043a\u043e" },
            { "Syrn", "\u0438\u0441\u0442\u043e\u0447\u043d\u043e\u0441\u0438\u0440\u0438\u0441\u043a\u043e" },
            { "Tagb", "\u0442\u0430\u0433\u0431\u0430\u043d\u0432\u0430\u043d\u0441\u043a\u043e" },
            { "Takr", "\u0442\u0430\u043a\u0440\u0438" },
            { "Tale", "\u0442\u0430\u0458 \u043b\u0435" },
            { "Talu", "\u043d\u043e\u0432\u043e \u0442\u0430\u0458 \u043b\u0443\u0435" },
            { "Taml", "\u0442\u0430\u043c\u0438\u043b\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Tang", "\u0442\u0430\u043d\u0433\u0443\u0442\u0441\u043a\u043e" },
            { "Tavt", "\u0442\u0430\u0458 \u0432\u0458\u0435\u0442" },
            { "Telu", metaValue_te },
            { "Teng", "\u0442\u0435\u043d\u0433\u0432\u0430\u0440" },
            { "Tfng", "\u0442\u0438\u0444\u0438\u043d\u0430\u0433" },
            { "Tglg", "\u0442\u0430\u0433\u0430\u043b\u043e\u0448\u043a\u043e" },
            { "Thaa", "\u0442\u0430\u043d\u0430" },
            { "Thai", "\u0442\u0430\u0458\u043b\u0430\u043d\u0434\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Tibt", "\u0442\u0438\u0431\u0435\u0442\u0441\u043a\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "Tirh", "\u0442\u0438\u0440\u0445\u0443\u0442\u0430" },
            { "Ugar", "\u0443\u0433\u0430\u0440\u0438\u0442\u0441\u043a\u043e" },
            { "Vaii", metaValue_vai },
            { "Visp", "\u0432\u0438\u0434\u043b\u0438\u0432 \u0433\u043e\u0432\u043e\u0440" },
            { "Wara", "\u0432\u0430\u0440\u0430\u043d\u0433 \u043a\u0448\u0438\u0442\u0438" },
            { "Wole", "\u0432\u043e\u043b\u0435\u0430\u0458\u0441\u043a\u043e" },
            { "Xpeo", "\u0441\u0442\u0430\u0440\u043e\u043f\u0435\u0440\u0441\u0438\u0441\u043a\u043e" },
            { "Xsux", "\u0441\u0443\u043c\u0435\u0440\u043e\u0430\u043a\u0430\u0434\u0441\u043a\u043e \u043a\u043b\u0438\u043d\u0435\u0441\u0442\u043e" },
            { "Yiii", "\u0458\u0438" },
            { "Zinh", "\u043d\u0430\u0441\u043b\u0435\u0434\u0435\u043d\u043e" },
            { "Zmth", "\u043c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u0447\u043a\u0430 \u043d\u043e\u0442\u0430\u0446\u0438\u0458\u0430" },
            { "Zsye", "\u0435\u043c\u043e\u045f\u0438" },
            { "Zsym", "\u0441\u0438\u043c\u0431\u043e\u043b\u0438" },
            { "Zxxx", "\u0431\u0435\u0437 \u043f\u0438\u0441\u043c\u043e" },
            { "Zyyy", "\u043e\u043f\u0448\u0442\u043e" },
            { "Zzzz", "\u043d\u0435\u043f\u043e\u0437\u043d\u0430\u0442\u043e \u043f\u0438\u0441\u043c\u043e" },
            { "de_AT", "\u0430\u0432\u0441\u0442\u0440\u0438\u0441\u043a\u0438 \u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "de_CH", "\u0448\u0432\u0430\u0458\u0446\u0430\u0440\u0441\u043a\u0438 \u0433\u043e\u0440\u043d\u043e\u0433\u0435\u0440\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "en_AU", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0441\u043a\u0438 \u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "en_CA", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0438 \u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "en_GB", "\u0431\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0438 \u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "en_US", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0430\u043d\u0433\u043b\u0438\u0441\u043a\u0438" },
            { "es_ES", "\u0448\u043f\u0430\u043d\u0441\u043a\u0438 (\u0415\u0432\u0440\u043e\u043f\u0430)" },
            { "es_MX", "\u043c\u0435\u043a\u0441\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0448\u043f\u0430\u043d\u0441\u043a\u0438" },
            { "fa_AF", "\u0434\u0430\u0440\u0438" },
            { "fr_CA", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "fr_CH", "\u0448\u0432\u0430\u0458\u0446\u0430\u0440\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0441\u043a\u0438" },
            { "pt_BR", "\u0431\u0440\u0430\u0437\u0438\u043b\u0441\u043a\u0438 \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0441\u043a\u0438" },
            { "pt_PT", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0441\u043a\u0438 (\u0415\u0432\u0440\u043e\u043f\u0430)" },
            { "ro_MD", "\u043c\u043e\u043b\u0434\u0430\u0432\u0441\u043a\u0438" },
            { "sw_CD", "\u043a\u043e\u043d\u0433\u043e\u0430\u043d\u0441\u043a\u0438 \u0441\u0432\u0430\u0445\u0438\u043b\u0438" },
            { "ar_001", "\u0441\u043e\u0432\u0440\u0435\u043c\u0435\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u0438\u0437\u0438\u0440\u0430\u043d \u0430\u0440\u0430\u043f\u0441\u043a\u0438" },
            { "es_419", "\u043b\u0430\u0442\u0438\u043d\u043e\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u0448\u043f\u0430\u043d\u0441\u043a\u0438" },
            { "key.ca", "\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "key.cf", "\u0424\u043e\u0440\u043c\u0430\u0442 \u043d\u0430 \u0432\u0430\u043b\u0443\u0442\u0430" },
            { "key.co", "\u041f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435" },
            { "key.cu", "\u0412\u0430\u043b\u0443\u0442\u0430" },
            { "key.hc", "\u0427\u0430\u0441\u043e\u0432\u0435\u043d \u0446\u0438\u043a\u043b\u0443\u0441 (12 \u0438\u043b\u0438 24)" },
            { "key.lb", "\u0421\u0442\u0438\u043b \u0437\u0430 \u0440\u0430\u0437\u0434\u0435\u043b\u0443\u0432\u0430\u045a\u0435 \u0440\u0435\u0434\u043e\u0432\u0438" },
            { "key.ms", "\u041c\u0435\u0440\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "key.nu", "\u0411\u0440\u043e\u0435\u0432\u0438" },
            { "nds_NL", "\u0434\u043e\u043b\u043d\u043e\u0441\u0430\u043a\u0441\u043e\u043d\u0441\u043a\u0438" },
            { "zh_Hans", "\u043f\u043e\u0435\u0434\u043d\u043e\u0441\u0442\u0430\u0432\u0435\u043d \u043a\u0438\u043d\u0435\u0441\u043a\u0438" },
            { "zh_Hant", "\u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u0435\u043d \u043a\u0438\u043d\u0435\u0441\u043a\u0438" },
            { "%%PINYIN", "\u041f\u0438\u043d\u0458\u0438\u043d \u0440\u043e\u043c\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0458\u0430" },
            { "%%WADEGILE", "\u0412\u0435\u0458\u0434-\u040f\u0430\u0458\u043b\u0441 \u0440\u043e\u043c\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0458\u0430" },
            { "type.ca.roc", "\u041c\u0438\u043d\u0433\u0443\u043e-\u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.co.eor", "\u0415\u0432\u0440\u043e\u043f\u0441\u043a\u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0437\u0430 \u043f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435" },
            { "type.hc.h11", "12-\u0447\u0430\u0441\u043e\u0432\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c (0-11)" },
            { "type.hc.h12", "12-\u0447\u0430\u0441\u043e\u0432\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c (1-12)" },
            { "type.hc.h23", "24-\u0447\u0430\u0441\u043e\u0432\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c (0-23)" },
            { "type.hc.h24", "24-\u0447\u0430\u0441\u043e\u0432\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c (1-24)" },
            { "type.nu.ahom", "\u0410\u0445\u043e\u043c\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.arab", "\u0410\u0440\u0430\u043f\u0441\u043a\u043e-\u0438\u043d\u0434\u0438\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.armn", "\u0415\u0440\u043c\u0435\u043d\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.beng", "\u0411\u0435\u043d\u0433\u0430\u043b\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.cakm", "\u0427\u0430\u043a\u043c\u0430\u043d\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.deva", "\u0414\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.ethi", "\u0415\u0442\u0438\u043e\u043f\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.geor", "\u0413\u0440\u0443\u0437\u0438\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.grek", "\u0413\u0440\u0447\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.gujr", "\u0413\u0443\u045f\u0430\u0440\u0430\u0442\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.guru", "\u0413\u0443\u0440\u043c\u0443\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.hans", "\u041f\u043e\u0435\u0434\u043d\u043e\u0441\u0442\u0430\u0432\u0435\u043d\u0438 \u043a\u0438\u043d\u0435\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.hant", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u0438 \u043a\u0438\u043d\u0435\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.hebr", "\u0425\u0435\u0431\u0440\u0435\u0458\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.java", "\u0408\u0430\u0432\u0430\u043d\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.jpan", "\u0408\u0430\u043f\u043e\u043d\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.khmr", "\u041a\u043c\u0435\u0440\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.knda", "\u041a\u0430\u043d\u043d\u0430\u0434\u0430 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.laoo", "\u041b\u0430\u043e\u0448\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.latn", "\u0410\u0440\u0430\u043f\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.mlym", "\u041c\u0430\u043b\u0430\u0458\u0430\u043b\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.mtei", "\u041c\u0435\u0458\u0442\u0435\u0458\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.mymr", "\u041c\u0458\u0430\u043d\u043c\u0430\u0440\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.olck", "\u0426\u0438\u0444\u0440\u0438 \u043e\u043b \u0447\u0438\u043a\u0438" },
            { "type.nu.orya", "\u041e\u0434\u0438\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.taml", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u0438 \u0442\u0430\u043c\u0438\u043b\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.telu", "\u0422\u0435\u043b\u0443\u0433\u0443 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.thai", "\u0422\u0430\u0458\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.tibt", "\u0422\u0438\u0431\u0435\u0442\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.vaii", "\u0426\u0438\u0444\u0440\u0438 \u0432\u0430\u0438" },
            { "type.ca.dangi", "\u0414\u0430\u043d\u0433\u0438\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.co.ducet", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u043f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435 \u0432\u043e \u0443\u043d\u0438\u043a\u043e\u0434" },
            { "type.co.emoji", "\u041f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435 \u0435\u043c\u043e\u0442\u0438\u043a\u043e\u043d\u0438" },
            { "type.lb.loose", "\u0414\u043e\u043f\u0443\u0441\u0442\u043b\u0438\u0432 \u0441\u0442\u0438\u043b \u0437\u0430 \u0440\u0430\u0437\u0434\u0435\u043b\u0443\u0432\u0430\u045a\u0435 \u0440\u0435\u0434\u043e\u0432\u0438" },
            { "type.nu.roman", "\u0420\u0438\u043c\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.ca.coptic", "\u041a\u043e\u043f\u0442\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.ca.hebrew", "\u0415\u0432\u0440\u0435\u0458\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.ca.indian", "\u0418\u043d\u0434\u0438\u0441\u043a\u0438 \u043d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u0435\u043d \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.co.compat", "\u041f\u0440\u0435\u0442\u0445\u043e\u0434\u043d\u043e \u043f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435" },
            { "type.co.pinyin", "\u0421\u043e\u0440\u0442\u0438\u0440\u0430\u045a\u0435 Pinyin" },
            { "type.co.search", "\u041e\u043f\u0448\u0442\u043e \u043f\u0440\u0435\u0431\u0430\u0440\u0443\u0432\u0430\u045a\u0435" },
            { "type.co.stroke", "\u0420\u0438\u0442\u043c\u0438\u0447\u043a\u0438 \u0440\u0435\u0434\u043e\u0441\u043b\u0435\u0434" },
            { "type.co.unihan", "\u041f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435 \u0443\u043d\u0438\u0445\u0430\u043d" },
            { "type.co.zhuyin", "\u041f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435 \u0436\u0443\u0458\u0438\u043d" },
            { "type.lb.normal", "\u041d\u043e\u0440\u043c\u0430\u043b\u0435\u043d \u0441\u0442\u0438\u043b \u0437\u0430 \u0440\u0430\u0437\u0434\u0435\u043b\u0443\u0432\u0430\u045a\u0435 \u0440\u0435\u0434\u043e\u0432\u0438" },
            { "type.lb.strict", "\u0421\u0442\u0440\u043e\u0433 \u0441\u0442\u0438\u043b \u0437\u0430 \u0440\u0430\u0437\u0434\u0435\u043b\u0443\u0432\u0430\u045a\u0435 \u0440\u0435\u0434\u043e\u0432\u0438" },
            { "type.ms.metric", "\u041c\u0435\u0442\u0440\u0438\u0447\u043a\u0438 \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "type.ca.chinese", "\u041a\u0438\u043d\u0435\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.ca.islamic", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.ca.iso8601", "\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 ISO-8601" },
            { "type.ca.persian", "\u041f\u0435\u0440\u0441\u0438\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.cf.account", "\u0421\u043c\u0435\u0442\u043a\u043e\u0432\u043e\u0434\u0441\u0442\u0432\u0435\u043d \u0444\u043e\u0440\u043c\u0430\u0442 \u043d\u0430 \u0432\u0430\u043b\u0443\u0442\u0430" },
            { "type.co.big5han", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e \u043a\u0438\u043d\u0435\u0441\u043a\u043e \u0441\u043e\u0440\u0442\u0438\u0440\u0430\u045a\u0435" },
            { "type.nu.arabext", "\u041f\u0440\u043e\u0448\u0438\u0440\u0435\u043d\u0438 \u0430\u0440\u0430\u043f\u0441\u043a\u043e-\u0438\u043d\u0434\u0438\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.nu.armnlow", "\u0415\u0440\u043c\u0435\u043d\u0441\u043a\u0438 \u043c\u0430\u043b\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.greklow", "\u0413\u0440\u0447\u043a\u0438 \u043c\u0430\u043b\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.hanidec", "\u041a\u0438\u043d\u0435\u0441\u043a\u0438 \u0434\u0435\u0446\u0438\u043c\u0430\u043b\u043d\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.hansfin", "\u041f\u043e\u0435\u0434\u043d\u043e\u0441\u0442\u0430\u0432\u0435\u043d\u0438 \u043a\u0438\u043d\u0435\u0441\u043a\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.hantfin", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u0438 \u043a\u0438\u043d\u0435\u0441\u043a\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.jpanfin", "\u0408\u0430\u043f\u043e\u043d\u0441\u043a\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0441\u043a\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.nu.tamldec", "\u0422\u0430\u043c\u0438\u043b\u0441\u043a\u0438 \u0446\u0438\u0444\u0440\u0438" },
            { "type.ca.buddhist", "\u0411\u0443\u0434\u0438\u0441\u0442\u0438\u0447\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.ca.ethiopic", "\u0415\u0442\u0438\u043e\u043f\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.ca.japanese", "\u0408\u0430\u043f\u043e\u043d\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.cf.standard", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u0435\u043d \u0444\u043e\u0440\u043c\u0430\u0442 \u043d\u0430 \u0432\u0430\u043b\u0443\u0442\u0430" },
            { "type.co.reformed", "\u0420\u0435\u0444\u043e\u0440\u043c\u0438\u0440\u0430\u043d\u043e \u043f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435" },
            { "type.co.searchjl", "\u041f\u0440\u0435\u0431\u0430\u0440\u0443\u0432\u0430\u045a\u0435 \u0441\u043f\u043e\u0440\u0435\u0434 \u043f\u043e\u0447\u0435\u0442\u043d\u0430 \u0441\u043e\u0433\u043b\u0430\u0441\u043a\u0430 \u0445\u0430\u043d\u0433\u0443\u043b" },
            { "type.co.standard", "\u0421\u0442\u0430\u043d\u0434\u0430\u0440\u0434\u043d\u043e \u043f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435" },
            { "type.ms.uksystem", "\u0418\u043c\u043f\u0435\u0440\u0438\u0458\u0430\u043b\u0435\u043d \u043c\u0435\u0440\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "type.ms.ussystem", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0438 \u043c\u0435\u0440\u0435\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "type.nu.fullwide", "\u0426\u0438\u0444\u0440\u0438 \u0441\u043e \u0446\u0435\u043b\u043e\u0441\u043d\u0430 \u0448\u0438\u0440\u0438\u043d\u0430" },
            { "type.nu.romanlow", "\u0420\u0438\u043c\u0441\u043a\u0438 \u043c\u0430\u043b\u0438 \u0431\u0440\u043e\u0435\u0432\u0438" },
            { "type.ca.gregorian", "\u0413\u0440\u0435\u0433\u043e\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.co.gb2312han", "\u041f\u043e\u0435\u0434\u043d\u043e\u0441\u0442\u0430\u0432\u0435\u043d\u043e \u043a\u0438\u043d\u0435\u0441\u043a\u043e \u0441\u043e\u0440\u0442\u0438\u0440\u0430\u045a\u0435" },
            { "type.co.phonebook", "\u0410\u0437\u0431\u0443\u0447\u0435\u043d \u0440\u0435\u0434\u043e\u0441\u043b\u0435\u0434" },
            { "type.co.dictionary", "\u041f\u043e\u0434\u0440\u0435\u0434\u0443\u0432\u0430\u045a\u0435 \u043f\u043e \u0430\u0437\u0431\u0443\u0447\u0435\u043d \u0440\u0435\u0434\u043e\u0441\u043b\u0435\u0434" },
            { "type.co.traditional", "\u0422\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d\u0430\u043b\u043d\u043e \u0441\u043e\u0440\u0442\u0438\u0440\u0430\u045a\u0435" },
            { "type.ca.islamic-rgsa", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 (\u0421\u0430\u0443\u0434\u0438\u0441\u043a\u0430 \u0410\u0440\u0430\u0431\u0438\u0458\u0430)" },
            { "type.ca.islamic-tbla", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 (\u0430\u0441\u0442\u0440\u043e\u043d\u043e\u043c\u0441\u043a\u0430 \u0435\u043f\u043e\u0445\u0430)" },
            { "type.ca.islamic-civil", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u0433\u0440\u0430\u0453\u0430\u043d\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
            { "type.ca.islamic-umalqura", "\u0418\u0441\u043b\u0430\u043c\u0441\u043a\u0438 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 (\u0423\u043c \u0430\u043b-\u041a\u0443\u0440\u0430)" },
            { "type.ca.ethiopic-amete-alem", "\u0415\u0442\u0438\u043e\u043f\u0441\u043a\u0438 \u0410\u043c\u0435\u0442 \u0410\u043b\u0435\u043c \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440" },
        };
        return data;
    }
}
