/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gsw extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_PW = "Palau";
        final String metaValue_ar = "Arabisch";
        final String metaValue_hy = "Armenisch";
        final String metaValue_ban = "Balinesisch";
        final String metaValue_bn = "Bengalisch";
        final String metaValue_zbl = "Bliss-Symbool";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptisch";
        final String metaValue_ka = "Georgisch";
        final String metaValue_got = "Gotisch";
        final String metaValue_el = "Griechisch";
        final String metaValue_zh = "Chineesisch";
        final String metaValue_he = "Hebr\u00e4isch";
        final String metaValue_ja = "Japanisch";
        final String metaValue_kn = "Kannada";
        final String metaValue_mn = "Mongolisch";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_ota = "Osmanisch";
        final String metaValue_sam = "Samaritanisch";
        final String metaValue_si = "Singhalesisch";
        final String metaValue_su = "Sundanesisch";
        final String metaValue_syr = "Syrisch";
        final String metaValue_ta = "Tamilisch";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_bo = "Tibeetisch";
        final String metaValue_uga = "Ugaritisch";
        final String metaValue_peo = "Altpersisch";
        final Object[][] data = new Object[][] {
            { "001", "W\u00e4lt" },
            { "002", "Afrika" },
            { "003", "Nordameerika" },
            { "005", "S\u00fc\u00fcdameerika" },
            { "009", "Ozeaanie" },
            { "011", "Weschtafrika" },
            { "013", "Mittelameerika" },
            { "014", "Oschtafrika" },
            { "015", "Nordafrika" },
            { "017", "Zentraalafrika" },
            { "018", "S\u00fc\u00fcdlichs Afrika" },
            { "019", "Nord-, Mittel- und S\u00fc\u00fcdameerika" },
            { "021", "N\u00f6rdlichs Ameerika" },
            { "029", "Karibik" },
            { "030", "Oschtaasie" },
            { "034", "S\u00fc\u00fcdaasie" },
            { "035", "S\u00fc\u00fcdoschtaasie" },
            { "039", "S\u00fc\u00fcdeuropa" },
            { "053", "Auschtraalie und N\u00f6iseeland" },
            { "054", "Melaneesie" },
            { "057", "Mikroneesischs Inselgebiet" },
            { "061", "Polineesie" },
            { "142", "Aasie" },
            { "143", "Zentraalaasie" },
            { "145", "Weschtaasie" },
            { "150", "Euroopa" },
            { "151", "Oschteuroopa" },
            { "154", "Nordeuroopa" },
            { "155", "Weschteuroopa" },
            { "419", "Latiinameerika" },
            { "AD", "Andorra" },
            { "AE", "Ver\u00e4inigti Arabischi Emirate" },
            { "AF", "Afganischtan" },
            { "AG", "Antigua und Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albaanie" },
            { "AM", "Armeenie" },
            { "AO", "Angoola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentiinie" },
            { "AS", "Amerikaanisch-Samoa" },
            { "AT", "\u00d6\u00f6schtriich" },
            { "AU", "Auschtraalie" },
            { "AW", "Aruba" },
            { "AX", "Aaland-Insle" },
            { "AZ", "Aserb\u00e4idschan" },
            { "BA", "Bosnie und Herzegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesch" },
            { "BE", "Belgie" },
            { "BF", "Burkina Faaso" },
            { "BG", "Bulgaarie" },
            { "BH", "Bachr\u00e4in" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthelemi" },
            { "BM", "Bermuuda" },
            { "BN", "Brun\u00e4i Tarussalam" },
            { "BO", "Boliivie" },
            { "BR", "Brasilie" },
            { "BS", "Bahaamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet-Insle" },
            { "BW", "Botswana" },
            { "BY", "Wiissrussland" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokos-Insle" },
            { "CD", "Temokraatischi Republik Kongo" },
            { "CF", "Zentraalafrikaanischi Republik" },
            { "CG", "Kongo" },
            { "CH", "Schwiiz" },
            { "CI", "Elfeb\u00e4ik\u00fcschte" },
            { "CK", "Cook-Insle" },
            { "CL", "Tschile" },
            { "CM", "Kamerun" },
            { "CN", "Chiina" },
            { "CO", "Kolumbie" },
            { "CR", "Coschta Rica" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CX", "Wienachts-Insle" },
            { "CY", "Zypere" },
            { "CZ", "Tschechischi Republik" },
            { "DE", "T\u00fc\u00fctschland" },
            { "DJ", "Tschibuuti" },
            { "DK", "T\u00e4nemark" },
            { "DM", "Tominica" },
            { "DO", "Tominikaanischi Republik" },
            { "DZ", "Algeerie" },
            { "EC", "Ecuador" },
            { "EE", "Eestland" },
            { "EG", "\u00c4g\u00fcpte" },
            { "EH", "Weschtsahara" },
            { "ER", "\u00c4ritreea" },
            { "ES", "Schpanie" },
            { "ET", "\u00c4thiopie" },
            { "EU", "Europ\u00e4\u00e4ischi Unioon" },
            { "FI", "Finnland" },
            { "FJ", "Fitschi" },
            { "FK", "Falkland-Insle" },
            { "FM", "Mikroneesie" },
            { "FO", "F\u00e4r\u00f6er" },
            { "FR", "Frankriich" },
            { "GA", "Gabun" },
            { "GB", "Ver\u00e4inigts Ch\u00f6nigriich" },
            { "GD", "Grenada" },
            { "GE", "Geoorgie" },
            { "GF", "Franz\u00f6sisch-Gu\u00e4jaana" },
            { "GG", "G\u00e4\u00e4rnsi" },
            { "GH", "Gaana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6\u00f6nland" },
            { "GM", "Gambia" },
            { "GN", "Gineea" },
            { "GP", "Guad\u00e4lup" },
            { "GQ", "\u00c4quatoriaalgineea" },
            { "GR", "Griecheland" },
            { "GS", "S\u00fc\u00fcdgeorgie und d\u2019s\u00fc\u00fcdlichi S\u00e4ndwitsch-Insle" },
            { "GT", "Guatemaala" },
            { "GU", "Guam" },
            { "GW", "Gineea-Bissau" },
            { "GY", "Gu\u00e4jaana" },
            { "HK", "Sonderverwaltigszone Hongkong" },
            { "HM", "H\u00f6\u00f6rd- und M\u00e4cDonald-Insle" },
            { "HN", "Honduras" },
            { "HR", "Kroaazie" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "ID", "Indoneesie" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Insle vo M\u00e4n" },
            { "IN", "Indie" },
            { "IO", "Britischs Territoorium im Indische Oozean" },
            { "IQ", "Iraak" },
            { "IR", "Iraan" },
            { "IS", "Iisland" },
            { "IT", "Itaalie" },
            { "JE", "Dsch\u00f6rsi" },
            { "JM", "Dscham\u00e4ika" },
            { "JO", "Jordaanie" },
            { "JP", "Japan" },
            { "KE", "Keenia" },
            { "KG", "Kirgiisischtan" },
            { "KH", "Kambodscha" },
            { "KI", "Kiribaati" },
            { "KM", "Komoore" },
            { "KN", "St. Kitts und Niuwis" },
            { "KP", "Demokraatischi Volksrepublik Koreea" },
            { "KR", "Republik Koreea" },
            { "KW", "Kuw\u00e4it" },
            { "KY", "K\u00e4im\u00e4n-Insle" },
            { "KZ", "Kasachschtan" },
            { "LA", "Laaos" },
            { "LB", "Libanon" },
            { "LC", "St. Lutschiia" },
            { "LI", "Li\u00e4chtescht\u00e4i" },
            { "LK", "Schri Lanka" },
            { "LR", "Libeeria" },
            { "LS", "Lesooto" },
            { "LT", "Littaue" },
            { "LU", "Luxemburg" },
            { "LV", "Lettland" },
            { "LY", "L\u00fc\u00fcbie" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Republik Moldau" },
            { "ME", "Monteneegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaschkar" },
            { "MH", "Marshallinsle" },
            { "ML", "Maali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolei" },
            { "MO", "Sonderverwaltigszone Macao" },
            { "MP", "N\u00f6rdlichi Mariaane" },
            { "MQ", "Martinigg" },
            { "MR", "Mauretaanie" },
            { "MS", "Moos\u00f6rrat" },
            { "MT", "Malta" },
            { "MU", "Mauriizius" },
            { "MV", "Malediiwe" },
            { "MW", "Malaawi" },
            { "MX", "Mexiko" },
            { "MY", "Mal\u00e4isia" },
            { "MZ", "Mosambik" },
            { "NA", "Namiibia" },
            { "NC", "N\u00f6ikaledoonie" },
            { "NE", "Niger" },
            { "NF", "Norfolk-Insle" },
            { "NG", "Nigeeria" },
            { "NI", "Nicaraagua" },
            { "NL", "Holland" },
            { "NO", "Norweege" },
            { "NP", "Neepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "N\u00f6iseeland" },
            { "OM", "Omaan" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Franz\u00f6sisch-Polineesie" },
            { "PG", "Papua-Neuguinea" },
            { "PH", "Philippiine" },
            { "PK", "Pakischtan" },
            { "PL", "Poole" },
            { "PM", "St. Pierr und Miggelo" },
            { "PN", "Pitgg\u00e4\u00e4rn" },
            { "PR", "Puerto Riggo" },
            { "PS", "Pal\u00e4schtin\u00e4nsischi Gebiet" },
            { "PT", "Portugal" },
            { "PW", metaValue_PW },
            { "PY", "Paraguai" },
            { "QA", "Ggatar" },
            { "QO", "\u00dcssers Ozeaanie" },
            { "RE", "Re\u00fcnioon" },
            { "RO", "Rum\u00e4\u00e4nie" },
            { "RS", "S\u00e4rbie" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "SA", "Saudi-Araabie" },
            { "SB", "Salomoone" },
            { "SC", "Seisch\u00e4lle" },
            { "SD", "Sudan" },
            { "SE", "Schweede" },
            { "SG", "Singapuur" },
            { "SH", "St. Helena" },
            { "SI", "Sloweenie" },
            { "SJ", "Svalbard und Jaan M\u00e4\u00e4ie" },
            { "SK", "Slowak\u00e4i" },
            { "SL", "Sierra Leoone" },
            { "SM", "San Mariino" },
            { "SN", "Senegal" },
            { "SO", "Somaalie" },
            { "SR", "Surinam" },
            { "ST", "Sao Tome und Prinssipe" },
            { "SV", "El Salvador" },
            { "SY", "S\u00fc\u00fcrie" },
            { "SZ", "Swasiland" },
            { "TC", "T\u00f6rks- und Gaiggos-Insle" },
            { "TD", "Tschad" },
            { "TF", "Franz\u00f6sischi S\u00fc\u00fcd- und Antarktisgebiet" },
            { "TG", "Toogo" },
            { "TH", "Thailand" },
            { "TJ", "Tadschikischtan" },
            { "TK", "Tokelau" },
            { "TL", "Oschttimor" },
            { "TM", "Turkmeenischtan" },
            { "TN", "Tuneesie" },
            { "TO", "Tonga" },
            { "TR", "T\u00fcrggei" },
            { "TT", "Trinidad und Tobaago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansaniia" },
            { "UA", "Ukraiine" },
            { "UG", "Uganda" },
            { "UM", "Amerikanisch-Ozeaanie" },
            { "US", "Ver\u00e4inigti Schtaate" },
            { "UY", "Uruguay" },
            { "UZ", "Uschbeekischtan" },
            { "VA", "Vatikanstadt" },
            { "VC", "St. Vincent und d\u2019Gr\u00f6nadiine" },
            { "VE", "Venezueela" },
            { "VG", "Britischi Jungfere-Insle" },
            { "VI", "Amerikaanischi Jungfere-Insle" },
            { "VN", "Wietnam" },
            { "VU", "Wanuatu" },
            { "WF", "Wallis und Futuuna" },
            { "WS", "Samooa" },
            { "YE", "Jeeme" },
            { "YT", "Majott" },
            { "ZA", "S\u00fc\u00fcdafrika" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Unbekannti oder ung\u00fcltigi Regioon" },
            { "aa", "Afar" },
            { "ab", "Abchasisch" },
            { "ae", "Avestisch" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharisch" },
            { "an", "Aragonesisch" },
            { "ar", metaValue_ar },
            { "as", "Assamesisch" },
            { "av", "Awarisch" },
            { "ay", "Aymara" },
            { "az", "Aserbaidschanisch" },
            { "ba", "Baschkirisch" },
            { "be", "Wiissrussisch" },
            { "bg", "Bulgaarisch" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Br\u00f6toonisch" },
            { "bs", "Bosnisch" },
            { "ca", "Katalaanisch" },
            { "ce", "Tschetscheenisch" },
            { "ch", "Chamorro" },
            { "co", "Korsisch" },
            { "cr", "Cree" },
            { "cs", "Tschechisch" },
            { "cu", "Chileslawisch" },
            { "cv", "Tschuwaschisch" },
            { "cy", "Walisisch" },
            { "da", "T\u00e4nisch" },
            { "de", "T\u00fc\u00fctsch" },
            { "dv", "Malediivisch" },
            { "dz", "Dschongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "\u00c4nglisch" },
            { "eo", "Eschperanto" },
            { "es", "Schpanisch" },
            { "et", "Eestnisch" },
            { "eu", "Baskisch" },
            { "fa", "Persisch" },
            { "ff", "Ful" },
            { "fi", "Finnisch" },
            { "fj", "Fidschianisch" },
            { "fo", "F\u00e4r\u00f6isch" },
            { "fr", "Franz\u00f6sisch" },
            { "fy", "Friesisch" },
            { "ga", "Iirisch" },
            { "gd", "Schottisch-G\u00e4\u00e4lisch" },
            { "gl", "Galizisch" },
            { "gn", "Guarani" },
            { "gu", "Gujarati" },
            { "gv", "Manx-G\u00e4\u00e4lisch" },
            { "ha", "Haussa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "ho", "Hiri-Motu" },
            { "hr", "Kroazisch" },
            { "ht", "Haitisch" },
            { "hu", "Ungarisch" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesisch" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sezuanischs Yi" },
            { "ik", "Inupiak" },
            { "io", "Ido" },
            { "is", "Iisl\u00e4ndisch" },
            { "it", "Itali\u00e4nisch" },
            { "iu", "Inukitut" },
            { "ja", metaValue_ja },
            { "jv", "Javanisch" },
            { "ka", metaValue_ka },
            { "kg", "Kongolesisch" },
            { "ki", "Kikuyu-Schpraach" },
            { "kj", "Kwanyama" },
            { "kk", "Kasachisch" },
            { "kl", "Gr\u00f6\u00f6nl\u00e4ndisch" },
            { "km", "Kambodschanisch" },
            { "kn", metaValue_kn },
            { "ko", "Koreaanisch" },
            { "kr", "Kanuri-Schpraach" },
            { "ks", "Kaschmirisch" },
            { "ku", "Kurdisch" },
            { "kv", "Komi-Schpraach" },
            { "kw", "Kornisch" },
            { "ky", "Kirgiisisch" },
            { "la", "Latiin" },
            { "lb", "Luxemburgisch" },
            { "lg", "Ganda-Schpraach" },
            { "li", "Limburgisch" },
            { "ln", "Lingala" },
            { "lo", "Laozisch" },
            { "lt", "Litauisch" },
            { "lu", "Luba" },
            { "lv", "Lettisch" },
            { "mg", "Madagassisch" },
            { "mh", "Marschallesisch" },
            { "mi", "Maori" },
            { "mk", "Mazedonisch" },
            { "ml", "Malayalam" },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malaiisch" },
            { "mt", "Maltesisch" },
            { "my", "Birmanisch" },
            { "na", "Nauruisch" },
            { "nb", "Norwegisch Bokm\u00e5l" },
            { "nd", "Nord-Ndebele-Schpraach" },
            { "ne", "Nepalesisch" },
            { "ng", "Ndonga" },
            { "nl", "Niderl\u00e4ndisch" },
            { "nn", "Norwegisch Nynorsk" },
            { "no", "Norwegisch" },
            { "nr", "S\u00fc\u00fcd-Ndebele-Schpraach" },
            { "nv", "Navajo-Schpraach" },
            { "ny", "Chewa-Schpraach" },
            { "oc", "Okzitanisch" },
            { "oj", "Ojibwa-Schpraach" },
            { "om", "Oromo" },
            { "or", "Orija" },
            { "os", "Ossezisch" },
            { "pa", "Pandschabisch" },
            { "pi", "Pali" },
            { "pl", "Polnisch" },
            { "ps", "Paschtu" },
            { "pt", "Portugiisisch" },
            { "qu", "Quechua" },
            { "rm", "R\u00e4toromanisch" },
            { "rn", "Rundi-Schpraach" },
            { "ro", "Rum\u00e4nisch" },
            { "ru", "Russisch" },
            { "rw", "Ruandisch" },
            { "sa", "Sanschkrit" },
            { "sc", "Sardisch" },
            { "sd", "Sindhi" },
            { "se", "Nord-Samisch" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroatisch" },
            { "si", metaValue_si },
            { "sk", "Slowakisch" },
            { "sl", "Slowenisch" },
            { "sm", "Samoanisch" },
            { "sn", "Schhona" },
            { "so", "Somali" },
            { "sq", "Albanisch" },
            { "sr", "Serbisch" },
            { "ss", "Swazi" },
            { "st", "S\u00fc\u00fcd-Sotho-Schpraach" },
            { "su", metaValue_su },
            { "sv", "Schwedisch" },
            { "sw", "Suaheli" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tadschikisch" },
            { "th", "Thail\u00e4ndisch" },
            { "ti", "Tigrinja" },
            { "tk", "Turkmenisch" },
            { "tl", metaValue_tl },
            { "tn", "Tswana-Schpraach" },
            { "to", "Tongaisch" },
            { "tr", "T\u00fcrkisch" },
            { "ts", "Tsonga" },
            { "tt", "Tatarisch" },
            { "tw", "Twi" },
            { "ty", "Tahitisch" },
            { "ug", "Uigurisch" },
            { "uk", "Ukrainisch" },
            { "ur", "Urdu" },
            { "uz", "Usbekisch" },
            { "ve", "Venda-Schpraach" },
            { "vi", "Vietnamesisch" },
            { "vo", "Volap\u00fck" },
            { "wa", "Wallonisch" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Jiddisch" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", metaValue_zh },
            { "zu", "Zulu" },
            { "ace", "Aceh" },
            { "ach", "Acholi" },
            { "ada", "Adangme" },
            { "ady", "Adygai" },
            { "afh", "Afrihili" },
            { "ain", "Ainu" },
            { "akk", "Akkadisch" },
            { "ale", "Aleutisch" },
            { "alt", "S\u00fc\u00fcd-Altaisch" },
            { "ang", "Alt\u00e4nglisch" },
            { "anp", "Angika" },
            { "arc", "Aram\u00e4\u00e4isch" },
            { "arn", "Araukanisch" },
            { "arp", "Arapaho" },
            { "arw", "Arawak" },
            { "ast", "Aschturianisch" },
            { "awa", "Awadhi" },
            { "bal", "Belutschisch" },
            { "ban", metaValue_ban },
            { "bas", "Basaa" },
            { "bej", "Bedauye" },
            { "bem", "Bemba" },
            { "bho", "Bhodschpuri" },
            { "bik", "Bikolisch" },
            { "bin", "Bini" },
            { "bla", "Blackfoot-Schpraach" },
            { "bra", "Braj-Bhakha" },
            { "bua", "Burjatisch" },
            { "bug", "Bugineesisch" },
            { "byn", "Blin" },
            { "cad", "Caddo" },
            { "car", "Kariibisch" },
            { "cch", "Atsam" },
            { "ceb", "Cebuano" },
            { "chb", "Tschibtscha" },
            { "chg", "Tschagataisch" },
            { "chk", "Trukesisch" },
            { "chm", "Tscheremissisch" },
            { "chn", "Chinook" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "cop", metaValue_cop },
            { "crh", "Krimtatarisch" },
            { "csb", "Kaschubisch" },
            { "dak", "Takota" },
            { "dar", "Targiinisch" },
            { "del", "Delaware-Schpraach" },
            { "den", "Slavey" },
            { "dgr", "Togrib" },
            { "din", "Tinka" },
            { "doi", "Togri" },
            { "dsb", "Nidersorbisch" },
            { "dua", "Tuala" },
            { "dum", "Mittelniderl\u00e4ndisch" },
            { "dyu", "Tiula" },
            { "efi", "Efikisch" },
            { "egy", "Alt\u00e4gyptisch" },
            { "eka", "Ekajuk" },
            { "elx", "Elamisch" },
            { "enm", "Mittel\u00e4nglisch" },
            { "ewo", "Ewondo" },
            { "fan", "Pangwe-Schpraach" },
            { "fat", "Fanti-Schpraach" },
            { "fil", "Filipino" },
            { "fon", "Fon" },
            { "frm", "Mittelfranz\u00f6sisch" },
            { "fro", "Altfranz\u00f6sisch" },
            { "frr", "Nordfriesisch" },
            { "frs", "Oschtfriesisch" },
            { "fur", "Friulisch" },
            { "gaa", "Ga" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gez", "Geez" },
            { "gil", "Gilbertesisch" },
            { "gmh", "Mittelhocht\u00fc\u00fctsch" },
            { "goh", "Althocht\u00fc\u00fctsch" },
            { "gon", "Gondi" },
            { "gor", "Mongondou" },
            { "got", metaValue_got },
            { "grb", "Grebo" },
            { "grc", "Altgriechisch" },
            { "gsw", "Schwiizert\u00fc\u00fctsch" },
            { "gwi", "Kutchinisch" },
            { "hai", "Haida" },
            { "haw", "Hawaiianisch" },
            { "hil", "Hiligaynonisch" },
            { "hit", "Hethitisch" },
            { "hmn", "Miao" },
            { "hsb", "Obersorbisch" },
            { "hup", "Hupa" },
            { "iba", "Ibanisch" },
            { "ilo", "Ilokano" },
            { "inh", "Inguschisch" },
            { "jbo", "Lojbanisch" },
            { "jpr", "J\u00fc\u00fcdisch-Persisch" },
            { "jrb", "J\u00fc\u00fcdisch-Arabisch" },
            { "kaa", "Karakalpakisch" },
            { "kab", "Kabylisch" },
            { "kac", "Kachin-Schpraach" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardinisch" },
            { "kcg", "Tyap" },
            { "kfo", "Koro" },
            { "kha", "Khasisch" },
            { "kho", "Sakisch" },
            { "kmb", "Kimbundu-Schpraach" },
            { "kok", "Konkani" },
            { "kos", "Kosraeanisch" },
            { "kpe", "Kpelle-Schpraach" },
            { "krc", "Karatschaiisch-Balkarisch" },
            { "krl", "Karelisch" },
            { "kru", "Oraon-Schpraach" },
            { "kum", "Kum\u00fckisch" },
            { "kut", "Kutenai-Schpraach" },
            { "lad", "Ladino" },
            { "lah", "Lahndanisch" },
            { "lam", "Lambanisch" },
            { "lez", "Lesgisch" },
            { "lol", "Mongo" },
            { "loz", "Rotse-Schpraach" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno-Schpraach" },
            { "lun", "Lunda-Schpraach" },
            { "luo", "Luo-Schpraach" },
            { "lus", "Lushai-Schpraach" },
            { "mad", "Maduresisch" },
            { "mag", "Khotta" },
            { "mai", "Maithili" },
            { "mak", "Makassarisch" },
            { "man", "Manding-Schpraach" },
            { "mas", "Massai-Schpraach" },
            { "mdf", "Mokschamordwinisch" },
            { "mdr", "Mandaresisch" },
            { "men", "Mende-Schpraach" },
            { "mga", "Mittelirisch" },
            { "mic", "Micmac-Schpraach" },
            { "min", "Minangkabau-Schpraach" },
            { "mnc", "Mandschurisch" },
            { "mni", "Meithei-Schpraach" },
            { "moh", "Mohawk-Schpraach" },
            { "mos", "Mossi-Schpraach" },
            { "mul", "Mehrschpraachig" },
            { "mus", "Muskogee-Schpraach" },
            { "mwl", "Mirandesisch" },
            { "mwr", "Marwarisch" },
            { "myv", "Erzya" },
            { "nap", "Neapolitanisch" },
            { "nds", "Nidert\u00fc\u00fctsch" },
            { "new", "Newarisch" },
            { "nia", "Nias-Schpraach" },
            { "niu", "Niue-Schpraach" },
            { "nog", "Nogaisch" },
            { "non", "Altnordisch" },
            { "nqo", metaValue_nqo },
            { "nso", "Nord-Sotho-Schpraach" },
            { "nwc", "Alt-Newari" },
            { "nym", "Nyamwezi-Schpraach" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "osa", "Osage-Schpraach" },
            { "ota", metaValue_ota },
            { "pag", "Pangasinanisch" },
            { "pal", "Mittelpersisch" },
            { "pam", "Pampanggan-Schpraach" },
            { "pap", "Papiamento" },
            { "pau", metaValue_PW },
            { "peo", metaValue_peo },
            { "phn", "Ph\u00f6nikisch" },
            { "pon", "Ponapeanisch" },
            { "pro", "Altprovenzalisch" },
            { "raj", "Rajasthani" },
            { "rap", "Oschterinsel-Schpraach" },
            { "rar", "Rarotonganisch" },
            { "rom", "Zig\u00fc\u00fcnerschpraach" },
            { "rup", "Aromunisch" },
            { "sad", "Sandawe-Schpraach" },
            { "sah", "Jakutisch" },
            { "sam", metaValue_sam },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "scn", "Sizilianisch" },
            { "sco", "Schottisch" },
            { "sel", "Selkupisch" },
            { "sga", "Altirisch" },
            { "shn", "Schan-Schpraach" },
            { "sid", "Sidamo" },
            { "sma", "S\u00fc\u00fcd-Samisch" },
            { "smj", "Lule-Samisch" },
            { "smn", "Inari-Samisch" },
            { "sms", "Skolt-Samisch" },
            { "snk", "Soninke-Schpraach" },
            { "sog", "Sogdisch" },
            { "srn", "Srananisch" },
            { "srr", "Serer-Schpraach" },
            { "suk", "Sukuma-Schpraach" },
            { "sus", "Susu" },
            { "sux", "Sumerisch" },
            { "syc", "Altsyrisch" },
            { "syr", metaValue_syr },
            { "tem", "Temne" },
            { "ter", "Tereno-Schpraach" },
            { "tet", "Tetum-Schpraach" },
            { "tig", "Tigre" },
            { "tiv", "Tiv-Schpraach" },
            { "tkl", "Tokelauanisch" },
            { "tlh", "Klingonisch" },
            { "tli", "Tlingit-Schpraach" },
            { "tmh", "Tamaseq" },
            { "tog", "Tsonga-Schpraach" },
            { "tpi", "Neumelanesisch" },
            { "tsi", "Tsimshian-Schpraach" },
            { "tum", "Tumbuka-Schpraach" },
            { "tvl", "Elliceanisch" },
            { "tyv", "Tuwinisch" },
            { "udm", "Udmurtisch" },
            { "uga", metaValue_uga },
            { "umb", "Mbundu-Schpraach" },
            { "und", "Unbeschtimmti Schpraach" },
            { "vai", "Vai-Schpraach" },
            { "vot", "Wotisch" },
            { "wal", "Walamo-Schpraach" },
            { "war", "Waray" },
            { "was", "Washo-Schpraach" },
            { "xal", "Kalm\u00fcckisch" },
            { "yao", "Yao-Schpraach" },
            { "yap", "Yapesisch" },
            { "zap", "Zapotekisch" },
            { "zbl", metaValue_zbl },
            { "zen", "Zenaga" },
            { "zun", "Zuni-Schpraach" },
            { "zxx", "K\u00e4n schpraachliche Inhalt" },
            { "zza", "Zaza" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Avst", "Aveschtisch" },
            { "Bali", metaValue_ban },
            { "Batk", "Battakisch" },
            { "Beng", metaValue_bn },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Blind\u00e4schrift" },
            { "Bugi", "Buginesisch" },
            { "Buhd", "Buhid" },
            { "Cans", "UCAS" },
            { "Cari", "Karisch" },
            { "Cher", metaValue_chr },
            { "Cirt", "Cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "Zypriotisch" },
            { "Cyrl", "Kyrillisch" },
            { "Cyrs", "Altchileslawisch" },
            { "Deva", "T\u00f6vanagaari" },
            { "Dsrt", "Teseret" },
            { "Egyd", "Temozisch-\u00c4g\u00fcptisch" },
            { "Egyh", "Hiraazisch-\u00c4g\u00fcptisch" },
            { "Egyp", "\u00c4g\u00fcptischi Hirogl\u00fc\u00fcfe" },
            { "Ethi", "\u00c4zioopisch" },
            { "Geok", "Ghutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "Glagolitisch" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", "Guscharati" },
            { "Guru", "Gurmukhi" },
            { "Hang", "Hangul" },
            { "Hani", metaValue_zh },
            { "Hano", "Hanunoo" },
            { "Hans", "Ver\u00e4ifachti Chineesischi Schrift" },
            { "Hant", "Tradizionelli Chineesischi Schrift" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hmng", "Pahawh Hmong" },
            { "Hrkt", "Katakana oder Hiragana" },
            { "Hung", "Altungarisch" },
            { "Inds", "Indus-Schrift" },
            { "Ital", "Altitalisch" },
            { "Java", "Javanesisch" },
            { "Jpan", metaValue_ja },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", "Khmer" },
            { "Knda", metaValue_kn },
            { "Kore", "Koreanisch" },
            { "Lana", "Lanna" },
            { "Laoo", "Laotisch" },
            { "Latf", "Latiinisch - Fraktur-Variante" },
            { "Latg", "Latiinisch - G\u00e4\u00e4lischi Variante" },
            { "Latn", "Latiinisch" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lyci", "Lykisch" },
            { "Lydi", "Lydisch" },
            { "Mand", "Mand\u00e4isch" },
            { "Mani", "Manich\u00e4isch" },
            { "Maya", "Maya-Hieroglyph\u00e4" },
            { "Mero", "Meroitisch" },
            { "Mlym", "Malaysisch" },
            { "Mong", metaValue_mn },
            { "Moon", "Moon" },
            { "Mtei", "Meitei Mayek" },
            { "Mymr", "Burmesisch" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orchon-Run\u00e4" },
            { "Orya", "Oriya" },
            { "Osma", metaValue_ota },
            { "Perm", "Altpermisch" },
            { "Phag", "Phags-pa" },
            { "Phlv", "Pahlavi" },
            { "Phnx", "Ph\u00f6nizisch" },
            { "Plrd", "Pollard Phonetisch" },
            { "Rjng", "Rejang" },
            { "Roro", "Rongorongo" },
            { "Runr", "Run\u00e4schrift" },
            { "Samr", metaValue_sam },
            { "Sara", "Sarati" },
            { "Saur", "Saurashtra" },
            { "Sgnw", "Geb\u00e4\u00e4rdeschpraach" },
            { "Shaw", "Shaw-Alphabet" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "Syrisch - Eschtrangelo-Variante" },
            { "Syrj", "Weschtsyrisch" },
            { "Syrn", "Oschtsyrisch" },
            { "Tagb", "Tagbanwa" },
            { "Tale", "Tai Le" },
            { "Talu", "Tai Lue" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "Thaana" },
            { "Thai", "Thai" },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", "Vai" },
            { "Visp", "Sichtbari Schpraach" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "Sumerisch-akkadischi Keilschrift" },
            { "Yiii", "Yi" },
            { "Zinh", "G\u2019eerbt\u00e4 Schriftw\u00e4rt" },
            { "Zxxx", "Schriftlosi Schpraach" },
            { "Zyyy", "Unbeschtimmt" },
            { "Zzzz", "Uncodiirti Schrift" },
            { "de_AT", "\u00d6schtriichischs T\u00fc\u00fctsch" },
            { "de_CH", "Schwiizer Hocht\u00fc\u00fctsch" },
            { "en_AU", "Auschtralischs \u00c4nglisch" },
            { "en_CA", "Kanadischs \u00c4nglisch" },
            { "en_GB", "Britischs \u00c4nglisch" },
            { "en_US", "Amerikanischs \u00c4nglisch" },
            { "es_ES", "Ibeerischs Schpanisch" },
            { "fr_CA", "Kanadischs Franz\u00f6sisch" },
            { "fr_CH", "Schwiizer Franz\u00f6sisch" },
            { "nl_BE", "Fl\u00e4\u00e4misch" },
            { "pt_BR", "Brasilianischs Portugiisisch" },
            { "pt_PT", "Iberischs Portugiisisch" },
            { "ro_MD", "Moldawisch" },
            { "%%1901", "Alti t\u00fc\u00fctschi R\u00e4chtschriibig" },
            { "%%1994", "Schtandardisierti Resianischi R\u00e4chtschriibig" },
            { "%%1996", "N\u00f6\u00f6i t\u00fc\u00fctschi R\u00e4chtschriibig" },
            { "es_419", "Latiinamerikanischs Schpanisch" },
            { "key.ca", "Kal\u00e4nder" },
            { "key.co", "Sortiirig" },
            { "key.cu", "W\u00e4\u00e4hrig" },
            { "%%BISKE", "Bela-Tial\u00e4kt" },
            { "%%BOONT", "Boontling" },
            { "%%LIPAW", "Lipowaz-Mundart" },
            { "%%NEDIS", "Natisone-Mundart" },
            { "%%NJIVA", "Njiva-Mundart" },
            { "%%OSOJS", "Osojane-Mundart" },
            { "%%POSIX", "Posix" },
            { "%%ROZAJ", "Resianisch" },
            { "%%SAAHO", "Saho" },
            { "%%SOLBA", "Solbica-Mundart" },
            { "zh_Hans", "Ver\u00e4ifachts Chineesisch" },
            { "zh_Hant", "Tradizionells Chineesisch" },
            { "%%FONIPA", "Foneetisch (IPA)" },
            { "%%FONUPA", "Foneetisch (UPA)" },
            { "%%SCOUSE", "Scouse-Mundart" },
            { "%%TARASK", "Taraskievica-R\u00e4chtschriibig" },
            { "%%AREVELA", "Oschtarmeenisch" },
            { "%%AREVMDA", "Weschtarmeenisch" },
            { "%%MONOTON", "Monotonisch" },
            { "%%POLYTON", "Politonisch" },
            { "%%REVISED", "N\u00f6\u00f6i R\u00e4chtschriibig" },
            { "%%1606NICT", "Schpaats Mittelfranz\u00f6sisch" },
            { "%%BAKU1926", "\u00c4inheitlichs T\u00fcrggischs Alfabeet" },
            { "%%SCOTLAND", "Schottischs Schtandard\u00e4nglisch" },
            { "type.ca.roc", "Kal\u00e4nder vor Republik Chiina" },
            { "type.ca.hebrew", "Hebr\u00e4\u00e4isch Kal\u00e4nder" },
            { "type.ca.indian", "Indisch Nationaalkal\u00e4nder" },
            { "type.co.pinyin", "Pinyin-Sortiirregle" },
            { "type.co.stroke", "Strichfolg" },
            { "type.ca.chinese", "Chineesisch Kal\u00e4nder" },
            { "type.ca.islamic", "Islaamisch Kal\u00e4nder" },
            { "type.co.big5han", "Tradizionells Chineesisch - Big5" },
            { "type.ca.buddhist", "Buddhischtisch Kal\u00e4nder" },
            { "type.ca.japanese", "Japaanisch Kal\u00e4nder" },
            { "type.ca.gregorian", "Gregoriaanisch Kal\u00e4nder" },
            { "type.co.gb2312han", "Ver\u00e4ifachts Chineesisch - GB2312" },
            { "type.co.phonebook", "Telifonbuech-Sortiirregle" },
            { "type.co.traditional", "Tradizionelli Sortiir-Regle" },
            { "type.ca.islamic-civil", "B\u00fcrgerlich islaamisch Kal\u00e4nder" },
        };
        return data;
    }
}
