/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kea extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_hy = "arm\u00e9niu";
        final String metaValue_bn = "bengali";
        final String metaValue_ka = "jorjianu";
        final String metaValue_el = "gregu";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebraiku";
        final String metaValue_ja = "japones";
        final String metaValue_km = "kmer";
        final String metaValue_kn = "kanares";
        final String metaValue_ko = "korianu";
        final String metaValue_lo = "lausianu";
        final String metaValue_ml = "malaialam";
        final String metaValue_my = "birmanes";
        final String metaValue_si = "singales";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailandes";
        final String metaValue_bo = "tibetanu";
        final Object[][] data = new Object[][] {
            { "001", "Mundu" },
            { "002", "\u00c1frika" },
            { "003", "Merka di Norti" },
            { "005", "Merka di Sul" },
            { "009", "Oseania" },
            { "011", "\u00c1frika Osidental" },
            { "013", "Merka Sentral" },
            { "014", "\u00c1frika Oriental" },
            { "015", "Norti di \u00c1frika" },
            { "017", "\u00c1frika Sentral" },
            { "018", "Sul di \u00c1frika" },
            { "019", "Merkas" },
            { "021", "Norti di Merka" },
            { "029", "Karaibas" },
            { "030", "\u00c1zia Oriental" },
            { "034", "Sul di \u00c1zia" },
            { "035", "Sudesti Azi\u00e1tiku" },
            { "039", "Europa di Sul" },
            { "053", "Austral\u00e1zia" },
            { "054", "Melan\u00e9zia" },
            { "057", "Rejion di Mikron\u00e9zia" },
            { "061", "Polin\u00e9zia" },
            { "142", "\u00c1zia" },
            { "143", "\u00c1zia Sentral" },
            { "145", "\u00c1zia Osidental" },
            { "150", "Europa" },
            { "151", "Europa Oriental" },
            { "154", "Europa di Norti" },
            { "155", "Europa Osidental" },
            { "202", "\u00c1frika Subisariana" },
            { "419", "Merka Latinu" },
            { "AC", "Ilha di Asenson" },
            { "AD", "Andora" },
            { "AE", "Emiradus \u00c1rabi Unidu" },
            { "AF", "Afeganist\u00e3u" },
            { "AG", "Antigua i Barbuda" },
            { "AI", "Angila" },
            { "AL", "Alb\u00e1nia" },
            { "AM", "Arm\u00e9nia" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e1rtika" },
            { "AR", "Arjentina" },
            { "AS", "Samoa Merkanu" },
            { "AT", "\u00c1ustria" },
            { "AU", "Austr\u00e1lia" },
            { "AW", "Aruba" },
            { "AX", "Ilhas \u00c5land" },
            { "AZ", "Azerbaidjan" },
            { "BA", "B\u00f3snia i Erzegovina" },
            { "BB", "Barbadus" },
            { "BD", "Bangladexi" },
            { "BE", "B\u00e9ljika" },
            { "BF", "Burkina Fasu" },
            { "BG", "Bulg\u00e1ria" },
            { "BH", "Barain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "San Bartolomeu" },
            { "BM", "Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bol\u00edvia" },
            { "BQ", "Karaibas Olandezas" },
            { "BR", "Brazil" },
            { "BS", "Baamas" },
            { "BT", "Butan" },
            { "BV", "Ilha Buv\u00ea" },
            { "BW", "Botsuana" },
            { "BY", "Belarus" },
            { "BZ", "Belizi" },
            { "CA", "Kanad\u00e1" },
            { "CC", "Ilhas Kokus (Keeling)" },
            { "CD", "Kongu - Kinxasa" },
            { "CF", "Republika Sentru-Afrikanu" },
            { "CG", "Kongu - Brazavili" },
            { "CH", "Suisa" },
            { "CI", "Kosta di Marfin" },
            { "CK", "Ilhas Kuk" },
            { "CL", "Xili" },
            { "CM", "Kamarons" },
            { "CN", "Xina" },
            { "CO", "Kol\u00f3mbia" },
            { "CP", "Ilha Kliperton" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabu Verdi" },
            { "CW", "Kurasau" },
            { "CX", "Ilha di Natal" },
            { "CY", "Xipri" },
            { "CZ", "Tx\u00e9kia" },
            { "DE", "Alimanha" },
            { "DG", "Diegu Garsia" },
            { "DJ", "Djibuti" },
            { "DK", "Dinamarka" },
            { "DM", "Dominika" },
            { "DO", "Rep\u00fablika Dominikana" },
            { "DZ", "Arj\u00e9lia" },
            { "EA", "Seuta i Melilha" },
            { "EC", "Ekuador" },
            { "EE", "St\u00f3nia" },
            { "EG", "Ejitu" },
            { "EH", "Sara Osidental" },
            { "ER", "Iritreia" },
            { "ES", "Spanha" },
            { "ET", "Eti\u00f3pia" },
            { "EU", "Union Europeia" },
            { "EZ", "Eurozona" },
            { "FI", "Finl\u00e1ndia" },
            { "FJ", "Fidji" },
            { "FK", "Ilhas Malvinas" },
            { "FM", "Mikron\u00e9zia" },
            { "FO", "Ilhas Faroe" },
            { "FR", "Fransa" },
            { "GA", "Gabon" },
            { "GB", "Reinu Unidu" },
            { "GD", "Granada" },
            { "GE", "Ji\u00f3rjia" },
            { "GF", "Giana Franseza" },
            { "GG", "Gernzi" },
            { "GH", "Gana" },
            { "GI", "Jibraltar" },
            { "GL", "Gronel\u00e1ndia" },
            { "GM", "G\u00e1mbia" },
            { "GN", "Gine" },
            { "GP", "Guadalupi" },
            { "GQ", "Gine Ekuatorial" },
            { "GR", "Gr\u00e9sia" },
            { "GS", "Ilhas Je\u00f3rjia di Sul i Sanduixi di Sul" },
            { "GT", "Guatimala" },
            { "GU", "Guam" },
            { "GW", "Gine-Bisau" },
            { "GY", "Giana" },
            { "HK", "Hong Kong, Rejion Administrativu Spesial di Xina" },
            { "HM", "Ilhas Heard i McDonald" },
            { "HN", "Onduras" },
            { "HR", "Kro\u00e1sia" },
            { "HT", "Ait\u00ed" },
            { "HU", "Ungria" },
            { "IC", "Kan\u00e1rias" },
            { "ID", "Indon\u00e9zia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Ilha di Man" },
            { "IN", "\u00cdndia" },
            { "IO", "Ilhas Brit\u00e1nikas di \u00cdndiku" },
            { "IQ", "Iraki" },
            { "IR", "Ir\u00e3u" },
            { "IS", "Isl\u00e1ndia" },
            { "IT", "It\u00e1lia" },
            { "JE", "Jersi" },
            { "JM", "Jamaika" },
            { "JO", "Jord\u00e1nia" },
            { "JP", "Japon" },
            { "KE", "K\u00e9nia" },
            { "KG", "Kirgistan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Kamoris" },
            { "KN", "San Kristovan i Nevis" },
            { "KP", "Koreia di Norti" },
            { "KR", "Koreia di Sul" },
            { "KW", "Kueiti" },
            { "KY", "Ilhas Kaimon" },
            { "KZ", "Kazakistan" },
            { "LA", "Laus" },
            { "LB", "L\u00edbanu" },
            { "LC", "Santa L\u00fasia" },
            { "LI", "Lixenstain" },
            { "LK", "Sri Lanka" },
            { "LR", "Lib\u00e9ria" },
            { "LS", "Lezotu" },
            { "LT", "Litu\u00e1nia" },
            { "LU", "Luxemburgu" },
            { "LV", "Let\u00f3nia" },
            { "LY", "L\u00edbia" },
            { "MA", "Marokus" },
            { "MC", "M\u00f3naku" },
            { "MD", "Mold\u00e1via" },
            { "ME", "Montenegru" },
            { "MF", "San Martinhu (Fransa)" },
            { "MG", "Madagaskar" },
            { "MH", "Ilhas Marxal" },
            { "MK", "Masid\u00f3nia di Norti" },
            { "ML", "Mali" },
            { "MM", "Mianmar (Birm\u00e1nia)" },
            { "MN", "Mong\u00f3lia" },
            { "MO", "Makau, Rejion Administrativu Spesial di Xina" },
            { "MP", "Ilhas Marianas di Norti" },
            { "MQ", "Martinika" },
            { "MR", "Maurit\u00e1nia" },
            { "MS", "Monserat" },
            { "MT", "Malta" },
            { "MU", "Maur\u00edsia" },
            { "MV", "Maldivas" },
            { "MW", "Malaui" },
            { "MX", "M\u00e9xiku" },
            { "MY", "Mal\u00e1zia" },
            { "MZ", "Musambiki" },
            { "NA", "Nam\u00edbia" },
            { "NC", "Nova Kalid\u00f3nia" },
            { "NE", "Nijer" },
            { "NF", "Ilhas Norfolk" },
            { "NG", "Nij\u00e9ria" },
            { "NI", "Nikar\u00e1gua" },
            { "NL", "Olanda" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zil\u00e1ndia" },
            { "OM", "Oman" },
            { "PA", "Panam\u00e1" },
            { "PE", "Peru" },
            { "PF", "Polin\u00e9zia Franseza" },
            { "PG", "Papua-Nova Gine" },
            { "PH", "Filipinas" },
            { "PK", "Pakistan" },
            { "PL", "Pul\u00f3nia" },
            { "PM", "San Piere i Mikelon" },
            { "PN", "Ilhas Pitkairn" },
            { "PR", "Portu Riku" },
            { "PS", "Tirit\u00f3riu palistinianu" },
            { "PT", "Purtugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Katar" },
            { "QO", "Ilhas di Oseania" },
            { "RE", "Runion" },
            { "RO", "Rum\u00e9nia" },
            { "RS", "S\u00e9rvia" },
            { "RU", "R\u00fasia" },
            { "RW", "Ruanda" },
            { "SA", "Ar\u00e1bia Saudita" },
            { "SB", "Ilhas Salum\u00e3u" },
            { "SC", "Seixelis" },
            { "SD", "Sudon" },
            { "SE", "Su\u00e9sia" },
            { "SG", "Singapura" },
            { "SH", "Santa Ilena" },
            { "SI", "Slov\u00e9nia" },
            { "SJ", "Svalbard i Jan Maien" },
            { "SK", "Slov\u00e1kia" },
            { "SL", "Sera Lioa" },
            { "SM", "San Marinu" },
            { "SN", "Senegal" },
            { "SO", "Sum\u00e1lia" },
            { "SR", "Surinami" },
            { "SS", "Sudon di Sul" },
            { "ST", "San Tume i Pr\u00ednsipi" },
            { "SV", "El Salvador" },
            { "SX", "San Martinhu (Olanda)" },
            { "SY", "S\u00edria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Kunha" },
            { "TC", "Ilhas Turkas i Kaikus" },
            { "TD", "Txadi" },
            { "TF", "Terras Franses di Sul" },
            { "TG", "Togu" },
            { "TH", "Tail\u00e1ndia" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor Lesti" },
            { "TM", "Turkumenistan" },
            { "TN", "Tun\u00edzia" },
            { "TO", "Tonga" },
            { "TR", "Turkia" },
            { "TT", "Trinidad i Tobagu" },
            { "TV", "Tuvalu" },
            { "TW", "Taiuan" },
            { "TZ", "Tanz\u00e1nia" },
            { "UA", "Ukr\u00e1nia" },
            { "UG", "Uganda" },
            { "UM", "Ilhas Minoris Distantis de Stadus Unidus" },
            { "UN", "Nasons Unidas" },
            { "US", "Stadus Unidos di Merka" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikanu" },
            { "VC", "San Bisenti i Granadinas" },
            { "VE", "Vinizuela" },
            { "VG", "Ilhas Virjens Brit\u00e1nikas" },
            { "VI", "Ilhas Virjens Merkanas" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Ualis i Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-sotakis" },
            { "XB", "Pseudo-bidiresional" },
            { "XK", "Kozovu" },
            { "YE", "I\u00e9men" },
            { "YT", "Maiote" },
            { "ZA", "\u00c1frika di Sul" },
            { "ZM", "Z\u00e1mbia" },
            { "ZW", "Zimb\u00e1bui" },
            { "ZZ", "Rejion Diskonxedu" },
            { "ab", "abk\u00e1ziu" },
            { "af", "afrikaner" },
            { "ak", "akan" },
            { "am", "am\u00e1riku" },
            { "ar", "\u00e1rabi" },
            { "as", "asames" },
            { "ay", "aimara" },
            { "az", "azerbaijanu" },
            { "ba", "baxkir" },
            { "be", "bielorusu" },
            { "bg", "b\u00falgaru" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bret\u00e3u" },
            { "bs", "bosniu" },
            { "ca", "katal\u00e3u" },
            { "ce", "txetxenu" },
            { "co", "k\u00f3rsiku" },
            { "cs", "txeku" },
            { "cu", "slavu kl\u00e9riku" },
            { "cv", "txuvaxi" },
            { "cy", "gales" },
            { "da", "dinamarkes" },
            { "de", "alemon" },
            { "dz", "dzonka" },
            { "ee", "eve" },
            { "el", metaValue_el },
            { "en", "ingles" },
            { "eo", "sperantu" },
            { "es", "spanhol" },
            { "et", "stonianu" },
            { "eu", "basku" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "finlandes" },
            { "fj", "fijianu" },
            { "fo", "faroes" },
            { "fr", "franses" },
            { "fy", "fr\u00edziu osidental" },
            { "ga", "irlandes" },
            { "gl", "galegu" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manks" },
            { "ha", "auza" },
            { "he", metaValue_he },
            { "hi", "indi" },
            { "hr", "kroata" },
            { "ht", "aitianu" },
            { "hu", "\u00fangaru" },
            { "hy", metaValue_hy },
            { "ia", "interlingua" },
            { "id", "indon\u00e9ziu" },
            { "ig", "ibo" },
            { "ii", "nuosu" },
            { "is", "islandes" },
            { "it", "italianu" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "javanes" },
            { "ka", metaValue_ka },
            { "ki", "kikuiu" },
            { "kk", "kazak" },
            { "kl", "groenlandes" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "ks", "kaxmira" },
            { "ku", "kurdu" },
            { "kw", "k\u00f3rniku" },
            { "ky", "kirgiz" },
            { "la", "latin" },
            { "lb", "luxemburges" },
            { "lg", "luganda" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituanu" },
            { "lu", "luba-katanga" },
            { "lv", "let\u00e3u" },
            { "mg", "malgaxi" },
            { "mi", "maori" },
            { "mk", "mased\u00f3niu" },
            { "ml", metaValue_ml },
            { "mr", "marati" },
            { "ms", "mal\u00e1iu" },
            { "mt", "maltes" },
            { "my", metaValue_my },
            { "nb", "norueges bokm\u00e5l" },
            { "ne", "nepales" },
            { "nl", "olandes" },
            { "nn", "norueges nynorsk" },
            { "om", "oromo" },
            { "or", "od\u00eda" },
            { "os", "os\u00e9tiku" },
            { "pa", "pandjabi" },
            { "pl", "pulaku" },
            { "ps", "paxto" },
            { "pt", "purtuges" },
            { "qu", "kexua" },
            { "rm", "romanxi" },
            { "rn", "rundi" },
            { "ro", "rumenu" },
            { "ru", "rusu" },
            { "rw", "kiniaruanda" },
            { "sa", "s\u00e1nskritu" },
            { "sd", "sindi" },
            { "si", metaValue_si },
            { "sk", "slovaku" },
            { "sl", "slov\u00e9niu" },
            { "so", "somali" },
            { "sq", "albanes" },
            { "sr", "s\u00e9rviu" },
            { "su", "sundanes" },
            { "sv", "sueku" },
            { "sw", "sua\u00edli" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadjiki" },
            { "th", metaValue_th },
            { "ti", "tigrinia" },
            { "tk", "turkmenu" },
            { "to", "tonganes" },
            { "tr", "turku" },
            { "tt", "tatar" },
            { "ug", "uigur" },
            { "uk", "ukranianu" },
            { "ur", "urdu" },
            { "uz", "uzbeki" },
            { "vi", "vietnamita" },
            { "wo", "uolof" },
            { "xh", "koza" },
            { "yo", "ioruba" },
            { "zh", "xines" },
            { "zu", "zulu" },
            { "agq", "aghem" },
            { "arn", "araukanu" },
            { "asa", "asu" },
            { "ast", "asturianu" },
            { "ban", "balines" },
            { "bas", "basa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "brx", "bodo" },
            { "ccp", "xakma" },
            { "ceb", "sebuanu" },
            { "cgg", "xiga" },
            { "chr", "xeroki" },
            { "ckb", "kurdu sentral" },
            { "dav", "taita" },
            { "dje", "zarma" },
            { "dsb", "s\u00f3rbiu baxu" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "ebu", "embu" },
            { "ewo", "ewondo" },
            { "fil", "filipinu" },
            { "fur", "friulanu" },
            { "gag", "gagauz" },
            { "gsw", "alemon suisu" },
            { "guz", "gusii" },
            { "haw", "avaianu" },
            { "hmn", "hmong" },
            { "hsb", "s\u00f3rbiu altu" },
            { "jgo", "\u00f1omba" },
            { "jmc", "matxame" },
            { "kab", "kabila" },
            { "kam", "kamba" },
            { "kde", "makonde" },
            { "kea", "kabuverdianu" },
            { "khq", "koira txiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "koi", "komi-permiak" },
            { "kok", "konkani" },
            { "ksf", "bafia" },
            { "ksh", "kolonhanu" },
            { "lag", "langi" },
            { "lkt", "lakota" },
            { "luo", "luo" },
            { "luy", "luyia" },
            { "mgh", "makua" },
            { "nds", "alemon baxu" },
            { "nmg", "kuazio" },
            { "prg", "prusianu" },
            { "quc", "kitxe" },
            { "rof", "rombu" },
            { "rwk", "rwa" },
            { "ses", "koiraboro seni" },
            { "smn", "inari sami" },
            { "tzm", "tamaziti di Atlas Sentral" },
            { "und", "l\u00edngua diskonxedu" },
            { "yue", "kantunes" },
            { "zgh", "tamazait marokinu padron" },
            { "zxx", "sen kontiudu lingu\u00edstiku" },
            { "Arab", "ar\u00e1biku" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "braille" },
            { "Cyrl", "sir\u00edliku" },
            { "Deva", "devanagari" },
            { "Ethi", "eti\u00f3piku" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmuki" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hans", "simplifikadu" },
            { "Hant", "tradisional" },
            { "Hebr", metaValue_he },
            { "Hira", "iragana" },
            { "Hrkt", "silab\u00e1riu japunes" },
            { "Jpan", metaValue_ja },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", "latinu" },
            { "Mlym", metaValue_ml },
            { "Mong", "mongol" },
            { "Mymr", metaValue_my },
            { "Orya", "oriya" },
            { "Sinh", metaValue_si },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "taana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Zmth", "notason matim\u00e1tiku" },
            { "Zsye", "emoji" },
            { "Zsym", "s\u00edmbulus" },
            { "Zxxx", "n\u00e3u skritu" },
            { "Zyyy", "komun" },
            { "Zzzz", "skrita diskonxedu" },
            { "de_AT", "alemon austr\u00edaku" },
            { "de_CH", "alemon altu suisu" },
            { "en_AU", "ingles australianu" },
            { "en_CA", "ingles kanadianu" },
            { "en_GB", "ingles brit\u00e1niku" },
            { "en_US", "ingles merkanu" },
            { "es_ES", "spanhol europeu" },
            { "es_MX", "spanhol mexikanu" },
            { "fr_CA", "franses kanadianu" },
            { "fr_CH", "franses suisu" },
            { "nl_BE", "flamengu" },
            { "pt_BR", "purtuges brazileru" },
            { "pt_PT", "purtuges europeu" },
            { "ro_MD", "rumenu mold\u00e1viku" },
            { "sw_CD", "sua\u00edli kongoles" },
            { "ar_001", "\u00e1rabi mudernu" },
            { "es_419", "spanhol latinu-merkanu" },
            { "key.ca", "Kalend\u00e1riu" },
            { "key.cf", "Formatu di mueda" },
            { "key.co", "Ordenason" },
            { "key.cu", "Mueda" },
            { "key.hc", "Siklu or\u00e1riu (12 o 24)" },
            { "key.lb", "Stilu di kebra di linha" },
            { "key.ms", "Sistema di midida" },
            { "key.nu", "Nunbru" },
            { "zh_Hans", "xines simplifikadu" },
            { "zh_Hant", "xines tradisional" },
            { "type.ca.roc", "Kalend\u00e1riu di Rep\u00fablika di Xina" },
            { "type.hc.h11", "Sistema di 12 ora (0\u201311)" },
            { "type.hc.h12", "Sistema di 12 ora (1\u201312)" },
            { "type.hc.h23", "Sistema di 24 ora (0\u201323)" },
            { "type.hc.h24", "Sistema di 24 ora (1\u201324)" },
            { "type.nu.latn", "Nunbru osidental" },
            { "type.ca.dangi", "Kalend\u00e1riu dangi" },
            { "type.co.ducet", "\u00d3rdi padron di Unicode" },
            { "type.lb.loose", "Stilu fleks\u00edvel di kebra di linha" },
            { "type.ca.coptic", "Kalend\u00e1riu kopta" },
            { "type.ca.hebrew", "Kalend\u00e1riu ebraiku" },
            { "type.ca.indian", "Kalend\u00e1riu nasional indianu" },
            { "type.co.search", "Piskiza di uzu jeral" },
            { "type.lb.normal", "Stilu padron di kebra di linha" },
            { "type.lb.strict", "Stilu r\u00edjidu di kebra di linha" },
            { "type.ms.metric", "Sistema m\u00e9triku" },
            { "type.ca.chinese", "Kalend\u00e1riu xines" },
            { "type.ca.islamic", "Kalend\u00e1riu isl\u00e1miku" },
            { "type.ca.iso8601", "Kalend\u00e1riu ISO-8601" },
            { "type.ca.persian", "Kalend\u00e1riu persa" },
            { "type.cf.account", "Formatu di mueda kontabil\u00edstiku" },
            { "type.ca.buddhist", "Kalend\u00e1riu budista" },
            { "type.ca.ethiopic", "Kalend\u00e1riu eti\u00f3piku" },
            { "type.ca.japanese", "Kalend\u00e1riu japones" },
            { "type.cf.standard", "Formatu di mueda padron" },
            { "type.co.standard", "\u00d3rdi padron" },
            { "type.ms.uksystem", "Sistema di midida brit\u00e1niku" },
            { "type.ms.ussystem", "Sistema di midida merkanu" },
            { "type.ca.gregorian", "Kalend\u00e1riu Gregorianu" },
            { "type.ca.islamic-tbla", "Kalend\u00e1riu isl\u00e1miku (astron\u00f3miku)" },
            { "type.ca.islamic-civil", "Kalend\u00e1riu isl\u00e1miku (sivil)" },
            { "type.ca.islamic-umalqura", "Kalend\u00e1riu isl\u00e1miku (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Kalend\u00e1riu et\u00edopi ameti alem" },
        };
        return data;
    }
}
