/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u0430\u0440\u0430\u0431";
        final String metaValue_bn = "\u0431\u0435\u043d\u0433\u0430\u043b";
        final String metaValue_ka = "\u0433\u04af\u0440\u0436";
        final String metaValue_el = "\u0433\u0440\u0435\u043a";
        final String metaValue_gu = "\u0433\u0443\u0436\u0430\u0440\u0430\u0442\u0438";
        final String metaValue_he = "\u0435\u0432\u0440\u0435\u0439";
        final String metaValue_ja = "\u044f\u043f\u043e\u043d";
        final String metaValue_km = "\u043a\u0445\u043c\u0435\u0440";
        final String metaValue_kn = "\u043a\u0430\u043d\u043d\u0430\u0434\u0430";
        final String metaValue_ko = "\u0441\u043e\u043b\u043e\u043d\u0433\u043e\u0441";
        final String metaValue_lo = "\u043b\u0430\u043e\u0441";
        final String metaValue_la = "\u043b\u0430\u0442\u0438\u043d";
        final String metaValue_ml = "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c";
        final String metaValue_or = "\u043e\u0440\u0438\u044f";
        final String metaValue_si = "\u0441\u0438\u043d\u0445\u0430\u043b\u0430";
        final String metaValue_ta = "\u0442\u0430\u043c\u0438\u043b";
        final String metaValue_te = "\u0442\u044d\u043b\u04af\u0433\u04af";
        final String metaValue_th = "\u0442\u0430\u0439";
        final String metaValue_bo = "\u0442\u04e9\u0432\u0434";
        final String metaValue_type_ca_ethiopic = "\u044d\u0442\u0438\u043e\u043f \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440";
        final Object[][] data = new Object[][] {
            { "001", "\u0414\u044d\u043b\u0445\u0438\u0439" },
            { "002", "\u0410\u0444\u0440\u0438\u043a" },
            { "003", "\u0425\u043e\u0439\u0434 \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "005", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "009", "\u041d\u043e\u043c\u0445\u043e\u043d \u0434\u0430\u043b\u0430\u0439\u043d \u043e\u0440\u043d\u0443\u0443\u0434" },
            { "011", "\u0411\u0430\u0440\u0443\u0443\u043d \u0410\u0444\u0440\u0438\u043a" },
            { "013", "\u0422\u04e9\u0432 \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "014", "\u0417\u04af\u04af\u043d \u0410\u0444\u0440\u0438\u043a" },
            { "015", "\u0425\u043e\u0439\u0434 \u0410\u0444\u0440\u0438\u043a" },
            { "017", "\u0422\u04e9\u0432 \u0410\u0444\u0440\u0438\u043a" },
            { "018", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u0444\u0440\u0438\u043a \u0442\u0438\u0432" },
            { "019", "\u0410\u043c\u0435\u0440\u0438\u043a" },
            { "021", "\u0425\u043e\u0439\u0434 \u0410\u043c\u0435\u0440\u0438\u043a \u0442\u0438\u0432" },
            { "029", "\u041a\u0430\u0440\u0438\u0431\u044b\u043d \u0442\u044d\u043d\u0433\u0438\u0441" },
            { "030", "\u0417\u04af\u04af\u043d \u0410\u0437\u0438" },
            { "034", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u0437\u0438" },
            { "035", "\u0417\u04af\u04af\u043d \u04e9\u043c\u043d\u04e9\u0434 \u0410\u0437\u0438" },
            { "039", "\u04e8\u043c\u043d\u04e9\u0434 \u0415\u0432\u0440\u043e\u043f" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438-\u0410\u0437\u0438" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438" },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0439\u043d \u0431\u04af\u0441" },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438" },
            { "142", "\u0410\u0437\u0438" },
            { "143", "\u0422\u04e9\u0432 \u0410\u0437\u0438" },
            { "145", "\u0411\u0430\u0440\u0443\u0443\u043d \u0410\u0437\u0438" },
            { "150", "\u0415\u0432\u0440\u043e\u043f" },
            { "151", "\u0417\u04af\u04af\u043d \u0415\u0432\u0440\u043e\u043f" },
            { "154", "\u0425\u043e\u0439\u0434 \u0415\u0432\u0440\u043e\u043f" },
            { "155", "\u0411\u0430\u0440\u0443\u0443\u043d \u0415\u0432\u0440\u043e\u043f" },
            { "202", "\u0421\u0430\u0445\u0430\u0440\u044b\u043d \u0446\u04e9\u043b\u0438\u0439\u043d \u0443\u0440\u0434 \u0445\u044d\u0441\u0433\u0438\u0439\u043d \u0410\u0444\u0440\u0438\u043a" },
            { "419", "\u041b\u0430\u0442\u0438\u043d \u0410\u043c\u0435\u0440\u0438\u043a" },
            { "AC", "\u0410\u0441\u0435\u043d\u0441\u0438\u043e\u043d \u0430\u0440\u0430\u043b" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u0410\u0440\u0430\u0431\u044b\u043d \u041d\u044d\u0433\u0434\u0441\u044d\u043d \u042d\u043c\u0438\u0440\u0442 \u0423\u043b\u0441" },
            { "AF", "\u0410\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0431\u0430 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u044c\u044f" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438" },
            { "AM", "\u0410\u0440\u043c\u0435\u043d\u0438" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0434" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0438\u0439\u043d \u0421\u0430\u043c\u043e\u0430" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0436\u0430\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438-\u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0438" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440" },
            { "BH", "\u0411\u0430\u0445\u0440\u0435\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d\u0442-\u0411\u0430\u0440\u0442\u0435\u043b\u044c\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0430" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438" },
            { "BQ", "\u041a\u0430\u0440\u0438\u0431\u044b\u043d \u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0411\u0443\u0432\u0435 \u0430\u0440\u0430\u043b" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d" },
            { "BY", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437\u0435" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u0439\u043b\u0438\u043d\u0433) \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e-\u041a\u0438\u043d\u0448\u0430\u0441\u0430" },
            { "CF", "\u0422\u04e9\u0432 \u0410\u0444\u0440\u0438\u043a\u0438\u0439\u043d \u0411\u04af\u0433\u0434 \u041d\u0430\u0439\u0440\u0430\u043c\u0434\u0430\u0445 \u0423\u043b\u0441" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e-\u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u044c" },
            { "CI", "\u041a\u043e\u0442-\u0434\u2019\u0418\u0432\u0443\u0430\u0440" },
            { "CK", "\u041a\u04af\u04af\u043a\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u0425\u044f\u0442\u0430\u0434" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438" },
            { "CP", "\u041a\u043b\u0438\u043f\u043f\u0435\u0440\u0442\u043e\u043d \u0430\u0440\u0430\u043b" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u0417\u0443\u043b \u0441\u0430\u0440\u044b\u043d \u0430\u0440\u0430\u043b" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "CZ", "\u0427\u0435\u0445" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e \u0413\u0430\u0440\u0441\u0438\u0430" },
            { "DJ", "\u0414\u0436\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "DO", "\u0411\u04af\u0433\u0434 \u041d\u0430\u0439\u0440\u0430\u043c\u0434\u0430\u0445 \u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u0423\u043b\u0441" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0431\u0430 \u041c\u0435\u043b\u0438\u043b\u044c\u044f" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0438" },
            { "EG", "\u0415\u0433\u0438\u043f\u0435\u0442" },
            { "EH", "\u0411\u0430\u0440\u0443\u0443\u043d \u0421\u0430\u0445\u0430\u0440" },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0435\u0439" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438" },
            { "ET", "\u042d\u0442\u0438\u043e\u043f" },
            { "EU", "\u0415\u0432\u0440\u043e\u043f\u044b\u043d \u0425\u043e\u043b\u0431\u043e\u043e" },
            { "EZ", "\u0415\u0432\u0440\u043e \u0431\u04af\u0441" },
            { "FI", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434" },
            { "FJ", "\u0424\u0438\u0436\u0438" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "GB", "\u0418\u0445 \u0411\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u04af\u0440\u0436" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u044b\u043d \u0413\u0432\u0438\u0430\u043d\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u0439" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u044b\u043d \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "GR", "\u0413\u0440\u0435\u043a" },
            { "GS", "\u04e8\u043c\u043d\u04e9\u0434 \u0416\u043e\u0440\u0436\u0438\u0430 \u0431\u0430 \u04e8\u043c\u043d\u04e9\u0434 \u0421\u044d\u043d\u0434\u0432\u0438\u0447\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u0439-\u0411\u0438\u0441\u0430\u0443" },
            { "GY", "\u0413\u0430\u0439\u0430\u043d\u0430" },
            { "HK", "\u0411\u041d\u0425\u0410\u0423-\u044b\u043d \u0422\u0443\u0441\u0433\u0430\u0439 \u0437\u0430\u0445\u0438\u0440\u0433\u0430\u0430\u043d\u044b \u0431\u04af\u0441 \u0425\u043e\u043d\u0433 \u041a\u043e\u043d\u0433" },
            { "HM", "\u0425\u0435\u0440\u0434 \u0431\u0430 \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "HU", "\u0423\u043d\u0433\u0430\u0440" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434" },
            { "IL", "\u0418\u0437\u0440\u0430\u0438\u043b\u044c" },
            { "IM", "\u041c\u044d\u043d \u0410\u0440\u0430\u043b" },
            { "IN", "\u042d\u043d\u044d\u0442\u0445\u044d\u0433" },
            { "IO", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u0439\u043d \u0445\u0430\u0440\u044c\u044f\u0430 \u042d\u043d\u044d\u0442\u0445\u044d\u0433\u0438\u0439\u043d \u0434\u0430\u043b\u0430\u0439 \u0434\u0430\u0445\u044c \u043d\u0443\u0442\u0430\u0433 \u0434\u044d\u0432\u0441\u0433\u044d\u0440" },
            { "IQ", "\u0418\u0440\u0430\u043a" },
            { "IR", "\u0418\u0440\u0430\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438" },
            { "JE", "\u0416\u0435\u0440\u0441\u0438" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "JO", "\u0419\u043e\u0440\u0434\u0430\u043d" },
            { "JP", "\u042f\u043f\u043e\u043d" },
            { "KE", "\u041a\u0435\u043d\u0438" },
            { "KG", "\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0436" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0442\u0441 \u0431\u0430 \u041d\u0435\u0432\u0438\u0441" },
            { "KP", "\u0425\u043e\u0439\u0434 \u0421\u043e\u043b\u043e\u043d\u0433\u043e\u0441" },
            { "KR", "\u04e8\u043c\u043d\u04e9\u0434 \u0421\u043e\u043b\u043e\u043d\u0433\u043e\u0441" },
            { "KW", "\u041a\u0443\u0432\u0435\u0439\u0442" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d\u044b \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442 \u041b\u044e\u0441\u0438\u0430" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438" },
            { "LY", "\u041b\u0438\u0432\u0438" },
            { "MA", "\u041c\u043e\u0440\u043e\u043a\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u043e\u0432\u0430" },
            { "ME", "\u041c\u043e\u043d\u0442\u0435\u043d\u0435\u0433\u0440\u043e" },
            { "MF", "\u0421\u0435\u043d\u0442-\u041c\u0430\u0440\u0442\u0438\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u044b\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "MK", "\u0425\u043e\u0439\u0434 \u041c\u0430\u043a\u0435\u0434\u043e\u043d" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MM", "\u041c\u044c\u044f\u043d\u043c\u0430\u0440" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b" },
            { "MO", "\u0411\u041d\u0425\u0410\u0423-\u044b\u043d \u0422\u0443\u0441\u0433\u0430\u0439 \u0437\u0430\u0445\u0438\u0440\u0433\u0430\u0430\u043d\u044b \u0431\u04af\u0441 \u041c\u0430\u043a\u0430\u043e" },
            { "MP", "\u0425\u043e\u0439\u0434 \u041c\u0430\u0440\u0438\u0430\u043d\u044b \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0438\u0432" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438" },
            { "NC", "\u0428\u0438\u043d\u044d \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0430\u0440\u0430\u043b" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438" },
            { "NP", "\u0411\u0430\u043b\u0431\u0430" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u044d" },
            { "NZ", "\u0428\u0438\u043d\u044d \u0417\u0435\u043b\u0430\u043d\u0434" },
            { "OM", "\u041e\u043c\u0430\u043d" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u044b\u043d \u041f\u043e\u043b\u0438\u043d\u0435\u0437" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u0428\u0438\u043d\u044d \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448" },
            { "PM", "\u0421\u0435\u043d\u0442-\u041f\u044c\u0435\u0440 \u0431\u0430 \u041c\u0438\u043a\u0435\u043b\u043e" },
            { "PN", "\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u044b \u043d\u0443\u0442\u0430\u0433 \u0434\u044d\u0432\u0441\u0433\u044d\u0440" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "QO", "\u041d\u043e\u043c\u0445\u043e\u043d \u0434\u0430\u043b\u0430\u0439\u0433 \u0442\u043e\u0439\u0440\u0441\u043e\u043d \u0443\u043b\u0441 \u043e\u0440\u043d\u0443\u0443\u0434" },
            { "RE", "\u0420\u0435\u044e\u043d\u0438\u043e\u043d" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438" },
            { "RU", "\u041e\u0440\u043e\u0441" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0421\u0430\u0443\u0434\u044b\u043d \u0410\u0440\u0430\u0431" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u044b \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b\u0438\u0439\u043d \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "SE", "\u0428\u0432\u0435\u0434" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u0421\u0435\u043d\u0442 \u0425\u0435\u043b\u0435\u043d\u0430" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438" },
            { "SJ", "\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0431\u0430 \u042f\u043d \u041c\u0430\u0439\u0435\u043d" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a" },
            { "SL", "\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "SS", "\u04e8\u043c\u043d\u04e9\u0434 \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0431\u0430 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "SV", "\u042d\u043b\u044c \u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "SX", "\u0421\u0438\u043d\u0442 \u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u0438\u0440\u0438" },
            { "SZ", "\u042d\u0441\u0432\u0430\u0442\u0438\u043d\u0438" },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d \u0434\u0430 \u041a\u0443\u043d\u044a\u044f" },
            { "TC", "\u0422\u0443\u0440\u043a \u0431\u0430 \u041a\u0430\u0439\u043a\u043e\u0441\u044b\u043d \u0410\u0440\u043b\u0443\u0443\u0434" },
            { "TD", "\u0427\u0430\u0434" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u044b\u043d \u04e9\u043c\u043d\u04e9\u0434 \u0433\u0430\u0437\u0430\u0440 \u043d\u0443\u0442\u0430\u0433" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0439\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u0430\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0422\u0438\u043c\u043e\u0440-\u041b\u0435\u0441\u0442\u0435" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u0443\u0440\u043a" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0431\u0430 \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "UM", "\u0410\u043c\u0435\u0440\u0438\u043a\u0438\u0439\u043d \u041d\u044d\u0433\u0434\u0441\u044d\u043d \u0423\u043b\u0441\u044b\u043d \u0431\u0430\u0433\u0430 \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "UN", "\u041d\u044d\u0433\u0434\u0441\u044d\u043d \u04ae\u043d\u0434\u044d\u0441\u0442\u043d\u0438\u0439 \u0411\u0430\u0439\u0433\u0443\u0443\u043b\u043b\u0430\u0433\u0430" },
            { "US", "\u0410\u043c\u0435\u0440\u0438\u043a\u0438\u0439\u043d \u041d\u044d\u0433\u0434\u0441\u044d\u043d \u0423\u043b\u0441" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d \u0445\u043e\u0442 \u0443\u043b\u0441" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0431\u0430 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u0439\u043d \u0412\u0438\u0440\u0436\u0438\u043d\u0438\u0439 \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "VI", "\u0410\u041d\u0423-\u044b\u043d \u0412\u0438\u0440\u0436\u0438\u043d\u0438\u0439 \u0430\u0440\u043b\u0443\u0443\u0434" },
            { "VN", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u0431\u0430 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "XA", "\u0445\u0443\u0443\u0440\u043c\u0430\u0433 \u0430\u044f\u043b\u0433\u0430" },
            { "XB", "\u0445\u0443\u0443\u0440\u043c\u0430\u0433 \u0445\u043e\u0451\u0440 \u0447\u0438\u0433\u043b\u044d\u043b\u0442" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "YE", "\u0419\u0435\u043c\u0435\u043d" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "ZA", "\u04e8\u043c\u043d\u04e9\u0434 \u0410\u0444\u0440\u0438\u043a" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u0422\u043e\u0434\u043e\u0440\u0445\u043e\u0439\u0433\u04af\u0439 \u0431\u04af\u0441" },
            { "aa", "\u0430\u0444\u0430\u0440" },
            { "ab", "\u0430\u0431\u0445\u0430\u0437" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441" },
            { "ak", "\u0430\u043a\u0430\u043d" },
            { "am", "\u0430\u043c\u0445\u0430\u0440" },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d" },
            { "ar", metaValue_ar },
            { "as", "\u0430\u0441\u0441\u0430\u043c" },
            { "av", "\u0430\u0432\u0430\u0440" },
            { "ay", "\u0430\u0439\u043c\u0430\u0440\u0430" },
            { "az", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0436\u0430\u043d" },
            { "ba", "\u0431\u0430\u0448\u043a\u0438\u0440" },
            { "be", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u044c" },
            { "bg", "\u0431\u043e\u043b\u0433\u0430\u0440" },
            { "bi", "\u0431\u0438\u0441\u043b\u0430\u043c" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d" },
            { "bs", "\u0431\u043e\u0441\u043d\u0438" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u0430\u043d" },
            { "ce", "\u0447\u0435\u0447\u0435\u043d\u044c" },
            { "ch", "\u0447\u0430\u043c\u043e\u0440\u0440\u043e" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a" },
            { "cs", "\u0447\u0435\u0445" },
            { "cu", "\u0441\u04af\u043c\u0438\u0439\u043d \u0441\u043b\u0430\u0432\u044f\u043d" },
            { "cv", "\u0447\u0443\u0432\u0430\u0448" },
            { "cy", "\u0443\u044d\u043b\u044c\u0441" },
            { "da", "\u0434\u0430\u043d\u0438" },
            { "de", "\u0433\u0435\u0440\u043c\u0430\u043d" },
            { "dv", "\u0434\u0438\u0432\u0435\u0445\u0438" },
            { "dz", "\u0437\u043e\u043d\u0445\u0430" },
            { "ee", "\u044d\u0432\u044d" },
            { "el", metaValue_el },
            { "en", "\u0430\u043d\u0433\u043b\u0438" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "es", "\u0438\u0441\u043f\u0430\u043d\u0438" },
            { "et", "\u044d\u0441\u0442\u043e\u043d\u0438" },
            { "eu", "\u0431\u0430\u0441\u043a" },
            { "fa", "\u043f\u0435\u0440\u0441" },
            { "ff", "\u0444\u0443\u043b\u0430" },
            { "fi", "\u0444\u0438\u043d" },
            { "fj", "\u0444\u0438\u0436\u0438" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446" },
            { "fy", "\u0431\u0430\u0440\u0443\u0443\u043d \u0444\u0440\u0438\u0437" },
            { "ga", "\u0438\u0440\u043b\u0430\u043d\u0434" },
            { "gd", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434\u044b\u043d \u0433\u0435\u043b" },
            { "gl", "\u0433\u0430\u043b\u0435\u0433\u043e" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "gu", metaValue_gu },
            { "gv", "\u043c\u0430\u043d\u043a\u0441" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "he", metaValue_he },
            { "hi", "\u0445\u0438\u043d\u0434\u0438" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442" },
            { "ht", "\u0413\u0430\u0438\u0442\u0438\u0439\u043d \u043a\u0440\u0435\u043e\u043b" },
            { "hu", "\u043c\u0430\u0436\u0430\u0440" },
            { "hy", "\u0430\u0440\u043c\u0435\u043d" },
            { "hz", "\u0445\u0435\u0440\u0435\u0440\u043e" },
            { "ia", "\u0438\u043d\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0432\u043e" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438" },
            { "ie", "\u043d\u044d\u0433\u0434\u043c\u044d\u043b \u0445\u044d\u043b" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "ii", "\u0441\u044b\u0447\u0443\u0430\u043d\u044c \u0438" },
            { "io", "\u0438\u0434\u043e" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434" },
            { "it", "\u0438\u0442\u0430\u043b\u0438" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "ja", metaValue_ja },
            { "jv", "\u044f\u0432\u0430" },
            { "ka", metaValue_ka },
            { "ki", "\u043a\u0438\u043a\u0443\u044e\u04af" },
            { "kj", "\u043a\u0443\u0430\u043d\u044c\u044f\u043c\u0430" },
            { "kk", "\u043a\u0430\u0437\u0430\u0445" },
            { "kl", "\u043a\u0430\u043b\u0430\u043b\u0438\u0441\u0443\u0442" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0438" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440" },
            { "ku", "\u043a\u0443\u0440\u0434" },
            { "kv", "\u043a\u043e\u043c\u0438" },
            { "kw", "\u043a\u043e\u0440\u043d" },
            { "ky", "\u043a\u0438\u0440\u0433\u0438\u0437" },
            { "la", metaValue_la },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "li", "\u043b\u0438\u043c\u0431\u0443\u0440\u0433" },
            { "ln", "\u043b\u0438\u043d\u0433\u0430\u043b\u0430" },
            { "lo", metaValue_lo },
            { "lt", "\u043b\u0438\u0442\u0432\u0430" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "lv", "\u043b\u0430\u0442\u0432\u0438" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0438" },
            { "mh", "\u043c\u0430\u0440\u0448\u0430\u043b\u043b" },
            { "mi", "\u043c\u0430\u043e\u0440\u0438" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d" },
            { "ml", metaValue_ml },
            { "mn", "\u043c\u043e\u043d\u0433\u043e\u043b" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0438" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439" },
            { "mt", "\u043c\u0430\u043b\u0442\u0430" },
            { "my", "\u0431\u0438\u0440\u043c" },
            { "na", "\u043d\u0430\u0443\u0440\u0443" },
            { "nb", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u0439\u043d \u0431\u0443\u043a\u043c\u043e\u043b" },
            { "nd", "\u0445\u043e\u0439\u0434 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "ne", "\u0431\u0430\u043b\u0431\u0430" },
            { "ng", "\u043d\u0434\u043e\u043d\u0433\u0430" },
            { "nl", "\u043d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "nn", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u0439\u043d \u043d\u0438\u043d\u043e\u0440\u0441\u043a" },
            { "no", "\u043d\u043e\u0440\u0432\u0435\u0433" },
            { "nr", "\u04e9\u043c\u043d\u04e9\u0434 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "nv", "\u043d\u0430\u0432\u0430\u0445\u043e" },
            { "ny", "\u043d\u044f\u043d\u0436\u0430" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "or", metaValue_or },
            { "os", "\u043e\u0441\u0441\u0435\u0442\u0438\u043d" },
            { "pa", "\u043f\u0430\u043d\u0436\u0430\u0431\u0438" },
            { "pl", "\u043f\u043e\u043b\u044c\u0448" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "rm", "\u0440\u043e\u043c\u0430\u043d\u0448" },
            { "rn", "\u0440\u0443\u043d\u0434\u0438" },
            { "ro", "\u0440\u0443\u043c\u044b\u043d" },
            { "ru", "\u043e\u0440\u043e\u0441" },
            { "rw", "\u043a\u0438\u043d\u044c\u044f\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "sc", "\u0441\u0430\u0440\u0434\u0438\u043d" },
            { "sd", "\u0441\u0438\u043d\u0434\u0445\u0438" },
            { "se", "\u0445\u043e\u0439\u0434 \u0441\u0430\u043c\u0438" },
            { "sg", "\u0441\u0430\u043d\u0433\u043e" },
            { "sh", "\u0445\u043e\u0440\u0432\u0430\u0442\u044b\u043d \u0441\u0435\u0440\u0431" },
            { "si", metaValue_si },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u043a" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d\u0438" },
            { "sm", "\u0441\u0430\u043c\u043e\u0430" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u0438" },
            { "sr", "\u0441\u0435\u0440\u0431" },
            { "ss", "\u0441\u0432\u0430\u0442\u0438" },
            { "st", "\u0441\u0435\u0441\u043e\u0442\u043e" },
            { "su", "\u0441\u0443\u043d\u0434\u0430\u043d" },
            { "sv", "\u0448\u0432\u0435\u0434" },
            { "sw", "\u0441\u0432\u0430\u0445\u0438\u043b\u0438" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u0442\u0430\u0436\u0438\u043a" },
            { "th", metaValue_th },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d\u044c\u044f" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d" },
            { "tn", "\u0446\u0432\u0430\u043d\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430" },
            { "tr", "\u0442\u0443\u0440\u043a" },
            { "ts", "\u0446\u043e\u043d\u0433\u0430" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440" },
            { "tw", "\u0442\u0432\u0438" },
            { "ty", "\u0442\u0430\u0438\u0442\u0438" },
            { "ug", "\u0443\u0439\u0433\u0443\u0440" },
            { "uk", "\u0443\u043a\u0440\u0430\u0438\u043d" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "uz", "\u0443\u0437\u0431\u0435\u043a" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "vi", "\u0432\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "vo", "\u0432\u043e\u043b\u0430\u043f\u044e\u043a" },
            { "wa", "\u0443\u043e\u043b\u043b\u0443\u043d" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444" },
            { "xh", "\u0445\u043e\u0441\u0430" },
            { "yi", "\u0438\u0434\u0434\u0438\u0448" },
            { "yo", "\u0451\u0440\u0443\u0431\u0430" },
            { "zh", "\u0445\u044f\u0442\u0430\u0434" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "ace", "\u0430\u0447\u0438\u043d" },
            { "ada", "\u0430\u0434\u0430\u043d\u0433\u043c\u044d" },
            { "ady", "\u0430\u0434\u0438\u0433\u044d" },
            { "agq", "\u0430\u0433\u0435\u043c" },
            { "ain", "\u0430\u0439\u043d\u0443" },
            { "ale", "\u0430\u043b\u044e\u0442" },
            { "alt", "\u04e9\u043c\u043d\u04e9\u0434 \u0430\u043b\u0442\u0430\u0439" },
            { "ann", "\u043e\u0431\u043e\u043b\u043e" },
            { "anp", "\u0430\u043d\u0433\u0438\u043a" },
            { "arn", "\u043c\u0430\u043f\u04af\u0447\u0438" },
            { "arp", "\u0430\u0440\u0430\u043f\u0430\u0433\u043e" },
            { "ars", "\u043d\u0430\u0434\u0436\u0438 \u0430\u0440\u0430\u0431" },
            { "asa", "\u0430\u0441\u0443" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u0438" },
            { "atj", "\u0430\u0442\u0438\u043a\u0430\u043c\u0435\u043a" },
            { "awa", "\u0430\u0432\u0430\u0434\u0445\u0438" },
            { "ban", "\u0431\u0430\u043b\u0438" },
            { "bas", "\u0431\u0430\u0441\u0430\u0430" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "bho", "\u0431\u043e\u0436\u043f\u0443\u0440\u0438" },
            { "bin", "\u0431\u0438\u043d\u0438" },
            { "bla", "\u0441\u0438\u043a\u0441\u0438\u043a\u0430" },
            { "brx", "\u0431\u043e\u0434\u043e" },
            { "bug", "\u0431\u0443\u0433\u0438" },
            { "byn", "\u0431\u043b\u0438\u043d" },
            { "cay", "\u043a\u0430\u0439\u044e\u0433\u0430 \u0445\u044d\u043b" },
            { "ccp", "\u0447\u0430\u043a\u043c\u0430" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u043e" },
            { "cgg", "\u0447\u0438\u0433\u0430" },
            { "chk", "\u0447\u0443\u0443\u043a" },
            { "chm", "\u043c\u0430\u0440\u0438 \u0445\u044d\u043b" },
            { "cho", "\u0447\u043e\u043a\u0442\u0430\u0443" },
            { "chp", "\u0447\u0438\u043f\u0435\u0432\u0430\u0439\u0430\u043d" },
            { "chr", "\u0447\u0435\u0440\u043e\u043a\u0438" },
            { "chy", "\u0447\u044d\u0435\u043d\u043d" },
            { "ckb", "\u0442\u04e9\u0432 \u043a\u0443\u0440\u0434" },
            { "clc", "\u0447\u0438\u043b\u043a\u043e\u0442\u0438\u043d" },
            { "crg", "\u043c\u0438\u0447\u0438\u0444" },
            { "crj", "\u0437\u04af\u04af\u043d \u04e9\u043c\u043d\u04e9\u0434 \u043a\u0440\u0438" },
            { "crk", "\u043f\u043b\u044d\u0439\u043d \u043a\u0440\u0438" },
            { "crl", "\u0437\u04af\u04af\u043d \u0445\u043e\u0439\u0434 \u043a\u0440\u0438" },
            { "crm", "\u043c\u04af\u04af\u0441 \u043a\u0440\u0438" },
            { "crr", "\u043a\u0430\u0440\u043e\u043b\u0438\u043d\u0430 \u0430\u043b\u0433\u043e\u043d\u043a\u0438\u043d\u0441\u043a \u0445\u044d\u043b" },
            { "crs", "\u0441\u0435\u0441\u0435\u043b\u0432\u0430 \u043a\u0440\u0435\u043e\u043b \u0444\u0440\u0430\u043d\u0446" },
            { "csw", "\u0441\u0432\u0430\u043c\u043f\u0438 \u043a\u0440\u0438" },
            { "dak", "\u0434\u0430\u043a\u043e\u0442\u0430" },
            { "dar", "\u0434\u0430\u0440\u0433\u0432\u0430" },
            { "dav", "\u0442\u0430\u0439\u0442\u0430" },
            { "dgr", "\u0434\u043e\u0433\u0440\u0438\u0431" },
            { "dje", "\u0437\u0430\u0440\u043c\u0430" },
            { "doi", "\u0434\u043e\u0433\u0440\u0438" },
            { "dsb", "\u0434\u043e\u043e\u0434 \u0441\u043e\u0440\u0431\u0438" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "dyo", "\u0436\u043e\u043b\u0430-\u0444\u043e\u043d\u0438" },
            { "dzg", "\u0434\u0430\u0437\u0430\u0433\u0430" },
            { "ebu", "\u044d\u043c\u0431\u0443" },
            { "efi", "\u044d\u0444\u0438\u043a" },
            { "eka", "\u044d\u043a\u0430\u0436\u0443\u043a" },
            { "ewo", "\u044d\u0432\u043e\u043d\u0434\u043e" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u0438\u043d\u043e" },
            { "fon", "\u0444\u043e\u043d" },
            { "frc", "\u0444\u0440\u0430\u043d\u0446, \u043a\u0430\u0436\u0443\u043d" },
            { "frr", "\u0445\u043e\u0439\u0434 \u0444\u0440\u0438\u0437" },
            { "fur", "\u0444\u0440\u0438\u0443\u043b\u0430\u043d" },
            { "gaa", "\u0433\u0430" },
            { "gag", "\u0433\u0430\u0433\u0443\u0437" },
            { "gez", "\u0433\u0438\u0439\u0437" },
            { "gil", "\u0433\u0438\u043b\u0431\u0435\u0440\u0442" },
            { "gor", "\u0433\u043e\u0440\u043e\u043d\u0442\u0430\u043b\u043e" },
            { "gsw", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438-\u0433\u0435\u0440\u043c\u0430\u043d" },
            { "guz", "\u0433\u0443\u0437\u044b" },
            { "gwi", "\u0433\u0432\u0438\u0447\u0438\u043d" },
            { "hai", "\u0445\u0430\u0439\u0434\u0430" },
            { "haw", "\u0445\u0430\u0432\u0430\u0439" },
            { "hax", "\u04e9\u043c\u043d\u04e9\u0434 \u0445\u0430\u0439\u0434\u0430" },
            { "hil", "\u0445\u0438\u043b\u0438\u0433\u0430\u0439\u043d\u043e\u043d" },
            { "hmn", "\u0445\u043c\u043e\u043d\u0433" },
            { "hsb", "\u0434\u044d\u044d\u0434 \u0441\u043e\u0440\u0431\u0438" },
            { "hup", "\u0445\u0443\u043f\u0430" },
            { "hur", "\u0445\u0430\u043b\u043a\u043e\u043c\u0435\u043b\u0435\u043c" },
            { "iba", "\u0438\u0431\u0430\u043d" },
            { "ibb", "\u0438\u0431\u0438\u0431\u0438\u043e" },
            { "ikt", "\u0431\u0430\u0440\u0443\u0443\u043d \u043a\u0430\u043d\u0430\u0434\u044b\u043d \u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "ilo", "\u0438\u043b\u043e\u043a\u043e" },
            { "inh", "\u0438\u043d\u0433\u0443\u0448" },
            { "jbo", "\u043b\u043e\u0436\u0431\u0430\u043d" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u044d" },
            { "kab", "\u043a\u0430\u0431\u0438\u043b\u0435" },
            { "kac", "\u043a\u0430\u0447\u0438\u043d" },
            { "kaj", "\u0436\u0436\u0443" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "kbd", "\u043a\u0430\u0431\u0430\u0440\u0434\u0438\u043d" },
            { "kcg", "\u0442\u044f\u043f" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u0435" },
            { "kea", "\u043a\u0430\u0431\u04af\u0432\u0435\u0440\u0434\u0438\u0430\u043d\u0443" },
            { "kfo", "\u043a\u043e\u0440\u043e" },
            { "kgp", "\u043a\u0430\u0439\u043d\u0433\u0430\u043d\u0433" },
            { "kha", "\u043a\u0430\u0441\u0438" },
            { "khq", "\u043a\u043e\u0439\u0440\u0430 \u0447\u0438\u043d\u0438" },
            { "kkj", "\u043a\u0430\u043a\u043e" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u0436\u0438\u043d" },
            { "kmb", "\u043a\u0438\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "koi", "\u043a\u043e\u043c\u0438-\u043f\u0435\u0440\u043c\u044f\u043a" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "kpe", "\u043a\u043f\u0435\u043b\u043b\u0435" },
            { "krc", "\u043a\u0430\u0440\u0430\u0447\u0430\u0439-\u0431\u0430\u043b\u043a\u0430\u0440" },
            { "krl", "\u043a\u0430\u0440\u0435\u043b\u044c" },
            { "kru", "\u043a\u0443\u0440\u0443\u043a" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b" },
            { "ksf", "\u0431\u0430\u0444\u0438\u0430" },
            { "ksh", "\u043a\u0451\u043b\u044c\u0448" },
            { "kum", "\u043a\u0443\u043c\u0443\u043a" },
            { "kwk", "\u043a\u0432\u0430\u043a \u0432\u0430\u043b\u0430" },
            { "lad", "\u043b\u0430\u0434\u0438\u043d" },
            { "lag", "\u043b\u0430\u043d\u0433\u0438" },
            { "lez", "\u043b\u0435\u0437\u0433\u0438" },
            { "lij", "\u041b\u0438\u0433\u0443\u0440\u0438" },
            { "lil", "\u043b\u0438\u043b\u043b\u0443\u044d\u0442" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0430" },
            { "lou", "\u043b\u0443\u0438\u0437\u0438\u0430\u043d\u0430 \u043a\u0440\u0435\u043e\u043b\u0435" },
            { "loz", "\u043b\u043e\u0437\u0438" },
            { "lrc", "\u0445\u043e\u0439\u0434 \u043b\u0443\u0440\u0438" },
            { "lsm", "\u0441\u0430\u043c\u0438\u0430" },
            { "lua", "\u043b\u0443\u0431\u0430-\u043b\u0443\u043b\u0443\u0430" },
            { "lun", "\u043b\u0443\u043d\u0434\u0430" },
            { "luo", "\u043b\u0443\u043e" },
            { "lus", "\u043c\u0438\u0437\u043e" },
            { "luy", "\u043b\u0443\u044f\u0430" },
            { "mad", "\u043c\u0430\u0434\u0443\u0440\u0438 \u0445\u044d\u043b" },
            { "mag", "\u043c\u0430\u0433\u0430\u0445\u0438" },
            { "mai", "\u043c\u0430\u0439" },
            { "mak", "\u043c\u0430\u043a\u0430\u0441\u0430\u0440" },
            { "mas", "\u043c\u0430\u0441\u0430\u0439" },
            { "mdf", "\u043c\u043e\u043a\u0448\u0430" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "mfe", "\u043c\u043e\u0440\u0438\u0441\u0435\u043d" },
            { "mgh", "\u043c\u0430\u043a\u0443\u0432\u0430-\u043c\u0438\u0442\u043e" },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "mic", "\u043c\u0438\u043a\u043c\u0430\u043a" },
            { "min", "\u043c\u0438\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u0443" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0438" },
            { "moe", "\u0438\u043d\u043d\u0443-\u0430\u0439\u043c\u0443\u043d" },
            { "moh", "\u043c\u043e\u0445\u0430\u0443\u043a" },
            { "mos", "\u043c\u043e\u0441\u0441\u0438" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "mul", "\u043e\u043b\u043e\u043d \u0445\u044d\u043b" },
            { "mus", "\u043a\u0440\u0438\u043a" },
            { "mwl", "\u043c\u0435\u0440\u0430\u043d\u0434\u0438" },
            { "myv", "\u044d\u0440\u0437\u044f" },
            { "mzn", "\u043c\u0430\u0437\u0430\u043d\u0434\u0435\u0440\u0430\u043d\u0438" },
            { "nap", "\u043d\u0435\u0430\u043f\u043e\u043b\u0438\u0442\u0430\u043d" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "nds", "\u0434\u043e\u043e\u0434 \u0433\u0435\u0440\u043c\u0430\u043d" },
            { "new", "\u043d\u0435\u0432\u0430\u0440\u0438" },
            { "nia", "\u043d\u0438\u0430\u0441 \u0445\u044d\u043b" },
            { "niu", "\u043d\u0438\u0443\u044d" },
            { "nmg", "\u043a\u0432\u0430\u0437\u0438\u043e" },
            { "nnh", "\u043d\u0433\u0438\u0435\u043c\u0431\u04af\u04af\u043d" },
            { "nog", "\u043d\u043e\u0433\u0430\u0438" },
            { "nqo", "\u043d\u043a\u043e" },
            { "nso", "\u0445\u043e\u0439\u0434 \u0441\u043e\u0442\u043e" },
            { "nus", "\u043d\u0443\u0435\u0440" },
            { "nyn", "\u043d\u044f\u043d\u043a\u043e\u043b\u0435" },
            { "ojb", "\u0431\u0430\u0440\u0443\u0443\u043d \u0445\u043e\u0439\u0434 \u043e\u0436\u0438\u0431\u0432\u0430" },
            { "ojc", "\u0442\u04e9\u0432 \u043e\u0436\u0438\u0431\u0432\u0430" },
            { "ojs", "\u043e\u0436\u0438 \u043a\u0440\u0438" },
            { "ojw", "\u0431\u0430\u0440\u0443\u0443\u043d \u043e\u0436\u0438\u0431\u0432\u0430" },
            { "oka", "\u043e\u043a\u0430\u043d\u0430\u0433\u0430\u043d" },
            { "pag", "\u043f\u0430\u043d\u0433\u0430\u0441\u0438\u043d" },
            { "pam", "\u043f\u0430\u043c\u043f\u0430\u043d\u0433\u0430" },
            { "pap", "\u043f\u0430\u043f\u044c\u044f\u043c\u0435\u043d\u0442\u043e" },
            { "pau", "\u043f\u0430\u043b\u0430\u0443" },
            { "pcm", "\u043d\u0438\u0433\u0435\u0440\u0438\u0439\u043d \u043f\u0438\u0434\u0436\u0438\u043d" },
            { "pis", "\u043f\u0438\u0436\u0438\u043d" },
            { "pqm", "\u043c\u0430\u043b\u0435\u0441\u0438\u0442-\u043f\u0430\u0441\u0441\u0430\u043c\u0430\u043a\u0432\u043e\u0434\u0434\u0438" },
            { "prg", "\u043f\u0440\u0443\u0441\u0441" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "rap", "\u0440\u0430\u043f\u0430\u043d\u0443\u0438" },
            { "rar", "\u0440\u0430\u0440\u043e\u0442\u043e\u043d\u0433" },
            { "rhg", "\u0440\u043e\u0445\u0438\u043d\u0436\u0430" },
            { "rof", "\u0440\u043e\u043c\u0431\u043e" },
            { "rup", "\u0430\u0440\u043e\u043c\u0430\u043d\u044b" },
            { "rwk", "\u0440\u0432\u0430" },
            { "sad", "\u0441\u0430\u043d\u0434\u0430\u0432\u044d" },
            { "sah", "\u0441\u0430\u0445\u0430" },
            { "saq", "\u0441\u0430\u043c\u0431\u04af\u0440\u04af" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u0438" },
            { "sba", "\u043d\u0433\u0430\u043c\u0431\u0430\u0439" },
            { "sbp", "\u0441\u0430\u043d\u0433\u04af" },
            { "scn", "\u0441\u0438\u0446\u0438\u043b" },
            { "sco", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "ses", "\u043a\u0451\u0440\u0430\u0431\u043e\u0440\u043e \u0441\u0435\u043d\u0438" },
            { "shi", "\u0442\u0430\u0447\u0435\u043b\u0445\u0438\u0442" },
            { "shn", "\u0448\u0430\u043d\u044c" },
            { "slh", "\u04e9\u043c\u043d\u04e9\u0434 \u043b\u0443\u0448\u0443\u0446\u0438\u0434" },
            { "sma", "\u04e9\u043c\u043d\u04e9\u0434 \u0441\u0430\u043c\u0438" },
            { "smj", "\u043b\u044e\u043b\u0435 \u0441\u0430\u043c\u0438" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438 \u0441\u0430\u043c\u0438" },
            { "sms", "\u0441\u043a\u043e\u043b\u0442 \u0441\u0430\u043c\u0438" },
            { "snk", "\u0441\u043e\u043d\u0438\u043d\u043a\u0435" },
            { "srn", "\u0441\u0440\u0430\u043d\u0430\u043d \u0442\u043e\u043d\u0433\u043e" },
            { "ssy", "\u0441\u0430\u0445\u043e" },
            { "str", "\u0441\u0442\u0440\u0435\u0439\u0442\u0441 \u0441\u0430\u043b\u0438\u0448" },
            { "suk", "\u0441\u0443\u043a\u0443\u043c\u0430" },
            { "swb", "\u043a\u043e\u043c\u043e\u0440\u0438" },
            { "syr", "\u0441\u0438\u0440\u0438" },
            { "tce", "\u04e9\u043c\u043d\u04e9\u0434 \u0442\u0443\u0442\u0447\u043e\u043d\u0435" },
            { "tem", "\u0442\u0438\u043c\u043d" },
            { "teo", "\u0442\u044d\u0441\u043e" },
            { "tet", "\u0442\u0435\u0442\u0443\u043c" },
            { "tgx", "\u0442\u0430\u0433\u0438\u0448" },
            { "tht", "\u0442\u0430\u043b\u0442\u0430\u043d" },
            { "tig", "\u0442\u0438\u0433\u0440" },
            { "tlh", "\u043a\u043b\u0438\u043d\u0433\u043e\u043d" },
            { "tli", "\u0442\u043b\u0438\u043d\u0433\u0438\u0442" },
            { "tok", "\u0442\u043e\u043a\u0438\u043f\u043e\u043d\u0430" },
            { "tpi", "\u0442\u043e\u043a \u043f\u0438\u0441\u0438\u043d" },
            { "trv", "\u0442\u0430\u0440\u043e\u043a\u043e" },
            { "ttm", "\u0445\u043e\u0439\u0434 \u0442\u0443\u0442\u0447\u043e\u043d\u0435" },
            { "tum", "\u0442\u0443\u043c\u0431\u0443\u043b\u0430" },
            { "tvl", "\u0442\u0443\u0432\u0430\u043b\u0443" },
            { "twq", "\u0442\u0430\u0441\u0430\u0432\u0430\u043a" },
            { "tyv", "\u0442\u0443\u0432\u0430" },
            { "tzm", "\u0422\u04e9\u0432 \u0410\u0442\u043b\u0430\u0441\u044b\u043d \u0442\u0430\u043c\u0430\u0437\u0438\u0433\u0445\u0442" },
            { "udm", "\u0443\u0434\u043c\u0443\u0440\u0442" },
            { "umb", "\u0443\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "und", "\u04ae\u043b \u043c\u044d\u0434\u044d\u0433\u0434\u044d\u0445 \u0445\u044d\u043b" },
            { "vai", "\u0432\u0430\u0439" },
            { "vec", "\u0432\u0435\u043d\u0435\u0446" },
            { "vun", "\u0432\u0443\u043d\u0436\u043e" },
            { "wae", "\u0443\u043e\u043b\u0441\u044d\u0440" },
            { "wal", "\u0443\u043e\u043b\u043b\u0430\u0439\u0442\u0442\u0430" },
            { "war", "\u0432\u0430\u0440\u0430\u0439" },
            { "wuu", "\u0445\u044f\u0442\u0430\u0434, \u0432\u0443 \u0445\u044d\u043b" },
            { "xal", "\u0445\u0430\u043b\u0438\u043c\u0430\u0433" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "yav", "\u044f\u043d\u0433\u0431\u0435\u043d" },
            { "ybb", "\u0435\u043c\u0431\u0430" },
            { "yrl", "\u043d\u044c\u0435\u043d\u0433\u0430\u0442\u0443" },
            { "yue", "\u043a\u0430\u043d\u0442\u043e\u043d" },
            { "zgh", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0442\u0430\u043c\u0430\u0437\u0430\u0439\u0442 (\u041c\u043e\u0440\u043e\u043a\u043a\u043e)" },
            { "zun", "\u0437\u0443\u043d\u0438" },
            { "zxx", "\u0445\u044d\u043b \u0437\u04af\u0439\u043d \u0430\u0433\u0443\u0443\u043b\u0433\u0430\u0433\u04af\u0439" },
            { "zza", "\u0437\u0430\u0437\u0430" },
            { "Adlm", "\u0410\u0434\u043b\u0430\u043c \u0431\u0438\u0447\u0438\u0433" },
            { "Aghb", "\u041a\u0430\u0432\u043a\u0430\u0437\u0438\u0439\u043d \u0430\u043b\u0431\u0430\u043d\u0438" },
            { "Ahom", "\u0410\u0445\u043e\u043c" },
            { "Arab", metaValue_ar },
            { "Aran", "\u041d\u0430\u0441\u0442\u0430\u043b\u0438\u043a \u0431\u0438\u0447\u0438\u0433" },
            { "Armi", "\u0410\u0440\u0430\u043c\u0430\u0439\u043a" },
            { "Armn", "\u0430\u0440\u043c\u0435\u043d\u0438" },
            { "Avst", "\u0410\u0432\u0435\u0441\u0442\u0430\u043d" },
            { "Bali", "\u0411\u0430\u043b\u0438" },
            { "Bamu", "\u0411\u0430\u043c\u0443" },
            { "Bass", "\u0411\u0430\u0441\u0441" },
            { "Batk", "\u0411\u0430\u0442\u043a" },
            { "Beng", metaValue_bn },
            { "Bhks", "\u0411\u0430\u0439\u043a\u0441\u0443\u043a\u0438" },
            { "Bopo", "\u0432\u043e\u043f\u043e\u043c\u043e\u0444\u043e" },
            { "Brah", "\u0411\u0440\u0430\u0445\u043c\u0438" },
            { "Brai", "\u0431\u0440\u0430\u0439\u043b" },
            { "Bugi", "\u0411\u0443\u0433\u0438\u043d\u0435\u0437" },
            { "Buhd", "\u0411\u0443\u0445\u0438\u0434" },
            { "Cakm", "\u0427\u0430\u043a\u043c\u0430 \u0431\u0438\u0447\u0438\u0433" },
            { "Cans", "\u041a\u0430\u043d\u0430\u0434\u044b\u043d \u0443\u0443\u0433\u0443\u0443\u043b \u0438\u0440\u0433\u044d\u0434\u0438\u0439\u043d \u0442\u044d\u043c\u0434\u044d\u0433\u0442 \u0431\u0438\u0447\u0438\u0433" },
            { "Cari", "\u041a\u0430\u0440\u0438" },
            { "Cham", "\u0427\u0430\u043c" },
            { "Cher", "\u0427\u0435\u0440\u043e\u043a\u0438 \u0431\u0438\u0447\u0438\u0433" },
            { "Chrs", "\u041a\u043e\u0440\u0430\u0441\u043c\u0438" },
            { "Copt", "\u041a\u043e\u043f\u0442\u0438\u043a" },
            { "Cpmn", "\u041a\u0438\u043f\u0440-\u041c\u0438\u043d\u043e\u0430\u043d" },
            { "Cprt", "\u041a\u0438\u043f\u0440\u0438\u043e\u0442" },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b\u043b" },
            { "Deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438" },
            { "Diak", "\u0414\u0438\u0430\u043a" },
            { "Dogr", "\u0414\u043e\u0433\u0440\u0430" },
            { "Dsrt", "\u0414\u0435\u0437\u0435\u0440\u0435\u0442" },
            { "Dupl", "\u0414\u0443\u043f\u043b\u043e\u044f\u043d" },
            { "Egyp", "\u0415\u0433\u0438\u043f\u0435\u0442\u0438\u0439\u043d \u0434\u04af\u0440\u0441 \u0431\u0438\u0447\u0438\u0433" },
            { "Elba", "\u042d\u043b\u0431\u0430\u0441\u0430\u043d" },
            { "Elym", "\u042d\u043b\u0438\u043c\u0430\u0439\u043a" },
            { "Ethi", "\u044d\u0442\u0438\u043e\u043f" },
            { "Geor", metaValue_ka },
            { "Glag", "\u0413\u043b\u0430\u0433\u043e\u043b\u0438\u0442\u0438\u043a" },
            { "Gong", "\u0413\u043e\u043d\u0433" },
            { "Gonm", "\u041c\u0430\u0441\u0430\u0440\u0430\u043c \u0413\u043e\u043d\u0434\u0438" },
            { "Goth", "\u0413\u043e\u0442\u0438\u043a" },
            { "Gran", "\u0413\u0440\u0430\u043d\u0442\u0430" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0433\u04af\u0440\u043c\u04af\u0445" },
            { "Hanb", "\u0411\u043e\u043f\u043e\u043c\u043e\u0444\u043e\u0442\u043e\u0439 \u0445\u0430\u043d\u0437" },
            { "Hang", "\u0445\u0430\u043d\u0433\u044b\u043b\u044c" },
            { "Hani", "\u0445\u0430\u043d\u0437" },
            { "Hano", "\u0425\u0430\u043d\u0443\u043d\u043e\u043e" },
            { "Hans", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d" },
            { "Hant", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442" },
            { "Hatr", "\u0425\u0430\u0442\u0440\u0430\u043d" },
            { "Hebr", metaValue_he },
            { "Hira", "\u0445\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "Hluw", "\u0410\u043d\u0430\u0442\u043e\u043b\u0438\u0439\u043d \u0434\u04af\u0440\u0441 \u0431\u0438\u0447\u0438\u0433" },
            { "Hmng", "\u041f\u0430\u0445\u0430\u0432 \u0425\u043c\u043e\u043d\u0433" },
            { "Hmnp", "\u0425\u043c\u043d\u043f" },
            { "Hrkt", "\u044f\u043f\u043e\u043d \u0445\u044d\u043b\u043d\u0438\u0439 \u04af\u0435\u0438\u0439\u043d \u0446\u0430\u0433\u0430\u0430\u043d \u0442\u043e\u043b\u0433\u043e\u0439" },
            { "Hung", "\u0425\u0443\u0443\u0447\u0438\u043d \u0423\u043d\u0433\u0430\u0440" },
            { "Ital", "\u0425\u0443\u0443\u0447\u0438\u043d \u0438\u0442\u0430\u043b\u0438" },
            { "Jamo", "\u0436\u0430\u043c\u043e" },
            { "Java", "\u0416\u0430\u0432\u0430" },
            { "Jpan", metaValue_ja },
            { "Kali", "\u041a\u0430\u043b\u0438" },
            { "Kana", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "Kawi", "\u041a\u0430\u0432\u0438" },
            { "Khar", "\u041a\u0430\u0440\u043e\u0448\u0442\u0438" },
            { "Khmr", metaValue_km },
            { "Khoj", "\u041a\u043e\u0436\u043a\u0438" },
            { "Kits", "\u041a\u0438\u0442\u0430\u043d \u0431\u0430\u0433\u0430 \u0431\u0438\u0447\u0432\u044d\u0440" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "\u041a\u0430\u0439\u0442\u0438" },
            { "Lana", "\u041b\u0430\u043d\u0430" },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Lepc", "\u041b\u0435\u043f\u043a" },
            { "Limb", "\u041b\u0438\u043c\u0431" },
            { "Lina", "\u0417\u0443\u0440\u0430\u0430\u0441\u0430\u043d A" },
            { "Linb", "\u0417\u0443\u0440\u0430\u0430\u0441\u0430\u043d B" },
            { "Lisu", "\u041b\u0438\u0441\u0443" },
            { "Lyci", "\u041b\u0438\u0441\u0438" },
            { "Lydi", "\u041b\u0438\u0434\u0438" },
            { "Mahj", "\u041c\u0430\u0445\u0430\u0436\u0430\u043d\u0438" },
            { "Maka", "\u041c\u0430\u043a\u0430\u0441\u0430\u0440" },
            { "Mand", "\u041c\u0430\u043d\u0434" },
            { "Mani", "\u041c\u0430\u043d\u0438\u0447" },
            { "Marc", "\u041c\u0430\u0440\u043a" },
            { "Medf", "\u041c\u0435\u0434\u0435\u0444\u0430\u0439\u0434\u0440\u0438\u043d" },
            { "Mend", "\u041c\u0435\u043d\u0434\u0438" },
            { "Merc", "\u041c\u0435\u0440\u043e\u0439\u0442\u0438\u043a \u041a\u0443\u0440\u0441\u0438\u0432" },
            { "Mero", "\u041c\u0435\u0440\u043e\u0439\u0442\u0438\u043a" },
            { "Mlym", metaValue_ml },
            { "Modi", "\u041c\u043e\u0434\u0438" },
            { "Mong", "\u043c\u043e\u043d\u0433\u043e\u043b \u0431\u0438\u0447\u0438\u0433" },
            { "Mroo", "\u041c\u0440\u0443" },
            { "Mtei", "\u041c\u0435\u0439\u0442\u0435\u0439 \u043c\u0430\u0435\u043a \u0431\u0438\u0447\u0438\u0433" },
            { "Mult", "\u041c\u0443\u043b\u0442\u0430\u043d\u0438" },
            { "Mymr", "\u043c\u044c\u044f\u043d\u043c\u0430\u0440" },
            { "Nagm", "\u041d\u0430\u0433 \u041c\u0443\u043d\u0434\u0430\u0440\u0438" },
            { "Nand", "\u041d\u0430\u043d\u0434\u0438\u043d\u0430\u0433\u0430\u0440\u0438" },
            { "Narb", "\u0425\u0443\u0443\u0447\u0438\u043d \u0425\u043e\u0439\u0434 \u0410\u0440\u0430\u0431 \u0431\u0438\u0447\u0438\u0433" },
            { "Nbat", "\u041d\u0430\u0431\u0430\u0442\u0430" },
            { "Newa", "\u041d\u0435\u0432\u0430" },
            { "Nkoo", "\u041d\u043a\u043e \u0431\u0438\u0447\u0438\u0433" },
            { "Nshu", "\u041d\u04af\u0448\u04af" },
            { "Ogam", "\u041e\u0433\u0430\u043c" },
            { "Olck", "\u041e\u043b \u0447\u0438\u043a\u0438 \u0431\u0438\u0447\u0438\u0433" },
            { "Orkh", "\u041e\u0440\u0445\u043e\u043d" },
            { "Orya", metaValue_or },
            { "Osge", "\u041e\u0441\u0433\u0435" },
            { "Osma", "\u041e\u0441\u043c\u0430\u043d\u0438" },
            { "Ougr", "\u0425\u0443\u0443\u0447\u0438\u043d \u0443\u0439\u0433\u0430\u0440" },
            { "Palm", "\u041f\u0430\u043b\u043c\u0438\u0440\u0435\u043d" },
            { "Pauc", "\u041f\u0430\u0439 \u0427\u0438\u043d \u0425\u0430\u0443" },
            { "Perm", "\u0425\u0443\u0443\u0447\u0438\u043d \u041f\u0435\u0440\u043c\u0438\u043a" },
            { "Phag", "\u0424\u0430\u0433\u0441-\u043f\u0430" },
            { "Phli", "\u041f\u0430\u0445\u043b\u0430\u0432\u0438" },
            { "Phlp", "\u041f\u0441\u0430\u043b\u0442\u0435\u0440 \u041f\u0430\u0445\u043b\u0430\u0432\u0438" },
            { "Phnx", "\u0424\u0438\u043d\u0438\u043a" },
            { "Plrd", "\u041f\u0438\u0440\u0434" },
            { "Prti", "\u041f\u0430\u0440\u0442\u0438\u0430\u043d" },
            { "Qaag", "\u041a\u0430\u0430\u043a" },
            { "Rjng", "\u0420\u0435\u0436\u0430\u043d\u0433" },
            { "Rohg", "\u0425\u0430\u043d\u0430\u0444\u0438 \u0431\u0438\u0447\u0438\u0433" },
            { "Runr", "\u0420\u0443\u043d\u0438" },
            { "Samr", "\u0421\u0430\u043c\u0430\u0440\u0438\u0442\u0430\u043d" },
            { "Sarb", "\u0425\u0443\u0443\u0447\u0438\u043d \u04e8\u043c\u043d\u04e9\u0434 \u0410\u0440\u0430\u0431" },
            { "Saur", "\u0421\u0430\u0443\u0440\u0430\u0448\u0442\u0440\u0430" },
            { "Sgnw", "\u0422\u044d\u043c\u0434\u044d\u0433\u0442 \u0431\u0438\u0447\u0438\u0433" },
            { "Shaw", "\u0428\u0430\u0432\u0438" },
            { "Shrd", "\u0428\u0430\u0440\u0430\u0434\u0430" },
            { "Sidd", "\u0421\u0438\u0434\u0434\u0445\u0430\u043c" },
            { "Sind", "\u041a\u0443\u0434\u0430\u0432\u0430\u0434\u0438" },
            { "Sinh", metaValue_si },
            { "Sogd", "\u0421\u043e\u0433\u0434\u0438" },
            { "Sogo", "\u0425\u0443\u0443\u0447\u0438\u043d \u0441\u043e\u0433\u0434\u0438" },
            { "Sora", "\u0421\u043e\u0440\u0430 \u0441\u043e\u043c\u043f\u0435\u043d\u0433" },
            { "Soyo", "\u0421\u043e\u0451\u043c\u0431\u043e" },
            { "Sund", "\u0421\u0443\u043d\u0434\u0430\u043d \u0431\u0438\u0447\u0438\u0433" },
            { "Sylo", "\u0421\u0438\u043b\u043e" },
            { "Syrc", "\u0421\u0438\u0440\u0438\u0439\u043a \u0431\u0438\u0447\u0438\u0433" },
            { "Tagb", "\u0422\u0430\u0433\u0431\u0430\u043d\u0432\u0430" },
            { "Takr", "\u0422\u0430\u043a\u0440\u0438" },
            { "Tale", "\u0422\u0430\u043b\u0435" },
            { "Talu", "\u0422\u0430\u043b\u0443" },
            { "Taml", metaValue_ta },
            { "Tang", "\u0422\u0430\u043d\u0433\u0443\u0442" },
            { "Tavt", "\u0422\u0430\u0439 \u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "Telu", metaValue_te },
            { "Tfng", "\u0422\u0438\u0444\u0438\u043d\u0430\u0433 \u0431\u0438\u0447\u0438\u0433" },
            { "Tglg", "\u0422\u0430\u0433\u0430\u043b\u043e\u0433" },
            { "Thaa", "\u0442\u0430\u043d\u0430" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "\u0422\u0438\u0440\u0445\u0443\u0442\u0430" },
            { "Tnsa", "\u0422\u0430\u043d\u0433\u0441\u0430" },
            { "Toto", "\u0422\u043e\u0442\u043e" },
            { "Ugar", "\u0423\u0433\u0430\u0440\u0438\u0442\u0438\u043a" },
            { "Vaii", "\u0412\u0430\u0438 \u0431\u0438\u0447\u0438\u0433" },
            { "Vith", "\u0412\u0438\u0442\u043a\u0443\u043a\u0438" },
            { "Wara", "\u0412\u0430\u0440\u0430\u043d\u0433 \u041a\u0448\u0438\u0442\u0438" },
            { "Wcho", "\u0412\u0430\u043d\u0447\u0443" },
            { "Xpeo", "\u0425\u0443\u0443\u0447\u0438\u043d \u043f\u0435\u0440\u0441" },
            { "Xsux", "\u0421\u0443\u043c\u0435\u0440\u043e-\u0410\u043a\u043a\u0430\u0434\u0438\u0430\u043d \u0448\u0430\u0430\u043d\u0442\u0430\u0433 \u0431\u0438\u0447\u0438\u0433" },
            { "Yezi", "\u0415\u0437\u0438\u0434\u0438" },
            { "Yiii", "\u0418 \u0431\u0438\u0447\u0438\u0433" },
            { "Zanb", "\u0417\u0430\u043d\u0430\u0431\u0430\u0437\u0430\u0440\u044b\u043d \u0434\u04e9\u0440\u0432\u04e9\u043b\u0436\u0438\u043d \u0431\u0438\u0447\u0438\u0433" },
            { "Zinh", "\u0417\u0438\u043d\u0445" },
            { "Zmth", "\u043c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u043a \u0442\u043e\u043e\u043b\u043b\u044b\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "Zsye", "\u044d\u043c\u043e\u0436\u0438" },
            { "Zsym", "\u0442\u044d\u043c\u0434\u044d\u0433" },
            { "Zxxx", "\u0431\u0438\u0447\u0438\u0433\u0434\u044d\u044d\u0433\u04af\u0439" },
            { "Zyyy", "\u043d\u0438\u0439\u0442\u043b\u044d\u0433" },
            { "Zzzz", "\u0442\u043e\u0434\u043e\u0440\u0445\u043e\u0439\u0433\u04af\u0439 \u0431\u0438\u0447\u0438\u0433" },
            { "de_AT", "\u0430\u0432\u0441\u0442\u0440\u0438-\u0433\u0435\u0440\u043c\u0430\u043d" },
            { "de_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u044c-\u0433\u0435\u0440\u043c\u0430\u043d" },
            { "en_AU", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438-\u0430\u043d\u0433\u043b\u0438" },
            { "en_CA", "\u043a\u0430\u043d\u0430\u0434-\u0430\u043d\u0433\u043b\u0438" },
            { "en_GB", "\u0431\u0440\u0438\u0442\u0430\u043d\u0438-\u0430\u043d\u0433\u043b\u0438" },
            { "en_US", "\u0430\u043c\u0435\u0440\u0438\u043a-\u0430\u043d\u0433\u043b\u0438" },
            { "es_ES", "\u0438\u0441\u043f\u0430\u043d\u0438 \u0445\u044d\u043b (\u0415\u0432\u0440\u043e\u043f)" },
            { "es_MX", "\u0438\u0441\u043f\u0430\u043d\u0438 \u0445\u044d\u043b (\u041c\u0435\u043a\u0441\u0438\u043a)" },
            { "fr_CA", "\u043a\u0430\u043d\u0430\u0434-\u0444\u0440\u0430\u043d\u0446" },
            { "fr_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438-\u0444\u0440\u0430\u043d\u0446" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434" },
            { "pt_BR", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b \u0445\u044d\u043b (\u0411\u0440\u0430\u0437\u0438\u043b)" },
            { "pt_PT", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b \u0445\u044d\u043b (\u0415\u0432\u0440\u043e\u043f)" },
            { "ro_MD", "\u043c\u043e\u043b\u0434\u0430\u0432" },
            { "sw_CD", "\u043a\u043e\u043d\u0433\u043e\u0433\u0438\u0439\u043d \u0441\u0432\u0430\u0445\u0438\u043b\u0438" },
            { "ar_001", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0430\u0440\u0430\u0431" },
            { "es_419", "\u0438\u0441\u043f\u0430\u043d\u0438 \u0445\u044d\u043b (\u041b\u0430\u0442\u0438\u043d \u0410\u043c\u0435\u0440\u0438\u043a)" },
            { "key.ca", "\u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "key.cf", "\u043c\u04e9\u043d\u0433\u04e9\u043d \u0442\u044d\u043c\u0434\u044d\u0433\u0442\u0438\u0439\u043d \u0445\u044d\u043b\u0431\u044d\u0440" },
            { "key.co", "\u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "key.cu", "\u043c\u04e9\u043d\u0433\u04e9\u043d \u0442\u044d\u043c\u0434\u044d\u0433\u0442" },
            { "key.hc", "\u0446\u0430\u0433\u0438\u0439\u043d \u043c\u04e9\u0447\u043b\u04e9\u0433 (12 \u044d\u0441\u0432\u044d\u043b 24)" },
            { "key.lb", "\u043c\u04e9\u0440\u0438\u0439\u043d \u0437\u0430\u0439\u043d \u0437\u0430\u0433\u0432\u0430\u0440" },
            { "key.ms", "\u043d\u044d\u0433\u0436\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "key.nu", "\u0442\u043e\u043e" },
            { "zh_Hans", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d \u0445\u044f\u0442\u0430\u0434" },
            { "zh_Hant", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0445\u044f\u0442\u0430\u0434" },
            { "type.ca.roc", "\u043c\u0438\u043d\u0433\u043e \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.co.eor", "\u0415\u0432\u0440\u043e\u043f\u0438\u0439\u043d \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u04af\u0440\u044d\u043c" },
            { "type.hc.h11", "12 \u0446\u0430\u0433\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c (0\u201311)" },
            { "type.hc.h12", "12 \u0446\u0430\u0433\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c (1\u201312)" },
            { "type.hc.h23", "24 \u0446\u0430\u0433\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c (0\u201323)" },
            { "type.hc.h24", "24 \u0446\u0430\u0433\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c (1\u201324)" },
            { "type.nu.ahom", "\u0410\u0445\u043e\u043c \u0442\u043e\u043e" },
            { "type.nu.arab", "\u0430\u0440\u0430\u0431-\u044d\u043d\u044d\u0442\u0445\u044d\u0433 \u0442\u043e\u043e" },
            { "type.nu.armn", "\u0430\u0440\u043c\u0435\u043d \u0442\u043e\u043e" },
            { "type.nu.bali", "\u0411\u0430\u043b\u0438 \u0442\u043e\u043e" },
            { "type.nu.beng", "\u0431\u0435\u043d\u0433\u0430\u043b \u0442\u043e\u043e" },
            { "type.nu.brah", "\u0411\u0440\u0430\u0445\u043c\u0438 \u0442\u043e\u043e" },
            { "type.nu.cakm", "\u0447\u0430\u043a\u043c\u0430 \u0442\u043e\u043e" },
            { "type.nu.cham", "\u0427\u0430\u043c \u0442\u043e\u043e" },
            { "type.nu.cyrl", "\u041a\u0438\u0440\u0438\u043b\u043b \u0442\u043e\u043e" },
            { "type.nu.deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438 \u0442\u043e\u043e" },
            { "type.nu.diak", "\u0414\u0438\u0432\u044d\u0441 \u0410\u043a\u04af\u0440\u04af \u0422\u043e\u043e" },
            { "type.nu.ethi", "\u044d\u0442\u0438\u043e\u043f \u0442\u043e\u043e" },
            { "type.nu.geor", "\u0433\u04af\u0440\u0436 \u0442\u043e\u043e" },
            { "type.nu.gong", "\u0413\u0443\u043d\u0436\u0430\u043b\u0430 \u0413\u043e\u043d\u0434\u0438 \u0442\u043e\u043e" },
            { "type.nu.gonm", "\u041c\u0430\u0441\u0430\u0440\u0430\u043c \u0413\u043e\u043d\u0434\u0438 \u0442\u043e\u043e" },
            { "type.nu.grek", "\u0433\u0440\u0435\u043a \u0442\u043e\u043e" },
            { "type.nu.gujr", "\u0433\u04af\u0436\u0430\u0440\u0430\u0442\u0438 \u0442\u043e\u043e" },
            { "type.nu.guru", "\u0433\u04af\u0440\u043c\u04af\u0445\u0438 \u0442\u043e\u043e" },
            { "type.nu.hans", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d \u0445\u044f\u0442\u0430\u0434 \u0442\u043e\u043e" },
            { "type.nu.hant", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0445\u044f\u0442\u0430\u0434 \u0442\u043e\u043e" },
            { "type.nu.hebr", "\u0435\u0432\u0440\u0435\u0439 \u0442\u043e\u043e" },
            { "type.nu.hmng", "\u041f\u0430\u0445\u0430\u0432 \u0425\u043c\u043e\u043d\u0433 \u0442\u043e\u043e" },
            { "type.nu.hmnp", "\u041d\u044f\u0430\u043a\u0435\u043d\u0433 \u041f\u0443\u0430\u0447\u044d \u0425\u043c\u043e\u043d\u0433 \u0442\u043e\u043e" },
            { "type.nu.java", "\u0436\u0430\u0432\u0430 \u0442\u043e\u043e" },
            { "type.nu.jpan", "\u044f\u043f\u043e\u043d \u0442\u043e\u043e" },
            { "type.nu.kali", "\u041a\u0430\u044f\u0430 \u041b\u0438 \u0442\u043e\u043e" },
            { "type.nu.kawi", "\u041a\u0430\u0432\u0438 \u0442\u043e\u043e" },
            { "type.nu.khmr", "\u043a\u0445\u043c\u0435\u0440 \u0442\u043e\u043e" },
            { "type.nu.knda", "\u043a\u0430\u043d\u043d\u0430\u0434\u0430 \u0442\u043e\u043e" },
            { "type.nu.lana", "\u0422\u0430\u0439 \u0422\u0430\u043c \u0425\u043e\u0440\u0430 \u0442\u043e\u043e" },
            { "type.nu.laoo", "\u043b\u0430\u043e\u0441 \u0442\u043e\u043e" },
            { "type.nu.latn", "\u0430\u0440\u0430\u0431 \u0442\u043e\u043e" },
            { "type.nu.lepc", "\u041b\u0435\u043f\u0447\u0430 \u0442\u043e\u043e" },
            { "type.nu.limb", "\u041b\u0438\u043c\u0431\u0443 \u0442\u043e\u043e" },
            { "type.nu.mlym", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c \u0442\u043e\u043e" },
            { "type.nu.modi", "\u041c\u043e\u0434\u0438 \u0442\u043e\u043e" },
            { "type.nu.mong", "\u043c\u043e\u043d\u0433\u043e\u043b \u0442\u043e\u043e" },
            { "type.nu.mroo", "\u041c\u0440\u043e \u0442\u043e\u043e" },
            { "type.nu.mtei", "\u043c\u0435\u0439\u0442\u0435\u0439 \u043c\u0430\u0435\u043a \u0442\u043e\u043e" },
            { "type.nu.mymr", "\u043c\u044c\u044f\u043d\u043c\u0430\u0440 \u0442\u043e\u043e" },
            { "type.nu.nagm", "\u041d\u0430\u0433 \u041c\u0443\u043d\u0434\u0430\u0440\u0438 \u0442\u043e\u043e" },
            { "type.nu.nkoo", "N\u2019Ko \u0442\u043e\u043e" },
            { "type.nu.olck", "\u043e\u043b \u0447\u0438\u043a\u0438 \u0442\u043e\u043e" },
            { "type.nu.orya", "\u043e\u0440\u0438\u044f \u0442\u043e\u043e" },
            { "type.nu.osma", "\u041e\u0441\u043c\u0430\u043d\u0438 \u0442\u043e\u043e" },
            { "type.nu.rohg", "\u0425\u0430\u043d\u0438\u0444\u0438 \u0420\u043e\u0445\u0438\u043d\u0436 \u0442\u043e\u043e" },
            { "type.nu.saur", "\u0421\u0430\u0443\u0440\u0430\u0448\u0442\u0440\u0430 \u0442\u043e\u043e" },
            { "type.nu.shrd", "\u0428\u0430\u0440\u0430\u0434\u0430 \u0442\u043e\u043e" },
            { "type.nu.sind", "\u041a\u04af\u0434\u0430\u0432\u0430\u0434\u0438 \u0442\u043e\u043e" },
            { "type.nu.sinh", "\u0421\u0438\u043d\u0445\u0430\u043b\u0430 \u041b\u0438\u0442 \u0442\u043e\u043e" },
            { "type.nu.sora", "\u0421\u043e\u0440\u0430 \u0421\u043e\u043c\u043f\u0435\u043d\u0433 \u0442\u043e\u043e" },
            { "type.nu.sund", "\u0421\u0443\u043d\u0434\u0430\u043d \u0442\u043e\u043e" },
            { "type.nu.takr", "\u0422\u0430\u043a\u0440\u0438 \u0442\u043e\u043e" },
            { "type.nu.talu", "\u0428\u0438\u043d\u044d \u0442\u0430\u0439 \u043b\u0443\u044d \u0442\u043e\u043e" },
            { "type.nu.taml", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0442\u0430\u043c\u0438\u043b \u0442\u043e\u043e" },
            { "type.nu.telu", "\u0442\u044d\u043b\u04af\u0433\u04af \u0442\u043e\u043e" },
            { "type.nu.thai", "\u0442\u0430\u0439 \u0442\u043e\u043e" },
            { "type.nu.tibt", "\u0442\u04e9\u0432\u0434 \u0442\u043e\u043e" },
            { "type.nu.tirh", "\u0422\u0438\u0440\u0445\u0443\u0442\u0430 \u0442\u043e\u043e" },
            { "type.nu.tnsa", "\u0422\u0430\u043d\u0433\u0441\u0430 \u0442\u043e\u043e" },
            { "type.nu.vaii", "\u0432\u0430\u0439 \u0442\u043e\u043e" },
            { "type.nu.wara", "\u0412\u0430\u0440\u0430\u043d\u0433 \u0441\u0438\u0442\u0438 \u0442\u043e\u043e" },
            { "type.nu.wcho", "\u0412\u0430\u043d\u0447\u043e \u0442\u043e\u043e" },
            { "type.ca.dangi", "\u0434\u0430\u043d\u0433\u0438 \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.co.ducet", "\u044e\u043d\u0438\u043a\u043e\u0434\u044b\u043d \u04af\u043d\u0434\u0441\u044d\u043d \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "type.co.emoji", "\u042d\u043c\u043e\u0436\u0438 \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "type.lb.loose", "\u0443\u0440\u0442 \u043c\u04e9\u0440\u0438\u0439\u043d \u0437\u0430\u0439\u043d \u0437\u0430\u0433\u0432\u0430\u0440" },
            { "type.nu.roman", "\u0440\u043e\u043c \u0442\u043e\u043e" },
            { "type.ca.coptic", "\u043a\u043e\u043f\u0442\u0438\u043a \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.ca.hebrew", "\u0435\u0432\u0440\u0435\u0439 \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.ca.indian", "\u044d\u043d\u044d\u0442\u0445\u044d\u0433\u0438\u0439\u043d \u04af\u043d\u0434\u044d\u0441\u043d\u0438\u0439 \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.co.compat", "\u041d\u0438\u0439\u0446\u043b\u0438\u0439\u043d \u04af\u04af\u0434\u043d\u044d\u044d\u0441 \u04e9\u043c\u043d\u04e9\u0445 \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "type.co.pinyin", "\u041f\u0438\u043d\u044c\u044f\u043d \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "type.co.search", "\u0435\u0440\u04e9\u043d\u0445\u0438\u0439 \u0445\u0430\u0439\u043b\u0442" },
            { "type.co.unihan", "\u042f\u0437\u0433\u0443\u0443\u0440\u044b\u043d \u0437\u0443\u0440\u0430\u0430\u0441\u043d\u044b \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "type.co.zhuyin", "\u0416\u04af\u044f\u0438\u043d \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "type.lb.normal", "\u044d\u043d\u0433\u0438\u0439\u043d \u043c\u04e9\u0440\u0438\u0439\u043d \u0437\u0430\u0439\u043d \u0437\u0430\u0433\u0432\u0430\u0440" },
            { "type.lb.strict", "\u0448\u0443\u043b\u0443\u0443\u043d \u043c\u04e9\u0440\u0438\u0439\u043d \u0437\u0430\u0439\u043d \u0437\u0430\u0433\u0432\u0430\u0440" },
            { "type.ms.metric", "\u043c\u0435\u0442\u0440\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "type.ca.chinese", "\u0445\u044f\u0442\u0430\u0434 \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.ca.islamic", "\u0438\u0441\u043b\u0430\u043c\u044b\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.ca.iso8601", "ISO-8601 \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.ca.persian", "\u043f\u0435\u0440\u0441 \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.cf.account", "\u043c\u04e9\u043d\u0433\u04e9\u043d \u0442\u044d\u043c\u0434\u044d\u0433\u0442\u0438\u0439\u043d \u043d\u044f\u0433\u0442\u043b\u0430\u043d \u0431\u043e\u0434\u043e\u0445 \u0431\u04af\u0440\u0442\u0433\u044d\u043b\u0438\u0439\u043d \u0445\u044d\u043b\u0431\u044d\u0440" },
            { "type.co.big5han", "\u0425\u0443\u0443\u0447\u0438\u043d \u0445\u044f\u0442\u0430\u0434 \u042d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b - \u0422\u043e\u043c5" },
            { "type.nu.arabext", "\u04e9\u0440\u0433\u04e9\u0442\u0433\u04e9\u0441\u04e9\u043d \u0430\u0440\u0430\u0431-\u044d\u043d\u044d\u0442\u0445\u044d\u0433 \u0442\u043e\u043e" },
            { "type.nu.armnlow", "\u0436\u0438\u0436\u0438\u0433 \u0430\u0440\u043c\u0435\u043d \u0442\u043e\u043e" },
            { "type.nu.greklow", "\u0436\u0438\u0436\u0438\u0433 \u0433\u0440\u0435\u043a \u0442\u043e\u043e" },
            { "type.nu.hanidec", "\u0445\u044f\u0442\u0430\u0434 \u0430\u0440\u0430\u0432\u0442\u044b\u043d \u0442\u043e\u043e" },
            { "type.nu.hansfin", "\u0445\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d \u0445\u044f\u0442\u0430\u0434 \u0441\u0430\u043d\u0445\u04af\u04af\u0433\u0438\u0439\u043d \u0442\u043e\u043e" },
            { "type.nu.hantfin", "\u0443\u043b\u0430\u043c\u0436\u043b\u0430\u043b\u0442 \u0445\u044f\u0442\u0430\u0434 \u0441\u0430\u043d\u0445\u04af\u04af\u0433\u0438\u0439\u043d \u0442\u043e\u043e" },
            { "type.nu.jpanfin", "\u044f\u043f\u043e\u043d \u0441\u0430\u043d\u0445\u04af\u04af\u0433\u0438\u0439\u043d \u0442\u043e\u043e" },
            { "type.nu.mathdbl", "\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u043a\u0438\u0439\u043d \u0445\u043e\u0441 \u0437\u0443\u0440\u043b\u0430\u0433\u0430\u0442 \u0442\u043e\u043e" },
            { "type.nu.tamldec", "\u0442\u0430\u043c\u0438\u043b \u0442\u043e\u043e" },
            { "type.ca.buddhist", "\u0431\u0443\u0434\u0434\u044b\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.ca.ethiopic", metaValue_type_ca_ethiopic },
            { "type.ca.japanese", "\u044f\u043f\u043e\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.cf.standard", "\u043c\u04e9\u043d\u0433\u04e9\u043d \u0442\u044d\u043c\u0434\u044d\u0433\u0442\u0438\u0439\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u0445\u044d\u043b\u0431\u044d\u0440" },
            { "type.co.reformed", "\u0428\u0438\u043d\u044d\u0447\u0438\u043b\u0441\u044d\u043d \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "type.co.searchjl", "\u0425\u0430\u043d\u0433\u04af\u043b\u044d\u044d\u0440 \u044d\u0445\u043d\u0438\u0439 \u0433\u0438\u0439\u0433\u04af\u04af\u043b\u044d\u0433\u0447\u044d\u044d\u0440 \u0445\u0430\u0439\u0445" },
            { "type.co.standard", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442 \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "type.ms.uksystem", "\u0410\u043d\u0433\u043b\u0438 \u043d\u044d\u0433\u0436\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "type.ms.ussystem", "\u0410\u043c\u0435\u0440\u0438\u043a \u043d\u044d\u0433\u0436\u0438\u0439\u043d \u0441\u0438\u0441\u0442\u0435\u043c" },
            { "type.nu.fullwide", "\u0431\u04af\u0442\u044d\u043d-\u04e9\u0440\u0433\u04e9\u043d\u0442\u044d\u0439 \u0442\u043e\u043e" },
            { "type.nu.lanatham", "\u0422\u0430\u0439 \u0422\u0430\u043c \u0422\u0430\u043c \u0442\u043e\u043e" },
            { "type.nu.mathbold", "\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u043a\u0438\u0439\u043d \u0431\u04af\u0434\u04af\u04af\u043d \u0442\u043e\u043e" },
            { "type.nu.mathmono", "\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u043a\u0438\u0439\u043d Monospace \u0442\u043e\u043e" },
            { "type.nu.mathsanb", "\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u043a\u0438\u0439\u043d Sans-Serif \u0411\u04af\u0434\u04af\u04af\u043d \u0442\u043e\u043e" },
            { "type.nu.mathsans", "\u041c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u043a\u0438\u0439\u043d Sans-Serif \u0442\u043e\u043e" },
            { "type.nu.mymrshan", "\u041c\u044c\u044f\u043d\u043c\u0430\u0440 \u0428\u0430\u043d \u0442\u043e\u043e" },
            { "type.nu.mymrtlng", "\u041c\u044c\u044f\u043d\u043c\u0430\u0440 \u0422\u0430\u0439 \u041b\u0430\u0439\u043d\u0433 \u0442\u043e\u043e" },
            { "type.nu.romanlow", "\u0436\u0438\u0436\u0438\u0433 \u0440\u043e\u043c \u0442\u043e\u043e" },
            { "type.ca.gregorian", "\u0433\u0440\u0435\u0433\u043e\u0440\u0438\u0439\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440" },
            { "type.co.gb2312han", "\u0425\u044f\u043b\u0431\u0430\u0440\u0448\u0443\u0443\u043b\u0441\u0430\u043d \u0445\u044f\u0442\u0430\u0434 \u042d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b - GB2312" },
            { "type.co.phonebook", "\u0423\u0442\u0430\u0441\u043d\u044b \u0434\u044d\u0432\u0442\u0440\u0438\u0439\u043d \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "type.co.dictionary", "\u0422\u043e\u043b\u044c\u043d\u044b \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "type.co.traditional", "\u0425\u0443\u0443\u0447\u0438\u043d \u044d\u0440\u044d\u043c\u0431\u044d\u043b\u044d\u0445 \u0434\u0430\u0440\u0430\u0430\u043b\u0430\u043b" },
            { "type.ca.islamic-rgsa", "\u0438\u0441\u043b\u0430\u043c\u0438\u0439\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440 (\u0441\u0430\u0443\u0434\u044b\u043d \u0430\u0440\u0430\u0431, \u0433\u0430\u0437\u0430\u0440\u0437\u04af\u0439\u043d)" },
            { "type.ca.islamic-tbla", "\u0438\u0441\u043b\u0430\u043c\u0438\u0439\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440 (\u0445\u04af\u0441\u043d\u044d\u0433\u0442\u044d\u043d, \u043e\u0434\u043e\u043d \u043e\u0440\u043d\u044b \u044d\u0440\u0438\u043d)" },
            { "type.ca.islamic-civil", "\u0438\u0441\u043b\u0430\u043c\u044b\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440 (tabular, civil epoch)" },
            { "type.ca.islamic-umalqura", "\u0438\u0441\u043b\u0430\u043c\u044b\u043d \u0446\u0430\u0433\u043b\u0430\u0432\u0430\u0440 (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", metaValue_type_ca_ethiopic },
        };
        return data;
    }
}
