/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_brx extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u0906\u0930\u093e\u092c\u093f\u0915";
        final String metaValue_hy = "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0928";
        final String metaValue_ae = "\u0905\u0935\u0938\u094d\u0924\u0928\u094d";
        final String metaValue_bn = "\u092c\u093e\u0902\u0932\u093e";
        final String metaValue_ccp = "\u091a\u093e\u0915\u092e\u093e";
        final String metaValue_ka = "\u091c\u0930\u094d\u091c\u093f\u092f\u093e\u0928";
        final String metaValue_el = "\u0917\u094d\u0930\u0940\u0915";
        final String metaValue_gu = "\u0917\u0941\u091c\u0930\u093e\u0924\u0940";
        final String metaValue_ja = "\u091c\u093e\u092a\u093e\u0928\u0940\u091c";
        final String metaValue_km = "\u0916\u094d\u092e\u0947\u0930";
        final String metaValue_la = "\u0932\u0947\u091f\u0940\u0928";
        final String metaValue_mn = "\u092e\u0902\u0917\u0932\u093f\u092f\u093e\u0928";
        final String metaValue_MM = "\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930";
        final String metaValue_nqo = "\u0928\u0902\u0915\u2019";
        final String metaValue_ta = "\u0924\u093e\u092e\u093f\u0932";
        final String metaValue_te = "\u0924\u0947\u0932\u0941\u0917\u0941";
        final String metaValue_th = "\u0925\u093e\u0908";
        final String metaValue_vai = "\u092d\u093e\u0908";
        final Object[][] data = new Object[][] {
            { "001", "\u092c\u0941\u0939\u0941\u092e" },
            { "002", "\u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "003", "\u0938\u093e\u0939\u093e \u0906\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "005", "\u0916\u094b\u0932\u093e \u0906\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "009", "\u0913\u0936\u0947\u0906\u0928\u093f\u092f\u093e" },
            { "011", "\u0938\u094b\u0928\u093e\u092c\u093e\u0930\u093f \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "013", "\u092e\u093f\u0930\u0941 \u0906\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "014", "\u0938\u093e\u0928\u091c\u093e\u092f\u093e\u0930\u093f \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "015", "\u0938\u093e\u0939\u093e\u092f\u093e\u0930\u093f \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "017", "\u0917\u0947\u091c\u0947\u0930\u093e\u0930\u093f \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "018", "\u0916\u094b\u0932\u093e\u092f\u093e\u0930\u093f \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "019", "\u0906\u092e\u0947\u0930\u093f\u0915\u093e\u0928\u093f" },
            { "021", "\u0938\u093e\u0939\u093e\u092f\u093e\u0930\u093f \u0906\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "029", "\u0915\u0947\u0930\u093f\u092c\u093f\u092f\u093e\u0928" },
            { "030", "\u0938\u093e\u0928\u091c\u093e\u092f\u093e\u0930\u093f \u090f\u0938\u093f\u092f\u093e" },
            { "034", "\u0916\u094b\u0932\u093e\u092f\u093e\u0930\u093f \u090f\u0938\u093f\u092f\u093e" },
            { "035", "\u0916\u094b\u0932\u093e-\u0938\u093e\u0928\u091c\u093e \u090f\u0938\u093f\u092f\u093e" },
            { "039", "\u0916\u094b\u0932\u093e\u092f\u093e\u0930\u093f \u092f\u0942\u0930\u094b\u092a" },
            { "053", "\u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u090f\u0938\u093f\u092f\u093e" },
            { "054", "\u092e\u0947\u0932\u093e\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "057", "\u092e\u093e\u0908\u0915\u094d\u0930\u2019\u0928\u0947\u0938\u093f\u092f\u093e\u092f\u093e\u0930\u093f \u0913\u0928\u0938\u094b\u0932" },
            { "061", "\u092a\u0932\u093f\u0928\u0947\u0938\u093f\u092f\u093e" },
            { "142", "\u090f\u0938\u093f\u092f\u093e" },
            { "143", "\u092e\u093f\u0930\u0941 \u090f\u0938\u093f\u092f\u093e" },
            { "145", "\u0938\u094b\u0928\u093e\u092c\u093e\u0930\u093f \u090f\u0938\u093f\u092f\u093e" },
            { "150", "\u092f\u0942\u0930\u094b\u092a" },
            { "151", "\u0938\u093e\u0928\u091c\u093e\u092f\u093e\u0930\u093f \u092f\u0942\u0930\u094b\u092a" },
            { "154", "\u0938\u093e\u0939\u093e\u092f\u093e\u0930\u093f \u092f\u0942\u0930\u094b\u092a" },
            { "155", "\u0938\u094b\u0928\u093e\u092c\u093e\u0930\u093f \u092f\u0942\u0930\u094b\u092a" },
            { "202", "\u0938\u093e\u0939\u093e\u0930\u093e\u092f\u093e\u0930\u093f \u0932\u094b\u092c\u094d\u092c\u093e \u0917\u094b\u0928\u093e\u0902 \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "419", "\u0932\u0947\u091f\u0940\u0928 \u0906\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "AC", "\u090f\u0938\u0947\u0928\u0938\u093f\u0905\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "AD", "\u090f\u0928\u094d\u0921\u0930\u094d\u0930\u093e" },
            { "AE", "\u091c\u0925\u093e\u092f \u0906\u0930\u093e\u092c \u090f\u092e\u093f\u0930\u0947\u0924" },
            { "AF", "\u0906\u092b\u0917\u093e\u0928\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "AG", "\u090f\u0928\u094d\u091f\u093f\u0917\u0941\u0906 \u0906\u0930\u094b \u092c\u093e\u0930\u092c\u0941\u0921\u093e" },
            { "AI", "\u090f\u0902\u0917\u0941\u0907\u0932\u094d\u0932\u093e" },
            { "AL", "\u0906\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e" },
            { "AM", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e" },
            { "AO", "\u0906\u0902\u0917\u0932\u093e" },
            { "AQ", "\u090f\u0928\u094d\u091f\u093e\u0930\u094d\u0915\u091f\u093f\u0915\u093e" },
            { "AR", "\u0906\u0930\u094d\u091c\u0947\u0928\u094d\u091f\u093f\u0928\u093e" },
            { "AS", "\u0906\u092e\u0947\u0930\u093f\u0915\u093e\u0928 \u0938\u093e\u092e\u0906" },
            { "AT", "\u0905\u0938\u094d\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "AU", "\u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e" },
            { "AW", "\u0906\u0930\u0942\u092c\u093e" },
            { "AX", "\u0906\u0932\u093e\u0923\u094d\u0921 \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "AZ", "\u0906\u091c\u0947\u0930\u092c\u093e\u0908\u091c\u093e\u0928" },
            { "BA", "\u092c\u0938\u0928\u093f\u092f\u093e \u0906\u0930\u094b \u0939\u094b\u0930\u094d\u091c\u0947\u0917\u092d\u093f\u0928\u093e" },
            { "BB", "\u092c\u093e\u0930\u092c\u093e\u0921\u2019\u0938" },
            { "BD", "\u092c\u093e\u0902\u0932\u093e\u0926\u0947\u0936" },
            { "BE", "\u092c\u0947\u0932\u091c\u093f\u092f\u093e\u092e" },
            { "BF", "\u092c\u0941\u0930\u094d\u0915\u093f\u0928\u093e \u092b\u093e\u0938\u2019" },
            { "BG", "\u092c\u0941\u0932\u094d\u0917\u093e\u0930\u093f\u092f\u093e" },
            { "BH", "\u092c\u093e\u0939\u0930\u0948\u0928" },
            { "BI", "\u092c\u0941\u0930\u0942\u0923\u094d\u0921\u0940" },
            { "BJ", "\u092c\u0947\u0928\u093f\u0928" },
            { "BL", "\u0938\u0948\u0928\u094d\u091f \u092c\u093e\u0930\u094d\u0925\u0947\u0932\u0947\u092e\u0940" },
            { "BM", "\u092c\u093e\u0930\u092e\u0942\u0921\u093e" },
            { "BN", "\u092c\u094d\u0930\u0942\u0928\u0947" },
            { "BO", "\u092c\u0932\u093f\u092d\u093f\u092f\u093e" },
            { "BQ", "\u0915\u0947\u0930\u093f\u092c\u093f\u092f\u093e\u0928 \u0928\u0947\u0926\u093e\u0930\u0932\u0947\u0923\u094d\u0921\u0938" },
            { "BR", "\u092c\u094d\u0930\u093e\u091c\u0940\u0932" },
            { "BS", "\u092c\u093e\u0939\u093e\u092e\u093e\u0938" },
            { "BT", "\u092d\u0942\u091f\u093e\u0928" },
            { "BV", "\u092c\u0942\u092d\u0947\u091f \u0926\u094d\u0935\u0940\u092a" },
            { "BW", "\u092c\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "BY", "\u092c\u0947\u0932\u093e\u0930\u0942\u0938" },
            { "BZ", "\u092c\u0947\u0932\u093f\u091c" },
            { "CA", "\u0915\u0947\u0928\u093e\u0921\u093e" },
            { "CC", "\u0915\u0915\u2019\u0938 \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "CD", "\u0915\u0902\u0917\u2019-\u0915\u093f\u0928\u0936\u093e\u0938\u093e" },
            { "CF", "\u092e\u093f\u0930\u0941 \u0906\u092b\u094d\u0930\u093f\u0915\u093e \u0938\u0941\u092c\u0941\u0902\u0916\u0941\u0902\u0925\u093e\u092f" },
            { "CG", "\u0915\u0902\u0917\u2019- \u092c\u094d\u0930\u093e\u091c\u094d\u091c\u093e\u092d\u0940\u0932" },
            { "CH", "\u0938\u0941\u0908\u091c\u093e\u0930\u0932\u0947\u0923\u094d\u0921" },
            { "CI", "\u0915\u091f \u0926\u093f\u092d\u0935\u0947\u0930" },
            { "CK", "\u0915\u0941\u0915 \u0926\u094d\u0935\u0940\u092a" },
            { "CL", "\u091a\u093f\u0932\u0947" },
            { "CM", "\u0915\u0947\u092e\u0947\u0930\u0942\u0928" },
            { "CN", "\u091a\u093e\u0907\u0928\u093e" },
            { "CO", "\u0915\u0932\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "CP", "\u0915\u094d\u0932\u093f\u092a\u094d\u092a\u093e\u0930\u094d\u091f\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "CR", "\u0915\u0938\u094d\u091f\u093e \u0930\u093f\u0915\u093e" },
            { "CU", "\u0915\u094d\u092f\u0942\u092c\u093e" },
            { "CV", "\u0915\u0947\u092a \u092d\u0947\u0930\u094d\u0926\u0947" },
            { "CW", "\u0915\u0941\u0930\u093e\u0938\u093e\u0935" },
            { "CX", "\u0916\u094d\u0930\u093f\u0938\u092e\u093e\u0938 \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "CY", "\u0938\u093e\u0907\u092a\u094d\u0930\u093e\u0938" },
            { "CZ", "\u091a\u0947\u0916\u093f\u092f\u093e" },
            { "DE", "\u091c\u093e\u0930\u094d\u092e\u093e\u0928\u0940" },
            { "DG", "\u0926\u093f\u092f\u0947\u0917\u2019 \u0917\u093e\u0930\u094d\u0938\u093f\u092f\u093e" },
            { "DJ", "\u091c\u093f\u092c\u094c\u0924\u093f" },
            { "DK", "\u0921\u0947\u0928\u092e\u093e\u0930\u094d\u0915" },
            { "DM", "\u0926\u092e\u093f\u0928\u093f\u0915\u093e" },
            { "DO", "\u0926\u092e\u093f\u0928\u093f\u0915\u093e\u0928 \u0938\u0941\u092c\u0941\u0902\u0916\u0941\u0902\u0925\u093e\u092f" },
            { "DZ", "\u0906\u0932\u094d\u091c\u0947\u0930\u093f\u092f\u093e" },
            { "EA", "\u0915\u093f\u0909\u0924\u093e \u0906\u0930\u094b \u092e\u0947\u0932\u093f\u0932\u094d\u0932\u093e" },
            { "EC", "\u090f\u0915\u094d\u0935\u093e\u0921\u2019\u0930" },
            { "EE", "\u090f\u0938\u094d\u091f\u2019\u0928\u093f\u092f\u093e" },
            { "EG", "\u0908\u091c\u093f\u092a\u094d\u0924" },
            { "EH", "\u0938\u094b\u0928\u093e\u092c\u093e\u0930\u093f \u0938\u093e\u0939\u093e\u0930\u093e" },
            { "ER", "\u090f\u0930\u093f\u091f\u094d\u0930\u093f\u092f\u093e" },
            { "ES", "\u0938\u094d\u092a\u0948\u0928" },
            { "ET", "\u0907\u0925\u093f\u092f\u2019\u092a\u093f\u092f\u093e" },
            { "EU", "\u092f\u0942\u0930\u094b\u092a\u0928\u093f \u091c\u0925\u093e\u092f" },
            { "EZ", "\u092f\u0942\u0930\u094b \u0913\u0928\u0938\u094b\u0932" },
            { "FI", "\u092b\u093f\u0928\u0932\u0947\u0923\u094d\u0921" },
            { "FJ", "\u092b\u093f\u091c\u0940" },
            { "FK", "\u092b\u0915\u0932\u0947\u0923\u094d\u0921 \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "FM", "\u092e\u093e\u0907\u0915\u094d\u0930\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "FO", "\u092b\u0947\u0930\u2019 \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "FR", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938" },
            { "GA", "\u0917\u093e\u092c\u0928" },
            { "GB", "\u091c\u0925\u093e\u092f \u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0939\u093e\u0926\u094b\u0930" },
            { "GD", "\u0917\u094d\u0930\u0947\u0928\u093e\u0926\u093e" },
            { "GE", "\u091c\u0930\u094d\u091c\u093f\u092f\u093e" },
            { "GF", "\u092b\u094d\u0930\u0947\u0928\u094d\u091a \u0917\u093f\u0906\u0928\u093e" },
            { "GG", "\u0917\u094b\u0930\u094d\u0928\u0938\u093f" },
            { "GH", "\u0918\u093e\u0928\u093e" },
            { "GI", "\u091c\u093f\u092c\u094d\u0930\u093e\u0932\u094d\u091f\u093e\u0930" },
            { "GL", "\u0917\u094d\u0930\u0940\u0928\u0932\u0947\u0923\u094d\u0921" },
            { "GM", "\u0917\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "GN", "\u0917\u093f\u0928\u0940\u092f\u093e" },
            { "GP", "\u0917\u094d\u0935\u093e\u0926\u0947\u0932\u094d\u092f\u0942\u092a" },
            { "GQ", "\u092c\u093f\u0938\u0941\u092c\u093e\u0930\u093f \u0917\u093f\u0928\u0940\u092f\u093e" },
            { "GR", "\u0917\u094d\u0930\u0940\u0938" },
            { "GS", "\u0916\u094b\u0932\u093e \u091c\u0930\u094d\u091c\u093f\u092f\u093e \u0906\u0930\u094b \u0916\u094b\u0932\u093e \u0938\u0947\u0923\u094d\u0921\u0935\u0940\u091a \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "GT", "\u0917\u0941\u0935\u093e\u091f\u0947\u092e\u093e\u0932\u093e" },
            { "GU", "\u0917\u0941\u0906\u092e" },
            { "GW", "\u0917\u093f\u0928\u0940\u092f\u093e- \u092c\u093f\u0938\u093e\u090a" },
            { "GY", "\u0917\u0941\u092f\u093e\u0928\u093e" },
            { "HK", "\u0939\u0902\u0915\u0902 \u090f\u0938.\u090f.\u0906\u0930 \u091a\u093e\u0907\u0928\u093e" },
            { "HM", "\u0939\u094b\u0930\u094d\u0926 \u0906\u0930\u094b \u092e\u0947\u0915\u0926\u2019\u0928\u093e\u0932\u094d\u0921 \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "HN", "\u0939\u0923\u094d\u0921\u0942\u0930\u093e\u0938" },
            { "HR", "\u0915\u094d\u0930\u0935\u0947\u0936\u093f\u092f\u093e" },
            { "HT", "\u0939\u093e\u0907\u0924\u0940" },
            { "HU", "\u0939\u093e\u0902\u0917\u093e\u0930\u0940" },
            { "IC", "\u0915\u093e\u0928\u093e\u0930\u093f \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "ID", "\u0907\u0923\u094d\u0921\u2019\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "IE", "\u0906\u092f\u093e\u0930\u0932\u0947\u0923\u094d\u0921" },
            { "IL", "\u0907\u091c\u094d\u0930\u093e\u0908\u0932" },
            { "IM", "\u0906\u092f\u094b\u0932 \u0905\u092b \u092e\u0947\u0928" },
            { "IN", "\u092d\u093e\u0930\u0924" },
            { "IO", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936\u0928\u093f \u092d\u093e\u0930\u0924\u093e\u0930\u093f \u0932\u0948\u0925\u094b \u092c\u093e\u0939\u093e\u0917\u094b" },
            { "IQ", "\u0908\u0930\u093e\u0915" },
            { "IR", "\u0908\u0930\u093e\u0928" },
            { "IS", "\u0906\u0907\u0938\u0932\u0947\u0923\u094d\u0921" },
            { "IT", "\u0907\u091f\u093e\u0932\u0940" },
            { "JE", "\u091c\u094b\u0930\u094d\u0938\u093f" },
            { "JM", "\u091c\u093e\u092e\u093e\u0907\u0915\u093e" },
            { "JO", "\u091c\u0930\u094d\u0921\u093e\u0928" },
            { "JP", "\u091c\u093e\u092a\u093e\u0928" },
            { "KE", "\u0915\u0947\u0928\u093f\u092f\u093e" },
            { "KG", "\u0915\u093f\u0930\u094d\u0917\u0940\u0938\u094d\u0924\u093e\u0928" },
            { "KH", "\u0915\u092e\u094d\u092c\u2019\u0921\u093f\u092f\u093e" },
            { "KI", "\u0915\u093f\u0930\u093f\u092c\u093e\u0924\u0940" },
            { "KM", "\u0915\u092e\u2019\u0930\u2019\u091c" },
            { "KN", "\u0938\u0948\u0928\u094d\u091f \u0915\u0940\u0924\u094d\u0938 \u0906\u0930\u094b \u0928\u0947\u092d\u093f\u0938" },
            { "KP", "\u0938\u093e\u0939\u093e \u0915\u0930\u093f\u092f\u093e" },
            { "KR", "\u0916\u094b\u0932\u093e \u0915\u0930\u093f\u092f\u093e" },
            { "KW", "\u0915\u0941\u0935\u0948\u0924" },
            { "KY", "\u0915\u0948\u092e\u0947\u0928 \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "KZ", "\u0915\u093e\u091c\u093e\u0916\u0938\u094d\u0924\u093e\u0928" },
            { "LA", "\u0932\u093e\u0913\u0938" },
            { "LB", "\u0932\u0947\u092c\u093e\u0928\u2019\u0928" },
            { "LC", "\u0938\u0948\u0928\u094d\u091f \u0932\u0941\u0938\u093f\u092f\u093e" },
            { "LI", "\u0932\u093f\u0915\u094d\u0924\u094b\u0928\u0938\u094d\u0924\u093e\u0908\u0928" },
            { "LK", "\u0936\u094d\u0930\u0940\u0932\u0902\u0915\u093e" },
            { "LR", "\u0932\u093e\u0907\u092c\u0947\u0930\u093f\u092f\u093e" },
            { "LS", "\u0932\u0947\u0938\u2019\u0925\u2019" },
            { "LT", "\u0932\u093f\u0925\u0941\u0906\u0928\u093f\u092f\u093e" },
            { "LU", "\u0932\u093e\u0915\u094d\u091c\u0947\u092e\u092c\u0941\u0930\u094d\u0917" },
            { "LV", "\u0932\u093e\u091f\u092d\u0940\u092f\u093e" },
            { "LY", "\u0932\u0940\u092c\u093f\u092f\u093e" },
            { "MA", "\u092e\u0930\u0915\u094d\u0915\u2019" },
            { "MC", "\u092e\u0928\u093e\u0915\u2019" },
            { "MD", "\u092e\u0932\u094d\u0921\u2019\u092d\u093e" },
            { "ME", "\u092e\u0928\u094d\u091f\u0947\u0928\u0947\u0917\u094d\u0930\u2019" },
            { "MF", "\u0938\u0948\u0928\u094d\u091f \u092e\u093e\u0930\u094d\u0924\u093f\u0928" },
            { "MG", "\u092e\u093e\u0926\u093e\u0917\u093e\u0938\u094d\u0915\u093e\u0930" },
            { "MH", "\u092e\u093e\u0930\u094d\u0936\u0947\u0932 \u0926\u094d\u0935\u0940\u092a" },
            { "MK", "\u0938\u093e\u0939\u093e \u092e\u0947\u0938\u0947\u0921\u2019\u0928\u093f\u092f\u093e" },
            { "ML", "\u092e\u093e\u0932\u0940" },
            { "MM", metaValue_MM },
            { "MN", "\u092e\u0902\u0917\u0932\u093f\u092f\u093e" },
            { "MO", "\u092e\u093e\u0915\u093e\u0909 \u090f\u0938.\u090f.\u0906\u0930 \u091a\u093e\u0907\u0928\u093e" },
            { "MP", "\u0938\u093e\u0939\u093e\u092f\u093e\u0930\u093f \u092e\u093e\u0930\u093f\u092f\u093e\u0928\u093e \u0926\u094d\u0935\u0940\u092a" },
            { "MQ", "\u092e\u093e\u0930\u094d\u0924\u093f\u0928\u093f\u0915" },
            { "MR", "\u092e\u093e\u0909\u0930\u093f\u091f\u093e\u0928\u093f\u092f\u093e" },
            { "MS", "\u092e\u0928\u0924\u094d\u0938\u0947\u0930\u093e\u0924" },
            { "MT", "\u092e\u093e\u0932\u094d\u091f\u093e" },
            { "MU", "\u092e\u0930\u093f\u0938\u093f\u092f\u093e\u0938" },
            { "MV", "\u092e\u093e\u0932\u0926\u0940\u0935" },
            { "MW", "\u092e\u093e\u0932\u093e\u0935\u0940" },
            { "MX", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u2019" },
            { "MY", "\u092e\u093e\u0932\u0947\u0936\u093f\u092f\u093e" },
            { "MZ", "\u092e\u091c\u093e\u092e\u094d\u092c\u093f\u0915" },
            { "NA", "\u0928\u093e\u092e\u0940\u092c\u093f\u092f\u093e" },
            { "NC", "\u0928\u093f\u0909 \u0915\u0947\u0932\u0947\u0921\u0928\u093f\u092f\u093e" },
            { "NE", "\u0928\u093e\u0907\u091c\u0947\u0930" },
            { "NF", "\u0928\u0930\u094d\u092b\u2019\u0915 \u0926\u094d\u0935\u0940\u092a" },
            { "NG", "\u0928\u093e\u0907\u091c\u0947\u0930\u093f\u092f\u093e" },
            { "NI", "\u0928\u093f\u0915\u093e\u0930\u093e\u0917\u0941\u0906" },
            { "NL", "\u0928\u0947\u0926\u093e\u0930\u0932\u0947\u0923\u094d\u0921" },
            { "NO", "\u0928\u0930\u0935\u0948" },
            { "NP", "\u0928\u0947\u092a\u093e\u0932" },
            { "NR", "\u0928\u093e\u0909\u0930\u0942" },
            { "NU", "\u0928\u0940\u092f\u0942\u090f" },
            { "NZ", "\u0928\u094d\u092f\u0942\u091c\u0940\u0932\u0947\u0923\u094d\u0921" },
            { "OM", "\u0913\u092e\u093e\u0928" },
            { "PA", "\u092a\u093e\u0928\u093e\u092e\u093e" },
            { "PE", "\u092a\u0947\u0930\u0942" },
            { "PF", "\u092b\u094d\u0930\u0947\u0928\u094d\u091a \u092a\u0932\u093f\u0928\u0947\u0936\u093f\u092f\u093e" },
            { "PG", "\u092a\u093e\u092a\u0941\u0906 \u0928\u093f\u0909 \u0917\u093f\u0928\u0940" },
            { "PH", "\u092b\u093f\u0932\u0940\u092a\u093f\u0928\u094d\u0938" },
            { "PK", "\u092a\u093e\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "PL", "\u092a\u0932\u0947\u0923\u094d\u0921" },
            { "PM", "\u0938\u0948\u0928\u094d\u091f. \u092a\u093f\u090f\u0930 \u0906\u0930\u094b \u092e\u093f\u0915\u0948\u0932\u0928" },
            { "PN", "\u092a\u093f\u091f\u0915\u093e\u0908\u0930\u094d\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "PR", "\u092a\u0941\u0935\u0947\u0930\u094d\u091f\u2019 \u0930\u0940\u0915\u2019" },
            { "PS", "\u092a\u0947\u0932\u0947\u0938\u094d\u0924\u093e\u0907\u0928\u0928\u093f \u0913\u0928\u0938\u094b\u0932\u092b\u094b\u0930" },
            { "PT", "\u092a\u0930\u094d\u0924\u0941\u0917\u093e\u0932" },
            { "PW", "\u092a\u093e\u0932\u093e\u090a" },
            { "PY", "\u092a\u093e\u0930\u093e\u0917\u0941\u090f" },
            { "QA", "\u0915\u093e\u0924\u093e\u0930" },
            { "QO", "\u092c\u093e\u092f\u091c\u094b\u0906\u0930\u093f \u0905\u0938\u093f\u092f\u093e\u0928\u093f\u092f\u093e" },
            { "RE", "\u0930\u0947\u092f\u0942\u0928\u093f\u092f\u0928" },
            { "RO", "\u0930\u092e\u093e\u0928\u093f\u092f\u093e" },
            { "RS", "\u0938\u093e\u0930\u094d\u092c\u093f\u092f\u093e" },
            { "RU", "\u0930\u093e\u0938\u093f\u092f\u093e" },
            { "RW", "\u0930\u0942\u0906\u0923\u094d\u0921\u093e" },
            { "SA", "\u0938\u093e\u0909\u0926\u093f \u0906\u0930\u093e\u092c\u093f\u092f\u093e" },
            { "SB", "\u0938\u0932\u2019\u092e\u0928 \u0926\u094d\u0935\u0940\u092a" },
            { "SC", "\u0938\u0948\u0936\u0947\u0932\u094d\u0932\u0947\u0938" },
            { "SD", "\u0938\u0942\u0926\u093e\u0928" },
            { "SE", "\u0938\u094d\u0935\u0940\u0921\u0947\u0928" },
            { "SG", "\u0938\u093f\u0902\u0902\u0917\u093e\u092a\u2019\u0930" },
            { "SH", "\u0938\u0948\u0928\u094d\u091f \u0939\u0947\u0932\u0947\u0928\u093e" },
            { "SI", "\u0938\u094d\u0932\u2019\u092d\u0947\u0928\u093f\u092f\u093e" },
            { "SJ", "\u0938\u094d\u092d\u093e\u0932\u092c\u093e\u0930\u094d\u0921 \u0906\u0930\u094b \u091c\u093e\u0928 \u092e\u093e\u092f\u0947\u0928" },
            { "SK", "\u0938\u094d\u0932\u092d\u093e\u0915\u093f\u092f\u093e" },
            { "SL", "\u0938\u093f\u092f\u0947\u0930\u093e \u0932\u0947\u0913\u0928" },
            { "SM", "\u0938\u093e\u0928 \u092e\u0947\u0930\u093f\u0928\u2019" },
            { "SN", "\u0938\u0947\u0928\u0947\u0917\u093e\u0932" },
            { "SO", "\u0938\u092e\u093e\u0932\u093f\u092f\u093e" },
            { "SR", "\u0938\u0941\u0930\u093f\u0928\u093e\u092e" },
            { "SS", "\u0916\u094b\u0932\u093e \u0938\u0941\u0926\u093e\u0928" },
            { "ST", "\u0938\u093e\u090a \u0924\u092e\u0947 \u0906\u0930\u094b \u092a\u094d\u0930\u093f\u0928\u094d\u0938\u093f\u092a" },
            { "SV", "\u090f\u0932 \u0938\u093e\u0932\u094d\u092d\u093e\u0921\u2019\u0930" },
            { "SX", "\u0938\u093f\u0928\u094d\u0924 \u092e\u093e\u0930\u094d\u0924\u0947\u0928" },
            { "SY", "\u0938\u0940\u0930\u093f\u092f\u093e" },
            { "SZ", "\u090f\u0938\u094d\u0935\u093e\u0924\u093f\u0928\u093f" },
            { "TA", "\u0924\u094d\u0930\u093f\u0938\u094d\u0924\u093e\u0928 \u0926\u093e \u0915\u0941\u0928\u094d\u0939\u093e" },
            { "TC", "\u0924\u0941\u0930\u094d\u0915\u0940 \u0906\u0930\u094b \u0915\u093e\u0908\u0915\u2019\u091c \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "TD", "\u091a\u093e\u0921" },
            { "TF", "\u092b\u094d\u0930\u093e\u0928\u094d\u0938\u0928\u093f \u0916\u094b\u0932\u093e\u092f\u093e\u0930\u093f \u092c\u093e\u0939\u093e\u0917\u094b\u092b\u094b\u0930" },
            { "TG", "\u091f\u0917\u2019" },
            { "TH", "\u0925\u093e\u0907\u0932\u0947\u0923\u094d\u0921" },
            { "TJ", "\u0924\u093e\u091c\u093f\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "TK", "\u091f\u0915\u0947\u0932\u093e\u090a" },
            { "TL", "\u0924\u093f\u092e\u0930-\u0932\u0947\u0938\u094d\u0924\u0947" },
            { "TM", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928\u0940\u0938\u094d\u0924\u093e\u0928" },
            { "TN", "\u0924\u094d\u092f\u0941\u0928\u093f\u0936\u093f\u092f\u093e" },
            { "TO", "\u091f\u0902\u0917\u093e" },
            { "TR", "\u0924\u0941\u0930\u094d\u0915\u0940" },
            { "TT", "\u0924\u094d\u0930\u093f\u0928\u093f\u0921\u093e\u0921 \u0906\u0930\u094b \u0924\u092c\u0947\u0917\u2019" },
            { "TV", "\u0924\u0941\u092d\u093e\u0932\u0941" },
            { "TW", "\u0924\u093e\u0907\u0935\u093e\u0928" },
            { "TZ", "\u0924\u093e\u0928\u094d\u091c\u093e\u0928\u093f\u092f\u093e" },
            { "UA", "\u092f\u0942\u0915\u094d\u0930\u0947\u0928" },
            { "UG", "\u0909\u0917\u093e\u0923\u094d\u0921\u093e" },
            { "UM", "\u0907\u0909.\u090f\u0938 \u0928\u093f \u092c\u093e\u092f\u091c\u094b\u0906\u0930\u093f \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "UN", "\u091c\u0925\u093e\u092f \u0939\u093e\u0926\u094b\u0930\u092b\u094b\u0930" },
            { "US", "\u091c\u0925\u093e\u092f \u0939\u093e\u0926\u094b\u0930 \u0906\u092e\u0947\u0930\u093f\u0915\u093e" },
            { "UY", "\u090a\u0930\u0941\u0917\u0941\u0935\u0947" },
            { "UZ", "\u0909\u091c\u092c\u0947\u0915\u093f\u0938\u094d\u0924\u093e\u0928" },
            { "VA", "\u092d\u0947\u091f\u093f\u0915\u093e\u0928 \u0928\u094b\u0917\u094b\u0930" },
            { "VC", "\u0938\u0948\u0928\u094d\u091f \u092d\u093f\u0928\u094d\u0938\u0947\u0928\u094d\u091f \u0906\u0930\u094b \u0917\u094d\u0930\u0947\u0928\u093e\u0926\u0940\u0928\u094d\u0938" },
            { "VE", "\u092d\u0947\u0928\u0947\u091c\u0941\u0935\u0947\u0932\u093e" },
            { "VG", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u092d\u093e\u0930\u094d\u091c\u093f\u0928 \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "VI", "\u0907\u0909. \u090f\u0938 \u092d\u093e\u0930\u094d\u091c\u093f\u0928 \u0926\u094d\u0935\u0940\u092a\u092b\u094b\u0930" },
            { "VN", "\u092d\u093f\u092f\u0947\u0924\u0928\u093e\u092e" },
            { "VU", "\u092d\u093e\u0928\u0941\u0906\u091f\u0941" },
            { "WF", "\u0935\u093e\u0932\u093f\u0938 \u0906\u0930\u094b \u092b\u094d\u092f\u0941\u091a\u0941\u0928\u093e" },
            { "WS", "\u0938\u093e\u092e\u0906" },
            { "XA", "\u0928\u0902\u0916\u093e\u0907-\u0917\u093e\u0930\u093e\u0902\u092c\u094b\u0932\u094b" },
            { "XB", "\u0928\u0902\u0916\u093e\u0907- \u092c\u093f\u0926\u093f" },
            { "XK", "\u0915\u0938\u2019\u092d\u2019" },
            { "YE", "\u092f\u0947\u092e\u0947\u0928" },
            { "YT", "\u092e\u093e\u092f\u0924\u094d\u0924\u0947" },
            { "ZA", "\u0916\u094b\u0932\u093e \u0906\u092b\u094d\u0930\u093f\u0915\u093e" },
            { "ZM", "\u091c\u093e\u092e\u094d\u092c\u093f\u092f\u093e" },
            { "ZW", "\u091c\u093f\u092e\u094d\u092c\u093e\u092c\u094d\u0935\u0947" },
            { "ZZ", "\u092e\u093f\u0925\u093f\u092f\u0948 \u0913\u0928\u0938\u094b\u0932" },
            { "ab", "\u0906\u092c\u094d\u0916\u093e\u091c\u093f\u092f\u093e\u0928" },
            { "ae", metaValue_ae },
            { "af", "\u0906\u092b\u094d\u0930\u093f\u0915\u093e\u0928\u094d\u0938" },
            { "ak", "\u0906\u0915\u093e\u0928" },
            { "am", "\u0906\u092e\u094d\u0939\u093e\u0930\u093f\u0915" },
            { "an", "\u0906\u0930\u093e\u0917\u0928\u093f\u0938" },
            { "ar", metaValue_ar },
            { "as", "\u0905\u0938\u092e\u093f\u092f\u093e" },
            { "av", "\u0906\u092d\u093e\u0930\u093f\u0915" },
            { "ay", "\u0906\u092f\u092e\u093e\u0930\u093e" },
            { "az", "\u0906\u091c\u093e\u0930\u092c\u093e\u092f\u091c\u093e\u0928\u093f" },
            { "ba", "\u092c\u093e\u0936\u0915\u093f\u0930" },
            { "be", "\u092c\u0947\u0932\u093e\u0930\u0941\u0938\u093f\u092f\u093e\u0928" },
            { "bg", "\u092c\u0941\u0932\u094d\u0917\u093e\u0930\u093f\u092f\u093e\u0928" },
            { "bi", "\u092c\u093f\u0938\u094d\u0932\u093e\u092e\u093e" },
            { "bm", "\u092c\u093e\u092e\u094d\u092c\u093e\u0930\u093e" },
            { "bn", metaValue_bn },
            { "bo", "\u0924\u093f\u092c\u094d\u092c\u0924\u0940" },
            { "br", "\u092c\u094d\u0930\u0947\u091f\u2019\u0928" },
            { "bs", "\u092c\u0938\u094d\u0928\u093f\u092f\u093e\u0928" },
            { "ca", "\u0915\u093e\u0924\u093e\u0932\u093e\u0928" },
            { "ce", "\u091a\u0947\u091a\u0947\u0928" },
            { "ch", "\u091a\u093e\u092e\u094b\u0930\u094d\u0930\u094b" },
            { "co", "\u0915\u0930\u094d\u0938\u093f\u0915\u093e\u0928" },
            { "cr", "\u0915\u094d\u0930\u0940" },
            { "cs", "\u091a\u0948\u0915" },
            { "cu", "\u091a\u0930\u094d\u091a \u0938\u094d\u0932\u093e\u0935\u093f\u0915\u094d" },
            { "cv", "\u091a\u0941\u092d\u093e\u0938" },
            { "cy", "\u0935\u0948\u0932\u094d\u0936" },
            { "da", "\u0921\u093e\u0928\u093f\u0936" },
            { "de", "\u091c\u093e\u0930\u094d\u092e\u093e\u0928" },
            { "dv", "\u0926\u0940\u0935\u0947\u0939\u0940" },
            { "dz", "\u091d\u0902\u0916\u093e" },
            { "ee", "\u090f\u0935\u0947" },
            { "el", metaValue_el },
            { "en", "\u0907\u0902\u0930\u093e\u091c\u0940" },
            { "eo", "\u090f\u0938\u094d\u092a\u0947\u0930\u093e\u0928\u094d\u0924\u2019" },
            { "es", "\u0938\u094d\u092a\u0947\u0928\u093f\u0936" },
            { "et", "\u090f\u0938\u094d\u091f\u2019\u0928\u093f\u092f\u093e\u0928" },
            { "eu", "\u092c\u093e\u0938\u094d\u0915" },
            { "fa", "\u092b\u093e\u0930\u094d\u0938\u0940" },
            { "ff", "\u092b\u0941\u0932\u093e\u0939" },
            { "fi", "\u092b\u093f\u0928\u094d\u0928\u093f\u0938" },
            { "fj", "\u092b\u093f\u091c\u093f\u092f\u093e\u0928" },
            { "fo", "\u092b\u0947\u0930\u2019\u0935\u0940\u091c" },
            { "fr", "\u092b\u094d\u0930\u0947\u0928\u094d\u091a" },
            { "fy", "\u0938\u094b\u0928\u093e\u092c\u093e\u0930\u093f \u092b\u094d\u0930\u093f\u091c\u093f\u092f\u093e\u0928" },
            { "ga", "\u0906\u0908\u0930\u093f\u0936" },
            { "gd", "\u0938\u094d\u0915\u091f\u093f\u0938 \u0917\u0948\u0932\u093f\u0915" },
            { "gl", "\u0917\u0947\u0932\u093f\u0938\u093f\u092f\u093e\u0928" },
            { "gn", "\u0917\u0941\u0906\u0930\u093e\u0928\u0940" },
            { "gu", metaValue_gu },
            { "gv", "\u092e\u0947\u0928\u0915\u094d\u0938" },
            { "ha", "\u0939\u093e\u0909\u0938\u093e" },
            { "he", "\u0939\u093f\u092c\u094d\u0930\u093f\u0909" },
            { "hi", "\u0939\u093f\u0928\u094d\u0926\u0940" },
            { "ho", "\u0939\u0940\u0930\u0940 \u092e\u094b\u091f\u0941" },
            { "hr", "\u0915\u094d\u0930\u0935\u0947\u0936\u093f\u092f\u093e\u0928" },
            { "ht", "\u0939\u093e\u0908\u091f\u093f\u092f\u093e\u0928 \u0915\u094d\u0930\u093f\u0905\u0932" },
            { "hu", "\u0939\u093e\u0902\u0917\u093e\u0930\u093f\u092f\u093e\u0928" },
            { "hy", metaValue_hy },
            { "hz", "\u0939\u0947\u0930\u0947\u0930\u2019" },
            { "ia", "\u0908\u0928\u094d\u091f\u0930\u0932\u093f\u0902\u0917\u094d\u0935\u093e" },
            { "id", "\u0908\u0923\u094d\u0921\u0928\u0947\u0938\u093f\u092f\u093e\u0928" },
            { "ie", "\u0908\u0928\u094d\u091f\u0930\u0932\u093f\u0902\u0917\u094d\u0935\u0947" },
            { "ig", "\u0908\u0917\u094d\u092c\u2019" },
            { "ii", "\u0936\u0940\u091a\u0941\u0906\u0928 \u092f\u0940" },
            { "ik", "\u0907\u0928\u0941\u092a\u093f\u092f\u093e\u0915\u093c\u094d" },
            { "io", "\u0908\u0921\u2019" },
            { "is", "\u0906\u0907\u0938\u094d\u0932\u0947\u0928\u094d\u0921\u093f\u0915" },
            { "it", "\u0907\u091f\u093e\u0932\u093f\u092f\u093e\u0928" },
            { "iu", "\u0907\u0928\u0941\u0915\u094d\u091f\u0940\u091f\u0941\u0924" },
            { "ja", metaValue_ja },
            { "jv", "\u091c\u093e\u092d\u093e\u0928\u0940\u0938" },
            { "ka", metaValue_ka },
            { "kg", "\u0915\u0949\u0902\u0917\u094b" },
            { "ki", "\u0915\u093f\u0915\u0941\u092f\u0941" },
            { "kj", "\u0915\u0941\u0906\u0928\u092f\u093e\u092e\u093e" },
            { "kk", "\u0915\u093e\u091c\u093e\u0916" },
            { "kl", "\u0915\u0932\u093e\u0932\u0940\u0938\u0941\u0924" },
            { "km", metaValue_km },
            { "kn", "\u0915\u0928\u094d\u0928\u0921" },
            { "ko", "\u0915\u0930\u093f\u092f\u093e\u0928" },
            { "kr", "\u0915\u0928\u0941\u0930\u0940" },
            { "ks", "\u0915\u093e\u0936\u094d\u092e\u093f\u0930\u0940" },
            { "ku", "\u0915\u0941\u0930\u094d\u0926\u0940\u0936" },
            { "kv", "\u0915\u2019\u092e\u0940" },
            { "kw", "\u0915\u0930\u094d\u0928\u093f\u0938" },
            { "ky", "\u0915\u093f\u0930\u0917\u0940\u091c" },
            { "la", metaValue_la },
            { "lb", "\u0932\u093e\u0915\u094d\u091c\u0947\u092e\u092c\u0941\u0930\u094d\u0917\u0940\u0936" },
            { "lg", "\u0917\u093e\u0928\u094d\u0921\u093e" },
            { "li", "\u0932\u0940\u092e\u094d\u092c\u0941\u0930\u094d\u0917\u093f\u0938" },
            { "ln", "\u0932\u093f\u0902\u0917\u093e\u0932\u093e" },
            { "lo", "\u0932\u093e\u090a" },
            { "lt", "\u0932\u093f\u0925\u0941\u0935\u093e\u0928\u093f\u092f\u093e\u0928" },
            { "lu", "\u0932\u0941\u092c\u093e-\u0915\u093e\u091f\u093e\u0919\u093e" },
            { "lv", "\u0932\u093e\u091f\u092d\u093f\u092f\u093e\u0928" },
            { "mg", "\u092e\u093e\u0932\u093e\u0917\u093e\u0938\u0940" },
            { "mh", "\u092e\u093e\u0930\u094d\u0936\u0947\u0932\u093f\u0938" },
            { "mi", "\u092e\u093e\u0914\u0930\u093f" },
            { "mk", "\u092e\u0947\u0938\u0947\u0921\u2019\u0928\u093f\u092f\u093e\u0928" },
            { "ml", "\u092e\u093e\u0932\u093e\u092f\u093e\u0932\u092e" },
            { "mn", metaValue_mn },
            { "mr", "\u092e\u093e\u0930\u093e\u0925\u0940" },
            { "ms", "\u092e\u0932\u0948" },
            { "mt", "\u092e\u093e\u0932\u094d\u091f\u0940\u091c" },
            { "my", "\u092c\u093e\u0930\u094d\u092e\u093f\u0938" },
            { "na", "\u0928\u093e\u090a\u0930\u0942" },
            { "nb", "\u0928\u0930\u0935\u0948\u091c\u093f\u092f\u093e\u0928 \u092c\u0915\u092e\u093e\u0932" },
            { "nd", "\u0938\u093e\u0939\u093e \u0928\u094d\u0926\u0947\u092c\u0947\u0932\u0947" },
            { "ne", "\u0928\u0947\u092a\u093e\u0932\u0940" },
            { "ng", "\u0928\u094d\u0921\u094b\u0902\u0917\u093e" },
            { "nl", "\u0921\u093e\u0924\u094d\u091a" },
            { "nn", "\u0928\u0930\u0935\u0948\u091c\u093f\u092f\u093e\u0928 \u0928\u093f\u0928\u0930\u094d\u0938\u094d\u0915" },
            { "no", "\u0928\u0930\u0935\u0948\u091c\u093f\u092f\u093e\u0928" },
            { "nr", "\u0916\u094b\u0932\u093e \u0928\u094d\u0926\u0947\u092c\u0947\u0932\u0947" },
            { "nv", "\u0928\u093e\u0935\u093e\u0939\u094b" },
            { "ny", "\u0928\u094d\u092f\u093e\u0928\u094d\u091c\u093e" },
            { "oc", "\u0905\u0915\u094d\u0938\u093f\u0924\u093e\u0928" },
            { "oj", "\u0913\u0939\u0940\u092c\u0935\u093e" },
            { "om", "\u0905\u0930\u092e\u2019" },
            { "or", "\u0909\u0930\u0940\u092f\u093e" },
            { "os", "\u0905\u0938\u094d\u0938\u0947\u091f\u0940\u0915" },
            { "pa", "\u092a\u093e\u0928\u094d\u091c\u093e\u092c\u0940" },
            { "pi", "\u092a\u093e\u0932\u0940" },
            { "pl", "\u092a\u0932\u093f\u0936" },
            { "ps", "\u092a\u093e\u0936\u094d\u0924\u2019" },
            { "pt", "\u092a\u0930\u094d\u091f\u0941\u0917\u093f\u091c" },
            { "qu", "\u0915\u094d\u0935\u0947\u091a\u0941\u0906" },
            { "rm", "\u0930\u092e\u093e\u0928\u094d\u0936" },
            { "rn", "\u0930\u0941\u0928\u094d\u0926\u0940" },
            { "ro", "\u0930\u092e\u093e\u0928\u0940\u092f\u093e\u0928" },
            { "ru", "\u0930\u093e\u0938\u093f\u092f\u093e\u0928" },
            { "rw", "\u0915\u093f\u0928\u094d\u092f\u093e\u0930\u094d\u0935\u093e\u0928\u094d\u0926\u093e" },
            { "sa", "\u0938\u0902\u0938\u094d\u0915\u0943\u0924" },
            { "sc", "\u0938\u093e\u0930\u094d\u0926\u0940\u0928\u0940\u092f\u093e\u0928" },
            { "sd", "\u0938\u093f\u0928\u094d\u0927\u0940" },
            { "se", "\u0938\u093e\u0939\u093e\u092f\u093e\u0930\u093f \u0938\u093e\u092e\u0940" },
            { "sg", "\u0938\u093e\u0919\u2019" },
            { "sh", "\u0938\u0930\u094d\u092c\u094b-\u0915\u094d\u0930\u094b\u090f\u0936\u0928\u094d" },
            { "si", "\u0938\u0940\u0902\u0939\u093e\u0932\u093e" },
            { "sk", "\u0938\u094d\u0932\u2019\u092d\u093e\u0915" },
            { "sl", "\u0938\u094d\u0932\u094b\u092d\u0947\u0928\u093f\u092f\u093e\u0928" },
            { "sm", "\u0938\u093e\u092e\u2019\u0935\u093e\u0928" },
            { "sn", "\u0936\u0928\u093e" },
            { "so", "\u0938\u2019\u092e\u093e\u0932\u0940" },
            { "sq", "\u0906\u0932\u094d\u092c\u093e\u0928\u093f\u092f\u093e\u0928" },
            { "sr", "\u0938\u093e\u0930\u094d\u092c\u093f\u092f\u093e\u0928" },
            { "ss", "\u0938\u094d\u0935\u093e\u091f\u093f" },
            { "st", "\u0916\u094b\u0932\u093e\u092f\u093e\u0930\u093f \u0938\u0925\u2019" },
            { "su", "\u0938\u0941\u0928\u094d\u0926\u093e\u0928\u0940" },
            { "sv", "\u0938\u094d\u0935\u0940\u0921\u093f\u0936" },
            { "sw", "\u0938\u094d\u0935\u093e\u0939\u093f\u0932\u0940" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u0924\u093e\u091c\u093f\u0915" },
            { "th", metaValue_th },
            { "ti", "\u0924\u093f\u0917\u094d\u0930\u0940\u0928\u094d\u092f\u093e" },
            { "tk", "\u0924\u0941\u0930\u094d\u0915\u092e\u0947\u0928" },
            { "tl", "\u0924\u093e\u0917\u093e\u0932\u094b\u0917" },
            { "tn", "\u0924\u094d\u0938\u094d\u0935\u093e\u0928\u093e" },
            { "to", "\u091f\u0902\u0917\u093e\u0928" },
            { "tr", "\u0924\u0941\u0930\u094d\u0915\u0940\u0938" },
            { "ts", "\u0924\u094d\u0938\u0902\u0917\u093e" },
            { "tt", "\u091f\u093e\u091f\u093e\u0930" },
            { "tw", "\u091f\u094d\u0935\u0940" },
            { "ty", "\u091f\u093e\u0939\u0940\u091f\u093f\u092f\u093e\u0928" },
            { "ug", "\u0909\u0908\u0918\u0941\u0930" },
            { "uk", "\u092f\u0941\u0915\u094d\u0930\u0947\u0928\u093f\u092f\u093e\u0928" },
            { "ur", "\u090a\u0930\u094d\u0926\u0941" },
            { "uz", "\u0909\u091c\u092c\u0947\u0915" },
            { "ve", "\u092d\u0947\u0928\u094d\u0921\u093e" },
            { "vi", "\u092d\u093f\u092f\u0947\u0924\u0928\u093e\u092e\u093f\u0938" },
            { "vo", "\u0935\u094b\u0932\u093e\u092a\u094b\u0915" },
            { "wa", "\u0935\u093e\u0932\u094d\u0932\u0941\u0928" },
            { "wo", "\u0935\u0932\u2019\u092b" },
            { "xh", "\u0916\u2019\u0938\u093e" },
            { "yi", "\u092f\u0940\u0926\u094d\u0926\u0940\u0936" },
            { "yo", "\u092f\u0930\u0942\u092c\u093e" },
            { "za", "\u091c\u093c\u0941\u0906\u0902\u0917" },
            { "zh", "\u091a\u093e\u0907\u0928\u0940\u091c" },
            { "zu", "\u091c\u0941\u0932\u0942" },
            { "ace", "\u090f\u091a\u0947\u0928\u093f\u091c" },
            { "ach", "\u0905\u0915\u094b\u0932\u0940" },
            { "ada", "\u090f\u0921\u093e\u0902\u0917\u092e\u0947" },
            { "ady", "\u0905\u0926\u093f\u0918\u0947" },
            { "afh", "\u0905\u092b\u094d\u0930\u0940\u0939\u0940\u0932\u0940" },
            { "agq", "\u0906\u0918\u0947\u092e" },
            { "ain", "\u0910\u0928\u0942" },
            { "akk", "\u0905\u0915\u093e\u0921\u093f\u0928\u0940" },
            { "ale", "\u0906\u0932\u0947\u0909\u091f" },
            { "alt", "\u0916\u094b\u0932\u093e\u092f\u093e\u0930\u093f \u0906\u0932\u094d\u091f\u093e\u0908" },
            { "ang", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "ann", "\u0905\u092c\u0932\u2019" },
            { "anp", "\u0906\u0919\u093f\u0915\u093e" },
            { "arc", "\u0905\u0930\u093e\u092e\u093e\u0908\u0915" },
            { "arn", "\u092e\u093e\u092a\u0941\u091a\u0947" },
            { "arp", "\u0906\u0930\u093e\u092a\u093e\u0939\u2019" },
            { "ars", "\u0928\u093e\u091c\u0921\u0940 \u0906\u0930\u093e\u092c\u093f\u0915" },
            { "arw", "\u0905\u0930\u093e\u0935\u093e\u0915" },
            { "asa", "\u0906\u0938\u0941" },
            { "ast", "\u0906\u0938\u094d\u0924\u0941\u0930\u093f\u092f\u093e\u0928" },
            { "atj", "\u0906\u0924\u093f\u0915\u093e\u092e\u0947\u0915\u094b" },
            { "awa", "\u0905\u0935\u0927\u0940" },
            { "bal", "\u092c\u0932\u0942\u091a\u0940" },
            { "ban", "\u092c\u093e\u0932\u093f\u0928\u093f\u0938" },
            { "bas", "\u092c\u093e\u0938\u093e" },
            { "bej", "\u092c\u0947\u091c\u093e" },
            { "bem", "\u092c\u0947\u092e\u094d\u092c\u093e" },
            { "bez", "\u092c\u0947\u0928\u093e" },
            { "bho", "\u092d\u091c\u092a\u0941\u0930\u0940" },
            { "bik", "\u092c\u093f\u0915\u094b\u0932\u094d" },
            { "bin", "\u092c\u093f\u0928\u0940" },
            { "bla", "\u0938\u0940\u0915\u0938\u0940\u0915\u093e" },
            { "bra", "\u092c\u094d\u0930\u091c" },
            { "brx", "\u092c\u0930\u2019" },
            { "bua", "\u092c\u0941\u0930\u093f\u092f\u093e\u0924" },
            { "bug", "\u092c\u0941\u0917\u093f\u0928\u0940\u091c" },
            { "byn", "\u092c\u094d\u0932\u0940\u0928" },
            { "cad", "\u0915\u093e\u0926\u094d\u0926\u094c" },
            { "car", "\u0915\u093e\u0930\u0940\u092c\u094d" },
            { "cay", "\u0915\u093e\u092f\u0941\u0917\u093e" },
            { "cch", "\u0906\u0924\u094d\u0938\u092e" },
            { "ccp", metaValue_ccp },
            { "ceb", "\u091a\u0947\u092c\u0941\u0906\u0928\u094b" },
            { "cgg", "\u091a\u0940\u0917\u093e" },
            { "chb", "\u091a\u0940\u092c\u091a\u093e" },
            { "chg", "\u091a\u0917\u0924\u093e\u0908" },
            { "chk", "\u091a\u0941\u0915\u0947\u0938\u0947" },
            { "chm", "\u092e\u093e\u0930\u093f" },
            { "chn", "\u091a\u0940\u0928\u0942\u0915\u094d \u091c\u093e\u0930\u094d\u0917\u0928\u094d" },
            { "cho", "\u091a\u0915\u094d\u091f\u093e\u090a" },
            { "chp", "\u091a\u093f\u092a\u0947\u0935\u094d\u092f\u093e\u0928" },
            { "chr", "\u091a\u0947\u0930\u0915\u0940" },
            { "chy", "\u091a\u0947\u092f\u0947\u0923" },
            { "ckb", "\u092e\u093f\u0930\u0941 \u0915\u0941\u0930\u094d\u0926\u093f\u0938" },
            { "clc", "\u091a\u093f\u0932\u094d\u0915\u091f\u093f\u0928" },
            { "cop", "\u0915\u0949\u092a\u094d\u091f\u0940\u0915\u094d" },
            { "crg", "\u092e\u093f\u091a\u093f\u092b" },
            { "crh", "\u0924\u0941\u0930\u094d\u0915\u0940 \u0915\u094d\u0930\u093f\u092e\u093f\u092f\u093e" },
            { "crj", "\u0916\u094b\u0932\u093e\u092f\u093e\u0930\u093f \u0938\u093e\u0928\u091c\u093e \u0915\u094d\u0930\u0940" },
            { "crk", "\u0939\u093e\u092f\u0947\u0928\u093e\u0930\u093f \u0915\u094d\u0930\u0940" },
            { "crl", "\u0938\u093e\u0939\u093e\u092f\u093e\u0930\u093f \u0938\u093e\u0928\u091c\u093e \u0915\u094d\u0930\u0940" },
            { "crm", "\u092e\u0942\u091c \u0915\u094d\u0930\u0940" },
            { "crr", "\u0915\u0947\u0930\u2019\u0932\u093f\u0928\u093e \u090f\u0932\u094d\u0917\u0902\u0915\u094d\u092f\u093e\u0928" },
            { "csb", "\u0915\u093e\u0936\u0941\u092c\u093f\u092f\u093e\u0928\u094d" },
            { "csw", "\u0938\u094d\u0935\u093e\u092e\u094d\u092a\u0940 \u0915\u094d\u0930\u0940" },
            { "dak", "\u0921\u093e\u0915\u2019\u091f\u093e" },
            { "dar", "\u0926\u0930\u094d\u0917\u0935\u093e" },
            { "dav", "\u091f\u093e\u0907\u091f\u093e" },
            { "del", "\u0926\u0932\u093e\u0935\u093e\u0930\u094d" },
            { "den", "\u0938\u094d\u0932\u0947\u0935\u094d" },
            { "dgr", "\u0921\u094b\u0917\u0930\u0940\u092c" },
            { "din", "\u0921\u0940\u0902\u0917\u0915\u093e" },
            { "dje", "\u091c\u093e\u0930\u094d\u092e\u093e" },
            { "doi", "\u0921\u094b\u0917\u0930\u0940" },
            { "dsb", "\u0917\u093e\u0939\u093e\u092f\u0938\u093f\u0928 \u0938\u0930\u094d\u092c\u093f\u092f\u093e\u0928" },
            { "dua", "\u0921\u0941\u0906\u0932\u093e" },
            { "dum", "\u092e\u0927\u094d\u092f \u0921\u091a" },
            { "dyo", "\u091c\u0932\u093e- \u092b\u0928\u094d\u092f\u0940" },
            { "dyu", "\u0926\u094d\u092f\u0941\u0906\u0932\u093e" },
            { "dzg", "\u0921\u093e\u091c\u093e\u0917\u093e" },
            { "ebu", "\u0907\u092e\u094d\u092c\u0941" },
            { "efi", "\u090f\u092b\u093f\u0915" },
            { "egy", "\u092a\u094d\u0930\u093e\u091a\u0940\u0928 \u092e\u093f\u0938\u094d\u0930\u0940" },
            { "eka", "\u090f\u0915\u093e\u091c\u0941\u0915" },
            { "elx", "\u090f\u0932\u093e\u092e\u0940" },
            { "enm", "\u092e\u0927\u094d\u092f \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "ewo", "\u090f\u0935\u2019\u0928\u094d\u0926\u2019" },
            { "fan", "\u092b\u093e\u0901\u0917\u094d" },
            { "fat", "\u092b\u093e\u0901\u091f\u0940" },
            { "fil", "\u092b\u093f\u0932\u093f\u092a\u093f\u0928\u2019" },
            { "fon", "\u092b\u2019\u0928" },
            { "frc", "\u0915\u093e\u091c\u0941\u0928 \u092b\u094d\u0930\u0947\u0928\u094d\u091a" },
            { "frm", "\u092e\u0927\u094d\u092f \u092b\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940" },
            { "fro", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092b\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940" },
            { "frr", "\u0909\u0924\u094d\u0924\u0930\u0940 \u092b\u094d\u0930\u0940\u091c\u093c\u093f\u092f\u0928\u094d" },
            { "frs", "\u092a\u0942\u0930\u094d\u0935\u0940 \u092b\u094d\u0930\u0940\u091c\u093c\u093f\u092f\u0928\u094d" },
            { "fur", "\u092b\u094d\u0930\u093f\u0909\u0932\u093f\u092f\u093e\u0928" },
            { "gaa", "\u0917\u093e" },
            { "gay", "\u0917\u093e\u092f\u094b" },
            { "gba", "\u0917\u094d\u092c\u093e\u092f\u093e" },
            { "gez", "\u0917\u0940\u091c" },
            { "gil", "\u0917\u0940\u0932\u094d\u092c\u0930\u094d\u091f\u093f\u0938" },
            { "gmh", "\u092e\u0927\u094d\u092f \u0909\u091a\u094d\u091a\u0938\u094d\u0924\u0930\u0940 \u091c\u0930\u094d\u092e\u0928" },
            { "goh", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0909\u091a\u094d\u091a\u0938\u094d\u0924\u0930\u0940 \u091c\u0930\u094d\u092e\u0928" },
            { "gon", "\u0917\u093e\u0901\u0921\u0940" },
            { "gor", "\u0917\u0930\u2019\u0928\u094d\u091f\u093e\u0932\u2019" },
            { "got", "\u0917\u0949\u0925\u093f\u0915" },
            { "grb", "\u0917\u094d\u0930\u0947\u092c\u094b" },
            { "grc", "\u092a\u094d\u0930\u093e\u091a\u0940\u0928 \u092f\u0942\u0928\u093e\u0928\u0940" },
            { "gsw", "\u0938\u094d\u0935\u0940\u0938 \u091c\u093e\u0930\u094d\u092e\u093e\u0928" },
            { "guz", "\u0917\u0941\u0936\u093f" },
            { "gwi", "\u0917\u094d\u0935\u0940\u091a\u0932\u0940\u0928" },
            { "hai", "\u0939\u093e\u0908\u0921\u093e" },
            { "haw", "\u0939\u093e\u0935\u093e\u0908\u092f\u093e\u0928" },
            { "hax", "\u0916\u094b\u0932\u093e\u092f\u093e\u0930\u093f \u0939\u093e\u0908\u0921\u093e" },
            { "hil", "\u0939\u093f\u0932\u0940\u0917\u0948\u0928\u2019\u0928" },
            { "hit", "\u0939\u0940\u0924\u094d\u0924\u0940" },
            { "hmn", "\u0939\u094d\u092e\u0902\u0917" },
            { "hsb", "\u0917\u094b\u091c\u094c\u0906\u0930\u093f \u0938\u0930\u094d\u092c\u093f\u092f\u093e\u0928" },
            { "hup", "\u0939\u0942\u092a\u093e" },
            { "hur", "\u0939\u093e\u0932\u094d\u0915\u2019\u092e\u0947\u0932\u0947\u092e" },
            { "iba", "\u0908\u092c\u093e\u0928" },
            { "ibb", "\u0908\u092c\u093f\u092c\u093f\u092f\u2019" },
            { "ikt", "\u0938\u094b\u0928\u093e\u092c\u093e\u0930\u093f \u0915\u093e\u0928\u093e\u0921\u093f\u092f\u093e\u0928 \u0907\u0928\u0941\u0915\u094d\u0924\u093f\u0924\u0941\u0924" },
            { "ilo", "\u0907\u0932\u2019\u0915\u2019" },
            { "inh", "\u0908\u0902\u0917\u0941\u0937" },
            { "jbo", "\u0932\u2019\u091c\u092c\u093e\u0928" },
            { "jgo", "\u0928\u094d\u0917\u092e\u094d\u092c\u093e" },
            { "jmc", "\u092e\u0947\u091a\u093e\u092e\u0947" },
            { "jpr", "\u092f\u0939\u0941\u0926\u0940 \u092b\u093c\u093e\u0930\u0938\u0940" },
            { "jrb", "\u092f\u0939\u0941\u0926\u0940 \u0905\u0930\u092c\u0940" },
            { "kaa", "\u0915\u093e\u0930\u093e \u0915\u0932\u092a\u0915" },
            { "kab", "\u0915\u093e\u092c\u0940\u0932" },
            { "kac", "\u0915\u093e\u091a\u0940\u0928" },
            { "kaj", "\u091d\u0941" },
            { "kam", "\u0915\u093e\u092e\u094d\u092c\u093e" },
            { "kaw", "\u0915\u093e\u0935\u0940" },
            { "kbd", "\u0915\u093e\u092c\u093e\u0930\u094d\u0921\u0940\u092f\u093e\u0928\u093f" },
            { "kcg", "\u0924\u094d\u092f\u093e\u092a" },
            { "kde", "\u092e\u093e\u0915\u2019\u0923\u094d\u0921\u0947" },
            { "kea", "\u0915\u093e\u092c\u0941\u092d\u0947\u0930\u094d\u0921\u0940\u092f\u093e\u0928\u0941" },
            { "kfo", "\u0915\u0930\u2019" },
            { "kgp", "\u0915\u093e\u0908\u0919\u093e\u0902" },
            { "kha", "\u0916\u093e\u0938\u093f" },
            { "kho", "\u0916\u093c\u094b\u0924\u093e\u0928\u0940" },
            { "khq", "\u0915\u0908\u0930\u093e \u091a\u0940\u0928\u093f" },
            { "kkj", "\u0915\u093e\u0915\u2019" },
            { "kln", "\u0915\u093e\u0932\u0947\u0928\u091c\u093f\u0928" },
            { "kmb", "\u0915\u093f\u092e\u094d\u092c\u0941\u0928\u094d\u0921\u0941" },
            { "kok", "\u0915\u094b\u0902\u0915\u0923\u0940" },
            { "kos", "\u0915\u094b\u0938\u094d\u0930\u093e\u0908\u092f\u0928\u094d" },
            { "kpe", "\u0915\u094d\u092a\u0947\u0932\u0947" },
            { "krc", "\u0915\u0930\u093e\u091a\u092f-\u092c\u0932\u0915\u093e\u0930" },
            { "krl", "\u0915\u0930\u0947\u0932\u093f\u092f\u093e\u0928" },
            { "kru", "\u0915\u0941\u0930\u0941\u0916" },
            { "ksb", "\u0936\u093e\u092e\u092c\u093e\u0932\u093e" },
            { "ksf", "\u092c\u093e\u092b\u093f\u092f\u093e" },
            { "ksh", "\u0915\u0932\u0917\u0928\u094d\u092f\u093e\u0928" },
            { "kum", "\u0915\u0941\u092e\u0940\u0915" },
            { "kut", "\u0915\u0941\u0924\u0947\u0928\u093e\u0908" },
            { "kwk", "\u0915\u094d\u0935\u093e\u0915\u0935\u093e\u0932\u093e" },
            { "lad", "\u0932\u093e\u0921\u0940\u0928\u2019" },
            { "lag", "\u0932\u093e\u0919\u093f" },
            { "lah", "\u0932\u093e\u0939\u094d\u0921\u093e\u0902" },
            { "lam", "\u0932\u093e\u0902\u092c\u093e" },
            { "lez", "\u0932\u0947\u091c\u0918\u0940\u092f\u093e\u0928" },
            { "lil", "\u0932\u093f\u0932\u094d\u0932\u0941\u0935\u0947\u0924" },
            { "lkt", "\u0932\u093e\u0915\u2019\u0924\u093e" },
            { "lol", "\u092e\u094b\u0902\u0917\u094b" },
            { "lou", "\u0932\u0941\u0908\u0938\u093f\u092f\u093e\u0928\u093e \u0915\u094d\u0930\u0947\u0935\u0932" },
            { "loz", "\u0932\u2019\u091c\u0940" },
            { "lrc", "\u0938\u093e\u0939\u093e\u092f\u093e\u0930\u093f \u0932\u0941\u0930\u0940" },
            { "lsm", "\u0938\u093e\u092e\u0940\u092f\u093e" },
            { "lua", "\u0932\u0941\u092c\u093e \u0932\u0941\u0932\u0941\u0906" },
            { "lui", "\u0932\u0941\u0908\u0938\u0947\u0928\u094b" },
            { "lun", "\u0932\u0941\u0923\u094d\u0921\u093e" },
            { "luo", "\u0932\u0941\u0905\u2019" },
            { "lus", "\u0932\u0941\u0936\u093e\u0908" },
            { "luy", "\u0932\u0941\u0908\u092f\u093e" },
            { "mad", "\u092e\u093e\u0926\u0941\u0930\u0940\u091c" },
            { "mag", "\u092e\u0917\u093e\u0939\u0940" },
            { "mai", "\u092e\u0948\u0925\u0940\u0932\u0940" },
            { "mak", "\u092e\u093e\u0915\u093e\u0938\u093e\u0930" },
            { "man", "\u092e\u093e\u0902\u0921\u0940\u0902\u0917\u094b" },
            { "mas", "\u092e\u093e\u0938\u093e\u0908" },
            { "mdf", "\u092e\u094b\u0915\u094d\u0937\u093e" },
            { "mdr", "\u092e\u0902\u0926\u093e\u0930" },
            { "men", "\u092e\u0947\u0928\u094d\u0926\u0947" },
            { "mer", "\u092e\u0947\u0930\u0941" },
            { "mfe", "\u092e\u0930\u093f\u091b\u094d\u092f\u0947\u0928" },
            { "mga", "\u092e\u0927\u094d\u092f \u0906\u0908\u0930\u0940\u0936 \u092d\u093e\u0937\u093e" },
            { "mgh", "\u092e\u093e\u0916\u0941\u0935\u093e- \u092e\u0940\u091f\u094d\u091f\u2019" },
            { "mgo", "\u092e\u0947\u0924\u093e" },
            { "mic", "\u092e\u093f\u0908\u0915\u092e\u093e\u0915" },
            { "min", "\u092e\u093f\u0928\u093e\u0902\u0915\u093e\u092c\u093e\u090a" },
            { "mnc", "\u092e\u093e\u0902\u091a\u0941" },
            { "mni", "\u092e\u0928\u093f\u092a\u0941\u0930\u0940" },
            { "moe", "\u0907\u0928\u094d\u0928\u0941-\u0906\u0907\u092e\u0941\u0928" },
            { "moh", "\u092e\u0939\u093e\u0909\u0915" },
            { "mos", "\u092e\u0938\u094d\u0938\u0940" },
            { "mua", "\u092e\u0941\u0928\u094d\u0926\u093e\u0902" },
            { "mul", "\u0917\u094b\u092c\u093e\u0902 \u0930\u093e\u0935\u092b\u094b\u0930" },
            { "mus", "\u092e\u0941\u0938\u094d\u0915\u2019\u0917\u0940" },
            { "mwl", "\u092e\u093f\u0930\u093e\u0923\u094d\u0921\u0940\u091c" },
            { "mwr", "\u092e\u093e\u0930\u0935\u093e\u0921\u093c\u0940" },
            { "myv", "\u090f\u0930\u094d\u091c\u0940\u092f\u093e" },
            { "mzn", "\u092e\u093e\u091c\u093e\u0928\u094d\u0926\u0947\u0930\u093e\u0928\u093f" },
            { "nap", "\u0928\u093f\u092f\u093e\u092a\u0932\u093f\u091f\u093e\u0928" },
            { "naq", "\u0928\u093e\u092e\u093e" },
            { "nds", "\u0917\u093e\u0939\u093e\u092f \u091c\u093e\u0930\u094d\u092e\u093e\u0928" },
            { "new", "\u0928\u0947\u0935\u093e\u0930\u0940" },
            { "nia", "\u0928\u093f\u092f\u093e\u0938" },
            { "niu", "\u0928\u093f\u092f\u0941\u0907\u0906\u0928" },
            { "nmg", "\u0915\u094d\u0935\u093e\u0938\u093f\u0905\u2019" },
            { "nnh", "\u0928\u094d\u0917\u0940\u090f\u092e\u094d\u092c\u0942\u0928" },
            { "nog", "\u0928\u2019\u0917\u093e\u0908" },
            { "non", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0928\u0949\u0930\u094d\u0938\u094d" },
            { "nqo", metaValue_nqo },
            { "nso", "\u0938\u093e\u0939\u093e\u092f\u093e\u0930\u093f \u0938\u0925\u2019" },
            { "nus", "\u0928\u0942\u0935\u0947\u0930" },
            { "nwc", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0928\u0947\u0935\u093e\u0930\u0940" },
            { "nym", "\u0928\u094d\u092f\u093e\u092e\u0935\u0947\u091c\u093c\u0940" },
            { "nyn", "\u0928\u094d\u092f\u093e\u0928\u0915\u094b\u0932\u0947" },
            { "nyo", "\u0928\u094d\u092f\u094c\u0930\u094b" },
            { "nzi", "\u0928\u094d\u091c\u093c\u0940\u092e\u093e" },
            { "ojb", "\u0938\u093e\u0939\u093e-\u0938\u094b\u0928\u093e\u092c\u093e\u0930\u093f \u0905\u091c\u093f\u092c\u094d\u0935\u093e" },
            { "ojc", "\u092e\u093f\u0930\u0941 \u0905\u091c\u093f\u092c\u094d\u0935\u093e" },
            { "ojs", "\u0905\u091c\u093f \u0915\u094d\u0930\u0940" },
            { "ojw", "\u0938\u094b\u0928\u093e\u092c\u093e\u0930\u093f \u0905\u091c\u093f\u092c\u094d\u0935\u093e" },
            { "oka", "\u0905\u0915\u093e\u0928\u093e\u0917\u093e\u0928" },
            { "osa", "\u0913\u0938\u0947\u091c" },
            { "ota", "\u0924\u0941\u0930\u094d\u0915\u0940 \u0913\u091f\u094b\u092e\u093e\u0928" },
            { "pag", "\u092a\u093e\u0919\u093e\u0938\u093f\u0928\u093e\u0928" },
            { "pal", "\u092a\u0939\u0932\u0935\u0940" },
            { "pam", "\u092a\u093e\u092e\u094d\u092a\u093e\u0919\u093e" },
            { "pap", "\u092a\u093e\u092a\u0940\u0906\u092e\u0947\u0928\u094d\u0924\u094b" },
            { "pau", "\u092a\u093e\u0932\u093e\u090a\u0935\u093e\u0928" },
            { "pcm", "\u0928\u093e\u0907\u091c\u0947\u0930\u093f\u092f\u093e\u0928 \u092a\u093f\u0926\u091c\u0940\u0928" },
            { "peo", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092b\u093c\u093e\u0930\u0938\u0940" },
            { "phn", "\u092b\u0940\u0928\u0940\u0938\u0940" },
            { "pis", "\u092a\u093f\u091c\u093f\u0928" },
            { "pon", "\u092a\u094b\u0939\u0928\u092a\u0940" },
            { "pqm", "\u092e\u093e\u0932\u093f\u0938\u0940\u0924- \u092a\u093e\u0938\u094d\u0938\u093e\u092e\u0915\u094d\u0935\u0926\u094d\u0926\u0940" },
            { "pro", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092a\u094d\u0930\u094b\u0935\u093e\u0901\u0938\u093e\u0932" },
            { "raj", "\u0930\u093e\u091c\u0938\u094d\u0925\u093e\u0928\u0940" },
            { "rap", "\u0930\u093e\u092a\u093e\u0928\u0941\u0908" },
            { "rar", "\u0930\u093e\u0930\u2019\u091f\u0902\u0917\u093e\u0928" },
            { "rhg", "\u0930\u0939\u093f\u0902\u0917\u0940\u092f\u093e" },
            { "rof", "\u0930\u092e\u094d\u092c\u2019" },
            { "rom", "\u0930\u0941\u092e\u093e\u0928\u0940" },
            { "rup", "\u0906\u0930\u094b\u092e\u093e\u0928\u093f\u092f\u093e\u0928" },
            { "rwk", "\u0930\u094d\u0935\u093e" },
            { "sad", "\u0938\u093e\u0923\u094d\u0921\u093e\u0935\u0947" },
            { "sah", "\u0938\u093e\u0916\u093e" },
            { "sam", "\u0938\u092e\u093e\u0930\u0940\u0924\u0940 \u0906\u0930\u093e\u092e\u093e\u0908\u0915\u093c" },
            { "saq", "\u0938\u093e\u092e\u094d\u092c\u0941\u0930\u0942" },
            { "sas", "\u0938\u093e\u0938\u0915" },
            { "sat", "\u0938\u093e\u0928\u094d\u0925\u093e\u0932\u0940" },
            { "sba", "\u0928\u094d\u0917\u093e\u092e\u094d\u092c\u0948" },
            { "sbp", "\u0938\u093e\u0919\u0941" },
            { "scn", "\u0938\u093f\u0938\u093f\u0932\u093f\u092f\u093e\u0928" },
            { "sco", "\u0938\u094d\u0915\u2019\u091f\u0938" },
            { "seh", "\u0938\u0947\u0928\u093e" },
            { "sel", "\u0938\u0947\u0932\u0915\u0941\u092a" },
            { "ses", "\u0915\u0908\u0930\u093e\u092c\u0930\u2019 \u0938\u0947\u0928\u094d\u0928\u093f" },
            { "sga", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0906\u0908\u0930\u0940\u0936" },
            { "shi", "\u0924\u093e\u091a\u0947\u0932\u094d\u0939\u0940\u091f" },
            { "shn", "\u0936\u093e\u0928" },
            { "sid", "\u0938\u0940\u0926\u093e\u092e\u094b" },
            { "slh", "\u0916\u094b\u0932\u093e\u092f\u093e\u0930\u093f \u0932\u093e\u0936\u0941\u0924\u0938\u0940\u0926" },
            { "sma", "\u092a\u0936\u094d\u091a\u0940\u092e\u0940 \u0938\u093e\u092e\u0940" },
            { "smj", "\u0932\u0941\u0932\u0947 \u0938\u093e\u092e\u0940" },
            { "smn", "\u0908\u0928\u093e\u0930\u0940 \u0938\u093e\u092e\u0940" },
            { "sms", "\u0938\u094d\u0915\u0932\u094d\u091f \u0938\u093e\u092e\u0940" },
            { "snk", "\u0938\u2019\u0928\u093f\u0928\u094d\u0915\u0947" },
            { "sog", "\u0938\u094b\u0917\u0921\u0940\u092f\u0928" },
            { "srn", "\u0938\u094d\u0930\u093e\u0928\u093e\u0928 \u091f\u0902\u0917\u2019" },
            { "srr", "\u0938\u0947\u0930\u0947\u0930" },
            { "str", "\u0938\u094d\u091f\u094d\u0930\u0948\u0924\u094d\u0938 \u0938\u093e\u0932\u093f\u0936" },
            { "suk", "\u0938\u0941\u0915\u0941\u092e\u093e" },
            { "sus", "\u0938\u0941\u0938\u0941" },
            { "sux", "\u0938\u0941\u092e\u0947\u0930\u093f\u0905\u0928" },
            { "swb", "\u0915\u092e\u0930\u093f\u092f\u093e\u0928" },
            { "syc", "\u092a\u093e\u0930\u0902\u092a\u0930\u0940\u0915 \u0938\u093f\u0930\u093f\u0906\u0915" },
            { "syr", "\u0938\u093f\u0930\u093f\u0906\u0915" },
            { "tce", "\u0916\u094b\u0932\u093e\u092f\u093e\u0930\u093f \u0924\u093e\u0924\u094d\u091a\u0928\u0947" },
            { "tem", "\u0924\u0940\u092e\u0928\u0947" },
            { "teo", "\u0924\u0947\u0938\u2019" },
            { "ter", "\u0924\u0947\u0930\u0947\u0928\u094b" },
            { "tet", "\u0924\u0947\u0924\u0941\u092e" },
            { "tgx", "\u0924\u093e\u0917\u0940\u0936" },
            { "tht", "\u091f\u093e\u0939\u0932\u094d\u091f\u093e\u0928" },
            { "tig", "\u091f\u0940\u0917\u094d\u0930\u0947" },
            { "tiv", "\u091f\u0940\u0935\u094d" },
            { "tkl", "\u091f\u094b\u0915\u0947\u0932\u094c" },
            { "tlh", "\u0915\u094d\u0932\u093f\u0919\u2019\u0928" },
            { "tli", "\u0924\u094d\u0932\u093f\u0919\u0940\u0924" },
            { "tmh", "\u0924\u092e\u093e\u0936\u0947\u0915" },
            { "tog", "\u0928\u094d\u092f\u093e\u0938\u093e \u091f\u0949\u0902\u0917\u093e" },
            { "tok", "\u091f\u0915\u093f \u092a\u0928\u093e" },
            { "tpi", "\u091f\u2019\u0915 \u092a\u093f\u0938\u0940\u0928" },
            { "trv", "\u0924\u093e\u0930\u2019\u0915\u2019" },
            { "tsi", "\u0924\u094d\u0938\u0940\u092e\u0936\u0940\u0906\u0928\u094d" },
            { "ttm", "\u0938\u093e\u0939\u093e\u092f\u093e\u0930\u093f \u0924\u093e\u0924\u094d\u091a\u2019\u0928\u0947" },
            { "tum", "\u0924\u0941\u092e\u094d\u092c\u0941\u0915\u093e" },
            { "tvl", "\u091f\u0941\u092d\u093e\u0932\u0941" },
            { "twq", "\u0924\u0947\u0938\u093e\u0935\u093e\u0915" },
            { "tyv", "\u0924\u0941\u092d\u093f\u0928\u093f\u092f\u093e\u0928" },
            { "tzm", "\u0938\u0947\u0928\u094d\u091f\u094d\u0930\u0947\u0932 \u0906\u091f\u0932\u093e\u0938 \u0924\u093e\u092e\u093e\u091c\u093e\u0908\u091f" },
            { "udm", "\u0909\u0921\u092e\u0941\u0930\u094d\u0924" },
            { "uga", "\u0909\u0917\u093e\u0930\u093f\u0924\u0940" },
            { "umb", "\u0909\u092e\u094d\u092c\u0941\u0928\u094d\u0921\u0941" },
            { "und", "\u092e\u093f\u0925\u093f\u092f\u0948 \u0930\u093e\u0935" },
            { "vai", metaValue_vai },
            { "vot", "\u0935\u094b\u091f\u0940\u0915" },
            { "vun", "\u092d\u0941\u0928\u094d\u091c\u2019" },
            { "wae", "\u0935\u093e\u0932\u094d\u0938\u093e\u0930" },
            { "wal", "\u0935\u0932\u093e\u0908\u0924\u094d\u0924\u093e" },
            { "war", "\u0935\u093e\u0930\u0948" },
            { "was", "\u0935\u093e\u0936\u094b" },
            { "wuu", "\u0935\u0941 \u091a\u093e\u0907\u0928\u0940\u091c" },
            { "xal", "\u0915\u093e\u0932\u092e\u0940\u0915" },
            { "xog", "\u0938\u2019\u0917\u093e" },
            { "yao", "\u092f\u093e\u0913" },
            { "yap", "\u092f\u093e\u092a\u0940\u091c\u093c" },
            { "yav", "\u092f\u093e\u0902\u092c\u0947\u0928" },
            { "ybb", "\u092f\u0947\u092e\u094d\u092c\u093e" },
            { "yrl", "\u0928\u094d\u0939\u0940\u0917\u093e\u0924\u0942" },
            { "yue", "\u0915\u0947\u0928\u094d\u091f\u0928\u093f\u091c" },
            { "zap", "\u091c\u093c\u093e\u092a\u094b\u0924\u0947\u0915" },
            { "zbl", "\u092c\u094d\u0932\u0940\u0938 \u091a\u093f\u0928\u094d\u0939" },
            { "zen", "\u091c\u093c\u0947\u0928\u093e\u0917\u093e" },
            { "zgh", "\u0938\u094d\u091f\u0947\u0928\u094d\u0926\u093e\u0930\u094d\u0926 \u092e\u0930\u0915\u094d\u0915\u093e\u0928 \u0924\u093e\u092e\u093e\u091c\u093e\u0908\u091f" },
            { "zun", "\u091c\u0941\u0928\u0940" },
            { "zxx", "\u0930\u093e\u0935\u0906\u0930\u093f \u0906\u092f\u0926\u093e\u092b\u094b\u0930 \u091c\u0947\u092c\u094b \u0917\u0948\u092f\u093e" },
            { "zza", "\u091c\u093e\u091c\u093e" },
            { "Adlm", "\u0906\u0926\u0932\u093e\u092e" },
            { "Arab", metaValue_ar },
            { "Aran", "\u0928\u093e\u0938\u094d\u0924\u093e\u0932\u093f\u0915" },
            { "Armi", "\u0936\u0939\u0928\u0936\u093e\u0939\u0940 \u0906\u0930\u093e\u092e\u093e\u0908\u0915" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", "\u092c\u093e\u0932\u0940" },
            { "Batk", "\u092c\u091f\u0915\u0940" },
            { "Beng", metaValue_bn },
            { "Blis", "\u092c\u094d\u0932\u0940\u0938 \u091a\u0940\u0928\u094d\u0939" },
            { "Bopo", "\u092c\u092a\u2019\u092e\u092b\u2019" },
            { "Brah", "\u092c\u094d\u0930\u0939\u094d\u092e\u0940" },
            { "Brai", "\u092c\u094d\u0930\u0948\u0932" },
            { "Bugi", "\u092c\u0941\u0917\u0940\u0928\u0940" },
            { "Buhd", "\u092c\u0941\u0939\u0940\u0926" },
            { "Cakm", metaValue_ccp },
            { "Cans", "\u091c\u0925\u093e\u092f \u0915\u093e\u0928\u093e\u0921\u0940\u092f\u093e\u0928 \u0925\u093e\u0917\u093f\u092c\u093f\u092f\u093e\u0930\u093f \u0930\u093f\u0902\u0938\u093e\u0930 \u0939\u093e\u0928\u091c\u093e" },
            { "Cari", "\u0915\u093e\u0930\u093f\u092f\u0928" },
            { "Cham", "\u0915\u0945\u092e" },
            { "Cher", "\u091a\u0947\u0930\u2019\u0915\u0940" },
            { "Cirt", "\u0938\u093f\u0930\u094d\u0925" },
            { "Copt", "\u0915\u0949\u092a\u094d\u091f" },
            { "Cprt", "\u0938\u0940\u092a\u094d\u0930\u0940\u0913\u091f\u094d" },
            { "Cyrl", "\u0938\u093f\u0930\u093f\u0932\u094d\u0932\u093f\u0915" },
            { "Cyrs", "\u092a\u0941\u0930\u093e\u0928\u0940 \u091a\u0930\u094d\u091a \u0938\u093f\u0930\u093f\u0932\u093f\u0915\u094d" },
            { "Deva", "\u0926\u0947\u092c\u0928\u093e\u0917\u093f\u0930\u093f" },
            { "Dsrt", "\u0926\u0947\u0938\u0947\u0930\u091f\u094d" },
            { "Egyd", "\u092e\u0940\u0938\u094d\u0930\u0940 \u0921\u0948\u092e\u094b\u091f\u0940\u0915\u094d" },
            { "Egyh", "\u092e\u0940\u0938\u094d\u0930\u0940 \u0939\u0948\u0930\u0948\u091f\u0940\u0915\u094d" },
            { "Egyp", "\u092e\u0940\u0938\u094d\u0930\u0940 \u0939\u0948\u0930\u094b\u0917\u094d\u0932\u0940\u092b\u093c\u094d" },
            { "Ethi", "\u0908\u0925\u093f\u092f\u092a\u093f\u0915" },
            { "Geok", "\u091c\u094b\u0930\u094d\u091c\u0940\u092f\u0928 \u0916\u0941\u0924\u0938\u0941\u0930\u0940" },
            { "Geor", metaValue_ka },
            { "Glag", "\u0917\u094d\u0932\u0948\u0917\u094b\u0932\u093f\u091f\u0940\u0915" },
            { "Goth", "\u0917\u094c\u0925\u0940\u0915" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0917\u0941\u0930\u092e\u0941\u0916\u0940" },
            { "Hanb", "\u092c\u092a\u2019\u092e\u092b\u2019 \u0925\u093e\u0928\u093e\u092f \u0939\u093e\u0928" },
            { "Hang", "\u0939\u093e\u0902\u0917\u0941\u0932" },
            { "Hani", "\u0939\u093e\u0928" },
            { "Hano", "\u0939\u093e\u0928\u0941\u0928\u0941" },
            { "Hans", "\u0917\u094b\u0930\u0932\u0948 \u0916\u093e\u0932\u093e\u092e\u0928\u093e \u0939\u094b\u0928\u093e\u092f" },
            { "Hant", "\u0906\u0938\u093e\u0930-\u0916\u093e\u0928\u094d\u0925\u093f\u0928\u093f" },
            { "Hebr", "\u0939\u093f\u092c\u094d\u0930\u093f\u090a" },
            { "Hira", "\u0939\u0940\u0930\u093e\u0917\u093e\u0928\u093e" },
            { "Hmng", "\u092a\u093e\u0939\u0935\u093e\u0939 \u0939\u094d\u092e\u094c\u0902\u0917" },
            { "Hrkt", "\u091c\u093e\u092a\u093e\u0928\u0940\u091c \u0930\u093f\u0902\u0938\u093e\u0930\u0925\u093f\u092b\u094b\u0930/\u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "Hung", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0939\u0902\u0917\u0948\u0930\u0940\u092f\u0928" },
            { "Inds", "\u0938\u093f\u0928\u094d\u0927\u0941" },
            { "Ital", "\u092a\u0941\u0930\u093e\u0928\u0940 \u0907\u091f\u0948\u0932\u093f\u092f\u0928" },
            { "Jamo", "\u091c\u093e\u092e\u2019" },
            { "Java", "\u091c\u093e\u0935\u093e\u0928\u0940\u0938" },
            { "Jpan", metaValue_ja },
            { "Kali", "\u0915\u093e\u092f\u093e\u0939 \u0932\u0940" },
            { "Kana", "\u0915\u093e\u0924\u093e\u0915\u093e\u0928\u093e" },
            { "Khar", "\u0916\u0930\u094b\u0937\u094d\u091f\u0940" },
            { "Khmr", metaValue_km },
            { "Knda", "\u0915\u0923\u094d\u0923\u0921\u093e" },
            { "Kore", "\u0915\u2019\u0930\u0940\u092f\u093e\u0928" },
            { "Lana", "\u0932\u093e\u0928\u093e" },
            { "Laoo", "\u0932\u093e\u0913" },
            { "Latf", "\u092b\u094d\u0930\u0948\u0915\u094d\u0924\u0941\u0930 \u0932\u0948\u091f\u093f\u0928" },
            { "Latg", "\u0917\u0948\u0932\u0940\u0915 \u0932\u0948\u091f\u093f\u0928" },
            { "Latn", metaValue_la },
            { "Lepc", "\u0932\u0947\u092a\u091a\u093e" },
            { "Limb", "\u0932\u093f\u092e\u094d\u092c\u0941" },
            { "Lina", "\u0932\u0940\u0928\u0940\u092f\u0930 \u090f" },
            { "Linb", "\u0932\u0940\u0928\u0940\u092f\u0930 \u092c\u0940" },
            { "Lyci", "\u0932\u0940\u0938\u0940\u092f\u0928" },
            { "Lydi", "\u0932\u0940\u0921\u0940\u092f\u0928" },
            { "Mand", "\u092e\u093e\u0902\u0921\u0947" },
            { "Mani", "\u092e\u093e\u0928\u0940\u0915\u0940" },
            { "Maya", "\u092e\u093e\u092f\u093e \u0939\u0940\u0930\u094b\u0917\u094d\u0932\u0940\u092b\u094d" },
            { "Mero", "\u092e\u0947\u0930\u094b\u0908\u091f\u0940\u0915\u094d" },
            { "Mlym", "\u092e\u0932\u092f\u093e\u0932\u092e" },
            { "Mong", metaValue_mn },
            { "Moon", "\u092e\u0941\u0928\u094d" },
            { "Mtei", "\u092e\u0948\u0924\u0947\u0908 \u092e\u093e\u092f\u0947\u0915" },
            { "Mymr", metaValue_MM },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "\u0913\u0917\u0939\u0948\u092e" },
            { "Olck", "\u0905\u0932 \u091a\u0940\u0915\u0940" },
            { "Orkh", "\u0913\u0930\u0916\u094b\u0928" },
            { "Orya", "\u0909\u0921\u093c\u093f\u092f\u093e" },
            { "Osma", "\u0913\u0938\u094d\u092e\u093e\u0928\u093f\u092f\u093e" },
            { "Perm", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092a\u0930\u094d\u092e\u0940\u0915\u094d" },
            { "Phag", "\u092b\u093e\u0917\u094d\u0938 \u092a\u093e" },
            { "Phlv", "\u092c\u0941\u0915 (\u0938\u093e\u0932\u091f\u0930) \u092a\u0939\u0932\u0935\u0940" },
            { "Phnx", "\u092b\u094b\u0928\u0940\u0936\u0940\u092f\u0928" },
            { "Plrd", "\u092a\u094c\u0932\u093e\u0930\u094d\u0921\u093c \u092b\u094b\u0928\u0947\u091f\u0940\u0915" },
            { "Rjng", "\u0930\u0947\u091c\u0947\u0902\u0917" },
            { "Rohg", "\u0939\u093e\u0928\u093f\u092b\u093f" },
            { "Roro", "\u0930\u094b\u0902\u0917\u094b\u0930\u094b\u0902\u0917\u094b" },
            { "Runr", "\u0930\u0942\u0928\u093f\u0915" },
            { "Samr", "\u0938\u092e\u093e\u0930\u0924\u0940" },
            { "Sara", "\u0938\u0930\u093e\u0924\u0940" },
            { "Saur", "\u0938\u094c\u0930\u093e\u0937\u094d\u091f\u094d\u0930" },
            { "Sgnw", "\u0938\u093e\u0902\u0915\u0947\u0924\u093f\u0915 \u0932\u0947\u0916" },
            { "Shaw", "\u0936\u0947\u0935\u093f\u092f\u0928" },
            { "Sinh", "\u0938\u093f\u0902\u0939\u093e\u0932\u0940" },
            { "Sund", "\u0938\u0942\u0928\u094d\u0921\u093e\u0928\u0940\u091c" },
            { "Sylo", "\u0938\u0940\u0932\u094d\u0939\u094b\u091f\u0940 \u0928\u093e\u0917\u0930\u0940" },
            { "Syrc", "\u0938\u0940\u0930\u0940\u0906\u0915" },
            { "Syre", "\u090f\u0938\u094d\u091f\u094d\u0930\u093e\u0902\u0917\u0932\u094b \u0938\u0940\u0930\u0940\u0906\u0915" },
            { "Syrj", "\u092a\u0936\u094d\u091a\u0940\u092e\u0940 \u0938\u0940\u0930\u0940\u0906\u0915" },
            { "Syrn", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0938\u0940\u0930\u0940\u0906\u0915" },
            { "Tagb", "\u0924\u093e\u0917\u092c\u093e\u0928\u0935\u093e" },
            { "Tale", "\u0924\u093e\u0908 \u0932\u0947" },
            { "Talu", "\u0928\u092f\u093e \u0924\u093e\u0908 \u0932\u0941\u090f" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Teng", "\u0924\u0947\u0902\u0917\u0935\u093e\u0930" },
            { "Tfng", "\u0924\u093f\u092b\u093f\u0928\u093e\u0918" },
            { "Tglg", "\u091f\u093e\u0917\u093e\u0932\u0949\u0917" },
            { "Thaa", "\u0925\u093e\u0928\u093e" },
            { "Thai", metaValue_th },
            { "Tibt", "\u0924\u093f\u092c\u0947\u0924\u093e\u0928" },
            { "Ugar", "\u090a\u0917\u093e\u0930\u0940\u091f\u0940\u0915" },
            { "Vaii", metaValue_vai },
            { "Visp", "\u0935\u0940\u091c\u093c\u0940\u092c\u0932 \u092c\u094b\u0932\u0940" },
            { "Xpeo", "\u092a\u0941\u0930\u093e\u0928\u0940 \u092b\u093e\u0930\u0938\u0940" },
            { "Xsux", "\u0938\u0941\u092e\u0947\u0930\u094b \u0905\u0915\u094d\u0915\u093e\u0921\u093c\u0940 \u0915\u0941\u0928\u0947\u0908\u092b\u0949\u0930\u094d\u092e" },
            { "Yiii", "\u092f\u0940" },
            { "Zinh", "\u0935\u093f\u0930\u093e\u0938\u0924" },
            { "Zmth", "\u0938\u093e\u0928\u0916\u093e\u0928\u094d\u0925\u093f\u092f\u093e\u0930\u093f \u0926\u0948\u0926\u0947\u0928\u094d\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "Zsye", "\u0908\u092e\u2019\u091c\u0940" },
            { "Zsym", "\u0928\u0947\u0930\u094d\u0938\u094b\u0928\u092b\u094b\u0930" },
            { "Zxxx", "\u0932\u093f\u0930\u0948" },
            { "Zyyy", "\u0938\u093e\u0927\u093e\u0930\u0928" },
            { "Zzzz", "\u092e\u093f\u0925\u093f\u092f\u0948 \u0939\u093e\u0902\u0916\u094b" },
            { "de_AT", "\u0905\u0938\u094d\u091f\u094d\u0930\u0947\u092f\u093e\u0906\u0930\u093f \u091c\u093e\u0930\u094d\u092e\u093e\u0928" },
            { "de_CH", "\u0938\u0941\u0907\u0938 \u0917\u094b\u091c\u094c \u091c\u093e\u0930\u094d\u092e\u093e\u0928" },
            { "en_AU", "\u0905\u0938\u094d\u091f\u094d\u0930\u0947\u0932\u093f\u092f\u093e\u0928\u093f \u0907\u0902\u0930\u093e\u091c\u0940" },
            { "en_CA", "\u0915\u093e\u0928\u093e\u0921\u093e\u0928\u093f \u0907\u0902\u0930\u093e\u091c\u0940" },
            { "en_GB", "\u092c\u094d\u0930\u093f\u091f\u093f\u0936 \u0907\u0902\u0930\u093e\u091c\u0940" },
            { "en_US", "\u0906\u092e\u0947\u0930\u093f\u0915\u093e\u0928\u093f \u0907\u0902\u0930\u093e\u091c\u0940" },
            { "es_ES", "\u092f\u0941\u0930\u094b\u092a\u0928\u093f \u0938\u094d\u092a\u0947\u0928\u093f\u0936" },
            { "es_MX", "\u092e\u0947\u0915\u094d\u0938\u093f\u0915\u2019\u0928\u093f \u0938\u094d\u092a\u0947\u0928\u093f\u0936" },
            { "fa_AF", "\u0921\u093e\u0930\u0940" },
            { "fr_CA", "\u0915\u093e\u0928\u093e\u0921\u093e\u0928\u093f \u092b\u094d\u0930\u0947\u0928\u094d\u091a" },
            { "fr_CH", "\u0938\u0941\u0907\u0938 \u092b\u094d\u0930\u0947\u0928\u094d\u091a" },
            { "nl_BE", "\u092b\u094d\u0932\u0947\u092e\u093f\u0938" },
            { "pt_BR", "\u092c\u094d\u0930\u093e\u091c\u093f\u0932\u0928\u093f \u092a\u0930\u094d\u091f\u0941\u0917\u093f\u091c" },
            { "pt_PT", "\u092f\u0941\u0930\u094b\u092a\u0928\u093f \u092a\u0930\u094d\u091f\u0941\u0917\u093f\u091c" },
            { "ro_MD", "\u092e\u094b\u0932\u094d\u0921\u0947\u0935\u093f\u092f\u0928\u094d" },
            { "%%1901", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u091c\u0930\u094d\u092e\u0928 \u0935\u0930\u094d\u0924\u0928\u0940 1901" },
            { "%%1994", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u0930\u0947\u0938\u0940\u092f\u0928 \u0935\u0930\u094d\u0924\u0928\u0940 1994" },
            { "%%1996", "\u091c\u0930\u094d\u092e\u0928 \u0935\u0930\u094d\u0924\u0928\u0940 1996" },
            { "ar_001", "\u0917\u094b\u0926\u093e\u0928 \u092e\u093e\u0928\u0925\u093e\u0916\u094b\u0906\u0930\u093f \u0906\u0930\u093e\u092c\u093f\u0915" },
            { "es_419", "\u0932\u0947\u091f\u0940\u0928 \u0906\u092e\u0947\u0930\u093f\u0915\u093e\u0928\u093f \u0938\u094d\u092a\u0947\u0928\u093f\u0936" },
            { "key.ca", "\u0915\u0947\u0932\u0947\u0923\u094d\u0921\u093e\u0930/\u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "key.cf", "\u092e\u0941\u0926\u094d\u0930\u093e\u0928\u093f \u0928\u0941\u0925\u093e\u092f" },
            { "key.co", "\u0930\u093e\u0928\u094d\u0928\u093e\u092f\u0928\u093f \u092b\u093e\u0930\u093f" },
            { "key.cu", "\u092e\u0941\u0926\u094d\u0930\u093e" },
            { "key.hc", "\u0918\u0928\u094d\u091f\u093e\u0928\u093f \u0917\u093f\u0926\u093f\u0902\u092b\u093f\u0928\u094d\u0928\u093e\u092f ( 12 \u092c\u0947\u0930\u0947\u0916\u093e 24)" },
            { "key.lb", "\u0939\u093e\u0902\u0916\u094b \u0938\u093f\u092b\u093e\u092f\u0928\u093e\u092f \u0926\u0939\u2018\u0919" },
            { "key.ms", "\u091c\u0916\u093e \u0932\u093e\u0928\u093e\u092f \u0906\u0926\u092c" },
            { "key.nu", "\u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "%%BISKE", "\u0938\u093e\u0928 \u091c\u0940\u0913\u0930\u094d\u091c\u0940\u0913 / \u092c\u0940\u0932\u093e \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "%%BOONT", "\u092c\u0941\u0928\u094d\u0924\u0932\u0940\u0902\u0917" },
            { "%%LIPAW", "\u0930\u0947\u091c\u093c\u0940\u092f\u0928 \u0915\u0940 \u0932\u0940\u092a\u094b\u0935\u093e\u091c\u093c \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "%%NEDIS", "\u0928\u093e\u091f\u0940\u0938\u094b\u0928 \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "%%NJIVA", "\u0917\u094d\u0928\u0940\u0935\u093e \u092f\u093e \u0928\u094d\u091c\u0940\u0935\u093e \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "%%OSOJS", "\u0913\u0938\u0947\u0906\u0915\u094b \u0913\u0938\u094b\u091c\u093e\u0928\u0947 \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "%%POSIX", "\u0915\u092e\u094d\u092a\u094d\u092f\u0942\u091f\u0930" },
            { "%%ROZAJ", "\u0930\u0947\u091c\u093c\u0940\u092f\u0928" },
            { "%%SAAHO", "\u0938\u093e\u0939\u094b" },
            { "%%SOLBA", "\u0936\u094d\u091f\u094b\u0932\u0935\u093f\u091c\u093c\u094d\u091c\u093c\u093e \u092f\u093e \u0938\u094b\u0932\u092c\u0940\u0915\u093e \u0921\u093e\u092f\u0932\u0947\u0915\u094d\u091f" },
            { "zh_Hans", "\u0917\u094b\u0930\u0932\u0948 \u0916\u093e\u0932\u093e\u092e\u0928\u093e\u092f \u091a\u093e\u0907\u0928\u0940\u091c" },
            { "zh_Hant", "\u0906\u0938\u093e\u0930-\u0916\u093e\u0928\u094d\u0925\u093f\u092f\u093e\u0930\u093f \u091a\u093e\u0907\u0928\u0940\u091c" },
            { "%%FONIPA", "\u0906\u0908\u092a\u0940\u090f \u092b\u093c\u094b\u0928\u0947\u091f\u0940\u0915\u094d\u0938" },
            { "%%FONUPA", "\u092f\u0941\u092a\u0940\u090f \u092b\u093c\u094b\u0928\u0947\u091f\u0940\u0915\u094d\u0938" },
            { "%%SCOUSE", "\u0938\u094d\u0915\u093e\u0909\u091c\u093c" },
            { "%%TARASK", "\u0924\u093e\u0930\u093e\u0938\u094d\u0915\u0940\u090f\u0935\u0940\u091a\u093e \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "%%AREVELA", "\u092a\u0942\u0930\u094d\u0935\u0940 \u0905\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0908" },
            { "%%MONOTON", "\u090f\u0915\u0938\u094d\u0935\u0930\u0940\u092f" },
            { "%%POLYTON", "\u092c\u0939\u0941\u0938\u094d\u0935\u0930\u0940\u092f" },
            { "%%REVISED", "\u0938\u0902\u0936\u094b\u0927\u093f\u0924 \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "%%1606NICT", "\u092e\u0927\u094d\u092f \u092b\u094d\u0930\u093e\u0902\u0938\u0940\u0938\u0940 1606 \u0924\u0915" },
            { "%%BAKU1926", "\u092f\u0941\u0928\u0940\u092b\u093e\u0908\u0921 \u0924\u0941\u0930\u094d\u0915\u0940 \u0932\u0948\u091f\u0940\u0928\u0940 \u0935\u0930\u094d\u0924\u0928\u0940" },
            { "%%SCOTLAND", "\u092e\u093e\u0928\u0915 \u0938\u094d\u0915\u0949\u091f \u0905\u0902\u0917\u094d\u0930\u0947\u091c\u093c\u0940" },
            { "type.ca.roc", "\u092e\u093f\u0902\u0917\u0941\u0935\u2019 \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.hc.h11", "12 \u0918\u0928\u094d\u091f\u093e\u0928\u093f \u0906\u0926\u092c (0\u201311)" },
            { "type.hc.h12", "12 \u0918\u0928\u094d\u091f\u093e\u0928\u093f \u0906\u0926\u092c (1\u201312)" },
            { "type.hc.h23", "24 \u0918\u0928\u094d\u091f\u093e\u0928\u093f \u0906\u0926\u092c ( 0\u201323)" },
            { "type.hc.h24", "24 \u0918\u0928\u094d\u091f\u093e\u0928\u093f \u0906\u0926\u092c ( 1\u201324)" },
            { "type.nu.arab", "\u0906\u0930\u093e\u092c\u093f\u0915-\u0907\u0923\u094d\u0921\u093f\u0915 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.armn", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0928\u093f \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b" },
            { "type.nu.beng", "\u092c\u093e\u0902\u0932\u093e \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.cakm", "\u091a\u093e\u0915\u092e\u093e \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.deva", "\u0926\u0947\u092c\u0928\u093e\u0917\u093f\u0930\u093f \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.ethi", "\u0907\u0925\u093f\u092f\u2019\u092a\u093f\u092f\u093e\u0928\u093f \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.geor", "\u091c\u0930\u094d\u091c\u093f\u092f\u093e\u0928 \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.grek", "\u0917\u094d\u0930\u0940\u0915 \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.gujr", "\u0917\u0941\u091c\u0930\u093e\u0924\u0940 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.guru", "\u0917\u0941\u0930\u092e\u0941\u0916\u0940 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.hans", "\u0917\u094b\u0930\u0932\u0948 \u0916\u093e\u0932\u093e\u092e\u0928\u093e\u092f \u091a\u093e\u0907\u0928\u0940\u091c \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.hant", "\u0906\u0938\u093e\u0930-\u0916\u093e\u0928\u094d\u0925\u093f\u092f\u093e\u0930\u093f \u091a\u093e\u0907\u0928\u0940\u091c \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.hebr", "\u0939\u093f\u092c\u094d\u0930\u093f\u0909 \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.java", "\u091c\u093e\u092d\u093e\u0928\u0940\u091c \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.jpan", "\u091c\u093e\u092a\u093e\u0928\u0940\u091c \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.khmr", "\u0916\u094d\u092e\u0947\u0930 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.knda", "\u0915\u093e\u0928\u094d\u0928\u093e\u0921\u093e \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.laoo", "\u0932\u093e\u0935 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.latn", "\u0938\u094b\u0928\u093e\u092c\u093e\u0930\u0940 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.mlym", "\u092e\u093e\u0932\u093e\u092f\u093e\u0932\u092e \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.mtei", "\u092e\u093f\u0924\u0948 \u092e\u093e\u092f\u0947\u0915 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.mymr", "\u092e\u094d\u092f\u093e\u0928\u092e\u093e\u0930\u0928\u093f \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.olck", "\u0905\u0932 \u091a\u093f\u0915\u093f \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.orya", "\u0905\u0930\u093f\u092f\u093e \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.taml", "\u0906\u0938\u093e\u0930 \u0916\u093e\u0928\u094d\u0925\u093f\u092f\u093e\u0930\u093f \u0924\u093e\u092e\u093f\u0932 \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.telu", "\u0924\u0947\u0932\u0941\u0917\u0941 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.thai", "\u0925\u093e\u0908 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.tibt", "\u0924\u093f\u092c\u094d\u092c\u0924\u093f \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.vaii", "\u092d\u093e\u0908 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.ca.dangi", "\u0926\u093e\u0902\u0917\u093f \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.co.ducet", "\u0917\u0930\u0939\u093e\u091c\u093f\u0930 \u0907\u0909\u0928\u093f\u0915\u0921 \u0930\u093e\u0928\u094d\u0928\u093e\u092f\u0928\u093f \u092b\u093e\u0930\u093f" },
            { "type.lb.loose", "\u0917\u0941\u0930\u0948 \u0939\u093e\u0902\u0916\u094b \u0938\u093f\u092b\u093e\u092f\u0928\u093e\u092f \u0926\u0939\u2018\u0919" },
            { "type.nu.roman", "\u0930\u092e\u093e\u0928 \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.ca.coptic", "\u0915\u092a\u094d\u0924\u093f\u0915 \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.ca.hebrew", "\u0939\u093f\u092c\u094d\u0930\u093f\u0909 \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.ca.indian", "\u092d\u093e\u0930\u0924\u0928\u093f \u0939\u093e\u0926\u094b\u0930\u0928\u093e\u0902 \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.co.pinyin", "\u092a\u093f\u0928\u092f\u0940\u0928 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "type.co.search", "\u0938\u093e\u0926\u093e\u0930\u0928-\u091c\u093e\u0939\u094b\u0928\u0928\u093f \u0928\u093e\u092f\u0917\u093f\u0930\u0928\u093e\u092f" },
            { "type.co.stroke", "\u0938\u094d\u091f\u094d\u0930\u094b\u0915 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "type.lb.normal", "\u091c\u093e\u0938\u093f\u092e\u093e \u0939\u093e\u0902\u0916\u094b \u0938\u093f\u092b\u093e\u092f\u0928\u093e\u092f \u0926\u0939\u2018\u0919" },
            { "type.lb.strict", "\u0917\u094b\u0916\u094d\u0930\u094b\u0902 \u0939\u093e\u0902\u0916\u094b \u0938\u093f\u092b\u093e\u092f\u0928\u093e\u092f \u0926\u0939\u2018\u0919" },
            { "type.ms.metric", "\u092e\u0947\u091f\u094d\u0930\u093f\u0915 \u0906\u0926\u092c" },
            { "type.ca.chinese", "\u091a\u093e\u0907\u0928\u093f\u091c \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.ca.islamic", "\u0907\u0938\u094d\u0932\u093e\u092e\u093f\u0915 \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.ca.iso8601", "\u0906\u0907.\u090f\u0938.\u0905-8601 \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.ca.persian", "\u092a\u093e\u0930\u094d\u0938\u093f\u092f\u093e\u0928 \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.cf.account", "\u092e\u0941\u0926\u094d\u0930\u093e\u0928\u093f \u0928\u0941\u0925\u093e\u092f\u0916\u094c \u0939\u093f\u0938\u093e\u092c \u0932\u093e\u0916\u093f\u0928\u093e\u092f" },
            { "type.co.big5han", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u091a\u0940\u0928\u0940 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923 \u092c\u0940\u0917 \u092b\u093c\u093e\u0908\u0935" },
            { "type.nu.arabext", "\u092b\u094b\u0932\u093e\u0935\u0928\u093e\u092f \u0906\u0930\u093e\u092c\u093f\u0915-\u0907\u0923\u094d\u0921\u093f\u0915 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.armnlow", "\u0906\u0930\u094d\u092e\u0947\u0928\u093f\u092f\u093e\u0928\u093f \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u092b\u093f\u0938\u093e \u0939\u093e\u0902\u0916\u094b" },
            { "type.nu.greklow", "\u0917\u094d\u0930\u0940\u0915 \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u092b\u093f\u0938\u093e \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.hanidec", "\u091a\u093e\u0907\u0928\u0940\u091c \u0926\u0936\u092e\u093f\u0915 \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.hansfin", "\u0917\u094b\u0930\u0932\u0948 \u0916\u093e\u0932\u093e\u092e\u0928\u093e\u092f \u091a\u093e\u0907\u0928\u0940\u091c \u0930\u093e\u0902\u0906\u0930\u093f \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.hantfin", "\u0906\u0938\u093e\u0930-\u0916\u093e\u0928\u094d\u0925\u093f\u092f\u093e\u0930\u093f \u091a\u093e\u0907\u0928\u0940\u091c \u0930\u093e\u0902\u0906\u0930\u093f \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.jpanfin", "\u091c\u093e\u092a\u093e\u0928\u0940\u091c \u0930\u093e\u0902\u0906\u0930\u093f \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.nu.tamldec", "\u0924\u093e\u092e\u093f\u0932 \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.ca.buddhist", "\u092c\u094c\u0926\u094d\u0927 \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.ca.ethiopic", "\u0907\u0925\u093f\u092f\u2019\u092a\u093f\u092f\u093e\u0928\u093f \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.ca.japanese", "\u091c\u093e\u092a\u093e\u0928\u0940\u091c \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.cf.standard", "\u0925\u093e\u0916\u094b\u0906\u0930\u093f \u092e\u0941\u0926\u094d\u0930\u093e\u0928\u093f \u0928\u0941\u0925\u093e\u092f" },
            { "type.co.standard", "\u0925\u093e\u0916\u094b\u0906\u0930\u093f \u0930\u094b\u0916\u094b\u092e \u092b\u093e\u0930\u093f" },
            { "type.ms.uksystem", "\u092c\u094d\u0930\u093f\u091f\u093f\u0938\u093e \u0917\u0928\u093e\u092f\u0928\u093e\u092f \u091c\u0916\u093e \u0932\u093e\u0928\u093e\u092f \u0906\u0926\u092c" },
            { "type.ms.ussystem", "\u0907\u0909.\u090f\u0938 \u0928\u093f \u091c\u0916\u093e \u0932\u093e\u0928\u093e\u092f \u0906\u0926\u092c" },
            { "type.nu.fullwide", "\u0906\u092c\u0941\u0902-\u0917\u0941\u0935\u093e\u0930\u0925\u093f\u0928\u093f \u0905\u0928\u091c\u093f\u092e\u093e\u092b\u094b\u0930" },
            { "type.nu.romanlow", "\u0930\u092e\u093e\u0928 \u0905\u0928\u091c\u093f\u092e\u093e \u0926\u093f\u0928\u094d\u0925\u093f\u0928\u093e\u092f \u092b\u093f\u0938\u093e \u0939\u093e\u0902\u0916\u094b\u092b\u094b\u0930" },
            { "type.ca.gregorian", "\u0917\u094d\u0930\u0947\u0917\u2019\u0930\u093f\u092f\u093e\u0928 \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
            { "type.co.gb2312han", "\u0938\u0930\u0932\u0940\u0915\u0943\u0924 \u091a\u0940\u0928\u0940 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923 \u091c\u0940\u092c\u09402312" },
            { "type.co.phonebook", "\u0926\u0942\u0930\u092d\u093e\u0937 \u0928\u093f\u0930\u094d\u0926\u0947\u0936\u093f\u0915\u093e \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "type.co.traditional", "\u092a\u093e\u0930\u092e\u094d\u092a\u093e\u0930\u093f\u0915 \u0935\u0930\u094d\u0917\u0940\u0915\u0930\u0923" },
            { "type.ca.islamic-civil", "\u0907\u0938\u094d\u0932\u093e\u092e\u093f\u0915 \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f ( \u092b\u093e\u0930\u093f, \u0939\u093e\u0926\u094b\u0930\u093e\u0930\u093f \u092e\u0941\u0917\u093e)" },
            { "ListCompositionPattern", "{0},{1}" },
            { "type.ca.islamic-umalqura", "\u0907\u0938\u094d\u0932\u093e\u092e\u093f\u0915 \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f( \u090a\u092e \u0906\u0932-\u0915\u0942\u0930\u093e)" },
            { "type.ca.ethiopic-amete-alem", "\u0907\u0925\u093f\u092f\u2019\u092a\u093f\u0915 \u0906\u092e\u0947\u0924\u0947 \u0906\u0932\u0947\u092e \u092b\u093e\u0928\u094d\u091c\u093e\u092e\u0941\u0925\u093f" },
        };
        return data;
    }
}
