/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_es extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "hora del meridiano de Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Hora est\u00e1ndar de Acre",
               "",
               "Hora de verano de Acre",
               "",
               "Hora de Acre",
               "",
            };
        final String[] Apia = new String[] {
               "hora est\u00e1ndar de Apia",
               "",
               "horario de verano de Apia",
               "",
               "hora de Apia",
               "",
            };
        final String[] Cook = new String[] {
               "hora est\u00e1ndar de las Islas Cook",
               "",
               "hora de verano media de las Islas Cook",
               "",
               "hora de las Islas Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "hora est\u00e1ndar de Cuba",
               "CST",
               "hora de verano de Cuba",
               "CDT",
               "hora de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "hora est\u00e1ndar de Fiyi",
               "",
               "hora de verano de Fiyi",
               "",
               "hora de Fiyi",
               "",
            };
        final String[] Gulf = new String[] {
               "hora est\u00e1ndar del Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "hora est\u00e1ndar de Hovd",
               "",
               "hora de verano de Hovd",
               "",
               "hora de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "hora est\u00e1ndar de Ir\u00e1n",
               "",
               "hora de verano de Ir\u00e1n",
               "",
               "hora de Ir\u00e1n",
               "",
            };
        final String[] Niue = new String[] {
               "hora de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "hora est\u00e1ndar de Omsk",
               "",
               "hora de verano de Omsk",
               "",
               "hora de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "hora est\u00e1ndar de Per\u00fa",
               "",
               "hora de verano de Per\u00fa",
               "",
               "hora de Per\u00fa",
               "",
            };
        final String[] Truk = new String[] {
               "hora de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "hora de la isla Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "hora est\u00e1ndar de Chile",
               "",
               "hora de verano de Chile",
               "",
               "hora de Chile",
               "",
            };
        final String[] China = new String[] {
               "hora est\u00e1ndar de China",
               "CST",
               "hora de verano de China",
               "CDT",
               "hora de China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "hora de las Islas Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "hora de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "hora est\u00e1ndar de la India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "hora est\u00e1ndar de Jap\u00f3n",
               "JST",
               "hora de verano de Jap\u00f3n",
               "JDT",
               "hora de Jap\u00f3n",
               "JT",
            };
        final String[] Korea = new String[] {
               "hora est\u00e1ndar de Corea",
               "KST",
               "hora de verano de Corea",
               "KST",
               "hora de Corea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "hora de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "hora de Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "hora de Palaos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "hora est\u00e1ndar de Samoa",
               "SST",
               "hora de verano de Samoa",
               "SST",
               "hora de Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "hora de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "hora est\u00e1ndar de Tonga",
               "",
               "hora de verano de Tonga",
               "",
               "hora de Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "hora de Yuk\u00f3n",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "hora est\u00e1ndar de Alaska",
               "AKST",
               "hora de verano de Alaska",
               "AKDT",
               "hora de Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "hora est\u00e1ndar del Amazonas",
               "",
               "hora de verano del Amazonas",
               "",
               "hora del Amazonas",
               "",
            };
        final String[] Anadyr = new String[] {
               "hora est\u00e1ndar de Anadyr",
               "",
               "hora de verano de Anadyr",
               "",
               "hora de Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "hora est\u00e1ndar de las Azores",
               "",
               "hora de verano de las Azores",
               "",
               "hora de las Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "hora de But\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "hora de Brun\u00e9i",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "hora est\u00e1ndar de la isla de Pascua",
               "",
               "hora de verano de la isla de Pascua",
               "",
               "hora de la isla de Pascua",
               "",
            };
        final String[] Guyana = new String[] {
               "hora de Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "hora est\u00e1ndar de Israel",
               "IST",
               "hora de verano de Israel",
               "IDT",
               "hora de Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "hora de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "hora de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "hora est\u00e1ndar de Mosc\u00fa",
               "MSK",
               "hora de verano de Mosc\u00fa",
               "MSK",
               "hora de Mosc\u00fa",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "hora de Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "hora est\u00e1ndar de Samara",
               "",
               "hora de verano de Samara",
               "",
               "hora de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "hora de Tahit\u00ed",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "hora est\u00e1ndar de Taip\u00e9i",
               "CST",
               "hora de verano de Taip\u00e9i",
               "CDT",
               "hora de Taip\u00e9i",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "hora de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "hora de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "hora de Wallis y Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "hora est\u00e1ndar de Arabia",
               "",
               "hora de verano de Arabia",
               "",
               "hora de Arabia",
               "",
            };
        final String[] Armenia = new String[] {
               "hora est\u00e1ndar de Armenia",
               "",
               "hora de verano de Armenia",
               "",
               "hora de Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "hora de Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "hora est\u00e1ndar de Chatham",
               "",
               "hora de verano de Chatham",
               "",
               "hora de Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "tiempo universal coordinado",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "hora de Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "hora de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "hora est\u00e1ndar de Georgia",
               "",
               "hora de verano de Georgia",
               "",
               "hora de Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "hora est\u00e1ndar de Irkutsk",
               "",
               "hora de verano de Irkutsk",
               "",
               "hora de Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "hora est\u00e1ndar de Magad\u00e1n",
               "",
               "hora de verano de Magad\u00e1n",
               "",
               "hora de Magad\u00e1n",
               "",
            };
        final String[] Myanmar = new String[] {
               "hora de Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "hora est\u00e1ndar de la isla Norfolk",
               "",
               "hora de verano de la isla Norfolk",
               "",
               "hora de la isla Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "hora est\u00e1ndar de Fernando de Noronha",
               "",
               "hora de verano de Fernando de Noronha",
               "",
               "hora de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "hora de Reuni\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "hora de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "hora de las Islas Salom\u00f3n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "hora de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "hora est\u00e1ndar de Uruguay",
               "",
               "hora de verano de Uruguay",
               "",
               "hora de Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "hora est\u00e1ndar de Vanuatu",
               "",
               "hora de verano de Vanuatu",
               "",
               "hora de Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "hora est\u00e1ndar de Yakutsk",
               "",
               "hora de verano de Yakutsk",
               "",
               "hora de Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "hora est\u00e1ndar del Atl\u00e1ntico",
               "AST",
               "hora de verano del Atl\u00e1ntico",
               "AST",
               "hora del Atl\u00e1ntico",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "hora est\u00e1ndar de Brasilia",
               "",
               "hora de verano de Brasilia",
               "",
               "hora de Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "hora est\u00e1ndar de Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "hora est\u00e1ndar de Colombia",
               "",
               "hora de verano de Colombia",
               "",
               "hora de Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "hora est\u00e1ndar de las islas Malvinas",
               "",
               "hora de verano de las islas Malvinas",
               "",
               "hora de las islas Malvinas",
               "",
            };
        final String[] Malaysia = new String[] {
               "hora de Malasia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "hora de Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "hora est\u00e1ndar de Ul\u00e1n Bator",
               "",
               "hora de verano de Ul\u00e1n Bator",
               "",
               "hora de Ul\u00e1n Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "hora est\u00e1ndar de Pakist\u00e1n",
               "PKT",
               "hora de verano de Pakist\u00e1n",
               "PKST",
               "hora de Pakist\u00e1n",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "hora est\u00e1ndar de Paraguay",
               "",
               "hora de verano de Paraguay",
               "",
               "hora de Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "hora de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "hora est\u00e1ndar de Sajal\u00edn",
               "",
               "hora de verano de Sajal\u00edn",
               "",
               "hora de Sajal\u00edn",
               "",
            };
        final String[] Suriname = new String[] {
               "hora de Surinam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "hora est\u00e1ndar de Argentina",
               "",
               "hora de verano de Argentina",
               "",
               "hora de Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "hora de la Isla de Navidad",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "hora de Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hora est\u00e1ndar de Hong Kong",
               "HKT",
               "hora de verano de Hong Kong",
               "HKST",
               "hora de Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "hora de Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "hora est\u00e1ndar de Kamchatka",
               "",
               "hora de verano de Kamchatka",
               "",
               "hora de Kamchatka",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "hora de Kirguist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "hora est\u00e1ndar de Lord Howe",
               "",
               "hora de verano de Lord Howe",
               "",
               "hora de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "hora de Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "hora est\u00e1ndar de Mauricio",
               "",
               "hora de verano de Mauricio",
               "",
               "hora de Mauricio",
               "",
            };
        final String[] Singapore = new String[] {
               "hora de Singapur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "hora de Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "hora est\u00e1ndar de Volgogrado",
               "MSK",
               "hora de verano de Volgogrado",
               "MSK",
               "hora de Volgogrado",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "hora est\u00e1ndar de Azerbaiy\u00e1n",
               "",
               "hora de verano de Azerbaiy\u00e1n",
               "",
               "hora de Azerbaiy\u00e1n",
               "",
            };
        final String[] Bangladesh = new String[] {
               "hora est\u00e1ndar de Banglad\u00e9s",
               "",
               "hora de verano de Banglad\u00e9s",
               "",
               "hora de Banglad\u00e9s",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "hora est\u00e1ndar de Cabo Verde",
               "",
               "hora de verano de Cabo Verde",
               "",
               "hora de Cabo Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "hora de Timor Oriental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "hora de Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "hora de Tayikist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "hora est\u00e1ndar de Uzbekist\u00e1n",
               "",
               "hora de verano de Uzbekist\u00e1n",
               "",
               "hora de Uzbekist\u00e1n",
               "",
            };
        final String[] Afghanistan = new String[] {
               "hora de Afganist\u00e1n",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "hora est\u00e1ndar de Krasnoyarsk",
               "",
               "hora de verano de Krasnoyarsk",
               "",
               "hora de Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "hora est\u00e1ndar de Nueva Zelanda",
               "NZST",
               "hora de verano de Nueva Zelanda",
               "NZDT",
               "hora de Nueva Zelanda",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "hora est\u00e1ndar de Novosibirsk",
               "",
               "hora de verano de Novosibirsk",
               "",
               "hora de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "hora est\u00e1ndar de Filipinas",
               "PST",
               "hora de verano de Filipinas",
               "PDT",
               "hora de Filipinas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "hora est\u00e1ndar de Vladivostok",
               "",
               "hora de verano de Vladivostok",
               "",
               "hora de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "hora del oc\u00e9ano \u00cdndico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "hora de las Esp\u00f3radas Ecuatoriales",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "hora est\u00e1ndar de Terranova",
               "NST",
               "hora de verano de Terranova",
               "NDT",
               "hora de Terranova",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "hora est\u00e1ndar de Turkmenist\u00e1n",
               "",
               "hora de verano de Turkmenist\u00e1n",
               "",
               "hora de Turkmenist\u00e1n",
               "",
            };
        final String[] French_Guiana = new String[] {
               "hora de la Guayana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "hora est\u00e1ndar de Nueva Caledonia",
               "",
               "hora de verano de Nueva Caledonia",
               "",
               "hora de Nueva Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "hora de Georgia del Sur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "hora est\u00e1ndar de Ekaterimburgo",
               "",
               "hora de verano de Ekaterimburgo",
               "",
               "hora de Ekaterimburgo",
               "",
            };
        final String[] Africa_Central = new String[] {
               "hora de \u00c1frica central",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "hora de \u00c1frica oriental",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "hora est\u00e1ndar de \u00c1frica occidental",
               "WAT",
               "hora de verano de \u00c1frica occidental",
               "WAT",
               "hora de \u00c1frica occidental",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "hora de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "hora est\u00e1ndar de Europa central",
               "CET",
               "hora de verano de Europa central",
               "CEST",
               "hora de Europa central",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "hora est\u00e1ndar de Europa oriental",
               "EET",
               "hora de verano de Europa oriental",
               "EEST",
               "hora de Europa oriental",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "hora est\u00e1ndar de Europa occidental",
               "WET",
               "hora de verano de Europa occidental",
               "WEST",
               "hora de Europa occidental",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "hora est\u00e1ndar del Pac\u00edfico de M\u00e9xico",
               "MST",
               "hora de verano del Pac\u00edfico de M\u00e9xico",
               "MDT",
               "hora del Pac\u00edfico de M\u00e9xico",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "hora de Sud\u00e1frica",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "hora est\u00e1ndar central",
               "CST",
               "hora de verano central",
               "CDT",
               "hora central",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "hora est\u00e1ndar oriental",
               "EST",
               "hora de verano oriental",
               "EST",
               "hora oriental",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "hora est\u00e1ndar del Pac\u00edfico",
               "PST",
               "hora de verano del Pac\u00edfico",
               "PDT",
               "hora del Pac\u00edfico",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "hora de Ant\u00e1rtida y Territorios Australes Franceses",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "hora de las islas Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "hora est\u00e1ndar de Haw\u00e1i-Aleutianas",
               "HST",
               "hora de verano de Haw\u00e1i-Aleutianas",
               "HST",
               "hora de Haw\u00e1i-Aleutianas",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "hora de las Islas F\u00e9nix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "hora est\u00e1ndar de San Pedro y Miquel\u00f3n",
               "",
               "hora de verano de San Pedro y Miquel\u00f3n",
               "",
               "hora de San Pedro y Miquel\u00f3n",
               "",
            };
        final String[] America_Mountain = new String[] {
               "hora est\u00e1ndar de las Monta\u00f1as Rocosas",
               "MST",
               "hora de verano de las Monta\u00f1as Rocosas",
               "MST",
               "hora de las Monta\u00f1as Rocosas",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "hora de las Islas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "hora de Pap\u00faa Nueva Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "hora est\u00e1ndar de Australia central",
               "ACST",
               "hora de verano de Australia central",
               "ACDT",
               "hora de Australia central",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "hora est\u00e1ndar de Australia oriental",
               "AEST",
               "hora de verano de Australia oriental",
               "AEDT",
               "hora de Australia oriental",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "hora est\u00e1ndar de Australia occidental",
               "AWST",
               "hora de verano de Australia occidental",
               "AWDT",
               "hora de Australia occidental",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "hora de Indonesia central",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "hora de Indonesia oriental",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "hora de Indonesia occidental",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "hora de Kazajist\u00e1n occidental",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "hora est\u00e1ndar de Australia centroccidental",
               "",
               "hora de verano de Australia centroccidental",
               "",
               "hora de Australia centroccidental",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "tiempo universal coordinado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano de Irlanda",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "tiempo universal coordinado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "tiempo universal coordinado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "tiempo universal coordinado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "tiempo universal coordinado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "tiempo universal coordinado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano de Irlanda",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "hora del meridiano de Greenwich",
                    "GMT",
                    "hora de verano brit\u00e1nica",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Ad\u00e9n" },
            { "timezone.excity.Asia/Baku", "Bak\u00fa" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Amm\u00e1n" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Chit\u00e1" },
            { "timezone.excity.Asia/Dhaka", "Daca" },
            { "timezone.excity.Asia/Dubai", "Dub\u00e1i" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Asia/Seoul", "Se\u00fal" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Anadyr", "An\u00e1dyr" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Brunei", "Brun\u00e9i" },
            { "timezone.excity.Asia/Hebron", "Hebr\u00f3n" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Saigon", "Ciudad Ho Chi Minh" },
            { "timezone.excity.Asia/Taipei", "Taip\u00e9i" },
            { "timezone.excity.Asia/Tehran", "Teher\u00e1n" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "Ciudad desconocida" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "timezone.excity.Africa/Cairo", "El Cairo" },
            { "timezone.excity.Africa/Tunis", "T\u00fanez" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bar\u00e9in" },
            { "timezone.excity.Asia/Barnaul", "Barna\u00fal" },
            { "timezone.excity.Asia/Jakarta", "Yakarta" },
            { "timezone.excity.Asia/Magadan", "Magad\u00e1n" },
            { "timezone.excity.Asia/Rangoon", "Yang\u00f3n (Rang\u00fan)" },
            { "timezone.excity.Asia/Tbilisi", "Tiflis" },
            { "timezone.excity.Asia/Thimphu", "Timbu" },
            { "timezone.excity.Asia/Yerevan", "Erev\u00e1n" },
            { "timezone.excity.Europe/Kirov", "K\u00edrov" },
            { "timezone.excity.Europe/Paris", "Par\u00eds" },
            { "timezone.excity.Europe/Sofia", "Sof\u00eda" },
            { "timezone.excity.Pacific/Fiji", "Fiyi" },
            { "timezone.excity.Africa/Bissau", "Bis\u00e1u" },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "timezone.excity.America/Bahia", "Bah\u00eda" },
            { "timezone.excity.America/Belem", "Bel\u00e9n" },
            { "timezone.excity.Asia/Ashgabat", "Asjabad" },
            { "timezone.excity.Asia/Calcutta", "Calcuta" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "timezone.excity.Asia/Dushanbe", "Dusamb\u00e9" },
            { "timezone.excity.Asia/Katmandu", "Katmand\u00fa" },
            { "timezone.excity.Asia/Khandyga", "Khandiga" },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "timezone.excity.Asia/Qostanay", "Kostan\u00e1i" },
            { "timezone.excity.Asia/Sakhalin", "Sajal\u00edn" },
            { "timezone.excity.Asia/Shanghai", "Shangh\u00e1i" },
            { "timezone.excity.Asia/Tashkent", "Taskent" },
            { "timezone.excity.Europe/Athens", "Atenas" },
            { "timezone.excity.Europe/Berlin", "Berl\u00edn" },
            { "timezone.excity.Europe/Dublin", "Dubl\u00edn" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Monaco", "M\u00f3naco" },
            { "timezone.excity.Europe/Moscow", "Mosc\u00fa" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Skopje", "Skopie" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "timezone.excity.Europe/Zurich", "Z\u00farich" },
            { "timezone.excity.Indian/Comoro", "Comoras" },
            { "timezone.excity.Pacific/Palau", "Palaos" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Abiy\u00e1n" },
            { "timezone.excity.Africa/Algiers", "Argel" },
            { "timezone.excity.Africa/Conakry", "Conakri" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edpoli" },
            { "timezone.excity.America/Belize", "Belice" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Caim\u00e1n" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Havana", "La Habana" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Manaus", "Manaos" },
            { "timezone.excity.America/Panama", "Panam\u00e1" },
            { "timezone.excity.Asia/Jerusalem", "Jerusal\u00e9n" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Asia/Vientiane", "Vienti\u00e1n" },
            { "timezone.excity.Europe/Saratov", "Sar\u00e1tov" },
            { "timezone.excity.Europe/Tallinn", "Tallin" },
            { "timezone.excity.Europe/Vatican", "El Vaticano" },
            { "timezone.excity.Europe/Vilnius", "Vilna" },
            { "timezone.excity.Indian/Reunion", "Reuni\u00f3n" },
            { "timezone.excity.Pacific/Easter", "Isla de Pascua" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Pacific/Saipan", "Saip\u00e1n" },
            { "timezone.excity.Pacific/Tahiti", "Tahit\u00ed" },
            { "timezone.excity.Africa/Djibouti", "Yibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Africa/Khartoum", "Jartum" },
            { "timezone.excity.Africa/Ndjamena", "Yamena" },
            { "timezone.excity.Africa/Sao_Tome", "Santo Tom\u00e9" },
            { "timezone.excity.America/Cayenne", "Cayena" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Curacao", "Curazao" },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.America/Tortola", "T\u00f3rtola" },
            { "timezone.excity.Atlantic/Canary", "Canarias" },
            { "timezone.excity.Atlantic/Faeroe", "Islas Feroe" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Bruselas" },
            { "timezone.excity.Europe/Chisinau", "Chisin\u00e1u" },
            { "timezone.excity.Europe/Guernsey", "Guernesey" },
            { "timezone.excity.Europe/Istanbul", "Estambul" },
            { "timezone.excity.Indian/Maldives", "Maldivas" },
            { "timezone.excity.Africa/Mogadishu", "Mogadiscio" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/Mazatlan", "Mazatl\u00e1n" },
            { "timezone.excity.America/Miquelon", "Miquel\u00f3n" },
            { "timezone.excity.America/New_York", "Nueva York" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/Santiago", "Santiago de Chile" },
            { "timezone.excity.America/St_Johns", "San Juan de Terranova" },
            { "timezone.excity.America/St_Kitts", "San Crist\u00f3bal" },
            { "timezone.excity.America/St_Lucia", "Santa Luc\u00eda" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ul\u00e1n Bator" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "timezone.excity.Australia/Sydney", "S\u00eddney" },
            { "timezone.excity.Europe/Amsterdam", "\u00c1msterdam" },
            { "timezone.excity.Europe/Astrakhan", "Astrac\u00e1n" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "timezone.excity.Europe/Stockholm", "Estocolmo" },
            { "timezone.excity.Europe/Ulyanovsk", "Uli\u00e1novsk" },
            { "timezone.excity.Europe/Volgograd", "Volgogrado" },
            { "timezone.excity.Indian/Christmas", "Navidad" },
            { "timezone.excity.Indian/Mauritius", "Mauricio" },
            { "timezone.excity.Pacific/Honolulu", "Honolul\u00fa" },
            { "timezone.excity.Africa/Nouakchott", "Nuakchot" },
            { "timezone.excity.Africa/Porto-Novo", "Portonovo" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburgo" },
            { "timezone.excity.Europe/Simferopol", "Simfer\u00f3pol" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Africa/Addis_Ababa", "Ad\u00eds Abeba" },
            { "timezone.excity.Africa/Ouagadougou", "Uagadug\u00fa" },
            { "timezone.excity.America/Grand_Turk", "Gran Turca" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/Rio_Branco", "R\u00edo Branco" },
            { "timezone.excity.America/St_Vincent", "San Vicente" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterimburgo" },
            { "timezone.excity.Atlantic/Reykjavik", "Reikiavik" },
            { "timezone.excity.Atlantic/St_Helena", "Santa Elena" },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Europe/Isle_of_Man", "Isla de Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrado" },
            { "timezone.excity.Africa/Johannesburg", "Johannesburgo" },
            { "timezone.excity.America/Los_Angeles", "Los \u00c1ngeles" },
            { "timezone.excity.America/Mexico_City", "Ciudad de M\u00e9xico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabo Verde" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es-Salam" },
            { "timezone.excity.America/Indianapolis", "Indian\u00e1polis" },
            { "timezone.excity.America/Port_of_Spain", "Puerto Espa\u00f1a" },
            { "timezone.excity.America/St_Barthelemy", "San Bartolom\u00e9" },
            { "timezone.excity.America/Port-au-Prince", "Puerto Pr\u00edncipe" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia del Sur" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota del Norte" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota del Norte" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "R\u00edo Gallegos" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota del Norte" },
        };
        return data;
    }
}
