/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_mi extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "W\u0101 Toharite Kiriw\u012bti",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "W\u0101 \u0100pia Arowh\u0101nui",
               "",
               "W\u0101 \u0100pia Awatea",
               "",
               "W\u0101 \u0100pia",
               "",
            };
        final String[] Cook = new String[] {
               "W\u0101 Kuki Airani Arowh\u0101nui",
               "",
               "W\u0101 Kuki Airani Raumati Haurua",
               "",
               "W\u0101 Kuki Airani",
               "",
            };
        final String[] Cuba = new String[] {
               "W\u0101 Arowh\u0101nui Kiupa",
               "CST",
               "W\u0101 Awatea Kiupa",
               "CDT",
               "W\u0101 Kiupa",
               "CT",
            };
        final String[] Fiji = new String[] {
               "W\u0101 Wh\u012bt\u012b Arowh\u0101nui",
               "",
               "W\u0101 Wh\u012bt\u012b Raumati",
               "",
               "W\u0101 Wh\u012bt\u012b",
               "",
            };
        final String[] Gulf = new String[] {
               "W\u0101 Whanga Arowh\u0101nui",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "W\u0101 Hovd Arowh\u0101nui",
               "",
               "W\u0101 Hovd Raumati",
               "",
               "W\u0101 Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "W\u0101 Ir\u0101na Arowh\u0101nui",
               "",
               "W\u0101 Ir\u0101na Awatea",
               "",
               "W\u0101 Ir\u0101na",
               "",
            };
        final String[] Niue = new String[] {
               "W\u0101 Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "W\u0101 Omsk Arowh\u0101nui",
               "",
               "W\u0101 Omsk Raumati",
               "",
               "W\u0101 Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "W\u0101 Peru Arowh\u0101nui",
               "",
               "W\u0101 Peru Raumati",
               "",
               "W\u0101 Peru",
               "",
            };
        final String[] Truk = new String[] {
               "W\u0101 Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "W\u0101 o Te Motu Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "W\u0101 Hiri Arowh\u0101nui",
               "",
               "W\u0101 Hiri Raumati",
               "",
               "W\u0101 Hiri",
               "",
            };
        final String[] China = new String[] {
               "W\u0101 Haina Arowh\u0101nui",
               "CST",
               "W\u0101 Haina Awatea",
               "CDT",
               "W\u0101 Haina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "W\u0101 o Ng\u0101 Moutere Kokohi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "W\u0101 R\u0113weti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "W\u0101 \u012ania",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "W\u0101 Hapani Arowh\u0101nui",
               "JST",
               "W\u0101 Hapani Awatea",
               "JDT",
               "W\u0101 Hapani",
               "JT",
            };
        final String[] Korea = new String[] {
               "W\u0101 K\u014drea Arowh\u0101nui",
               "KST",
               "W\u0101 K\u014drea Awatea",
               "KST",
               "W\u0101 K\u014drea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "W\u0101 Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "W\u0101 Nep\u014dra",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "W\u0101 P\u0101rau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "W\u0101 H\u0101moa Arowh\u0101nui",
               "SST",
               "W\u0101 H\u0101moa Awatea",
               "SST",
               "W\u0101 H\u0101moa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "W\u0101 Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "W\u0101 Tonga Arowh\u0101nui",
               "",
               "W\u0101 Tonga Raumati",
               "",
               "W\u0101 Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "W\u0101 Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "W\u0101 Arowh\u0101nui Alaska",
               "AKST",
               "W\u0101 Awatea Alaska",
               "AKDT",
               "W\u0101 Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "W\u0101 Amahona Arowh\u0101nui",
               "",
               "W\u0101 Amahona Raumati",
               "",
               "W\u0101 Amahona",
               "",
            };
        final String[] Azores = new String[] {
               "W\u0101 Azores Arowh\u0101nui",
               "",
               "W\u0101 Azores Raumati",
               "",
               "W\u0101 Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "W\u0101 P\u016btana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "W\u0101 Poronai Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "W\u0101 ki te Moutere Aranga Arowh\u0101nui",
               "",
               "W\u0101 ki te Moutere Aranga Raumati",
               "",
               "W\u0101 ki te Moutere o Aranga",
               "",
            };
        final String[] Guyana = new String[] {
               "W\u0101 Kaiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "W\u0101 Iharaira Arowh\u0101nui",
               "IST",
               "W\u0101 Iharaira Awatea",
               "IDT",
               "W\u0101 Iharaira",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "W\u0101 Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "W\u0101 Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "W\u0101 Mohikau Arowh\u0101nui",
               "MSK",
               "W\u0101 Mohikau Raumati",
               "MSK",
               "W\u0101 Mohikau",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "W\u0101 Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "W\u0101 Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "W\u0101 Taipei Arowh\u0101nui",
               "CST",
               "W\u0101 Taipei Awatea",
               "CDT",
               "W\u0101 Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "W\u0101 T\u016bwaru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "W\u0101 Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "W\u0101 W\u0101rihi me Whutuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "W\u0101 Ar\u0101pia Arowh\u0101nui",
               "",
               "W\u0101 Ar\u0101pia Awatea",
               "",
               "W\u0101 Ar\u0101pia",
               "",
            };
        final String[] Armenia = new String[] {
               "W\u0101 \u0100menia Arowh\u0101nui",
               "",
               "W\u0101 \u0100menia Raumati",
               "",
               "W\u0101 \u0100menia",
               "",
            };
        final String[] Bolivia = new String[] {
               "W\u0101 Poriwia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "W\u0101 R\u0113kohu Arowh\u0101nui",
               "",
               "W\u0101 R\u0113kohu Awatea",
               "",
               "W\u0101 R\u0113kohu",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "W\u0101 Aonui K\u014dtuitui",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "W\u0101 Ekuatoa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "W\u0101 Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "W\u0101 H\u014dria Arowh\u0101nui",
               "",
               "W\u0101 H\u014dria Raumati",
               "",
               "W\u0101 H\u014dria",
               "",
            };
        final String[] Irkutsk = new String[] {
               "W\u0101 Irkutsk Arowh\u0101nui",
               "",
               "W\u0101 Irkutsk Raumati",
               "",
               "W\u0101 Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "W\u0101 Magadan Arowh\u0101nui",
               "",
               "W\u0101 Magadan Raumati",
               "",
               "W\u0101 Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "W\u0101 P\u0113ma",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "W\u0101 o Te Moutere N\u014dpoke Arowh\u0101nui",
               "",
               "W\u0101 o Te Moutere N\u014dpoke Awatea",
               "",
               "W\u0101 o Te Moutere N\u014dpoke",
               "",
            };
        final String[] Noronha = new String[] {
               "W\u0101 Fernando de Noronha Arowh\u0101nui",
               "",
               "W\u0101 Fernando de Noronha Raumati",
               "",
               "W\u0101 Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "W\u0101 Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "W\u0101 Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "W\u0101 o Ng\u0101 Motu Horomona",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "W\u0101 Tokerau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "W\u0101 Urukoi Arowh\u0101nui",
               "",
               "W\u0101 Urukoi Raumati",
               "",
               "W\u0101 Urukoi",
               "",
            };
        final String[] Vanuatu = new String[] {
               "W\u0101 Whenuat\u016b Arowh\u0101nui",
               "",
               "W\u0101 Whenuat\u016b Raumati",
               "",
               "W\u0101 Whenuat\u016b",
               "",
            };
        final String[] Yakutsk = new String[] {
               "W\u0101 Yakutsk Arowh\u0101nui",
               "",
               "W\u0101 Yakutsk Raumati",
               "",
               "W\u0101 Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "W\u0101 Arowh\u0101nui Ranatiki",
               "AST",
               "W\u0101 Awatea Ranatiki",
               "AST",
               "W\u0101 Ranatiki",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "W\u0101 Par\u012bhia Arowh\u0101nui",
               "",
               "W\u0101 Par\u012bhia Raumati",
               "",
               "W\u0101 Par\u012bhia",
               "",
            };
        final String[] Chamorro = new String[] {
               "W\u0101 Chamorro Arowh\u0101nui",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "W\u0101 Korom\u014dpia Arowh\u0101nui",
               "",
               "W\u0101 Korom\u014dpia Raumati",
               "",
               "W\u0101 Korom\u014dpia",
               "",
            };
        final String[] Falkland = new String[] {
               "W\u0101 ki Ng\u0101 Motu Wh\u0101kana Arowh\u0101nui",
               "",
               "W\u0101 ki Ng\u0101 Motu Wh\u0101kana Raumati",
               "",
               "W\u0101 ki Ng\u0101 Motu Wh\u0101kana",
               "",
            };
        final String[] Malaysia = new String[] {
               "W\u0101 Mareia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "W\u0101 M\u0101ratiri",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "W\u0101 Ulaanbaatar Arowh\u0101nui",
               "",
               "W\u0101 Ulaanbaatar Raumati",
               "",
               "W\u0101 Ulaanbaatar",
               "",
            };
        final String[] Pakistan = new String[] {
               "W\u0101 Pakit\u0101ne Arowh\u0101nui",
               "PKT",
               "W\u0101 Pakit\u0101ne Raumati",
               "PKST",
               "W\u0101 Pakit\u0101ne",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "W\u0101 Parakai Arowh\u0101nui",
               "",
               "W\u0101 Parakai Raumati",
               "",
               "W\u0101 Parakai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "W\u0101 Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "W\u0101 Sakhalin Arowh\u0101nui",
               "",
               "W\u0101 Sakhalin Raumati",
               "",
               "W\u0101 Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "W\u0101 Huriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "W\u0101 \u0100ketina Arowh\u0101nui",
               "",
               "W\u0101 \u0100ketina Raumati",
               "",
               "W\u0101 \u0100ketina",
               "",
            };
        final String[] Christmas = new String[] {
               "W\u0101 o Te Moutere Kirihimete",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "W\u0101 Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "W\u0101 Hongipua Arowh\u0101nui",
               "HKT",
               "W\u0101 Hongipua Raumati",
               "HKST",
               "W\u0101 Hongipua",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "W\u0101 \u012aniahaina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "W\u0101 Kikit\u0101nga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "W\u0101 Lord Howe Arowh\u0101nui",
               "",
               "W\u0101 Lord Howe Awatea",
               "",
               "W\u0101 Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "W\u0101 Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "W\u0101 Marihi Arowh\u0101nui",
               "",
               "W\u0101 Marihi Raumati",
               "",
               "W\u0101 Marihi",
               "",
            };
        final String[] Singapore = new String[] {
               "W\u0101 Hingapoa Arowh\u0101nui",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "W\u0101 Peneh\u016bera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "W\u0101 Volgograd Arowh\u0101nui",
               "MSK",
               "W\u0101 Volgograd Raumati",
               "MSK",
               "W\u0101 Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "W\u0101 Atepaih\u0101nia Arowh\u0101nui",
               "",
               "W\u0101 Atepaih\u0101nia Raumati",
               "",
               "W\u0101 Atepaih\u0101nia",
               "",
            };
        final String[] Bangladesh = new String[] {
               "W\u0101 P\u0101karat\u0113hi Arowh\u0101nui",
               "",
               "W\u0101 P\u0101karat\u0113hi Raumati",
               "",
               "W\u0101 P\u0101karat\u0113hi",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "W\u0101 Arowh\u0101nui o Te K\u016brae Matomato",
               "",
               "W\u0101 Raumati o Te K\u016brae Matomato",
               "",
               "W\u0101 o Te K\u016brae Matomato",
               "",
            };
        final String[] East_Timor = new String[] {
               "W\u0101 o Timoa ki te R\u0101whiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "W\u0101 Heikere",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "W\u0101 Takirit\u0101nga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "W\u0101 Uhipeket\u0101ne Arowh\u0101nui",
               "",
               "W\u0101 Uhipeket\u0101ne Raumati",
               "",
               "W\u0101 Uhipeket\u0101ne",
               "",
            };
        final String[] Afghanistan = new String[] {
               "W\u0101 Awhekenet\u0101na",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "W\u0101 Krasnoyarsk Arowh\u0101nui",
               "",
               "W\u0101 Krasnoyarsk Raumati",
               "",
               "W\u0101 Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "W\u0101 Aotearoa Arowh\u0101nui",
               "NZST",
               "W\u0101 Aotearoa Awatea",
               "NZDT",
               "W\u0101 Aotearoa",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "W\u0101 Novosibirsk Arowh\u0101nui",
               "",
               "W\u0101 Novosibirsk Raumati",
               "",
               "W\u0101 Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "W\u0101 Pirip\u012bni Arowh\u0101nui",
               "PST",
               "W\u0101 Pirip\u012bni Raumati",
               "PDT",
               "W\u0101 Pirip\u012bni",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "W\u0101 Vladivostok Arowh\u0101nui",
               "",
               "W\u0101 Vladivostok Raumati",
               "",
               "W\u0101 Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "W\u0101 o Te Moana \u012ania",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "W\u0101 o Ng\u0101 Mouter o Te Raina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "W\u0101 Arowh\u0101nui Newfoundland",
               "NST",
               "W\u0101 Awatea Newfoundland",
               "NDT",
               "W\u0101 Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "W\u0101 Tukumanat\u0101nga Arowh\u0101nui",
               "",
               "W\u0101 Tukumanat\u0101nga Raumati",
               "",
               "W\u0101 Tukumanat\u0101nga",
               "",
            };
        final String[] French_Guiana = new String[] {
               "W\u0101 Ki\u0101na W\u012bw\u012b",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "W\u0101 Whenua Kanaki Arowh\u0101nui",
               "",
               "W\u0101 Whenua Kanaki Raumati",
               "",
               "W\u0101 Whenua Kanaki",
               "",
            };
        final String[] South_Georgia = new String[] {
               "W\u0101 H\u014dria ki te Tonga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "W\u0101 Yekaterinburg Arowh\u0101nui",
               "",
               "W\u0101 Yekaterinburg Raumati",
               "",
               "W\u0101 Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "W\u0101 o Te Puku o \u0100wherika",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "W\u0101 o \u0100wherika ki te r\u0101whiti",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "W\u0101 Arowh\u0101nui o \u0100werika ki te uru",
               "WAT",
               "W\u0101 Raumati o \u0100wherika ki te uru",
               "WAT",
               "W\u0101 o \u0100wherika ki te uru",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "W\u0101 Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "W\u0101 Arowh\u0101nui Uropi Waenga",
               "CET",
               "W\u0101 Raumati Uropi Waenga",
               "CEST",
               "W\u0101 Uropi Waenga",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "W\u0101 Arowh\u0101nui Uropi R\u0101whiti",
               "EET",
               "W\u0101 Raumati Uropi R\u0101whiti",
               "EEST",
               "W\u0101 Uropi R\u0101whiti",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "W\u0101 Arowh\u0101nui Uropi Uru",
               "WET",
               "W\u0101 Raumati Uropi Uru",
               "WEST",
               "W\u0101 Uropi Uru",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "W\u0101 Arowh\u0101nui M\u0113hiko Kiwa",
               "MST",
               "W\u0101 Awatea M\u0113hiko Kiwa",
               "MDT",
               "W\u0101 M\u0113hiko Kiwa",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "W\u0101 Arowh\u0101nui o \u0100wherika ki te tonga",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "W\u0101 Arowh\u0101nui Waenga",
               "CST",
               "W\u0101 Awatea Waenga",
               "CDT",
               "W\u0101 Waenga",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "W\u0101 Arowh\u0101nui R\u0101whiti",
               "EST",
               "W\u0101 Awatea R\u0101whiti",
               "EST",
               "W\u0101 R\u0101whiti",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "W\u0101 Arowh\u0101nui Kiwa",
               "PST",
               "W\u0101 Awatea Kiwa",
               "PDT",
               "W\u0101 Kiwa",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "W\u0101 W\u012bw\u012b o Te Tonga me te K\u014dpakatanga ki te Tonga",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "W\u0101 Kiripati",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "W\u0101 Arowh\u0101nui Hawaii-Aleutian",
               "HST",
               "W\u0101 Awatea Hawaii-Aleutian",
               "HST",
               "W\u0101 Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "W\u0101 o Ng\u0101 Moutere Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "W\u0101 Arowh\u0101nui o St. Pierre me Miquelon",
               "",
               "W\u0101 Awatea o St. Pierre me Miquelon",
               "",
               "W\u0101 St. Pierre me Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "W\u0101 Arowh\u0101nui Maunga",
               "MST",
               "W\u0101 Awatea Maunga",
               "MST",
               "W\u0101 Maunga",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "W\u0101 o Ng\u0101 Motu M\u0101hara",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "W\u0101 Papua N\u016bkini",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "W\u0101 Ahitereiria Waenga Arowh\u0101nui",
               "ACST",
               "W\u0101 Ahitereiria Waenga Awatea",
               "ACDT",
               "W\u0101 Ahitereiria Waenga",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "W\u0101 Ahitereiria ki te R\u0101whiti Arowh\u0101nui",
               "AEST",
               "W\u0101 Ahitereiria ki te R\u0101whiti Awatea",
               "AEDT",
               "W\u0101 Ahitereiria ki te R\u0101whiti",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "W\u0101 Ahitereiria ki te Uru Arowh\u0101nui",
               "AWST",
               "W\u0101 Ahitereiria ki te Uru Awatea",
               "AWDT",
               "W\u0101 Ahitereiria ki te Uru",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "W\u0101 Initon\u012bhia Waenga",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "W\u0101 Initon\u012bhia ki te r\u0101whiti",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "W\u0101 Initon\u012bhia ki te uru",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "W\u0101 Katat\u0101nga ki te Uru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "W\u0101 Ahitereiria Waenga-Uru Arowh\u0101nui",
               "",
               "W\u0101 Ahitereiria Waenga-Uru Awatea",
               "",
               "W\u0101 Ahitereiria Waenga-Uru",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "W\u0101 Toharite Kiriw\u012bti",
                    "GMT",
                    "W\u0101 Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "W\u0101 Aonui K\u014dtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "W\u0101 Toharite Kiriw\u012bti",
                    "GMT",
                    "W\u0101 Airihi Arowh\u0101nui",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "W\u0101 Aonui K\u014dtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "W\u0101 Aonui K\u014dtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "W\u0101 Toharite Kiriw\u012bti",
                    "GMT",
                    "W\u0101 Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "W\u0101 Aonui K\u014dtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "W\u0101 Aonui K\u014dtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "W\u0101 Aonui K\u014dtuitui",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "W\u0101 Toharite Kiriw\u012bti",
                    "GMT",
                    "W\u0101 Airihi Arowh\u0101nui",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "W\u0101 Toharite Kiriw\u012bti",
                    "GMT",
                    "W\u0101 Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "W\u0101 Toharite Kiriw\u012bti",
                    "GMT",
                    "W\u0101 Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "W\u0101 Toharite Kiriw\u012bti",
                    "GMT",
                    "W\u0101 Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "W\u0101 Toharite Kiriw\u012bti",
                    "GMT",
                    "W\u0101 Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "W\u0101 Toharite Kiriw\u012bti",
                    "GMT",
                    "W\u0101 Piritana Raumati",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Gaza", "K\u0101ha" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Dubai", "Tupae" },
            { "timezone.excity.Asia/Macau", "Makau" },
            { "timezone.excity.Asia/Qatar", "Kat\u0101" },
            { "timezone.excity.Asia/Seoul", "Houra" },
            { "timezone.excity.Asia/Tokyo", "T\u014dkio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Brunei", "Poronai" },
            { "timezone.excity.Asia/Kuwait", "K\u016bweiti" },
            { "timezone.excity.Asia/Manila", "Manira" },
            { "timezone.excity.Asia/Riyadh", "Riata" },
            { "timezone.excity.Asia/Tehran", "Ter\u0101na" },
            { "timezone.excity.Etc/Unknown", "T\u0101one T\u0113 M\u014dhiotia" },
            { "timezone.excity.Europe/Oslo", "\u014choro" },
            { "timezone.excity.Europe/Rome", "R\u014dma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Africa/Tunis", "T\u016bn\u012bhi" },
            { "timezone.excity.Asia/Baghdad", "P\u0101katata" },
            { "timezone.excity.Asia/Bahrain", "P\u0101reina" },
            { "timezone.excity.Asia/Bangkok", "Pangakoko" },
            { "timezone.excity.Asia/Jakarta", "Tiak\u0101ta" },
            { "timezone.excity.Europe/Malta", "M\u0101rata" },
            { "timezone.excity.Europe/Paris", "Par\u012b" },
            { "timezone.excity.Indian/Cocos", "Kokohi" },
            { "timezone.excity.Pacific/Apia", "\u0100pia" },
            { "timezone.excity.Pacific/Fiji", "Wh\u012bt\u012b" },
            { "timezone.excity.Pacific/Guam", "Kuama" },
            { "timezone.excity.Asia/Katmandu", "Katamar\u016b" },
            { "timezone.excity.Asia/Shanghai", "Hangahai" },
            { "timezone.excity.Europe/Athens", "\u0100tene" },
            { "timezone.excity.Europe/Berlin", "Pear\u012bni" },
            { "timezone.excity.Europe/Dublin", "Tapurini" },
            { "timezone.excity.Europe/Lisbon", "R\u012bpene" },
            { "timezone.excity.Europe/London", "R\u0101nana" },
            { "timezone.excity.Europe/Madrid", "M\u0101tiri" },
            { "timezone.excity.Europe/Monaco", "Mon\u0101ko" },
            { "timezone.excity.Europe/Moscow", "Mohikau" },
            { "timezone.excity.Europe/Prague", "Par\u0101ka" },
            { "timezone.excity.Europe/Vienna", "Whiena" },
            { "timezone.excity.Europe/Zurich", "H\u016brika" },
            { "timezone.excity.Indian/Comoro", "Komoro" },
            { "timezone.excity.Pacific/Palau", "P\u0101rau" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Nairobi", "Ng\u0101iropi" },
            { "timezone.excity.Africa/Tripoli", "Tiripor\u012b" },
            { "timezone.excity.America/Belize", "P\u0113rihi" },
            { "timezone.excity.America/Cayman", "K\u0101mana" },
            { "timezone.excity.America/Havana", "Hawh\u0101na" },
            { "timezone.excity.Asia/Hong_Kong", "Hongipua" },
            { "timezone.excity.Asia/Jerusalem", "Hiruh\u0101rama" },
            { "timezone.excity.Asia/Singapore", "Hingapoa" },
            { "timezone.excity.Europe/Andorra", "Anat\u014dra" },
            { "timezone.excity.Europe/Vatican", "Te Poho-o-Pita" },
            { "timezone.excity.Pacific/Noumea", "N\u016bmea" },
            { "timezone.excity.Pacific/Wallis", "W\u0101rihi" },
            { "timezone.excity.America/Antigua", "Te Motu Nehe" },
            { "timezone.excity.America/Chicago", "Hik\u0101ko" },
            { "timezone.excity.America/Grenada", "Kerenata" },
            { "timezone.excity.America/Jamaica", "Hemeika" },
            { "timezone.excity.America/Toronto", "T\u0101roto" },
            { "timezone.excity.Asia/Phnom_Penh", "Penoma Pena" },
            { "timezone.excity.Australia/Perth", "P\u0113tia" },
            { "timezone.excity.Europe/Brussels", "Paruhi" },
            { "timezone.excity.Europe/Budapest", "Putap\u0113hi" },
            { "timezone.excity.Europe/Helsinki", "H\u0113riki" },
            { "timezone.excity.Europe/Istanbul", "Itap\u016bru" },
            { "timezone.excity.Indian/Maldives", "M\u0101ratiri" },
            { "timezone.excity.Pacific/Chatham", "R\u0113kohu" },
            { "timezone.excity.Pacific/Norfolk", "N\u014dpoke" },
            { "timezone.excity.America/Barbados", "Papatohe" },
            { "timezone.excity.America/Dominica", "Tominika" },
            { "timezone.excity.America/New_York", "Te \u0100poro Nui" },
            { "timezone.excity.America/St_Johns", "Hato Hone" },
            { "timezone.excity.America/St_Lucia", "Hato Ruihia" },
            { "timezone.excity.Antarctica/Davis", "R\u0113weti" },
            { "timezone.excity.Atlantic/Bermuda", "P\u0101mura" },
            { "timezone.excity.Australia/Darwin", "T\u0101wini" },
            { "timezone.excity.Australia/Hobart", "Hopat\u0101one" },
            { "timezone.excity.Australia/Sydney", "Poih\u0101kena" },
            { "timezone.excity.Europe/Amsterdam", "P\u0101puni\u0101mita" },
            { "timezone.excity.Europe/Stockholm", "Tokoomo" },
            { "timezone.excity.Indian/Christmas", "Kirihimete" },
            { "timezone.excity.Indian/Mauritius", "Marihi" },
            { "timezone.excity.Pacific/Auckland", "T\u0101maki Makaurau" },
            { "timezone.excity.America/Goose_Bay", "Kuihi Pei" },
            { "timezone.excity.America/Guatemala", "Kuatam\u0101ra" },
            { "timezone.excity.America/St_Thomas", "Hato Tamati" },
            { "timezone.excity.America/Vancouver", "Te Whanga-a-Kiwa" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuara R\u016bpa" },
            { "timezone.excity.Europe/Copenhagen", "Kopeheikana" },
            { "timezone.excity.Europe/Luxembourg", "Rakapu\u014d" },
            { "timezone.excity.Europe/San_Marino", "Hana Marino" },
            { "timezone.excity.Pacific/Pago_Pago", "Pango Pango" },
            { "timezone.excity.America/Costa_Rica", "Koto Rika" },
            { "timezone.excity.America/Grand_Turk", "T\u0101koru Nui" },
            { "timezone.excity.America/Martinique", "M\u0101tiniki" },
            { "timezone.excity.America/St_Vincent", "Hato W\u0113neti" },
            { "timezone.excity.Atlantic/St_Helena", "Hato H\u0113rena" },
            { "timezone.excity.Australia/Adelaide", "Atireira" },
            { "timezone.excity.Australia/Brisbane", "Piripane" },
            { "timezone.excity.Europe/Isle_of_Man", "Te Moutere Mana" },
            { "timezone.excity.America/El_Salvador", "Whakaora" },
            { "timezone.excity.America/Los_Angeles", "Ng\u0101 Anahera" },
            { "timezone.excity.America/Mexico_City", "M\u0113hiko T\u0101onenui" },
            { "timezone.excity.America/Puerto_Rico", "Peta Riko" },
            { "timezone.excity.Atlantic/Cape_Verde", "Te K\u016brae Matomato" },
            { "timezone.excity.Australia/Melbourne", "Poipiripi" },
            { "timezone.excity.Antarctica/Macquarie", "Makoare" },
            { "timezone.excity.Pacific/Port_Moresby", "Pota Moahipi" },
            { "timezone.excity.America/Cambridge_Bay", "Kemureti Pei" },
            { "timezone.excity.Atlantic/South_Georgia", "H\u014dria ki Te Tonga" },
        };
        return data;
    }
}
