/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_syr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "\u0710\u0720\u0721\u0722\u071d\u0710";
        final String metaValue_ar = "\u0725\u072a\u0712\u071d\u072c";
        final String metaValue_hy = "\u0710\u072a\u0721\u0722\u071d\u072c";
        final String metaValue_gu = "\u0713\u0718\u0713\u0710\u072a\u071d\u072c";
        final String metaValue_type_hc_h23 = "\u071b\u071f\u0742\u0723\u0710 24 \u072b\u0725\u072c\u0742\u0710 (0\u201323)";
        final Object[][] data = new Object[][] {
            { "001", "\u072c\u0710\u0712\u071d\u0720" },
            { "002", "\u0710\u0726\u072a\u071d\u0729\u0710" },
            { "003", "\u0710\u0721\u072a\u071d\u071f\u0710 \u0713\u072a\u0712\u071d\u071d\u072c\u0710" },
            { "005", "\u0710\u0721\u072a\u071d\u071f\u0710 \u072c\u071d\u0721\u0722\u071d\u072c\u0710" },
            { "009", "\u0710\u0718\u0729\u071d\u0722\u0718\u0723\u071d\u0710" },
            { "011", "\u0710\u0726\u072a\u071d\u0729\u0710 \u0721\u0725\u072a\u0712\u071d\u072c\u0710" },
            { "013", "\u0710\u0721\u072a\u071d\u071f\u0710 \u0721\u0728\u0725\u071d\u072c\u0710" },
            { "014", "\u0710\u0726\u072a\u071d\u0729\u0710 \u0721\u0715\u0722\u071a\u071d\u072c\u0710" },
            { "015", "\u0710\u0726\u072a\u071d\u0729\u0710 \u0713\u072a\u0712\u071d\u071d\u072c\u0710" },
            { "017", "\u0710\u0726\u072a\u071d\u0729\u0710 \u0721\u0728\u0725\u071d\u072c\u0710" },
            { "018", "\u0710\u0726\u072a\u071d\u0729\u0710 \u072c\u071d\u0721\u0722\u071d\u072c\u0710" },
            { "019", "\u0710\u0721\u072a\u0308\u071d\u071f\u0710" },
            { "021", "\u0713\u072a\u0712\u071d\u0710 \u0710\u0721\u072a\u071d\u071f\u0710" },
            { "029", "\u071f\u0710\u072a\u071d\u0712\u071d\u0722" },
            { "030", "\u0710\u0723\u071d\u0710 \u0721\u0715\u0722\u071a\u071d\u072c\u0710" },
            { "034", "\u0710\u0723\u071d\u0710 \u072c\u071d\u0721\u0722\u071d\u072c\u0710" },
            { "035", "\u072c\u071d\u0721\u0722 \u0721\u0715\u0722\u071a \u0710\u0723\u071d\u0710" },
            { "039", "\u0710\u0718\u072a\u0718\u0726\u0710 \u072c\u071d\u0721\u0722\u071d\u072c\u0710" },
            { "053", "\u0710\u0718\u0723\u071b\u072a\u0710\u0720\u0710\u0723\u071d\u0710" },
            { "054", "\u0721\u071d\u0720\u0710\u0722\u071d\u0723\u071d\u0710" },
            { "057", "\u0721\u071d\u071f\u072a\u0718\u0722\u071d\u0719\u071d\u0710" },
            { "061", "\u0726\u0718\u0720\u0722\u071d\u0723\u071d\u0710" },
            { "142", "\u0710\u0723\u071d\u0710" },
            { "143", "\u0710\u0723\u071d\u0710 \u0721\u0728\u0725\u071d\u072c\u0710" },
            { "145", "\u0710\u0723\u071d\u0710 \u0721\u0725\u072a\u0712\u071d\u072c\u0710" },
            { "150", "\u0710\u0718\u072a\u0718\u0726\u0710" },
            { "151", "\u0710\u0718\u072a\u0718\u0726\u0710 \u0721\u0715\u0722\u071a\u071d\u072c\u0710" },
            { "154", "\u0710\u0718\u072a\u0718\u0726\u0710 \u0713\u072a\u0712\u071d\u071d\u072c\u0710" },
            { "155", "\u0710\u0718\u072a\u0718\u0726\u0710 \u0721\u0725\u072a\u0712\u0742\u071d\u072c\u0710" },
            { "202", "\u0710\u0726\u072a\u071d\u0729\u0710 \u0728\u071a\u072a\u0710 \u072c\u071d\u0721\u0722\u071d\u072c\u0710" },
            { "419", "\u0710\u0721\u072a\u071d\u071f\u0710 \u0720\u072c\u071d\u0722\u071d\u072c\u0710" },
            { "AD", "\u0710\u0722\u0715\u0718\u072a\u0710" },
            { "AE", "\u0710\u0721\u071d\u072a\u0308\u0718\u072c\u0710 \u0721\u071a\u071d\u0715\u0308\u072c\u0710 \u0725\u072a\u0308\u0712\u071d\u0710" },
            { "AF", "\u0710\u0726\u0713\u0710\u0722\u0723\u072c\u0710\u0722" },
            { "AG", "\u0710\u0722\u072c\u071d\u0713\u0718\u0710 \u0718\u0712\u0710\u072a\u0712\u0718\u0715\u0710" },
            { "AI", "\u0710\u0722\u0713\u0718\u071d\u0720\u0710" },
            { "AL", "\u0710\u0720\u0712\u0722\u071d\u0710" },
            { "AM", "\u0710\u072a\u0721\u0722\u071d\u0710" },
            { "AO", "\u0710\u0722\u0713\u0718\u0720\u0710" },
            { "AQ", "\u0710\u0722\u072c\u072a\u072c\u071d\u071f\u0710" },
            { "AR", "\u0710\u072a\u0713\u0722\u072c\u071d\u0722\u0710" },
            { "AS", "\u0723\u0721\u0718\u0710 \u0710\u0721\u071d\u0716\u0308\u071f\u071d\u0710" },
            { "AT", "\u0710\u0718\u0723\u071b\u072a\u071d\u0710" },
            { "AU", "\u0710\u0718\u0723\u072c\u072a\u0720\u071d\u0710" },
            { "AW", "\u0710\u072a\u0718\u0712\u0710" },
            { "AX", "\u0713\u0719\u071d\u0716\u0308\u0710 \u0715\u0710\u0720\u0710\u0722\u0715" },
            { "AZ", "\u0710\u0719\u072a\u0712\u071d\u0713\u0710\u0722" },
            { "BA", "\u0712\u0718\u0723\u0722\u0710 \u0718\u0717\u072a\u072c\u0723\u0713\u0718\u0712\u071d\u0722\u0710" },
            { "BB", "\u0712\u072a\u0712\u0710\u0715\u0718\u0723" },
            { "BD", "\u0712\u0722\u0713\u0720\u0710\u0715\u071d\u072b" },
            { "BE", "\u0712\u0720\u0713\u071d\u0729\u0710" },
            { "BF", "\u0712\u0718\u072a\u0729\u071d\u0722\u0710 \u0726\u0710\u0723\u0718" },
            { "BG", "\u0712\u0718\u0720\u0713\u0710\u072a\u071d\u0710" },
            { "BH", "\u0712\u071a\u072a\u071d\u0722" },
            { "BI", "\u0712\u0718\u072a\u0718\u0722\u0715\u071d" },
            { "BJ", "\u0712\u0722\u071d\u0722" },
            { "BL", "\u0721\u072a\u072c\u071d \u0712\u072a \u072c\u0718\u0720\u0721\u071d" },
            { "BM", "\u0712\u072a\u0721\u0718\u0715\u0710" },
            { "BN", "\u0712\u072a\u0718\u0722\u0710\u071d" },
            { "BO", "\u0712\u0718\u0720\u071d\u0712\u071d\u0710" },
            { "BQ", "\u071f\u0710\u072a\u071d\u0712\u071d\u0722 \u0715\u0722\u071d\u072c\u071d\u072a\u0720\u0710\u0722\u0715\u0723" },
            { "BR", "\u0712\u072a\u0710\u0719\u071d\u0720" },
            { "BS", "\u0712\u0717\u0710\u0721\u0723" },
            { "BT", "\u0712\u0718\u072c\u0710\u0722" },
            { "BV", "\u0713\u0719\u072a\u072c\u0710 \u0715\u0712\u0718\u0712\u071d\u072c" },
            { "BW", "\u0712\u0718\u071b\u0723\u0718\u0710\u0722\u0710" },
            { "BY", "\u0712\u0720\u0710\u072a\u0718\u0723" },
            { "BZ", "\u0712\u0720\u071d\u0719" },
            { "CA", "\u071f\u0722\u0715\u0710" },
            { "CC", "\u0713\u0719\u071d\u0716\u0308\u0710 \u0715\u071f\u0718\u071f\u0718\u0723" },
            { "CD", "\u071f\u0718\u0722\u0713\u0718 - \u071f\u071d\u0722\u072b\u0710\u0723\u0710" },
            { "CF", "\u0729\u0718\u071b\u0722\u071d\u0718\u072c\u0710 \u0715\u0710\u0726\u072a\u071d\u0729\u0710 \u0721\u0728\u0725\u071d\u072c\u0710" },
            { "CG", "\u071f\u0718\u0722\u0713\u0718 - \u0712\u072a\u0710\u0719\u0710\u0712\u071d\u0720" },
            { "CH", "\u0723\u0718\u071d\u0723\u072a\u0710" },
            { "CI", "\u0729\u0718\u071b \u0715\u071d\u0712\u0718\u0710\u072a" },
            { "CK", "\u0713\u0719\u072a\u072c\u0710 \u071f\u0718\u071f" },
            { "CL", "\u072c\u072b\u071d\u0720\u071d" },
            { "CM", "\u071f\u0710\u0721\u072a\u0718\u0722" },
            { "CN", "\u0728\u071d\u0722" },
            { "CO", "\u071f\u0718\u0720\u0718\u0721\u0712\u071d\u0710" },
            { "CR", "\u071f\u0718\u0723\u072c\u0710 \u072a\u071d\u0729\u0710" },
            { "CU", "\u071f\u0718\u0712\u0710" },
            { "CV", "\u071f\u0710\u0726 \u0712\u071d\u072a\u0715\u071d (\u072a\u071d\u072b\u0710 \u071d\u0718\u072a\u0729\u0710)" },
            { "CW", "\u071f\u0718\u072a\u0710\u071f\u0718" },
            { "CX", "\u0713\u0719\u072a\u072c\u0710 \u0715\u071f\u072a\u071d\u0723\u072c\u0721\u0723" },
            { "CY", "\u0729\u0718\u0726\u072a\u0718\u0723" },
            { "CZ", "\u072c\u072b\u071d\u071f\u071d\u0710" },
            { "DE", metaValue_DE },
            { "DJ", "\u0713\u071d\u0712\u0718\u071b\u071d" },
            { "DK", "\u0715\u0710\u0722\u0721\u0710\u072a\u0729" },
            { "DM", "\u0715\u0718\u0721\u071d\u0722\u071d\u0729\u0710" },
            { "DO", "\u0729\u0718\u071b\u0722\u071d\u0718\u072c\u0710 \u0715\u0718\u0721\u071d\u0722\u071d\u0729\u0710\u0722\u071d\u072c\u0710" },
            { "DZ", "\u0713\u0719\u0710\u072a" },
            { "EA", "\u071f\u0718\u071d\u071b\u0710 \u0718\u0721\u071d\u0720\u071d\u0710" },
            { "EC", "\u0710\u0729\u0718\u0710\u0715\u0718\u072a" },
            { "EE", "\u0710\u0723\u071b\u0718\u0722\u071d\u0710" },
            { "EG", "\u0721\u0728\u072a\u071d\u0722" },
            { "EH", "\u0728\u071a\u072a\u0710 \u0721\u0725\u072a\u0712\u071d\u072c\u0710" },
            { "ER", "\u0710\u072a\u072c\u072a\u071d\u0710" },
            { "ES", "\u0710\u0723\u0726\u0722\u071d\u0710" },
            { "ET", "\u071f\u0718\u072b" },
            { "EU", "\u071a\u0718\u071d\u0715\u0710 \u0710\u0718\u072a\u0718\u0726\u071d\u0710" },
            { "EZ", "\u0729\u0720\u071d\u0721\u0710 \u0715\u0710\u0718\u072a\u0718" },
            { "FI", "\u0726\u071d\u0722\u0720\u0722\u0715" },
            { "FJ", "\u0726\u071d\u0713\u071d" },
            { "FK", "\u0713\u0719\u072a\u072c\u0710 \u0715\u0726\u0720\u071f\u0720\u0722\u0715" },
            { "FM", "\u0710\u072c\u072a\u0718\u072c\u0710 \u0726\u0715\u072a\u0720\u071d\u0710 \u0715\u0721\u071d\u0729\u072a\u0718\u0722\u071d\u0723\u071d\u0710" },
            { "FO", "\u0713\u0719\u071d\u0716\u0308\u0710 \u0715\u0726\u072a\u0718" },
            { "FR", "\u0726\u072a\u0722\u0723\u0710" },
            { "GA", "\u0713\u0712\u0718\u0722" },
            { "GB", "\u0721\u0720\u071f\u0718\u072c\u0710 \u0721\u071a\u071d\u0715\u072c\u0710" },
            { "GD", "\u0713\u072a\u071d\u0722\u0710\u0715\u0710" },
            { "GE", "\u0713\u0718\u072a\u0713\u071d\u0710" },
            { "GF", "\u0713\u0718\u071d\u0710\u0722\u0710 \u0726\u072a\u0722\u0723\u071d\u072c\u0710" },
            { "GG", "\u0713\u0718\u072a\u0722\u0719\u071d" },
            { "GH", "\u0713\u0710\u0722\u0710" },
            { "GI", "\u0713\u0712\u072a\u0720\u071b\u072a" },
            { "GL", "\u0713\u072a\u071d\u0722\u0720\u0722\u0715" },
            { "GM", "\u0713\u0721\u0712\u071d\u0710" },
            { "GN", "\u0713\u071d\u0722\u071d\u0710" },
            { "GP", "\u0713\u0718\u0710\u0715\u0718\u0720\u0718\u0726\u0710\u071d" },
            { "GQ", "\u0713\u071d\u0722\u071d\u0710 \u072b\u0718\u071d\u072c\u0710" },
            { "GR", "\u071d\u0718\u0722" },
            { "GS", "\u0713\u0719\u071d\u0716\u0308\u0710 \u0715\u0713\u0718\u072a\u0713\u071d\u0710 \u0718\u0723\u0710\u0722\u0715\u0718\u071d\u071f \u072c\u071d\u0721\u0722\u071d\u0308\u0710" },
            { "GT", "\u0713\u0718\u0710\u072c\u071d\u0721\u0710\u0720\u0710" },
            { "GU", "\u0713\u0718\u0710\u0721" },
            { "GW", "\u0713\u071d\u0722\u071d\u0710 \u0712\u071d\u0723\u0710\u0718" },
            { "GY", "\u0713\u0718\u071d\u0710\u0722\u0710" },
            { "HK", "\u0717\u0718\u0722\u0713 \u071f\u0718\u0722\u0713" },
            { "HN", "\u0717\u0718\u0722\u0715\u0718\u072a\u0723" },
            { "HR", "\u0729\u072a\u0718\u0710\u071b\u071d\u0710" },
            { "HT", "\u0717\u0710\u071d\u072c\u071d" },
            { "HU", "\u0721\u0713\u072a" },
            { "IC", "\u0713\u0719\u071d\u0716\u0308\u0710 \u0715\u071f\u0710\u0722\u072a\u071d" },
            { "ID", "\u0710\u071d\u0722\u0715\u0718\u0722\u071d\u0723\u071d\u0710" },
            { "IE", "\u0710\u071d\u072a\u0720\u0722\u0715" },
            { "IL", "\u0710\u071d\u0723\u072a\u0710\u071d\u0720" },
            { "IM", "\u0713\u0719\u072a\u072c\u0710 \u0715\u0721\u0710\u0722" },
            { "IN", "\u0717\u0722\u0715\u0718" },
            { "IQ", "\u0725\u071d\u072a\u0729" },
            { "IR", "\u0710\u071d\u072a\u0710\u0722" },
            { "IS", "\u0710\u071d\u0723\u0720\u0722\u0715" },
            { "IT", "\u0710\u071d\u071b\u0720\u071d\u0710" },
            { "JE", "\u0713\u071d\u072a\u0719\u071d" },
            { "JM", "\u0713\u0721\u071d\u071f\u0710" },
            { "JO", "\u0710\u0718\u072a\u0715\u0718\u0722" },
            { "JP", "\u071d\u0726\u0722" },
            { "KE", "\u0729\u071d\u0722\u071d\u0710" },
            { "KG", "\u0729\u071d\u072a\u0713\u071d\u0719\u0723\u072c\u0710\u0722" },
            { "KH", "\u071f\u0721\u0712\u0718\u0715\u071d\u0710" },
            { "KI", "\u071f\u071d\u072a\u071d\u0712\u072c\u071d" },
            { "KM", "\u0713\u0719\u072a\u072c\u0710 \u0715\u0729\u0721\u072a" },
            { "KN", "\u0723\u0710\u0722\u072c \u071f\u071d\u072c\u0723 \u0718\u0722\u071d\u0712\u071d\u0723" },
            { "KP", "\u071f\u0718\u072a\u071d\u0710 \u0715\u0713\u072a\u0712\u071d\u0710" },
            { "KR", "\u071f\u0718\u072a\u071d\u0710 \u0715\u072c\u071d\u0721\u0722\u071d\u0710" },
            { "KW", "\u071f\u0718\u071d\u072c" },
            { "KY", "\u0713\u0719\u071d\u0716\u0308\u0710 \u0715\u071f\u0710\u071d\u0721\u0710\u0722" },
            { "KZ", "\u071f\u0719\u0729\u0723\u072c\u0710\u0722" },
            { "LA", "\u0720\u0710\u0718\u0723" },
            { "LB", "\u0720\u0712\u0722\u0722" },
            { "LC", "\u0721\u072a\u072c\u071d \u0720\u0718\u072b\u0710" },
            { "LI", "\u0720\u071d\u071f\u071b\u0722\u072b\u071b\u071d\u0722" },
            { "LK", "\u072b\u072a\u071d \u0720\u0710\u0722\u071f\u0710" },
            { "LR", "\u0720\u071d\u0712\u071d\u072a\u071d\u0710" },
            { "LS", "\u0720\u0723\u0718\u071b\u0718" },
            { "LT", "\u0720\u072c\u0718\u0722\u071d\u0710" },
            { "LU", "\u0720\u0718\u071f\u0723\u0721\u0712\u0718\u072a\u0713" },
            { "LV", "\u0720\u0710\u071b\u0712\u071d\u0710" },
            { "LY", "\u0720\u0718\u0712\u0710" },
            { "MA", "\u0721\u0713\u072a\u0712" },
            { "MC", "\u0721\u0718\u0722\u0710\u0729\u0718" },
            { "MD", "\u0721\u0718\u0720\u0715\u0718\u0712\u0710" },
            { "ME", "\u0721\u0718\u0722\u071b\u071d\u0722\u071d\u0713\u072a\u0718" },
            { "MF", "\u0723\u0710\u0722\u072c \u0721\u0710\u072a\u072c\u071d\u0722" },
            { "MG", "\u0721\u0715\u0713\u0723\u0729\u072a" },
            { "MH", "\u0713\u0719\u072a\u072c\u0710 \u0721\u0710\u072a\u072b\u0710\u0720" },
            { "MK", "\u0713\u072a\u0712\u071d \u0721\u0729\u0715\u0718\u0722\u071d\u0710" },
            { "ML", "\u0721\u0710\u0720\u071d" },
            { "MM", "\u0721\u071d\u0710\u0722\u0721\u0710\u072a (\u0712\u0718\u072a\u0721\u0710)" },
            { "MN", "\u0721\u0718\u0722\u0713\u0718\u0720\u071d\u0710" },
            { "MP", "\u0713\u0719\u071d\u0716\u0308\u0710 \u0715\u0721\u072a\u071d\u0722\u0710 \u0713\u072a\u0712\u071d\u0710" },
            { "MQ", "\u0721\u0710\u072a\u072c\u071d\u0722\u071d\u0729" },
            { "MR", "\u0721\u0718\u072a\u071d\u071b\u0722\u071d\u0710" },
            { "MS", "\u0721\u0718\u0722\u0723\u071d\u072a\u0710\u072c" },
            { "MT", "\u0721\u071d\u0720\u071b\u0710" },
            { "MU", "\u0721\u0718\u072a\u071d\u071b\u071d\u0718\u0723" },
            { "MV", "\u0713\u0719\u072a\u072c\u0710 \u0721\u0710\u0720\u0715\u071d\u0712\u071d\u072c\u0710" },
            { "MW", "\u0721\u0720\u0710\u0718\u071d" },
            { "MX", "\u0721\u071f\u0723\u071d\u071f\u0718" },
            { "MY", "\u0721\u0720\u071d\u0719\u071d\u0710" },
            { "MZ", "\u0721\u0718\u0719\u0721\u0712\u071d\u0729" },
            { "NA", "\u0722\u0721\u071d\u0712\u071d\u0710" },
            { "NE", "\u0722\u071d\u0713\u072a" },
            { "NG", "\u0722\u071d\u0713\u071d\u072a\u071d\u0710" },
            { "NI", "\u0722\u071d\u071f\u072a\u0710\u0713\u0718\u0710" },
            { "NL", "\u0717\u0718\u0720\u0722\u0715\u0710" },
            { "NO", "\u0722\u0718\u072a\u0712\u071d\u0713" },
            { "NP", "\u0722\u071d\u0726\u0710\u0720" },
            { "NR", "\u0722\u0710\u0718\u072a\u0718" },
            { "NZ", "\u0722\u071d\u0718 \u0719\u071d\u0720\u0722\u0715" },
            { "OM", "\u0725\u0718\u0721\u0710\u0722" },
            { "PA", "\u0726\u0722\u0721\u0710" },
            { "PE", "\u0726\u071d\u072a\u0718" },
            { "PG", "\u0726\u0710\u0726\u0718\u0710 \u0713\u071d\u0722\u071d\u0710 \u071a\u0715\u072c\u0710" },
            { "PH", "\u0726\u071d\u0720\u071d\u0726\u071d\u0722\u071d\u0710" },
            { "PK", "\u0726\u0710\u071f\u0723\u072c\u0710\u0722" },
            { "PL", "\u0726\u0718\u0720\u0722\u0715" },
            { "PM", "\u0723\u0710\u0722\u072c \u0726\u071d\u0725\u072a \u0718\u0721\u0729\u0718\u0720\u0718\u0722" },
            { "PR", "\u0726\u0718\u0710\u072a\u071b\u0718 \u072a\u071d\u0729\u0718" },
            { "PS", "\u0710\u072c\u0716\u0308\u0718\u072c\u0710 \u0715\u0726\u0720\u0723\u071b\u071d\u0722" },
            { "PT", "\u0726\u0718\u072a\u071b\u0718\u0713\u0720" },
            { "PW", "\u0726\u0720\u0710\u0718" },
            { "PY", "\u0726\u072a\u0713\u0718\u0710\u071d" },
            { "QA", "\u0729\u071b\u072a" },
            { "QO", "\u0710\u0718\u0729\u071d\u0722\u0718\u0723\u071d\u0710 \u0712\u072a\u071d\u072c\u0710" },
            { "RE", "\u072a\u071d\u0718\u0722\u071d\u0718\u0722" },
            { "RO", "\u072a\u0718\u0721\u0722\u071d\u0710" },
            { "RS", "\u0723\u072a\u0712\u071d\u0710" },
            { "RU", "\u072a\u0718\u0723\u071d\u0710" },
            { "RW", "\u072a\u0718\u0710\u0722\u0715\u0710" },
            { "SA", "\u0723\u0725\u0718\u0715\u071d\u0710" },
            { "SB", "\u0713\u0719\u072a\u072c\u0710 \u0715\u072b\u0720\u071d\u0721\u0718\u0722" },
            { "SC", "\u0723\u0710\u071d\u072b\u071d\u0720" },
            { "SD", "\u0723\u0718\u0715\u0710\u0722" },
            { "SE", "\u0723\u0718\u071d\u0715" },
            { "SG", "\u0723\u071d\u0722\u0713\u0710\u0726\u0718\u072a" },
            { "SH", "\u0721\u072a\u072c\u071d \u0717\u071d\u0720\u071d\u0722\u0710" },
            { "SI", "\u0723\u0720\u0718\u0712\u0722\u071d\u0710" },
            { "SJ", "\u0723\u0712\u0720\u0715\u0712\u072a\u0715 \u0718\u0713\u0710\u0722 \u0721\u0710\u071d\u071d\u0722" },
            { "SK", "\u0723\u0720\u0718\u0712\u0729\u071d\u0710" },
            { "SL", "\u0723\u071d\u071d\u072a\u0710 \u0720\u071d\u0710\u0718\u0722\u071d" },
            { "SM", "\u0723\u0722 \u0721\u072a\u071d\u0722\u0718" },
            { "SN", "\u0723\u0722\u0713\u0710\u0720" },
            { "SO", "\u0728\u0718\u0721\u0710\u0720" },
            { "SR", "\u0723\u0718\u072a\u071d\u0722\u0710\u0721" },
            { "SS", "\u072c\u071d\u0721\u0722 \u0723\u0718\u0715\u0710\u0722" },
            { "ST", "\u0723\u0710\u0718 \u071b\u0718\u0721\u071d \u0718\u0726\u072a\u071d\u0722\u0723\u071d\u0726\u071d" },
            { "SV", "\u0710\u0720 \u0723\u0720\u0712\u0710\u0715\u0718\u072a" },
            { "SX", "\u0723\u0722\u072c \u0721\u0710\u072a\u072c\u071d\u0722" },
            { "SY", "\u0723\u0718\u072a\u071d\u0710" },
            { "SZ", "\u0710\u0723\u0718\u0710\u071b\u071d\u0722\u071d" },
            { "TC", "\u0713\u0719\u071d\u0716\u0308\u0710 \u0715\u072c\u0718\u072a\u071f\u0723 \u0718\u071f\u0710\u071d\u071f\u0718\u0723" },
            { "TD", "\u072c\u072b\u0710\u0715" },
            { "TF", "\u0729\u0720\u071d\u0721\u0308\u0710 \u0715\u0726\u072a\u0722\u0723\u0710 \u072c\u071d\u0721\u0722\u071d\u072c\u0710" },
            { "TG", "\u072c\u0718\u0713\u0718" },
            { "TH", "\u072c\u0710\u071d\u0720\u0722\u0715" },
            { "TJ", "\u072c\u0710\u0713\u071d\u071f\u0723\u072c\u0710\u0722" },
            { "TL", "\u072c\u071d\u0721\u0718\u072a-\u0720\u0723\u072c\u071d" },
            { "TM", "\u072c\u0718\u072a\u071f\u0721\u0722\u0723\u072c\u0710\u0722" },
            { "TN", "\u072c\u0718\u0722\u0723" },
            { "TO", "\u072c\u0718\u0722\u0713\u0710" },
            { "TR", "\u072c\u0718\u072a\u071f\u071d\u0710" },
            { "TT", "\u072c\u072a\u071d\u0722\u071d\u0715\u0710\u0715 \u0718\u072c\u0718\u0712\u0710\u0713\u0718" },
            { "TV", "\u072c\u0718\u0712\u0710\u0720\u0718" },
            { "TW", "\u072c\u0710\u071d\u0718\u0710\u0722" },
            { "TZ", "\u071b\u0722\u0719\u0722\u071d\u0710" },
            { "UA", "\u0710\u0718\u0729\u072a\u0710\u071d\u0722\u0710" },
            { "UG", "\u0710\u0718\u0713\u0722\u0715\u0710" },
            { "UN", "\u0710\u0721\u0308\u0718\u072c\u0710 \u0721\u071a\u071d\u0308\u0715\u072c\u0710" },
            { "US", "\u0710\u0718\u071a\u0715\u0308\u0722\u0710 \u0721\u071a\u071d\u0715\u0308\u0710" },
            { "UY", "\u0710\u0718\u072a\u0718\u0713\u0718\u0710\u071d" },
            { "UZ", "\u0710\u0718\u0719\u0712\u071f\u0723\u072c\u0710\u0722" },
            { "VA", "\u0721\u0715\u071d\u0722\u072c\u0710 \u0715\u0718\u071b\u071d\u0729\u0722" },
            { "VC", "\u0723\u0710\u0722\u072c \u0712\u071d\u0722\u0723\u071d\u0722\u072c \u0718\u0713\u072a\u071d\u0722\u0710\u0715\u071d\u0722\u0710\u0723" },
            { "VE", "\u0712\u0722\u0719\u0718\u071d\u0720\u0710" },
            { "VG", "\u0713\u0719\u0716\u0308\u071d\u0710 \u0712\u072c\u0718\u0308\u0720\u0710 \u0715\u0712\u072a\u071d\u071b\u0722\u071d\u0710" },
            { "VI", "\u0713\u0719\u0716\u0308\u071d\u0710 \u0712\u072c\u0718\u0308\u0720\u0710 \u0715\u0710\u0721\u071d\u072a\u071f\u0710" },
            { "VN", "\u0712\u071d\u072c\u0722\u0710\u0721" },
            { "VU", "\u0712\u0710\u0722\u0718\u0710\u071b\u0718" },
            { "WS", "\u0723\u0721\u0718\u0710" },
            { "XK", "\u0729\u0718\u0723\u0718\u0712\u0718" },
            { "YE", "\u071d\u0721\u0722" },
            { "YT", "\u0721\u0710\u071d\u0718\u071b" },
            { "ZA", "\u072c\u071d\u0721\u0722 \u0710\u0726\u072a\u071d\u0729\u0710" },
            { "ZM", "\u0719\u0710\u0721\u0712\u071d\u0710" },
            { "ZW", "\u0719\u071d\u0721\u0712\u0710\u0712\u0718\u071d" },
            { "ab", "\u0710\u0712\u071f\u0710\u0719\u071d\u072c" },
            { "am", "\u0710\u0721\u072a\u0722\u071d\u072c" },
            { "an", "\u0710\u072a\u0710\u0713\u0718\u0722\u071d\u072c" },
            { "ar", metaValue_ar },
            { "az", "\u0710\u0719\u072a\u0712\u071d\u0713\u0710\u0722\u071d\u072c" },
            { "bn", "\u0712\u0722\u0713\u0710\u0720\u071d\u0710" },
            { "de", metaValue_DE },
            { "el", "\u071d\u0718\u0722\u0710\u071d\u072c" },
            { "en", "\u0710\u0722\u0713\u0720\u071d\u072c" },
            { "es", "\u0723\u0726\u0722\u071d\u071d\u0710" },
            { "fa", "\u0726\u072a\u0723\u071d\u072c" },
            { "ff", "\u0726\u0718\u0720\u0710\u0717\u071d\u072c" },
            { "fi", "\u0726\u071d\u0722\u0720\u0722\u0715\u071d\u072c" },
            { "fr", "\u0726\u072a\u0722\u0723\u071d\u072c" },
            { "gl", "\u0713\u0720\u071d\u0729\u071d\u072c" },
            { "gu", metaValue_gu },
            { "he", "\u0725\u0712\u072a\u0710\u071d\u072c" },
            { "hi", "\u0717\u0722\u0715\u071d\u0710" },
            { "hy", metaValue_hy },
            { "it", "\u0710\u071d\u071b\u0720\u071d\u072c" },
            { "ka", "\u0713\u0718\u072a\u0713\u071d\u0710\u071d\u072c" },
            { "ku", "\u0729\u0718\u072a\u0715\u071d\u072c" },
            { "la", "\u0720\u072c\u071d\u0722\u071d\u072c" },
            { "lg", "\u0713\u0722\u0715\u071d\u072c" },
            { "nl", "\u0717\u0718\u0720\u0722\u0715\u071d\u072c" },
            { "no", "\u0722\u0718\u072a\u0712\u071d\u0713\u0710\u071d\u072c" },
            { "om", "\u0710\u0718\u072a\u0718\u0721\u0718\u0710\u071d\u072c" },
            { "pl", "\u0726\u0718\u0720\u0722\u0715\u0710\u071d\u072c" },
            { "pt", "\u0726\u0718\u072a\u071b\u0718\u0713\u0720\u0710\u071d\u072c" },
            { "ro", "\u072a\u0718\u0721\u0722\u0710\u071d\u072c" },
            { "ru", "\u0710\u0718\u072a\u0718\u0723\u0722\u071d\u072c" },
            { "sq", "\u0710\u0720\u0712\u0722\u071d\u072c" },
            { "sv", "\u0723\u0718\u071d\u0715\u0710\u071d\u072c" },
            { "sw", "\u0723\u0718\u0710\u0717\u071d\u0720\u0710\u071d\u072c" },
            { "tr", "\u072c\u0718\u072a\u071f\u071d\u072c" },
            { "uk", "\u0710\u0718\u071f\u072a\u0710\u071d\u0722\u0710\u071d\u072c" },
            { "ur", "\u0710\u0718\u072a\u0715\u0718\u071d\u072c" },
            { "vi", "\u0712\u071d\u072c\u0722\u0710\u0721\u0710\u071d\u072c" },
            { "yi", "\u071d\u0715\u071d\u072c\u071d\u072c" },
            { "zh", "\u0728\u071d\u0722\u071d\u072c" },
            { "arp", "\u0710\u072a\u0710\u0726\u0717\u071d\u072c" },
            { "ckb", "\u0729\u072a\u0715\u071d\u072c \u0729\u0722\u071b\u072a\u0718\u0722\u071d\u0710" },
            { "fon", "\u0726\u0718\u0722\u071d\u072c" },
            { "gaa", "\u0713\u0710\u071d\u072c" },
            { "mul", "\u0720\u072b\u0308\u0722\u0710 \u0726\u0716\u0308\u071d\u072b\u0710" },
            { "nds", "\u0710\u0720\u0721\u0722\u071d\u0710 \u0720\u0710\u0720\u072c\u071a\u072c" },
            { "pis", "\u0726\u071d\u0713\u071d\u0722\u071d\u072c" },
            { "sco", "\u0723\u071f\u0718\u072c\u0720\u0722\u0715\u0710\u071d\u072c" },
            { "syr", "\u0723\u0718\u072a\u071d\u071d\u0710" },
            { "und", "\u0720\u072b\u0722\u0710 \u0720\u0710 \u071d\u0715\u071d\u0725\u0710" },
            { "Arab", metaValue_ar },
            { "Armi", "\u0710\u072a\u0721\u071d\u0710" },
            { "Armn", metaValue_hy },
            { "Geor", "\u0713\u0718\u072a\u0713\u071d\u072c" },
            { "Grek", "\u071d\u0718\u0722\u071d\u072c" },
            { "Gujr", metaValue_gu },
            { "Hebr", "\u0725\u0712\u072a\u071d\u072c" },
            { "Syrc", "\u0723\u0718\u072a\u071d\u072c" },
            { "Zsye", "\u0710\u071d\u0721\u0718\u0713\u071d" },
            { "Zxxx", "\u0720\u071d\u072c \u071f\u072c\u071d\u0712\u0718\u072c\u0710" },
            { "Zzzz", "\u0720\u071d\u072c \u071b\u071f\u0723\u0710 \u0715\u071f\u072c\u071d\u0712\u072c\u0710" },
            { "nl_BE", "\u0726\u0720\u0721\u071d\u072b\u071d\u072c" },
            { "ar_001", "\u0725\u072a\u0712\u071d\u072c \u072a\u0718\u072b\u0721\u071d\u0710 \u071a\u0715\u072c\u0710" },
            { "key.ca", "\u0723\u0718\u072a\u0713\u0715\u0710" },
            { "key.cf", "\u071b\u0718\u0726\u0723\u0710 \u0715\u0719\u0718\u0308\u0719\u0710" },
            { "key.co", "\u071b\u071f\u0723\u0710 \u0715\u0726\u0718\u072a\u072b\u0722\u071d\u0710" },
            { "key.cu", "\u0719\u0718\u0308\u0719\u0710" },
            { "key.hc", "\u071b\u071f\u0742\u0723\u0710 \u0725\u0715\u0722\u0718\u072c\u0710 (12 \u0720\u0718\u0729\u0712\u0720 24)" },
            { "key.ms", "\u071b\u071f\u0723\u0710 \u0715\u071f\u071d\u0720\u072c\u0710" },
            { "key.nu", "\u0721\u0722\u071d\u0308\u0722\u0710" },
            { "nds_NL", "\u0717\u0718\u0720\u0722\u0715\u0710 \u0720\u0710\u0720\u072c\u071a\u072c" },
            { "zh_Hans", "\u0728\u071d\u0722\u071d\u072c (\u0726\u072b\u071d\u071b\u0710)" },
            { "zh_Hant", "\u0728\u071d\u0722\u0710\u071d\u072c" },
            { "type.ca.roc", "\u0723\u0718\u072a\u0713\u0715\u0710 \u0721\u071d\u0722\u0713\u0718" },
            { "type.hc.h11", "\u071b\u071f\u0742\u0723\u0710 12 \u072b\u0725\u072c\u0742\u0710 (0\u201311)" },
            { "type.hc.h12", "\u071b\u071f\u0742\u0723\u0710 12 \u072b\u0725\u072c\u0742\u0710 (1\u201312)" },
            { "type.hc.h23", metaValue_type_hc_h23 },
            { "type.hc.h24", metaValue_type_hc_h23 },
            { "type.nu.arab", "\u0721\u0722\u071d\u0308\u0722\u0710 \u0715\u0725\u0716\u0308\u0712\u071d\u0710 \u0717\u0722\u0715\u0718\u071d\u0710" },
            { "type.nu.armn", "\u0721\u0722\u071d\u0308\u0722\u0710 \u0715\u0710\u0716\u0308\u0721\u0722\u071d\u0710" },
            { "type.nu.ethi", "\u0721\u0722\u071d\u0308\u0722\u0710 \u071f\u0718\u072b\u071d\u0710" },
            { "type.nu.geor", "\u0721\u0722\u071d\u0308\u0722\u0710 \u0713\u0718\u072a\u0713\u071d\u0710" },
            { "type.nu.grek", "\u0721\u0722\u071d\u0308\u0722\u0710 \u0715\u071d\u0718\u0722\u071d\u0308\u0710" },
            { "type.nu.hebr", "\u0721\u0722\u071d\u0308\u0722\u0710 \u0715\u071d\u0717\u0718\u0715\u071d\u0308\u0710" },
            { "type.nu.jpan", "\u0721\u0722\u071d\u0308\u0722\u0710 \u0715\u071d\u0726\u0722\u071d\u0308\u0710" },
            { "type.nu.latn", "\u0721\u0722\u071d\u0308\u0722\u0710 \u0721\u0725\u072a\u0712\u071d\u0710" },
            { "type.nu.mong", "\u0721\u0722\u071d\u0308\u0722\u0710 \u0715\u0721\u0718\u0722\u0713\u0718\u0720\u0722\u071d\u0308\u0710" },
            { "type.ca.dangi", "\u0723\u0718\u072a\u0713\u0715\u0710 \u0715\u0722\u0713\u071d" },
            { "type.nu.roman", "\u0721\u0722\u071d\u0308\u0722\u0710 \u072a\u0717\u0718\u0721\u071d\u0710" },
            { "type.ca.coptic", "\u0723\u0718\u072a\u0713\u0715\u0710 \u0710\u0713\u0712\u071b\u071d\u0710" },
            { "type.ca.hebrew", "\u0723\u0718\u072a\u0713\u0715\u0710 \u071d\u0717\u0718\u0715\u071d\u0710" },
            { "type.ca.indian", "\u0723\u0718\u072a\u0713\u0715\u0710 \u0710\u0718\u0721\u072c\u0722\u071d\u0710 \u0717\u0722\u0715\u0718\u071d\u0710" },
            { "type.ms.metric", "\u071b\u071f\u0723\u0710 \u0721\u071d\u072c\u072a\u071d\u0710" },
            { "type.ca.chinese", "\u0723\u0718\u072a\u0713\u0715\u0710 \u0728\u071d\u0722\u071d\u0710" },
            { "type.ca.iso8601", "\u0723\u0718\u072a\u0713\u0715\u0710 ISO-8601" },
            { "type.ca.persian", "\u0723\u0718\u072a\u0713\u0715\u0710 \u0726\u072a\u0723\u071d\u0710" },
            { "type.cf.account", "\u071b\u0718\u0726\u0723\u0710 \u0715\u0719\u0718\u0308\u0719\u0710 \u0721\u071a\u072b\u0712\u0722\u0718\u072c\u071d\u0710" },
            { "type.ca.buddhist", "\u0723\u0718\u072a\u0713\u0715\u0710 \u0712\u0718\u0715\u0717\u071d\u071d\u0710" },
            { "type.ca.ethiopic", "\u0723\u0718\u072a\u0713\u0715\u0710 \u071f\u0718\u072b\u071d\u0710" },
            { "type.ca.japanese", "\u0723\u0718\u072a\u0713\u0715\u0710 \u071d\u0726\u0722\u071d\u0710" },
            { "type.cf.standard", "\u071b\u0718\u0726\u0723\u0710 \u0715\u0719\u0718\u0308\u0719\u0710 \u072b\u072a\u072b\u071d\u0710" },
            { "type.co.standard", "\u071b\u071f\u0742\u0723\u0710 \u0726\u0718\u072a\u072b\u0722\u071d\u0710 \u072b\u072a\u072b\u071d\u0710" },
            { "type.ms.uksystem", "\u071b\u071f\u0723\u0710 \u0715\u071f\u071d\u0720\u072c\u0710 \u0712\u072a\u071d\u071b\u0722\u071d\u071d\u0710" },
            { "type.ms.ussystem", "\u071b\u071f\u0723\u0710 \u0715\u071f\u071d\u0720\u072c\u0710 \u0710\u0721\u072a\u071d\u071f\u071d\u0710" },
            { "type.ca.gregorian", "\u0723\u0718\u072a\u0713\u0715\u0710 \u0713\u072a\u071d\u0713\u0718\u072a\u071d\u0710" },
            { "type.co.phonebook", "\u071f\u072c\u0712\u0710 \u0715\u0721\u0722\u071d\u0308\u0722\u0710 \u0715\u072c\u071d\u0720\u071d\u0726\u0718\u0722" },
            { "type.co.dictionary", "\u071b\u071f\u0742\u0723\u0710 \u0726\u0718\u072a\u072b\u0722\u071d\u0710 \u0715\u0720\u071f\u0723\u071d\u0729\u0718\u0722" },
            { "type.co.traditional", "\u071b\u071f\u0742\u0723\u0710 \u0726\u0718\u072a\u072b\u0722\u071d\u0710 \u0725\u071d\u0715\u0742\u071d\u0710" },
            { "ListCompositionPattern", "{0}\u060c {1}" },
        };
        return data;
    }
}
