/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_it extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Ora del meridiano di Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Ora standard di Apia",
               "",
               "Ora legale di Apia",
               "",
               "Ora di Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Ora standard delle isole Cook",
               "",
               "Ora legale media delle isole Cook",
               "",
               "Ora delle isole Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Ora standard di Cuba",
               "CST",
               "Ora legale di Cuba",
               "CDT",
               "Ora di Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Ora standard delle Figi",
               "",
               "Ora legale delle Figi",
               "",
               "Ora delle Figi",
               "",
            };
        final String[] Gulf = new String[] {
               "Ora del Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Ora standard di Hovd",
               "",
               "Ora legale di Hovd",
               "",
               "Ora di Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Ora standard dell\u2019Iran",
               "",
               "Ora legale dell\u2019Iran",
               "",
               "Ora dell\u2019Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Ora di Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Ora standard di Omsk",
               "",
               "Ora legale di Omsk",
               "",
               "Ora di Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Ora standard del Per\u00f9",
               "",
               "Ora legale del Per\u00f9",
               "",
               "Ora del Per\u00f9",
               "",
            };
        final String[] Truk = new String[] {
               "Ora del Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Ora dell\u2019Isola di Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Ora standard del Cile",
               "",
               "Ora legale del Cile",
               "",
               "Ora del Cile",
               "",
            };
        final String[] China = new String[] {
               "Ora standard della Cina",
               "CST",
               "Ora legale della Cina",
               "CDT",
               "Ora della Cina",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Ora delle Isole Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Ora di Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Ora standard dell\u2019India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Ora standard del Giappone",
               "JST",
               "Ora legale del Giappone",
               "JDT",
               "Ora del Giappone",
               "JT",
            };
        final String[] Korea = new String[] {
               "Ora standard coreana",
               "KST",
               "Ora legale coreana",
               "KST",
               "Ora coreana",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Ora di Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Ora del Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Ora di Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Ora standard di Samoa",
               "SST",
               "Ora legale di Samoa",
               "SST",
               "Ora di Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Ora di Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Ora standard di Tonga",
               "",
               "Ora legale di Tonga",
               "",
               "Ora di Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Ora dello Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Ora standard dell\u2019Alaska",
               "AKST",
               "Ora legale dell\u2019Alaska",
               "AKDT",
               "Ora dell\u2019Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Ora standard dell\u2019Amazzonia",
               "",
               "Ora legale dell\u2019Amazzonia",
               "",
               "Ora dell\u2019Amazzonia",
               "",
            };
        final String[] Anadyr = new String[] {
               "Ora standard di Anadyr",
               "",
               "Ora legale di Anadyr",
               "",
               "Ora di Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Ora standard delle Azzorre",
               "",
               "Ora legale delle Azzorre",
               "",
               "Ora delle Azzorre",
               "",
            };
        final String[] Bhutan = new String[] {
               "Ora del Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Ora del Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ora standard dell\u2019Isola di Pasqua",
               "",
               "Ora legale dell\u2019Isola di Pasqua",
               "",
               "Ora dell\u2019Isola di Pasqua",
               "",
            };
        final String[] Guyana = new String[] {
               "Ora della Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Ora standard di Israele",
               "IST",
               "Ora legale di Israele",
               "IDT",
               "Ora di Israele",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Ora del Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Ora di Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Ora standard di Mosca",
               "MSK",
               "Ora legale di Mosca",
               "MSK",
               "Ora di Mosca",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ora di Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Ora standard di Samara",
               "",
               "Ora legale di Samara",
               "",
               "Ora di Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Ora di Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Ora standard di Taipei",
               "CST",
               "Ora legale di Taipei",
               "CDT",
               "Ora di Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Ora di Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Ora di Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Ora di Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ora standard araba",
               "",
               "Ora legale araba",
               "",
               "Ora araba",
               "",
            };
        final String[] Armenia = new String[] {
               "Ora standard dell\u2019Armenia",
               "",
               "Ora legale dell\u2019Armenia",
               "",
               "Ora dell\u2019Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Ora della Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Ora standard delle Chatham",
               "",
               "Ora legale delle Chatham",
               "",
               "Ora delle Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Tempo coordinato universale",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ora dell\u2019Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Ora di Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Ora standard della Georgia",
               "",
               "Ora legale della Georgia",
               "",
               "Ora della Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Ora standard di Irkutsk",
               "",
               "Ora legale di Irkutsk",
               "",
               "Ora di Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Ora standard di Magadan",
               "",
               "Ora legale di Magadan",
               "",
               "Ora di Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Ora della Birmania",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Ora standard delle Isole Norfolk",
               "",
               "Ora legale delle Isole Norfolk",
               "",
               "Ora delle Isole Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Ora standard di Fernando de Noronha",
               "",
               "Ora legale di Fernando de Noronha",
               "",
               "Ora di Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Ora di Riunione",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Ora di Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Ora delle Isole Salomone",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Ora di Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Ora standard dell\u2019Uruguay",
               "",
               "Ora legale dell\u2019Uruguay",
               "",
               "Ora dell\u2019Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Ora standard del Vanuatu",
               "",
               "Ora legale del Vanuatu",
               "",
               "Ora del Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Ora standard di Yakutsk",
               "",
               "Ora legale di Yakutsk",
               "",
               "Ora di Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Ora standard dell\u2019Atlantico",
               "AST",
               "Ora legale dell\u2019Atlantico",
               "AST",
               "Ora dell\u2019Atlantico",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Ora standard di Brasilia",
               "",
               "Ora legale di Brasilia",
               "",
               "Ora di Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Ora di Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Ora standard della Colombia",
               "",
               "Ora legale della Colombia",
               "",
               "Ora della Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Ora standard delle Isole Falkland",
               "",
               "Ora legale delle Isole Falkland",
               "",
               "Ora delle Isole Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Ora della Malesia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Ora delle Maldive",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ora standard di Ulan Bator",
               "",
               "Ora legale di Ulan Bator",
               "",
               "Ora di Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Ora standard del Pakistan",
               "PKT",
               "Ora legale del Pakistan",
               "PKST",
               "Ora del Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Ora standard del Paraguay",
               "",
               "Ora legale del Paraguay",
               "",
               "Ora del Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Ora delle Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Ora standard di Sakhalin",
               "",
               "Ora legale di Sakhalin",
               "",
               "Ora di Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Ora del Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Ora standard dell\u2019Argentina",
               "",
               "Ora legale dell\u2019Argentina",
               "",
               "Ora dell\u2019Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Ora dell\u2019Isola Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Ora delle Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Ora standard di Hong Kong",
               "HKT",
               "Ora legale di Hong Kong",
               "HKST",
               "Ora di Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Ora dell\u2019Indocina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Ora standard di Petropavlovsk-Kamchatski",
               "",
               "Ora legale di Petropavlovsk-Kamchatski",
               "",
               "Ora di Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Ora del Kirghizistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Ora standard di Lord Howe",
               "",
               "Ora legale di Lord Howe",
               "",
               "Ora di Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Ora delle Marchesi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Ora standard delle Mauritius",
               "",
               "Ora legale delle Mauritius",
               "",
               "Ora delle Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Ora di Singapore",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Ora del Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Ora standard di Volgograd",
               "MSK",
               "Ora legale di Volgograd",
               "MSK",
               "Ora di Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Ora standard dell\u2019Azerbaigian",
               "",
               "Ora legale dell\u2019Azerbaigian",
               "",
               "Ora dell\u2019Azerbaigian",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Ora standard del Bangladesh",
               "",
               "Ora legale del Bangladesh",
               "",
               "Ora del Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Ora standard di Capo Verde",
               "",
               "Ora legale di Capo Verde",
               "",
               "Ora di Capo Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Ora di Timor Est",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Ora del Kazakistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Ora delle Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Ora del Tagikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Ora standard dell\u2019Uzbekistan",
               "",
               "Ora legale dell\u2019Uzbekistan",
               "",
               "Ora dell\u2019Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Ora dell\u2019Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Ora standard di Krasnoyarsk",
               "",
               "Ora legale di Krasnoyarsk",
               "",
               "Ora di Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Ora standard della Nuova Zelanda",
               "NZST",
               "Ora legale della Nuova Zelanda",
               "NZDT",
               "Ora della Nuova Zelanda",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Ora standard di Novosibirsk",
               "",
               "Ora legale di Novosibirsk",
               "",
               "Ora di Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Ora standard delle Filippine",
               "PST",
               "Ora legale delle Filippine",
               "PDT",
               "Ora delle Filippine",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Ora standard di Vladivostok",
               "",
               "Ora legale di Vladivostok",
               "",
               "Ora di Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Ora dell\u2019Oceano Indiano",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Ora delle Sporadi equatoriali",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Ora standard di Terranova",
               "NST",
               "Ora legale di Terranova",
               "NDT",
               "Ora di Terranova",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Ora standard del Turkmenistan",
               "",
               "Ora legale del Turkmenistan",
               "",
               "Ora del Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Ora della Guiana francese",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Ora standard della Nuova Caledonia",
               "",
               "Ora legale della Nuova Caledonia",
               "",
               "Ora della Nuova Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Ora della Georgia del Sud",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Ora standard di Ekaterinburg",
               "",
               "Ora legale di Ekaterinburg",
               "",
               "Ora di Ekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Ora dell\u2019Africa centrale",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ora dell\u2019Africa orientale",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Ora standard dell\u2019Africa occidentale",
               "WAT",
               "Ora legale dell\u2019Africa occidentale",
               "WAT",
               "Ora dell\u2019Africa occidentale",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Ora di Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Ora standard dell\u2019Europa centrale",
               "CET",
               "Ora legale dell\u2019Europa centrale",
               "CEST",
               "Ora dell\u2019Europa centrale",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Ora standard dell\u2019Europa orientale",
               "EET",
               "Ora legale dell\u2019Europa orientale",
               "EEST",
               "Ora dell\u2019Europa orientale",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Ora standard dell\u2019Europa occidentale",
               "WET",
               "Ora legale dell\u2019Europa occidentale",
               "WEST",
               "Ora dell\u2019Europa occidentale",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Ora standard del Pacifico (Messico)",
               "MST",
               "Ora legale del Pacifico (Messico)",
               "MDT",
               "Ora del Pacifico (Messico)",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Ora dell\u2019Africa meridionale",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Ora standard centrale USA",
               "CST",
               "Ora legale centrale USA",
               "CDT",
               "Ora centrale USA",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Ora standard orientale USA",
               "EST",
               "Ora legale orientale USA",
               "EST",
               "Ora orientale USA",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Ora standard del Pacifico USA",
               "PST",
               "Ora legale del Pacifico USA",
               "PDT",
               "Ora del Pacifico USA",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Ora delle Terre australi e antartiche francesi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Ora delle isole Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Ora standard delle Isole Hawaii-Aleutine",
               "HST",
               "Ora legale delle Isole Hawaii-Aleutine",
               "HST",
               "Ora delle isole Hawaii-Aleutine",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Ora delle Isole della Fenice",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Ora standard di Saint-Pierre e Miquelon",
               "",
               "Ora legale di Saint-Pierre e Miquelon",
               "",
               "Ora di Saint-Pierre e Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Ora standard Montagne Rocciose USA",
               "MST",
               "Ora legale Montagne Rocciose USA",
               "MST",
               "Ora Montagne Rocciose USA",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Ora delle Isole Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Ora della Papua Nuova Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Ora standard dell\u2019Australia centrale",
               "ACST",
               "Ora legale dell\u2019Australia centrale",
               "ACDT",
               "Ora dell\u2019Australia centrale",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ora standard dell\u2019Australia orientale",
               "AEST",
               "Ora legale dell\u2019Australia orientale",
               "AEDT",
               "Ora dell\u2019Australia orientale",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Ora standard dell\u2019Australia occidentale",
               "AWST",
               "Ora legale dell\u2019Australia occidentale",
               "AWDT",
               "Ora dell\u2019Australia occidentale",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Ora dell\u2019Indonesia centrale",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ora dell\u2019Indonesia orientale",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Ora dell\u2019Indonesia occidentale",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Ora standard dell\u2019Australia centroccidentale",
               "",
               "Ora legale dell\u2019Australia centroccidentale",
               "",
               "Ora dell\u2019Australia centroccidentale",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Ora del meridiano di Greenwich",
                    "GMT",
                    "Ora legale del Regno Unito",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Tempo coordinato universale",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Ora del meridiano di Greenwich",
                    "GMT",
                    "Ora legale dell\u2019Irlanda",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Tempo coordinato universale",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Tempo coordinato universale",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Ora del meridiano di Greenwich",
                    "GMT",
                    "Ora legale del Regno Unito",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Tempo coordinato universale",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Tempo coordinato universale",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Tempo coordinato universale",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Ora del meridiano di Greenwich",
                    "GMT",
                    "Ora legale dell\u2019Irlanda",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Ora del meridiano di Greenwich",
                    "GMT",
                    "Ora legale del Regno Unito",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Ora del meridiano di Greenwich",
                    "GMT",
                    "Ora legale del Regno Unito",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Ora del meridiano di Greenwich",
                    "GMT",
                    "Ora legale del Regno Unito",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Ora del meridiano di Greenwich",
                    "GMT",
                    "Ora legale del Regno Unito",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Ora del meridiano di Greenwich",
                    "GMT",
                    "Ora legale del Regno Unito",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "timezone.excity.Asia/Dhaka", "Dacca" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Giuba" },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Anadyr", "Anadyr\u2019" },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riyad" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Citt\u00e0 sconosciuta" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Il Cairo" },
            { "timezone.excity.Africa/Tunis", "Tunisi" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Jakarta", "Giacarta" },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Europe/Paris", "Parigi" },
            { "timezone.excity.Pacific/Fiji", "Figi" },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "timezone.excity.Asia/Khandyga", "Chandyga" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Ust-Nera", "Ust\u2019-Nera" },
            { "timezone.excity.Europe/Athens", "Atene" },
            { "timezone.excity.Europe/Berlin", "Berlino" },
            { "timezone.excity.Europe/Dublin", "Dublino" },
            { "timezone.excity.Europe/Lisbon", "Lisbona" },
            { "timezone.excity.Europe/London", "Londra" },
            { "timezone.excity.Europe/Moscow", "Mosca" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Warsaw", "Varsavia" },
            { "timezone.excity.Europe/Zagreb", "Zagabria" },
            { "timezone.excity.Europe/Zurich", "Zurigo" },
            { "timezone.excity.Indian/Comoro", "Comore" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Algeri" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Havana", "L\u2019Avana" },
            { "timezone.excity.Asia/Famagusta", "Famagosta" },
            { "timezone.excity.Asia/Jerusalem", "Gerusalemme" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Europe/Vatican", "Citt\u00e0 del Vaticano" },
            { "timezone.excity.Indian/Reunion", "La Riunione" },
            { "timezone.excity.Pacific/Easter", "Pasqua" },
            { "timezone.excity.Pacific/Kanton", "Canton" },
            { "timezone.excity.Africa/Djibouti", "Gibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Ayun" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Cayenne", "Caienna" },
            { "timezone.excity.America/Jamaica", "Giamaica" },
            { "timezone.excity.Atlantic/Azores", "Azzorre" },
            { "timezone.excity.Atlantic/Canary", "Canarie" },
            { "timezone.excity.Atlantic/Faeroe", "Isole F\u00e6r \u00d8er" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Bruxelles" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Indian/Maldives", "Maldive" },
            { "timezone.excity.Africa/Mogadishu", "Mogadiscio" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/St_Lucia", "Santa Lucia" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Europe/Bucharest", "Bucarest" },
            { "timezone.excity.Europe/Gibraltar", "Gibilterra" },
            { "timezone.excity.Europe/Ljubljana", "Lubiana" },
            { "timezone.excity.Europe/Stockholm", "Stoccolma" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Sao_Paulo", "San Paolo" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuzneck" },
            { "timezone.excity.Europe/Copenhagen", "Copenaghen" },
            { "timezone.excity.Europe/Luxembourg", "Lussemburgo" },
            { "timezone.excity.Europe/Simferopol", "Sinferopoli" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Marquesas", "Marchesi" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/Guadeloupe", "Guadalupa" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/St_Vincent", "Saint Vincent" },
            { "timezone.excity.Asia/Yekaterinburg", "Ekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Sant\u2019Elena" },
            { "timezone.excity.Europe/Isle_of_Man", "Isola di Man" },
            { "timezone.excity.America/Mexico_City", "Citt\u00e0 del Messico" },
            { "timezone.excity.America/Puerto_Rico", "Portorico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Capo Verde" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia del Sud" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota del nord" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota del nord" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota del nord" },
        };
        return data;
    }
}
