/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_dsb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwichski cas",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apiaski standardny cas",
               "",
               "Apiaski l\u011b\u015bojski cas",
               "",
               "Apiaski cas",
               "",
            };
        final String[] Cook = new String[] {
               "Standardny cas Cookowych kupow",
               "",
               "l\u011b\u015bojski cas Cookowych kupow",
               "",
               "cas Cookowych kupow",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba\u0144ski standardny cas",
               "CST",
               "Kuba\u0144ski l\u011b\u015bojski cas",
               "CDT",
               "Kuba\u0144ski cas",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fid\u017aiski standardny cas",
               "",
               "Fid\u017aiski l\u011b\u015bojski cas",
               "",
               "Fid\u017aiski cas",
               "",
            };
        final String[] Gulf = new String[] {
               "cas Persiskego golfa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Chowdski standardny cas",
               "",
               "Chowdski l\u011b\u015bojski cas",
               "",
               "Chowdski cas",
               "",
            };
        final String[] Iran = new String[] {
               "Ira\u0144ski standardny cas",
               "",
               "Ira\u0144ski l\u011b\u015bojski cas",
               "",
               "Ira\u0144ski cas",
               "",
            };
        final String[] Niue = new String[] {
               "Niueski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omski standardny cas",
               "",
               "Omski l\u011b\u015bojski cas",
               "",
               "Omski cas",
               "",
            };
        final String[] Peru = new String[] {
               "Peruski standardny cas",
               "",
               "Peruski l\u011b\u015bojski cas",
               "",
               "Peruski cas",
               "",
            };
        final String[] Truk = new String[] {
               "Chuukski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "cas kupy Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chilski standardny cas",
               "",
               "Chilski l\u011b\u015bojski cas",
               "",
               "Chilski cas",
               "",
            };
        final String[] China = new String[] {
               "Chinski standardny cas",
               "CST",
               "Chinski l\u011b\u015bojski cas",
               "CDT",
               "Chinski cas",
               "CT",
            };
        final String[] Cocos = new String[] {
               "cas Kokosowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indiski cas",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japa\u0144ski standardny cas",
               "JST",
               "Japa\u0144ski l\u011b\u015bojski cas",
               "JDT",
               "Japa\u0144ski cas",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korejski standardny cas",
               "KST",
               "Korejski l\u011b\u015bojski cas",
               "KST",
               "Korejski cas",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauruski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palauski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoaski standardny cas",
               "SST",
               "Samoaski l\u011b\u015bojski cas",
               "SST",
               "Samoaski cas",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tongaski standardny cas",
               "",
               "Tongaski l\u011b\u015bojski cas",
               "",
               "Tongaski cas",
               "",
            };
        final String[] Yukon = new String[] {
               "Yukonowy cas",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Alaskojski standardny cas",
               "AKST",
               "Alaskojski l\u011b\u015bojski cas",
               "AKDT",
               "Alaskojski cas",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amaconaski standardny cas",
               "",
               "Amaconaski l\u011b\u015bojski cas",
               "",
               "Amaconaski cas",
               "",
            };
        final String[] Azores = new String[] {
               "Acorski standardny cas",
               "",
               "Acorski l\u011b\u015bojski cas",
               "",
               "Acorski cas",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhuta\u0144ski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Bruneiski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "standardny cas Jat\u0161owneje kupy",
               "",
               "l\u011b\u015bojski cas Jat\u0161owneje kupy",
               "",
               "cas Jat\u0161owneje kupy",
               "",
            };
        final String[] Guyana = new String[] {
               "Guya\u0144ski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israelski standardny cas",
               "IST",
               "Israelski l\u011b\u015bojski cas",
               "IDT",
               "Israelski cas",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosraeski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskowski standardny cas",
               "MSK",
               "Moskowski l\u011b\u015bojski cas",
               "MSK",
               "Moskowski cas",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponapski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahitiski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Tchajpejski standardny cas",
               "CST",
               "Tchajpejski l\u011b\u015bojski cas",
               "CDT",
               "Tchajpejski cas",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "cas Wostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "cas kupow Wallis a Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabiski standardny cas",
               "",
               "Arabiski l\u011b\u015bojski cas",
               "",
               "Arabiski cas",
               "",
            };
        final String[] Armenia = new String[] {
               "Arme\u0144ski standardny cas",
               "",
               "Arme\u0144ski l\u011b\u015bojski cas",
               "",
               "Arme\u0144ski cas",
               "",
            };
        final String[] Bolivia = new String[] {
               "Boliwiski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chathamski standardny cas",
               "",
               "Chathamski l\u011b\u015bojski cas",
               "",
               "Chathamski cas",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordin\u011browany sw\u011btowy cas",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekuadorski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambierski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgiski standardny cas",
               "",
               "Georgiski l\u011b\u015bojski cas",
               "",
               "Georgiski cas",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutski standardny cas",
               "",
               "Irkutski l\u011b\u015bojski cas",
               "",
               "Irkutski cas",
               "",
            };
        final String[] Magadan = new String[] {
               "Magada\u0144ski standardny cas",
               "",
               "Magada\u0144ski l\u011b\u015bojski cas",
               "",
               "Magada\u0144ski cas",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmarski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "standardny cas kupy Norfolk",
               "",
               "l\u011b\u015bojski cas kupy Norfolk",
               "",
               "cas kupy Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "standardny cas Fernando de Noronha",
               "",
               "l\u011b\u015bojski cas Fernando de Noronha",
               "",
               "cas Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Reunionski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "cas Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomo\u0144ski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelauski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguayski standardny cas",
               "",
               "Uruguayski l\u011b\u015bojski cas",
               "",
               "Uruguayski cas",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatski standardny cas",
               "",
               "Vanuatski l\u011b\u015bojski cas",
               "",
               "Vanuatski cas",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutski standardny cas",
               "",
               "Jakutski l\u011b\u015bojski cas",
               "",
               "Jakutski cas",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantiski standardny cas",
               "AST",
               "Atlantiski l\u011b\u015bojski cas",
               "AST",
               "Atlantiski cas",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Bras\u00edlia standardny cas",
               "",
               "Bras\u00edlia l\u011b\u015bojski cas",
               "",
               "Bras\u00edlia cas",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorrski cas",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbiski standardny cas",
               "",
               "Kolumbiski l\u011b\u015bojski cas",
               "",
               "Kolumbiski cas",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandski standardny cas",
               "",
               "Falklandski l\u011b\u015bojski cas",
               "",
               "Falklandski cas",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malajziski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Malediwski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan-Batorski standardny cas",
               "",
               "Ulan-Batorski l\u011b\u015bojski cas",
               "",
               "Ulan-Batorski cas",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakista\u0144ski standardny cas",
               "PKT",
               "Pakista\u0144ski l\u011b\u015bojski cas",
               "PKST",
               "Pakista\u0144ski cas",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayski standardny cas",
               "",
               "Paraguayski l\u011b\u015bojski cas",
               "",
               "Paraguayski cas",
               "",
            };
        final String[] Pitcairn = new String[] {
               "cas Pitcairnowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sachalinski standardny cas",
               "",
               "Sachalinski l\u011b\u015bojski cas",
               "",
               "Sachalinski cas",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinamski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentinski standardny cas",
               "",
               "Argentinski l\u011b\u015bojski cas",
               "",
               "Argentinski cas",
               "",
            };
        final String[] Christmas = new String[] {
               "cas G\u00f3downych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagoski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hongkongski standardny cas",
               "HKT",
               "Hongkongski l\u011b\u015bojski cas",
               "HKST",
               "Hongkongski cas",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indochinski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgiski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Standardny cas kupy Lord-Howe",
               "",
               "l\u011b\u015bojski cas kupy Lord-Howe",
               "",
               "cas kupy Lord-Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marqueski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauriciski standardny cas",
               "",
               "Mauriciski l\u011b\u015bojski cas",
               "",
               "Mauriciski cas",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapurski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuelski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Wolgogradski standardny cas",
               "MSK",
               "Wolgogradski l\u011b\u015bojski cas",
               "MSK",
               "Wolgogradski cas",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Azerbajd\u017eaniski standardny cas",
               "",
               "Azerbajd\u017eaniski l\u011b\u015bojski cas",
               "",
               "Azerbajd\u017eaniski cas",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Banglade\u0161ski standardny cas",
               "",
               "Banglade\u0161ski l\u011b\u015bojski cas",
               "",
               "Banglade\u0161ski cas",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kapverdski standardny cas",
               "",
               "Kapverdski l\u011b\u015bojski cas",
               "",
               "Kapverdski cas",
               "",
            };
        final String[] East_Timor = new String[] {
               "P\u00f3dzajt\u0161notimorski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "kazachiski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychelski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tad\u017aikiski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Uzbekiski standardny cas",
               "",
               "Uzbekiski l\u011b\u015bojski cas",
               "",
               "Uzbekiski cas",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghaniski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarski standardny cas",
               "",
               "Krasnojarski l\u011b\u015bojski cas",
               "",
               "Krasnojarski cas",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Nowoseelandski standardny cas",
               "NZST",
               "Nowoseelandski l\u011b\u015bojski cas",
               "NZDT",
               "Nowoseelandski cas",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Nowosibirski standardny cas",
               "",
               "Nowosibirski l\u011b\u015bojski cas",
               "",
               "Nowosibirski cas",
               "",
            };
        final String[] Philippines = new String[] {
               "Filipinski standardny cas",
               "PST",
               "Filipinski l\u011b\u015bojski cas",
               "PDT",
               "Filipinski cas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostokski standardny cas",
               "",
               "Wladiwostokski l\u011b\u015bojski cas",
               "",
               "Wladiwostokski cas",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indiskooceaniski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "cas Linijowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Nowofundlandski standardny cas",
               "NST",
               "Nowofundlandski l\u011b\u015bojski cas",
               "NDT",
               "Nowofundlandski cas",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmeniski standardny cas",
               "",
               "Turkmeniski l\u011b\u015bojski cas",
               "",
               "Turkmeniski cas",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Francojskoguya\u0144ski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Nowokaledoniski standardny cas",
               "",
               "Nowokaledoniski l\u011b\u015bojski cas",
               "",
               "Nowokaledoniski cas",
               "",
            };
        final String[] South_Georgia = new String[] {
               "P\u00f3dpo\u0142dnjowogeorgiski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburgski standardny cas",
               "",
               "Jekaterinburgski l\u011b\u015bojski cas",
               "",
               "Jekaterinburgski cas",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Srjej\u017aoafriski cas",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "P\u00f3dzajt\u0161noafriski cas",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "P\u00f3dwjacornoafriski standardny cas",
               "WAT",
               "P\u00f3dwjacornoafriski l\u011b\u015bojski cas",
               "WAT",
               "P\u00f3dwjacornoafriski cas",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "DumontDUrville cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Srjej\u017anoeuropejski standardny cas",
               "MEZ",
               "Srjej\u017anoeuropejski l\u011b\u015bojski cas",
               "MESZ",
               "Srjej\u017anoeuropejski cas",
               "MEZ",
            };
        final String[] Europe_Eastern = new String[] {
               "P\u00f3dzajt\u0161noeuropejski standardny cas",
               "OEZ",
               "P\u00f3dzajt\u0161noeuropejski l\u011b\u015bojski cas",
               "OESZ",
               "P\u00f3dzajt\u0161noeuropejski cas",
               "OEZ",
            };
        final String[] Europe_Western = new String[] {
               "P\u00f3dwjacornoeuropejski standardny cas",
               "WEZ",
               "P\u00f3dwjacornoeuropejski l\u011b\u015bojski cas",
               "WESZ",
               "P\u00f3dwjacornoeuropejski cas",
               "WEZ",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexiski pacifiski standardny cas",
               "MST",
               "Mexiski pacifiski l\u011b\u015bojski cas",
               "MDT",
               "Mexiski pacifiski cas",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "P\u00f3dpo\u0142dnjowoafriski cas",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "P\u00f3dpo\u0142nocnoameriski centralny standardny cas",
               "CST",
               "P\u00f3dpo\u0142nocnoameriski centralny l\u011b\u015bojski cas",
               "CDT",
               "P\u00f3dpo\u0142nocnoameriski centralny cas",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "P\u00f3dpo\u0142nocnoameriski p\u00f3dzajt\u0161ny standardny cas",
               "EST",
               "P\u00f3dpo\u0142nocnoameriski p\u00f3dzajt\u0161ny l\u011b\u015bojski cas",
               "EST",
               "P\u00f3dpo\u0142nocnoameriski p\u00f3dzajt\u0161ny cas",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "P\u00f3dpo\u0142nocnoameriski pacifiski standardny cas",
               "PST",
               "P\u00f3dpo\u0142nocnoameriski pacifiski l\u011b\u015bojski cas",
               "PDT",
               "P\u00f3dpo\u0142nocnoameriski pacifiski cas",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "cas francojskego p\u00f3dpo\u0142dnjowego a antarktiskeho teritoriuma",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "cas Gilbertowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaiisko-aleutski standardny cas",
               "HST",
               "Hawaiisko-aleutski l\u011b\u015bojski cas",
               "HST",
               "Hawaiisko-aleutski cas",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "cas Phoenixowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St.-Pierre-a-Miquelo\u0144ski standardny cas",
               "",
               "St.-Pierre-a-Miquelo\u0144ski l\u011b\u015bojski cas",
               "",
               "St.-Pierre-a-Miquelo\u0144ski cas",
               "",
            };
        final String[] America_Mountain = new String[] {
               "P\u00f3dpo\u0142nocnoameriski g\u00f3rski standardny cas",
               "MST",
               "P\u00f3dpo\u0142nocnoameriski g\u00f3rski l\u011b\u015bojski cas",
               "MST",
               "P\u00f3dpo\u0142nocnoameriski g\u00f3rski cas",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "cas Marshallowych kupow",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Nowoginejski cas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Srjej\u017aoawstralski standardny cas",
               "ACST",
               "Srjej\u017aoawstralski l\u011b\u015bojski cas",
               "ACDT",
               "Srjej\u017aoawstralski cas",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "P\u00f3dzajt\u0161noawstralski standardny cas",
               "AEST",
               "P\u00f3dzajt\u0161noawstralski l\u011b\u015bojski cas",
               "AEDT",
               "P\u00f3dzajt\u0161noawstralski cas",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "P\u00f3dwjacornoawstralski standardny cas",
               "AWST",
               "P\u00f3dwjacornoawstralski l\u011b\u015bojski cas",
               "AWDT",
               "P\u00f3dwjacornoawstralski cas",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Srjej\u017aoindoneski cas",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "P\u00f3dzajt\u0161noindoneski",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "P\u00f3dwjacornoindoneski cas",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Srjej\u017aop\u00f3dwjacorny awstralski standardny cas",
               "",
               "Srjej\u017aop\u00f3dwjacorny awstralski l\u011b\u015bojski cas",
               "",
               "Srjej\u017aop\u00f3dwjacorny awstralski cas",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwichski cas",
                    "GMT",
                    "Britiski l\u011b\u015bojski cas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "koordin\u011browany sw\u011btowy cas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwichski cas",
                    "GMT",
                    "Iriski l\u011b\u015bojski cas",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "koordin\u011browany sw\u011btowy cas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "koordin\u011browany sw\u011btowy cas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwichski cas",
                    "GMT",
                    "Britiski l\u011b\u015bojski cas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "koordin\u011browany sw\u011btowy cas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "koordin\u011browany sw\u011btowy cas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "koordin\u011browany sw\u011btowy cas",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwichski cas",
                    "GMT",
                    "Iriski l\u011b\u015bojski cas",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwichski cas",
                    "GMT",
                    "Britiski l\u011b\u015bojski cas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwichski cas",
                    "GMT",
                    "Britiski l\u011b\u015bojski cas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwichski cas",
                    "GMT",
                    "Britiski l\u011b\u015bojski cas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwichski cas",
                    "GMT",
                    "Britiski l\u011b\u015bojski cas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwichski cas",
                    "GMT",
                    "Britiski l\u011b\u015bojski cas",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Saigon", "Ho-Chi-Minh-m\u011bsto" },
            { "timezone.excity.Asia/Taipei", "Taipeh" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Njeznate" },
            { "timezone.excity.Europe/Kiev", "Kiew" },
            { "timezone.excity.Europe/Rome", "Rom" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Akkra" },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Karachi", "Kara\u010di" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerewan" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Jayapura", "Port Numbay" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.Europe/Athens", "Athen" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/Moscow", "Moskwa" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "timezone.excity.Europe/Warsaw", "War\u0161awa" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Comoro", "Komory" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Algier" },
            { "timezone.excity.Africa/Tripoli", "Tripolis" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Kaimaniske kupy" },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "timezone.excity.Asia/Pyongyang", "Pj\u00f6ngjang" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Europe/Vilnius", "Wilna" },
            { "timezone.excity.Pacific/Easter", "Jat\u0161owne kupy" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Atlantic/Azores", "Acory" },
            { "timezone.excity.Atlantic/Canary", "Kanary" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e4r\u00f6je" },
            { "timezone.excity.Europe/Belgrade", "B\u011b\u0142ogrod" },
            { "timezone.excity.Europe/Brussels", "Br\u00fcssel" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161inau" },
            { "timezone.excity.Indian/Maldives", "Malediwy" },
            { "timezone.excity.Africa/Mogadishu", "Mogadi\u0161u" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Nowosibirsk" },
            { "timezone.excity.Asia/Vladivostok", "Wladiwostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudy" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Indian/Christmas", "G\u00f3downe kupy" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.Antarctica/Vostok", "Wostok" },
            { "timezone.excity.Asia/Novokuznetsk", "Nowokuznjetsk" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Ouagadougou", "Wagadugu" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.America/Mexico_City", "Mexiko-m\u011bsto" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Daressalam" },
            { "timezone.excity.America/Port_of_Spain", "Port-of-Spain" },
            { "timezone.excity.America/St_Barthelemy", "St.Barth\u00e9lemy" },
            { "timezone.excity.Atlantic/South_Georgia", "P\u00f3dpo\u0142dnjowa Georgiska" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dumont D\u2019Urville" },
        };
        return data;
    }
}
