/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_km extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "អាស៊ែបៃហ្សង់";
        final String metaValue_BY = "បេឡារុស";
        final String metaValue_BG = "ប៊ុលហ្ការី";
        final String metaValue_BD = "បង់ក្លាដែស";
        final String metaValue_CZ = "ឆែក";
        final String metaValue_DK = "ដាណឺម៉ាក";
        final String metaValue_DE = "អាល្លឺម៉ង់";
        final String metaValue_GR = "ក្រិក";
        final String metaValue_ES = "អេស្ប៉ាញ";
        final String metaValue_EE = "អេស្តូនី";
        final String metaValue_FI = "ហ្វាំងឡង់";
        final String metaValue_FR = "បារាំង";
        final String metaValue_IE = "អៀរឡង់";
        final String metaValue_HT = "ហៃទី";
        final String metaValue_HU = "ហុងគ្រី";
        final String metaValue_AM = "អាមេនី";
        final String metaValue_ID = "ឥណ្ឌូណេស៊ី";
        final String metaValue_IS = "អ៊ីស្លង់";
        final String metaValue_IT = "អ៊ីតាលី";
        final String metaValue_JP = "ជប៉ុន";
        final String metaValue_LU = "លុចសំបួ";
        final String metaValue_LA = "ឡាវ";
        final String metaValue_LT = "លីទុយអានី";
        final String metaValue_MN = "ម៉ុងហ្គោលី";
        final String metaValue_NR = "ណូរូ";
        final String metaValue_NP = "នេប៉ាល់";
        final String metaValue_NL = "ហូឡង់";
        final String metaValue_NO = "ន័រវែស";
        final String metaValue_PL = "ប៉ូឡូញ";
        final String metaValue_RO = "រូម៉ានី";
        final String metaValue_RU = "រុស្ស៊ី";
        final String metaValue_LK = "ស្រីលង្កា";
        final String metaValue_SK = "ស្លូវ៉ាគី";
        final String metaValue_WS = "សាម័រ";
        final String metaValue_SO = "សូម៉ាលី";
        final String metaValue_AL = "អាល់បានី";
        final String metaValue_SD = "ស៊ូដង់";
        final String metaValue_SE = "ស៊ុយអែត";
        final String metaValue_TH = "ថៃ";
        final String metaValue_TO = "តុងហ្គា";
        final String metaValue_UA = "អ៊ុយក្រែន";
        final String metaValue_VN = "វៀតណាម";
        final String metaValue_CN = "ចិន";
        final String metaValue_PH = "ហ្វ៊ីលីពីន";
        final String metaValue_SY = "ស៊ីរី";
        final String metaValue_TV = "ទូវ៉ាលូ";
        final String metaValue_ar = "អារ៉ាប់";
        final String metaValue_ae = "អាវេស្ថាន";
        final String metaValue_ban = "បាលី";
        final String metaValue_ccp = "ចាក់ម៉ា";
        final String metaValue_CY = "ស៊ីប";
        final String metaValue_ET = "អេត្យូពី";
        final String metaValue_GE = "ហ្សកហ្ស៊ី";
        final String metaValue_IL = "អ៊ីស្រាអែល";
        final String metaValue_jv = "ជ្វា";
        final String metaValue_km = "ខ្មែរ";
        final String metaValue_kn = "ខាណាដា";
        final String metaValue_ko = "កូរ៉េ";
        final String metaValue_ml = "ម៉ាឡាយ៉ាឡាម";
        final String metaValue_my = "ភូមា";
        final String metaValue_or = "អូឌៀ";
        final String metaValue_ta = "តាមីល";
        final String metaValue_te = "តេលុគុ";
        final String metaValue_bo = "ទីបេ";
        final String metaValue_MD = "ម៉ុលដាវី";
        final String metaValue_type_nu_taml = "លេខ​តាមីល";
        final Object[][] data = new Object[][] {
            { "001", "ពិភពលោក" },
            { "002", "អាហ្វ្រិក" },
            { "003", "អាមេរិក​ខាង​ជើង" },
            { "005", "អាមេរិក​ខាង​ត្បូង" },
            { "009", "អូសេអានី" },
            { "011", "អាហ្វ្រិក​ខាង​លិច" },
            { "013", "អាមេរិក​កណ្ដាល" },
            { "014", "អាហ្វ្រិកខាងកើត" },
            { "015", "អាហ្វ្រិក​ខាង​ជើង" },
            { "017", "អាហ្វ្រិក​កណ្តាល" },
            { "018", "អាហ្វ្រិកភាគខាងត្បូង" },
            { "019", "អាមេរិក" },
            { "021", "អាមេរិក​ភាគ​ខាង​ជើង" },
            { "029", "ការ៉ាប៊ីន" },
            { "030", "អាស៊ី​ខាង​កើត" },
            { "034", "អាស៊ី​ខាង​ត្បូង" },
            { "035", "អាស៊ីអាគ្នេយ៍" },
            { "039", "អឺរ៉ុប​ខាង​ត្បូង" },
            { "053", "អូស្ត្រាឡាស៊ី" },
            { "054", "មេឡាណេស៊ី" },
            { "057", "តំបន់​មីក្រូណេស៊ី" },
            { "061", "ប៉ូលីណេស៊ី" },
            { "142", "អាស៊ី" },
            { "143", "អាស៊ី​កណ្ដាល" },
            { "145", "អាស៊ី​ខាង​លិច" },
            { "150", "អឺរ៉ុប" },
            { "151", "អឺរ៉ុប​ខាង​កើត" },
            { "154", "អឺរ៉ុប​ខាង​ជើង" },
            { "155", "អឺរ៉ុប​ខាង​លិច" },
            { "202", "អនុតំបន់សាហារ៉ាអាហ្វ្រិក" },
            { "419", "អាមេរិក​ឡាទីន" },
            { "AC", "កោះ​អាសេនសិន" },
            { "AD", "អង់ដូរ៉ា" },
            { "AE", "អេមីរ៉ាត​អារ៉ាប់​រួម" },
            { "AF", "អាហ្វហ្កានីស្ថាន" },
            { "AG", "អង់ទីហ្គា និង បាប៊ុយដា" },
            { "AI", "អង់ហ្គីឡា" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "អង់ហ្គោឡា" },
            { "AQ", "អង់តាក់ទិក" },
            { "AR", "អាហ្សង់ទីន" },
            { "AS", "សាម័រ អាមេរិកាំង" },
            { "AT", "អូទ្រីស" },
            { "AU", "អូស្ត្រាលី" },
            { "AW", "អារូបា" },
            { "AX", "កោះ​អាឡង់" },
            { "AZ", metaValue_AZ },
            { "BA", "បូស្ន៊ី និងហឺហ្ស៊ីហ្គូវីណា" },
            { "BB", "បាបាដុស" },
            { "BD", metaValue_BD },
            { "BE", "បែលហ្ស៊ិក" },
            { "BF", "បួគីណាហ្វាសូ" },
            { "BG", metaValue_BG },
            { "BH", "បារ៉ែន" },
            { "BI", "ប៊ូរុនឌី" },
            { "BJ", "បេណាំង" },
            { "BL", "សាំង​បាថេឡេមី" },
            { "BM", "ប៊ឺមុយដា" },
            { "BN", "ព្រុយណេ" },
            { "BO", "បូលីវី" },
            { "BQ", "ហូឡង់ ការ៉ាប៊ីន" },
            { "BR", "ប្រេស៊ីល" },
            { "BS", "បាហាម៉ា" },
            { "BT", "ប៊ូតង់" },
            { "BV", "កោះ​ប៊ូវ៉េត" },
            { "BW", "បុតស្វាណា" },
            { "BY", metaValue_BY },
            { "BZ", "បេលី" },
            { "CA", "កាណាដា" },
            { "CC", "កោះ​កូកូស (គីលីង)" },
            { "CD", "កុងហ្គោ- គីនស្ហាសា" },
            { "CF", "សាធារណរដ្ឋអាហ្វ្រិកកណ្ដាល" },
            { "CG", "កុងហ្គោ - ប្រាហ្សាវីល" },
            { "CH", "ស្វ៊ីស" },
            { "CI", "កូតឌីវ័រ" },
            { "CK", "កោះ​ខូក" },
            { "CL", "ស៊ីលី" },
            { "CM", "កាមេរូន" },
            { "CN", metaValue_CN },
            { "CO", "កូឡុំប៊ី" },
            { "CP", "កោះ​ឃ្លីភឺតុន" },
            { "CR", "កូស្តារីកា" },
            { "CU", "គុយបា" },
            { "CV", "កាប់វែរ" },
            { "CW", "កូរ៉ាកៅ" },
            { "CX", "កោះ​គ្រីស្មាស" },
            { "CY", metaValue_CY },
            { "CZ", metaValue_CZ },
            { "DE", metaValue_DE },
            { "DG", "ឌៀហ្គោហ្គាស៊ី" },
            { "DJ", "ជីប៊ូទី" },
            { "DK", metaValue_DK },
            { "DM", "ដូមីនីក" },
            { "DO", "សាធារណរដ្ឋ​ដូមីនីក" },
            { "DZ", "អាល់ហ្សេរី" },
            { "EA", "ជឺតា និង​ម៉េលីឡា" },
            { "EC", "អេក្វាទ័រ" },
            { "EE", metaValue_EE },
            { "EG", "អេហ្ស៊ីប" },
            { "EH", "សាហារ៉ាខាងលិច" },
            { "ER", "អេរីត្រេ" },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "EU", "សហភាព​អឺរ៉ុប" },
            { "EZ", "តំបន់ចាយលុយអឺរ៉ូ" },
            { "FI", metaValue_FI },
            { "FJ", "ហ្វីជី" },
            { "FK", "កោះ​ហ្វក់ឡែន" },
            { "FM", "មីក្រូណេស៊ី" },
            { "FO", "កោះ​ហ្វារ៉ូ" },
            { "FR", metaValue_FR },
            { "GA", "ហ្គាបុង" },
            { "GB", "ចក្រភព​អង់គ្លេស" },
            { "GD", "ហ្គ្រើណាដ" },
            { "GE", metaValue_GE },
            { "GF", "ហ្គីអាណា បារាំង" },
            { "GG", "ហ្គេនស៊ី" },
            { "GH", "ហ្គាណា" },
            { "GI", "ហ្ស៊ីប្រាល់តា" },
            { "GL", "ហ្គ្រោអង់ឡង់" },
            { "GM", "ហ្គំប៊ី" },
            { "GN", "ហ្គីណេ" },
            { "GP", "ហ្គោដឺឡុប" },
            { "GQ", "ហ្គីណេអេក្វាទ័រ" },
            { "GR", metaValue_GR },
            { "GS", "កោះ​ហ្សកហ្ស៊ី​ខាងត្បូង និង សង់វិច​ខាងត្បូង" },
            { "GT", "ក្វាតេម៉ាឡា" },
            { "GU", "ហ្គាំ" },
            { "GW", "ហ្គីណេប៊ីស្សូ" },
            { "GY", "ហ្គីយ៉ាន" },
            { "HK", "ហុងកុង តំបន់រដ្ឋបាលពិសេសចិន" },
            { "HM", "កោះ​ហឺដនិង​ម៉ាក់ដូណាល់" },
            { "HN", "ហុងឌូរ៉ាស" },
            { "HR", "ក្រូអាស៊ី" },
            { "HT", metaValue_HT },
            { "HU", metaValue_HU },
            { "IC", "កោះ​កាណារី" },
            { "ID", metaValue_ID },
            { "IE", metaValue_IE },
            { "IL", metaValue_IL },
            { "IM", "អែលអុហ្វមែន" },
            { "IN", "ឥណ្ឌា" },
            { "IO", "ដែនដី​អង់គ្លេស​នៅ​មហា​សមុទ្រ​ឥណ្ឌា" },
            { "IQ", "អ៊ីរ៉ាក់" },
            { "IR", "អ៊ីរ៉ង់" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "JE", "ជើស៊ី" },
            { "JM", "ហ្សាម៉ាអ៊ីក" },
            { "JO", "ហ៊្សកដានី" },
            { "JP", metaValue_JP },
            { "KE", "កេនយ៉ា" },
            { "KG", "កៀហ្ស៊ីស៊ីស្ថាន" },
            { "KH", "កម្ពុជា" },
            { "KI", "គិរីបាទី" },
            { "KM", "កូម័រ" },
            { "KN", "សាំង​គីត និង ណេវីស" },
            { "KP", "កូរ៉េ​ខាង​ជើង" },
            { "KR", "កូរ៉េ​ខាង​ត្បូង" },
            { "KW", "កូវ៉ែត" },
            { "KY", "កោះ​កៃម៉ង់" },
            { "KZ", "កាហ្សាក់ស្ថាន" },
            { "LA", metaValue_LA },
            { "LB", "លីបង់" },
            { "LC", "សាំងលូស៊ី" },
            { "LI", "លិចតិនស្ដាញ" },
            { "LK", metaValue_LK },
            { "LR", "លីបេរីយ៉ា" },
            { "LS", "ឡេសូតូ" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", "ឡេតូនី" },
            { "LY", "លីប៊ី" },
            { "MA", "ម៉ារ៉ុក" },
            { "MC", "ម៉ូណាកូ" },
            { "MD", metaValue_MD },
            { "ME", "ម៉ុងតេណេហ្គ្រោ" },
            { "MF", "សាំង​ម៉ាទីន" },
            { "MG", "ម៉ាដាហ្គាស្កា" },
            { "MH", "កោះ​ម៉ាស់សល" },
            { "MK", "ម៉ាសេដ្វានខាងជើង" },
            { "ML", "ម៉ាលី" },
            { "MM", "មីយ៉ាន់ម៉ា (ភូមា)" },
            { "MN", metaValue_MN },
            { "MO", "ម៉ាកាវ តំបន់រដ្ឋបាលពិសេសចិន" },
            { "MP", "កោះ​ម៉ារីណា​ខាង​ជើង" },
            { "MQ", "ម៉ាទីនីក" },
            { "MR", "ម៉ូរីតានី" },
            { "MS", "ម៉ុងស៊ែរ៉ា" },
            { "MT", "ម៉ាល់ត៍" },
            { "MU", "ម៉ូរីស" },
            { "MV", "ម៉ាល់ឌីវ" },
            { "MW", "ម៉ាឡាវី" },
            { "MX", "ម៉ិកស៊ិក" },
            { "MY", "ម៉ាឡេស៊ី" },
            { "MZ", "ម៉ូសំប៊ិក" },
            { "NA", "ណាមីប៊ី" },
            { "NC", "នូវែល​កាឡេដូនី" },
            { "NE", "នីហ្សេ" },
            { "NF", "កោះ​ណ័រហ្វក់" },
            { "NG", "នីហ្សេរីយ៉ា" },
            { "NI", "នីការ៉ាហ្គា" },
            { "NL", metaValue_NL },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "ណៀ" },
            { "NZ", "នូវែល​សេឡង់" },
            { "OM", "អូម៉ង់" },
            { "PA", "ប៉ាណាម៉ា" },
            { "PE", "ប៉េរូ" },
            { "PF", "ប៉ូលី​ណេស៊ី​បារាំង" },
            { "PG", "ប៉ាពូអាស៊ី​នូវែលហ្គីណេ" },
            { "PH", metaValue_PH },
            { "PK", "ប៉ាគីស្ថាន" },
            { "PL", metaValue_PL },
            { "PM", "សង់ព្យែរ និង​មីគីឡុង" },
            { "PN", "កោះ​ភីតកាន" },
            { "PR", "ព័រតូរីកូ" },
            { "PS", "ដែនដីប៉ាឡេស្ទីន" },
            { "PT", "ព័រទុយហ្កាល់" },
            { "PW", "ផៅឡូ" },
            { "PY", "ប៉ារ៉ាហ្គាយ" },
            { "QA", "កាតា" },
            { "QO", "តំបន់ជាយអូសេអានី" },
            { "RE", "រេអុយញ៉ុង" },
            { "RO", metaValue_RO },
            { "RS", "សែប៊ី" },
            { "RU", metaValue_RU },
            { "RW", "រវ៉ាន់ដា" },
            { "SA", "អារ៉ាប៊ីសាអូឌីត" },
            { "SB", "កោះ​សូឡូម៉ុង" },
            { "SC", "សីស្ហែល" },
            { "SD", metaValue_SD },
            { "SE", metaValue_SE },
            { "SG", "សិង្ហបុរី" },
            { "SH", "សង់​ហេឡេណា" },
            { "SI", "ស្លូវេនី" },
            { "SJ", "ស្វាលបាដ និង ហ្សង់ម៉ាយេន" },
            { "SK", metaValue_SK },
            { "SL", "សៀរ៉ាឡេអូន" },
            { "SM", "សាន​ម៉ារីណូ" },
            { "SN", "សេណេហ្គាល់" },
            { "SO", metaValue_SO },
            { "SR", "សូរីណាម" },
            { "SS", "ស៊ូដង់​ខាង​ត្បូង" },
            { "ST", "សៅតូម៉េ និង ប្រាំងស៊ីប" },
            { "SV", "អែលសាល់វ៉ាឌ័រ" },
            { "SX", "សីង​ម៉ាធីន" },
            { "SY", metaValue_SY },
            { "SZ", "ស្វាស៊ីឡង់" },
            { "TA", "ទ្រីស្តង់​ដា​ចូនហា" },
            { "TC", "កោះ​ទួគ និង កៃកូស" },
            { "TD", "ឆាដ" },
            { "TF", "ដែនដី​បារាំង​នៅ​ភាគខាងត្បូង" },
            { "TG", "តូហ្គោ" },
            { "TH", metaValue_TH },
            { "TJ", "តាហ្ស៊ីគីស្ថាន" },
            { "TK", "តូខេឡៅ" },
            { "TL", "ទីម័រលេស្តេ" },
            { "TM", "តួកម៉េនីស្ថាន" },
            { "TN", "ទុយនីស៊ី" },
            { "TO", metaValue_TO },
            { "TR", "តួកគី" },
            { "TT", "ទ្រីនីដាត និង​តូបាហ្គោ" },
            { "TV", metaValue_TV },
            { "TW", "តៃវ៉ាន់" },
            { "TZ", "តង់សានី" },
            { "UA", metaValue_UA },
            { "UG", "អ៊ូហ្គង់ដា" },
            { "UM", "កោះ​អៅឡាយីង​អាមេរិក" },
            { "UN", "អង្គការសហប្រជាជាតិ" },
            { "US", "សហរដ្ឋអាមេរិក" },
            { "UY", "អ៊ុយរូហ្គាយ" },
            { "UZ", "អ៊ូសបេគីស្ថាន" },
            { "VA", "បុរី​វ៉ាទីកង់" },
            { "VC", "សាំង​វ៉ាំងសង់ និង ហ្គ្រេណាឌីន" },
            { "VE", "វ៉េណេស៊ុយអេឡា" },
            { "VG", "កោះ​វឺជិន​ចក្រភព​អង់គ្លេស" },
            { "VI", "កោះ​វឺជីន​អាមេរិក" },
            { "VN", metaValue_VN },
            { "VU", "វ៉ានូទូ" },
            { "WF", "វ៉ាលីស និង​ហ្វូទូណា" },
            { "WS", metaValue_WS },
            { "XA", "Pseudo-Accents" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "កូសូវ៉ូ" },
            { "YE", "យេម៉ែន" },
            { "YT", "ម៉ាយុត" },
            { "ZA", "អាហ្វ្រិកខាងត្បូង" },
            { "ZM", "សំប៊ី" },
            { "ZW", "ស៊ីមបាវ៉េ" },
            { "ZZ", "តំបន់មិនស្គាល់" },
            { "aa", "អាហ្វារ" },
            { "ab", "អាប់ខាហ៊្សាន" },
            { "ae", metaValue_ae },
            { "af", "អាហ្វ្រិកាន" },
            { "ak", "អាកាន" },
            { "am", "អាំហារិក" },
            { "an", "អារ៉ាហ្គោន" },
            { "ar", metaValue_ar },
            { "as", "អាសាមីស" },
            { "av", "អាវ៉ារីក" },
            { "ay", "អីម៉ារ៉ា" },
            { "az", metaValue_AZ },
            { "ba", "បាស្គៀ" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "ប៊ីស្លាម៉ា" },
            { "bm", "បាម្បារា" },
            { "bn", metaValue_BD },
            { "bo", metaValue_bo },
            { "br", "ប្រ៊ីស្តុន" },
            { "bs", "បូស្ន៊ី" },
            { "ca", "កាតាឡាន" },
            { "ce", "ឈីឆេន" },
            { "ch", "ឈីម៉ូរ៉ូ" },
            { "co", "កូស៊ីខាន" },
            { "cs", metaValue_CZ },
            { "cu", "ឈើជស្លាវិក" },
            { "cv", "ឈូវ៉ាស" },
            { "cy", "វេល" },
            { "da", metaValue_DK },
            { "de", metaValue_DE },
            { "dv", "ទេវីហ៊ី" },
            { "dz", "ដុងខា" },
            { "ee", "អ៊ីវ" },
            { "el", metaValue_GR },
            { "en", "អង់គ្លេស" },
            { "eo", "អេស្ពេរ៉ាន់តូ" },
            { "es", metaValue_ES },
            { "et", metaValue_EE },
            { "eu", "បាសខ៍" },
            { "fa", "ភឺសៀន" },
            { "ff", "ហ្វ៊ូឡា" },
            { "fi", metaValue_FI },
            { "fj", "ហ៊្វីជី" },
            { "fo", "ហ្វារូស" },
            { "fr", metaValue_FR },
            { "fy", "ហ្វ្រីស៊ានខាងលិច" },
            { "ga", metaValue_IE },
            { "gd", "ស្កុតហ្កែលិគ" },
            { "gl", "ហ្កាលីស្យាន" },
            { "gn", "ហ្គូរ៉ានី" },
            { "gu", "ហ្គុយ៉ារ៉ាទី" },
            { "gv", "មេន" },
            { "ha", "ហូសា" },
            { "he", "ហេប្រឺ" },
            { "hi", "ហិណ្ឌី" },
            { "hr", "ក្រូអាត" },
            { "ht", metaValue_HT },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "ហឺរីរ៉ូ" },
            { "ia", "អ៊ីនធើលីង" },
            { "id", metaValue_ID },
            { "ie", "អ៊ីនធើលីងវេ" },
            { "ig", "អ៊ីកបូ" },
            { "ii", "ស៊ីឈាន់យី" },
            { "io", "អ៊ីដូ" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "អ៊ីនុកទីទុត" },
            { "ja", metaValue_JP },
            { "jv", metaValue_jv },
            { "ka", "ហ្សក​ហ្ស៊ី" },
            { "ki", "គីគូយូ" },
            { "kj", "គូនយ៉ាម៉ា" },
            { "kk", "កាហ្សាក់" },
            { "kl", "កាឡាលលីស៊ុត" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "កានូរី" },
            { "ks", "កាស្មៀរ" },
            { "ku", "ឃឺដ" },
            { "kv", "កូមី" },
            { "kw", "កូនីស" },
            { "ky", "​កៀហ្ស៊ីស" },
            { "la", "ឡាតំាង" },
            { "lb", metaValue_LU },
            { "lg", "ហ្កាន់ដា" },
            { "li", "លីមប៊ូស" },
            { "ln", "លីនកាឡា" },
            { "lo", metaValue_LA },
            { "lt", metaValue_LT },
            { "lu", "លូបាកាតានហ្គា" },
            { "lv", "ឡាតវី" },
            { "mg", "ម៉ាឡាហ្គាស៊ី" },
            { "mh", "ម៉ាស់សល" },
            { "mi", "ម៉ោរី" },
            { "mk", "ម៉ាសេដូនី" },
            { "ml", metaValue_ml },
            { "mn", metaValue_MN },
            { "mr", "ម៉ារ៉ាធី" },
            { "ms", "ម៉ាឡេ" },
            { "mt", "ម៉ាល់តា" },
            { "my", metaValue_my },
            { "na", metaValue_NR },
            { "nb", "ន័រវែស បុកម៉ាល់" },
            { "nd", "នេបេលេខាងជើង" },
            { "ne", metaValue_NP },
            { "ng", "នុនហ្គា" },
            { "nl", metaValue_NL },
            { "nn", "ន័រវែស នីនូស" },
            { "no", metaValue_NO },
            { "nr", "នេប៊េលខាងត្បូង" },
            { "nv", "ណាវ៉ាចូ" },
            { "ny", "ណានចា" },
            { "oc", "អូសីតាន់" },
            { "om", "អូរ៉ូម៉ូ" },
            { "or", metaValue_or },
            { "os", "អូស៊ីទិក" },
            { "pa", "បឹនជាពិ" },
            { "pl", metaValue_PL },
            { "ps", "បាស្តូ" },
            { "pt", "ព័រទុយហ្គាល់" },
            { "qu", "ហ្គិកឈួ" },
            { "rm", "រ៉ូម៉ង់" },
            { "rn", "រុណ្ឌី" },
            { "ro", metaValue_RO },
            { "ru", metaValue_RU },
            { "rw", "គិនយ៉ាវ៉ាន់ដា" },
            { "sa", "សំស្ក្រឹត" },
            { "sc", "សាឌីនា" },
            { "sd", "ស៊ីនឌី" },
            { "se", "សាមីខាងជើង" },
            { "sg", "សានហ្គោ" },
            { "sh", "សឺបូក្រូអាត" },
            { "si", metaValue_LK },
            { "sk", metaValue_SK },
            { "sl", "ស្លូវ៉ានី" },
            { "sm", metaValue_WS },
            { "sn", "សូណា" },
            { "so", metaValue_SO },
            { "sq", metaValue_AL },
            { "sr", "ស៊ែប" },
            { "ss", "ស្វាទី" },
            { "st", "សូថូខាងត្បូង" },
            { "su", metaValue_SD },
            { "sv", metaValue_SE },
            { "sw", "ស្វាហ៊ីលី" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "តាហ្ស៊ីគ" },
            { "th", metaValue_TH },
            { "ti", "ទីហ្គ្រីញ៉ា" },
            { "tk", "តួកម៉េន" },
            { "tn", "ស្វាណា" },
            { "to", metaValue_TO },
            { "tr", "ទួរគី" },
            { "ts", "សុងហ្គា" },
            { "tt", "តាតា" },
            { "tw", "ទ្វី" },
            { "ty", "តាហ៊ីទី" },
            { "ug", "អ៊ុយហ្គឺរ" },
            { "uk", metaValue_UA },
            { "ur", "អ៊ូរឌូ" },
            { "uz", "អ៊ូសបេគ" },
            { "ve", "វេនដា" },
            { "vi", metaValue_VN },
            { "vo", "វូឡាពូក" },
            { "wa", "វ៉ាលូន" },
            { "wo", "វូឡុហ្វ" },
            { "xh", "ឃសា" },
            { "yi", "យ៉ីឌីស" },
            { "yo", "យរូបា" },
            { "za", "ហ្សួង" },
            { "zh", metaValue_CN },
            { "zu", "ហ្សូលូ" },
            { "ace", "អាកហ៊ីនឺស" },
            { "ada", "អាដេងមី" },
            { "ady", "អាឌីហ្គី" },
            { "agq", "អាហ្គីម" },
            { "ain", "អាយនូ" },
            { "ale", "អាលូត" },
            { "alt", "អាល់តៃខាងត្បូង" },
            { "ann", "អូបូឡូ" },
            { "anp", "អាហ្គីកា" },
            { "arn", "ម៉ាពូឈី" },
            { "arp", "អារ៉ាប៉ាហូ" },
            { "ars", "អារ៉ាប់ណាឌី" },
            { "asa", "អាស៊ូ" },
            { "ast", "អាស្ទូរី" },
            { "atj", "អាទិកាម៉េក" },
            { "awa", "អាវ៉ាឌី" },
            { "ban", metaValue_ban },
            { "bas", "បាសា" },
            { "bem", "បេមបា" },
            { "bez", "បេណា" },
            { "bgc", "ហារីយ៉ាន់វី" },
            { "bgn", "បាឡូជីខាងលិច" },
            { "bho", "បូចពូរី" },
            { "bin", "ប៊ីនី" },
            { "bla", "ស៊ីកស៊ីកា" },
            { "blo", "អានី" },
            { "brx", "បូដូ" },
            { "bug", "ប៊ុកហ្គី" },
            { "byn", "ប្ល៊ីន" },
            { "cay", "ខាយូហ្កា" },
            { "ccp", metaValue_ccp },
            { "ceb", "ស៊ីប៊ូអាណូ" },
            { "cgg", "ឈីហ្កា" },
            { "chk", "ឈូគី" },
            { "chm", "ម៉ារី" },
            { "cho", "ឆុកតាវ" },
            { "chp", "ឈីប៉េវ៉ាយអិន" },
            { "chr", "ឆេរូគី" },
            { "chy", "ឈីយីនី" },
            { "ckb", "ឃើដភាគកណ្តាល" },
            { "clc", "ឈីលកូទីន" },
            { "crg", "មីឈីហ្វ" },
            { "crj", "គ្រីខាងកើត​ប៉ែកខាងត្បូង" },
            { "crk", "គ្រីតំបន់វាលរាប" },
            { "crl", "គ្រីខាងកើត​ប៉ែកខាងជើង" },
            { "crm", "មូសគ្រី" },
            { "crr", "អាល់ហ្គនខ្វៀន ខារ៉ូលីណា" },
            { "crs", "សេសេលវ៉ាគ្រីអូល (បារាំង)" },
            { "csw", "គ្រីតំបន់ភក់ល្បាប់" },
            { "dak", "ដាកូតា" },
            { "dar", "ដាចវ៉ា" },
            { "dav", "តៃតា" },
            { "dgr", "ដូគ្រីប" },
            { "dje", "ហ្សាម៉ា" },
            { "doi", "ដូហ្គ្រី" },
            { "dsb", "សូប៊ីក្រោម" },
            { "dua", "ឌួលឡា" },
            { "dyo", "ចូឡាហ៊្វុនយី" },
            { "dzg", "ដាហ្សាហ្គា" },
            { "ebu", "អេមប៊ូ" },
            { "efi", "អ៊ីហ្វិក" },
            { "eka", "អ៊ីកាជុក" },
            { "ewo", "អ៊ីវ៉ុនដូ" },
            { "fil", metaValue_PH },
            { "fon", "ហ្វ៊ុន" },
            { "frc", "បារាំងកាហ្សង់" },
            { "frr", "ហ្វ្រ៊ីសៀន​ខាងជើង" },
            { "fur", "ហ៊្វ្រូលាន" },
            { "gaa", "ហ្គា" },
            { "gag", "កាគូស" },
            { "gez", "ជីស" },
            { "gil", "ហ្គីលបឺទ" },
            { "gor", "ហ្គូរុនតាឡូ" },
            { "gsw", "អាល្លឺម៉ង (ស្វីស)" },
            { "guz", "ហ្គូស៊ី" },
            { "gwi", "ហ្គីចឈីន" },
            { "hai", "ហៃដា" },
            { "haw", "ហាវ៉ៃ" },
            { "hax", "ហៃដាខាងត្បូង" },
            { "hil", "ហ៊ីលីហ្គេណុន" },
            { "hmn", "ម៉ុង" },
            { "hsb", "សូប៊ីលើ" },
            { "hup", "ហ៊ូប៉ា" },
            { "hur", "ហាល់កូម៉េឡេម" },
            { "iba", "អ៊ីបាន" },
            { "ibb", "អាយប៊ីប៊ីអូ" },
            { "ikt", "អ៊ីនុកទីទុត​កាណាដា​ប៉ែកខាងលិច" },
            { "ilo", "អ៊ីឡូកូ" },
            { "inh", "អ៊ិនហ្គូស" },
            { "jbo", "លុចបាន" },
            { "jgo", "ងុំបា" },
            { "jmc", "ម៉ាឆាំ" },
            { "kab", "កាប៊ីឡេ" },
            { "kac", "កាឈីន" },
            { "kaj", "ជូ" },
            { "kam", "កាំបា" },
            { "kbd", "កាបាឌៀ" },
            { "kcg", "យ៉ាប់" },
            { "kde", "ម៉ាកូនដេ" },
            { "kea", "កាប៊ូវឺឌៀនូ" },
            { "kfo", "គូរូ" },
            { "kgp", "ខាងហ្កេង" },
            { "kha", "កាស៊ី" },
            { "khq", "គុយរ៉ាឈីនី" },
            { "kkj", "កាកូ" },
            { "kln", "កាលែនជីន" },
            { "kmb", "គីមប៊ុនឌូ" },
            { "koi", "គូមីភឹមយ៉ាគ" },
            { "kok", "គុនកានី" },
            { "kpe", "គ្លីប" },
            { "krc", "ការ៉ាឆាយបាល់កា" },
            { "krl", "ការីលា" },
            { "kru", "គូរូក" },
            { "ksb", "សាមបាឡា" },
            { "ksf", "បាហ្វៀ" },
            { "ksh", "កូឡូញ" },
            { "kum", "គូមីគ" },
            { "kwk", "ក្វាក់វ៉ាឡា" },
            { "kxv", "គូវី" },
            { "lad", "ឡាឌីណូ" },
            { "lag", "ឡានហ្គី" },
            { "lez", "ឡេសហ្គី" },
            { "lij", "លីគូរី" },
            { "lil", "លីលលូអេត" },
            { "lkt", "ឡាកូតា" },
            { "lmo", "ឡំបាត" },
            { "lou", "ក្រេអូល លូអ៊ីស៊ីអាណា" },
            { "loz", "ឡូហ្ស៊ី" },
            { "lrc", "លូរីខាងជើង" },
            { "lsm", "សាមៀ" },
            { "lua", "លូបាលូឡា" },
            { "lun", "លុនដា" },
            { "luo", "លូអូ" },
            { "lus", "មីហ្សូ" },
            { "luy", "លូយ៉ា" },
            { "mad", "ម៉ាឌូរីស" },
            { "mag", "ម៉ាហ្គាហ៊ី" },
            { "mai", "ម៉ៃធីលី" },
            { "mak", "ម៉ាកាសា" },
            { "mas", "ម៉ាសៃ" },
            { "mdf", "មុខសា" },
            { "men", "មេនឌី" },
            { "mer", "មេរូ" },
            { "mfe", "ម៉ូរីស៊ីន" },
            { "mgh", "ម៉ាកគូវ៉ាមីតូ" },
            { "mgo", "មេតា" },
            { "mic", "មិកមេក" },
            { "min", "មីណាងកាប៊ូ" },
            { "mni", "ម៉ានីពូរី" },
            { "moe", "អ៊ីននូអៃមុន" },
            { "moh", "ម៊ូហាគ" },
            { "mos", "មូស៊ី" },
            { "mua", "មុនដាង" },
            { "mul", "ពហុភាសា" },
            { "mus", "គ្រីក" },
            { "mwl", "មីរ៉ានដេស" },
            { "myv", "អឺហ្ស៊ីយ៉ា" },
            { "mzn", "ម៉ាហ្សានដឺរេនី" },
            { "nap", "នាប៉ូលីតាន" },
            { "naq", "ណាម៉ា" },
            { "nds", "អាល្លឺម៉ង់ក្រោម" },
            { "new", "នេវ៉ាវី" },
            { "nia", "នីអាស" },
            { "niu", "នូអៀន" },
            { "nmg", "ក្វាស្យូ" },
            { "nnh", "ងៀមប៊ូន" },
            { "nog", "ណូហ្គៃ" },
            { "nqo", "នគោ" },
            { "nso", "សូថូខាងជើង" },
            { "nus", "នូអ័រ" },
            { "nyn", "ណានកូលេ" },
            { "ojb", "អូជីបវ៉ា​ប៉ែកពាយ័ព្យ" },
            { "ojc", "អូជីពវ៉ាកណ្ដាល" },
            { "ojs", "អូជីគ្រី" },
            { "ojw", "អូជីបវ៉ា​ខាងលិច" },
            { "oka", "អូកាណាហ្កាន" },
            { "pag", "ភេនហ្គាស៊ីណាន" },
            { "pam", "ផាមភេនហ្គា" },
            { "pap", "ប៉ាប៉ៃមេនតូ" },
            { "pau", "ប៉ាលូអាន" },
            { "pcm", "ភាសាទំនាក់ទំនងនីហ្សេរីយ៉ា" },
            { "pis", "ពីជីន" },
            { "pqm", "ម៉ាលីស៊ីត ប៉ាសាម៉ាខ្វូឌី" },
            { "prg", "ព្រូស៊ាន" },
            { "quc", "គីចឈី" },
            { "raj", "រ៉ាចាស់ថានី" },
            { "rap", "រ៉ាប៉ានូ" },
            { "rar", "រ៉ារ៉ូតុងហ្គាន" },
            { "rhg", "រ៉ូហ៊ីងយ៉ា" },
            { "rof", "រុមបូ" },
            { "rup", "អារ៉ូម៉ានី" },
            { "rwk", "រ៉្វា" },
            { "sad", "សានដាវី" },
            { "sah", "យ៉ាឃុត" },
            { "saq", "សាមបូរូ" },
            { "sat", "សាន់តាលី" },
            { "sba", "ងាំបេយ" },
            { "sbp", "សានហ្គូ" },
            { "scn", "ស៊ីស៊ីលាន" },
            { "sco", "ស្កុត" },
            { "sdh", "ឃើដភាគខាងត្បូង" },
            { "seh", "ស៊ីណា" },
            { "ses", "គុយរ៉ាបូរ៉ុស៊ីនី" },
            { "shi", "តាឈីលហ៊ីត" },
            { "shn", "សាន" },
            { "slh", "ឡាស៊ូតស៊ីតខាងត្បូង" },
            { "sma", "សាមីខាងត្បូង" },
            { "smj", "លូលីសាមី" },
            { "smn", "អ៊ីណារីសាមី" },
            { "sms", "ស្កុលសាមី" },
            { "snk", "សូនីនគេ" },
            { "srn", "ស្រាណានតុងហ្គោ" },
            { "ssy", "សាហូ" },
            { "str", "សាលីសស្ត្រេតស៍" },
            { "suk", "ស៊ូគូម៉ា" },
            { "swb", "កូម៉ូរី" },
            { "syr", metaValue_SY },
            { "szl", "ស៊ីឡេស៊ី" },
            { "tce", "ថុចឆុនខាងត្បូង" },
            { "tem", "ធីមនី" },
            { "teo", "តេសូ" },
            { "tet", "ទីទុំ" },
            { "tgx", "តាហ្គីស" },
            { "tht", "តាល់តាន" },
            { "tig", "ធីហ្គ្រា" },
            { "tlh", "ឃ្លីនហ្គុន" },
            { "tli", "ថ្លីងហ្គីត" },
            { "tok", "តូគីប៉ូណា" },
            { "tpi", "ថុកពីស៊ីន" },
            { "trv", "តារ៉ូកូ" },
            { "ttm", "ថុចឆុនខាងជើង" },
            { "tum", "ទុមប៊ូកា" },
            { "tvl", metaValue_TV },
            { "twq", "តាសាវ៉ាក់" },
            { "tyv", "ទូវីនៀ" },
            { "tzm", "តាម៉ាសាយអាត្លាសកណ្តាល" },
            { "udm", "អាត់មូដ" },
            { "umb", "អាម់ប៊ុនឌូ" },
            { "und", "ភាសាមិនស្គាល់" },
            { "vai", "វៃ" },
            { "vec", "វេណេតូ" },
            { "vmw", "ម៉ាឃូវ៉ា" },
            { "vun", "វុនចូ" },
            { "wae", "វេលសឺ" },
            { "wal", "វ៉ូឡាយតា" },
            { "war", "វ៉ារេយ" },
            { "wbp", "វ៉ារីប៉ារី" },
            { "wuu", "អ៊ូចិន" },
            { "xal", "កាលមីគ" },
            { "xnr", "ខែងគ្រី" },
            { "xog", "សូហ្គា" },
            { "yav", "យ៉ាងបេន" },
            { "ybb", "យេមបា" },
            { "yrl", "ញីនហ្កាទូ" },
            { "yue", "កន្តាំង" },
            { "zgh", "តាម៉ាហ្សៃម៉ារ៉ុកស្តង់ដា" },
            { "zun", "ហ្សូនី" },
            { "zxx", "គ្មាន​ទិន្នន័យ​ភាសា" },
            { "zza", "ហ្សាហ្សា" },
            { "Adlm", "អាតឡាម" },
            { "Aghb", "អាល់បានីកៅកាស៊ី" },
            { "Ahom", "អាហូម" },
            { "Arab", metaValue_ar },
            { "Aran", "អារ៉ាន" },
            { "Armi", "អារ៉ាម៉ាអ៊ីមភើរៀល" },
            { "Armn", metaValue_AM },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", "បាមុន" },
            { "Bass", "បាសាវ៉ះ" },
            { "Batk", "បាតាក" },
            { "Beng", metaValue_BD },
            { "Bhks", "ប៉ៃស៊ូគី" },
            { "Bopo", "បូផូម៉ូហ្វូ" },
            { "Brah", "ប្រាមិ" },
            { "Brai", "អក្សរ​សម្រាប់មនុស្ស​ពិការ​ភ្នែក" },
            { "Bugi", "ប៊ូគីនេ" },
            { "Buhd", "ប៊ូហ៊ីដ" },
            { "Cakm", metaValue_ccp },
            { "Cans", "ព្យាង្គអាបូរីជីន​កាណាដារួម" },
            { "Cari", "ខារី" },
            { "Cham", "ចាម" },
            { "Cher", "ឆេរ៉ូគី" },
            { "Chrs", "ខូរ៉ាស្មី" },
            { "Copt", "ខូប្ទ" },
            { "Cpmn", "ស៊ីប្រូមីណូ" },
            { "Cprt", metaValue_CY },
            { "Cyrl", "ស៊ីរីលីក" },
            { "Deva", "ដាវ៉ាន់ណាការិ" },
            { "Ethi", metaValue_ET },
            { "Geor", metaValue_GE },
            { "Gong", "គុនចាឡាកុនឌិ" },
            { "Grek", "ក្រិច" },
            { "Gujr", "គូចារ៉ាទី" },
            { "Guru", "កុមុយឃី" },
            { "Hanb", "ហានប៍" },
            { "Hang", "ហាំងកុល" },
            { "Hani", "ហាន" },
            { "Hans", "អក្សរ​ចិន​កាត់" },
            { "Hant", "អក្សរ​ចិន​ពេញ" },
            { "Hebr", metaValue_IL },
            { "Hira", "ហ៊ីរ៉ាកាណា" },
            { "Hmnp", "នីយ៉ាកេងពួជឺម៉ុង" },
            { "Hrkt", "សញ្ញាសំឡេងភាសាជប៉ុន" },
            { "Jamo", "ចាម៉ូ" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_JP },
            { "Kali", "កាយ៉ាលី" },
            { "Kana", "កាតាកាណា" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Lana", "ឡាណា" },
            { "Laoo", metaValue_LA },
            { "Latn", "ឡាតាំង" },
            { "Lepc", "ឡេបចា" },
            { "Limb", "លីបប៊ូ" },
            { "Lisu", "ហ្វ្រាសឺ" },
            { "Mand", "ម៉ានដា" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_MN },
            { "Mtei", "ម៉ីតីម៉ាយ៉ែក" },
            { "Mymr", metaValue_my },
            { "Newa", "ណេវ៉ា" },
            { "Nkoo", "នកូ" },
            { "Olck", "អូលឈិគិ" },
            { "Orya", metaValue_or },
            { "Osge", "អូស្គ" },
            { "Plrd", "ផូឡាដ" },
            { "Rohg", "ហានីហ្វ៊ី" },
            { "Saur", "សៅរ៉ាសត្រា" },
            { "Sinh", "ស៊ីនហាឡា" },
            { "Sund", metaValue_SD },
            { "Sylo", "ស៊ីឡូ" },
            { "Syrc", "ស៊ីរីអែក" },
            { "Tale", "តៃឡេ" },
            { "Talu", "តៃឡឺថ្មី" },
            { "Taml", metaValue_ta },
            { "Tavt", "តៃវៀត" },
            { "Telu", metaValue_te },
            { "Tfng", "ទីហ្វ៊ីណាហ្វ" },
            { "Thaa", "ថាណា" },
            { "Thai", metaValue_TH },
            { "Tibt", metaValue_bo },
            { "Vaii", "វ៉ៃ" },
            { "Wcho", "វ៉ាន់ឆូ" },
            { "Yiii", "យី" },
            { "Zinh", "ស្នងកេរ្តិ៍" },
            { "Zmth", "និមិត្តសញ្ញាគណិតវិទ្យា" },
            { "Zsye", "សញ្ញាអារម្មណ៍" },
            { "Zsym", "និមិត្តសញ្ញា" },
            { "Zxxx", "គ្មានការសរសេរ" },
            { "Zyyy", "ទូទៅ" },
            { "Zzzz", "អក្សរមិនស្គាល់" },
            { "es_ES", "អេស្ប៉ាញ (អ៊ឺរ៉ុប)" },
            { "fa_AF", "ដារី" },
            { "nl_BE", "ផ្លាមីស" },
            { "pt_BR", "ព័រទុយហ្កាល់ (ប្រេស៊ីល)" },
            { "pt_PT", "ព័រទុយហ្គាល់ (អឺរ៉ុប)" },
            { "ro_MD", metaValue_MD },
            { "sw_CD", "កុងហ្គោស្វាហ៊ីលី" },
            { "ar_001", "អារ៉ាប់ស្តង់ដារទំនើប" },
            { "key.ca", "ប្រតិទិន" },
            { "key.cf", "ទម្រង់រូបិយបណ្ណ" },
            { "key.co", "លំដាប់​តម្រៀប" },
            { "key.cu", "រូបិយបណ្ណ" },
            { "key.hc", "វដ្តម៉ោង (12 vs 24)" },
            { "key.lb", "របៀបចុះបន្ទាត់" },
            { "key.ms", "ប្រព័ន្ធវាស់វែង" },
            { "key.nu", "លេខ" },
            { "nds_NL", "ហ្សាក់ស្យុងក្រោម" },
            { "zh_Hans", "ចិន​អក្សរ​កាត់" },
            { "zh_Hant", "ចិន​អក្សរ​ពេញ" },
            { "type.ca.roc", "ប្រតិទិនមីងគ័រ" },
            { "type.hc.h11", "ប្រព័ន្ធ 12 ម៉ោង (0–11)" },
            { "type.hc.h12", "ប្រព័ន្ធ 12 ម៉ោង (1–12)" },
            { "type.hc.h23", "ប្រព័ន្ធ 24 ម៉ោង (0–23)" },
            { "type.hc.h24", "ប្រព័ន្ធ 24 ម៉ោង (1–24)" },
            { "type.nu.arab", "លេខ​ឥណ្ឌា-អារ៉ាប់" },
            { "type.nu.armn", "លេខ​អាមេនី" },
            { "type.nu.beng", "លេខ​បង់ក្លាដែស" },
            { "type.nu.cakm", "លេខចាក់ម៉ា" },
            { "type.nu.deva", "លេខ​ឌីវ៉ាណាការី" },
            { "type.nu.ethi", "លេខ​អេត្យូពី" },
            { "type.nu.geor", "លេខ​ហ្សកហ្សី" },
            { "type.nu.grek", "លេខ​ក្រិក" },
            { "type.nu.gujr", "លេខ​ហ្កុយ៉ារាទី" },
            { "type.nu.guru", "លេខ​កុមុឃី" },
            { "type.nu.hans", "លេខ​ចិន​អក្សរ​កាត់" },
            { "type.nu.hant", "លេខ​ចិន​អក្សរ​ពេញ" },
            { "type.nu.hebr", "លេខហេប្រឺ" },
            { "type.nu.java", "លេខជ្វា" },
            { "type.nu.jpan", "លេខ​ជប៉ុន" },
            { "type.nu.khmr", "លេខ​ខ្មែរ" },
            { "type.nu.knda", "លេខខាណាដា" },
            { "type.nu.laoo", "លេខ​ឡាវ" },
            { "type.nu.latn", "លេខ​បច្ចឹម​ប្រទេស" },
            { "type.nu.mlym", "លេខ​មលយាល័ម" },
            { "type.nu.mtei", "លេខមីតីម៉ាយ៉ែក" },
            { "type.nu.mymr", "លេខ​ភូមា" },
            { "type.nu.olck", "លេខអូលឈិគិ" },
            { "type.nu.orya", "លេខអូឌៀ" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "type.nu.telu", "លេខ​តេលុគុ" },
            { "type.nu.thai", "លេខ​ថៃ" },
            { "type.nu.tibt", "លេខទីបេ" },
            { "type.nu.vaii", "លេខវ៉ៃ" },
            { "type.ca.dangi", "ប្រតិទិនកូរ៉េ" },
            { "type.co.ducet", "លំដាប់​តម្រៀប​យូនីកូដ​លំនាំដើម" },
            { "type.lb.loose", "របៀបចុះបន្ទាត់ខ្លី" },
            { "type.nu.roman", "លេខ​រ៉ូមាំង" },
            { "type.ca.coptic", "ប្រតិទិនកបទិច" },
            { "type.ca.hebrew", "ប្រតិទិនហេប្រឺ" },
            { "type.co.search", "ស្វែងរក​ទូទៅ" },
            { "type.lb.normal", "របៀបចុះបន្ទាត់ធម្មតា" },
            { "type.lb.strict", "របៀបចុះបន្ទាត់តឹងរឹង" },
            { "type.ms.metric", "ប្រព័ន្ធវាស់វែងម៉ាទ្រិក" },
            { "type.ca.chinese", "ប្រតិទិន​ចិន" },
            { "type.ca.islamic", "ប្រតិទិនអ៊ីស្លាម" },
            { "type.ca.iso8601", "ប្រតិទិន ISO-8601" },
            { "type.ca.persian", "ប្រតិទិនពែក្ស" },
            { "type.cf.account", "ទម្រង់រូបិយបណ្ណគណនី" },
            { "type.nu.arabext", "លេខ​ឥណ្ឌា-អារ៉ាប់​ពង្រីក" },
            { "type.nu.armnlow", "លេខ​តូច​អាមេនី" },
            { "type.nu.greklow", "លេខ​តូច​ក្រិក" },
            { "type.nu.hanidec", "លេខ​ទសភាគ​ចិន" },
            { "type.nu.hansfin", "លេខ​ហិរញ្ញវត្ថុ​ចិន​អក្សរ​កាត់" },
            { "type.nu.hantfin", "លេខ​ហិរញ្ញវត្ថុ​ចិន​អក្សរ​ពេញ" },
            { "type.nu.jpanfin", "លេខ​ហិរញ្ញវត្ថុ​ជប៉ុន" },
            { "type.nu.tamldec", metaValue_type_nu_taml },
            { "type.ca.buddhist", "ប្រតិទិនពុទ្ធសាសនា" },
            { "type.ca.ethiopic", "ប្រតិទិន​អេត្យូពី" },
            { "type.ca.japanese", "ប្រតិទិន​ជប៉ុន" },
            { "type.cf.standard", "ទម្រង់រូបិយបណ្ណបទដ្ឋាន" },
            { "type.co.standard", "លំដាប់​តម្រៀប​ស្តង់ដារ" },
            { "type.ms.uksystem", "ប្រព័ន្ធវាស់វែងចក្រព័ទ្ធ" },
            { "type.ms.ussystem", "ប្រព័ន្ធវាស់វែងអាមេរិក" },
            { "type.nu.fullwide", "លេខ​ទទឹង​ពេញ" },
            { "type.nu.romanlow", "លេខ​តូច​រ៉ូមាំង" },
            { "type.ca.gregorian", "ប្រតិទិន​ហ្សកហ្ស៊ី" },
            { "ListKeyTypePattern", "{0}៖ {1}" },
            { "type.ca.islamic-civil", "ប្រតិទិនអ៊ិស្លាម (តារាង, សម័យស៊ីវិល)" },
            { "type.ca.islamic-umalqura", "ប្រតិទិនអ៊ិស្លាម (អ៊ុំអាល់គូរ៉ា)" },
            { "type.ca.ethiopic-amete-alem", "ប្រតិទិនអេត្យូពីអាម៉េតេ​អាលែម" },
        };
        return data;
    }
}
