/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_vai extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_DE = "ꕧꕮꔧ";
        final String metaValue_GR = "ꗥꗷꘋ";
        final String metaValue_US = "ꕶꕱ";
        final String metaValue_ES = "ꕐꘊꔧ";
        final String metaValue_NP = "ꕇꕐꔷ";
        final String metaValue_RW = "ꕟꖙꕡ";
        final String metaValue_SE = "ꖬꔨꗵꘋ";
        final Object[][] data = new Object[][] {
            { "AC", "ꗻꗡ ꕒꕡꕌ ꗏ ꔳꘋꗣ" },
            { "AD", "ꕉꖆꕟ" },
            { "AE", "ꖳꕯꔤꗳ ꕉꕟꔬ ꗡꕆꔓꔻ" },
            { "AF", "ꕉꔱꕭꔕꔻꕚꘋ" },
            { "AG", "ꕉꘋꔳꖶꕎ ꗪ ꕑꖜꕜ" },
            { "AI", "ꕉꕄꕞ" },
            { "AL", "ꕉꔷꕑꕇꕩ" },
            { "AM", "ꕉꕆꕯ" },
            { "AO", "ꕉꖐꕞ" },
            { "AQ", "ꕉꘋꕚꔳꕪ" },
            { "AR", "ꕉꘀꘋꔳꕯ" },
            { "AS", "ꕶꕱ ꕢꕹꕎ" },
            { "AT", "ꖺꔻꖤꕎ" },
            { "AU", "ꖺꖬꖤꔃꔷꕩ" },
            { "AW", "ꕉꖩꕑ" },
            { "AX", "ꕉꕞꔺ" },
            { "AZ", "ꕉꕤꕑꔤꕧꘋ" },
            { "BA", "ꕷꔻꕇꕰ ꗪ ꗥꕤꖑꔲꕯ" },
            { "BB", "ꕑꔆꖁꔻ" },
            { "BD", "ꕑꕅꕞꗵꔼ" },
            { "BE", "ꗩꕀꗚꘋ" },
            { "BF", "ꕷꕃꕯ ꕘꖇ" },
            { "BG", "ꗂꔠꔸꕩ" },
            { "BH", "ꕑꗸꘋ" },
            { "BI", "ꖜꖩꔺ" },
            { "BJ", "ꗩꕇꘋ" },
            { "BL", "ꕪꘋꕓ ꗞꗢ ꕒꕚꕞꕆ" },
            { "BM", "ꗩꖷꕜ" },
            { "BN", "ꖜꖩꘉꔧ" },
            { "BO", "ꕷꔷꔲꕩ" },
            { "BQ", "ꕪꔓꔬꘂꘋ ꖨꕮ ꗨꗳꗣ" },
            { "BR", "ꖜꕟꔘꔀ" },
            { "BS", "ꕑꕌꕮꔻ" },
            { "BT", "ꖜꕚꘋ" },
            { "BV", "ꖜꔍꔳ ꔳꘋꗣ" },
            { "BW", "ꕷꖬꕎꕯ" },
            { "BY", "ꗩꕞꖩꔻ" },
            { "BZ", "ꔆꔷꔘ" },
            { "CA", "ꕪꕯꕜ" },
            { "CC", "ꖏꖏꔻ (ꔞꔀꔷꘋ) ꔳꘋꗣ" },
            { "CD", "ꖏꖐ ꗵꗞꖴꕟꔎ ꕸꖃꔀ" },
            { "CF", "ꕉꔱꔸꕪ ꗳ ꗳ ꕸꖃꔀ" },
            { "CG", "ꖏꖐ" },
            { "CH", "ꖬꔃꕤ ꖨꕮꕊ" },
            { "CI", "ꖏꔳ ꕾꕎ" },
            { "CK", "ꖏꕃ ꔳꘋꗣ" },
            { "CL", "ꔚꔷ" },
            { "CM", "ꕪꔈꖩꘋ" },
            { "CN", "ꕦꔤꕯ" },
            { "CO", "ꗛꗏꔭꕩ" },
            { "CP", "ꕃꔒꕐꗋꘋ ꔳꘋꗣ" },
            { "CR", "ꖏꔻꕚ ꔸꕪ" },
            { "CU", "ꕃꖳꕑ" },
            { "CV", "ꔞꔪ ꗲꔵ ꔳꘋꗣ" },
            { "CW", "ꖴꕟꖇꕱ" },
            { "CX", "ꔞꔻꕮꔻ ꔳꘋꗣ" },
            { "CY", "ꕢꗡꖛꗐꔻ" },
            { "CZ", "ꗿꕃ ꕸꖃꔀ" },
            { "DE", metaValue_DE },
            { "DG", "ꔵꔀꖑ ꔳꘋꗣ" },
            { "DJ", "ꕀꖜꔳ" },
            { "DK", "ꕜꕇꕮꕃ" },
            { "DM", "ꖁꕆꕇꕪ" },
            { "DO", "ꖁꕆꕇꕪꘋ ꕸꕱꔀ" },
            { "DZ", "ꕉꔷꔠꔸꕩ" },
            { "EA", "ꗻꕚ ꗪ ꔡꔷꕞ" },
            { "EC", "ꗡꖴꔃꗍ" },
            { "EE", "ꗡꔻꕿꕇꕰ" },
            { "EG", "ꕆꔖꕞ" },
            { "EH", "ꕢꕌꕟ ꔎꔒ ꕀꔤ" },
            { "ER", "ꔀꔸꔳꕟ" },
            { "ES", metaValue_ES },
            { "ET", "ꔤꔳꖎꔪꕩ" },
            { "FI", "ꔱꘋ ꖨꕮꕊ" },
            { "FJ", "ꔱꔤꕀ" },
            { "FK", "ꕘꔷꕃ ꖨꕮ ꔳꘋꗣ" },
            { "FM", "ꕆꖏꕇꔻꕩ" },
            { "FO", "ꕘꖄ ꔳꘋꗣ" },
            { "FR", "ꖢꕟꘋꔻ" },
            { "GA", "ꕭꕷꘋ" },
            { "GB", "ꖕꕯꔤꗳ" },
            { "GD", "ꖶꕟꕯꕜ" },
            { "GE", "ꗘꖺꕀꕩ" },
            { "GF", "ꗱꘋꔻ ꖶꕎꕯ" },
            { "GG", "ꖶꗦꘋꔻ" },
            { "GH", "ꕭꕌꕯ" },
            { "GI", "ꕀꖜꕟꕚ" },
            { "GL", "ꕧꕓ ꖴꕎ ꖨꕮꕊ" },
            { "GM", "ꕭꔭꕩ" },
            { "GN", "ꕅꔤꕇ" },
            { "GP", "ꖶꕎꔐꖨꔅ" },
            { "GQ", "ꖦꕰꕊ ꗳ ꕅꔤꕇ" },
            { "GR", metaValue_GR },
            { "GS", "ꗘꖺꕀꕩ ꗛꔤ ꔒꘋꗣ ꗏ ꗪ ꗇꖢ ꔳꘋꗣ ꗛꔤ ꔒꘋꗣ ꗏ" },
            { "GT", "ꖶꕎꔎꕮꕞ" },
            { "GU", "ꖶꕎꕆ" },
            { "GW", "ꕅꔤꕇ ꔫꕢꕴ" },
            { "GY", "ꖶꕩꕯ" },
            { "HM", "ꗥꗡꔵ ꗪ ꕮꖁꕯ" },
            { "HN", "ꖽꖫꕟ" },
            { "HR", "ꖏꔓꔻꕩ" },
            { "HT", "ꕌꔤꔳ" },
            { "HU", "ꖽꘋꕭꔓ" },
            { "IC", "ꗛꖺꔻꕩ ꔳꘋꗣ" },
            { "ID", "ꔤꖆꕇꔻꕩ" },
            { "IE", "ꕉꔓ ꖨꕮꕊ" },
            { "IL", "ꕑꕇꔻꕞꔤꕞ" },
            { "IM", "ꕮꘋ ꔳꘋꗣ" },
            { "IN", "ꔤꔺꕩ" },
            { "IQ", "ꔤꕟꕃ" },
            { "IR", "ꔤꕟꘋ" },
            { "IS", "ꕉꔤꔻ ꖨꕮꕊ" },
            { "IT", "ꔤꕚꔷ" },
            { "JE", "ꘀꗡꔘ" },
            { "JM", "ꕧꕮꔧꕪ" },
            { "JO", "ꗘꖺꗵꘋ" },
            { "JP", "ꔛꗨꗢ" },
            { "KE", "ꔞꕰ" },
            { "KG", "ꕃꕅꔻꕚꘋ" },
            { "KH", "ꕪꕹꔵꕩ" },
            { "KI", "ꕃꔸꕑꔳ" },
            { "KM", "ꖏꕹꖄꔻ" },
            { "KN", "ꔻꘋ ꕃꔳꔻ ꗪ ꔕꔲꔻ" },
            { "KP", "ꖏꔸꕩ ꗛꔤ ꕪꘋꗒ" },
            { "KR", "ꖏꔸꕩ ꗛꔤ ꔒꘋꗣ ꗏ" },
            { "KW", "ꖴꔃꔳ" },
            { "KY", "ꔞꔀꕮꘋ ꔳꘋꗣ" },
            { "KZ", "ꕪꕤꔻꕚꘋ" },
            { "LA", "ꕞꕴꔻ" },
            { "LB", "ꔒꕑꗟꘋ" },
            { "LC", "ꔻꘋ ꖨꔻꕩ" },
            { "LI", "ꔷꗿꘋꔻꗳꘋ" },
            { "LK", "ꖬꔸ ꕞꘋꕪ" },
            { "LR", "ꕞꔤꔫꕩ" },
            { "LS", "ꔷꖇꕿ" },
            { "LT", "ꔷꖤꔃꕇꕰ" },
            { "LU", "ꗏꔻꘋꗂꖺ" },
            { "LV", "ꕞꔳꔲꕩ" },
            { "LY", "ꔒꔫꕩ" },
            { "MA", "ꗞꕟꖏ" },
            { "MC", "ꗞꕯꖏ" },
            { "MD", "ꖒꔷꖁꕙ" },
            { "ME", "ꗞꔳꕇꖶꖄ" },
            { "MF", "ꕪꘋꕓ ꗞꗢ ꕮꕊꔳꘋ" },
            { "MG", "ꕮꕜꕭꔻꕪ" },
            { "MH", "ꕮꕊꕣ ꔳꘋꗣ" },
            { "ML", "ꕮꔷ" },
            { "MM", "ꕆꕩꘋꕮ" },
            { "MN", "ꗞꖐꔷꕩ" },
            { "MO", "ꕮꗛꖺ" },
            { "MP", "ꗛꔤ ꕪꘋꗒ ꕮꔸꕩꕯ ꔳꘋꗣ" },
            { "MQ", "ꕮꔳꕇꕃ" },
            { "MR", "ꗞꔓꔎꕇꕰ" },
            { "MS", "ꗞꘋꔖꕟꔳ" },
            { "MT", "ꕮꕊꕚ" },
            { "MU", "ꗞꔓꗔ" },
            { "MV", "ꕮꔷꕜꔍ" },
            { "MW", "ꕮꕞꕌꔨ" },
            { "MX", "ꘈꔻꖏ" },
            { "MY", "ꕮꔒꔻꕩ" },
            { "MZ", "ꕹꕤꔭꕃ" },
            { "NA", "ꕯꕆꔫꕩ" },
            { "NC", "ꕪꔷꖁꕇꕰ ꕯꕮꕊ" },
            { "NE", "ꕯꔤꕧ" },
            { "NF", "ꗟꖺꗉ ꔳꘋꗣ" },
            { "NG", "ꕯꔤꕀꔸꕩ" },
            { "NI", "ꕇꕪꕟꖶꕎ" },
            { "NL", "ꘉꕜ ꖨꕮꕊ" },
            { "NO", "ꗟꖺꔃ" },
            { "NP", metaValue_NP },
            { "NR", "ꖆꖩ" },
            { "NU", "ꖸꔃꔤ" },
            { "NZ", "ꔽꔤ ꖨꕮ ꕯꕮꕊ" },
            { "OM", "ꕱꕮꘋ" },
            { "PA", "ꕐꕯꕮ" },
            { "PE", "ꗨꗡꖩ" },
            { "PF", "ꗱꘋꔻ ꕶꔷꕇꔻꕩ" },
            { "PG", "ꕐꖛꕎ ꕅꔤꕇ ꕯꕮꕊ" },
            { "PH", "ꔱꔒꔪꘋ" },
            { "PK", "ꕐꕃꔻꕚꘋ" },
            { "PL", "ꕶꗷꘋ" },
            { "PM", "ꔻꘋ ꔪꘂ ꗪ ꕆꔞꗏꘋ" },
            { "PN", "ꔪꔳꕪꕆ" },
            { "PR", "ꔪꖳꕿ ꔸꖏ" },
            { "PS", "ꕐꔒꔻꔳꕯ ꔎꔒ ꕀꔤ ꗛꔤ ꕞ ꗱ ꗪ ꕭꕌꕤ" },
            { "PT", "ꕶꕿꕃꔤ ꕸꖃꔀ" },
            { "PW", "ꕐꖃ" },
            { "PY", "ꕐꕟꗝꔀ" },
            { "QA", "ꕪꕚꕌ" },
            { "RE", "ꔓꗠꖻ" },
            { "RO", "ꖄꕆꕇꕰ" },
            { "RS", "ꗻꗡꔬꕩ" },
            { "RU", "ꗐꖺꔻꕩ" },
            { "RW", metaValue_RW },
            { "SA", "ꕞꕌꖝ ꕸꖃꔀ" },
            { "SB", "ꖬꕞꔤꕮꕊꕯ ꔳꘋꗣ" },
            { "SC", "ꔖꗼꔷ" },
            { "SD", "ꖬꗵꘋ" },
            { "SE", metaValue_SE },
            { "SG", "ꔻꕬꕶꕱ" },
            { "SH", "ꔻꘋ ꗥꔷꕯ" },
            { "SI", "ꔻꖃꔍꕇꕰ" },
            { "SJ", "ꔻꕙꕒꔵ ꗪ ꕧꘋ ꕮꘂꘋ" },
            { "SK", "ꔻꖃꕙꕃꕩ" },
            { "SL", "ꔋꕩ ꕒꕌꖺ ꕸꖃꔀ" },
            { "SM", "ꕮꔸꖆ ꕢꘋ" },
            { "SN", "ꔻꕇꕭꕌ" },
            { "SO", "ꖇꕮꔷꕩ" },
            { "SR", "ꖬꔸꕯꔈ" },
            { "SS", "ꖬꕜꘋ ꗛꔤ ꔒꘋꗣ ꗏ" },
            { "ST", "ꕢꕴ ꕿꔈ ꗪ ꕉ ꕮꔧ ꕗꕴꔀ" },
            { "SV", "ꗡꗷ ꕢꔍꗍꖺ" },
            { "SX", "ꔻꘋꔳ ꕮꕊꗳꘋ" },
            { "SY", "ꔻꕩꘋ" },
            { "SZ", "ꖬꕎꔽ ꖨꕮꕊ" },
            { "TA", "ꔳꔻꕚꘋ ꕜ ꖴꕯ" },
            { "TC", "ꗋꖺꕃꔻ ꗪ ꕪꔤꖏꔻ ꔳꘋꗣ" },
            { "TD", "ꕦꔵ" },
            { "TF", "ꔱꗷꘋꔻ ꗛꔤ ꔒꘋꗣ ꗏ ꕸꖃꔀ ꖸ" },
            { "TG", "ꕿꖑ" },
            { "TH", "ꕚꔤ ꖨꕮꕊ" },
            { "TJ", "ꕚꕀꕃꔻꕚꘋ" },
            { "TK", "ꕿꔞꖃ" },
            { "TL", "ꔎꔒ ꗃ ꔳꗞꖻ" },
            { "TM", "ꗋꖺꕃꕮꕇꔻꕚꘋ" },
            { "TN", "ꖤꕇꔻꕩ" },
            { "TO", "ꗋꕬ" },
            { "TR", "ꗋꖺꕃ" },
            { "TT", "ꖤꔸꔕꕜ ꗪ ꕿꔆꖑ" },
            { "TV", "ꕚꖣꖨ" },
            { "TW", "ꕚꔤꕎꘋ" },
            { "TZ", "ꕚꘋꕤꕇꕰ" },
            { "UA", "ꖳꖴꔓꘋ" },
            { "UG", "ꖳꕭꕡ" },
            { "UM", "ꕶꕱ ꕪꘋ ꗅꘋ ꔳꘋꗣ ꖸ" },
            { "US", metaValue_US },
            { "UY", "ꖳꔓꗝꔀ" },
            { "UZ", "ꖳꗩꕃꔻꕚꘋ" },
            { "VA", "ꕙꔳꕪꘋ ꕢꕨꕌ" },
            { "VC", "ꔻꘋ ꔲꘋꔻꘋ ꗪ ꖶꔓꕯꔵꘋ ꖸ" },
            { "VE", "ꕙꔳꕪꘋ ꕸꖃꔀ" },
            { "VG", "ꔛꔟꔻ ꗩꗡ ꗏ ꖷꖬ ꔳꘋꗣ" },
            { "VI", "ꕶꕱ ꗩꗡ ꗏ ꖷꖬ ꔳꘋꗣ" },
            { "VN", "ꗲꕇꖮꔃꕞ" },
            { "VU", "ꕙꖸꕎꖤ" },
            { "WF", "ꕎꔷꔻ ꗪ ꖢꖤꕯ" },
            { "WS", "ꕢꕹꖙꕉ" },
            { "XK", "ꖏꖇꕾ" },
            { "YE", "ꔝꘈꘋ" },
            { "YT", "ꕮꗚꔎ" },
            { "ZA", "ꕉꔱꔸꕪ ꗛꔤ ꔒꘋꗣ ꗏ ꕸꖃꔀ" },
            { "ZM", "ꕤꔭꕩ" },
            { "ZW", "ꔽꕓꖜꔃ" },
            { "ak", "ꕉꕪꘋ" },
            { "am", "ꕉꕆꕌꔸ" },
            { "ar", "ꕞꕌꖝ" },
            { "be", "ꔆꕞꖩꔻ" },
            { "bg", "ꗂꔠꗸꘋ" },
            { "bn", "ꗩꕭꔷ" },
            { "cs", "ꗿꗡ" },
            { "de", metaValue_DE },
            { "el", metaValue_GR },
            { "en", metaValue_US },
            { "es", metaValue_ES },
            { "fa", "ꗨꗡꔻꘂꘋ" },
            { "fr", "ꗱꘋꔻ" },
            { "ha", "ꕌꖙꕢ" },
            { "hi", "ꔦꔺ" },
            { "hu", "ꖽꔟꗸꘋ" },
            { "id", "ꔤꖆꕇꔻꘂꘋ" },
            { "ig", "ꔤꕼ" },
            { "it", "ꔤꕚꔷꘂꘋ" },
            { "ja", "ꕧꕐꕇꔧ" },
            { "jv", "ꕧꕙꕇꔧ" },
            { "km", "ꕃꘈꗢ" },
            { "ko", "ꖏꔸꘂꘋ" },
            { "ms", "ꕮꔒꔀ" },
            { "my", "ꗩꕆꔻ" },
            { "ne", metaValue_NP },
            { "nl", "ꗍꔿ" },
            { "pa", "ꖛꕨꔬ" },
            { "pl", "ꗁꔒꔻ" },
            { "pt", "ꕶꕿꕃꔤ" },
            { "ro", "ꖄꕆꕇꘂꘋ" },
            { "ru", "ꗐꖺꔻꘂꘋ" },
            { "rw", metaValue_RW },
            { "so", "ꖇꕮꔷ" },
            { "sv", metaValue_SE },
            { "ta", "ꕚꕆꔷ" },
            { "th", "ꕚꔤ" },
            { "tr", "ꗋꕃ" },
            { "uk", "ꖳꖴꔓꕇꘂꘋ" },
            { "ur", "ꖺꖦ" },
            { "vi", "ꔲꕩꕯꕆꔧ" },
            { "yo", "ꖎꖄꕑ" },
            { "zh", "ꕦꕇꔧ" },
            { "zu", "ꖮꖨ" },
            { "vai", "ꕙꔤ" },
        };
        return data;
    }
}
