/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_gu extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TV = "તુવાલુ";
        final String metaValue_ar = "અરબી";
        final String metaValue_ae = "અવેસ્તન";
        final String metaValue_zbl = "બ્લિસિમ્બોલ્સ";
        final String metaValue_ccp = "ચકમા";
        final String metaValue_cop = "કોપ્ટિક";
        final String metaValue_got = "ગોથિક";
        final String metaValue_el = "ગ્રીક";
        final String metaValue_gu = "ગુજરાતી";
        final String metaValue_he = "હીબ્રુ";
        final String metaValue_jv = "જાવાનીસ";
        final String metaValue_km = "ખ્મેર";
        final String metaValue_ko = "કોરિયન";
        final String metaValue_lo = "લાઓ";
        final String metaValue_la = "લેટિન";
        final String metaValue_ml = "મલયાલમ";
        final String metaValue_mn = "મોંગોલિયન";
        final String metaValue_or = "ઉડિયા";
        final String metaValue_phn = "ફોનિશિયન";
        final String metaValue_ta = "તમિલ";
        final String metaValue_te = "તેલુગુ";
        final String metaValue_vai = "વાઇ";
        final Object[][] data = new Object[][] {
            { "001", "વિશ્વ" },
            { "002", "આફ્રિકા" },
            { "003", "ઉત્તર અમેરિકા" },
            { "005", "દક્ષિણ અમેરિકા" },
            { "009", "ઓશનિયા" },
            { "011", "પશ્ચિમી આફ્રિકા" },
            { "013", "મધ્ય અમેરિકા" },
            { "014", "પૂર્વીય આફ્રિકા" },
            { "015", "ઉત્તરી આફ્રિકા" },
            { "017", "મધ્ય આફ્રિકા" },
            { "018", "સધર્ન આફ્રિકા" },
            { "019", "અમેરિકા" },
            { "021", "ઉત્તરી અમેરિકા" },
            { "029", "કેરિબિયન" },
            { "030", "પૂર્વીય એશિયા" },
            { "034", "દક્ષિણ એશિયા" },
            { "035", "દક્ષિણપૂર્વ એશિયા" },
            { "039", "દક્ષિણ યુરોપ" },
            { "053", "ઓસ્ટ્રેલેશિયા" },
            { "054", "મેલાનેશિયા" },
            { "057", "માઈક્રોનેશિયન ક્ષેત્ર" },
            { "061", "પોલિનેશિયા" },
            { "142", "એશિયા" },
            { "143", "મધ્ય એશિયા" },
            { "145", "પશ્ચિમી એશિયા" },
            { "150", "યુરોપ" },
            { "151", "પૂર્વીય યુરોપ" },
            { "154", "ઉત્તરીય યુરોપ" },
            { "155", "પશ્ચિમી યુરોપ" },
            { "202", "સબ-સહારન આફ્રિકા" },
            { "419", "લેટિન અમેરિકા" },
            { "AC", "એસેન્શન આઇલેન્ડ" },
            { "AD", "એન્ડોરા" },
            { "AE", "યુનાઇટેડ આરબ અમીરાત" },
            { "AF", "અફઘાનિસ્તાન" },
            { "AG", "ઍન્ટિગુઆ અને બર્મુડા" },
            { "AI", "ઍંગ્વિલા" },
            { "AL", "અલ્બેનિયા" },
            { "AM", "આર્મેનિયા" },
            { "AO", "અંગોલા" },
            { "AQ", "એન્ટાર્કટિકા" },
            { "AR", "આર્જેન્ટીના" },
            { "AS", "અમેરિકન સમોઆ" },
            { "AT", "ઑસ્ટ્રિયા" },
            { "AU", "ઑસ્ટ્રેલિયા" },
            { "AW", "અરુબા" },
            { "AX", "ઑલૅન્ડ આઇલૅન્ડ્સ" },
            { "AZ", "અઝરબૈજાન" },
            { "BA", "બોસ્નિયા અને હર્ઝેગોવિના" },
            { "BB", "બારબાડોસ" },
            { "BD", "બાંગ્લાદેશ" },
            { "BE", "બેલ્જીયમ" },
            { "BF", "બુર્કિના ફાસો" },
            { "BG", "બલ્ગેરિયા" },
            { "BH", "બેહરીન" },
            { "BI", "બુરુંડી" },
            { "BJ", "બેનિન" },
            { "BL", "સેંટ બાર્થેલેમી" },
            { "BM", "બર્મુડા" },
            { "BN", "બ્રુનેઇ" },
            { "BO", "બોલિવિયા" },
            { "BQ", "કેરેબિયન નેધરલેન્ડ્ઝ" },
            { "BR", "બ્રાઝિલ" },
            { "BS", "બહામાસ" },
            { "BT", "ભૂટાન" },
            { "BV", "બૌવેત આઇલૅન્ડ" },
            { "BW", "બોત્સ્વાના" },
            { "BY", "બેલારુસ" },
            { "BZ", "બેલીઝ" },
            { "CA", "કેનેડા" },
            { "CC", "કોકોઝ (કીલીંગ) આઇલૅન્ડ્સ" },
            { "CD", "કોંગો - કિંશાસા" },
            { "CF", "સેન્ટ્રલ આફ્રિકન રિપબ્લિક" },
            { "CG", "કોંગો - બ્રાઝાવિલે" },
            { "CH", "સ્વિટ્ઝર્લૅન્ડ" },
            { "CI", "કોટ ડીઆઇવરી" },
            { "CK", "કુક આઇલેન્ડ્સ" },
            { "CL", "ચિલી" },
            { "CM", "કૅમરૂન" },
            { "CN", "ચીન" },
            { "CO", "કોલંબિયા" },
            { "CP", "ક્લિપરટન આઇલેન્ડ" },
            { "CQ", "સાર્ક" },
            { "CR", "કોસ્ટા રિકા" },
            { "CU", "ક્યુબા" },
            { "CV", "કૅપ વર્ડે" },
            { "CW", "ક્યુરાસાઓ" },
            { "CX", "ક્રિસમસ આઇલૅન્ડ" },
            { "CY", "સાયપ્રસ" },
            { "CZ", "ચેકીયા" },
            { "DE", "જર્મની" },
            { "DG", "ડિએગો ગારસિઆ" },
            { "DJ", "જીબૌટી" },
            { "DK", "ડેનમાર્ક" },
            { "DM", "ડોમિનિકા" },
            { "DO", "ડોમિનિકન રિપબ્લિક" },
            { "DZ", "અલ્જીરિયા" },
            { "EA", "સ્યુટા અને મેલિલા" },
            { "EC", "એક્વાડોર" },
            { "EE", "એસ્ટોનિયા" },
            { "EG", "ઇજિપ્ત" },
            { "EH", "પશ્ચિમી સહારા" },
            { "ER", "એરિટ્રિયા" },
            { "ES", "સ્પેન" },
            { "ET", "ઇથિઓપિયા" },
            { "EU", "યુરોપિયન સંઘ" },
            { "EZ", "યુરોઝોન" },
            { "FI", "ફિનલેન્ડ" },
            { "FJ", "ફીજી" },
            { "FK", "ફૉકલૅન્ડ આઇલૅન્ડ્સ" },
            { "FM", "માઇક્રોનેશિયા" },
            { "FO", "ફેરો આઇલૅન્ડ્સ" },
            { "FR", "ફ્રાંસ" },
            { "GA", "ગેબન" },
            { "GB", "યુનાઇટેડ કિંગડમ" },
            { "GD", "ગ્રેનેડા" },
            { "GE", "જ્યોર્જિયા" },
            { "GF", "ફ્રેંચ ગયાના" },
            { "GG", "ગ્વેર્નસે" },
            { "GH", "ઘાના" },
            { "GI", "જીબ્રાલ્ટર" },
            { "GL", "ગ્રીનલેન્ડ" },
            { "GM", "ગેમ્બિયા" },
            { "GN", "ગિની" },
            { "GP", "ગ્વાડેલોપ" },
            { "GQ", "ઇક્વેટોરિયલ ગિની" },
            { "GR", "ગ્રીસ" },
            { "GS", "દક્ષિણ જ્યોર્જિયા અને દક્ષિણ સેન્ડવિચ આઇલેન્ડ્સ" },
            { "GT", "ગ્વાટેમાલા" },
            { "GU", "ગ્વામ" },
            { "GW", "ગિની-બિસાઉ" },
            { "GY", "ગયાના" },
            { "HK", "હોંગકોંગ SAR ચીન" },
            { "HM", "હર્ડ અને મેકડોનાલ્ડ આઇલૅન્ડ્સ" },
            { "HN", "હોન્ડુરસ" },
            { "HR", "ક્રોએશિયા" },
            { "HT", "હૈતિ" },
            { "HU", "હંગેરી" },
            { "IC", "કૅનેરી આઇલેન્ડ્સ" },
            { "ID", "ઇન્ડોનેશિયા" },
            { "IE", "આયરલૅન્ડ" },
            { "IL", "ઇઝરાઇલ" },
            { "IM", "આઇલ ઑફ મેન" },
            { "IN", "ભારત" },
            { "IO", "બ્રિટિશ ઇન્ડિયન ઓશન ટેરિટરી" },
            { "IQ", "ઇરાક" },
            { "IR", "ઈરાન" },
            { "IS", "આઇસલૅન્ડ" },
            { "IT", "ઇટાલી" },
            { "JE", "જર્સી" },
            { "JM", "જમૈકા" },
            { "JO", "જોર્ડન" },
            { "JP", "જાપાન" },
            { "KE", "કેન્યા" },
            { "KG", "કિર્ગિઝ્સ્તાન" },
            { "KH", "કંબોડિયા" },
            { "KI", "કિરિબાટી" },
            { "KM", "કોમોરસ" },
            { "KN", "સેંટ કિટ્સ અને નેવિસ" },
            { "KP", "ઉત્તર કોરિયા" },
            { "KR", "દક્ષિણ કોરિયા" },
            { "KW", "કુવૈત" },
            { "KY", "કેમેન આઇલેન્ડ્સ" },
            { "KZ", "કઝાકિસ્તાન" },
            { "LA", "લાઓસ" },
            { "LB", "લેબનોન" },
            { "LC", "સેંટ લુસિયા" },
            { "LI", "લૈચટેંસ્ટેઇન" },
            { "LK", "શ્રીલંકા" },
            { "LR", "લાઇબેરિયા" },
            { "LS", "લેસોથો" },
            { "LT", "લિથુઆનિયા" },
            { "LU", "લક્ઝમબર્ગ" },
            { "LV", "લાત્વિયા" },
            { "LY", "લિબિયા" },
            { "MA", "મોરોક્કો" },
            { "MC", "મોનાકો" },
            { "MD", "મોલડોવા" },
            { "ME", "મૉન્ટેનેગ્રો" },
            { "MF", "સેંટ માર્ટિન" },
            { "MG", "મેડાગાસ્કર" },
            { "MH", "માર્શલ આઇલેન્ડ્સ" },
            { "MK", "ઉત્તર મેસેડોનિયા" },
            { "ML", "માલી" },
            { "MM", "મ્યાંમાર (બર્મા)" },
            { "MN", "મંગોલિયા" },
            { "MO", "મકાઉ SAR ચીન" },
            { "MP", "ઉત્તરી મારિયાના આઇલેન્ડ્સ" },
            { "MQ", "માર્ટીનીક" },
            { "MR", "મૌરિટાનિયા" },
            { "MS", "મોંટસેરાત" },
            { "MT", "માલ્ટા" },
            { "MU", "મોરિશિયસ" },
            { "MV", "માલદિવ્સ" },
            { "MW", "માલાવી" },
            { "MX", "મેક્સિકો" },
            { "MY", "મલેશિયા" },
            { "MZ", "મોઝામ્બિક" },
            { "NA", "નામિબિયા" },
            { "NC", "ન્યુ સેલેડોનિયા" },
            { "NE", "નાઇજર" },
            { "NF", "નોરફોક આઇલેન્ડ્સ" },
            { "NG", "નાઇજેરિયા" },
            { "NI", "નિકારાગુઆ" },
            { "NL", "નેધરલેન્ડ્સ" },
            { "NO", "નૉર્વે" },
            { "NP", "નેપાળ" },
            { "NR", "નૌરુ" },
            { "NU", "નીયુ" },
            { "NZ", "ન્યુઝીલૅન્ડ" },
            { "OM", "ઓમાન" },
            { "PA", "પનામા" },
            { "PE", "પેરુ" },
            { "PF", "ફ્રેંચ પોલિનેશિયા" },
            { "PG", "પાપુઆ ન્યૂ ગિની" },
            { "PH", "ફિલિપિન્સ" },
            { "PK", "પાકિસ્તાન" },
            { "PL", "પોલેંડ" },
            { "PM", "સેંટ પીએરી અને મિક્યુલોન" },
            { "PN", "પીટકૈર્ન આઇલેન્ડ્સ" },
            { "PR", "પ્યુઅર્ટો રિકો" },
            { "PS", "પેલેસ્ટિનિયન ટેરિટરી" },
            { "PT", "પોર્ટુગલ" },
            { "PW", "પલાઉ" },
            { "PY", "પેરાગ્વે" },
            { "QA", "કતાર" },
            { "QO", "આઉટલાઈન્ગ ઓશનિયા" },
            { "RE", "રીયુનિયન" },
            { "RO", "રોમાનિયા" },
            { "RS", "સર્બિયા" },
            { "RU", "રશિયા" },
            { "RW", "રવાંડા" },
            { "SA", "સાઉદી અરેબિયા" },
            { "SB", "સોલોમન આઇલેન્ડ્સ" },
            { "SC", "સેશેલ્સ" },
            { "SD", "સુદાન" },
            { "SE", "સ્વીડન" },
            { "SG", "સિંગાપુર" },
            { "SH", "સેંટ હેલેના" },
            { "SI", "સ્લોવેનિયા" },
            { "SJ", "સ્વાલબર્ડ અને જેન મેયન" },
            { "SK", "સ્લોવેકિયા" },
            { "SL", "સીએરા લેઓન" },
            { "SM", "સૅન મેરિનો" },
            { "SN", "સેનેગલ" },
            { "SO", "સોમાલિયા" },
            { "SR", "સુરીનામ" },
            { "SS", "દક્ષિણ સુદાન" },
            { "ST", "સાઓ ટૉમ અને પ્રિંસિપે" },
            { "SV", "એલ સેલ્વાડોર" },
            { "SX", "સિંટ માર્ટેન" },
            { "SY", "સીરિયા" },
            { "SZ", "એસ્વાટીની" },
            { "TA", "ત્રિસ્તાન દા કુન્હા" },
            { "TC", "તુર્ક્સ અને કેકોઝ આઇલેન્ડ્સ" },
            { "TD", "ચાડ" },
            { "TF", "ફ્રેંચ સધર્ન ટેરિટરીઝ" },
            { "TG", "ટોગો" },
            { "TH", "થાઇલેંડ" },
            { "TJ", "તાજીકિસ્તાન" },
            { "TK", "ટોકેલાઉ" },
            { "TL", "તિમોર-લેસ્તે" },
            { "TM", "તુર્કમેનિસ્તાન" },
            { "TN", "ટ્યુનિશિયા" },
            { "TO", "ટોંગા" },
            { "TR", "તુર્કિયે" },
            { "TT", "ટ્રિનીદાદ અને ટોબેગો" },
            { "TV", metaValue_TV },
            { "TW", "તાઇવાન" },
            { "TZ", "તાંઝાનિયા" },
            { "UA", "યુક્રેન" },
            { "UG", "યુગાંડા" },
            { "UM", "યુ.એસ. આઉટલાઇનિંગ આઇલેન્ડ્સ" },
            { "UN", "સંયુક્ત રાષ્ટ્ર" },
            { "US", "યુનાઇટેડ સ્ટેટ્સ" },
            { "UY", "ઉરુગ્વે" },
            { "UZ", "ઉઝ્બેકિસ્તાન" },
            { "VA", "વેટિકન સિટી" },
            { "VC", "સેંટ વિન્સેંટ અને ગ્રેનેડાઇંસ" },
            { "VE", "વેનેઝુએલા" },
            { "VG", "બ્રિટિશ વર્જિન આઇલેન્ડ્સ" },
            { "VI", "યુએસ વર્જિન આઇલેન્ડ્સ" },
            { "VN", "વિયેતનામ" },
            { "VU", "વાનુઆતુ" },
            { "WF", "વૉલિસ અને ફ્યુચુના" },
            { "WS", "સમોઆ" },
            { "XA", "સ્યુડો-ઍક્સન્ટ" },
            { "XB", "સ્યુડો-દ્વિદિશ" },
            { "XK", "કોસોવો" },
            { "YE", "યમન" },
            { "YT", "મેયોટ" },
            { "ZA", "દક્ષિણ આફ્રિકા" },
            { "ZM", "ઝામ્બિયા" },
            { "ZW", "ઝિમ્બાબ્વે" },
            { "ZZ", "અજ્ઞાત પ્રદેશ" },
            { "aa", "અફાર" },
            { "ab", "અબખાજિયન" },
            { "ae", metaValue_ae },
            { "af", "આફ્રિકન્સ" },
            { "ak", "અકાન" },
            { "am", "એમ્હારિક" },
            { "an", "અર્ગોનીઝ" },
            { "ar", metaValue_ar },
            { "as", "આસામી" },
            { "av", "અવેરિક" },
            { "ay", "આયમારા" },
            { "az", "અઝરબૈજાની" },
            { "ba", "બશ્કીર" },
            { "be", "બેલારુશિયન" },
            { "bg", "બલ્ગેરિયન" },
            { "bi", "બિસ્લામા" },
            { "bm", "બામ્બારા" },
            { "bn", "બાંગ્લા" },
            { "bo", "તિબેટીયન" },
            { "br", "બ્રેટોન" },
            { "bs", "બોસ્નિયન" },
            { "ca", "કતલાન" },
            { "ce", "ચેચન" },
            { "ch", "કેમોરો" },
            { "co", "કોર્સિકન" },
            { "cr", "ક્રી" },
            { "cs", "ચેક" },
            { "cu", "ચર્ચ સ્લાવિક" },
            { "cv", "ચૂવાશ" },
            { "cy", "વેલ્શ" },
            { "da", "ડેનિશ" },
            { "de", "જર્મન" },
            { "dv", "દિવેહી" },
            { "dz", "ડ્ઝોંગ્ખા" },
            { "ee", "ઈવ" },
            { "el", metaValue_el },
            { "en", "અંગ્રેજી" },
            { "eo", "એસ્પેરાન્ટો" },
            { "es", "સ્પેનિશ" },
            { "et", "એસ્ટોનિયન" },
            { "eu", "બાસ્ક" },
            { "fa", "ફારસી" },
            { "ff", "ફુલા" },
            { "fi", "ફિનિશ" },
            { "fj", "ફીજીયન" },
            { "fo", "ફોરિસ્ત" },
            { "fr", "ફ્રેન્ચ" },
            { "fy", "પશ્ચિમિ ફ્રિશિયન" },
            { "ga", "આઇરિશ" },
            { "gd", "સ્કોટીસ ગેલિક" },
            { "gl", "ગેલિશિયન" },
            { "gn", "ગુઆરાની" },
            { "gu", metaValue_gu },
            { "gv", "માંક્સ" },
            { "ha", "હૌસા" },
            { "he", metaValue_he },
            { "hi", "હિન્દી" },
            { "ho", "હિરી મોટૂ" },
            { "hr", "ક્રોએશિયન" },
            { "ht", "હૈતિઅન ક્રેઓલે" },
            { "hu", "હંગેરિયન" },
            { "hy", "આર્મેનિયન" },
            { "hz", "હેરેરો" },
            { "ia", "ઇંટરલિંગુઆ" },
            { "id", "ઇન્ડોનેશિયન" },
            { "ie", "ઇંટરલિંગ" },
            { "ig", "ઇગ્બો" },
            { "ii", "સિચુઆન યી" },
            { "ik", "ઇનુપિયાક" },
            { "io", "ઈડો" },
            { "is", "આઇસલેન્ડિક" },
            { "it", "ઇટાલિયન" },
            { "iu", "ઇનુકિટૂટ" },
            { "ja", "જાપાનીઝ" },
            { "jv", metaValue_jv },
            { "ka", "જ્યોર્જિયન" },
            { "kg", "કોંગો" },
            { "ki", "કિકુયૂ" },
            { "kj", "ક્વાન્યામા" },
            { "kk", "કઝાખ" },
            { "kl", "કલાલ્લિસુત" },
            { "km", metaValue_km },
            { "kn", "કન્નડ" },
            { "ko", metaValue_ko },
            { "kr", "કનુરી" },
            { "ks", "કાશ્મીરી" },
            { "ku", "કુરમાનજી" },
            { "kv", "કોમી" },
            { "kw", "કોર્નિશ" },
            { "ky", "કિર્ગીઝ" },
            { "la", metaValue_la },
            { "lb", "લક્ઝેમબર્ગિશ" },
            { "lg", "ગાંડા" },
            { "li", "લિંબૂર્ગિશ" },
            { "ln", "લિંગાલા" },
            { "lo", metaValue_lo },
            { "lt", "લિથુઆનિયન" },
            { "lu", "લૂબા-કટાંગા" },
            { "lv", "લાતવિયન" },
            { "mg", "મલાગસી" },
            { "mh", "માર્શલીઝ" },
            { "mi", "માઓરી" },
            { "mk", "મેસેડોનિયન" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "મરાઠી" },
            { "ms", "મલય" },
            { "mt", "માલ્ટિઝ" },
            { "my", "બર્મીઝ" },
            { "na", "નાઉરૂ" },
            { "nb", "નોર્વેજિયન બોકમાલ" },
            { "nd", "ઉત્તર દેબેલ" },
            { "ne", "નેપાળી" },
            { "ng", "ડોન્ગા" },
            { "nl", "ડચ" },
            { "nn", "નોર્વેજિયન નાયનૉર્સ્ક" },
            { "no", "નૉર્વેજીયન" },
            { "nr", "દક્ષિણ દેબેલ" },
            { "nv", "નાવાજો" },
            { "ny", "ન્યાન્જા" },
            { "oc", "ઓક્સિટન" },
            { "oj", "ઓજિબ્વા" },
            { "om", "ઓરોમો" },
            { "or", metaValue_or },
            { "os", "ઓસ્સેટિક" },
            { "pa", "પંજાબી" },
            { "pi", "પાલી" },
            { "pl", "પોલીશ" },
            { "ps", "પશ્તો" },
            { "pt", "પોર્ટુગીઝ" },
            { "qu", "ક્વેચુઆ" },
            { "rm", "રોમાન્શ" },
            { "rn", "રૂન્દી" },
            { "ro", "રોમાનિયન" },
            { "ru", "રશિયન" },
            { "rw", "કિન્યારવાન્ડા" },
            { "sa", "સંસ્કૃત" },
            { "sc", "સાર્દિનિયન" },
            { "sd", "સિંધી" },
            { "se", "ઉત્તરી સામી" },
            { "sg", "સાંગો" },
            { "sh", "સર્બો-ક્રોએશિયન" },
            { "si", "સિંહાલી" },
            { "sk", "સ્લોવૅક" },
            { "sl", "સ્લોવેનિયન" },
            { "sm", "સામોન" },
            { "sn", "શોના" },
            { "so", "સોમાલી" },
            { "sq", "અલ્બેનિયન" },
            { "sr", "સર્બિયન" },
            { "ss", "સ્વાતી" },
            { "st", "દક્ષિણ સોથો" },
            { "su", "સંડેનીઝ" },
            { "sv", "સ્વીડિશ" },
            { "sw", "સ્વાહિલી" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "તાજીક" },
            { "th", "થાઈ" },
            { "ti", "ટાઇગ્રિનિયા" },
            { "tk", "તુર્કમેન" },
            { "tl", "ટાગાલોગ" },
            { "tn", "ત્સ્વાના" },
            { "to", "ટોંગાન" },
            { "tr", "ટર્કિશ" },
            { "ts", "સોંગા" },
            { "tt", "તતાર" },
            { "tw", "ટ્વાઇ" },
            { "ty", "તાહિતિયન" },
            { "ug", "ઉઇગુર" },
            { "uk", "યુક્રેનિયન" },
            { "ur", "ઉર્દૂ" },
            { "uz", "ઉઝ્બેક" },
            { "ve", "વેન્દા" },
            { "vi", "વિયેતનામીસ" },
            { "vo", "વોલાપુક" },
            { "wa", "વાલૂન" },
            { "wo", "વોલોફ" },
            { "xh", "ખોસા" },
            { "yi", "યિદ્દિશ" },
            { "yo", "યોરૂબા" },
            { "za", "ઝુઆગ" },
            { "zh", "ચાઇનીઝ" },
            { "zu", "ઝુલુ" },
            { "ace", "અચીની" },
            { "ach", "એકોલી" },
            { "ada", "અદાંગ્મી" },
            { "ady", "અદિઘે" },
            { "afh", "અફ્રિહિલી" },
            { "agq", "અઘેમ" },
            { "ain", "ઐનુ" },
            { "akk", "અક્કાદીયાન" },
            { "ale", "અલેઉત" },
            { "alt", "દક્ષિણ અલ્તાઇ" },
            { "ang", "જુની અંગ્રેજી" },
            { "ann", "ઓબોલો" },
            { "anp", "અંગીકા" },
            { "arc", "એરમૈક" },
            { "arn", "મેપુચે" },
            { "arp", "અરાપાહો" },
            { "arq", "આલ્જેરિયન અરબી" },
            { "ars", "નજદી અરેબિક" },
            { "arw", "અરાવક" },
            { "ary", "મોરોક્કન અરબી" },
            { "arz", "ઈજિપ્શિયન અરબી" },
            { "asa", "અસુ" },
            { "ast", "અસ્તુરિયન" },
            { "atj", "એટીકામેકવ" },
            { "awa", "અવધી" },
            { "bal", "બલૂચી" },
            { "ban", "બાલિનીસ" },
            { "bas", "બસા" },
            { "bax", "બામન" },
            { "bej", "બેજા" },
            { "bem", "બેમ્બા" },
            { "bez", "બેના" },
            { "bgc", "હરિયાણવી" },
            { "bgn", "પશ્ચિમી બાલોચી" },
            { "bho", "ભોજપુરી" },
            { "bik", "બિકોલ" },
            { "bin", "બિની" },
            { "bla", "સિક્સિકા" },
            { "blo", "અની" },
            { "bpy", "બિષ્નુપ્રિયા" },
            { "bra", "વ્રજ" },
            { "brh", "બ્રાહુઈ" },
            { "brx", "બોડો" },
            { "bua", "બુરિયાત" },
            { "bug", "બુગિનીસ" },
            { "byn", "બ્લિન" },
            { "cad", "કડ્ડો" },
            { "car", "કરિબ" },
            { "cay", "કેયુગા" },
            { "cch", "અત્સમ" },
            { "ccp", metaValue_ccp },
            { "ceb", "સિબુઆનો" },
            { "cgg", "ચિગા" },
            { "chb", "ચિબ્ચા" },
            { "chg", "છગાતાઇ" },
            { "chk", "ચૂકીસ" },
            { "chm", "મારી" },
            { "chn", "ચિનૂક જાર્ગન" },
            { "cho", "ચોક્તૌ" },
            { "chp", "શિપેવ્યાન" },
            { "chr", "શેરોકી" },
            { "chy", "શેયેન્ન" },
            { "ckb", "સેન્ટ્રલ કુર્દિશ" },
            { "clc", "ચિલકોટિન" },
            { "cop", metaValue_cop },
            { "crg", "મિચિફ" },
            { "crh", "ક્રિમિયન તુર્કી" },
            { "crj", "દક્ષિણ પૂર્વ ક્રી" },
            { "crk", "પ્લેઇન્સ ક્રી" },
            { "crl", "ઉત્તરી પૂર્વ ક્રી" },
            { "crm", "મૂઝ ક્રી" },
            { "crr", "કેરોલિના એલ્ગોનક્વિઅન" },
            { "crs", "સેસેલ્વા ક્રેઓલે ફ્રેન્ચ" },
            { "csb", "કાશુબિયન" },
            { "csw", "સ્વેમ્પી ક્રી" },
            { "dak", "દાકોતા" },
            { "dar", "દાર્ગવા" },
            { "dav", "તૈતા" },
            { "del", "દેલવેર" },
            { "den", "સ્લેવ" },
            { "dgr", "ડોગ્રિબ" },
            { "din", "દિન્કા" },
            { "dje", "ઝર્મા" },
            { "doi", "ડોગ્રી" },
            { "dsb", "લોઅર સોર્બિયન" },
            { "dua", "દુઆલા" },
            { "dum", "મધ્ય ડચ" },
            { "dyo", "જોલા-ફોન્યી" },
            { "dyu", "ડ્યુલા" },
            { "dzg", "દાઝાગા" },
            { "ebu", "ઍમ્બુ" },
            { "efi", "એફિક" },
            { "egy", "પ્રાચીન ઇજીપ્શિયન" },
            { "eka", "એકાજુક" },
            { "elx", "એલામાઇટ" },
            { "enm", "મિડિલ અંગ્રેજી" },
            { "ewo", "ઇવોન્ડો" },
            { "fan", "ફેંગ" },
            { "fat", "ફન્ટી" },
            { "fil", "ફિલિપિનો" },
            { "fon", "ફોન" },
            { "frc", "કાજૂન ફ્રેન્ચ" },
            { "frm", "મિડિલ ફ્રેંચ" },
            { "fro", "જૂની ફ્રેંચ" },
            { "frr", "ઉત્તરી ફ્રિશિયન" },
            { "frs", "પૂર્વ ફ્રિશિયન" },
            { "fur", "ફ્રિયુલિયાન" },
            { "gaa", "ગા" },
            { "gag", "ગાગાઝ" },
            { "gan", "gan" },
            { "gay", "ગાયો" },
            { "gba", "બાયા" },
            { "gbz", "ઝોરોસ્ટ્રિઅન દારી" },
            { "gez", "ગીઝ" },
            { "gil", "જિલ્બરટીઝ" },
            { "gmh", "મધ્ય હાઇ જર્મન" },
            { "goh", "જૂની હાઇ જર્મન" },
            { "gon", "ગોંડી" },
            { "gor", "ગોરોન્તાલો" },
            { "got", metaValue_got },
            { "grb", "ગ્રેબો" },
            { "grc", "પ્રાચીન ગ્રીક" },
            { "gsw", "સ્વિસ જર્મન" },
            { "guz", "ગુસી" },
            { "gwi", "ગ્વિચ’ઇન" },
            { "hai", "હૈડા" },
            { "haw", "હવાઇયન" },
            { "hax", "દક્ષિણ હૈડા" },
            { "hif", "ફીજી હિંદી" },
            { "hil", "હિલિગેનોન" },
            { "hit", "હિટ્ટિતે" },
            { "hmn", "હમોંગ" },
            { "hsb", "અપર સોર્બિયન" },
            { "hup", "હૂપા" },
            { "hur", "હેલ્કોમેલેમ" },
            { "iba", "ઇબાન" },
            { "ibb", "ઇબિબિઓ" },
            { "ikt", "પશ્ચિમ કેનેડિયન ઇનુકિટ્યુટ" },
            { "ilo", "ઇલોકો" },
            { "inh", "ઇંગુશ" },
            { "jbo", "લોજ્બાન" },
            { "jgo", "નગોમ્બા" },
            { "jmc", "મકામે" },
            { "jpr", "જુદેઓ-પર્શિયન" },
            { "jrb", "જુદેઓ-અરબી" },
            { "kaa", "કારા-કલ્પક" },
            { "kab", "કબાઇલ" },
            { "kac", "કાચિન" },
            { "kaj", "જ્જુ" },
            { "kam", "કમ્બા" },
            { "kaw", "કાવી" },
            { "kbd", "કબાર્ડિયન" },
            { "kcg", "ત્યાપ" },
            { "kde", "મકોન્ડે" },
            { "kea", "કાબુવર્ડિઆનુ" },
            { "kfo", "કોરો" },
            { "kgp", "કૈંગાંગ" },
            { "kha", "ખાસી" },
            { "kho", "ખોતાનીસ" },
            { "khq", "કોયરા ચિનિ" },
            { "kkj", "કાકો" },
            { "kln", "કલેજિન" },
            { "kmb", "કિમ્બન્દુ" },
            { "koi", "કોમી-પર્મ્યાક" },
            { "kok", "કોંકણી" },
            { "kos", "કોસરિયન" },
            { "kpe", "ક્પેલ્લે" },
            { "krc", "કરાચય-બલ્કાર" },
            { "krl", "કરેલિયન" },
            { "kru", "કુરૂખ" },
            { "ksb", "શમ્બાલા" },
            { "ksf", "બફિયા" },
            { "ksh", "કોલોગ્નિયન" },
            { "kum", "કુમીક" },
            { "kut", "કુતેનાઇ" },
            { "kwk", "ક્વેકવાલા" },
            { "kxv", "કૂવી" },
            { "lad", "લાદીનો" },
            { "lag", "લંગી" },
            { "lah", "લાહન્ડા" },
            { "lam", "લામ્બા" },
            { "lez", "લેઝધીયન" },
            { "lfn", "લિંગ્વા ફેન્કા નોવા" },
            { "lij", "લિગુરીઅન" },
            { "lil", "લિલુએટ" },
            { "lkt", "લાકોટા" },
            { "lmo", "લોંબાર્ડ" },
            { "lol", "મોંગો" },
            { "lou", "લ્યુઇસિયાના ક્રેઓલ" },
            { "loz", "લોઝી" },
            { "lrc", "ઉત્તરી લુરી" },
            { "lsm", "સામિયા" },
            { "lua", "લૂબા-લુલુઆ" },
            { "lui", "લુઇસેનો" },
            { "lun", "લુન્ડા" },
            { "luo", "લ્યુઓ" },
            { "lus", "મિઝો" },
            { "luy", "લુઈયા" },
            { "mad", "માદુરીસ" },
            { "mag", "મગહી" },
            { "mai", "મૈથિલી" },
            { "mak", "મકાસર" },
            { "man", "મન્ડિન્ગો" },
            { "mas", "મસાઇ" },
            { "mdf", "મોક્ષ" },
            { "mdr", "મંદાર" },
            { "men", "મેન્ડે" },
            { "mer", "મેરુ" },
            { "mfe", "મોરીસ્યેન" },
            { "mga", "મધ્ય આઈરિશ" },
            { "mgh", "માખુવા-મીટ્ટુ" },
            { "mgo", "મેતા" },
            { "mic", "મિકમેક" },
            { "min", "મિનાંગ્કાબાઉ" },
            { "mnc", "માન્ચુ" },
            { "mni", "મણિપુરી" },
            { "moe", "ઇન્નુ-આયમુન" },
            { "moh", "મોહૌક" },
            { "mos", "મોસ્સી" },
            { "mrj", "પશ્ચિમી મારી" },
            { "mua", "મુનડાન્ગ" },
            { "mul", "બહુવિધ ભાષાઓ" },
            { "mus", "ક્રિક" },
            { "mwl", "મિરાંડી" },
            { "mwr", "મારવાડી" },
            { "myv", "એર્ઝયા" },
            { "mzn", "મઝાન્દેરાની" },
            { "nap", "નેપોલિટાન" },
            { "naq", "નમા" },
            { "nds", "લો જર્મન" },
            { "new", "નેવારી" },
            { "nia", "નિયાસ" },
            { "niu", "નિયુઆન" },
            { "nmg", "ક્વાસિઓ" },
            { "nnh", "નીએમબુન" },
            { "nog", "નોગાઇ" },
            { "non", "જૂની નોર્સ" },
            { "nqo", "એન’કો" },
            { "nso", "ઉત્તરી સોથો" },
            { "nus", "નુએર" },
            { "nwc", "પરંપરાગત નેવારી" },
            { "nym", "ન્યામવેઝી" },
            { "nyn", "ન્યાનકોલ" },
            { "nyo", "ન્યોરો" },
            { "nzi", "ન્ઝિમા" },
            { "ojb", "ઉત્તરપશ્ચિમી ઓઝિબવે" },
            { "ojc", "સેન્ટ્રલ ઓઝિબ્વા" },
            { "ojs", "ઓજી-ક્રી" },
            { "ojw", "પશ્ચિમી ઓઝિબ્વા" },
            { "oka", "ઓકાનાગન" },
            { "osa", "ઓસેજ" },
            { "ota", "ઓટોમાન તુર્કિશ" },
            { "pag", "પંગાસીનાન" },
            { "pal", "પહલવી" },
            { "pam", "પમ્પાન્ગા" },
            { "pap", "પાપિયામેન્ટો" },
            { "pau", "પલાઉઆન" },
            { "pcm", "નાઇજેરિયન પીજીન" },
            { "peo", "જૂની ફારસી" },
            { "phn", metaValue_phn },
            { "pis", "પિજિન" },
            { "pon", "પોહપિએન" },
            { "pqm", "મલિસીટ-પાસમાક્વોડ્ડી" },
            { "prg", "પ્રુસ્સીયન" },
            { "pro", "જુની પ્રોવેન્સલ" },
            { "quc", "કિચે" },
            { "raj", "રાજસ્થાની" },
            { "rap", "રાપાનુઇ" },
            { "rar", "રારોટોંગન" },
            { "rhg", "રોહિંગ્યા" },
            { "rof", "રોમ્બો" },
            { "rom", "રોમાની" },
            { "rup", "અરોમેનિયન" },
            { "rwk", "રવા" },
            { "sad", "સોંડવે" },
            { "sah", "સખા" },
            { "sam", "સામરિટાન અરેમિક" },
            { "saq", "સમ્બુરુ" },
            { "sas", "સાસાક" },
            { "sat", "સંતાલી" },
            { "sba", "ન્ગામ્બેય" },
            { "sbp", "સાંગુ" },
            { "scn", "સિસિલિયાન" },
            { "sco", "સ્કોટ્સ" },
            { "sdh", "સર્ઘન કુર્દીશ" },
            { "seh", "સેના" },
            { "sel", "સેલ્કપ" },
            { "ses", "કોયરાબોરો સેન્ની" },
            { "sga", "જૂની આયરિશ" },
            { "shi", "તેશીલહિટ" },
            { "shn", "શેન" },
            { "sid", "સિદામો" },
            { "slh", "દક્ષિણ લુશુટસીડ" },
            { "sma", "દક્ષિણી સામી" },
            { "smj", "લુલે સામી" },
            { "smn", "ઇનારી સામી" },
            { "sms", "સ્કોલ્ટ સામી" },
            { "snk", "સોનિન્કે" },
            { "sog", "સોગ્ડિએન" },
            { "srn", "સ્રાનન ટોન્ગો" },
            { "srr", "સેરેર" },
            { "ssy", "સાહો" },
            { "str", "સ્ટ્રેટ્સ સેલિશ" },
            { "suk", "સુકુમા" },
            { "sus", "સુસુ" },
            { "sux", "સુમેરિયન" },
            { "swb", "કોમોરિયન" },
            { "syc", "પરંપરાગત સિરિએક" },
            { "syr", "સિરિએક" },
            { "szl", "સિલેસ્યિન" },
            { "tce", "દક્ષિણ ટુચૉન" },
            { "tcy", "તુલુ" },
            { "tem", "ટિમ્ને" },
            { "teo", "તેસો" },
            { "ter", "તેરેનો" },
            { "tet", "તેતુમ" },
            { "tgx", "ટાગિશ" },
            { "tht", "તહલતાન" },
            { "tig", "ટાઇગ્રે" },
            { "tiv", "તિવ" },
            { "tkl", "તોકેલાઉ" },
            { "tlh", "ક્લિન્ગોન" },
            { "tli", "ટ્લિંગિટ" },
            { "tmh", "તામાશેખ" },
            { "tog", "ન્યાસા ટોન્ગા" },
            { "tok", "ટોકી પોના" },
            { "tpi", "ટોક પિસિન" },
            { "trv", "ટારોકો" },
            { "tsi", "સિમ્શિયન" },
            { "ttm", "ઉત્તરી ટુચૉન" },
            { "ttt", "મુસ્લિમ તાટ" },
            { "tum", "તુમ્બુકા" },
            { "tvl", metaValue_TV },
            { "twq", "તસાવાક" },
            { "tyv", "ટુવીનિયન" },
            { "tzm", "સેન્ટ્રલ એટલાસ તામાઝિટ" },
            { "udm", "ઉદમુર્ત" },
            { "uga", "યુગેરિટિક" },
            { "umb", "ઉમ્બુન્ડૂ" },
            { "und", "અજ્ઞાત ભાષા" },
            { "vai", metaValue_vai },
            { "vec", "વેનેશ્યિન" },
            { "vmw", "મખુવા" },
            { "vot", "વોટિક" },
            { "vun", "વુન્જો" },
            { "wae", "વેલ્સેર" },
            { "wal", "વોલાયટ્ટા" },
            { "war", "વારેય" },
            { "was", "વાશો" },
            { "wbp", "વાર્લ્પીરી" },
            { "wuu", "વુ ચાઈનીઝ" },
            { "xal", "કાલ્મિક" },
            { "xnr", "કંગરી" },
            { "xog", "સોગા" },
            { "yao", "યાઓ" },
            { "yap", "યાપીસ" },
            { "yav", "યાન્ગબેન" },
            { "ybb", "યેમ્બા" },
            { "yrl", "નહેનગાતુ" },
            { "yue", "કેંટોનીઝ" },
            { "zap", "ઝેપોટેક" },
            { "zbl", metaValue_zbl },
            { "zen", "ઝેનાગા" },
            { "zgh", "માનક મોરોક્કન તામાઝિટ" },
            { "zun", "ઝૂની" },
            { "zxx", "કોઇ ભાષાશાસ્ત્રીય સામગ્રી નથી" },
            { "zza", "ઝાઝા" },
            { "Adlm", "એડલમ" },
            { "Arab", metaValue_ar },
            { "Aran", "નસ્તાલીક" },
            { "Armi", "ઇમ્પિરિયલ આર્મનિક" },
            { "Armn", "અર્મેનિયન" },
            { "Avst", metaValue_ae },
            { "Bali", "બાલીનીઝ" },
            { "Batk", "બટાક" },
            { "Beng", "બંગાળી" },
            { "Blis", metaValue_zbl },
            { "Bopo", "બોપોમોફો" },
            { "Brah", "બ્રહ્મી" },
            { "Brai", "બ્રેલ" },
            { "Bugi", "બગિનીસ" },
            { "Buhd", "બુહિદ" },
            { "Cakm", metaValue_ccp },
            { "Cans", "યુનાઇટેડ કેનેડિયન એબોરિજનલ સિલેબિક્સ" },
            { "Cari", "કરૈન" },
            { "Cher", "ચેરોકી" },
            { "Cirt", "સિર્થ" },
            { "Copt", metaValue_cop },
            { "Cprt", "સિપ્રાયટ" },
            { "Cyrl", "સિરિલિક" },
            { "Cyrs", "ઓલ્ડ ચર્ચ સ્લાવોનિક સિરિલિક" },
            { "Deva", "દેવનાગરી" },
            { "Dsrt", "ડેસરેટ" },
            { "Egyd", "ઇજિપ્શિયન ડેમોટિક" },
            { "Egyh", "ઇજિપ્શિયન હાઇરેટિક" },
            { "Egyp", "ઇજિપ્શિયન હાઇરોગ્લિફ્સ" },
            { "Ethi", "ઇથિયોપિક" },
            { "Geok", "જ્યોર્જિઅન ખુતસુરી" },
            { "Geor", "જ્યોર્જિઅન" },
            { "Glag", "ગ્લેગોલિટિક" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "ગુરૂમુખી" },
            { "Hanb", "હાન્બ" },
            { "Hang", "હંગુલ" },
            { "Hani", "હાન" },
            { "Hano", "હનુનૂ" },
            { "Hans", "સરળીકૃત" },
            { "Hant", "પરંપરાગત" },
            { "Hebr", metaValue_he },
            { "Hira", "હિરાગાના" },
            { "Hmng", "પહાઉ મોન્ગ" },
            { "Hrkt", "જાપાનીઝ વર્ણમાળા" },
            { "Hung", "ઓલ્ડ હંગેરિયન" },
            { "Inds", "સિન્ધુ" },
            { "Ital", "જૂનુ ઇટાલિક" },
            { "Jamo", "જેમો" },
            { "Java", metaValue_jv },
            { "Jpan", "જાપાની" },
            { "Kali", "કાયાહ લી" },
            { "Kana", "કટાકાના" },
            { "Khar", "ખારોશ્થી" },
            { "Khmr", metaValue_km },
            { "Knda", "કન્નડા" },
            { "Kore", metaValue_ko },
            { "Kthi", "કૈથી" },
            { "Lana", "લાના" },
            { "Laoo", metaValue_lo },
            { "Latf", "ફ્રેકતુર લેટિન" },
            { "Latg", "ગૈલિક લેટિન" },
            { "Latn", metaValue_la },
            { "Lepc", "લેપચા" },
            { "Limb", "લિમ્બૂ" },
            { "Lina", "લીનિયર અ" },
            { "Linb", "લીનિયર બી" },
            { "Lyci", "લિશિયન" },
            { "Lydi", "લિડિયન" },
            { "Mand", "માન્ડાયીન" },
            { "Mani", "માનીચાયીન" },
            { "Maya", "મયાન હાઇરોગ્લિફ્સ" },
            { "Mero", "મેરોઇટિક" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "મૂન" },
            { "Mtei", "મેઇતેઇ માયેક" },
            { "Mymr", "મ્યાંમાર" },
            { "Nkoo", "એન’ કો" },
            { "Ogam", "ઓઘામ" },
            { "Olck", "ઓલ ચિકી" },
            { "Orkh", "ઓરખોન" },
            { "Orya", metaValue_or },
            { "Osma", "ઓસ્માન્યા" },
            { "Perm", "ઓલ્ડ પરમિક" },
            { "Phag", "ફાગ્સ-પા" },
            { "Phli", "ઇન્સ્ક્રિપ્શનલ પહલવી" },
            { "Phlp", "સાલટર પહલવી" },
            { "Phlv", "બુક પહલવી" },
            { "Phnx", metaValue_phn },
            { "Plrd", "પોલાર્ડ ફોનેટિક" },
            { "Prti", "ઇન્સ્ક્રિપ્શનલ પાર્થિયન" },
            { "Rjng", "રીજાંગ" },
            { "Rohg", "હનીફી" },
            { "Roro", "રોંગોરોંગો" },
            { "Runr", "રૂનિક" },
            { "Samr", "સમરિટાન" },
            { "Sara", "સરાતી" },
            { "Saur", "સૌરાષ્ટ્ર" },
            { "Sgnw", "સંકેત લિપી" },
            { "Shaw", "શાવિયાન" },
            { "Sinh", "સિંહલી" },
            { "Sund", "સુદાનીઝ" },
            { "Sylo", "સિલોતી નાગરી" },
            { "Syrc", "સિરિયેક" },
            { "Syre", "એસ્ત્રેન્જેલો સિરિયાક" },
            { "Syrj", "પશ્ચિમ સિરિયાક" },
            { "Syrn", "પૂર્વ સિરિયાક" },
            { "Tagb", "તગબન્વા" },
            { "Tale", "તાઇ લી" },
            { "Talu", "નવીન તાઇ લૂ" },
            { "Taml", metaValue_ta },
            { "Tavt", "તાઇ વેઇત" },
            { "Telu", metaValue_te },
            { "Teng", "તેન્ગવાર" },
            { "Tfng", "તિફિનાઘ" },
            { "Tglg", "ટેગાલોગ" },
            { "Thaa", "થાના" },
            { "Thai", "થાઇ" },
            { "Tibt", "ટિબેટી" },
            { "Ugar", "યુગાતિટિક" },
            { "Vaii", metaValue_vai },
            { "Visp", "વિસિબલ સ્પીચ" },
            { "Xpeo", "જુની ફારસી" },
            { "Xsux", "સુમેરો અક્કાદિયન સુનિફોર્મ" },
            { "Yiii", "યી" },
            { "Zinh", "વંશાગત" },
            { "Zmth", "ગણિતીય સંકેતલિપિ" },
            { "Zsye", "ઇમોજી" },
            { "Zsym", "પ્રતીકો" },
            { "Zxxx", "અલિખિત" },
            { "Zyyy", "સામાન્ય" },
            { "Zzzz", "અજ્ઞાત લિપિ" },
            { "de_AT", "ઓસ્ટ્રિઅન જર્મન" },
            { "de_CH", "સ્વિસ હાય જર્મન" },
            { "en_AU", "ઓસ્ટ્રેલિયન અંગ્રેજી" },
            { "en_CA", "કેનેડિયન અંગ્રેજી" },
            { "en_GB", "બ્રિટિશ અંગ્રેજી" },
            { "en_US", "અમેરિકન અંગ્રેજી" },
            { "es_ES", "યુરોપિયન સ્પેનિશ" },
            { "es_MX", "મેક્સિકન સ્પેનિશ" },
            { "fa_AF", "ડારી" },
            { "fr_CH", "સ્વિસ ફ્રેંચ" },
            { "nl_BE", "ફ્લેમિશ" },
            { "pt_BR", "બ્રાઝિલીયન પોર્ટુગીઝ" },
            { "pt_PT", "યુરોપિયન પોર્ટુગીઝ" },
            { "ro_MD", "મોલડાવિયન" },
            { "sw_CD", "કોંગો સ્વાહિલી" },
            { "ar_001", "મોડર્ન સ્ટાન્ડર્ડ અરબી" },
            { "es_419", "લેટિન અમેરિકન સ્પેનિશ" },
            { "key.ca", "કેલેન્ડર" },
            { "key.cf", "ચલણી બંધારણ" },
            { "key.co", "સૉર્ટ ક્રમ" },
            { "key.cu", "ચલણ" },
            { "key.em", "ઇમોજી પ્રસ્તુતિ" },
            { "key.hc", "કલાકનું આવર્તન (12 વિ.24)" },
            { "key.lb", "રેખા વિરામ પ્રકાર" },
            { "key.lw", "શબ્દોમાં રેખા વિરામ" },
            { "key.ms", "માપદંડ પદ્ધતિ" },
            { "key.nu", "આંકડાઓ" },
            { "key.ss", "સંક્ષેપ પછી વાક્ય વિરામ" },
            { "key.tz", "સમય ઝોન" },
            { "key.va", "લોકેલ વેરિએન્ટ" },
            { "nds_NL", "લો સેક્સોન" },
            { "zh_Hans", "સરળીકૃત ચાઇનીઝ" },
            { "zh_Hant", "પારંપરિક ચાઇનીઝ" },
            { "%%PINYIN", "પિનયિન રોમનાઇઝેશન" },
            { "%%WADEGILE", "વેડ-ગિલ્સ રોમનાઇઝેશન" },
            { "type.ca.roc", "મિંગુઓ કેલેન્ડર" },
            { "type.co.eor", "યુરોપીયન ક્રમ આપવાના નિયમો" },
            { "type.hc.h11", "12 કલાકની સિસ્ટમ (0–11)" },
            { "type.hc.h12", "12 કલાકની સિસ્ટમ (1–12)" },
            { "type.hc.h23", "24 કલાકની સિસ્ટમ (0–23)" },
            { "type.hc.h24", "24 કલાકની સિસ્ટમ (1–24)" },
            { "type.m0.bgn", "US BGN" },
            { "type.nu.arab", "અરેબિક-ભારતીય અંકો" },
            { "type.nu.armn", "અર્મેનિયન સંખ્યાઓ" },
            { "type.nu.beng", "બંગાળી અંકો" },
            { "type.nu.cakm", "ચકમા અંકો" },
            { "type.nu.deva", "દેવનાગરી અંકો" },
            { "type.nu.ethi", "ઇથિયોપીક સંખ્યાઓ" },
            { "type.nu.geor", "જ્યોર્જિઅન સંખ્યાઓ" },
            { "type.nu.grek", "ગ્રીક સંખ્યાઓ" },
            { "type.nu.gujr", "ગુજરાતી અંકો" },
            { "type.nu.guru", "ગુરમુખી અંકો" },
            { "type.nu.hans", "સરળીકૃત ચાઇનીઝ સંખ્યાઓ" },
            { "type.nu.hant", "પરંપરાગત ચાઇનીઝ સંખ્યાઓ" },
            { "type.nu.hebr", "હિબ્રુ સંખ્યાઓ" },
            { "type.nu.java", "જાવાનીઝ અંકો" },
            { "type.nu.jpan", "જાપાનીઝ સંખ્યાઓ" },
            { "type.nu.khmr", "ખ્મેર અંકો" },
            { "type.nu.knda", "કન્નડા અંકો" },
            { "type.nu.laoo", "લાઓ અંકો" },
            { "type.nu.latn", "પશ્ચિમી અંકો" },
            { "type.nu.mlym", "મલયાલમ અંકો" },
            { "type.nu.mong", "મોંગોલિયન અંકો" },
            { "type.nu.mtei", "મેઇતેઇ માયેક અંકો" },
            { "type.nu.mymr", "મ્યાન્માર અંકો" },
            { "type.nu.olck", "ઓલ ચિકી અંકો" },
            { "type.nu.orya", "ઓરિયા અંકો" },
            { "type.nu.taml", "પારંપરિક તમિલ સંખ્યાઓ" },
            { "type.nu.telu", "તેલુગુ અંકો" },
            { "type.nu.thai", "થાઇ અંકો" },
            { "type.nu.tibt", "તિબેટિયન અંકો" },
            { "type.nu.vaii", "વાઇ અંકો" },
            { "type.ca.dangi", "ડાંગી કેલેન્ડર" },
            { "type.co.ducet", "ડિફોલ્ટ યુનિકોડ સૉર્ટ ક્રમ" },
            { "type.lb.loose", "શિથિલ રેખા વિરામ પ્રકાર" },
            { "type.nu.roman", "રોમન સંખ્યાઓ" },
            { "type.ca.coptic", "કોપ્ટિક કેલેન્ડર" },
            { "type.ca.hebrew", "હિબ્રુ કેલેન્ડર" },
            { "type.ca.indian", "ભારતીય રાષ્ટ્રીય કેલેન્ડર" },
            { "type.co.compat", "અગાઉનો સોર્ટ ક્રમ, સુસંગતતા માટે" },
            { "type.co.pinyin", "પિનયિન અનુક્મ" },
            { "type.co.search", "સામાન્ય-ઉદ્દેશ શોધ" },
            { "type.co.stroke", "સ્ટ્રોક અનુક્મ" },
            { "type.co.unihan", "રેડિકલ-સ્ટ્રોક" },
            { "type.d0.fwidth", "પૂર્ણપહોળાઇ" },
            { "type.d0.hwidth", "અર્ધપહોળાઈ" },
            { "type.lb.normal", "સામાન્ય રેખા વિરામ પ્રકાર" },
            { "type.lb.strict", "ચુસ્ત રેખા વિરામ પ્રકાર" },
            { "type.m0.ungegn", "UN GEGN" },
            { "type.ms.metric", "દશાંશ પદ્ધતિ" },
            { "type.nu.native", "મૂળ અંકો" },
            { "type.ca.chinese", "ચાઇનીઝ કેલેન્ડર" },
            { "type.ca.islamic", "હિજરી કેલેન્ડર" },
            { "type.ca.iso8601", "ISO-8601 કેલેન્ડર" },
            { "type.ca.persian", "પર્શિયન કેલેન્ડર" },
            { "type.cf.account", "હિસાબી ચલણી બંધારણ" },
            { "type.d0.npinyin", "સંખ્યા" },
            { "type.nu.arabext", "વિસ્તૃત અરેબિક-ઇન્ડિક અંકો" },
            { "type.nu.armnlow", "અર્મેનિયન નાના અક્ષરની સંખ્યાઓ" },
            { "type.nu.finance", "નાણાકીય સંખ્યાઓ" },
            { "type.nu.greklow", "ગ્રીક નાના અક્ષરની સંખ્યાઓ" },
            { "type.nu.hanidec", "ચાઇનીઝ દશાંશ સંખ્યાઓ" },
            { "type.nu.hansfin", "સરળીકૃત ચાઇનીઝ નાણાકીય સંખ્યાઓ" },
            { "type.nu.hantfin", "પરંપરાગત ચાઇનીઝ નાણાકીય સંખ્યાઓ" },
            { "type.nu.jpanfin", "જાપાનીઝ નાણાકીય સંખ્યાઓ" },
            { "type.nu.tamldec", "તમિલ અંકો" },
            { "type.ca.buddhist", "બુદ્ધિસ્ટ કેલેન્ડર" },
            { "type.ca.ethiopic", "ઇથિઓપિક કેલેન્ડર" },
            { "type.ca.japanese", "જાપાનીઝ કેલેન્ડર" },
            { "type.cf.standard", "પ્રમાણભૂત ચલણી બંધારણ" },
            { "type.co.phonetic", "ધ્વન્યાત્મક સૉર્ટ ક્રમ" },
            { "type.co.searchjl", "હંગુલ પ્રારંભિક વ્યંજન દ્વારા શોધો" },
            { "type.co.standard", "માનક સૉર્ટ ક્રમ" },
            { "type.ms.uksystem", "રજવાડું માપદંડ પદ્ધતિ" },
            { "type.ms.ussystem", "અમેરિકન માપદંડ પદ્ધતિ" },
            { "type.nu.fullwide", "પૂર્ણ પહોળાઈ અંકો" },
            { "type.nu.romanlow", "રોમન નાના અક્ષરની સંખ્યા" },
            { "type.ca.gregorian", "ગ્રેગોરિઅન કેલેન્ડર" },
            { "type.co.phonebook", "ફોનબુક અનુક્મ" },
            { "type.co.dictionary", "શબ્દકોશ અનુક્મ" },
            { "type.co.traditional", "પરંપરાગત અનુક્મ" },
            { "type.nu.traditional", "પરંપરાગત અંકો" },
            { "type.ca.islamic-rgsa", "ઇસ્લામિક કેલેન્ડર (સાઉદી અરેબિયા, નિરીક્ષણ)" },
            { "type.ca.islamic-tbla", "ઇસ્લામિક કેલેન્ડર (ટેબ્યુલર, ખગોળશાસ્ત્રીય યુગ)" },
            { "type.ca.islamic-civil", "હિજરી-નાગરિક કેલેન્ડર" },
            { "type.ca.islamic-umalqura", "હિજરી કેલેન્ડર (ઉમ અલ-કુરા)" },
            { "type.ca.ethiopic-amete-alem", "ઇથિઓપિક એમેટ એલેમ કેલેન્ડર" },
        };
        return data;
    }
}
