/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */

package org.polarsys.kitalpha.pdt.metamodel.model.platform.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.polarsys.kitalpha.pdt.metamodel.edit.provider.PlatformEditPlugin;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.PlatformPackage;
import org.polarsys.kitalpha.pdt.metamodel.model.platform.util.PlatformAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class PlatformItemProviderAdapterFactory extends PlatformAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(PlatformEditPlugin.INSTANCE, PlatformPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PlatformItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Plugin} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PluginItemProvider pluginItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Plugin}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPluginAdapter() {
		if (pluginItemProvider == null) {
			pluginItemProvider = new PluginItemProvider(this);
		}

		return pluginItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ExtensionPoint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExtensionPointItemProvider extensionPointItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ExtensionPoint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExtensionPointAdapter() {
		if (extensionPointItemProvider == null) {
			extensionPointItemProvider = new ExtensionPointItemProvider(this);
		}

		return extensionPointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Extension} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExtensionItemProvider extensionItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Extension}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExtensionAdapter() {
		if (extensionItemProvider == null) {
			extensionItemProvider = new ExtensionItemProvider(this);
		}

		return extensionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Repository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RepositoryItemProvider repositoryItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Repository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRepositoryAdapter() {
		if (repositoryItemProvider == null) {
			repositoryItemProvider = new RepositoryItemProvider(this);
		}

		return repositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfiguredSchemaElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConfiguredSchemaElementItemProvider configuredSchemaElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfiguredSchemaElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConfiguredSchemaElementAdapter() {
		if (configuredSchemaElementItemProvider == null) {
			configuredSchemaElementItemProvider = new ConfiguredSchemaElementItemProvider(this);
		}

		return configuredSchemaElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfigurationElementAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConfigurationElementAttributeItemProvider configurationElementAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfigurationElementAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConfigurationElementAttributeAdapter() {
		if (configurationElementAttributeItemProvider == null) {
			configurationElementAttributeItemProvider = new ConfigurationElementAttributeItemProvider(this);
		}

		return configurationElementAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ComplexCompositor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComplexCompositorItemProvider complexCompositorItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ComplexCompositor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComplexCompositorAdapter() {
		if (complexCompositorItemProvider == null) {
			complexCompositorItemProvider = new ComplexCompositorItemProvider(this);
		}

		return complexCompositorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.SchemaElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SchemaElementItemProvider schemaElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.SchemaElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchemaElementAdapter() {
		if (schemaElementItemProvider == null) {
			schemaElementItemProvider = new SchemaElementItemProvider(this);
		}

		return schemaElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Feature} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureItemProvider featureItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Feature}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureAdapter() {
		if (featureItemProvider == null) {
			featureItemProvider = new FeatureItemProvider(this);
		}

		return featureItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginDependency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PluginDependencyItemProvider pluginDependencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginDependency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPluginDependencyAdapter() {
		if (pluginDependencyItemProvider == null) {
			pluginDependencyItemProvider = new PluginDependencyItemProvider(this);
		}

		return pluginDependencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureDependency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureDependencyItemProvider featureDependencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureDependency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureDependencyAdapter() {
		if (featureDependencyItemProvider == null) {
			featureDependencyItemProvider = new FeatureDependencyItemProvider(this);
		}

		return featureDependencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Package} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PackageItemProvider packageItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Package}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPackageAdapter() {
		if (packageItemProvider == null) {
			packageItemProvider = new PackageItemProvider(this);
		}

		return packageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureInclusion} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureInclusionItemProvider featureInclusionItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureInclusion}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureInclusionAdapter() {
		if (featureInclusionItemProvider == null) {
			featureInclusionItemProvider = new FeatureInclusionItemProvider(this);
		}

		return featureInclusionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfigurationElementAttributeInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConfigurationElementAttributeInstanceItemProvider configurationElementAttributeInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ConfigurationElementAttributeInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConfigurationElementAttributeInstanceAdapter() {
		if (configurationElementAttributeInstanceItemProvider == null) {
			configurationElementAttributeInstanceItemProvider = new ConfigurationElementAttributeInstanceItemProvider(this);
		}

		return configurationElementAttributeInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.StringValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringValueItemProvider stringValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.StringValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringValueAdapter() {
		if (stringValueItemProvider == null) {
			stringValueItemProvider = new StringValueItemProvider(this);
		}

		return stringValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.JavaClassValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JavaClassValueItemProvider javaClassValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.JavaClassValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createJavaClassValueAdapter() {
		if (javaClassValueItemProvider == null) {
			javaClassValueItemProvider = new JavaClassValueItemProvider(this);
		}

		return javaClassValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.BooleanValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanValueItemProvider booleanValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.BooleanValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanValueAdapter() {
		if (booleanValueItemProvider == null) {
			booleanValueItemProvider = new BooleanValueItemProvider(this);
		}

		return booleanValueItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Cardinality} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CardinalityItemProvider cardinalityItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.Cardinality}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCardinalityAdapter() {
		if (cardinalityItemProvider == null) {
			cardinalityItemProvider = new CardinalityItemProvider(this);
		}

		return cardinalityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.SchemaElementReference} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SchemaElementReferenceItemProvider schemaElementReferenceItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.SchemaElementReference}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchemaElementReferenceAdapter() {
		if (schemaElementReferenceItemProvider == null) {
			schemaElementReferenceItemProvider = new SchemaElementReferenceItemProvider(this);
		}

		return schemaElementReferenceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EclipseElementItemProvider eclipseElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEclipseElementAdapter() {
		if (eclipseElementItemProvider == null) {
			eclipseElementItemProvider = new EclipseElementItemProvider(this);
		}

		return eclipseElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureToPluginDependency} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureToPluginDependencyItemProvider featureToPluginDependencyItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureToPluginDependency}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureToPluginDependencyAdapter() {
		if (featureToPluginDependencyItemProvider == null) {
			featureToPluginDependencyItemProvider = new FeatureToPluginDependencyItemProvider(this);
		}

		return featureToPluginDependencyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginExtensions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PluginExtensionsItemProvider pluginExtensionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginExtensions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPluginExtensionsAdapter() {
		if (pluginExtensionsItemProvider == null) {
			pluginExtensionsItemProvider = new PluginExtensionsItemProvider(this);
		}

		return pluginExtensionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginExtensionPoints} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PluginExtensionPointsItemProvider pluginExtensionPointsItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginExtensionPoints}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPluginExtensionPointsAdapter() {
		if (pluginExtensionPointsItemProvider == null) {
			pluginExtensionPointsItemProvider = new PluginExtensionPointsItemProvider(this);
		}

		return pluginExtensionPointsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginDependencies} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PluginDependenciesItemProvider pluginDependenciesItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.PluginDependencies}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPluginDependenciesAdapter() {
		if (pluginDependenciesItemProvider == null) {
			pluginDependenciesItemProvider = new PluginDependenciesItemProvider(this);
		}

		return pluginDependenciesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureDependencies} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureDependenciesItemProvider featureDependenciesItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureDependencies}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureDependenciesAdapter() {
		if (featureDependenciesItemProvider == null) {
			featureDependenciesItemProvider = new FeatureDependenciesItemProvider(this);
		}

		return featureDependenciesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureInclusions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeatureInclusionsItemProvider featureInclusionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeatureInclusions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeatureInclusionsAdapter() {
		if (featureInclusionsItemProvider == null) {
			featureInclusionsItemProvider = new FeatureInclusionsItemProvider(this);
		}

		return featureInclusionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeaturePluginDependencies} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FeaturePluginDependenciesItemProvider featurePluginDependenciesItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.FeaturePluginDependencies}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFeaturePluginDependenciesAdapter() {
		if (featurePluginDependenciesItemProvider == null) {
			featurePluginDependenciesItemProvider = new FeaturePluginDependenciesItemProvider(this);
		}

		return featurePluginDependenciesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.IncludedPlugins} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IncludedPluginsItemProvider includedPluginsItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.IncludedPlugins}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIncludedPluginsAdapter() {
		if (includedPluginsItemProvider == null) {
			includedPluginsItemProvider = new IncludedPluginsItemProvider(this);
		}

		return includedPluginsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EclipseModelItemProvider eclipseModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.EclipseModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEclipseModelAdapter() {
		if (eclipseModelItemProvider == null) {
			eclipseModelItemProvider = new EclipseModelItemProvider(this);
		}

		return eclipseModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ExportedPackage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExportedPackageItemProvider exportedPackageItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ExportedPackage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExportedPackageAdapter() {
		if (exportedPackageItemProvider == null) {
			exportedPackageItemProvider = new ExportedPackageItemProvider(this);
		}

		return exportedPackageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ExportedPackages} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExportedPackagesItemProvider exportedPackagesItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ExportedPackages}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExportedPackagesAdapter() {
		if (exportedPackagesItemProvider == null) {
			exportedPackagesItemProvider = new ExportedPackagesItemProvider(this);
		}

		return exportedPackagesItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.IntrospectionError} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntrospectionErrorItemProvider introspectionErrorItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.IntrospectionError}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntrospectionErrorAdapter() {
		if (introspectionErrorItemProvider == null) {
			introspectionErrorItemProvider = new IntrospectionErrorItemProvider(this);
		}

		return introspectionErrorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ExecutionEnvironments} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecutionEnvironmentsItemProvider executionEnvironmentsItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ExecutionEnvironments}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExecutionEnvironmentsAdapter() {
		if (executionEnvironmentsItemProvider == null) {
			executionEnvironmentsItemProvider = new ExecutionEnvironmentsItemProvider(this);
		}

		return executionEnvironmentsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ExecutionEnvironment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecutionEnvironmentItemProvider executionEnvironmentItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.ExecutionEnvironment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExecutionEnvironmentAdapter() {
		if (executionEnvironmentItemProvider == null) {
			executionEnvironmentItemProvider = new ExecutionEnvironmentItemProvider(this);
		}

		return executionEnvironmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.IntrospectionErrors} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntrospectionErrorsItemProvider introspectionErrorsItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.pdt.metamodel.model.platform.IntrospectionErrors}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntrospectionErrorsAdapter() {
		if (introspectionErrorsItemProvider == null) {
			introspectionErrorsItemProvider = new IntrospectionErrorsItemProvider(this);
		}

		return introspectionErrorsItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (pluginItemProvider != null) pluginItemProvider.dispose();
		if (extensionPointItemProvider != null) extensionPointItemProvider.dispose();
		if (extensionItemProvider != null) extensionItemProvider.dispose();
		if (repositoryItemProvider != null) repositoryItemProvider.dispose();
		if (configuredSchemaElementItemProvider != null) configuredSchemaElementItemProvider.dispose();
		if (configurationElementAttributeItemProvider != null) configurationElementAttributeItemProvider.dispose();
		if (complexCompositorItemProvider != null) complexCompositorItemProvider.dispose();
		if (schemaElementItemProvider != null) schemaElementItemProvider.dispose();
		if (featureItemProvider != null) featureItemProvider.dispose();
		if (pluginDependencyItemProvider != null) pluginDependencyItemProvider.dispose();
		if (featureDependencyItemProvider != null) featureDependencyItemProvider.dispose();
		if (packageItemProvider != null) packageItemProvider.dispose();
		if (featureInclusionItemProvider != null) featureInclusionItemProvider.dispose();
		if (configurationElementAttributeInstanceItemProvider != null) configurationElementAttributeInstanceItemProvider.dispose();
		if (stringValueItemProvider != null) stringValueItemProvider.dispose();
		if (javaClassValueItemProvider != null) javaClassValueItemProvider.dispose();
		if (booleanValueItemProvider != null) booleanValueItemProvider.dispose();
		if (cardinalityItemProvider != null) cardinalityItemProvider.dispose();
		if (schemaElementReferenceItemProvider != null) schemaElementReferenceItemProvider.dispose();
		if (eclipseElementItemProvider != null) eclipseElementItemProvider.dispose();
		if (featureToPluginDependencyItemProvider != null) featureToPluginDependencyItemProvider.dispose();
		if (pluginExtensionsItemProvider != null) pluginExtensionsItemProvider.dispose();
		if (pluginExtensionPointsItemProvider != null) pluginExtensionPointsItemProvider.dispose();
		if (pluginDependenciesItemProvider != null) pluginDependenciesItemProvider.dispose();
		if (featureDependenciesItemProvider != null) featureDependenciesItemProvider.dispose();
		if (featureInclusionsItemProvider != null) featureInclusionsItemProvider.dispose();
		if (featurePluginDependenciesItemProvider != null) featurePluginDependenciesItemProvider.dispose();
		if (includedPluginsItemProvider != null) includedPluginsItemProvider.dispose();
		if (eclipseModelItemProvider != null) eclipseModelItemProvider.dispose();
		if (exportedPackageItemProvider != null) exportedPackageItemProvider.dispose();
		if (exportedPackagesItemProvider != null) exportedPackagesItemProvider.dispose();
		if (introspectionErrorItemProvider != null) introspectionErrorItemProvider.dispose();
		if (executionEnvironmentsItemProvider != null) executionEnvironmentsItemProvider.dispose();
		if (executionEnvironmentItemProvider != null) executionEnvironmentItemProvider.dispose();
		if (introspectionErrorsItemProvider != null) introspectionErrorsItemProvider.dispose();
	}

}
