/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.config;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.polarsys.kitalpha.massactions.core.column.IMAColumn;
import org.polarsys.kitalpha.massactions.core.table.layer.IMAComponent;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;

public class MAColumnConfiguration
extends AbstractRegistryConfiguration
implements IMAComponent {
    private IMABodyLayer bodyLayer;
    private List<IMAColumn> currentColumnList;
    private List<IMAColumn> newColumnList;

    public MAColumnConfiguration(IMABodyLayer bodyLayer) {
        this.bodyLayer = bodyLayer;
        this.currentColumnList = this.getCurrentColumnList();
        this.newColumnList = null;
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        if (this.newColumnList != null) {
            this.destroyRegistry(configRegistry);
            this.currentColumnList = this.newColumnList;
            this.newColumnList = null;
        }
        this.currentColumnList.forEach(column -> column.configureRegistry(configRegistry));
    }

    public void destroyRegistry(IConfigRegistry configRegistry) {
        this.currentColumnList.forEach(column -> column.destroyRegistry(configRegistry));
    }

    private List<IMAColumn> getCurrentColumnList() {
        return this.bodyLayer.getColumnPropertyAccessor().getColumnList();
    }

    @Override
    public void dataChanged(Collection<EObject> data) {
        this.newColumnList = this.getCurrentColumnList();
    }

    @Override
    public void dispose() {
    }
}

