/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.ui.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceHelper;
import org.polarsys.kitalpha.resourcereuse.helper.ResourceReuse;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.model.SearchCriteria;
import org.polarsys.kitalpha.resourcereuse.ui.Activator;
import org.polarsys.kitalpha.resourcereuse.ui.Messages;
import org.polarsys.kitalpha.resourcereuse.ui.dialog.StringValue;

public class ResourceReuseSelectionDialog
extends TitleAreaDialog {
    private static final String DEFAULT_MESSAGE = "Setup criteria to match a resource";
    private final SearchCriteria criteria = new SearchCriteria();
    private Text idText;
    private Text nameText;
    private Text versionText;
    private Text domainText;
    private Label detailsLabel;
    private final List<StringValue> tags = new ArrayList<StringValue>();
    private final ResourceHelper helper;
    private TableViewer matchingResourceViewer;
    private Label matchingResourceLabel;

    public ResourceReuseSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.helper = ResourceReuse.createHelper();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select resource");
        shell.setImage(Activator.getDefault().getImage("obj16/find.gif"));
        shell.setMinimumSize(1000, 800);
    }

    private void updateMatchingResources() {
        this.criteria.setId(this.idText.getText());
        this.criteria.setName(this.nameText.getText());
        this.criteria.setVersion(this.versionText.getText());
        this.criteria.setDomain(this.domainText.getText());
        this.criteria.getTags().clear();
        for (StringValue sv : this.tags) {
            this.criteria.getTags().add(sv.value);
        }
        Resource[] resources = null;
        this.setErrorMessage(null);
        this.setMessage(DEFAULT_MESSAGE);
        try {
            resources = this.helper.getResources(this.criteria);
        }
        catch (IllegalArgumentException e) {
            this.setErrorMessage(e.getMessage());
        }
        this.matchingResourceViewer.setInput((Object)resources);
        this.matchingResourceLabel.setText("Matching resources (" + (resources == null ? 0 : resources.length) + "):");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        Composite subComposite = new Composite(composite, 0);
        GridLayout subLayout = new GridLayout();
        subComposite.setLayout((Layout)subLayout);
        GridData subLayoutData = new GridData(1808);
        subLayoutData.minimumWidth = 550;
        subComposite.setLayoutData((Object)subLayoutData);
        this.createCriteriaComposite(subComposite);
        this.createMatchingComposite(composite);
        this.createDetailComposite(subComposite);
        ResourceReuseSelectionDialog.applyDialogFont((Control)composite);
        composite.pack();
        this.setMessage(DEFAULT_MESSAGE);
        this.setTitle("Load Model Reusue resource");
        return composite;
    }

    private void createDetailComposite(Composite composite) {
        Group grp = this.createGroup(composite, "Details");
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        grp.setLayout((Layout)layout);
        this.detailsLabel = new Label((Composite)grp, 0);
        this.detailsLabel.setLayoutData((Object)new GridData(1808));
        this.detailsLabel.setText("");
    }

    private void createMatchingComposite(Composite composite) {
        Composite grp = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        grp.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        grp.setLayoutData((Object)layoutData);
        this.matchingResourceLabel = new Label(grp, 0);
        this.matchingResourceLabel.setText("Matching resources:");
        this.matchingResourceLabel.setLayoutData((Object)new GridData(768));
        this.matchingResourceViewer = new TableViewer(grp);
        this.matchingResourceViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.matchingResourceViewer.setColumnProperties(new String[]{"name"});
        this.matchingResourceViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.matchingResourceViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Resource) {
                    return ((Resource)element).getName();
                }
                return super.getText(element);
            }
        });
        this.matchingResourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                String label = "";
                if (element instanceof Resource) {
                    Resource r = (Resource)element;
                    label = "\n id=" + r.getId() + "\n name=" + r.getName() + "\n version=" + r.getVersion() + "\n domain=" + r.getDomain() + "\n provider symbolic name=" + r.getProviderSymbolicName();
                    label = String.valueOf(label) + "\n provider location = " + r.getProviderLocation() + "\n path=" + r.getPath() + "\n metada path = ?" + "\n tags=" + Arrays.toString(r.getTags().toArray());
                }
                ResourceReuseSelectionDialog.this.detailsLabel.setText(label);
            }
        });
    }

    private void createCriteriaComposite(Composite parent) {
        Group composite = this.createGroup(parent, "Criteria");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite fields = new Composite((Composite)composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        fields.setLayout((Layout)layout);
        fields.setLayoutData((Object)new GridData(768));
        Label label = new Label(fields, 0);
        GridData layoutData = new GridData();
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
        label = new Label(fields, 0);
        label.setText(String.valueOf(Messages.id_Field_Label) + ':');
        label.setLayoutData((Object)new GridData());
        this.idText = new Text(fields, 2048);
        this.idText.setLayoutData((Object)new GridData(768));
        this.idText.setText(this.toString(this.criteria.getId()));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ResourceReuseSelectionDialog.this.updateMatchingResources();
            }
        };
        this.idText.addModifyListener(listener);
        label = new Label(fields, 0);
        label.setText(String.valueOf(Messages.name_Field_Label) + ':');
        label.setLayoutData((Object)new GridData());
        this.nameText = new Text(fields, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(this.toString(this.criteria.getName()));
        this.nameText.addModifyListener(listener);
        label = new Label(fields, 0);
        label.setText(String.valueOf(Messages.version_Field_Label) + ':');
        label.setLayoutData((Object)new GridData());
        this.versionText = new Text(fields, 2048);
        this.versionText.setLayoutData((Object)new GridData(768));
        this.versionText.setText(this.toString(this.criteria.getVersion()));
        this.versionText.addModifyListener(listener);
        label = new Label(fields, 0);
        label.setText(String.valueOf(Messages.domain_Field_Label) + ':');
        label.setLayoutData((Object)new GridData());
        this.domainText = new Text(fields, 2048);
        this.domainText.setLayoutData((Object)new GridData(768));
        this.domainText.setText(this.toString(this.criteria.getDomain()));
        this.domainText.addModifyListener(listener);
        this.tags.addAll(StringValue.toStringValueList(this.criteria.getTags()));
        this.createTableComposite((Composite)composite, this.tags, "newTag", String.valueOf(Messages.tags_Field_Label) + ':', Messages.tags_Field__AddButton_Label, Messages.tags_Field__DeleteButton_Label);
    }

    protected void createTableComposite(Composite parent, final List<StringValue> data, final String defaultValue, String tableLabel, String addLabel, String deleteLabel) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(tableLabel);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        final TableViewer viewer = new TableViewer(composite);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
        viewer.setColumnProperties(new String[]{"name"});
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)viewer.getTable())});
        viewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                StringValue tag = (StringValue)((TableItem)element).getData();
                tag.value = value.toString();
                viewer.refresh();
                ResourceReuseSelectionDialog.this.updateMatchingResources();
            }

            public Object getValue(Object element, String property) {
                StringValue tag = (StringValue)element;
                return tag.value;
            }

            public boolean canModify(Object element, String property) {
                return true;
            }
        });
        viewer.setInput(data);
        Composite btnComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        btnComposite.setLayout((Layout)layout);
        btnComposite.setLayoutData((Object)new GridData(1040));
        Button addButton = new Button(btnComposite, 8);
        addButton.setLayoutData((Object)new GridData());
        addButton.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        addButton.setToolTipText(addLabel);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                data.add(new StringValue(defaultValue));
                viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button deleteButton = new Button(btnComposite, 8);
        deleteButton.setLayoutData((Object)new GridData());
        deleteButton.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        deleteButton.setToolTipText(deleteLabel);
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    data.remove(obj);
                    ++n2;
                }
                viewer.refresh();
                deleteButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteButton.setEnabled(!event.getSelection().isEmpty());
                ResourceReuseSelectionDialog.this.updateMatchingResources();
            }
        });
    }

    private Group createGroup(Composite composite, String label) {
        Group group = new Group(composite, 0);
        group.setText(label);
        GridData layoutData = new GridData(1808);
        layoutData.minimumHeight = 90;
        group.setLayoutData((Object)layoutData);
        return group;
    }

    private String toString(String value) {
        return value == null ? "" : value;
    }

    public SearchCriteria getCriteria() {
        return this.criteria;
    }
}

