/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.Messages;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.feedback.Feedback;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.unknownreferences.scrutinizes.MissingEPackageResultWrapper;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IFeedback;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;

public class MissingEPackage
implements IScrutinize<MissingEPackageResultWrapper, Collection<IFeedback.IFeedbackMessage>> {
    private Set<EPackage> ePackages = new HashSet<EPackage>();
    private Set<XMLResource> xmlResources = new HashSet<XMLResource>();
    private Set<AnyType> anyTypes = new HashSet<AnyType>();

    public void findIn(EObject eObject) {
        if (eObject instanceof AnyType) {
            AnyType anyType = (AnyType)eObject;
            EPackage ePackage = anyType.eClass().getEPackage();
            this.anyTypes.add(anyType);
            if (ePackage.eResource() == null) {
                this.ePackages.add(ePackage);
            }
        }
    }

    public void findIn(Resource resource) {
        if (resource instanceof XMLResource) {
            XMLResource xmlResource = (XMLResource)resource;
            this.xmlResources.add(xmlResource);
            Map eObjectToExtensionMap = xmlResource.getEObjectToExtensionMap();
            for (AnyType anyType : eObjectToExtensionMap.values()) {
                this.findIn(anyType.getMixed());
                this.findIn(anyType.getAny());
                this.findIn(anyType.getAnyAttribute());
            }
        }
    }

    private void findIn(FeatureMap featureMap) {
        for (FeatureMap.Entry entry : featureMap) {
            Object value = entry.getValue();
            if (!(value instanceof AnyType)) continue;
            AnyType anyType = (AnyType)value;
            this.ePackages.add(anyType.eClass().getEPackage());
        }
    }

    public MissingEPackageResultWrapper getAnalysisResult() {
        return new MissingEPackageResultWrapper(this.ePackages, this.xmlResources, this.anyTypes);
    }

    public Collection<IFeedback.IFeedbackMessage> getFeedbackAnalysisMessages() {
        Feedback feedback = new Feedback();
        for (EPackage ePackage : this.getAnalysisResult().getePackages()) {
            String message = Messages.MISSING_ECORE_PACKAGE;
            message = String.valueOf(message) + "(" + ePackage.getNsURI() + ")";
            Feedback.FeedbackMessage feedbackMessage = new Feedback.FeedbackMessage(IFeedback.FeedbackLevel.ERROR, message);
            feedback.addFeedbackMessage(feedbackMessage);
        }
        return feedback.getFeedbackMessages();
    }
}

