/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.configurable.preferences.ui;

import java.util.Optional;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.polarsys.kitalpha.richtext.widget.configurable.editormodel.EditorGroup;
import org.polarsys.kitalpha.richtext.widget.configurable.editormodel.EditorItem;
import org.polarsys.kitalpha.richtext.widget.configurable.editormodel.EditorModel;
import org.polarsys.kitalpha.richtext.widget.configurable.editormodel.EditorModelNode;
import org.polarsys.kitalpha.richtext.widget.configurable.editormodel.EditorToolbar;

public class MDERichTextEditorConfigurationPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    IPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.polarsys.kitalpha.richtext.widget.configurable.preferences.core");

    public MDERichTextEditorConfigurationPage() {
        super(1);
        this.setPreferenceStore(this.preferenceStore);
    }

    public void createFieldEditors() {
        EditorItem globalEnablementItem = EditorModel.INSTANCE.getGlobalEnablementItem();
        BooleanFieldEditor globalConfigurableEnablementPreferenceField = new BooleanFieldEditor(globalEnablementItem.getId(), globalEnablementItem.getLabel(), this.getFieldEditorParent());
        globalEnablementItem.setPreferenceField(globalConfigurableEnablementPreferenceField);
        globalEnablementItem.setParent(this.getFieldEditorParent());
        this.addField((FieldEditor)globalConfigurableEnablementPreferenceField);
        for (EditorToolbar toolbar : EditorModel.INSTANCE.getToolbars()) {
            Composite toolbarGroup = new Composite(this.getFieldEditorParent(), 0);
            GridData toolbarGroupGridData = new GridData();
            toolbarGroupGridData.verticalIndent = 20;
            toolbarGroup.setLayoutData((Object)toolbarGroupGridData);
            BooleanFieldEditor toolbarPreferenceField = new BooleanFieldEditor(toolbar.getId(), toolbar.getLabel(), toolbarGroup);
            toolbar.setPreferenceField(toolbarPreferenceField);
            toolbar.setParent(toolbarGroup);
            this.addField((FieldEditor)toolbarPreferenceField);
            for (EditorGroup group : toolbar.getGroups()) {
                Composite groupGroup = new Composite(toolbarGroup, 0);
                GridData groupGroupGridData = new GridData();
                groupGroupGridData.horizontalIndent = 40;
                groupGroup.setLayoutData((Object)groupGroupGridData);
                BooleanFieldEditor groupPreferenceField = new BooleanFieldEditor(group.getId(), group.getLabel(), groupGroup);
                group.setPreferenceField(groupPreferenceField);
                group.setParent(groupGroup);
                this.addField((FieldEditor)groupPreferenceField);
                Composite itemsGroup = new Composite(groupGroup, 0);
                for (EditorItem item : group.getItems()) {
                    BooleanFieldEditor itemPreferenceField = new BooleanFieldEditor(item.getId(), item.getLabel(), itemsGroup);
                    item.setPreferenceField(itemPreferenceField);
                    item.setParent(itemsGroup);
                    GridData itemsGroupGridData = new GridData();
                    itemsGroupGridData.horizontalIndent = 40;
                    itemsGroup.setLayoutData((Object)itemsGroupGridData);
                    this.addField((FieldEditor)itemPreferenceField);
                }
            }
        }
    }

    protected void initialize() {
        super.initialize();
        EditorItem globalEnablementItem = EditorModel.INSTANCE.getGlobalEnablementItem();
        boolean isEnabled = globalEnablementItem.getPreferenceField().getBooleanValue();
        if (EditorModel.INSTANCE.isNodeToBeActivated((EditorModelNode)globalEnablementItem)) {
            for (EditorToolbar toolbar : EditorModel.INSTANCE.getToolbars()) {
                for (EditorGroup group : toolbar.getGroups()) {
                    group.getPreferenceField().setEnabled(isEnabled, group.getParent());
                    for (EditorItem item : group.getItems()) {
                        item.getPreferenceField().setEnabled(isEnabled, item.getParent());
                    }
                }
            }
        } else {
            for (EditorToolbar toolbar : EditorModel.INSTANCE.getToolbars()) {
                toolbar.getPreferenceField().setEnabled(false, toolbar.getParent());
                for (EditorGroup group : toolbar.getGroups()) {
                    group.getPreferenceField().setEnabled(false, group.getParent());
                    for (EditorItem item : group.getItems()) {
                        item.getPreferenceField().setEnabled(false, item.getParent());
                    }
                }
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        BooleanFieldEditor preferenceField = (BooleanFieldEditor)event.getSource();
        EditorModelNode editorModelNode = EditorModel.INSTANCE.getNode(preferenceField);
        boolean newValue = (Boolean)event.getNewValue();
        if (editorModelNode instanceof EditorToolbar) {
            EditorToolbar toolbar = (EditorToolbar)editorModelNode;
            boolean toolbarValue = newValue;
            this.preferenceStore.setValue(toolbar.getId(), toolbarValue);
            toolbar.getPreferenceField().load();
            for (EditorGroup group : toolbar.getGroups()) {
                this.preferenceStore.setValue(group.getId(), toolbarValue);
                group.getPreferenceField().load();
                boolean groupValue = group.getPreferenceField().getBooleanValue();
                for (EditorItem item : group.getItems()) {
                    boolean isEnabled = groupValue && toolbarValue;
                    this.preferenceStore.setValue(item.getId(), isEnabled);
                    item.getPreferenceField().load();
                }
            }
        } else if (editorModelNode instanceof EditorGroup) {
            EditorGroup group = (EditorGroup)editorModelNode;
            this.preferenceStore.setValue(group.getId(), newValue);
            group.getPreferenceField().load();
            for (EditorItem item : group.getItems()) {
                this.preferenceStore.setValue(item.getId(), newValue);
                item.getPreferenceField().load();
            }
            this.updateParentToolBar(group);
        } else if (editorModelNode instanceof EditorItem) {
            EditorItem changedItem = (EditorItem)editorModelNode;
            boolean isEnabled = (Boolean)event.getNewValue();
            if (changedItem.getId() == "org.polarsys.kitalpha.richtext.widgets.preferences.global_configurable_enablement") {
                for (EditorToolbar toolbar : EditorModel.INSTANCE.getToolbars()) {
                    this.preferenceStore.setValue(toolbar.getId(), isEnabled);
                    toolbar.getPreferenceField().load();
                    toolbar.getPreferenceField().setEnabled(isEnabled, toolbar.getParent());
                    for (EditorGroup group : toolbar.getGroups()) {
                        this.preferenceStore.setValue(group.getId(), isEnabled);
                        group.getPreferenceField().load();
                        group.getPreferenceField().setEnabled(isEnabled, group.getParent());
                        for (EditorItem item : group.getItems()) {
                            this.preferenceStore.setValue(item.getId(), isEnabled);
                            item.getPreferenceField().load();
                            item.getPreferenceField().setEnabled(isEnabled, item.getParent());
                        }
                    }
                }
            } else {
                EditorGroup parentGroup;
                Optional<Boolean> currentParentState;
                this.preferenceStore.setValue(changedItem.getId(), isEnabled);
                changedItem.getPreferenceField().load();
                EditorModelNode parentNode = EditorModel.INSTANCE.getNode(changedItem.getParentId());
                if (parentNode instanceof EditorGroup && (currentParentState = (parentGroup = (EditorGroup)parentNode).getItems().stream().map(EditorModelNode::getPreferenceField).map(BooleanFieldEditor::getBooleanValue).reduce((b1, b2) -> b1 != false || b2 != false)).isPresent()) {
                    this.preferenceStore.setValue(parentGroup.getId(), currentParentState.get().booleanValue());
                    parentGroup.getPreferenceField().load();
                    this.updateParentToolBar(parentGroup);
                }
            }
        }
    }

    private void updateParentToolBar(EditorGroup group) {
        EditorToolbar parentToolBar;
        Optional<Boolean> currentParentState;
        EditorModelNode parentNode = EditorModel.INSTANCE.getNode(group.getParentId());
        if (parentNode instanceof EditorToolbar && (currentParentState = (parentToolBar = (EditorToolbar)parentNode).getGroups().stream().map(EditorModelNode::getPreferenceField).map(BooleanFieldEditor::getBooleanValue).reduce((b1, b2) -> b1 != false || b2 != false)).isPresent()) {
            this.preferenceStore.setValue(parentToolBar.getId(), currentParentState.get().booleanValue());
            parentToolBar.getPreferenceField().load();
        }
    }

    public void dispose() {
        EditorItem globalEditorItem = EditorModel.INSTANCE.getGlobalEnablementItem();
        globalEditorItem.getPreferenceField().dispose();
        for (EditorToolbar toolbar : EditorModel.INSTANCE.getToolbars()) {
            for (EditorGroup group : toolbar.getGroups()) {
                for (EditorItem item : group.getItems()) {
                    item.getPreferenceField().dispose();
                }
                group.getPreferenceField().dispose();
            }
            toolbar.getPreferenceField().dispose();
        }
        super.dispose();
    }

    public void init(IWorkbench workbench) {
    }
}

