/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.visualize.table.layer.groupby;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByHeaderLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.groupBy.GroupByModel;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.polarsys.kitalpha.massactions.core.data.provider.ColumnHeaderDelegateDataProvider;
import org.polarsys.kitalpha.massactions.core.table.layer.column.IMAColumnHeaderLayer;
import org.polarsys.kitalpha.massactions.core.table.layer.grid.IMAGridLayer;
import org.polarsys.kitalpha.massactions.visualize.data.accessor.MVColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.visualize.table.layer.body.MVBodyLayer;
import org.polarsys.kitalpha.massactions.visualize.table.layer.groupby.IMVGroupByLayer;
import org.polarsys.kitalpha.massactions.visualize.unfold.MVPerspectiveManager;

public class MVGroupByLayer
extends CompositeLayer
implements IMVGroupByLayer {
    private static final Log log = LogFactory.getLog(MVGroupByLayer.class);
    private static final String AT_INDEX = "] at index [";
    protected IMAGridLayer gridLayerStack;
    protected GroupByHeaderLayer groupByHeaderLayer;
    protected MVBodyLayer bodyLayerStack;
    protected GroupByModel groupByModel;
    protected List<String> prevColumnNames;
    protected MVColumnPropertyAccessor columnPropertyAccessor;
    protected final FoldedEObjectChangedListener eObjectChangedListener = this.createFoldedEObjectChangedListener();
    protected final ILayerListener columnHideShowListener = this.createColumnHideShowListener();

    public MVGroupByLayer(IMAGridLayer gridLayerStack) {
        super(1, 2);
        this.gridLayerStack = gridLayerStack;
        this.initializeLayers();
        this.addLayerListener(this.columnHideShowListener);
    }

    protected void initializeLayers() {
        this.bodyLayerStack = (MVBodyLayer)this.gridLayerStack.getBodyLayer();
        this.bodyLayerStack.getData().forEach(this::installListener);
        this.columnPropertyAccessor = this.bodyLayerStack.getColumnPropertyAccessor();
        this.groupByModel = this.bodyLayerStack.getGroupByModel();
        this.prevColumnNames = this.columnPropertyAccessor.getColumnProperties();
        IMAColumnHeaderLayer columnHeaderLayerStack = this.gridLayerStack.getColumnHeaderLayer();
        ColumnHeaderDelegateDataProvider groupByDataProvider = new ColumnHeaderDelegateDataProvider(columnHeaderLayerStack);
        this.groupByHeaderLayer = new GroupByHeaderLayer(this.groupByModel, (ILayer)this.gridLayerStack, (IDataProvider)groupByDataProvider);
        this.setChildLayer("GROUP_BY_REGION", (ILayer)this.groupByHeaderLayer, 0, 0);
        this.setChildLayer("Grid", (ILayer)this.gridLayerStack, 0, 1);
    }

    public void dataChanged(Collection<EObject> data) {
        HashSet<EObject> newAddedData = new HashSet<EObject>(data);
        newAddedData.removeAll(this.bodyLayerStack.getData());
        newAddedData.forEach(this::installListener);
        this.gridLayerStack.dataChanged(data);
        this.updateGroupedByColumns();
        this.bodyLayerStack.notifyListeners();
        this.prevColumnNames = this.columnPropertyAccessor.getColumnProperties();
    }

    protected void updateGroupedByColumns() {
        List prevGroupedColumns = this.groupByModel.getGroupByColumnIndexes();
        boolean changeMade = false;
        int i = 0;
        while (i < prevGroupedColumns.size()) {
            int prevColumnIndex = (Integer)prevGroupedColumns.get(i);
            String prevColumnName = this.prevColumnNames.get(prevColumnIndex);
            int currColumnIndex = this.columnPropertyAccessor.getColumnIndex(prevColumnName);
            if (currColumnIndex != prevColumnIndex) {
                changeMade = true;
                if (currColumnIndex != -1) {
                    prevGroupedColumns.set(i, currColumnIndex);
                    log.info((Object)("Adding grouped column [" + prevColumnName + AT_INDEX + prevColumnIndex + "]"));
                } else {
                    prevGroupedColumns.remove((Object)prevColumnIndex);
                    --i;
                    log.info((Object)("Removing grouped column [" + prevColumnName + AT_INDEX + prevColumnIndex + "]"));
                }
            }
            ++i;
        }
        if (changeMade) {
            this.groupByModel.update();
        }
    }

    protected Adapter installListener(EObject element) {
        EList adapters = element.eAdapters();
        if (!adapters.contains((Object)this.eObjectChangedListener)) {
            adapters.add(this.eObjectChangedListener);
        }
        return this.eObjectChangedListener;
    }

    protected void uninstallListener(EObject element, Adapter listener) {
        element.eAdapters().remove((Object)listener);
    }

    @Override
    public IMAGridLayer getGridLayer() {
        return this.gridLayerStack;
    }

    @Override
    public GroupByHeaderLayer getGroupByHeaderLayer() {
        return this.groupByHeaderLayer;
    }

    public void dispose() {
        this.bodyLayerStack.getData().forEach(element -> this.uninstallListener((EObject)element, (Adapter)this.eObjectChangedListener));
        super.dispose();
    }

    private ILayerListener createColumnHideShowListener() {
        return new ColumnHideShowListener();
    }

    protected FoldedEObjectChangedListener createFoldedEObjectChangedListener() {
        return new FoldedEObjectChangedListener();
    }

    public class ColumnHideShowListener
    implements ILayerListener {
        public void handleLayerEvent(ILayerEvent event) {
            MVPerspectiveManager perspectiveManager = MVGroupByLayer.this.columnPropertyAccessor.getPerspectiveManager();
            if (!perspectiveManager.isFolded() && (event instanceof HideColumnPositionsEvent || event instanceof ShowColumnPositionsEvent)) {
                List columnList = MVGroupByLayer.this.columnPropertyAccessor.getColumnList();
                perspectiveManager.unfold(columnList);
                MVGroupByLayer.this.updateGroupedByColumns();
                MVGroupByLayer.this.prevColumnNames = MVGroupByLayer.this.columnPropertyAccessor.getColumnProperties();
                MVGroupByLayer.this.bodyLayerStack.notifyListeners();
            }
        }
    }

    public class FoldedEObjectChangedListener
    extends AdapterImpl {
        private void objectChangedAction(Object notifier) {
            MVPerspectiveManager perspectiveManager = MVGroupByLayer.this.columnPropertyAccessor.getPerspectiveManager();
            if (perspectiveManager.isFolded()) {
                perspectiveManager.addDirtyElement((EObject)notifier);
            } else {
                perspectiveManager.elementChanged((EObject)notifier);
                MVGroupByLayer.this.updateGroupedByColumns();
                MVGroupByLayer.this.prevColumnNames = MVGroupByLayer.this.columnPropertyAccessor.getColumnProperties();
                MVGroupByLayer.this.bodyLayerStack.notifyListeners();
            }
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.objectChangedAction(notification.getNotifier());
                    break;
                }
            }
        }
    }
}

