/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.handlers.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Property;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.PropertySet;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ViewpointFactory;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.tools.model.ViewpointElement;
import org.polarsys.kitalpha.ad.viewpoint.handlers.IConfigurationHandler;
import org.polarsys.kitalpha.ad.viewpoint.handlers.runtime.ViewpointManager;

public class ViewpointConfigurationHandler
extends ViewpointManager.ElementHandler
implements IConfigurationHandler {
    public ViewpointConfigurationHandler(Viewpoint viewpoint, ViewpointManager mgr) {
        super(viewpoint, mgr);
    }

    @Override
    public List<ViewpointElement> getElements() {
        ArrayList<ViewpointElement> services = new ArrayList<ViewpointElement>();
        services.addAll((Collection<ViewpointElement>)this.getViewpoint().getProperties());
        return services;
    }

    @Override
    public void createProperty(String name) {
        PropertySet set = this.getCurrentPropertySet();
        Property prop = ViewpointFactory.eINSTANCE.createProperty();
        prop.setName(name);
        prop.setVpid(EcoreUtil.generateUUID());
        set.getNewProperties().add((Object)prop);
        prop.setName(name);
        this.saveModel();
    }

    private PropertySet getCurrentPropertySet() {
        if (this.getViewpoint().getPropertySet() == null) {
            PropertySet propSet = ViewpointFactory.eINSTANCE.createPropertySet();
            propSet.setTarget(this.getViewpoint());
            propSet.setVpid(EcoreUtil.generateUUID());
            this.getViewpoint().setPropertySet(propSet);
        }
        return this.getViewpoint().getPropertySet();
    }

    @Override
    public void removeProperties(List<Property> properties) {
        for (Property prop : properties) {
            if (!this.isRemovable((ViewpointElement)prop)) continue;
            PropertySet set = (PropertySet)prop.eContainer();
            set.getNewProperties().remove((Object)prop);
        }
        this.saveModel();
    }

    @Override
    public List<ViewpointElement> getElementsFromParents() {
        HashMap<String, ViewpointElement> name2prop = new HashMap<String, ViewpointElement>();
        for (Viewpoint vp : this.getViewpoint().getAllParents()) {
            for (ViewpointElement elt : vp.getProperties()) {
                name2prop.put(this.getIdentifier(elt), elt);
            }
        }
        return new ArrayList<ViewpointElement>(name2prop.values());
    }

    @Override
    protected String getIdentifier(ViewpointElement elt) {
        return elt.getName();
    }
}

