/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;
import org.polarsys.kitalpha.emde.Activator;
import org.polarsys.kitalpha.emde.extension.DefaultModelExtensionManager;
import org.polarsys.kitalpha.emde.extension.ExtendedModel;
import org.polarsys.kitalpha.emde.extension.ExtensibleModel;
import org.polarsys.kitalpha.emde.extension.utils.Log;

public class PreferenceModelExtensionManager
extends DefaultModelExtensionManager {
    private static final String MODEL_DISABLED_PREFERENCE = "model.disabled_";

    @Override
    public void setExtensionModelDisabled(ExtensibleModel extensibleModel, ExtendedModel extendedModel, boolean disabled) {
        if (this.isExtensionModelDisabled(extendedModel) != disabled) {
            IEclipsePreferences prefs = PreferenceModelExtensionManager.getPreferencesRoot();
            prefs.putBoolean(this.computeKey(extendedModel), disabled);
            PreferenceModelExtensionManager.flushPreferences(prefs);
            this.fireExtensionEvent(extendedModel.getName(), !disabled);
        }
    }

    @Override
    public boolean isExtensionModelDisabled(ExtendedModel extendedModel) {
        return PreferenceModelExtensionManager.getPreferencesRoot().getBoolean(this.computeKey(extendedModel), false);
    }

    protected String computeKey(ExtendedModel extendedModel) {
        return MODEL_DISABLED_PREFERENCE + extendedModel.getQualifiedName();
    }

    static IEclipsePreferences getPreferencesRoot() {
        IEclipsePreferences root = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("instance");
        return (IEclipsePreferences)root.node(Activator.getContext().getBundle().getSymbolicName());
    }

    static void flushPreferences(IEclipsePreferences prefs) {
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Log.getDefault().logError((Throwable)e);
        }
    }
}

