/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph;

import java.util.Stack;
import java.util.Vector;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationGraph;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationGraphCycle;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.graph.GenerationNode;
import org.polarsys.kitalpha.ad.af.dsl.generation.desc.internal.fifo.GenerationFifoList;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;

public class GenerationStack {
    private Stack<GenerationNode> _stack = new Stack();
    private Stack<Viewpoint> _vpStack = new Stack();

    public void compute(GenerationGraph graph) {
        GenerationGraphCycle cycleDetect = new GenerationGraphCycle(graph);
        cycleDetect.analyse();
        if (cycleDetect.exist()) {
            return;
        }
        this._stack.clear();
        this._vpStack.clear();
        GenerationGraph c_graph = graph.clone();
        this.computeStack(c_graph);
        this.reorderStack();
    }

    public void reorderStack() {
        GenerationFifoList fifoList = new GenerationFifoList();
        GenerationNode node = this._stack.pop();
        while (node != null) {
            fifoList.enfiler(node);
            GenerationNode generationNode = node = this._stack.isEmpty() ? null : this._stack.pop();
        }
        while (!fifoList.isEmpty()) {
            GenerationNode node2 = fifoList.defiler();
            this._stack.push(node2);
            this._vpStack.push(node2.getViewpoint());
        }
    }

    public void print() {
        Stack sClone = (Stack)this._stack.clone();
        System.out.println("Generation Stack - Begin");
        while (!sClone.isEmpty()) {
            String name = ((GenerationNode)sClone.pop()).getName();
            System.out.println(" " + name);
        }
        System.out.println("Generation Stack - End");
    }

    public Stack<GenerationNode> getGenerationNodeStack() {
        return (Stack)this._stack.clone();
    }

    public Stack<Viewpoint> getViewpointStack() {
        return (Stack)this._vpStack.clone();
    }

    public GenerationNode getNextNode() {
        return !this._stack.isEmpty() ? this._stack.pop() : null;
    }

    private void computeStack(GenerationGraph graph) {
        if (!graph.isEmpty()) {
            Vector<GenerationNode> leafs = graph.getLeafs();
            for (GenerationNode node : leafs) {
                if (this._stack.contains(node)) continue;
                this._stack.push(node);
            }
            for (GenerationNode node : leafs) {
                graph.remove(node);
            }
            this.computeStack(graph);
        }
    }
}

