/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.polarsys.kitalpha.ad.integration.sirius.model.SiriusRepresentation;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.RepresentationElement;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.desc.CoreDomainViewpointHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.helper.URIConverterHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.ui.contentassist.DiagramUseLinks;

public class UseLinksContentassistHelper {
    public static final String MODEL_KEY = "model";
    public static final String DIAGRAM_KEY = "diagram";
    private static final DiagramUseLinks imports = new DiagramUseLinks();

    public static DiagramUseLinks getViewpointRepresentation(EObject model) {
        imports.clear();
        String projectName = ResourceHelper.getProjectName((EObject)model);
        org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint vp = UseLinksContentassistHelper.getRootViewpoint(model, projectName);
        UseLinksContentassistHelper.initImportsWithUsedViewpoints(vp);
        UseLinksContentassistHelper.initImportsWithModelsAndDiagrams(vp);
        UseLinksContentassistHelper.initImportWithWorkspaceAndFSResources(vp);
        return imports;
    }

    private static void initImportWithWorkspaceAndFSResources(org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint vp) {
        EList wsResources = vp.getUseWorkspaceResource();
        EList fsResources = vp.getUseFSResource();
        for (String uri : wsResources) {
            UseLinksContentassistHelper.addImport(uri);
        }
        for (String uri : fsResources) {
            UseLinksContentassistHelper.addImport(uri);
        }
    }

    private static void addImport(String uri) {
        URI tmp = URI.createURI((String)uri);
        if (tmp.isFile() || tmp.isHierarchical() || tmp.isPlatform() || tmp.isRelative()) {
            if (tmp.lastSegment().endsWith(".ecore")) {
                imports.put(MODEL_KEY, uri);
            }
            if (tmp.lastSegment().endsWith("odesign")) {
                imports.put(DIAGRAM_KEY, uri);
            }
        }
    }

    private static void initImportsWithModelsAndDiagrams(org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint vp) {
        EList usedModels = vp.getUseAnyEMFResource();
        EList usedDiagrams = vp.getUseDiagramResource();
        for (String uri : usedModels) {
            imports.put(MODEL_KEY, uri);
        }
        for (String uri : usedDiagrams) {
            imports.put(DIAGRAM_KEY, uri);
        }
    }

    private static void initImportsWithUsedViewpoints(org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint vp) {
        EList viewpoints = vp.getUseViewpoint();
        for (org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint viewpoint : viewpoints) {
            String vpProjectName = ResourceHelper.getProjectName((EObject)viewpoint);
            String resource_id = vpProjectName.substring(0, vpProjectName.lastIndexOf("."));
            Viewpoint coreDomainViewpoint = CoreDomainViewpointHelper.getCoreDomainViewpoint((String)resource_id, null);
            if (coreDomainViewpoint == null) {
                throw new RuntimeException("Could not find the viewpoint resource for the project: " + vpProjectName);
            }
            EList packages = coreDomainViewpoint.getMetamodel().getModels();
            EList representations = coreDomainViewpoint.getRepresentation().getRepresentations();
            UseLinksContentassistHelper.fillURI((EList<EPackage>)packages, (EList<RepresentationElement>)representations);
        }
    }

    private static void fillURI(EList<EPackage> packages, EList<RepresentationElement> representations) {
        for (EPackage ePackage : packages) {
            String nsuri = ePackage.getNsURI();
            URI uri = URI.createURI((String)nsuri);
            URI p_uri = URIConverterHelper.getPlatformURI((URI)uri);
            if (p_uri != null && !p_uri.isEmpty()) {
                imports.put(MODEL_KEY, p_uri.toString());
                continue;
            }
            Resource ePackageResource = ePackage.eResource();
            if (ePackageResource != null) {
                URI resource_uri = ePackageResource.getURI();
                if (resource_uri == null || resource_uri.isEmpty()) continue;
                imports.put(MODEL_KEY, resource_uri.toString());
                continue;
            }
            imports.put(MODEL_KEY, nsuri);
        }
        for (RepresentationElement representationElement : representations) {
            if (!(representationElement instanceof SiriusRepresentation)) continue;
            Group group = ((SiriusRepresentation)representationElement).getOdesign();
            if (group.eResource().getURI().isPlatformResource()) {
                String ptf_uri = ResourceHelper.URIFix.createPlatformResourceURI((String)group.eResource().getURI().toPlatformString(true), (boolean)true).toString();
                imports.put(DIAGRAM_KEY, ptf_uri);
            }
            if (!group.eResource().getURI().isPlatformPlugin()) continue;
            String plg_uri = ResourceHelper.URIFix.createPlatformPluginURI((String)group.eResource().getURI().toPlatformString(true), (boolean)true).toString();
            imports.put(DIAGRAM_KEY, plg_uri);
        }
    }

    private static org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint getRootViewpoint(EObject model, String projectName) {
        ResourceSetImpl fakeResourceSet = new ResourceSetImpl();
        org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint viewpoint = null;
        ResourceHelper.loadPrimaryResource((String)projectName, (ResourceSet)fakeResourceSet);
        URI uri = ResourceHelper.getPrimaryResourceURI((String)projectName);
        XtextResource resource = (XtextResource)fakeResourceSet.getResource(uri, false);
        String text = null;
        IEditorReference vpspecEditor = UseLinksContentassistHelper.getOpenedEditor(uri);
        try {
            if (vpspecEditor != null) {
                XtextEditor editor = (XtextEditor)vpspecEditor.getEditor(false);
                text = editor.getDirtyStateEditorSupport().getDirtyStateManager().getActualContentProvider().getContent(uri);
                if (text != null && !text.isEmpty() && resource != null) {
                    resource.reparse(text);
                } else if (resource != null) {
                    resource.load(Collections.emptyMap());
                }
            } else if (resource != null) {
                resource.load(Collections.emptyMap());
            }
            viewpoint = UseLinksContentassistHelper.getCurrentViewpoint((Resource)resource);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return viewpoint;
    }

    private static IEditorReference getOpenedEditor(URI uri) {
        IEditorReference[] editors;
        IEditorReference[] iEditorReferenceArray = editors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray[n2];
            String id = iEditorReference.getId();
            if (id.equals("org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.Vpspec")) {
                try {
                    String segment;
                    String project;
                    IFile file = (IFile)iEditorReference.getEditorInput().getAdapter(IFile.class);
                    if (file != null && (project = file.getProject().getName().toString()).equalsIgnoreCase(segment = uri.segment(1))) {
                        return iEditorReference;
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }

    private static org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint getCurrentViewpoint(Resource resource) {
        if (resource == null) {
            return null;
        }
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject v = (EObject)it.next();
            if (!(v instanceof org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint)) continue;
            return (org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.vpspec.Viewpoint)v;
        }
        return null;
    }
}

