/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.java;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.model.pattern.PatternExecutionReporter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.constant.Messages;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.java.JDTUtility;

public class JavaClassReporter
implements PatternExecutionReporter {
    public static final Integer dontSave = 0;
    public static final Integer whenExecutionFinished = 1;
    public static final Integer whenLoopFinished = 2;
    protected String collectedOutput = "";

    public final void executionFinished(String output, PatternContext context) {
        Integer _saveTime = (Integer)context.getValue("savetime");
        if (_saveTime == null || !whenExecutionFinished.equals(_saveTime)) {
            return;
        }
        String _projectName = (String)context.getValue("projectname");
        String _packageName = (String)context.getValue("packagename");
        String _className = (String)context.getValue("classname");
        if (_projectName == null || _projectName.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Project);
        }
        if (_packageName == null || _packageName.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Package);
        }
        if (_className == null || _className.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Class);
        }
        if (this.collectedOutput != null && this.collectedOutput.trim().length() != 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(_projectName);
            IFolder folder = JDTUtility.createOrGetPackageFolders(project, _packageName);
            IFile file = folder.getFile(String.valueOf(_className) + ".java");
            JDTUtility.writeJavaContent(file, output);
        }
    }

    public void loopFinished(String output, String outputWithCallBack, PatternContext context, Map<String, Object> parameterValues) {
        Integer _saveTime = (Integer)context.getValue("savetime");
        if (_saveTime == null || !whenLoopFinished.equals(_saveTime)) {
            this.collectedOutput = String.valueOf(this.collectedOutput) + output;
            return;
        }
        String _projectName = (String)context.getValue("projectname");
        String _packageName = (String)context.getValue("packagename");
        String _className = (String)context.getValue("classname");
        if (_projectName == null || _projectName.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Project);
        }
        if (_packageName == null || _packageName.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Package);
        }
        if (_className == null || _className.trim().length() == 0) {
            throw new IllegalArgumentException(Messages.JavaReporter_Parameters_NameNotNull_Class);
        }
        if (whenLoopFinished.equals(_saveTime)) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(_projectName);
            IFolder folder = JDTUtility.createOrGetPackageFolders(project, _packageName);
            IFile file = folder.getFile(String.valueOf(_className) + ".java");
            String mergedcode = output;
            if (file.exists()) {
                mergedcode = JDTUtility.mergeJavaCode(file, output);
            }
            String codeWithCleanImportSction = JDTUtility.organizeImport(file, mergedcode);
            JDTUtility.writeJavaContent(file, codeWithCleanImportSction);
        }
    }
}

