/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.extension.ExtensionManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.ExpressionInterpreter;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.ExpressionKind;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.expression.helper.sirius.OCLExpressionNotSupported;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl.ViewpointResourceProviderRegistry;

public class SiriusExpressionHelper {
    public static ExpressionKind getCurrentExpressionKind() {
        Viewpoint viewpoint = ViewpointResourceProviderRegistry.getInstance().getViewpoint();
        return ExtensionManager.getDiagramExpressionLanguageFilters((EObject)viewpoint);
    }

    public static String getEdgeSemanticTarget(boolean source) {
        ExpressionKind currentExpressionKind = SiriusExpressionHelper.getCurrentExpressionKind();
        if (source) {
            switch (currentExpressionKind) {
                case QueryLegacy: 
                case AQL: {
                    return "sourceNode.target";
                }
                case Acceleo_3_x: {
                    return "sourceNode.oclAsType(viewpoint::DSemanticDecorator).target";
                }
                case Ocl: {
                    throw new OCLExpressionNotSupported();
                }
            }
        } else {
            switch (currentExpressionKind) {
                case QueryLegacy: 
                case AQL: {
                    return "targetNode.target";
                }
                case Acceleo_3_x: {
                    return "targetNode.oclAsType(viewpoint::DSemanticDecorator).target";
                }
                case Ocl: {
                    throw new OCLExpressionNotSupported();
                }
            }
        }
        return "";
    }

    public static String getExpressoin(String expression) {
        ExpressionKind kind = SiriusExpressionHelper.getCurrentExpressionKind();
        return kind.format(expression);
    }

    public static String getExpressoin(String expression, ExpressionInterpreter interpreter) {
        return interpreter.format(expression);
    }

    public static String getConcatenationCharacter() {
        ExpressionKind currentExpressionKind = SiriusExpressionHelper.getCurrentExpressionKind();
        return currentExpressionKind.getConcatenationCharacter();
    }

    public static String getInnerFeature(String featureName) {
        switch (SiriusExpressionHelper.getCurrentExpressionKind()) {
            case QueryLegacy: {
                return "<%" + featureName + "%>";
            }
            case AQL: {
                return "self." + featureName;
            }
            case Acceleo_3_x: {
                return featureName;
            }
            case Ocl: {
                throw new OCLExpressionNotSupported();
            }
        }
        throw new RuntimeException();
    }

    public static String getInnerJavaService(String serviceName) {
        switch (SiriusExpressionHelper.getCurrentExpressionKind()) {
            case QueryLegacy: {
                return "<%" + serviceName + "%>";
            }
            case AQL: {
                return "self." + serviceName;
            }
            case Acceleo_3_x: {
                return serviceName;
            }
            case Ocl: {
                throw new OCLExpressionNotSupported();
            }
        }
        throw new RuntimeException();
    }

    public static String getInnerVariable(String variableName) {
        switch (SiriusExpressionHelper.getCurrentExpressionKind()) {
            case QueryLegacy: {
                return SiriusExpressionHelper.variableHasPrefix(variableName) ? variableName : "$" + variableName;
            }
            case Acceleo_3_x: 
            case AQL: {
                return SiriusExpressionHelper.getVariableWithoutPrefix(variableName);
            }
            case Ocl: {
                throw new OCLExpressionNotSupported();
            }
        }
        throw new RuntimeException();
    }

    public static String formatString(String string) {
        String trimedString = string.trim();
        if (ExpressionInterpreter.isInterpreterExpression(trimedString)) {
            return string;
        }
        ExpressionKind expressionKind = SiriusExpressionHelper.getCurrentExpressionKind();
        switch (expressionKind) {
            case QueryLegacy: {
                return string;
            }
            case AQL: {
                if (ExpressionKind.AQL.isFormated(trimedString)) {
                    return trimedString.substring(4);
                }
                return SiriusExpressionHelper.stringHasDelimiters(string, '\'') ? string : String.valueOf('\'') + string + '\'';
            }
            case Acceleo_3_x: {
                return SiriusExpressionHelper.stringHasDelimiters(string, '\'') ? string : String.valueOf('\'') + string + '\'';
            }
            case Ocl: {
                throw new OCLExpressionNotSupported();
            }
        }
        throw new RuntimeException("Interpreter " + expressionKind.toString() + " not known");
    }

    private static boolean stringHasDelimiters(String string, char delimiter) {
        return string.charAt(0) == delimiter && string.charAt(string.length() - 1) == delimiter;
    }

    private static String getVariableWithoutPrefix(String variableName) {
        if (SiriusExpressionHelper.variableHasPrefix(variableName)) {
            return variableName.substring(1, variableName.length());
        }
        return variableName;
    }

    private static boolean variableHasPrefix(String variableName) {
        return variableName != null && variableName.length() > 0 ? variableName.startsWith("$") : false;
    }
}

